/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIC_CONSTANTS_H_
#define _PIC_CONSTANTS_H_

// PIC constants

// there will be an upper and lower margin block for every pic
// Note: the 1st lrmargin (upper in the pic pipe) will clip to the
// needs of the CIS - getting rid of the dead pixels.  The 2nd lrmargin
// (lower in the pic pipe) is after PRNU/DSNU, and the other subblocks,
// and is used for clipping to the size of the actual page.  This makes
// PRNU/DSNU and chipgap easier since they don't have to change with the
// user requested margins
#define MAX_NUM_LRMARGIN_BLOCKS 2

#define MAX_FLARE_DMAS 3

#define MAX_NUM_PICBLOCKS 2
// max number of output dmas per picblock
#define MAX_OUTPUT_DMAS 3

/// constants for PRNU/DSNU
//     for pic_pd_set_config1
#define PD_LUT_12bits 0
#define PD_LUT_16bits 1
#define PD_LUT_20bits 2
#define PD_LUT_24bits 3
#define PD_LUT_28bits 4
#define PD_LUT_32bits 5


//     for pic_pd_set_config2
#define PD_COEFF_12bits 0
#define PD_COEFF_16bits 1
#define PD_COEFF_20bits 2
#define PD_COEFF_24bits 3
#define PD_COEFF_28bits 4
#define PD_COEFF_32bits 5


// PRNU/DSNU values
//   for pic_pd_set_config1
#define PD_50_50 0
#define PD_PRNU_PLUS_1 1
#define PD_PRNU_PLUS_2 2
#define PD_PRNU_PLUS_3 5
#define PD_DSNU_PLUS_1 3
#define PD_DSNU_PLUS_2 4
#define PD_DSNU_PLUS_3 6


// pic_wdma DWOCR modes
#define WDMA_PROCESS_DATA 2
#define WDMA_DISCARD_DATA 1
#define WDMA_DISALLOW_DATA 0

// ASIC revision
#define ASICREVA 0
#define ASICREVB 1
#endif

