/*
 ***************************************************************************************
 * (c) Copyright 2014-2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#include <linux/uaccess.h>

#include "PIC_regheaders.h"
#include "pic_constants.h"
#include "pic_full_subblock_list.h"
#include "pic_handle.h"
#include "pic_if.h"
#include "pic_driverlib_if.h"

unsigned long pic_handle_copy_from_user(struct pic_handle_t *to, const void __user *from)
{
    uint32_t handle_size;
    long rc;
    rc = get_user(handle_size, (uint32_t *) from);
    if (rc < 0)
        return rc;
    rc = copy_from_user(to, from, handle_size);
    if (rc < 0)
        return rc;
    pic_fixup_shadow_pointers(to);
    return rc;
}
EXPORT_SYMBOL(pic_handle_copy_from_user);
