/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#include <linux/module.h>
#include <linux/of_device.h>
#include <linux/genalloc.h>

// local static variable to keep the memory pool structure and node structure around
static struct gen_pool *pool;
static struct device_node *node1;

void dump_sram_info(void)
{
    printk("SRAM info:\n");
    printk("Total size of the sram pool is 0x%d\n", gen_pool_size(pool));
    printk("Current available memory in the sram pool is 0x%d\n", gen_pool_avail(pool));
}
EXPORT_SYMBOL(dump_sram_info);

// returns virtual address of the allocated pointer to memory
void *sram_allocate(unsigned int size, void *phys_addr)
{
    void *virt_addr;
    
    virt_addr = gen_pool_dma_alloc(pool, size, phys_addr);
    if (!virt_addr)
    {
        printk("unable to allocate %d SRAM bytes\n", size);
    }

    return virt_addr;
}
EXPORT_SYMBOL(sram_allocate);

// frees the memory previously allocated with sram_allocate
void sram_free(void *buffer, int size)
{
    if (buffer)
    {
        gen_pool_free(pool, (unsigned long) buffer, size);
    }
}
EXPORT_SYMBOL(sram_free);

static int sram_pool_init(void)
{
    printk("%s\n",__func__);
    node1 = of_find_compatible_node(NULL, NULL, "marvell,mckinley5");
    if (node1 == NULL)
    {
        printk("ERROR: %s mckinley5 node not found - returned NULL\n", __func__);
        return -1;
    }
    
    pool = of_get_named_gen_pool(node1, "sram", 0);
    if (pool == NULL)
    {
        printk("ERROR: %s could not get named pool, sram - returned NULL\n", __func__);
        return -1;
    }
    
    dump_sram_info();
    
    return 0;
}

module_init(sram_pool_init);

static void sram_pool_exit(void)
{
    of_node_put(node1);
}

module_exit(sram_pool_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Marvell");
MODULE_DESCRIPTION("simple driver to allow alloc/dealloc from SRAM\n");
MODULE_VERSION("2015_May_21");
