/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _ICETEST_IF_H_
#define _ICETEST_IF_H_

struct icetest_testconfig_info
{
    uint8_t pic_rate;
    uint8_t disable_pacing;
    uint8_t blank_en;
    uint8_t softreset_active;
    uint8_t icetest_enable;
    uint8_t icetest_mode_select;

    bool pic_rate_valid;
    bool disable_pacing_valid;
    bool blank_en_valid;
    bool softreset_active_valid;
    bool icetest_enable_valid;
    bool icetest_mode_select_valid;
};

struct icetest_interrupt_info
{
    bool overflow_int;
    bool dma_int;
    bool underflow_int;
    // for debug use only
    uint32_t debug_intarray;
};

struct icetest_idma_config_info
{
    uint8_t replicate;
    uint8_t enable;
    uint8_t out_width;
    uint8_t handshake_enable;
    uint8_t own_write_disable;
    uint8_t own_polarity;
    uint8_t burst_len;
    // for debug use only
    uint32_t debug_array;

    bool replicate_valid;
    bool enable_valid;
    bool out_width_valid;
    bool handshake_enable_valid;
    bool own_write_disable_valid;
    bool own_polarity_valid;
    bool burst_len_valid;
};

struct icetest_idma_status_info
{
    uint8_t dma_paused;
    uint8_t pause_after;
    uint8_t pause_before;
    uint8_t soi;
    uint8_t eoi;
    uint8_t soft_reset;
    uint8_t full_cbuf;
    uint8_t empty_cbuf;
    uint8_t full_dbuf;
    uint8_t empty_dbuf;
    uint8_t packer_empty;
    uint8_t dma_busy;
    // for debug use only
    uint32_t debug_array;
};

struct icetest_idma_interrupt_info
{
    bool rresp_int;
    bool bresp_int;
    bool rst_int;
    bool eoi_int;
    bool fin_int;
    bool who_int;
    // for debug use only
    uint32_t debug_intarray;

};

// exported functions from icetest.c for anyone to call
void icetest_register_callback(void *callbackfcn);
void icetest_clear_irq(struct icetest_interrupt_info *irqstruct);
void icetest_enable_irq(struct icetest_interrupt_info *irqstruct);
void icetest_disable_irq(struct icetest_interrupt_info *irqstruct);
void icetest_set_irq(struct icetest_interrupt_info *irqstruct);
void icetest_set_config(struct icetest_testconfig_info *info);
void icetest_get_config(struct icetest_testconfig_info *info);
void icetest_handle_idma_irqs(void);
void icetest_dump_regs(void);
void icetest_soft_reset(int resetval);
uint32_t icetest_get_rev0(void);
uint32_t icetest_get_rev1(void);
void icetest_register_callback_idma(void *callbackfcn);
void icetest_idma_soft_reset(int resetval);
void icetest_dump_idma_regs(void);
void icetest_set_idma_config(struct icetest_idma_config_info *config);
void icetest_set_idma_burstlen(int burstlen);
void icetest_set_idma_dma_width(int dma_width);
void icetest_set_idma_enable(int enable);
void icetest_set_idma_replicate(int replicate);
void icetest_get_idma_config(struct icetest_idma_config_info *config);
void icetest_get_idma_status(struct icetest_idma_status_info *status);
void icetest_set_idma_linewidth(int linewidth);
void icetest_get_idma_linewidth(int *linewidth);
void icetest_clear_idma_irqs(struct icetest_idma_interrupt_info *int_info);
void icetest_start_idma(dma_addr_t descriptor_phys_addr);
void icetest_enable_idma_irqs(struct icetest_idma_interrupt_info *int_info);
void icetest_disable_idma_irqs(struct icetest_idma_interrupt_info *int_info);


// ICETEST constants
#define IGNORE_PIC_READY 0  // for the disable pacing register, ignore, or
#define USE_PIC_READY 1   // tell icetest to pay attention to pic ready
#define ICETEST_ENABLE 1
#define ICETEST_SEL_SCAN 0x00
#define ICETEST_SEL_CISX0 0x01
#define ICETEST_SEL_CISX1 0x02
#define ICETEST_SEL_CISX ICETEST_SEL_CISX0

// Basalt and Granite 2 have the following bit order for ICE_test data
// cbimif_ice_test.Data[15:0]  = `ICE_TOP.PICDataOut; // the pixel data
// cbimif_ice_test.Data[17:16] = `ICE_TOP.PICTypeOut;
// cbimif_ice_test.Data[20:18] = `ICE_TOP.PICColorOut; //
// cbimif_ice_test.Data[21]    = `ICE_TOP.PICExposureOut; // unknown
// cbimif_ice_test.Data[22]    = `ICE_TOP.PICLineCRCErrorOut; // if set, CRC error
// cbimif_ice_test.Data[23]    = `ICE_TOP.PICTagOut;   // the sensor the data belongs to, 0 or 1
// cbimif_ice_test.Data[31:24]    = 0;

#define PIC_INDATA_DATA(x)     (((x) & 0xffff) << 0)
#define PIC_INDATA_DATATYPE(x) (((x) & 0x3) << 16)
#define PIC_INDATA_COLOR(x)    (((x) & 0x7) << 18)
#define PIC_INDATA_EXP         (0x1 << 21)
#define PIC_INDATA_LINECRC(x)  (((x) & 1) << 22)
#define PIC_INDATA_TAGOUT(x)   (((x) & 1) << 23)

#define PIC_INDATA_TAGOUT_MASK   (1 << 23)
#define PIC_INDATA_TAGOUT_SHIFT  (23)

 /* PIC Data type (2 bits) */
#define PIC_CBI_NORMP      0   // normal data pixel 
#define PIC_CBI_SOL        1   // first data pixel in line, sometimes called FIRP 
#define PIC_CBI_EOL        2   // last data pixel in line, sometimes called LASTP 
#define PIC_CBI_EOI        3   // last pixel in the image (EOI) 

/* Color (3 bits) */
#define PIC_CBI_CEVEN_0    0   /* Color 0 (even or non-staggered) */
#define PIC_CBI_CEVEN_1    1   /* Color 1 (even or non-staggered) */
#define PIC_CBI_CEVEN_2    2   /* Color 2 (even or non-staggered) */
#define PIC_CBI_MEVEN      3   /* Monochrome (even or non-staggereed) */
#define PIC_CBI_CODD_0     4   /* Color 0 (odd) */
#define PIC_CBI_CODD_1     5   /* Color 1 (odd) */
#define PIC_CBI_CODD_2     6   /* Color 2 (odd) */
#define PIC_CBI_MODD       7   /* Monochrome (odd) */

#endif
