/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _ICETEST_driver_H_
#define _ICETEST_driver_H_

// interface between icetest.c and the layer below it

enum icetestsubblock{common=0, icetest_idma};

enum mask_type {enable=0, pending, ack, force};

// These objects (handles to the blocks) are kept by icetest.c at subblock registration time
typedef struct device_data icetestDeviceHandle; 
typedef struct device_data icetestIDMADeviceHandle; 

struct icetest_testconfig_info;  //  defined in icetest_if.h
struct icetest_interrupt_info;  //  defined in icetest_if.h
struct icetest_idma_interrupt_info;  //  defined in icetest_if.h
struct icetest_idma_config_info;  //  defined in icetest_if.h
struct icetest_idma_status_info;  //  defined in icetest_if.h


/////////////////////////////////////////////////////////////////////////////
// function tables passed to icetest.c

struct icetest_idma_function_struct
{
    int version;
    void (*clear_icetest_idma_irqs) (icetestIDMADeviceHandle *device_data,
                                     struct icetest_idma_interrupt_info *irqstruct);
    void (*dump_icetest_idma_regs) (icetestIDMADeviceHandle *device_data);
    void (*start_icetest_idma) (icetestIDMADeviceHandle *device_data, dma_addr_t phys_addr);
    void (*set_all_idma_irqstruct) (icetestIDMADeviceHandle *unused,
                                    struct icetest_idma_interrupt_info *irqstruct, bool setval);
    void (*convert_uintarray_to_irqstruct) (icetestIDMADeviceHandle *unused, uint32_t ints,
                                            struct icetest_idma_interrupt_info *irqstruct,
                                            enum mask_type operation);
    void (*get_icetest_idma_desc_read) (icetestIDMADeviceHandle *device_data, int *value);
    void (*set_icetest_idma_config) (icetestIDMADeviceHandle *device_data,
                                     struct icetest_idma_config_info *info);
    void (*get_icetest_idma_config) (icetestIDMADeviceHandle *device_data,
                                     struct icetest_idma_config_info *info);
    void (*get_icetest_idma_status) (icetestIDMADeviceHandle *device_data, struct icetest_idma_status_info *info);
    void (*get_icetest_idma_linewidth) (icetestIDMADeviceHandle *device_data, int *value);
    void (*set_icetest_idma_linewidth) (icetestIDMADeviceHandle *device_data, int value);
    void (*get_icetest_idma_transfer_length) (icetestIDMADeviceHandle *device_data, int *value);
    void (*get_icetest_idma_transfer_addr) (icetestIDMADeviceHandle *device_data, int *value);
    void (*get_icetest_idma_ctrl_word) (icetestIDMADeviceHandle *device_data, int *value);
    void (*set_icetest_idma_soft_reset) (icetestIDMADeviceHandle *device_data, int value);
    void (*handle_icetest_idma_irqs) (icetestIDMADeviceHandle *device_data);
    void (*enable_icetest_idma_irqs) (icetestIDMADeviceHandle *device_data,
                                      struct icetest_idma_interrupt_info *irqstruct);
    void (*disable_icetest_idma_irqs) (icetestIDMADeviceHandle *device_data,
                                       struct icetest_idma_interrupt_info *irqstruct);
    void (*register_callback) (icetestIDMADeviceHandle *device_data, void *callback_fcn);
};

struct icetest_common_function_struct
{
    int version;
    void (*set_all_irqstruct) (icetestDeviceHandle *unused,
                              struct icetest_interrupt_info *irqstruct,
                              bool setval);
    uint32_t (*convert_irqstruct_to_update_uintarray) (icetestDeviceHandle *unused,
                                                       uint32_t ints,
                                                       struct icetest_interrupt_info *irqstruct,
                                                       enum mask_type operation);
    void (*convert_uintarray_to_irqstruct) (icetestDeviceHandle *unused,
                                            uint32_t ints,
                                            struct icetest_interrupt_info *irqstruct,
                                            enum mask_type operation);
    void (*clear_icetest_irq) (icetestDeviceHandle *device_data,
                               struct icetest_interrupt_info *irqstruct);
    void (*enable_icetest_irq) (icetestDeviceHandle *device_data,
                                struct icetest_interrupt_info *irqstruct);
    void (*disable_icetest_irq) (icetestDeviceHandle *device_data,
                                struct icetest_interrupt_info *irqstruct);
    void (*force_icetest_irq ) (icetestDeviceHandle *device_data,
                              struct icetest_interrupt_info *irqstruct);
    void (*set_icetest_config) (icetestDeviceHandle *device_data, struct icetest_testconfig_info *cfg);
    void (*get_icetest_config) (icetestDeviceHandle *device_data, struct icetest_testconfig_info *info);
    void (*dump_icetest_regs) (icetestDeviceHandle *device_data);
    void (*register_callback) (icetestDeviceHandle *device_data, void *callback_fcn);
    uint32_t (*get_icetest_rev0) (icetestDeviceHandle *device_data);
    uint32_t (*get_icetest_rev1) (icetestDeviceHandle *device_data);
    
};
////////////////////////////////////////////////////////////////////////////

//registration function - subblocks register at init or probe time, and unregister at remove time
void register_icetest_subblock(enum icetestsubblock icetestsubblock,
                               void *iceetest_subblock_data, int instance);
void *unregister_icetest_subblock(enum icetestsubblock, int instance);


#endif
