/*
 ***************************************************************************************
 * (c) Copyright 2013 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _DESCRIPTOR_H_
#define _DESCRIPTOR_H_

enum descriptor_type {old_4word_axi=1, new_8word_axi};

// the new versions of the AXI DMA use a different bit for ownership
#define DMA_NEW_OWNS 1 << 24
#define DMA_OLD_OWNS 1 << 16
// and they use a different word for xfer address and length
#define DMA_NEW_XFER_ADDR 8
#define DMA_NEW_XFER_LENGTH 4
#define DMA_OLD_XFER_ADDR 4
#define DMA_OLD_XFER_LENGTH 8

#define DMA_EOI  1 << 7
#define DMA_SOI  1 << 6
#define DMA_INT_WHEN_DONE  1 << 1
#define DMA_STOP_WHEN_DONE 1 << 0




/* Distort descriptor */
struct pie_distort_descriptor {
   uint32_t line_range;
   uint32_t src;
   uint32_t next_phys_addr;
   uint32_t prev_phys_addr;
   uint32_t unused[4];
};

struct pie_distort_descriptor_info {
    struct device *dev;
    struct pie_distort_descriptor *descriptors;
    dma_addr_t base_phys_addr;
    unsigned int count;
};

dma_addr_t distort_descriptor_get_phys_addr(struct pie_distort_descriptor_info *info,
                                            int index);
int distort_descriptor_set_prev_next(struct pie_distort_descriptor_info *info, int index,
                                     int prev_index, int next_index);
int distort_descriptor_set(struct pie_distort_descriptor_info *info, int index,
                           dma_addr_t databuf, unsigned int first_line_in_range,
                           unsigned int num_lines);
int distort_descriptor_create_list(struct pie_distort_descriptor_info *info,
                                   struct device *dev, unsigned int count);
void distort_descriptor_destroy_list(struct pie_distort_descriptor_info *info);
void distort_descriptor_print_chain(struct pie_distort_descriptor_info *info);
void distort_descriptor_clear_chain(struct pie_distort_descriptor_info *info);


// ZX Descriptors

#define ZX_DESCRIPTOR_CTRL_BLOCK_OWN (1 << 16)
#define ZX_DESCRIPTOR_CTRL_INTR_ON_FINISH (1 << 1)
#define ZX_DESCRIPTOR_CTRL_STOP_ON_FINISH (1 << 0)
#define ZX_DESCRIPTOR_CTRL_NO_EOI (1 << 5)
#define ZX_DESCRIPTOR_CTRL_NO_SOI (1 << 4)
#define ZX_CMD_HEADER_STRETCHBLT8W 0x0a
#define ZX_CMD_HEADER_STRETCHBLT24W 0x0c
#define ZX_CMD_HEADER_STRETCHBLT32W 0x0e
#define ZX_CMD_LENGTH_STRETCHBLT_SHIFT 8

struct zx_descriptor {
    uint32_t ctrl;
    uint32_t source;
    uint32_t length;
    uint32_t next;
} __attribute__((__packed__));

struct zx_descriptor_info {
    struct device *dev;
    struct zx_descriptor *descriptors;
    dma_addr_t base_phys_addr;
    unsigned int num_descriptors;
    unsigned int num_command_words;
};

int zx_descriptor_create_list(struct zx_descriptor_info *info,
                              struct device *dev,
                              unsigned int num_descriptors,
                              unsigned int num_command_words);
void zx_descriptor_destroy_list(struct zx_descriptor_info *info);
dma_addr_t zx_descriptor_get_phys_addr(struct zx_descriptor_info *info,
                                       int index);
uint32_t *zx_descriptor_get_command_buffer(struct zx_descriptor_info *info);
dma_addr_t zx_descriptor_get_command_buffer_phys_addr(struct zx_descriptor_info *info);
void zx_descriptor_print_chain(struct zx_descriptor_info *info,
                               int num_command_words);

// ODMA AXI Descriptor

#define ODMA_AXI_DESCRIPTOR_CONFIG_BLOCK_OWN (1 << 16)
#define ODMA_AXI_DESCRIPTOR_CONFIG_IMAGE_END   (1 << 7)
#define ODMA_AXI_DESCRIPTOR_CONFIG_IMAGE_START (1 << 6)
#define ODMA_AXI_DESCRIPTOR_CONFIG_INTR_ON_FINISH (1 << 1)
#define ODMA_AXI_DESCRIPTOR_CONFIG_STOP_ON_FINISH (1 << 0)

struct odma_axi_descriptor {
    uint32_t ctrl;
    uint32_t source;
    uint32_t length;
    uint32_t next;
    uint32_t lines;
    uint32_t width;
    uint32_t last_line;
    uint32_t source2;
} __attribute__((__packed__));

struct odma_axi_descriptor_info {
    struct device *dev;
    struct odma_axi_descriptor *descriptors;
    dma_addr_t base_phys_addr;
    unsigned int num_descriptors;
};

int odma_axi_descriptor_create_list(struct odma_axi_descriptor_info *info,
                                    struct device *dev,
                                    unsigned int num_descriptors);
void odma_axi_descriptor_destroy_list(struct odma_axi_descriptor_info *info);
dma_addr_t odma_axi_descriptor_get_phys_addr(struct odma_axi_descriptor_info *info,
                                             int index);
void odma_axi_descriptor_print_chain(struct odma_axi_descriptor_info *info);







/* POGO AXI descriptor */
typedef struct DMA_descriptor_s DMA_descriptor;

int create_descriptor_list(int num_descriptors,
                           enum descriptor_type dtype,
                           DMA_descriptor **ret_descriptor, 
                           dma_addr_t *ret_descriptor_phys,
                           struct device *device_ptr);

int set_descriptor(DMA_descriptor *descriptor, int index, int data_xfer_size, 
                    dma_addr_t databuf, uint32_t flags);

void dump_descriptors(DMA_descriptor *descriptor, int num_descriptors);

void destroy_descriptors(int num_descriptors, DMA_descriptor *descriptor_addr,
                         dma_addr_t descriptor_addr_phys, struct device *device_ptr);

/*Set director with given buffer address*/
int set_descriptor_direct(DMA_descriptor *descriptor, int index, int data_xfer_size,
                           dma_addr_t strip_databuf, uint32_t flags);
int set_descriptor_direct_eightword(DMA_descriptor *descriptor, int index, int data_xfer_size,
                                    dma_addr_t strip_databuf, int data_xfer_size2,
                                    dma_addr_t strip_databuf2, uint32_t flags);

dma_addr_t get_descriptor_phys_address (dma_addr_t descriptor_addr_phys, int index);
#endif
