/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _CISX_INT_IF_H_
#define _CISX_INT_IF_H_

// NOTE:
//  The CISX Int register structures may not appear here if the virtual register 
//  definitions in cisx_if.h happen to match the physical registers. At the
//  time this sub-block driver was created, they all matched.

struct cisx_int_function_struct
{
    int version;
    void (*dump_cisx_int_regs) (cisx_intDeviceHandle *device_data);

    void (*get_cisx_int_CisxCfg) (cisx_intDeviceHandle *device_data, struct cisx_int_CisxCfg_reg *cfg);
    void (*set_cisx_int_CisxCfg) (cisx_intDeviceHandle *device_data, struct cisx_int_CisxCfg_reg *cfg);

    void (*get_cisx_int_CisxStat) (cisx_intDeviceHandle *device_data, struct cisx_int_CisxStat_reg *cfg);

    void (*get_cisx_int_Chan0Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan0Pix_reg *cfg);
    void (*set_cisx_int_Chan0Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan0Pix_reg *cfg);

    void (*get_cisx_int_Chan1Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan1Pix_reg *cfg);
    void (*set_cisx_int_Chan1Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan1Pix_reg *cfg);

    void (*get_cisx_int_Chan2Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan2Pix_reg *cfg);
    void (*set_cisx_int_Chan2Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan2Pix_reg *cfg);

    void (*get_cisx_int_Chan3Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan3Pix_reg *cfg);
    void (*set_cisx_int_Chan3Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan3Pix_reg *cfg);

    void (*get_cisx_int_Chan4Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan4Pix_reg *cfg);
    void (*set_cisx_int_Chan4Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan4Pix_reg *cfg);

    void (*get_cisx_int_Chan5Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan5Pix_reg *cfg);
    void (*set_cisx_int_Chan5Pix) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan5Pix_reg *cfg);

    void (*get_cisx_int_Chan0Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan0Shuffle_reg *cfg);
    void (*set_cisx_int_Chan0Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan0Shuffle_reg *cfg);

    void (*get_cisx_int_Chan1Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan1Shuffle_reg *cfg);
    void (*set_cisx_int_Chan1Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan1Shuffle_reg *cfg);

    void (*get_cisx_int_Chan2Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan2Shuffle_reg *cfg);
    void (*set_cisx_int_Chan2Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan2Shuffle_reg *cfg);

    void (*get_cisx_int_Chan3Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan3Shuffle_reg *cfg);
    void (*set_cisx_int_Chan3Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan3Shuffle_reg *cfg);

    void (*get_cisx_int_Chan4Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan4Shuffle_reg *cfg);
    void (*set_cisx_int_Chan4Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan4Shuffle_reg *cfg);

    void (*get_cisx_int_Chan5Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan5Shuffle_reg *cfg);
    void (*set_cisx_int_Chan5Shuffle) (cisx_intDeviceHandle *device_data, struct cisx_int_Chan5Shuffle_reg *cfg);

    void (*get_cisx_int_TBL_CNT) (cisx_intDeviceHandle *device_data, struct cisx_int_TBL_CNT_reg *cfg);
    void (*set_cisx_int_TBL_CNT) (cisx_intDeviceHandle *device_data, struct cisx_int_TBL_CNT_reg *cfg);

    void (*get_cisx_int_REV0) (cisx_intDeviceHandle *device_data, struct cisx_int_REV0_reg *cfg);

    void (*get_cisx_int_REV1) (cisx_intDeviceHandle *device_data, struct cisx_int_REV1_reg *cfg);

    void (*get_cisx_int_ODMA_TBL_LUT) (cisx_intDeviceHandle *device_data, struct cisx_int_ODMA_TBL_LUT_reg *cfg, uint8_t index);
    void (*set_cisx_int_ODMA_TBL_LUT) (cisx_intDeviceHandle *device_data, struct cisx_int_ODMA_TBL_LUT_reg *cfg, uint8_t index);

    void (*get_cisx_int_COLOR_OUT_TBL_LUT) (cisx_intDeviceHandle *device_data, struct cisx_int_COLOR_OUT_TBL_LUT_reg *cfg, uint8_t index);
    void (*set_cisx_int_COLOR_OUT_TBL_LUT) (cisx_intDeviceHandle *device_data, struct cisx_int_COLOR_OUT_TBL_LUT_reg *cfg, uint8_t index);

    void (*cisx_int_register_callback_irq) (cisx_intDeviceHandle *device_data, void *callbackfcn);

    void (*cisx_int_enable_irq)  (cisx_intDeviceHandle *device_data, struct cisx_int_irqs *irqs);
    void (*cisx_int_disable_irq) (cisx_intDeviceHandle *device_data, struct cisx_int_irqs *irqs);

    void (*cisx_int_force_irq)  (cisx_intDeviceHandle *device_data, struct cisx_int_irqs *irqs);

    void (*cisx_int_clear_irq)  (cisx_intDeviceHandle *device_data, struct cisx_int_irqs *irqs);

    void (*cisx_int_handle_irq) (cisx_intDeviceHandle *device_data);
};

#endif // _CISX_INT_IF_H_

