/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _CISX_IF_H_
#define _CISX_IF_H_


// ****************************************************************************
// CISX INT interrupts.
// ****************************************************************************
struct cisx_int_irqs
{
    int   cisx_instance;

    bool  imagedone;
    bool  odma5;
    bool  odma4;
    bool  odma3;
    bool  odma2;
    bool  odma1;
    bool  odma0;
    bool  idma1;
    bool  idma0;
    bool  dmabuserr;

    // NOTE: this is for debug only - use the fields in the structure to see if a bit is set!!!!
    uint32_t irq_array;  
};


// ****************************************************************************
// CISX INT virtual register structures.
//    Note that these virtual register structures MAY or MAY NOT match physical
//    hardware. If not, the CISX driver will translate to the format needed by
//    the sub-block driver.
// ****************************************************************************

struct cisx_int_CisxCfg_reg
{
    uint8_t  enable;       // 1 bits
    uint8_t  slave_inp_sel;  // 1 bits
    uint8_t  bypass;       // 1 bits
    uint8_t  mode;         // 3 bits
    uint8_t  cbiout_pace;  // 5 bits
    uint8_t  cpu_access_lut;  // 1 bits
    uint8_t  numchans;     // 4 bits
    uint8_t  ccd_order;    // 3 bits
    uint8_t  color_out_tbl_en;  // 1 bits
    uint8_t  appchan_idata;  // 1 bits
    uint8_t  appchan_ext;  // 1 bits
    uint8_t  appchan5;     // 1 bits
    uint8_t  appchan4;     // 1 bits
    uint8_t  appchan3;     // 1 bits
    uint8_t  appchan2;     // 1 bits
    uint8_t  appchan1;     // 1 bits
    uint8_t  appchan0;     // 1 bits

    bool enable_valid;
    bool slave_inp_sel_valid;
    bool bypass_valid;
    bool mode_valid;
    bool cbiout_pace_valid;
    bool cpu_access_lut_valid;
    bool numchans_valid;
    bool ccd_order_valid;
    bool color_out_tbl_en_valid;
    bool appchan_idata_valid;
    bool appchan_ext_valid;
    bool appchan5_valid;
    bool appchan4_valid;
    bool appchan3_valid;
    bool appchan2_valid;
    bool appchan1_valid;
    bool appchan0_valid;
};

struct cisx_int_CisxStat_reg
{
    uint8_t  line_sm;      // 3 bits
    uint8_t  odma_busy;    // 1 bits
    uint8_t  idma_busy;    // 1 bits

    bool line_sm_valid;
    bool odma_busy_valid;
    bool idma_busy_valid;
};

struct cisx_int_Chan0Pix_reg
{
    uint16_t chan0dum;     // 10 bits
    uint16_t chan0dat;     // 16 bits

    bool chan0dum_valid;
    bool chan0dat_valid;
};

struct cisx_int_Chan1Pix_reg
{
    uint16_t chan1dum;     // 10 bits
    uint16_t chan1dat;     // 16 bits

    bool chan1dum_valid;
    bool chan1dat_valid;
};

struct cisx_int_Chan2Pix_reg
{
    uint16_t chan2dum;     // 10 bits
    uint16_t chan2dat;     // 16 bits

    bool chan2dum_valid;
    bool chan2dat_valid;
};

struct cisx_int_Chan3Pix_reg
{
    uint16_t chan3dum;     // 10 bits
    uint16_t chan3dat;     // 16 bits

    bool chan3dum_valid;
    bool chan3dat_valid;
};

struct cisx_int_Chan4Pix_reg
{
    uint16_t chan4dum;     // 10 bits
    uint16_t chan4dat;     // 16 bits

    bool chan4dum_valid;
    bool chan4dat_valid;
};

struct cisx_int_Chan5Pix_reg
{
    uint16_t chan5dum;     // 10 bits
    uint16_t chan5dat;     // 16 bits

    bool chan5dum_valid;
    bool chan5dat_valid;
};

struct cisx_int_Chan0Shuffle_reg
{
    uint16_t chan0sep;     // 10 bits

    bool chan0sep_valid;
};

struct cisx_int_Chan1Shuffle_reg
{
    uint16_t chan1sep;     // 10 bits

    bool chan1sep_valid;
};

struct cisx_int_Chan2Shuffle_reg
{
    uint16_t chan2sep;     // 10 bits

    bool chan2sep_valid;
};

struct cisx_int_Chan3Shuffle_reg
{
    uint16_t chan3sep;     // 10 bits

    bool chan3sep_valid;
};

struct cisx_int_Chan4Shuffle_reg
{
    uint16_t chan4sep;     // 10 bits

    bool chan4sep_valid;
};

struct cisx_int_Chan5Shuffle_reg
{
    uint16_t chan5sep;     // 10 bits

    bool chan5sep_valid;
};

struct cisx_int_TBL_CNT_reg
{
    uint8_t  color_out_tbl_cnt;  // 2 bits
    uint8_t  odma_tbl_cnt;  // 6 bits

    bool color_out_tbl_cnt_valid;
    bool odma_tbl_cnt_valid;
};

struct cisx_int_REV0_reg
{
    uint16_t maj;          // 16 bits
    uint16_t mid;          // 16 bits

    bool maj_valid;
    bool mid_valid;
};

struct cisx_int_REV1_reg
{
    uint16_t cfg;          // 16 bits

    bool cfg_valid;
};

struct cisx_int_ODMA_TBL_LUT_reg
{
    uint8_t  d;    // 4 bits

    bool d_valid;
};

struct cisx_int_COLOR_OUT_TBL_LUT_reg
{
    uint8_t  d;  // 2 bits

    bool d_valid;
};


// Public API functions: CISX INT (complete virtual register methods)
void cisx_int_get_CisxCfg(uint8_t cisx_instance, struct cisx_int_CisxCfg_reg *cfg);
void cisx_int_set_CisxCfg(uint8_t cisx_instance, struct cisx_int_CisxCfg_reg *cfg);
void cisx_int_get_CisxStat(uint8_t cisx_instance, struct cisx_int_CisxStat_reg *cfg);
void cisx_int_get_Chan0Pix(uint8_t cisx_instance, struct cisx_int_Chan0Pix_reg *cfg);
void cisx_int_set_Chan0Pix(uint8_t cisx_instance, struct cisx_int_Chan0Pix_reg *cfg);
void cisx_int_get_Chan1Pix(uint8_t cisx_instance, struct cisx_int_Chan1Pix_reg *cfg);
void cisx_int_set_Chan1Pix(uint8_t cisx_instance, struct cisx_int_Chan1Pix_reg *cfg);
void cisx_int_get_Chan2Pix(uint8_t cisx_instance, struct cisx_int_Chan2Pix_reg *cfg);
void cisx_int_set_Chan2Pix(uint8_t cisx_instance, struct cisx_int_Chan2Pix_reg *cfg);
void cisx_int_get_Chan3Pix(uint8_t cisx_instance, struct cisx_int_Chan3Pix_reg *cfg);
void cisx_int_set_Chan3Pix(uint8_t cisx_instance, struct cisx_int_Chan3Pix_reg *cfg);
void cisx_int_get_Chan4Pix(uint8_t cisx_instance, struct cisx_int_Chan4Pix_reg *cfg);
void cisx_int_set_Chan4Pix(uint8_t cisx_instance, struct cisx_int_Chan4Pix_reg *cfg);
void cisx_int_get_Chan5Pix(uint8_t cisx_instance, struct cisx_int_Chan5Pix_reg *cfg);
void cisx_int_set_Chan5Pix(uint8_t cisx_instance, struct cisx_int_Chan5Pix_reg *cfg);
void cisx_int_get_Chan0Shuffle(uint8_t cisx_instance, struct cisx_int_Chan0Shuffle_reg *cfg);
void cisx_int_set_Chan0Shuffle(uint8_t cisx_instance, struct cisx_int_Chan0Shuffle_reg *cfg);
void cisx_int_get_Chan1Shuffle(uint8_t cisx_instance, struct cisx_int_Chan1Shuffle_reg *cfg);
void cisx_int_set_Chan1Shuffle(uint8_t cisx_instance, struct cisx_int_Chan1Shuffle_reg *cfg);
void cisx_int_get_Chan2Shuffle(uint8_t cisx_instance, struct cisx_int_Chan2Shuffle_reg *cfg);
void cisx_int_set_Chan2Shuffle(uint8_t cisx_instance, struct cisx_int_Chan2Shuffle_reg *cfg);
void cisx_int_get_Chan3Shuffle(uint8_t cisx_instance, struct cisx_int_Chan3Shuffle_reg *cfg);
void cisx_int_set_Chan3Shuffle(uint8_t cisx_instance, struct cisx_int_Chan3Shuffle_reg *cfg);
void cisx_int_get_Chan4Shuffle(uint8_t cisx_instance, struct cisx_int_Chan4Shuffle_reg *cfg);
void cisx_int_set_Chan4Shuffle(uint8_t cisx_instance, struct cisx_int_Chan4Shuffle_reg *cfg);
void cisx_int_get_Chan5Shuffle(uint8_t cisx_instance, struct cisx_int_Chan5Shuffle_reg *cfg);
void cisx_int_set_Chan5Shuffle(uint8_t cisx_instance, struct cisx_int_Chan5Shuffle_reg *cfg);
void cisx_int_get_TBL_CNT(uint8_t cisx_instance, struct cisx_int_TBL_CNT_reg *cfg);
void cisx_int_set_TBL_CNT(uint8_t cisx_instance, struct cisx_int_TBL_CNT_reg *cfg);
void cisx_int_get_REV0(uint8_t cisx_instance, struct cisx_int_REV0_reg *cfg);
void cisx_int_get_REV1(uint8_t cisx_instance, struct cisx_int_REV1_reg *cfg);
void cisx_int_get_ODMA_TBL_LUT(uint8_t cisx_instance, struct cisx_int_ODMA_TBL_LUT_reg *cfg, uint8_t index);
void cisx_int_set_ODMA_TBL_LUT(uint8_t cisx_instance, struct cisx_int_ODMA_TBL_LUT_reg *cfg, uint8_t index);
void cisx_int_get_COLOR_OUT_TBL_LUT(uint8_t cisx_instance, struct cisx_int_COLOR_OUT_TBL_LUT_reg *cfg, uint8_t index);
void cisx_int_set_COLOR_OUT_TBL_LUT(uint8_t cisx_instance, struct cisx_int_COLOR_OUT_TBL_LUT_reg *cfg, uint8_t index);

// Public API functions: CISX INT (IRQ methods)
void cisx_int_register_irq_callback(uint8_t cisx_instance, void *callbackfcn);
void cisx_int_enable_irqs(uint8_t cisx_instance, struct cisx_int_irqs *irqs);
void cisx_int_disable_irqs(uint8_t cisx_instance, struct cisx_int_irqs *irqs);
void cisx_int_handle_irqs(uint8_t cisx_instance);
void cisx_int_force_irqs(uint8_t cisx_instance, struct cisx_int_irqs *irqs);
void cisx_int_clear_irqs(uint8_t cisx_instance, struct cisx_int_irqs *irqs);

// Public API functions: CISX INT (legacy helper methods)
void cisx_int_dump_regs(uint8_t cisx_instance);

// ****************************************************************************
// CISX INT constants.
// ****************************************************************************

#define CISX_INT_CFG_CCD_ORDER_012  0
#define CISX_INT_CFG_CCD_ORDER_021  1
#define CISX_INT_CFG_CCD_ORDER_102  2
#define CISX_INT_CFG_CCD_ORDER_120  3
#define CISX_INT_CFG_CCD_ORDER_201  4
#define CISX_INT_CFG_CCD_ORDER_210  5

#define CISX_INT_CFG_NUMCHANS_1     1
#define CISX_INT_CFG_NUMCHANS_2     2
#define CISX_INT_CFG_NUMCHANS_3     3
#define CISX_INT_CFG_NUMCHANS_4     4
#define CISX_INT_CFG_NUMCHANS_5     5
#define CISX_INT_CFG_NUMCHANS_6     6

#define CISX_INT_CFG_MODE_MONO_NO_SHUFFLE 0
#define CISX_INT_CFG_MODE_MONO_SHUFFLE    1
#define CISX_INT_CFG_MODE_MONO_STAGGER    2
#define CISX_INT_CFG_MODE_CLR_NO_SHUFFLE  4
#define CISX_INT_CFG_MODE_CLR_SHUFFLE     5
#define CISX_INT_CFG_MODE_CLR_STAGGER     6


// ****************************************************************************
// CISX IDMA interrupts.
// ****************************************************************************
struct cisx_idma_irqs
{
    int   cisx_instance;
    int   dma_instance;

    bool  rresp;
    bool  bresp;
    bool  rst;
    bool  eoi;
    bool  fin;
    bool  who;

    // NOTE: this is for debug only - use the fields in the structure to see if a bit is set!!!!
    uint32_t irq_array;  
};

// ****************************************************************************
// CISX IDMA virtual register structures.
//    Note that these virtual register structures MAY or MAY NOT match physical
//    hardware. If not, the CISX driver will translate to the format needed by
//    the sub-block driver.
// ****************************************************************************

struct cisx_idma_cfg_reg
{
    uint8_t  replicate;    // 1 bits
    uint8_t  enable;       // 1 bits
    uint8_t  out_width;    // 3 bits
    uint8_t  burst_len;    // 2 bits

    bool replicate_valid;
    bool enable_valid;
    bool out_width_valid;
    bool burst_len_valid;
};

struct cisx_idma_status_reg
{
    uint8_t  soi;          // 1 bits
    uint8_t  eoi;          // 1 bits
    uint8_t  softreset;    // 1 bits
    uint8_t  full_cbuf;    // 1 bits
    uint8_t  empty_cbuf;   // 1 bits
    uint8_t  full_dbuf;    // 1 bits
    uint8_t  empty_dbuf;   // 1 bits
    uint8_t  packer_empty;  // 1 bits
    uint8_t  dma_busy;     // 1 bits

    bool soi_valid;
    bool eoi_valid;
    bool softreset_valid;
    bool full_cbuf_valid;
    bool empty_cbuf_valid;
    bool full_dbuf_valid;
    bool empty_dbuf_valid;
    bool packer_empty_valid;
    bool dma_busy_valid;
};

struct cisx_idma_line_width_reg
{
    uint16_t line_width;   // 16 bits

    bool line_width_valid;
};

struct cisx_idma_desc_write_reg
{
    uint32_t desc;         // 32 bits

    bool desc_valid;
};

struct cisx_idma_desc_read_reg
{
    uint32_t desc;         // 32 bits

    bool desc_valid;
};

struct cisx_idma_xfer_length_reg
{
    uint32_t len;          // 32 bits

    bool len_valid;
};

struct cisx_idma_xfer_addr_reg
{
    uint32_t addr;         // 32 bits

    bool addr_valid;
};

struct cisx_idma_ctrl_word_reg
{
    uint32_t ctrl_word;    // 32 bits

    bool ctrl_word_valid;
};

struct cisx_idma_reset_reg
{
    uint8_t  soft_reset;   // 1 bits

    bool soft_reset_valid;
};

// Public API functions: CISX IDMA (complete virtual register methods)
void cisx_idma_get_cfg(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_cfg_reg *cfg);
void cisx_idma_set_cfg(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_cfg_reg *cfg);
void cisx_idma_get_status(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_status_reg *cfg);
void cisx_idma_get_line_width(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_line_width_reg *cfg);
void cisx_idma_set_line_width(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_line_width_reg *cfg);
void cisx_idma_set_desc_write(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_desc_write_reg *cfg);
void cisx_idma_get_desc_read(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_desc_read_reg *cfg);
void cisx_idma_get_xfer_length(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_xfer_length_reg *cfg);
void cisx_idma_get_xfer_addr(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_xfer_addr_reg *cfg);
void cisx_idma_get_ctrl_word(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_ctrl_word_reg *cfg);
void cisx_idma_set_reset(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_reset_reg *cfg);

// Public API functions: CISX IDMA (IRQ methods)
void cisx_idma_register_irq_callback(uint8_t cisx_instance, uint8_t idma_instance, void *callbackfcn);
void cisx_idma_enable_irqs(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_irqs *irqs);
void cisx_idma_disable_irqs(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_irqs *irqs);
void cisx_idma_handle_irqs(uint8_t cisx_instance, uint8_t idma_instance);
void cisx_idma_force_irqs(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_irqs *irqs);
void cisx_idma_clear_irqs(uint8_t cisx_instance, uint8_t idma_instance, struct cisx_idma_irqs *irqs);

// Public API functions: CISX IDMA (legacy helper methods)
void cisx_idma_dump_regs(uint8_t cisx_instance, uint8_t idma_instance);

// ****************************************************************************
// CISX IDMA constants
// ****************************************************************************

#define CISX_IDMA_CFG_OUT_WDTH_1    0    // Output data width: 1 bit
#define CISX_IDMA_CFG_OUT_WDTH_2    1    // Output data width: 2 bits
#define CISX_IDMA_CFG_OUT_WDTH_4    2    // Output data width: 4 bits
#define CISX_IDMA_CFG_OUT_WDTH_8    3    // Output data width: 8 bits
#define CISX_IDMA_CFG_OUT_WDTH_16   4    // Output data width: 16 bits
#define CISX_IDMA_CFG_OUT_WDTH_32   5    // Output data width: 32 bits
#define CISX_IDMA_CFG_OUT_WDTH_24   6    // Output data width: 24 bits

#define CISX_IDMA_CFG_BURST_LEN_4   0    // DMA burst length: 4 words
#define CISX_IDMA_CFG_BURST_LEN_8   1    // DMA burst length: 8 words
#define CISX_IDMA_CFG_BURST_LEN_16  2    // DMA burst length: 16 words


// ****************************************************************************
// CISX ODMA interrupts.
// ****************************************************************************

struct cisx_odma_irqs
{
    int   cisx_instance;
    int   dma_instance;

    bool  rresp;
    bool  bresp;
    bool  rst;
    bool  eoi;
    bool  dir;
    bool  cl_ali;
    bool  eol_ali;
    bool  eoi_ali;
    bool  eoi_err;
    bool  fin;
    bool  who;

    // NOTE: this is for debug only - use the fields in the structure to see if a bit is set!!!!
    uint32_t irq_array;  
};

// ****************************************************************************
// CISX ODMA virtual register structures.
//    Note that these virtual register structures MAY or MAY NOT match physical
//    hardware. If not, the CISX driver will translate to the format needed by
//    the sub-block driver.
// ****************************************************************************

struct cisx_odma_cfg_reg
{
    uint8_t  serpentine;   // 1 bits
    uint8_t  line_rev;     // 1 bits
    uint8_t  tran_rev;     // 1 bits
    uint8_t  upper_half;   // 1 bits
    uint8_t  msb_in;       // 1 bits
    uint8_t  enable;       // 1 bits
    uint8_t  in_width;     // 3 bits
    uint8_t  burst_len;    // 2 bits

    bool serpentine_valid;
    bool line_rev_valid;
    bool tran_rev_valid;
    bool upper_half_valid;
    bool msb_in_valid;
    bool enable_valid;
    bool in_width_valid;
    bool burst_len_valid;
};

struct cisx_odma_status_reg
{
    uint8_t  desc_own;     // 1 bits
    uint8_t  desc_eoi;     // 1 bits
    uint8_t  desc_soi;     // 1 bits
    uint8_t  reverse;      // 1 bits
    uint8_t  softreset;    // 1 bits
    uint8_t  full_cbuf;    // 1 bits
    uint8_t  empty_cbuf;   // 1 bits
    uint8_t  full_dbuf;    // 1 bits
    uint8_t  empty_dbuf;   // 1 bits
    uint8_t  packer_empty;  // 1 bits
    uint8_t  dma_busy;     // 1 bits

    bool desc_own_valid;
    bool desc_eoi_valid;
    bool desc_soi_valid;
    bool reverse_valid;
    bool softreset_valid;
    bool full_cbuf_valid;
    bool empty_cbuf_valid;
    bool full_dbuf_valid;
    bool empty_dbuf_valid;
    bool packer_empty_valid;
    bool dma_busy_valid;
};

struct cisx_odma_line_size_reg
{
    uint32_t line_size;    // 18 bits

    bool line_size_valid;
};

struct cisx_odma_desc_write_reg
{
    uint32_t desc;         // 30 bits

    bool desc_valid;
};

struct cisx_odma_desc_read_reg
{
    uint32_t desc;         // 32 bits

    bool desc_valid;
};

struct cisx_odma_xfer_length_reg
{
    uint32_t len;          // 32 bits

    bool len_valid;
};

struct cisx_odma_xfer_addr_reg
{
    uint32_t addr;         // 32 bits

    bool addr_valid;
};

struct cisx_odma_xfer_burst_reg
{
    uint8_t  burst;        // 5 bits

    bool burst_valid;
};

struct cisx_odma_reset_reg
{
    uint8_t  soft_reset;   // 1 bits

    bool soft_reset_valid;
};

// Public API functions: CISX ODMA (complete virtual register methods)
void cisx_odma_get_cfg(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_cfg_reg *cfg);
void cisx_odma_set_cfg(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_cfg_reg *cfg);
void cisx_odma_get_status(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_status_reg *cfg);
void cisx_odma_get_line_size(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_line_size_reg *cfg);
void cisx_odma_set_line_size(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_line_size_reg *cfg);
void cisx_odma_set_desc_write(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_desc_write_reg *cfg);
void cisx_odma_get_desc_read(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_desc_read_reg *cfg);
void cisx_odma_get_xfer_length(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_xfer_length_reg *cfg);
void cisx_odma_get_xfer_addr(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_xfer_addr_reg *cfg);
void cisx_odma_get_xfer_burst(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_xfer_burst_reg *cfg);
void cisx_odma_set_reset(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_reset_reg *cfg);

// Public API functions: CISX ODMA (IRQ methods)
void cisx_odma_register_irq_callback(uint8_t cisx_instance, uint8_t odma_instance, void *callbackfcn);
void cisx_odma_enable_irqs(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_irqs *irqs);
void cisx_odma_disable_irqs(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_irqs *irqs);
void cisx_odma_handle_irqs(uint8_t cisx_instance, uint8_t odma_instance);
void cisx_odma_force_irqs(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_irqs *irqs);
void cisx_odma_clear_irqs(uint8_t cisx_instance, uint8_t odma_instance, struct cisx_odma_irqs *irqs);

// Public API functions: CISX ODMA (legacy helper methods)
void cisx_odma_dump_regs(uint8_t cisx_instance, uint8_t odma_instance);


// ****************************************************************************
// CISX ODMA constants.
// ****************************************************************************

#define CISX_ODMA_CFG_IN_WDTH_1     0    // Incoming data width: 1 bit
#define CISX_ODMA_CFG_IN_WDTH_2     1    // Incoming data width: 2 bits
#define CISX_ODMA_CFG_IN_WDTH_4     2    // Incoming data width: 4 bits
#define CISX_ODMA_CFG_IN_WDTH_8     3    // Incoming data width: 8 bits
#define CISX_ODMA_CFG_IN_WDTH_16    4    // Incoming data width: 16 bits
#define CISX_ODMA_CFG_IN_WDTH_32    5    // Incoming data width: 32 bits
#define CISX_ODMA_CFG_IN_WDTH_24    6    // Incoming data width: 24 bits

#define CISX_ODMA_CFG_BURST_LEN_4   0    // DMA burst length: 4 words
#define CISX_ODMA_CFG_BURST_LEN_8   1    // DMA burst length: 8 words
#define CISX_ODMA_CFG_BURST_LEN_16  2    // DMA burst length: 16 words

#endif

