/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _CISX_IDMA_IF_H_
#define _CISX_IDMA_IF_H_

// NOTE:
//  The CISX IDMA register structures may not appear here if the virtual register 
//  definitions in cisx_if.h happen to match the physical registers. At the
//  time this sub-block driver was created, they all matched.

struct cisx_idma_function_struct
{
    int version;
    void (*dump_cisx_idma_regs) (cisx_idmaDeviceHandle *device_data);

    void (*get_cisx_idma_cfg) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_cfg_reg *cfg);
    void (*set_cisx_idma_cfg) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_cfg_reg *cfg);

    void (*get_cisx_idma_status) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_status_reg *cfg);

    void (*get_cisx_idma_line_width) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_line_width_reg *cfg);
    void (*set_cisx_idma_line_width) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_line_width_reg *cfg);

    void (*set_cisx_idma_desc_write) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_desc_write_reg *cfg);

    void (*get_cisx_idma_desc_read) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_desc_read_reg *cfg);

    void (*get_cisx_idma_xfer_length) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_xfer_length_reg *cfg);

    void (*get_cisx_idma_xfer_addr) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_xfer_addr_reg *cfg);

    void (*get_cisx_idma_ctrl_word) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_ctrl_word_reg *cfg);

    void (*set_cisx_idma_reset) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_reset_reg *cfg);

    void (*cisx_idma_register_callback_irq) (cisx_idmaDeviceHandle *device_data, void *callbackfcn);

    void (*cisx_idma_enable_irq)  (cisx_idmaDeviceHandle *device_data, struct cisx_idma_irqs *irqs);
    void (*cisx_idma_disable_irq) (cisx_idmaDeviceHandle *device_data, struct cisx_idma_irqs *irqs);

    void (*cisx_idma_force_irq)  (cisx_idmaDeviceHandle *device_data, struct cisx_idma_irqs *irqs);

    void (*cisx_idma_clear_irq)  (cisx_idmaDeviceHandle *device_data, struct cisx_idma_irqs *irqs);

    void (*cisx_idma_handle_irq) (cisx_idmaDeviceHandle *device_data);
};

#endif // _CISX_IDMA_IF_H_

