/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _CISX_driver_H_
#define _CISX_driver_H_

// Interface between cisx.c and the layer below it

// CISX block constants
#define MAX_NUM_CISXBLOCKS  2
#define MAX_INPUT_DMAS      2  // per cisx block
#define MAX_OUTPUT_DMAS     6  // per cisx block

enum cisxsubblock{cisx_int=0, input_dma, output_dma};

// These objects (handles to the blocks) are kept by cisx.c at subblock registration time
typedef struct device_data cisx_intDeviceHandle; 
typedef struct device_data cisx_idmaDeviceHandle;
typedef struct device_data cisx_odmaDeviceHandle;

cisx_intDeviceHandle *get_cisx_int_device(uint8_t cisx_instance);

// Registration functions - subblocks register at init or probe time, and 
// unregister at remove time
void  register_cisx_subblock(enum  cisxsubblock subblock, 
                             void *cisx_subblock_data, 
                             int   cisx_instance,
                             int   subblock_instance);
void *unregister_cisx_subblock(enum cisxsubblock subblock, 
                               int  cisx_instance, 
                               int  subblock_instance);

#endif

