/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

/** 
* \file afe_if.h
* 
* \brief Interface routines for accessing AFEs
* 
* Products with scanners interact with AFEs to control gain and 
* offset settings prior to retrieving image data.  This API 
* allows the caller to interact with all AFEs in the system. 
* 
**/

#ifndef INC_AFE_IF_H
#define INC_AFE_IF_H

typedef struct
{
    void (*dev_added)(uint32_t index);
    void (*dev_removed)(uint32_t index);
} afe_os_functions_t;

void     afe_system_init( afe_os_functions_t *os_functions );              ///< Called once to load AFE system (os can specify routines that should be called in certain circumstances for additional OS-related needs)
void     afe_system_unload(void);                                          ///< Called once to unload AFE system

uint32_t afe_get_num_afes(void);                                           ///< Returns the number of AFEs in the system

int      afe_reset(int afe);                                               ///< Reset to power-on values
int      afe_soft_setup(int afe, void *config);                            ///< Set to known state prior to each new use

int      afe_set_gains(int afe, uint32_t red, uint32_t green, uint32_t blue);   ///< Set gains for red, green and blue (val of 100 = gain of 1.0)
int      afe_set_offsets(int afe, int32_t red, int32_t green, int32_t blue);    ///< Set offsets for red, green and blue (offset of 1 should give shift of 1 in final output)

int      afe_get_bits_per_pixel(int afe);                                  ///< Bits per pixel for the AFE output

int      afe_get_name(int afe, char *buffer, int buf_len);                 ///< A string name to represent this AFE
uint32_t afe_reg_read(int afe, uint32_t reg_index);                        ///< Read any AFE register
int      afe_reg_write(int afe, uint32_t reg_index, uint32_t reg_value);   ///< Write any AFE register
int      afe_reg_dump(int afe);                                            ///< Dump all AFE registers

int      afe_sleep(int afe);                                               ///< Put the AFE to sleep
int      afe_wakeup(int afe);                                              ///< Wake up the AFE
int      afe_unload(int afe);                                              ///< Unload the driver

#endif // INC_AFE_IF_H

