 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file uart_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _UART_REGSTRUCTS_H_
#define _UART_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: UART (uart)
//
//====================================================================

typedef struct UART_REGS_s
{
 union {
  volatile uint32_t UART_RBR;  ///< 0x0 [R]: Receive Buffer Register
  volatile uint32_t UART_THR;  ///< 0x0 [W]: Transmit Holding Register
  volatile uint32_t UART_DLL;  ///< 0x0 [R/W]: Divisor Latch Low Byte Register
 } union0;
 union {
  volatile uint32_t UART_IER;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t UART_DLH;  ///< 0x4 [R/W]: Divisor Latch High Byte Register
 } union1;
 union {
  volatile uint32_t UART_IIR;  ///< 0x8 [R]: Interrupt Identification Register
  volatile uint32_t UART_FCR;  ///< 0x8 [W]: FIFO Control Register
 } union2;
  volatile uint32_t UART_LCR;  ///< 0xc [R/W]: Line Control Register
  volatile uint32_t UART_MCR;  ///< 0x10 [R/W]: Modem Control Register
  volatile uint32_t UART_LSR;  ///< 0x14 [R]: Line Status Register
  volatile uint32_t UART_MSR;  ///< 0x18 [R]: Modem Status Register
  volatile uint32_t UART_SCR;  ///< 0x1c [R/W]: Scratchpad Register
  volatile uint32_t UART_ISR;  ///< 0x20 [R/W]: Infrared Selection Register
  volatile uint32_t UART_FOR;  ///< 0x24 [R]: Receive FIFO Occupancy Register
  volatile uint32_t UART_ABR;  ///< 0x28 [R/W]: Auto-Baud Control Register
  volatile uint32_t UART_ACR;  ///< 0x2c [R]: Auto-Baud Count Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} UART_REGS_t;

#endif // UART
