 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file tsen_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _TSEN_REGS_REGMASKS_H_
#define _TSEN_REGS_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: TSEN Temperature Sensor Registers (tsen_regs)
/** \brief Registers for firmware configuration/status of TSEN_ADC33 combo hardmacro. Note that ADC-only configuration and status is in separate register set (see AUXADC block).*/
//
//====================================================================

//====================================================================
//Register: TSEN Configuration register (TSEN_Configuration)
/** \brief This register configures the TSEN hardmacro. <BR>*/
//====================================================================

#define  TSEN_REGS_TSEN_CONFIGURATION_RESERVED1_MASK 0xfffc0000
#define  TSEN_REGS_TSEN_CONFIGURATION_RESERVED1_SHIFT 18
#define  TSEN_REGS_TSEN_CONFIGURATION_RESERVED1_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONFIGURATION_RESERVED1_MASK) >> TSEN_REGS_TSEN_CONFIGURATION_RESERVED1_SHIFT)
#define  TSEN_REGS_TSEN_CONFIGURATION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONFIGURATION_RESERVED1_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONFIGURATION_RESERVED1_SHIFT))

#define  TSEN_REGS_TSEN_CONFIGURATION_TSEN_RSVD_MASK 0x3c000
#define  TSEN_REGS_TSEN_CONFIGURATION_TSEN_RSVD_SHIFT 14
#define  TSEN_REGS_TSEN_CONFIGURATION_TSEN_RSVD_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONFIGURATION_TSEN_RSVD_MASK) >> TSEN_REGS_TSEN_CONFIGURATION_TSEN_RSVD_SHIFT)
#define  TSEN_REGS_TSEN_CONFIGURATION_TSEN_RSVD_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONFIGURATION_TSEN_RSVD_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONFIGURATION_TSEN_RSVD_SHIFT))

#define  TSEN_REGS_TSEN_CONFIGURATION_RAW_SEL_MASK 0x3000
#define  TSEN_REGS_TSEN_CONFIGURATION_RAW_SEL_SHIFT 12
#define  TSEN_REGS_TSEN_CONFIGURATION_RAW_SEL_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONFIGURATION_RAW_SEL_MASK) >> TSEN_REGS_TSEN_CONFIGURATION_RAW_SEL_SHIFT)
#define  TSEN_REGS_TSEN_CONFIGURATION_RAW_SEL_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONFIGURATION_RAW_SEL_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONFIGURATION_RAW_SEL_SHIFT))

#define  TSEN_REGS_TSEN_CONFIGURATION_CAL_MASK 0xc00
#define  TSEN_REGS_TSEN_CONFIGURATION_CAL_SHIFT 10
#define  TSEN_REGS_TSEN_CONFIGURATION_CAL_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONFIGURATION_CAL_MASK) >> TSEN_REGS_TSEN_CONFIGURATION_CAL_SHIFT)
#define  TSEN_REGS_TSEN_CONFIGURATION_CAL_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONFIGURATION_CAL_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONFIGURATION_CAL_SHIFT))

#define  TSEN_REGS_TSEN_CONFIGURATION_CHOP_EN_MASK 0x300
#define  TSEN_REGS_TSEN_CONFIGURATION_CHOP_EN_SHIFT 8
#define  TSEN_REGS_TSEN_CONFIGURATION_CHOP_EN_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONFIGURATION_CHOP_EN_MASK) >> TSEN_REGS_TSEN_CONFIGURATION_CHOP_EN_SHIFT)
#define  TSEN_REGS_TSEN_CONFIGURATION_CHOP_EN_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONFIGURATION_CHOP_EN_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONFIGURATION_CHOP_EN_SHIFT))

#define  TSEN_REGS_TSEN_CONFIGURATION_EXT_EN_MASK 0x80
#define  TSEN_REGS_TSEN_CONFIGURATION_EXT_EN_SHIFT 7
#define  TSEN_REGS_TSEN_CONFIGURATION_EXT_EN_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONFIGURATION_EXT_EN_MASK) >> TSEN_REGS_TSEN_CONFIGURATION_EXT_EN_SHIFT)
#define  TSEN_REGS_TSEN_CONFIGURATION_EXT_EN_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONFIGURATION_EXT_EN_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONFIGURATION_EXT_EN_SHIFT))

#define  TSEN_REGS_TSEN_CONFIGURATION_AVG_NUM_MASK 0x70
#define  TSEN_REGS_TSEN_CONFIGURATION_AVG_NUM_SHIFT 4
#define  TSEN_REGS_TSEN_CONFIGURATION_AVG_NUM_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONFIGURATION_AVG_NUM_MASK) >> TSEN_REGS_TSEN_CONFIGURATION_AVG_NUM_SHIFT)
#define  TSEN_REGS_TSEN_CONFIGURATION_AVG_NUM_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONFIGURATION_AVG_NUM_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONFIGURATION_AVG_NUM_SHIFT))

#define  TSEN_REGS_TSEN_CONFIGURATION_DIV_MASK 0xf
#define  TSEN_REGS_TSEN_CONFIGURATION_DIV_SHIFT 0
#define  TSEN_REGS_TSEN_CONFIGURATION_DIV_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONFIGURATION_DIV_MASK) >> TSEN_REGS_TSEN_CONFIGURATION_DIV_SHIFT)
#define  TSEN_REGS_TSEN_CONFIGURATION_DIV_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONFIGURATION_DIV_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONFIGURATION_DIV_SHIFT))

//====================================================================
//Register: TSEN Control register (TSEN_Control)
/** \brief This register controls the TSEN hardmacro. <BR>*/
//====================================================================

#define  TSEN_REGS_TSEN_CONTROL_RESERVED1_MASK 0xfffffff8
#define  TSEN_REGS_TSEN_CONTROL_RESERVED1_SHIFT 3
#define  TSEN_REGS_TSEN_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONTROL_RESERVED1_MASK) >> TSEN_REGS_TSEN_CONTROL_RESERVED1_SHIFT)
#define  TSEN_REGS_TSEN_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONTROL_RESERVED1_SHIFT))

#define  TSEN_REGS_TSEN_CONTROL_START_MASK 0x4
#define  TSEN_REGS_TSEN_CONTROL_START_SHIFT 2
#define  TSEN_REGS_TSEN_CONTROL_START_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONTROL_START_MASK) >> TSEN_REGS_TSEN_CONTROL_START_SHIFT)
#define  TSEN_REGS_TSEN_CONTROL_START_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONTROL_START_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONTROL_START_SHIFT))

#define  TSEN_REGS_TSEN_CONTROL_EN_MASK 0x2
#define  TSEN_REGS_TSEN_CONTROL_EN_SHIFT 1
#define  TSEN_REGS_TSEN_CONTROL_EN_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONTROL_EN_MASK) >> TSEN_REGS_TSEN_CONTROL_EN_SHIFT)
#define  TSEN_REGS_TSEN_CONTROL_EN_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONTROL_EN_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONTROL_EN_SHIFT))

#define  TSEN_REGS_TSEN_CONTROL_RESET_MASK 0x1
#define  TSEN_REGS_TSEN_CONTROL_RESET_SHIFT 0
#define  TSEN_REGS_TSEN_CONTROL_RESET_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_CONTROL_RESET_MASK) >> TSEN_REGS_TSEN_CONTROL_RESET_SHIFT)
#define  TSEN_REGS_TSEN_CONTROL_RESET_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_CONTROL_RESET_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_CONTROL_RESET_SHIFT))

//====================================================================
//Register: TSEN and ADC Common Control Register (TSEN_ADC_Control)
/** \brief This register controls common signals to the TSEN and ADC portions of the TSEN_ADC33 combo hardmacro. <BR>*/
//====================================================================

#define  TSEN_REGS_TSEN_ADC_CONTROL_RESERVED1_MASK 0xffffc000
#define  TSEN_REGS_TSEN_ADC_CONTROL_RESERVED1_SHIFT 14
#define  TSEN_REGS_TSEN_ADC_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_ADC_CONTROL_RESERVED1_MASK) >> TSEN_REGS_TSEN_ADC_CONTROL_RESERVED1_SHIFT)
#define  TSEN_REGS_TSEN_ADC_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_ADC_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_ADC_CONTROL_RESERVED1_SHIFT))

#define  TSEN_REGS_TSEN_ADC_CONTROL_ISO_EN_MASK 0x2000
#define  TSEN_REGS_TSEN_ADC_CONTROL_ISO_EN_SHIFT 13
#define  TSEN_REGS_TSEN_ADC_CONTROL_ISO_EN_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_ADC_CONTROL_ISO_EN_MASK) >> TSEN_REGS_TSEN_ADC_CONTROL_ISO_EN_SHIFT)
#define  TSEN_REGS_TSEN_ADC_CONTROL_ISO_EN_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_ADC_CONTROL_ISO_EN_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_ADC_CONTROL_ISO_EN_SHIFT))

#define  TSEN_REGS_TSEN_ADC_CONTROL_TESTMON_MASK 0x1f00
#define  TSEN_REGS_TSEN_ADC_CONTROL_TESTMON_SHIFT 8
#define  TSEN_REGS_TSEN_ADC_CONTROL_TESTMON_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_ADC_CONTROL_TESTMON_MASK) >> TSEN_REGS_TSEN_ADC_CONTROL_TESTMON_SHIFT)
#define  TSEN_REGS_TSEN_ADC_CONTROL_TESTMON_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_ADC_CONTROL_TESTMON_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_ADC_CONTROL_TESTMON_SHIFT))

#define  TSEN_REGS_TSEN_ADC_CONTROL_RESERVED2_MASK 0xe0
#define  TSEN_REGS_TSEN_ADC_CONTROL_RESERVED2_SHIFT 5
#define  TSEN_REGS_TSEN_ADC_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_ADC_CONTROL_RESERVED2_MASK) >> TSEN_REGS_TSEN_ADC_CONTROL_RESERVED2_SHIFT)
#define  TSEN_REGS_TSEN_ADC_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_ADC_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_ADC_CONTROL_RESERVED2_SHIFT))

#define  TSEN_REGS_TSEN_ADC_CONTROL_BG_DTRIM_MASK 0x1e
#define  TSEN_REGS_TSEN_ADC_CONTROL_BG_DTRIM_SHIFT 1
#define  TSEN_REGS_TSEN_ADC_CONTROL_BG_DTRIM_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_ADC_CONTROL_BG_DTRIM_MASK) >> TSEN_REGS_TSEN_ADC_CONTROL_BG_DTRIM_SHIFT)
#define  TSEN_REGS_TSEN_ADC_CONTROL_BG_DTRIM_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_ADC_CONTROL_BG_DTRIM_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_ADC_CONTROL_BG_DTRIM_SHIFT))

#define  TSEN_REGS_TSEN_ADC_CONTROL_BG_CHP_SEL_MASK 0x1
#define  TSEN_REGS_TSEN_ADC_CONTROL_BG_CHP_SEL_SHIFT 0
#define  TSEN_REGS_TSEN_ADC_CONTROL_BG_CHP_SEL_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_ADC_CONTROL_BG_CHP_SEL_MASK) >> TSEN_REGS_TSEN_ADC_CONTROL_BG_CHP_SEL_SHIFT)
#define  TSEN_REGS_TSEN_ADC_CONTROL_BG_CHP_SEL_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_ADC_CONTROL_BG_CHP_SEL_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_ADC_CONTROL_BG_CHP_SEL_SHIFT))

//====================================================================
//Register: Temperature Data Status register (TSEN_Status)
/** \brief The temperature measurement is continuously updated into this register.*/
//====================================================================

#define  TSEN_REGS_TSEN_STATUS_RESERVED1_MASK 0xfe000000
#define  TSEN_REGS_TSEN_STATUS_RESERVED1_SHIFT 25
#define  TSEN_REGS_TSEN_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_STATUS_RESERVED1_MASK) >> TSEN_REGS_TSEN_STATUS_RESERVED1_SHIFT)
#define  TSEN_REGS_TSEN_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_STATUS_RESERVED1_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_STATUS_RESERVED1_SHIFT))

#define  TSEN_REGS_TSEN_STATUS_TSEN_RDY_MASK 0x1000000
#define  TSEN_REGS_TSEN_STATUS_TSEN_RDY_SHIFT 24
#define  TSEN_REGS_TSEN_STATUS_TSEN_RDY_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_STATUS_TSEN_RDY_MASK) >> TSEN_REGS_TSEN_STATUS_TSEN_RDY_SHIFT)
#define  TSEN_REGS_TSEN_STATUS_TSEN_RDY_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_STATUS_TSEN_RDY_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_STATUS_TSEN_RDY_SHIFT))

#define  TSEN_REGS_TSEN_STATUS_TSEN_DATA_RAW_MASK 0xfff000
#define  TSEN_REGS_TSEN_STATUS_TSEN_DATA_RAW_SHIFT 12
#define  TSEN_REGS_TSEN_STATUS_TSEN_DATA_RAW_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_STATUS_TSEN_DATA_RAW_MASK) >> TSEN_REGS_TSEN_STATUS_TSEN_DATA_RAW_SHIFT)
#define  TSEN_REGS_TSEN_STATUS_TSEN_DATA_RAW_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_STATUS_TSEN_DATA_RAW_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_STATUS_TSEN_DATA_RAW_SHIFT))

#define  TSEN_REGS_TSEN_STATUS_TSEN_DATA_MASK 0xfff
#define  TSEN_REGS_TSEN_STATUS_TSEN_DATA_SHIFT 0
#define  TSEN_REGS_TSEN_STATUS_TSEN_DATA_MASK_SHIFT(reg) (((reg) & TSEN_REGS_TSEN_STATUS_TSEN_DATA_MASK) >> TSEN_REGS_TSEN_STATUS_TSEN_DATA_SHIFT)
#define  TSEN_REGS_TSEN_STATUS_TSEN_DATA_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_TSEN_STATUS_TSEN_DATA_MASK) | (((uint32_t)val) << TSEN_REGS_TSEN_STATUS_TSEN_DATA_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  TSEN_REGS_REV0_MAJ_MASK 0xffff0000
#define  TSEN_REGS_REV0_MAJ_SHIFT 16
#define  TSEN_REGS_REV0_MAJ_MASK_SHIFT(reg) (((reg) & TSEN_REGS_REV0_MAJ_MASK) >> TSEN_REGS_REV0_MAJ_SHIFT)
#define  TSEN_REGS_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_REV0_MAJ_MASK) | (((uint32_t)val) << TSEN_REGS_REV0_MAJ_SHIFT))

#define  TSEN_REGS_REV0_MID_MASK 0xffff
#define  TSEN_REGS_REV0_MID_SHIFT 0
#define  TSEN_REGS_REV0_MID_MASK_SHIFT(reg) (((reg) & TSEN_REGS_REV0_MID_MASK) >> TSEN_REGS_REV0_MID_SHIFT)
#define  TSEN_REGS_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_REV0_MID_MASK) | (((uint32_t)val) << TSEN_REGS_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  TSEN_REGS_REV1_RESERVED1_MASK 0xffff0000
#define  TSEN_REGS_REV1_RESERVED1_SHIFT 16
#define  TSEN_REGS_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & TSEN_REGS_REV1_RESERVED1_MASK) >> TSEN_REGS_REV1_RESERVED1_SHIFT)
#define  TSEN_REGS_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_REV1_RESERVED1_MASK) | (((uint32_t)val) << TSEN_REGS_REV1_RESERVED1_SHIFT))

#define  TSEN_REGS_REV1_CFG_MASK 0xffff
#define  TSEN_REGS_REV1_CFG_SHIFT 0
#define  TSEN_REGS_REV1_CFG_MASK_SHIFT(reg) (((reg) & TSEN_REGS_REV1_CFG_MASK) >> TSEN_REGS_REV1_CFG_SHIFT)
#define  TSEN_REGS_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~TSEN_REGS_REV1_CFG_MASK) | (((uint32_t)val) << TSEN_REGS_REV1_CFG_SHIFT))

#endif // TSEN_REGS
