 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file ssp_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SSP_REGSTRUCTS_H_
#define _SSP_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SSP (SSP)
//
//====================================================================

typedef struct SSP_REGS_s
{
  volatile uint32_t SSP_SSCR0;  ///< 0x0 [R/W]: SSP Control Register 0
  volatile uint32_t SSP_SSCR1;  ///< 0x4 [R/W]: SSP Control Register 1
  volatile uint32_t SSP_SSSR;  ///< 0x8 [R]: SSP Status Register
  volatile uint32_t SSP_SSITR;  ///< 0xc [R/W]: SSP Interrupt Test Register
  volatile uint32_t SSP_SSDR;  ///< 0x10 [R/W]: SSP Data Register
  volatile uint32_t reserved0[5];
  volatile uint32_t SSP_SSTO;  ///< 0x28 [R/W]: SSP Time Out Register
  volatile uint32_t SSP_SSPSP;  ///< 0x2c [R/W]: SSP Programmable Serial Protocol Register
  volatile uint32_t SSP_SSTSA;  ///< 0x30 [R/W]: SSP TX Time Slot Active Register
  volatile uint32_t SSP_SSRSA;  ///< 0x34 [R/W]: SSP RX Time Slot Active Register
  volatile uint32_t SSP_SSTSS;  ///< 0x38 [R]: SSP Time Slot Status Register
  volatile uint32_t reserved1[17];
  volatile uint32_t SSP_GPS_ID;  ///< 0x80 [R]: GPS Controller ID Register
  volatile uint32_t SSP_GPS_CSR;  ///< 0x84 [R/W]: GPS Control and Status Register
  volatile uint32_t SSP_GPS_TSCNT;  ///< 0x88 [R]: Time Sync Count Register
  volatile uint32_t SSP_GPS_TSCNT_ADJ;  ///< 0x8c [R]: Time Sync Count Adjust Register
  volatile uint32_t reserved2[12];
  volatile uint32_t SSP_SPI_MOD;  ///< 0xc0 [R/W]: Modified SPI Mode Register
  volatile uint32_t REV0;  ///< 0xc4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc8 [R]: IP Tagging Revision 1
} SSP_REGS_t;

#endif // SSP
