 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file ssp_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SSP_REGMASKS_H_
#define _SSP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SSP (SSP)
//
//====================================================================

//====================================================================
//Register: SSP Control Register 0 (SSP_SSCR0)
/** \brief These registers contain bit fields that control various functions within the SSP
port. The following table shows the bit locations corresponding to the different
control bit fields within the SSP Control 0 Register. The reset state of all
bits are as shown, but they must be programmed to their preferred values before
enabling the SSP port.
Writes to reserved bits must be 0x0, and read values of reserved bits are
undefined.*/
//====================================================================

#define  SSP_SSP_SSCR0_MOD_MASK 0x80000000
#define  SSP_SSP_SSCR0_MOD_SHIFT 31
#define  SSP_SSP_SSCR0_MOD_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_MOD_MASK) >> SSP_SSP_SSCR0_MOD_SHIFT)
#define  SSP_SSP_SSCR0_MOD_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_MOD_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_MOD_SHIFT))

#define  SSP_SSP_SSCR0_RESERVED1_MASK 0x40000000
#define  SSP_SSP_SSCR0_RESERVED1_SHIFT 30
#define  SSP_SSP_SSCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_RESERVED1_MASK) >> SSP_SSP_SSCR0_RESERVED1_SHIFT)
#define  SSP_SSP_SSCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_RESERVED1_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_RESERVED1_SHIFT))

#define  SSP_SSP_SSCR0_FPCKE_MASK 0x20000000
#define  SSP_SSP_SSCR0_FPCKE_SHIFT 29
#define  SSP_SSP_SSCR0_FPCKE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_FPCKE_MASK) >> SSP_SSP_SSCR0_FPCKE_SHIFT)
#define  SSP_SSP_SSCR0_FPCKE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_FPCKE_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_FPCKE_SHIFT))

#define  SSP_SSP_SSCR0_FCTRL_MASK 0x10000000
#define  SSP_SSP_SSCR0_FCTRL_SHIFT 28
#define  SSP_SSP_SSCR0_FCTRL_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_FCTRL_MASK) >> SSP_SSP_SSCR0_FCTRL_SHIFT)
#define  SSP_SSP_SSCR0_FCTRL_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_FCTRL_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_FCTRL_SHIFT))

#define  SSP_SSP_SSCR0_RESERVED2_MASK 0x8000000
#define  SSP_SSP_SSCR0_RESERVED2_SHIFT 27
#define  SSP_SSP_SSCR0_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_RESERVED2_MASK) >> SSP_SSP_SSCR0_RESERVED2_SHIFT)
#define  SSP_SSP_SSCR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_RESERVED2_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_RESERVED2_SHIFT))

#define  SSP_SSP_SSCR0_FRDC_MASK 0x7000000
#define  SSP_SSP_SSCR0_FRDC_SHIFT 24
#define  SSP_SSP_SSCR0_FRDC_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_FRDC_MASK) >> SSP_SSP_SSCR0_FRDC_SHIFT)
#define  SSP_SSP_SSCR0_FRDC_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_FRDC_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_FRDC_SHIFT))

#define  SSP_SSP_SSCR0_TIM_MASK 0x800000
#define  SSP_SSP_SSCR0_TIM_SHIFT 23
#define  SSP_SSP_SSCR0_TIM_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_TIM_MASK) >> SSP_SSP_SSCR0_TIM_SHIFT)
#define  SSP_SSP_SSCR0_TIM_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_TIM_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_TIM_SHIFT))

#define  SSP_SSP_SSCR0_RIM_MASK 0x400000
#define  SSP_SSP_SSCR0_RIM_SHIFT 22
#define  SSP_SSP_SSCR0_RIM_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_RIM_MASK) >> SSP_SSP_SSCR0_RIM_SHIFT)
#define  SSP_SSP_SSCR0_RIM_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_RIM_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_RIM_SHIFT))

#define  SSP_SSP_SSCR0_RESERVED3_MASK 0x200000
#define  SSP_SSP_SSCR0_RESERVED3_SHIFT 21
#define  SSP_SSP_SSCR0_RESERVED3_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_RESERVED3_MASK) >> SSP_SSP_SSCR0_RESERVED3_SHIFT)
#define  SSP_SSP_SSCR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_RESERVED3_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_RESERVED3_SHIFT))

#define  SSP_SSP_SSCR0_EDSS_MASK 0x100000
#define  SSP_SSP_SSCR0_EDSS_SHIFT 20
#define  SSP_SSP_SSCR0_EDSS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_EDSS_MASK) >> SSP_SSP_SSCR0_EDSS_SHIFT)
#define  SSP_SSP_SSCR0_EDSS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_EDSS_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_EDSS_SHIFT))

#define  SSP_SSP_SSCR0_RESERVED4_MASK 0xfff00
#define  SSP_SSP_SSCR0_RESERVED4_SHIFT 8
#define  SSP_SSP_SSCR0_RESERVED4_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_RESERVED4_MASK) >> SSP_SSP_SSCR0_RESERVED4_SHIFT)
#define  SSP_SSP_SSCR0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_RESERVED4_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_RESERVED4_SHIFT))

#define  SSP_SSP_SSCR0_SSE_MASK 0x80
#define  SSP_SSP_SSCR0_SSE_SHIFT 7
#define  SSP_SSP_SSCR0_SSE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_SSE_MASK) >> SSP_SSP_SSCR0_SSE_SHIFT)
#define  SSP_SSP_SSCR0_SSE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_SSE_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_SSE_SHIFT))

#define  SSP_SSP_SSCR0_RESERVED5_MASK 0x40
#define  SSP_SSP_SSCR0_RESERVED5_SHIFT 6
#define  SSP_SSP_SSCR0_RESERVED5_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_RESERVED5_MASK) >> SSP_SSP_SSCR0_RESERVED5_SHIFT)
#define  SSP_SSP_SSCR0_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_RESERVED5_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_RESERVED5_SHIFT))

#define  SSP_SSP_SSCR0_FRF_MASK 0x30
#define  SSP_SSP_SSCR0_FRF_SHIFT 4
#define  SSP_SSP_SSCR0_FRF_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_FRF_MASK) >> SSP_SSP_SSCR0_FRF_SHIFT)
#define  SSP_SSP_SSCR0_FRF_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_FRF_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_FRF_SHIFT))

#define  SSP_SSP_SSCR0_DSS_MASK 0xf
#define  SSP_SSP_SSCR0_DSS_SHIFT 0
#define  SSP_SSP_SSCR0_DSS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR0_DSS_MASK) >> SSP_SSP_SSCR0_DSS_SHIFT)
#define  SSP_SSP_SSCR0_DSS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR0_DSS_MASK) | (((uint32_t)val) << SSP_SSP_SSCR0_DSS_SHIFT))

//====================================================================
//Register: SSP Control Register 1 (SSP_SSCR1)
/** \brief These registers contain bit fields that control various SSP port functions. The
following table shows bit locations corresponding to control bit fields in
SSP_SSCR1. The reset state of all bits is shown, but must be set to the
preferred value before enabling the SSP port by setting the <Synchronous Serial
Port Enable> field in the SSP Control Register 0.
Write 0x0 to reserved bits, the read values of reserved bits are undetermined.*/
//====================================================================

#define  SSP_SSP_SSCR1_TTELP_MASK 0x80000000
#define  SSP_SSP_SSCR1_TTELP_SHIFT 31
#define  SSP_SSP_SSCR1_TTELP_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_TTELP_MASK) >> SSP_SSP_SSCR1_TTELP_SHIFT)
#define  SSP_SSP_SSCR1_TTELP_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_TTELP_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_TTELP_SHIFT))

#define  SSP_SSP_SSCR1_TTE_MASK 0x40000000
#define  SSP_SSP_SSCR1_TTE_SHIFT 30
#define  SSP_SSP_SSCR1_TTE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_TTE_MASK) >> SSP_SSP_SSCR1_TTE_SHIFT)
#define  SSP_SSP_SSCR1_TTE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_TTE_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_TTE_SHIFT))

#define  SSP_SSP_SSCR1_EBCEI_MASK 0x20000000
#define  SSP_SSP_SSCR1_EBCEI_SHIFT 29
#define  SSP_SSP_SSCR1_EBCEI_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_EBCEI_MASK) >> SSP_SSP_SSCR1_EBCEI_SHIFT)
#define  SSP_SSP_SSCR1_EBCEI_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_EBCEI_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_EBCEI_SHIFT))

#define  SSP_SSP_SSCR1_SCFR_MASK 0x10000000
#define  SSP_SSP_SSCR1_SCFR_SHIFT 28
#define  SSP_SSP_SSCR1_SCFR_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_SCFR_MASK) >> SSP_SSP_SSCR1_SCFR_SHIFT)
#define  SSP_SSP_SSCR1_SCFR_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_SCFR_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_SCFR_SHIFT))

#define  SSP_SSP_SSCR1_ECRA_MASK 0x8000000
#define  SSP_SSP_SSCR1_ECRA_SHIFT 27
#define  SSP_SSP_SSCR1_ECRA_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_ECRA_MASK) >> SSP_SSP_SSCR1_ECRA_SHIFT)
#define  SSP_SSP_SSCR1_ECRA_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_ECRA_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_ECRA_SHIFT))

#define  SSP_SSP_SSCR1_ECRB_MASK 0x4000000
#define  SSP_SSP_SSCR1_ECRB_SHIFT 26
#define  SSP_SSP_SSCR1_ECRB_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_ECRB_MASK) >> SSP_SSP_SSCR1_ECRB_SHIFT)
#define  SSP_SSP_SSCR1_ECRB_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_ECRB_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_ECRB_SHIFT))

#define  SSP_SSP_SSCR1_SCLKDIR_MASK 0x2000000
#define  SSP_SSP_SSCR1_SCLKDIR_SHIFT 25
#define  SSP_SSP_SSCR1_SCLKDIR_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_SCLKDIR_MASK) >> SSP_SSP_SSCR1_SCLKDIR_SHIFT)
#define  SSP_SSP_SSCR1_SCLKDIR_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_SCLKDIR_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_SCLKDIR_SHIFT))

#define  SSP_SSP_SSCR1_SFRMDIR_MASK 0x1000000
#define  SSP_SSP_SSCR1_SFRMDIR_SHIFT 24
#define  SSP_SSP_SSCR1_SFRMDIR_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_SFRMDIR_MASK) >> SSP_SSP_SSCR1_SFRMDIR_SHIFT)
#define  SSP_SSP_SSCR1_SFRMDIR_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_SFRMDIR_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_SFRMDIR_SHIFT))

#define  SSP_SSP_SSCR1_RWOT_MASK 0x800000
#define  SSP_SSP_SSCR1_RWOT_SHIFT 23
#define  SSP_SSP_SSCR1_RWOT_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_RWOT_MASK) >> SSP_SSP_SSCR1_RWOT_SHIFT)
#define  SSP_SSP_SSCR1_RWOT_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_RWOT_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_RWOT_SHIFT))

#define  SSP_SSP_SSCR1_TRAIL_MASK 0x400000
#define  SSP_SSP_SSCR1_TRAIL_SHIFT 22
#define  SSP_SSP_SSCR1_TRAIL_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_TRAIL_MASK) >> SSP_SSP_SSCR1_TRAIL_SHIFT)
#define  SSP_SSP_SSCR1_TRAIL_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_TRAIL_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_TRAIL_SHIFT))

#define  SSP_SSP_SSCR1_TSRE_MASK 0x200000
#define  SSP_SSP_SSCR1_TSRE_SHIFT 21
#define  SSP_SSP_SSCR1_TSRE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_TSRE_MASK) >> SSP_SSP_SSCR1_TSRE_SHIFT)
#define  SSP_SSP_SSCR1_TSRE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_TSRE_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_TSRE_SHIFT))

#define  SSP_SSP_SSCR1_RSRE_MASK 0x100000
#define  SSP_SSP_SSCR1_RSRE_SHIFT 20
#define  SSP_SSP_SSCR1_RSRE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_RSRE_MASK) >> SSP_SSP_SSCR1_RSRE_SHIFT)
#define  SSP_SSP_SSCR1_RSRE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_RSRE_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_RSRE_SHIFT))

#define  SSP_SSP_SSCR1_TINTE_MASK 0x80000
#define  SSP_SSP_SSCR1_TINTE_SHIFT 19
#define  SSP_SSP_SSCR1_TINTE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_TINTE_MASK) >> SSP_SSP_SSCR1_TINTE_SHIFT)
#define  SSP_SSP_SSCR1_TINTE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_TINTE_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_TINTE_SHIFT))

#define  SSP_SSP_SSCR1_PINTE_MASK 0x40000
#define  SSP_SSP_SSCR1_PINTE_SHIFT 18
#define  SSP_SSP_SSCR1_PINTE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_PINTE_MASK) >> SSP_SSP_SSCR1_PINTE_SHIFT)
#define  SSP_SSP_SSCR1_PINTE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_PINTE_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_PINTE_SHIFT))

#define  SSP_SSP_SSCR1_FEN_MASK 0x20000
#define  SSP_SSP_SSCR1_FEN_SHIFT 17
#define  SSP_SSP_SSCR1_FEN_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_FEN_MASK) >> SSP_SSP_SSCR1_FEN_SHIFT)
#define  SSP_SSP_SSCR1_FEN_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_FEN_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_FEN_SHIFT))

#define  SSP_SSP_SSCR1_IFS_MASK 0x10000
#define  SSP_SSP_SSCR1_IFS_SHIFT 16
#define  SSP_SSP_SSCR1_IFS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_IFS_MASK) >> SSP_SSP_SSCR1_IFS_SHIFT)
#define  SSP_SSP_SSCR1_IFS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_IFS_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_IFS_SHIFT))

#define  SSP_SSP_SSCR1_STRF_MASK 0x8000
#define  SSP_SSP_SSCR1_STRF_SHIFT 15
#define  SSP_SSP_SSCR1_STRF_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_STRF_MASK) >> SSP_SSP_SSCR1_STRF_SHIFT)
#define  SSP_SSP_SSCR1_STRF_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_STRF_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_STRF_SHIFT))

#define  SSP_SSP_SSCR1_EFWR_MASK 0x4000
#define  SSP_SSP_SSCR1_EFWR_SHIFT 14
#define  SSP_SSP_SSCR1_EFWR_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_EFWR_MASK) >> SSP_SSP_SSCR1_EFWR_SHIFT)
#define  SSP_SSP_SSCR1_EFWR_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_EFWR_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_EFWR_SHIFT))

#define  SSP_SSP_SSCR1_RFT_MASK 0x3c00
#define  SSP_SSP_SSCR1_RFT_SHIFT 10
#define  SSP_SSP_SSCR1_RFT_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_RFT_MASK) >> SSP_SSP_SSCR1_RFT_SHIFT)
#define  SSP_SSP_SSCR1_RFT_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_RFT_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_RFT_SHIFT))

#define  SSP_SSP_SSCR1_TFT_MASK 0x3c0
#define  SSP_SSP_SSCR1_TFT_SHIFT 6
#define  SSP_SSP_SSCR1_TFT_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_TFT_MASK) >> SSP_SSP_SSCR1_TFT_SHIFT)
#define  SSP_SSP_SSCR1_TFT_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_TFT_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_TFT_SHIFT))

#define  SSP_SSP_SSCR1_MWDS_MASK 0x20
#define  SSP_SSP_SSCR1_MWDS_SHIFT 5
#define  SSP_SSP_SSCR1_MWDS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_MWDS_MASK) >> SSP_SSP_SSCR1_MWDS_SHIFT)
#define  SSP_SSP_SSCR1_MWDS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_MWDS_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_MWDS_SHIFT))

#define  SSP_SSP_SSCR1_SPH_MASK 0x10
#define  SSP_SSP_SSCR1_SPH_SHIFT 4
#define  SSP_SSP_SSCR1_SPH_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_SPH_MASK) >> SSP_SSP_SSCR1_SPH_SHIFT)
#define  SSP_SSP_SSCR1_SPH_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_SPH_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_SPH_SHIFT))

#define  SSP_SSP_SSCR1_SPO_MASK 0x8
#define  SSP_SSP_SSCR1_SPO_SHIFT 3
#define  SSP_SSP_SSCR1_SPO_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_SPO_MASK) >> SSP_SSP_SSCR1_SPO_SHIFT)
#define  SSP_SSP_SSCR1_SPO_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_SPO_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_SPO_SHIFT))

#define  SSP_SSP_SSCR1_LBM_MASK 0x4
#define  SSP_SSP_SSCR1_LBM_SHIFT 2
#define  SSP_SSP_SSCR1_LBM_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_LBM_MASK) >> SSP_SSP_SSCR1_LBM_SHIFT)
#define  SSP_SSP_SSCR1_LBM_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_LBM_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_LBM_SHIFT))

#define  SSP_SSP_SSCR1_TIE_MASK 0x2
#define  SSP_SSP_SSCR1_TIE_SHIFT 1
#define  SSP_SSP_SSCR1_TIE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_TIE_MASK) >> SSP_SSP_SSCR1_TIE_SHIFT)
#define  SSP_SSP_SSCR1_TIE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_TIE_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_TIE_SHIFT))

#define  SSP_SSP_SSCR1_RIE_MASK 0x1
#define  SSP_SSP_SSCR1_RIE_SHIFT 0
#define  SSP_SSP_SSCR1_RIE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSCR1_RIE_MASK) >> SSP_SSP_SSCR1_RIE_SHIFT)
#define  SSP_SSP_SSCR1_RIE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSCR1_RIE_MASK) | (((uint32_t)val) << SSP_SSP_SSCR1_RIE_SHIFT))

//====================================================================
//Register: SSP Status Register (SSP_SSSR)
/** \brief These registers contain bits that signal overrun errors as well as the TXFIFO
and RXFIFO service requests. Each of these hardware-detected events signals an
interrupt request to the interrupt controller, or a DMA request. The Status
register also contains flags that indicate if the SSPx port is actively
transmitting data, if the TXFIFO is not full, and if the RXFIFO is not empty.
A signal-interrupt signal is sent to the interrupt controller for each SSPx
port. These events can cause an interrupt request or a DMA request:
end-of-chain, receiver timeout, peripheral trailing byte, RXFIFO overrun, RXFIFO
service request, and TXFIFO service request.
Bits that cause an interrupt request remain set until they are cleared by
writing a 0x1 to each bit. Once a status bit is cleared, the interrupt is
cleared. Read-write bits are called status bits (status bits are referred to
as <q>sticky</q> and once set by hardware, they can only be cleared by writing
a 0x1 to each bit), read-only bits are called flags. Writing 0x1 to a sticky
status bit clears it, writing a 0x0 has no effect. Read-only flags are set
to 0x1 and are cleared automatically to 0x0 by hardware, and writes have no
effect. Some bits that cause interrupt requests have corresponding mask bits in
the control registers and are indicated in the following sections.
The following table shows the bit locations corresponding to the status and flag
bits within the SSP Port Status Register. All bits are read-only except
the <Receive FIFO Overrun>, <Peripheral Trailing Byte Interrupt>, <Transmit FIFO
Underrun>, <Bit Count Error>, <Receiver Time-out Interrupt>, and <End of Chain>,
which are all read-write. The reset state of read-write bits is 0x0 and all bits
return to their reset state when the <Synchronous Serial Port Enable> field in
the SSP Control Register 0 is cleared.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP_SSP_SSSR_OSS_MASK 0x80000000
#define  SSP_SSP_SSSR_OSS_SHIFT 31
#define  SSP_SSP_SSSR_OSS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_OSS_MASK) >> SSP_SSP_SSSR_OSS_SHIFT)
#define  SSP_SSP_SSSR_OSS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_OSS_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_OSS_SHIFT))

#define  SSP_SSP_SSSR_TX_OSS_MASK 0x40000000
#define  SSP_SSP_SSSR_TX_OSS_SHIFT 30
#define  SSP_SSP_SSSR_TX_OSS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_TX_OSS_MASK) >> SSP_SSP_SSSR_TX_OSS_SHIFT)
#define  SSP_SSP_SSSR_TX_OSS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_TX_OSS_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_TX_OSS_SHIFT))

#define  SSP_SSP_SSSR_RESERVED1_MASK 0x3f000000
#define  SSP_SSP_SSSR_RESERVED1_SHIFT 24
#define  SSP_SSP_SSSR_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_RESERVED1_MASK) >> SSP_SSP_SSSR_RESERVED1_SHIFT)
#define  SSP_SSP_SSSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_RESERVED1_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_RESERVED1_SHIFT))

#define  SSP_SSP_SSSR_BCE_MASK 0x800000
#define  SSP_SSP_SSSR_BCE_SHIFT 23
#define  SSP_SSP_SSSR_BCE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_BCE_MASK) >> SSP_SSP_SSSR_BCE_SHIFT)
#define  SSP_SSP_SSSR_BCE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_BCE_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_BCE_SHIFT))

#define  SSP_SSP_SSSR_CSS_MASK 0x400000
#define  SSP_SSP_SSSR_CSS_SHIFT 22
#define  SSP_SSP_SSSR_CSS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_CSS_MASK) >> SSP_SSP_SSSR_CSS_SHIFT)
#define  SSP_SSP_SSSR_CSS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_CSS_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_CSS_SHIFT))

#define  SSP_SSP_SSSR_TUR_MASK 0x200000
#define  SSP_SSP_SSSR_TUR_SHIFT 21
#define  SSP_SSP_SSSR_TUR_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_TUR_MASK) >> SSP_SSP_SSSR_TUR_SHIFT)
#define  SSP_SSP_SSSR_TUR_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_TUR_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_TUR_SHIFT))

#define  SSP_SSP_SSSR_EOC_MASK 0x100000
#define  SSP_SSP_SSSR_EOC_SHIFT 20
#define  SSP_SSP_SSSR_EOC_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_EOC_MASK) >> SSP_SSP_SSSR_EOC_SHIFT)
#define  SSP_SSP_SSSR_EOC_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_EOC_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_EOC_SHIFT))

#define  SSP_SSP_SSSR_TINT_MASK 0x80000
#define  SSP_SSP_SSSR_TINT_SHIFT 19
#define  SSP_SSP_SSSR_TINT_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_TINT_MASK) >> SSP_SSP_SSSR_TINT_SHIFT)
#define  SSP_SSP_SSSR_TINT_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_TINT_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_TINT_SHIFT))

#define  SSP_SSP_SSSR_PINT_MASK 0x40000
#define  SSP_SSP_SSSR_PINT_SHIFT 18
#define  SSP_SSP_SSSR_PINT_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_PINT_MASK) >> SSP_SSP_SSSR_PINT_SHIFT)
#define  SSP_SSP_SSSR_PINT_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_PINT_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_PINT_SHIFT))

#define  SSP_SSP_SSSR_RESERVED2_MASK 0x30000
#define  SSP_SSP_SSSR_RESERVED2_SHIFT 16
#define  SSP_SSP_SSSR_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_RESERVED2_MASK) >> SSP_SSP_SSSR_RESERVED2_SHIFT)
#define  SSP_SSP_SSSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_RESERVED2_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_RESERVED2_SHIFT))

#define  SSP_SSP_SSSR_RFL_MASK 0xf000
#define  SSP_SSP_SSSR_RFL_SHIFT 12
#define  SSP_SSP_SSSR_RFL_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_RFL_MASK) >> SSP_SSP_SSSR_RFL_SHIFT)
#define  SSP_SSP_SSSR_RFL_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_RFL_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_RFL_SHIFT))

#define  SSP_SSP_SSSR_TFL_MASK 0xf00
#define  SSP_SSP_SSSR_TFL_SHIFT 8
#define  SSP_SSP_SSSR_TFL_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_TFL_MASK) >> SSP_SSP_SSSR_TFL_SHIFT)
#define  SSP_SSP_SSSR_TFL_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_TFL_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_TFL_SHIFT))

#define  SSP_SSP_SSSR_ROR_MASK 0x80
#define  SSP_SSP_SSSR_ROR_SHIFT 7
#define  SSP_SSP_SSSR_ROR_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_ROR_MASK) >> SSP_SSP_SSSR_ROR_SHIFT)
#define  SSP_SSP_SSSR_ROR_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_ROR_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_ROR_SHIFT))

#define  SSP_SSP_SSSR_RFS_MASK 0x40
#define  SSP_SSP_SSSR_RFS_SHIFT 6
#define  SSP_SSP_SSSR_RFS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_RFS_MASK) >> SSP_SSP_SSSR_RFS_SHIFT)
#define  SSP_SSP_SSSR_RFS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_RFS_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_RFS_SHIFT))

#define  SSP_SSP_SSSR_TFS_MASK 0x20
#define  SSP_SSP_SSSR_TFS_SHIFT 5
#define  SSP_SSP_SSSR_TFS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_TFS_MASK) >> SSP_SSP_SSSR_TFS_SHIFT)
#define  SSP_SSP_SSSR_TFS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_TFS_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_TFS_SHIFT))

#define  SSP_SSP_SSSR_BSY_MASK 0x10
#define  SSP_SSP_SSSR_BSY_SHIFT 4
#define  SSP_SSP_SSSR_BSY_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_BSY_MASK) >> SSP_SSP_SSSR_BSY_SHIFT)
#define  SSP_SSP_SSSR_BSY_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_BSY_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_BSY_SHIFT))

#define  SSP_SSP_SSSR_RNE_MASK 0x8
#define  SSP_SSP_SSSR_RNE_SHIFT 3
#define  SSP_SSP_SSSR_RNE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_RNE_MASK) >> SSP_SSP_SSSR_RNE_SHIFT)
#define  SSP_SSP_SSSR_RNE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_RNE_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_RNE_SHIFT))

#define  SSP_SSP_SSSR_TNF_MASK 0x4
#define  SSP_SSP_SSSR_TNF_SHIFT 2
#define  SSP_SSP_SSSR_TNF_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_TNF_MASK) >> SSP_SSP_SSSR_TNF_SHIFT)
#define  SSP_SSP_SSSR_TNF_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_TNF_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_TNF_SHIFT))

#define  SSP_SSP_SSSR_RESERVED3_MASK 0x3
#define  SSP_SSP_SSSR_RESERVED3_SHIFT 0
#define  SSP_SSP_SSSR_RESERVED3_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSSR_RESERVED3_MASK) >> SSP_SSP_SSSR_RESERVED3_SHIFT)
#define  SSP_SSP_SSSR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSSR_RESERVED3_MASK) | (((uint32_t)val) << SSP_SSP_SSSR_RESERVED3_SHIFT))

//====================================================================
//Register: SSP Interrupt Test Register (SSP_SSITR)
/** \brief Only use these read-write registers for testing purposes. The interrupt request
or DMA service request generated when one of these test bits is set remains
active until the test bit is cleared by writing 0x0. Setting any of these bits
to 0x1 also causes the corresponding status bit(s) to be set to 0x1 in the SSP
Status Register.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP_SSP_SSITR_RESERVED1_MASK 0xffffff00
#define  SSP_SSP_SSITR_RESERVED1_SHIFT 8
#define  SSP_SSP_SSITR_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSITR_RESERVED1_MASK) >> SSP_SSP_SSITR_RESERVED1_SHIFT)
#define  SSP_SSP_SSITR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSITR_RESERVED1_MASK) | (((uint32_t)val) << SSP_SSP_SSITR_RESERVED1_SHIFT))

#define  SSP_SSP_SSITR_TROR_MASK 0x80
#define  SSP_SSP_SSITR_TROR_SHIFT 7
#define  SSP_SSP_SSITR_TROR_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSITR_TROR_MASK) >> SSP_SSP_SSITR_TROR_SHIFT)
#define  SSP_SSP_SSITR_TROR_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSITR_TROR_MASK) | (((uint32_t)val) << SSP_SSP_SSITR_TROR_SHIFT))

#define  SSP_SSP_SSITR_TRFS_MASK 0x40
#define  SSP_SSP_SSITR_TRFS_SHIFT 6
#define  SSP_SSP_SSITR_TRFS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSITR_TRFS_MASK) >> SSP_SSP_SSITR_TRFS_SHIFT)
#define  SSP_SSP_SSITR_TRFS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSITR_TRFS_MASK) | (((uint32_t)val) << SSP_SSP_SSITR_TRFS_SHIFT))

#define  SSP_SSP_SSITR_TTFS_MASK 0x20
#define  SSP_SSP_SSITR_TTFS_SHIFT 5
#define  SSP_SSP_SSITR_TTFS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSITR_TTFS_MASK) >> SSP_SSP_SSITR_TTFS_SHIFT)
#define  SSP_SSP_SSITR_TTFS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSITR_TTFS_MASK) | (((uint32_t)val) << SSP_SSP_SSITR_TTFS_SHIFT))

#define  SSP_SSP_SSITR_RESERVED2_MASK 0x1f
#define  SSP_SSP_SSITR_RESERVED2_SHIFT 0
#define  SSP_SSP_SSITR_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSITR_RESERVED2_MASK) >> SSP_SSP_SSITR_RESERVED2_SHIFT)
#define  SSP_SSP_SSITR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSITR_RESERVED2_MASK) | (((uint32_t)val) << SSP_SSP_SSITR_RESERVED2_SHIFT))

//====================================================================
//Register: SSP Data Register (SSP_SSDR)
/** \brief These registers are each two physical registers that have a common address.
One SSDR_x is temporary storage for data that is transferred automatically
into the TXFIFO, the other SSDR_x is temporary storage for data that is
transferred automatically from the RXFIFO.
As programmed I/O or DMA access the SSDR_x, the TXFIFO or RXFIFO control
logic transfers data automatically between the SSDR_x and the FIFO as fast
as the system moves it. Data in the TXFIFO shifts up to accommodate new
data that is written to the SSDR_X, unless it is an attempted write to
a full TXFIFO. Data in the RXFIFO shifts down to accommodate data that is
read from the SSP Data Register. The <Transmit FIFO Level>, <Receive FIFO
Level>, <Receive FIFO Not Empty>, and <Transmit FIFO Not Full> fields in
the SSP Status Register show whether the FIFO is full, above/below
a programmable FIFO trigger threshold level, or empty.
When using programmed I/O, data can be written to the SSP Data Register
anytime the TXFIFO falls below its trigger threshold level.
When a data sample size of less than 32-bits or 16 bits for packed mode is
selected, software should right-justify the data that is written to the SSP
Data Register for automatic insertion into the TXFIFO. The transmit logic
left-justifies the data and ignores any unused bits. Received data of less
than 32 bits is right-justified automatically in the RXFIFO (thus, you
cannot perform a write in packed mode of less than 32 bits wide). The
TXFIFO and RXFIFO are cleared to 0x0 when the SSPx port is reset or
disabled (by writing a 0x0 to the <Synchronous Serial Port Enable> field in
the SSP Control Register 0).
The reset state of SSDR_x is undetermined. The following table shows the
location of the SSPx port SSDR_x.*/
//====================================================================

#define  SSP_SSP_SSDR_DATA_MASK 0xffffffff
#define  SSP_SSP_SSDR_DATA_SHIFT 0
#define  SSP_SSP_SSDR_DATA_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSDR_DATA_MASK) >> SSP_SSP_SSDR_DATA_SHIFT)
#define  SSP_SSP_SSDR_DATA_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSDR_DATA_MASK) | (((uint32_t)val) << SSP_SSP_SSDR_DATA_SHIFT))

//====================================================================
//Register: SSP Time Out Register (SSP_SSTO)
/** \brief These registers specify the timeout (TIMEOUT) value used to signal a period of
inactivity within the RXFIFO, see Timeout Section in the PXA2128 Datasheet. When
a timeout occurs, the <Receiver Time-out Interrupt> field in the SSP Status
Register is set. When the TIMEOUT value is set to 0x000000, no timeout occurs
and the <Receiver Time-out Interrupt> field is not set. The TIMEOUT interval is
given by the calculation in the TIMEOUT Interval Equation.
TIMEOUT Interval Equation
TimeOut Interval = <Timeout Value> / APB Clock Frequency
Note: APB Clock Frequency = 26 MHz
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP_SSP_SSTO_RESERVED1_MASK 0xff000000
#define  SSP_SSP_SSTO_RESERVED1_SHIFT 24
#define  SSP_SSP_SSTO_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSTO_RESERVED1_MASK) >> SSP_SSP_SSTO_RESERVED1_SHIFT)
#define  SSP_SSP_SSTO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSTO_RESERVED1_MASK) | (((uint32_t)val) << SSP_SSP_SSTO_RESERVED1_SHIFT))

#define  SSP_SSP_SSTO_TIMEOUT_MASK 0xffffff
#define  SSP_SSP_SSTO_TIMEOUT_SHIFT 0
#define  SSP_SSP_SSTO_TIMEOUT_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSTO_TIMEOUT_MASK) >> SSP_SSP_SSTO_TIMEOUT_SHIFT)
#define  SSP_SSP_SSTO_TIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSTO_TIMEOUT_MASK) | (((uint32_t)val) << SSP_SSP_SSTO_TIMEOUT_SHIFT))

//====================================================================
//Register: SSP Programmable Serial Protocol Register (SSP_SSPSP)
/** \brief These registers contain eight fields that program the various programmable
serial-protocol (PSP) parameters. When using Programmable Serial Protocol (PSP)
format in network mode, the parameters <Serial Frame Delay>, <Serial Frame
Delay>, <Start Delay>, <Dummy Stop>, <Extended Dummy Stop>, <Dummy Start>,
and <Extended Dummy Start> must be set to 0x0. The other parameters <Serial
Frame Polarity>, <Serial Bit-rate Clock Mode>, <Frame Sync Relative Timing Bit>,
and <Serial Frame Width> are programmable.
Writes 0b0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP_SSP_SSPSP_RESERVED1_MASK 0x80000000
#define  SSP_SSP_SSPSP_RESERVED1_SHIFT 31
#define  SSP_SSP_SSPSP_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_RESERVED1_MASK) >> SSP_SSP_SSPSP_RESERVED1_SHIFT)
#define  SSP_SSP_SSPSP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_RESERVED1_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_RESERVED1_SHIFT))

#define  SSP_SSP_SSPSP_EDMYSTOP_MASK 0x70000000
#define  SSP_SSP_SSPSP_EDMYSTOP_SHIFT 28
#define  SSP_SSP_SSPSP_EDMYSTOP_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_EDMYSTOP_MASK) >> SSP_SSP_SSPSP_EDMYSTOP_SHIFT)
#define  SSP_SSP_SSPSP_EDMYSTOP_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_EDMYSTOP_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_EDMYSTOP_SHIFT))

#define  SSP_SSP_SSPSP_EDMYSTRT_MASK 0xc000000
#define  SSP_SSP_SSPSP_EDMYSTRT_SHIFT 26
#define  SSP_SSP_SSPSP_EDMYSTRT_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_EDMYSTRT_MASK) >> SSP_SSP_SSPSP_EDMYSTRT_SHIFT)
#define  SSP_SSP_SSPSP_EDMYSTRT_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_EDMYSTRT_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_EDMYSTRT_SHIFT))

#define  SSP_SSP_SSPSP_FSRT_MASK 0x2000000
#define  SSP_SSP_SSPSP_FSRT_SHIFT 25
#define  SSP_SSP_SSPSP_FSRT_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_FSRT_MASK) >> SSP_SSP_SSPSP_FSRT_SHIFT)
#define  SSP_SSP_SSPSP_FSRT_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_FSRT_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_FSRT_SHIFT))

#define  SSP_SSP_SSPSP_DMYSTOP_MASK 0x1800000
#define  SSP_SSP_SSPSP_DMYSTOP_SHIFT 23
#define  SSP_SSP_SSPSP_DMYSTOP_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_DMYSTOP_MASK) >> SSP_SSP_SSPSP_DMYSTOP_SHIFT)
#define  SSP_SSP_SSPSP_DMYSTOP_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_DMYSTOP_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_DMYSTOP_SHIFT))

#define  SSP_SSP_SSPSP_RESERVED2_MASK 0x400000
#define  SSP_SSP_SSPSP_RESERVED2_SHIFT 22
#define  SSP_SSP_SSPSP_RESERVED2_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_RESERVED2_MASK) >> SSP_SSP_SSPSP_RESERVED2_SHIFT)
#define  SSP_SSP_SSPSP_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_RESERVED2_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_RESERVED2_SHIFT))

#define  SSP_SSP_SSPSP_SFRMWDTH_MASK 0x3f0000
#define  SSP_SSP_SSPSP_SFRMWDTH_SHIFT 16
#define  SSP_SSP_SSPSP_SFRMWDTH_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_SFRMWDTH_MASK) >> SSP_SSP_SSPSP_SFRMWDTH_SHIFT)
#define  SSP_SSP_SSPSP_SFRMWDTH_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_SFRMWDTH_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_SFRMWDTH_SHIFT))

#define  SSP_SSP_SSPSP_SFRMDLY_MASK 0xfe00
#define  SSP_SSP_SSPSP_SFRMDLY_SHIFT 9
#define  SSP_SSP_SSPSP_SFRMDLY_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_SFRMDLY_MASK) >> SSP_SSP_SSPSP_SFRMDLY_SHIFT)
#define  SSP_SSP_SSPSP_SFRMDLY_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_SFRMDLY_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_SFRMDLY_SHIFT))

#define  SSP_SSP_SSPSP_DMYSTRT_MASK 0x180
#define  SSP_SSP_SSPSP_DMYSTRT_SHIFT 7
#define  SSP_SSP_SSPSP_DMYSTRT_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_DMYSTRT_MASK) >> SSP_SSP_SSPSP_DMYSTRT_SHIFT)
#define  SSP_SSP_SSPSP_DMYSTRT_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_DMYSTRT_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_DMYSTRT_SHIFT))

#define  SSP_SSP_SSPSP_STRTDLY_MASK 0x70
#define  SSP_SSP_SSPSP_STRTDLY_SHIFT 4
#define  SSP_SSP_SSPSP_STRTDLY_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_STRTDLY_MASK) >> SSP_SSP_SSPSP_STRTDLY_SHIFT)
#define  SSP_SSP_SSPSP_STRTDLY_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_STRTDLY_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_STRTDLY_SHIFT))

#define  SSP_SSP_SSPSP_ETDS_MASK 0x8
#define  SSP_SSP_SSPSP_ETDS_SHIFT 3
#define  SSP_SSP_SSPSP_ETDS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_ETDS_MASK) >> SSP_SSP_SSPSP_ETDS_SHIFT)
#define  SSP_SSP_SSPSP_ETDS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_ETDS_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_ETDS_SHIFT))

#define  SSP_SSP_SSPSP_SFRMP_MASK 0x4
#define  SSP_SSP_SSPSP_SFRMP_SHIFT 2
#define  SSP_SSP_SSPSP_SFRMP_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_SFRMP_MASK) >> SSP_SSP_SSPSP_SFRMP_SHIFT)
#define  SSP_SSP_SSPSP_SFRMP_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_SFRMP_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_SFRMP_SHIFT))

#define  SSP_SSP_SSPSP_SCMODE_MASK 0x3
#define  SSP_SSP_SSPSP_SCMODE_SHIFT 0
#define  SSP_SSP_SSPSP_SCMODE_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSPSP_SCMODE_MASK) >> SSP_SSP_SSPSP_SCMODE_SHIFT)
#define  SSP_SSP_SSPSP_SCMODE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSPSP_SCMODE_MASK) | (((uint32_t)val) << SSP_SSP_SSPSP_SCMODE_SHIFT))

//====================================================================
//Register: SSP TX Time Slot Active Register (SSP_SSTSA)
/** \brief These read-write registers are only used in network mode (<Mode> in SSP Control
Register 0 set), and they specify in which time slot the SSPx port transmits
data. See Network Mode (Example Using 4 Time Slots) figure for an example of the
use of time slots when in network mode.
The 8-bit <TX Time Slot Active> field specifies in which time slots the SSPx
port transmits data and in which time slots the SSPx port does NOT transmit
data. Bits beyond the <Frame Rate Divider Control> field in the SSP Control
Register 0 value are ignored (for example, if <Frame Rate Divider
Control> = 0x3, specifying that four time slots are used, then <TX Time Slot
Active> bits [7:4] are ignored). If the <TXD Three-State Enable> field in the
SSP Control Register 1 is set, the SSPx port three-states the SSPTXDx interface
output signal line during time slots that have associated TTSA bits programmed
to 0x0.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP_SSP_SSTSA_RESERVED1_MASK 0xffffff00
#define  SSP_SSP_SSTSA_RESERVED1_SHIFT 8
#define  SSP_SSP_SSTSA_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSTSA_RESERVED1_MASK) >> SSP_SSP_SSTSA_RESERVED1_SHIFT)
#define  SSP_SSP_SSTSA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSTSA_RESERVED1_MASK) | (((uint32_t)val) << SSP_SSP_SSTSA_RESERVED1_SHIFT))

#define  SSP_SSP_SSTSA_TTSA_MASK 0xff
#define  SSP_SSP_SSTSA_TTSA_SHIFT 0
#define  SSP_SSP_SSTSA_TTSA_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSTSA_TTSA_MASK) >> SSP_SSP_SSTSA_TTSA_SHIFT)
#define  SSP_SSP_SSTSA_TTSA_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSTSA_TTSA_MASK) | (((uint32_t)val) << SSP_SSP_SSTSA_TTSA_SHIFT))

//====================================================================
//Register: SSP RX Time Slot Active Register (SSP_SSRSA)
/** \brief These read-write registers are only used in network mode (<Mode> in SSP Control
Register 0 set), and they specify in which time slot the SSPx port receives
data. See Network Mode (Example Using 4 Time Slots) figure for an example of the
use of time slots when in network mode.
The 8-bit <RX Time Slot Active> field specifies in which time slots the SSPx
port receives data and in which time slots the SSPx port does not receive data.
Bits beyond the <Frame Rate Divider Control> field in the SSP Control Register 0
value are ignored. For example, if <Frame Rate Divider Control> = 0x3,
specifying that four time slots are used, then <RX Time Slot Active> bits [7:4]
are ignored.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP_SSP_SSRSA_RESERVED1_MASK 0xffffff00
#define  SSP_SSP_SSRSA_RESERVED1_SHIFT 8
#define  SSP_SSP_SSRSA_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSRSA_RESERVED1_MASK) >> SSP_SSP_SSRSA_RESERVED1_SHIFT)
#define  SSP_SSP_SSRSA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSRSA_RESERVED1_MASK) | (((uint32_t)val) << SSP_SSP_SSRSA_RESERVED1_SHIFT))

#define  SSP_SSP_SSRSA_RTSA_MASK 0xff
#define  SSP_SSP_SSRSA_RTSA_SHIFT 0
#define  SSP_SSP_SSRSA_RTSA_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSRSA_RTSA_MASK) >> SSP_SSP_SSRSA_RTSA_SHIFT)
#define  SSP_SSP_SSRSA_RTSA_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSRSA_RTSA_MASK) | (((uint32_t)val) << SSP_SSP_SSRSA_RTSA_SHIFT))

//====================================================================
//Register: SSP Time Slot Status Register (SSP_SSTSS)
/** \brief These read-only registers are only available when in network mode (<Mode> in SSP
Control Register 0 set), and they identify the time slot in which the SSPx port
is operating.
Write 0x0 to reserved bits, reads from reserved bits are undetermined.*/
//====================================================================

#define  SSP_SSP_SSTSS_NMBSY_MASK 0x80000000
#define  SSP_SSP_SSTSS_NMBSY_SHIFT 31
#define  SSP_SSP_SSTSS_NMBSY_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSTSS_NMBSY_MASK) >> SSP_SSP_SSTSS_NMBSY_SHIFT)
#define  SSP_SSP_SSTSS_NMBSY_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSTSS_NMBSY_MASK) | (((uint32_t)val) << SSP_SSP_SSTSS_NMBSY_SHIFT))

#define  SSP_SSP_SSTSS_RESERVED1_MASK 0x7ffffff8
#define  SSP_SSP_SSTSS_RESERVED1_SHIFT 3
#define  SSP_SSP_SSTSS_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSTSS_RESERVED1_MASK) >> SSP_SSP_SSTSS_RESERVED1_SHIFT)
#define  SSP_SSP_SSTSS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSTSS_RESERVED1_MASK) | (((uint32_t)val) << SSP_SSP_SSTSS_RESERVED1_SHIFT))

#define  SSP_SSP_SSTSS_TSS_MASK 0x7
#define  SSP_SSP_SSTSS_TSS_SHIFT 0
#define  SSP_SSP_SSTSS_TSS_MASK_SHIFT(reg) (((reg) & SSP_SSP_SSTSS_TSS_MASK) >> SSP_SSP_SSTSS_TSS_SHIFT)
#define  SSP_SSP_SSTSS_TSS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SSTSS_TSS_MASK) | (((uint32_t)val) << SSP_SSP_SSTSS_TSS_SHIFT))

//====================================================================
//Register: GPS Controller ID Register (SSP_GPS_ID)
//====================================================================

#define  SSP_SSP_GPS_ID_GPS_ID_MASK 0xffffffff
#define  SSP_SSP_GPS_ID_GPS_ID_SHIFT 0
#define  SSP_SSP_GPS_ID_GPS_ID_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_ID_GPS_ID_MASK) >> SSP_SSP_GPS_ID_GPS_ID_SHIFT)
#define  SSP_SSP_GPS_ID_GPS_ID_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_ID_GPS_ID_MASK) | (((uint32_t)val) << SSP_SSP_GPS_ID_GPS_ID_SHIFT))

//====================================================================
//Register: GPS Control and Status Register (SSP_GPS_CSR)
//====================================================================

#define  SSP_SSP_GPS_CSR_RESERVED1_MASK 0xffffe000
#define  SSP_SSP_GPS_CSR_RESERVED1_SHIFT 13
#define  SSP_SSP_GPS_CSR_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_CSR_RESERVED1_MASK) >> SSP_SSP_GPS_CSR_RESERVED1_SHIFT)
#define  SSP_SSP_GPS_CSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_CSR_RESERVED1_MASK) | (((uint32_t)val) << SSP_SSP_GPS_CSR_RESERVED1_SHIFT))

#define  SSP_SSP_GPS_CSR_LSB_1ST_MASK 0x1000
#define  SSP_SSP_GPS_CSR_LSB_1ST_SHIFT 12
#define  SSP_SSP_GPS_CSR_LSB_1ST_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_CSR_LSB_1ST_MASK) >> SSP_SSP_GPS_CSR_LSB_1ST_SHIFT)
#define  SSP_SSP_GPS_CSR_LSB_1ST_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_CSR_LSB_1ST_MASK) | (((uint32_t)val) << SSP_SSP_GPS_CSR_LSB_1ST_SHIFT))

#define  SSP_SSP_GPS_CSR_SERCLK_FEDGE_MASK 0x800
#define  SSP_SSP_GPS_CSR_SERCLK_FEDGE_SHIFT 11
#define  SSP_SSP_GPS_CSR_SERCLK_FEDGE_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_CSR_SERCLK_FEDGE_MASK) >> SSP_SSP_GPS_CSR_SERCLK_FEDGE_SHIFT)
#define  SSP_SSP_GPS_CSR_SERCLK_FEDGE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_CSR_SERCLK_FEDGE_MASK) | (((uint32_t)val) << SSP_SSP_GPS_CSR_SERCLK_FEDGE_SHIFT))

#define  SSP_SSP_GPS_CSR_FS_SEL1_0_MASK 0x600
#define  SSP_SSP_GPS_CSR_FS_SEL1_0_SHIFT 9
#define  SSP_SSP_GPS_CSR_FS_SEL1_0_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_CSR_FS_SEL1_0_MASK) >> SSP_SSP_GPS_CSR_FS_SEL1_0_SHIFT)
#define  SSP_SSP_GPS_CSR_FS_SEL1_0_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_CSR_FS_SEL1_0_MASK) | (((uint32_t)val) << SSP_SSP_GPS_CSR_FS_SEL1_0_SHIFT))

#define  SSP_SSP_GPS_CSR_MAX_STRMBITS_MASK 0x180
#define  SSP_SSP_GPS_CSR_MAX_STRMBITS_SHIFT 7
#define  SSP_SSP_GPS_CSR_MAX_STRMBITS_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_CSR_MAX_STRMBITS_MASK) >> SSP_SSP_GPS_CSR_MAX_STRMBITS_SHIFT)
#define  SSP_SSP_GPS_CSR_MAX_STRMBITS_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_CSR_MAX_STRMBITS_MASK) | (((uint32_t)val) << SSP_SSP_GPS_CSR_MAX_STRMBITS_SHIFT))

#define  SSP_SSP_GPS_CSR_GPS_TYPE_MASK 0x70
#define  SSP_SSP_GPS_CSR_GPS_TYPE_SHIFT 4
#define  SSP_SSP_GPS_CSR_GPS_TYPE_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_CSR_GPS_TYPE_MASK) >> SSP_SSP_GPS_CSR_GPS_TYPE_SHIFT)
#define  SSP_SSP_GPS_CSR_GPS_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_CSR_GPS_TYPE_MASK) | (((uint32_t)val) << SSP_SSP_GPS_CSR_GPS_TYPE_SHIFT))

#define  SSP_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK 0x8
#define  SSP_SSP_GPS_CSR_TSYNC_COUNT_RST_SHIFT 3
#define  SSP_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK) >> SSP_SSP_GPS_CSR_TSYNC_COUNT_RST_SHIFT)
#define  SSP_SSP_GPS_CSR_TSYNC_COUNT_RST_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_CSR_TSYNC_COUNT_RST_MASK) | (((uint32_t)val) << SSP_SSP_GPS_CSR_TSYNC_COUNT_RST_SHIFT))

#define  SSP_SSP_GPS_CSR_SOFT_RESET_MASK 0x4
#define  SSP_SSP_GPS_CSR_SOFT_RESET_SHIFT 2
#define  SSP_SSP_GPS_CSR_SOFT_RESET_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_CSR_SOFT_RESET_MASK) >> SSP_SSP_GPS_CSR_SOFT_RESET_SHIFT)
#define  SSP_SSP_GPS_CSR_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_CSR_SOFT_RESET_MASK) | (((uint32_t)val) << SSP_SSP_GPS_CSR_SOFT_RESET_SHIFT))

#define  SSP_SSP_GPS_CSR_GPS_ON_MASK 0x2
#define  SSP_SSP_GPS_CSR_GPS_ON_SHIFT 1
#define  SSP_SSP_GPS_CSR_GPS_ON_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_CSR_GPS_ON_MASK) >> SSP_SSP_GPS_CSR_GPS_ON_SHIFT)
#define  SSP_SSP_GPS_CSR_GPS_ON_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_CSR_GPS_ON_MASK) | (((uint32_t)val) << SSP_SSP_GPS_CSR_GPS_ON_SHIFT))

#define  SSP_SSP_GPS_CSR_GPS_MODE_MASK 0x1
#define  SSP_SSP_GPS_CSR_GPS_MODE_SHIFT 0
#define  SSP_SSP_GPS_CSR_GPS_MODE_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_CSR_GPS_MODE_MASK) >> SSP_SSP_GPS_CSR_GPS_MODE_SHIFT)
#define  SSP_SSP_GPS_CSR_GPS_MODE_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_CSR_GPS_MODE_MASK) | (((uint32_t)val) << SSP_SSP_GPS_CSR_GPS_MODE_SHIFT))

//====================================================================
//Register: Time Sync Count Register (SSP_GPS_TSCNT)
/** \brief This is the counter that is used to increment at each TIME_SYNC rising edge of
MAX2769.*/
//====================================================================

#define  SSP_SSP_GPS_TSCNT_GPS_TSCNT_MASK 0xffffffff
#define  SSP_SSP_GPS_TSCNT_GPS_TSCNT_SHIFT 0
#define  SSP_SSP_GPS_TSCNT_GPS_TSCNT_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_TSCNT_GPS_TSCNT_MASK) >> SSP_SSP_GPS_TSCNT_GPS_TSCNT_SHIFT)
#define  SSP_SSP_GPS_TSCNT_GPS_TSCNT_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_TSCNT_GPS_TSCNT_MASK) | (((uint32_t)val) << SSP_SSP_GPS_TSCNT_GPS_TSCNT_SHIFT))

//====================================================================
//Register: Time Sync Count Adjust Register (SSP_GPS_TSCNT_ADJ)
/** \brief This register is updated with the contents of the Time Sync Count Register
whenever the Rx FIFO is read by the system. DMA access should read this
register. This register is adjusted to eliminate DMA delay.*/
//====================================================================

#define  SSP_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK 0xffffffff
#define  SSP_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_SHIFT 0
#define  SSP_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK_SHIFT(reg) (((reg) & SSP_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK) >> SSP_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_SHIFT)
#define  SSP_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_MASK) | (((uint32_t)val) << SSP_SSP_GPS_TSCNT_ADJ_GPS_TSCNT_ADJ_SHIFT))

//====================================================================
//Register: Modified SPI Mode Register (SSP_SPI_MOD)
/** \brief This is the register holding the enable bit for modified SPI.*/
//====================================================================

#define  SSP_SSP_SPI_MOD_RESERVED1_MASK 0xfffffffe
#define  SSP_SSP_SPI_MOD_RESERVED1_SHIFT 1
#define  SSP_SSP_SPI_MOD_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_SSP_SPI_MOD_RESERVED1_MASK) >> SSP_SSP_SPI_MOD_RESERVED1_SHIFT)
#define  SSP_SSP_SPI_MOD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SPI_MOD_RESERVED1_MASK) | (((uint32_t)val) << SSP_SSP_SPI_MOD_RESERVED1_SHIFT))

#define  SSP_SSP_SPI_MOD_SPI_MOD_MASK 0x1
#define  SSP_SSP_SPI_MOD_SPI_MOD_SHIFT 0
#define  SSP_SSP_SPI_MOD_SPI_MOD_MASK_SHIFT(reg) (((reg) & SSP_SSP_SPI_MOD_SPI_MOD_MASK) >> SSP_SSP_SPI_MOD_SPI_MOD_SHIFT)
#define  SSP_SSP_SPI_MOD_SPI_MOD_REPLACE_VAL(reg,val) (((reg) & ~SSP_SSP_SPI_MOD_SPI_MOD_MASK) | (((uint32_t)val) << SSP_SSP_SPI_MOD_SPI_MOD_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  SSP_REV0_MAJ_MASK 0xffff0000
#define  SSP_REV0_MAJ_SHIFT 16
#define  SSP_REV0_MAJ_MASK_SHIFT(reg) (((reg) & SSP_REV0_MAJ_MASK) >> SSP_REV0_MAJ_SHIFT)
#define  SSP_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SSP_REV0_MAJ_MASK) | (((uint32_t)val) << SSP_REV0_MAJ_SHIFT))

#define  SSP_REV0_MID_MASK 0xffff
#define  SSP_REV0_MID_SHIFT 0
#define  SSP_REV0_MID_MASK_SHIFT(reg) (((reg) & SSP_REV0_MID_MASK) >> SSP_REV0_MID_SHIFT)
#define  SSP_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~SSP_REV0_MID_MASK) | (((uint32_t)val) << SSP_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  SSP_REV1_RESERVED1_MASK 0xffff0000
#define  SSP_REV1_RESERVED1_SHIFT 16
#define  SSP_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & SSP_REV1_RESERVED1_MASK) >> SSP_REV1_RESERVED1_SHIFT)
#define  SSP_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSP_REV1_RESERVED1_MASK) | (((uint32_t)val) << SSP_REV1_RESERVED1_SHIFT))

#define  SSP_REV1_CFG_MASK 0xffff
#define  SSP_REV1_CFG_SHIFT 0
#define  SSP_REV1_CFG_MASK_SHIFT(reg) (((reg) & SSP_REV1_CFG_MASK) >> SSP_REV1_CFG_SHIFT)
#define  SSP_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~SSP_REV1_CFG_MASK) | (((uint32_t)val) << SSP_REV1_CFG_SHIFT))

#endif // SSP
