 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file ips_apb_config_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _IPS_APB_CONFIG_REGMASKS_H_
#define _IPS_APB_CONFIG_REGMASKS_H_

#include <stdint.h>

//====================================================================
//
//Register File: Chip configuration registers (IPS_APB_config)
/** \brief Configuration registers contained in IPS_APB_config.v*/
//
//====================================================================

//====================================================================
//Register: JBIG Tagging Revision 0 (JBIG_REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  IPS_APB_CONFIG_JBIG_REV0_MAJ_MASK 0xffff0000
#define  IPS_APB_CONFIG_JBIG_REV0_MAJ_SHIFT 16
#define  IPS_APB_CONFIG_JBIG_REV0_MAJ_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_JBIG_REV0_MAJ_MASK) >> IPS_APB_CONFIG_JBIG_REV0_MAJ_SHIFT)
#define  IPS_APB_CONFIG_JBIG_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_JBIG_REV0_MAJ_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_JBIG_REV0_MAJ_SHIFT))

#define  IPS_APB_CONFIG_JBIG_REV0_MID_MASK 0xffff
#define  IPS_APB_CONFIG_JBIG_REV0_MID_SHIFT 0
#define  IPS_APB_CONFIG_JBIG_REV0_MID_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_JBIG_REV0_MID_MASK) >> IPS_APB_CONFIG_JBIG_REV0_MID_SHIFT)
#define  IPS_APB_CONFIG_JBIG_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_JBIG_REV0_MID_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_JBIG_REV0_MID_SHIFT))

//====================================================================
//Register: JBIG Tagging Revision 1 (JBIG_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  IPS_APB_CONFIG_JBIG_REV1_RESERVED1_MASK 0xffff0000
#define  IPS_APB_CONFIG_JBIG_REV1_RESERVED1_SHIFT 16
#define  IPS_APB_CONFIG_JBIG_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_JBIG_REV1_RESERVED1_MASK) >> IPS_APB_CONFIG_JBIG_REV1_RESERVED1_SHIFT)
#define  IPS_APB_CONFIG_JBIG_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_JBIG_REV1_RESERVED1_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_JBIG_REV1_RESERVED1_SHIFT))

#define  IPS_APB_CONFIG_JBIG_REV1_CFG_MASK 0xffff
#define  IPS_APB_CONFIG_JBIG_REV1_CFG_SHIFT 0
#define  IPS_APB_CONFIG_JBIG_REV1_CFG_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_JBIG_REV1_CFG_MASK) >> IPS_APB_CONFIG_JBIG_REV1_CFG_SHIFT)
#define  IPS_APB_CONFIG_JBIG_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_JBIG_REV1_CFG_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_JBIG_REV1_CFG_SHIFT))

//====================================================================
//Register: Optional Feature Control Register (OFCR)
/** \brief This register allows firmware control of feature options. If a feature is
  disables via an efuse bit, then it is not affected by this register.*/
//====================================================================

#define  IPS_APB_CONFIG_OFCR_RESERVED1_MASK 0xfe000000
#define  IPS_APB_CONFIG_OFCR_RESERVED1_SHIFT 25
#define  IPS_APB_CONFIG_OFCR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_RESERVED1_MASK) >> IPS_APB_CONFIG_OFCR_RESERVED1_SHIFT)
#define  IPS_APB_CONFIG_OFCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_RESERVED1_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_RESERVED1_SHIFT))

#define  IPS_APB_CONFIG_OFCR_GC_DISABLE_MASK 0x1000000
#define  IPS_APB_CONFIG_OFCR_GC_DISABLE_SHIFT 24
#define  IPS_APB_CONFIG_OFCR_GC_DISABLE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_GC_DISABLE_MASK) >> IPS_APB_CONFIG_OFCR_GC_DISABLE_SHIFT)
#define  IPS_APB_CONFIG_OFCR_GC_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_GC_DISABLE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_GC_DISABLE_SHIFT))

#define  IPS_APB_CONFIG_OFCR_CPU3_DISABLE_MASK 0x800000
#define  IPS_APB_CONFIG_OFCR_CPU3_DISABLE_SHIFT 23
#define  IPS_APB_CONFIG_OFCR_CPU3_DISABLE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_CPU3_DISABLE_MASK) >> IPS_APB_CONFIG_OFCR_CPU3_DISABLE_SHIFT)
#define  IPS_APB_CONFIG_OFCR_CPU3_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_CPU3_DISABLE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_CPU3_DISABLE_SHIFT))

#define  IPS_APB_CONFIG_OFCR_CPU2_DISABLE_MASK 0x400000
#define  IPS_APB_CONFIG_OFCR_CPU2_DISABLE_SHIFT 22
#define  IPS_APB_CONFIG_OFCR_CPU2_DISABLE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_CPU2_DISABLE_MASK) >> IPS_APB_CONFIG_OFCR_CPU2_DISABLE_SHIFT)
#define  IPS_APB_CONFIG_OFCR_CPU2_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_CPU2_DISABLE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_CPU2_DISABLE_SHIFT))

#define  IPS_APB_CONFIG_OFCR_CPU1_DISABLE_MASK 0x200000
#define  IPS_APB_CONFIG_OFCR_CPU1_DISABLE_SHIFT 21
#define  IPS_APB_CONFIG_OFCR_CPU1_DISABLE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_CPU1_DISABLE_MASK) >> IPS_APB_CONFIG_OFCR_CPU1_DISABLE_SHIFT)
#define  IPS_APB_CONFIG_OFCR_CPU1_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_CPU1_DISABLE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_CPU1_DISABLE_SHIFT))

#define  IPS_APB_CONFIG_OFCR_CPU_FREQ_MASK 0x100000
#define  IPS_APB_CONFIG_OFCR_CPU_FREQ_SHIFT 20
#define  IPS_APB_CONFIG_OFCR_CPU_FREQ_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_CPU_FREQ_MASK) >> IPS_APB_CONFIG_OFCR_CPU_FREQ_SHIFT)
#define  IPS_APB_CONFIG_OFCR_CPU_FREQ_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_CPU_FREQ_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_CPU_FREQ_SHIFT))

#define  IPS_APB_CONFIG_OFCR_DDR_BUSWIDTH_MASK 0x80000
#define  IPS_APB_CONFIG_OFCR_DDR_BUSWIDTH_SHIFT 19
#define  IPS_APB_CONFIG_OFCR_DDR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_DDR_BUSWIDTH_MASK) >> IPS_APB_CONFIG_OFCR_DDR_BUSWIDTH_SHIFT)
#define  IPS_APB_CONFIG_OFCR_DDR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_DDR_BUSWIDTH_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_DDR_BUSWIDTH_SHIFT))

#define  IPS_APB_CONFIG_OFCR_ICE_MASK 0x40000
#define  IPS_APB_CONFIG_OFCR_ICE_SHIFT 18
#define  IPS_APB_CONFIG_OFCR_ICE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_ICE_MASK) >> IPS_APB_CONFIG_OFCR_ICE_SHIFT)
#define  IPS_APB_CONFIG_OFCR_ICE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_ICE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_ICE_SHIFT))

#define  IPS_APB_CONFIG_OFCR_RESERVED2_MASK 0x3f000
#define  IPS_APB_CONFIG_OFCR_RESERVED2_SHIFT 12
#define  IPS_APB_CONFIG_OFCR_RESERVED2_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_RESERVED2_MASK) >> IPS_APB_CONFIG_OFCR_RESERVED2_SHIFT)
#define  IPS_APB_CONFIG_OFCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_RESERVED2_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_RESERVED2_SHIFT))

#define  IPS_APB_CONFIG_OFCR_RESERVE_LVDSAFE_MASK 0x800
#define  IPS_APB_CONFIG_OFCR_RESERVE_LVDSAFE_SHIFT 11
#define  IPS_APB_CONFIG_OFCR_RESERVE_LVDSAFE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_RESERVE_LVDSAFE_MASK) >> IPS_APB_CONFIG_OFCR_RESERVE_LVDSAFE_SHIFT)
#define  IPS_APB_CONFIG_OFCR_RESERVE_LVDSAFE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_RESERVE_LVDSAFE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_RESERVE_LVDSAFE_SHIFT))

#define  IPS_APB_CONFIG_OFCR_LASER_VIDEOCHAN_MASK 0x7f8
#define  IPS_APB_CONFIG_OFCR_LASER_VIDEOCHAN_SHIFT 3
#define  IPS_APB_CONFIG_OFCR_LASER_VIDEOCHAN_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_LASER_VIDEOCHAN_MASK) >> IPS_APB_CONFIG_OFCR_LASER_VIDEOCHAN_SHIFT)
#define  IPS_APB_CONFIG_OFCR_LASER_VIDEOCHAN_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_LASER_VIDEOCHAN_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_LASER_VIDEOCHAN_SHIFT))

#define  IPS_APB_CONFIG_OFCR_INK_PENCONTROL_MASK 0x4
#define  IPS_APB_CONFIG_OFCR_INK_PENCONTROL_SHIFT 2
#define  IPS_APB_CONFIG_OFCR_INK_PENCONTROL_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_INK_PENCONTROL_MASK) >> IPS_APB_CONFIG_OFCR_INK_PENCONTROL_SHIFT)
#define  IPS_APB_CONFIG_OFCR_INK_PENCONTROL_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_INK_PENCONTROL_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_INK_PENCONTROL_SHIFT))

#define  IPS_APB_CONFIG_OFCR_RESERVED3_MASK 0x2
#define  IPS_APB_CONFIG_OFCR_RESERVED3_SHIFT 1
#define  IPS_APB_CONFIG_OFCR_RESERVED3_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_RESERVED3_MASK) >> IPS_APB_CONFIG_OFCR_RESERVED3_SHIFT)
#define  IPS_APB_CONFIG_OFCR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_RESERVED3_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_RESERVED3_SHIFT))

#define  IPS_APB_CONFIG_OFCR_TAC_TOP_MASK 0x1
#define  IPS_APB_CONFIG_OFCR_TAC_TOP_SHIFT 0
#define  IPS_APB_CONFIG_OFCR_TAC_TOP_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFCR_TAC_TOP_MASK) >> IPS_APB_CONFIG_OFCR_TAC_TOP_SHIFT)
#define  IPS_APB_CONFIG_OFCR_TAC_TOP_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFCR_TAC_TOP_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFCR_TAC_TOP_SHIFT))

//====================================================================
//Register: Optional Feature Status Register (OFSR)
/** \brief This register indicates the status of the optional features as set via the efuse bits or
       the OFCR Register bits. Note that the efuse bits take precedence over the OFCR Register bits.*/
//====================================================================

#define  IPS_APB_CONFIG_OFSR_RESERVED1_MASK 0xfe000000
#define  IPS_APB_CONFIG_OFSR_RESERVED1_SHIFT 25
#define  IPS_APB_CONFIG_OFSR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_RESERVED1_MASK) >> IPS_APB_CONFIG_OFSR_RESERVED1_SHIFT)
#define  IPS_APB_CONFIG_OFSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_RESERVED1_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_RESERVED1_SHIFT))

#define  IPS_APB_CONFIG_OFSR_GC_DISABLE_MASK 0x1000000
#define  IPS_APB_CONFIG_OFSR_GC_DISABLE_SHIFT 24
#define  IPS_APB_CONFIG_OFSR_GC_DISABLE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_GC_DISABLE_MASK) >> IPS_APB_CONFIG_OFSR_GC_DISABLE_SHIFT)
#define  IPS_APB_CONFIG_OFSR_GC_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_GC_DISABLE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_GC_DISABLE_SHIFT))

#define  IPS_APB_CONFIG_OFSR_CPU3_DISABLE_MASK 0x800000
#define  IPS_APB_CONFIG_OFSR_CPU3_DISABLE_SHIFT 23
#define  IPS_APB_CONFIG_OFSR_CPU3_DISABLE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_CPU3_DISABLE_MASK) >> IPS_APB_CONFIG_OFSR_CPU3_DISABLE_SHIFT)
#define  IPS_APB_CONFIG_OFSR_CPU3_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_CPU3_DISABLE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_CPU3_DISABLE_SHIFT))

#define  IPS_APB_CONFIG_OFSR_CPU2_DISABLE_MASK 0x400000
#define  IPS_APB_CONFIG_OFSR_CPU2_DISABLE_SHIFT 22
#define  IPS_APB_CONFIG_OFSR_CPU2_DISABLE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_CPU2_DISABLE_MASK) >> IPS_APB_CONFIG_OFSR_CPU2_DISABLE_SHIFT)
#define  IPS_APB_CONFIG_OFSR_CPU2_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_CPU2_DISABLE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_CPU2_DISABLE_SHIFT))

#define  IPS_APB_CONFIG_OFSR_CPU1_DISABLE_MASK 0x200000
#define  IPS_APB_CONFIG_OFSR_CPU1_DISABLE_SHIFT 21
#define  IPS_APB_CONFIG_OFSR_CPU1_DISABLE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_CPU1_DISABLE_MASK) >> IPS_APB_CONFIG_OFSR_CPU1_DISABLE_SHIFT)
#define  IPS_APB_CONFIG_OFSR_CPU1_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_CPU1_DISABLE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_CPU1_DISABLE_SHIFT))

#define  IPS_APB_CONFIG_OFSR_CPU_FREQ_MASK 0x100000
#define  IPS_APB_CONFIG_OFSR_CPU_FREQ_SHIFT 20
#define  IPS_APB_CONFIG_OFSR_CPU_FREQ_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_CPU_FREQ_MASK) >> IPS_APB_CONFIG_OFSR_CPU_FREQ_SHIFT)
#define  IPS_APB_CONFIG_OFSR_CPU_FREQ_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_CPU_FREQ_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_CPU_FREQ_SHIFT))

#define  IPS_APB_CONFIG_OFSR_DDR_BUSWIDTH_MASK 0x80000
#define  IPS_APB_CONFIG_OFSR_DDR_BUSWIDTH_SHIFT 19
#define  IPS_APB_CONFIG_OFSR_DDR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_DDR_BUSWIDTH_MASK) >> IPS_APB_CONFIG_OFSR_DDR_BUSWIDTH_SHIFT)
#define  IPS_APB_CONFIG_OFSR_DDR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_DDR_BUSWIDTH_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_DDR_BUSWIDTH_SHIFT))

#define  IPS_APB_CONFIG_OFSR_ICE_MASK 0x40000
#define  IPS_APB_CONFIG_OFSR_ICE_SHIFT 18
#define  IPS_APB_CONFIG_OFSR_ICE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_ICE_MASK) >> IPS_APB_CONFIG_OFSR_ICE_SHIFT)
#define  IPS_APB_CONFIG_OFSR_ICE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_ICE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_ICE_SHIFT))

#define  IPS_APB_CONFIG_OFSR_RESERVED2_MASK 0x3f000
#define  IPS_APB_CONFIG_OFSR_RESERVED2_SHIFT 12
#define  IPS_APB_CONFIG_OFSR_RESERVED2_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_RESERVED2_MASK) >> IPS_APB_CONFIG_OFSR_RESERVED2_SHIFT)
#define  IPS_APB_CONFIG_OFSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_RESERVED2_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_RESERVED2_SHIFT))

#define  IPS_APB_CONFIG_OFSR_RESERVE_LVDSAFE_MASK 0x800
#define  IPS_APB_CONFIG_OFSR_RESERVE_LVDSAFE_SHIFT 11
#define  IPS_APB_CONFIG_OFSR_RESERVE_LVDSAFE_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_RESERVE_LVDSAFE_MASK) >> IPS_APB_CONFIG_OFSR_RESERVE_LVDSAFE_SHIFT)
#define  IPS_APB_CONFIG_OFSR_RESERVE_LVDSAFE_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_RESERVE_LVDSAFE_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_RESERVE_LVDSAFE_SHIFT))

#define  IPS_APB_CONFIG_OFSR_LASER_VIDEOCHAN_MASK 0x7f8
#define  IPS_APB_CONFIG_OFSR_LASER_VIDEOCHAN_SHIFT 3
#define  IPS_APB_CONFIG_OFSR_LASER_VIDEOCHAN_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_LASER_VIDEOCHAN_MASK) >> IPS_APB_CONFIG_OFSR_LASER_VIDEOCHAN_SHIFT)
#define  IPS_APB_CONFIG_OFSR_LASER_VIDEOCHAN_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_LASER_VIDEOCHAN_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_LASER_VIDEOCHAN_SHIFT))

#define  IPS_APB_CONFIG_OFSR_INK_PENCONTROL_MASK 0x4
#define  IPS_APB_CONFIG_OFSR_INK_PENCONTROL_SHIFT 2
#define  IPS_APB_CONFIG_OFSR_INK_PENCONTROL_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_INK_PENCONTROL_MASK) >> IPS_APB_CONFIG_OFSR_INK_PENCONTROL_SHIFT)
#define  IPS_APB_CONFIG_OFSR_INK_PENCONTROL_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_INK_PENCONTROL_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_INK_PENCONTROL_SHIFT))

#define  IPS_APB_CONFIG_OFSR_RESERVED3_MASK 0x2
#define  IPS_APB_CONFIG_OFSR_RESERVED3_SHIFT 1
#define  IPS_APB_CONFIG_OFSR_RESERVED3_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_RESERVED3_MASK) >> IPS_APB_CONFIG_OFSR_RESERVED3_SHIFT)
#define  IPS_APB_CONFIG_OFSR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_RESERVED3_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_RESERVED3_SHIFT))

#define  IPS_APB_CONFIG_OFSR_TAC_TOP_MASK 0x1
#define  IPS_APB_CONFIG_OFSR_TAC_TOP_SHIFT 0
#define  IPS_APB_CONFIG_OFSR_TAC_TOP_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_OFSR_TAC_TOP_MASK) >> IPS_APB_CONFIG_OFSR_TAC_TOP_SHIFT)
#define  IPS_APB_CONFIG_OFSR_TAC_TOP_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_OFSR_TAC_TOP_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_OFSR_TAC_TOP_SHIFT))

//====================================================================
//Register: DB Mux Control (AMC)
/** \brief This register contains muxing control bits for DB.*/
//====================================================================

#define  IPS_APB_CONFIG_AMC_RESERVED1_MASK 0xffffff00
#define  IPS_APB_CONFIG_AMC_RESERVED1_SHIFT 8
#define  IPS_APB_CONFIG_AMC_RESERVED1_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_AMC_RESERVED1_MASK) >> IPS_APB_CONFIG_AMC_RESERVED1_SHIFT)
#define  IPS_APB_CONFIG_AMC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_AMC_RESERVED1_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_AMC_RESERVED1_SHIFT))

#define  IPS_APB_CONFIG_AMC_AMC_TBD_MASK 0xf8
#define  IPS_APB_CONFIG_AMC_AMC_TBD_SHIFT 3
#define  IPS_APB_CONFIG_AMC_AMC_TBD_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_AMC_AMC_TBD_MASK) >> IPS_APB_CONFIG_AMC_AMC_TBD_SHIFT)
#define  IPS_APB_CONFIG_AMC_AMC_TBD_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_AMC_AMC_TBD_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_AMC_AMC_TBD_SHIFT))

#define  IPS_APB_CONFIG_AMC_AMC_SEL_MASK 0x7
#define  IPS_APB_CONFIG_AMC_AMC_SEL_SHIFT 0
#define  IPS_APB_CONFIG_AMC_AMC_SEL_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_AMC_AMC_SEL_MASK) >> IPS_APB_CONFIG_AMC_AMC_SEL_SHIFT)
#define  IPS_APB_CONFIG_AMC_AMC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_AMC_AMC_SEL_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_AMC_AMC_SEL_SHIFT))

//====================================================================
//Register: Miscellaneous Feature Control (MFC)
/** \brief This register is a location for other miscellaneous control bits.*/
//====================================================================

#define  IPS_APB_CONFIG_MFC_RESERVED1_MASK 0xffffff00
#define  IPS_APB_CONFIG_MFC_RESERVED1_SHIFT 8
#define  IPS_APB_CONFIG_MFC_RESERVED1_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_MFC_RESERVED1_MASK) >> IPS_APB_CONFIG_MFC_RESERVED1_SHIFT)
#define  IPS_APB_CONFIG_MFC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_MFC_RESERVED1_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_MFC_RESERVED1_SHIFT))

#define  IPS_APB_CONFIG_MFC_RS_MASK 0xf0
#define  IPS_APB_CONFIG_MFC_RS_SHIFT 4
#define  IPS_APB_CONFIG_MFC_RS_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_MFC_RS_MASK) >> IPS_APB_CONFIG_MFC_RS_SHIFT)
#define  IPS_APB_CONFIG_MFC_RS_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_MFC_RS_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_MFC_RS_SHIFT))

#define  IPS_APB_CONFIG_MFC_DUR_MASK 0x8
#define  IPS_APB_CONFIG_MFC_DUR_SHIFT 3
#define  IPS_APB_CONFIG_MFC_DUR_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_MFC_DUR_MASK) >> IPS_APB_CONFIG_MFC_DUR_SHIFT)
#define  IPS_APB_CONFIG_MFC_DUR_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_MFC_DUR_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_MFC_DUR_SHIFT))

#define  IPS_APB_CONFIG_MFC_UES_MASK 0x7
#define  IPS_APB_CONFIG_MFC_UES_SHIFT 0
#define  IPS_APB_CONFIG_MFC_UES_MASK_SHIFT(reg) (((reg) & IPS_APB_CONFIG_MFC_UES_MASK) >> IPS_APB_CONFIG_MFC_UES_SHIFT)
#define  IPS_APB_CONFIG_MFC_UES_REPLACE_VAL(reg,val) (((reg) & ~IPS_APB_CONFIG_MFC_UES_MASK) | (((uint32_t)val) << IPS_APB_CONFIG_MFC_UES_SHIFT))

#endif // IPS_APB_CONFIG
