 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 */
/**
      \file INTNUMS.H

      Defines for the interrupt numbers for the main processor
      */

#ifndef __INTNUMS_H__
#define __INTNUMS_H__


#ifdef __cplusplus
extern "C" {
#endif


// Interrupt state defines
#define IRQ_ENABLED 0
#define IRQ_DISABLED 1
 
/*
	Interrupts on the GIC
*/


/*	The GIC has 32 internal Interrupts.  Reserve them and start our external ones from that point on.*/
#define INTRL_GIC_OFFSET						(32)

#define INTNUM_SSP1_INT_REQ_SSP1            	(  0 + INTRL_GIC_OFFSET)		//ssp1_int_req (SSP1)(APB_TOP)
#define INTNUM_SSP2_INT_REQ_SSP2            	(  1 + INTRL_GIC_OFFSET)		//ssp2_int_req (SSP2) (APB_TOP)
#define INTNUM_CORE_CSSCG                   	(  2 + INTRL_GIC_OFFSET)		//CORE_CSSCG(From MPMU)
#define INTNUM_DDR_CSSCG                    	(  3 + INTRL_GIC_OFFSET)		//DDR_CSSCG(From MPMU)
#define INTNUM_SCAN_CSSCG                   	(  4 + INTRL_GIC_OFFSET)		//SCAN_CSSCG (from MPMU)
#define INTNUM_MPMU_IRQ                     	(  5 + INTRL_GIC_OFFSET)		//MPMU_IRQ (From MPMU)
#define INTNUM_APMU_IRQ                     	(  6 + INTRL_GIC_OFFSET)		//APMU_IRQ (From APMU)
#define INTNUM_TWSI1_INT_I2C_APB_TOP        	(  7 + INTRL_GIC_OFFSET)		//twsi1_int (I2C-APB_TOP)
#define INTNUM_DMA_CHANNEL_INT              	(  8 + INTRL_GIC_OFFSET)		//|dma_channel_int
#define INTNUM_ONEWIRE_INT                  	(  9 + INTRL_GIC_OFFSET)		//onewire_int (APB_TOP)
#define INTNUM_TIMER_1_IRQ                  	( 10 + INTRL_GIC_OFFSET)		//timer_1_irq(APB_AON)
#define INTNUM_TIMER_2_IRQ                  	( 11 + INTRL_GIC_OFFSET)		//timer_2_irq(APB_AON)
#define INTNUM_TIMER_3_IRQ                  	( 12 + INTRL_GIC_OFFSET)		//timer_3_irq(APB_AON)
#define INTNUM_IPC0_WAKEUP                  	( 13 + INTRL_GIC_OFFSET)		//ipc0_wakeup(APB_AON)
#define INTNUM_SSP3_INT_REQ_SSP3            	( 14 + INTRL_GIC_OFFSET)		//ssp3_int_req (SSP3)(APB_TOP)
#define INTNUM_LAN_GMAC_INT                 	( 15 + INTRL_GIC_OFFSET)		//lan_gmac_int
#define INTNUM_UART_INT_UART1               	( 16 + INTRL_GIC_OFFSET)		//uart_int (UART1)(APB_AON)
#define INTNUM_UART_INT_UART2               	( 17 + INTRL_GIC_OFFSET)		//uart_int (UART2)(APB_AON)
#define INTNUM_UART_INT_UART3               	( 18 + INTRL_GIC_OFFSET)		//uart_int (UART3)(APB_AON)
#define INTNUM_UART_INT_UART4               	( 19 + INTRL_GIC_OFFSET)		//uart_int (UART4)(APB_AON)
#define INTNUM_DM2_PCIE_IRQ                 	( 20 + INTRL_GIC_OFFSET)		//Dm2_PCIe_IRQ
#define INTNUM_DM4_PCIE_IRQ                 	( 21 + INTRL_GIC_OFFSET)		//Dm4_PCIe_IRQ
#define INTNUM_AP_SCCP_IRQ                  	( 22 + INTRL_GIC_OFFSET)		//AP_SCCP_IRQ
#define INTNUM_WDT_IRQ_WATCH_DOG_TIMER      	( 23 + INTRL_GIC_OFFSET)		//wdt_irq (Watch Dog Timer)(APB_AON-No Reset)
#define INTNUM_NDSMC_DMA_INTR               	( 24 + INTRL_GIC_OFFSET)		//ndsmc_dma_intr
#define INTNUM_MMC1_INT_SEPERATED           	( 25 + INTRL_GIC_OFFSET)		//mmc1_int | sdh2icu_wakeup_int1
#define INTNUM_SDH2ICU_WAKEUP_INT1_SEPERATED	( 25 + INTRL_GIC_OFFSET)		//mmc1_int | sdh2icu_wakeup_int1
#define INTNUM_MMC1_INT_OR_SDH2ICU_WAKEUP_INT1	( 25 + INTRL_GIC_OFFSET)		//mmc1_int | sdh2icu_wakeup_int1
#define INTNUM_WTM_HST_INT_OUT              	( 26 + INTRL_GIC_OFFSET)		//wtm_hst_int_out
#define INTNUM_LCD_IRQ                      	( 27 + INTRL_GIC_OFFSET)		//lcd_irq
#define INTNUM_QS_IRQ_BOOTSPI               	( 28 + INTRL_GIC_OFFSET)		//qs_irq (BootSPI)
#define INTNUM_USB2DUAL_IRQ                 	( 29 + INTRL_GIC_OFFSET)		//usb2Dual_irq
#define INTNUM_USB2H_IRQ                    	( 30 + INTRL_GIC_OFFSET)		//usb2H IRQ 
#define INTNUM_USB3H_IRQ                    	( 31 + INTRL_GIC_OFFSET)		//usb3H_irq
#define INTNUM_USB3D_IRQ                    	( 32 + INTRL_GIC_OFFSET)		//usb3D_irq
#define INTNUM_ND2ICU_INT_NAND              	( 33 + INTRL_GIC_OFFSET)		//nd2icu_int (NAND)
#define INTNUM_SATA_INT_PENDINGIO_WRAP      	( 34 + INTRL_GIC_OFFSET)		//sata_int_pending(IO_WRAP)
#define INTNUM_SATA_PME_INTIO_WRAP          	( 35 + INTRL_GIC_OFFSET)		//sata_pme_int(IO_WRAP)
#define INTNUM_GPIO_INT_AP_0                	( 36 + INTRL_GIC_OFFSET)		//gpio_int_ap[0]
#define INTNUM_WTM_SP_INT_OUT               	( 37 + INTRL_GIC_OFFSET)		//wtm_sp_int_out
#define INTNUM_MMC2_INT_SEPERATED           	( 38 + INTRL_GIC_OFFSET)		//mmc2_int | sdh2icu_wakeup_int2
#define INTNUM_SDH2ICU_WAKEUP_INT2_SEPERATED	( 38 + INTRL_GIC_OFFSET)		//mmc2_int | sdh2icu_wakeup_int2
#define INTNUM_MMC2_INT_OR_SDH2ICU_WAKEUP_INT2	( 38 + INTRL_GIC_OFFSET)		//mmc2_int | sdh2icu_wakeup_int2
#define INTNUM_MMC3_INT_SEPERATED           	( 39 + INTRL_GIC_OFFSET)		//mmc3_int | sdh2icu_wakeup_int3
#define INTNUM_SDH2ICU_WAKEUP_INT3_SEPERATED	( 39 + INTRL_GIC_OFFSET)		//mmc3_int | sdh2icu_wakeup_int3
#define INTNUM_MMC3_INT_OR_SDH2ICU_WAKEUP_INT3	( 39 + INTRL_GIC_OFFSET)		//mmc3_int | sdh2icu_wakeup_int3
#define INTNUM_IPC1_WAKEUP                  	( 40 + INTRL_GIC_OFFSET)		//ipc1_wakeup(APB_TOP)
#define INTNUM_SM_INT_SMEMC                 	( 41 + INTRL_GIC_OFFSET)		//sm_int (SMEMC)
#define INTNUM_SDH2ICU_WAKEUP_INT1          	( 42 + INTRL_GIC_OFFSET)		//sdh2icu_wakeup_int1
#define INTNUM_MMC1_INT                     	( 43 + INTRL_GIC_OFFSET)		//mmc1_int
#define INTNUM_SDH2ICU_WAKEUP_INT4          	( 44 + INTRL_GIC_OFFSET)		//sdh2icu_wakeup_int4
#define INTNUM_MMC2_INT                     	( 45 + INTRL_GIC_OFFSET)		//mmc2_int
#define INTNUM_TWSI3_INT                    	( 46 + INTRL_GIC_OFFSET)		//twsi3_int
#define INTNUM_MMC3_INT                     	( 49 + INTRL_GIC_OFFSET)		//mmc3_int
#define INTNUM_PAD_EDGE_DETECT              	( 50 + INTRL_GIC_OFFSET)		//pad_edge_detect
#define INTNUM_XAQ2_INTR_GC4                	( 53 + INTRL_GIC_OFFSET)		//xaq2_intr (GC4)
#define INTNUM_TWSI2_INTI2C_APB_TOP         	( 54 + INTRL_GIC_OFFSET)		//twsi2_int(I2C-APB_TOP)
#define INTNUM_TWSI5_INTI2C_APB_TOP         	( 55 + INTRL_GIC_OFFSET)		//twsi5_int(I2C-APB_TOP)
#define INTNUM_TWSI4_INTI2C_APB_TOP         	( 56 + INTRL_GIC_OFFSET)		//twsi4_int(I2C-APB_TOP)
#define INTNUM_CDMAINT_0                    	( 57 + INTRL_GIC_OFFSET)		//CDMAInt[0]
#define INTNUM_CDMAINT_1                    	( 58 + INTRL_GIC_OFFSET)		//CDMAInt[1]
#define INTNUM_R4_NPMUIRQ                   	( 59 + INTRL_GIC_OFFSET)		//R4_nPMUIRQ
#define INTNUM_R4_NVALFIQ                   	( 60 + INTRL_GIC_OFFSET)		//R4_nVALFIQ
#define INTNUM_R4_NVALIRQ                   	( 61 + INTRL_GIC_OFFSET)		//R4_nVALIRQ
#define INTNUM_R4_NCTIIRQ                   	( 62 + INTRL_GIC_OFFSET)		//R4_nCTIIRQ
#define INTNUM_APCPU_NAXIERRIRQ             	( 63 + INTRL_GIC_OFFSET)		//apcpu_nAXIERRIRQ
#define INTNUM_APCPU_NINTERRIRQ             	( 64 + INTRL_GIC_OFFSET)		//apcpu_nINTERRIRQ
#define INTNUM_APCPU_NPMUIRQ_0              	( 65 + INTRL_GIC_OFFSET)		//apcpu_nPMUIRQ[0]
#define INTNUM_APCPU_NPMUIRQ_1              	( 66 + INTRL_GIC_OFFSET)		//apcpu_nPMUIRQ[1]
#define INTNUM_APCPU_NPMUIRQ_2              	( 67 + INTRL_GIC_OFFSET)		//apcpu_nPMUIRQ[2]
#define INTNUM_APCPU_NPMUIRQ_3              	( 68 + INTRL_GIC_OFFSET)		//apcpu_nPMUIRQ[3]
#define INTNUM_APCPU_NCTIIRQ_0              	( 69 + INTRL_GIC_OFFSET)		//apcpu_nCTIIRQ[0]
#define INTNUM_APCPU_NCTIIRQ_1              	( 70 + INTRL_GIC_OFFSET)		//apcpu_nCTIIRQ[1]
#define INTNUM_APCPU_NCTIIRQ_2              	( 71 + INTRL_GIC_OFFSET)		//apcpu_nCTIIRQ[2]
#define INTNUM_APCPU_NCTIIRQ_3              	( 72 + INTRL_GIC_OFFSET)		//apcpu_nCTIIRQ[3]
#define INTNUM_APCPU_COMMRX_0               	( 73 + INTRL_GIC_OFFSET)		//apcpu_COMMRX[0]
#define INTNUM_APCPU_COMMRX_1               	( 74 + INTRL_GIC_OFFSET)		//apcpu_COMMRX[1]
#define INTNUM_APCPU_COMMRX_2               	( 75 + INTRL_GIC_OFFSET)		//apcpu_COMMRX[2]
#define INTNUM_APCPU_COMMRX_3               	( 76 + INTRL_GIC_OFFSET)		//apcpu_COMMRX[3]
#define INTNUM_APCPU_COMMTX_0               	( 77 + INTRL_GIC_OFFSET)		//apcpu_COMMTX[0]
#define INTNUM_APCPU_COMMTX_1               	( 78 + INTRL_GIC_OFFSET)		//apcpu_COMMTX[1]
#define INTNUM_APCPU_COMMTX_2               	( 79 + INTRL_GIC_OFFSET)		//apcpu_COMMTX[2]
#define INTNUM_APCPU_COMMTX_3               	( 80 + INTRL_GIC_OFFSET)		//apcpu_COMMTX[3]
#define INTNUM_APCPU_NCOMMIRQ_0             	( 81 + INTRL_GIC_OFFSET)		//apcpu_nCOMMIRQ[0]
#define INTNUM_APCPU_NCOMMIRQ_1             	( 82 + INTRL_GIC_OFFSET)		//apcpu_nCOMMIRQ[1]
#define INTNUM_APCPU_NCOMMIRQ_2             	( 83 + INTRL_GIC_OFFSET)		//apcpu_nCOMMIRQ[2]
#define INTNUM_APCPU_NCOMMIRQ_3             	( 84 + INTRL_GIC_OFFSET)		//apcpu_nCOMMIRQ[3]
#define INTNUM_APCPU_NWAMRRSTREQ_0          	( 85 + INTRL_GIC_OFFSET)		//apcpu_nWAMRRSTREQ[0]
#define INTNUM_APCPU_NWAMRRSTREQ_1          	( 86 + INTRL_GIC_OFFSET)		//apcpu_nWAMRRSTREQ[1]
#define INTNUM_APCPU_NWAMRRSTREQ_2          	( 87 + INTRL_GIC_OFFSET)		//apcpu_nWAMRRSTREQ[2]
#define INTNUM_APCPU_NWAMRRSTREQ_3          	( 88 + INTRL_GIC_OFFSET)		//apcpu_nWAMRRSTREQ[3]
#define INTNUM_MCK_PML_OVERFLOW_IRQMC       	( 89 + INTRL_GIC_OFFSET)		//mck_pml_overflow_irq(MC)
#define INTNUM_DMA_CHANNEL_INT_0            	( 90 + INTRL_GIC_OFFSET)		//dma_channel_int[0]
#define INTNUM_DMA_CHANNEL_INT_1            	( 91 + INTRL_GIC_OFFSET)		//dma_channel_int[1]
#define INTNUM_DMA_CHANNEL_INT_2            	( 92 + INTRL_GIC_OFFSET)		//dma_channel_int[2]
#define INTNUM_DMA_CHANNEL_INT_3            	( 93 + INTRL_GIC_OFFSET)		//dma_channel_int[3]
#define INTNUM_DMA_CHANNEL_INT_4            	( 94 + INTRL_GIC_OFFSET)		//dma_channel_int[4]
#define INTNUM_DMA_CHANNEL_INT_5            	( 95 + INTRL_GIC_OFFSET)		//dma_channel_int[5]
#define INTNUM_DMA_CHANNEL_INT_6            	( 96 + INTRL_GIC_OFFSET)		//dma_channel_int[6]
#define INTNUM_DMA_CHANNEL_INT_7            	( 97 + INTRL_GIC_OFFSET)		//dma_channel_int[7]
#define INTNUM_DMA_CHANNEL_INT_8            	( 98 + INTRL_GIC_OFFSET)		//dma_channel_int[8]
#define INTNUM_DMA_CHANNEL_INT_9            	( 99 + INTRL_GIC_OFFSET)		//dma_channel_int[9]
#define INTNUM_DMA_CHANNEL_INT_10           	(100 + INTRL_GIC_OFFSET)		//dma_channel_int[10]
#define INTNUM_DMA_CHANNEL_INT_11           	(101 + INTRL_GIC_OFFSET)		//dma_channel_int[11]
#define INTNUM_DMA_CHANNEL_INT_12           	(102 + INTRL_GIC_OFFSET)		//dma_channel_int[12]
#define INTNUM_DMA_CHANNEL_INT_13           	(103 + INTRL_GIC_OFFSET)		//dma_channel_int[13]
#define INTNUM_DMA_CHANNEL_INT_14           	(104 + INTRL_GIC_OFFSET)		//dma_channel_int[14]
#define INTNUM_DMA_CHANNEL_INT_15           	(105 + INTRL_GIC_OFFSET)		//dma_channel_int[15]
#define INTNUM_M2M_INTERRUPTM2M0            	(106 + INTRL_GIC_OFFSET)		//m2m_interrupt(M2M0)
#define INTNUM_M2M2_INTERRUPTM2M1           	(107 + INTRL_GIC_OFFSET)		//m2m2_interrupt(M2M1)
#define INTNUM_EXT_IRQ_PADRING_CHECK        	(108 + INTRL_GIC_OFFSET)		//EXT_IRQ (Padring-Check)
#define INTNUM_SMMU_AP_CXT_NS               	(109 + INTRL_GIC_OFFSET)		//SMMU_AP_cxt_ns
#define INTNUM_SMMU_AP_COMB_NS              	(110 + INTRL_GIC_OFFSET)		//SMMU_AP_comb_ns
#define INTNUM_SMMU_AP_COMB_S               	(111 + INTRL_GIC_OFFSET)		//SMMU_AP_comb_s
#define INTNUM_SMMU_AP_PERF                 	(112 + INTRL_GIC_OFFSET)		//SMMU_AP_perf
#define INTNUM_AP_TIMEBASE_1US              	(113 + INTRL_GIC_OFFSET)		//AP-TIMEB1us
#define INTNUM_AP_TIMEBASE_10US             	(114 + INTRL_GIC_OFFSET)		//AP-TIMEB10us
#define INTNUM_AP_TIMEBASE_100US            	(115 + INTRL_GIC_OFFSET)		//AP-TIMEB100us
#define INTNUM_AP_TIMEBASE_1MS              	(116 + INTRL_GIC_OFFSET)		//AP-TIMEB1ms
#define INTNUM_AP_TIMEBASE_10MS             	(117 + INTRL_GIC_OFFSET)		//AP-TIMEB10ms
#define INTNUM_AP_TIMEBASE_100MS            	(118 + INTRL_GIC_OFFSET)		//AP-TIMEB100ms
#define INTNUM_GPIO_INT_AP_1                	(119 + INTRL_GIC_OFFSET)		//gpio_int_ap[1]
#define INTNUM_GPIO_INT_AP_2                	(120 + INTRL_GIC_OFFSET)		//gpio_int_ap[2]
#define INTNUM_GPIO_INT_AP_3                	(121 + INTRL_GIC_OFFSET)		//gpio_int_ap[3]
#define INTNUM_GPIO_INT_AP_4                	(122 + INTRL_GIC_OFFSET)		//gpio_int_ap[4]
#define INTNUM_GPIO_INT_AP_5                	(123 + INTRL_GIC_OFFSET)		//gpio_int_ap[5]
#define INTNUM_SCCP_IRQ_0                   	(124 + INTRL_GIC_OFFSET)		//SCCP_IRQ[0]
#define INTNUM_SCCP_IRQ_1                   	(125 + INTRL_GIC_OFFSET)		//SCCP_IRQ[1]
#define INTNUM_TIMEBASE_1US                 	(126 + INTRL_GIC_OFFSET)		//TIMEB1us
#define INTNUM_TIMEBASE_10US                	(127 + INTRL_GIC_OFFSET)		//TIMEB10us
#define INTNUM_TIMEBASE_100US               	(128 + INTRL_GIC_OFFSET)		//TIMEB100us
#define INTNUM_TIMEBASE_1MS                 	(129 + INTRL_GIC_OFFSET)		//TIMEB1ms
#define INTNUM_TIMEBASE_10MS                	(130 + INTRL_GIC_OFFSET)		//TIMEB10ms
#define INTNUM_TIMEBASE_100MS               	(131 + INTRL_GIC_OFFSET)		//TIMEB100ms
#define INTNUM_TIMER_IRQ_0                  	(132 + INTRL_GIC_OFFSET)		//Timer_IRQ[0]
#define INTNUM_TIMER_IRQ_1                  	(133 + INTRL_GIC_OFFSET)		//Timer_IRQ[1]
#define INTNUM_TIMER_IRQ_2                  	(134 + INTRL_GIC_OFFSET)		//Timer_IRQ[2]
#define INTNUM_TIMER_IRQ_3                  	(135 + INTRL_GIC_OFFSET)		//Timer_IRQ[3]
#define INTNUM_UPCERROR_IRQ_0               	(136 + INTRL_GIC_OFFSET)		//UPCError_IRQ[0]
#define INTNUM_UPCERROR_IRQ_1               	(137 + INTRL_GIC_OFFSET)		//UPCError_IRQ[1]
#define INTNUM_AUDIO_IRQ                    	(138 + INTRL_GIC_OFFSET)		//Audio_IRQ
#define INTNUM_HVSYNC_IRQ                   	(139 + INTRL_GIC_OFFSET)		//HVSync_IRQ
#define INTNUM_ENG_IRQ_0                    	(140 + INTRL_GIC_OFFSET)		//Eng_IRQ[0]
#define INTNUM_ENG_IRQ_1                    	(141 + INTRL_GIC_OFFSET)		//Eng_IRQ[1]
#define INTNUM_ENG_IRQ_2                    	(142 + INTRL_GIC_OFFSET)		//Eng_IRQ[2]
#define INTNUM_ENG_IRQ_3                    	(143 + INTRL_GIC_OFFSET)		//Eng_IRQ[3]
#define INTNUM_ZX_IRQ                       	(144 + INTRL_GIC_OFFSET)		//Zx_IRQ
#define INTNUM_SSPA_IRQ                     	(145 + INTRL_GIC_OFFSET)		//SSPA_IRQ
#define INTNUM_JBIG_DECODE_OVER_0           	(146 + INTRL_GIC_OFFSET)		//jbig_decode_over[0]
#define INTNUM_JBIG_DECODE_OVER_1           	(147 + INTRL_GIC_OFFSET)		//jbig_decode_over[1]
#define INTNUM_JBIG_DECODE_OVER_2           	(148 + INTRL_GIC_OFFSET)		//jbig_decode_over[2]
#define INTNUM_JBIG_DECODE_OVER_3           	(149 + INTRL_GIC_OFFSET)		//jbig_decode_over[3]
#define INTNUM_JBIG_DECODE_IDMA_IRQ_0       	(150 + INTRL_GIC_OFFSET)		//jbig_decode_idma_irq[0]
#define INTNUM_JBIG_DECODE_IDMA_IRQ_1       	(151 + INTRL_GIC_OFFSET)		//jbig_decode_idma_irq[1]
#define INTNUM_JBIG_DECODE_IDMA_IRQ_2       	(152 + INTRL_GIC_OFFSET)		//jbig_decode_idma_irq[2]
#define INTNUM_JBIG_DECODE_IDMA_IRQ_3       	(153 + INTRL_GIC_OFFSET)		//jbig_decode_idma_irq[3]
#define INTNUM_JBIG_DECODE_ODMA_IRQ_0       	(154 + INTRL_GIC_OFFSET)		//jbig_decode_odma_irq[0]
#define INTNUM_JBIG_DECODE_ODMA_IRQ_1       	(155 + INTRL_GIC_OFFSET)		//jbig_decode_odma_irq[1]
#define INTNUM_JBIG_DECODE_ODMA_IRQ_2       	(156 + INTRL_GIC_OFFSET)		//jbig_decode_odma_irq[2]
#define INTNUM_JBIG_DECODE_ODMA_IRQ_3       	(157 + INTRL_GIC_OFFSET)		//jbig_decode_odma_irq[3]
#define INTNUM_JBIG_CODEC_OVER_0            	(158 + INTRL_GIC_OFFSET)		//jbig_codec_over[0]
#define INTNUM_JBIG_CODEC_OVER_1            	(159 + INTRL_GIC_OFFSET)		//jbig_codec_over[1]
#define INTNUM_JBIG_CODEC_OVER_2            	(160 + INTRL_GIC_OFFSET)		//jbig_codec_over[2]
#define INTNUM_JBIG_CODEC_OVER_3            	(161 + INTRL_GIC_OFFSET)		//jbig_codec_over[3]
#define INTNUM_JBIG_CODEC_OVER_4            	(162 + INTRL_GIC_OFFSET)		//jbig_codec_over[4]
#define INTNUM_JBIG_CODEC_IDMA_IRQ_0        	(163 + INTRL_GIC_OFFSET)		//jbig_codec_idma_irq[0]
#define INTNUM_JBIG_CODEC_IDMA_IRQ_1        	(164 + INTRL_GIC_OFFSET)		//jbig_codec_idma_irq[1]
#define INTNUM_JBIG_CODEC_IDMA_IRQ_2        	(165 + INTRL_GIC_OFFSET)		//jbig_codec_idma_irq[2]
#define INTNUM_JBIG_CODEC_IDMA_IRQ_3        	(166 + INTRL_GIC_OFFSET)		//jbig_codec_idma_irq[3]
#define INTNUM_JBIG_CODEC_IDMA_IRQ_4        	(167 + INTRL_GIC_OFFSET)		//jbig_codec_idma_irq[4]
#define INTNUM_JBIG_CODEC_ODMA_IRQ_0        	(168 + INTRL_GIC_OFFSET)		//jbig_codec_odma_irq[0]
#define INTNUM_JBIG_CODEC_ODMA_IRQ_1        	(169 + INTRL_GIC_OFFSET)		//jbig_codec_odma_irq[1]
#define INTNUM_JBIG_CODEC_ODMA_IRQ_2        	(170 + INTRL_GIC_OFFSET)		//jbig_codec_odma_irq[2]
#define INTNUM_JBIG_CODEC_ODMA_IRQ_3        	(171 + INTRL_GIC_OFFSET)		//jbig_codec_odma_irq[3]
#define INTNUM_JBIG_CODEC_ODMA_IRQ_4        	(172 + INTRL_GIC_OFFSET)		//jbig_codec_odma_irq[4]
#define INTNUM_ROTATE_IRQ                   	(173 + INTRL_GIC_OFFSET)		//ROTATE_irq
#define INTNUM_JPEGIRQ_0                    	(174 + INTRL_GIC_OFFSET)		//JpegIrq[0]
#define INTNUM_JPEGIRQ_1                    	(175 + INTRL_GIC_OFFSET)		//JpegIrq[1]
#define INTNUM_STMOTORS_IRQ_0               	(176 + INTRL_GIC_OFFSET)		//STMotors_IRQ[0]
#define INTNUM_STMOTORS_IRQ_1               	(177 + INTRL_GIC_OFFSET)		//STMotors_IRQ[1]
#define INTNUM_STMOTORS_IRQ_2               	(178 + INTRL_GIC_OFFSET)		//STMotors_IRQ[2]
#define INTNUM_STMOTORS_IRQ_3               	(179 + INTRL_GIC_OFFSET)		//STMotors_IRQ[3]
#define INTNUM_STMOTORS_IRQ_4               	(180 + INTRL_GIC_OFFSET)		//STMotors_IRQ[4]
#define INTNUM_STMOTORS_IRQ_5               	(181 + INTRL_GIC_OFFSET)		//STMotors_IRQ[5]
#define INTNUM_DCMOTORS_IRQ_0               	(182 + INTRL_GIC_OFFSET)		//DCMotors_IRQ[0]
#define INTNUM_DCMOTORS_IRQ_1               	(183 + INTRL_GIC_OFFSET)		//DCMotors_IRQ[1]
#define INTNUM_DCMOTORS_IRQ_2               	(184 + INTRL_GIC_OFFSET)		//DCMotors_IRQ[2]
#define INTNUM_DCMOTORS_IRQ_3               	(185 + INTRL_GIC_OFFSET)		//DCMotors_IRQ[3]
#define INTNUM_DCMOTORS_IRQ_4               	(186 + INTRL_GIC_OFFSET)		//DCMotors_IRQ[4]
#define INTNUM_DCMOTORS_IRQ_5               	(187 + INTRL_GIC_OFFSET)		//DCMotors_IRQ[5]
#define INTNUM_DCMOTORS_IRQ_6               	(188 + INTRL_GIC_OFFSET)		//DCMotors_IRQ[6]
#define INTNUM_CDMA_IRQ                     	(189 + INTRL_GIC_OFFSET)		//CDMA_IRQ
#define INTNUM_PIE_IRQ                      	(190 + INTRL_GIC_OFFSET)		//Pie_IRQ
#define INTNUM_PIC_IRQ_0                    	(191 + INTRL_GIC_OFFSET)		//Pic_IRQ[0]
#define INTNUM_PIC_IRQ_1                    	(192 + INTRL_GIC_OFFSET)		//Pic_IRQ[1]
#define INTNUM_SCAN_IRQ                     	(193 + INTRL_GIC_OFFSET)		//Scan_IRQ
#define INTNUM_ICETEST_IRQ                  	(194 + INTRL_GIC_OFFSET)		//IceTest_Irq
#define INTNUM_CISX_IRQ                     	(195 + INTRL_GIC_OFFSET)		//Cisx_Irq
#define INTNUM_VID_IRQ_0                    	(196 + INTRL_GIC_OFFSET)		//Vid_IRQ[0]
#define INTNUM_VID_IRQ_1                    	(197 + INTRL_GIC_OFFSET)		//Vid_IRQ[1]
#define INTNUM_VID_IRQ_2                    	(198 + INTRL_GIC_OFFSET)		//Vid_IRQ[2]
#define INTNUM_VID_IRQ_3                    	(199 + INTRL_GIC_OFFSET)		//Vid_IRQ[3]
#define INTNUM_VID_IRQ_4                    	(200 + INTRL_GIC_OFFSET)		//Vid_IRQ[4]
#define INTNUM_VID_IRQ_5                    	(201 + INTRL_GIC_OFFSET)		//Vid_IRQ[5]
#define INTNUM_VID_IRQ_6                    	(202 + INTRL_GIC_OFFSET)		//Vid_IRQ[6]
#define INTNUM_VID_IRQ_7                    	(203 + INTRL_GIC_OFFSET)		//Vid_IRQ[7]
#define INTNUM_UPCNORM_IRQ_0                	(204 + INTRL_GIC_OFFSET)		//UPCNorm_IRQ[0]
#define INTNUM_UPCNORM_IRQ_1                	(205 + INTRL_GIC_OFFSET)		//UPCNorm_IRQ[1]
#define INTNUM_PIP_IRQ_0                    	(206 + INTRL_GIC_OFFSET)		//PIP_IRQ[0]
#define INTNUM_PIP_IRQ_1                    	(207 + INTRL_GIC_OFFSET)		//PIP_IRQ[1]
#define INTNUM_VCF_IRQ                      	(208 + INTRL_GIC_OFFSET)		//Vcf_IRQ
#define INTNUM_APB2_IRQ                     	(209 + INTRL_GIC_OFFSET)		//APB2_IRQ
#define INTNUM_DB_IRQ                    	(210 + INTRL_GIC_OFFSET)		//Db_IRQ
#define INTNUM_A1_IRQ                    	(211 + INTRL_GIC_OFFSET)		//A1_IRQ
#define INTNUM_DEC_IRQ                      	(212 + INTRL_GIC_OFFSET)		//DEC_IRQ
#define INTNUM_DEC_FIQ                      	(213 + INTRL_GIC_OFFSET)		//DEC_FIQ
#define INTNUM_LMON_IRQ                     	(214 + INTRL_GIC_OFFSET)		//Lmon_IRQ
#define INTNUM_IPMU_IRQ                     	(215 + INTRL_GIC_OFFSET)		//IPMU_IRQ
#define INTNUM_SMMU_IPS_CXT_NS              	(216 + INTRL_GIC_OFFSET)		//SMMU_IPS_cxt_ns
#define INTNUM_SMMU_IPS_COMB_NS             	(217 + INTRL_GIC_OFFSET)		//SMMU_IPS_comb_ns
#define INTNUM_SMMU_IPS_COMB_S              	(218 + INTRL_GIC_OFFSET)		//SMMU_IPS_comb_s
#define INTNUM_SMMU_IPS_PERF                	(219 + INTRL_GIC_OFFSET)		//SMMU_IPS_perf
#define INTNUM_UPC_SAFETYMODE               	(220 + INTRL_GIC_OFFSET)		//UPC SafetyMode
#define INTNUM_GPIO_INT_AP_6                	(221 + INTRL_GIC_OFFSET)		//gpio_int_ap[6]
#define INTNUM_GPIO_INT_AP_7                	(222 + INTRL_GIC_OFFSET)		//gpio_int_ap[7]

/*
	This section specifies if the above interrupts are level or
	edge triggered. This is a bit mask with interrupt id's as the index
	a 1 means edge triggered, a 0 means level triggered
*/
#define INT_TYPE1		(0x00000000)
#define INT_TYPE2		(0x00000000)
#define INT_TYPE3		(0x00000000)
#define INT_TYPE4		(0xC07e0000)
#define INT_TYPE5		(0x0000000f)
#define INT_TYPE6		(0x00000000)
#define INT_TYPE7		(0x00000000)
#define INT_TYPE0		(0)
#define INT_TYPE8		(0)
#define INT_TYPE9		(0)
#define INT_TYPE10		(0)
#define INT_TYPE11		(0)
#define INT_TYPE12		(0)
#define INT_TYPE13		(0)
#define INT_TYPE14		(0)
#define INT_TYPE15		(0)
#define INT_TYPE16		(0)
#define INT_TYPE17		(0)
#define INT_TYPE18		(0)
#define INT_TYPE19		(0)
#define INT_TYPE20		(0)
#define INT_TYPE21		(0)
#define INT_TYPE22		(0)
#define INT_TYPE23		(0)
#define INT_TYPE24		(0)
#define INT_TYPE25		(0)
#define INT_TYPE26		(0)
#define INT_TYPE27		(0)
#define INT_TYPE28		(0)
#define INT_TYPE29		(0)
#define INT_TYPE30		(0)
#define INT_TYPE31		(0)

#ifdef __cplusplus
}
#endif

#endif // __INTNUMS_H__
