 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file i2c_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _I2C_REGSTRUCTS_H_
#define _I2C_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: TWSI (i2c)
//
//====================================================================

typedef struct I2C_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C_REGS_t;

#endif // I2C
