 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file i2c_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _I2C_REGMASKS_H_
#define _I2C_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: TWSI (i2c)
//
//====================================================================

//====================================================================
//Register: TWSI Bus Monitor Register (TWSI_IBMR)
/** \brief The TWSI Bus Monitor register (IBMR) tracks the status of the SCL and SDA pins.
The values of these pins are recorded in this read-only IBMR, so software can
determine when the TWSI bus is hung and the TWSI unit must be reset.
This a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  I2C_TWSI_IBMR_RESERVED1_MASK 0xfffffffc
#define  I2C_TWSI_IBMR_RESERVED1_SHIFT 2
#define  I2C_TWSI_IBMR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_IBMR_RESERVED1_MASK) >> I2C_TWSI_IBMR_RESERVED1_SHIFT)
#define  I2C_TWSI_IBMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_IBMR_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_IBMR_RESERVED1_SHIFT))

#define  I2C_TWSI_IBMR_SCL_MASK 0x2
#define  I2C_TWSI_IBMR_SCL_SHIFT 1
#define  I2C_TWSI_IBMR_SCL_MASK_SHIFT(reg) (((reg) & I2C_TWSI_IBMR_SCL_MASK) >> I2C_TWSI_IBMR_SCL_SHIFT)
#define  I2C_TWSI_IBMR_SCL_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_IBMR_SCL_MASK) | (((uint32_t)val) << I2C_TWSI_IBMR_SCL_SHIFT))

#define  I2C_TWSI_IBMR_SDA_MASK 0x1
#define  I2C_TWSI_IBMR_SDA_SHIFT 0
#define  I2C_TWSI_IBMR_SDA_MASK_SHIFT(reg) (((reg) & I2C_TWSI_IBMR_SDA_MASK) >> I2C_TWSI_IBMR_SDA_SHIFT)
#define  I2C_TWSI_IBMR_SDA_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_IBMR_SDA_MASK) | (((uint32_t)val) << I2C_TWSI_IBMR_SDA_SHIFT))

//====================================================================
//Register: TWSI Data Buffer Register (TWSI_IDBR)
/** \brief The PXA2128 Application Processor use the TWSI Data Buffer register to transmit
and receive data from the TWSI bus. The IDBR is accessed by the program I/O on
one side and by the TWSI Shift register on the other. The IDBR receives data
coming into the TWSI unit after a full byte is received and acknowledged. The
PXA2128 Application Processor core writes data going out of the TWSI to the IDBR
and sends it to the serial bus.
When the TWSI is in transmit mode (master or slave), the PXA2128 Application
Processor writes data to the IDBR over the internal bus. The PXA2128 Application
Processor write data to the IDBR when a master transaction is initiated or when
the IDBR transmit-empty interrupt is signalled. Data moves from the IDBR to the
Shift register when the transfer byte bit is set. The IDBR transmit-empty
interrupt is signalled (if enabled) when a byte is transferred on the TWSI bus
and the acknowledge cycle is complete. If the IDBR is not written by the PXA2128
Application Processor, and a Stop condition is not in place before the TWSI bus
is ready to transfer the next byte packet, the TWSI unit inserts wait states
until the PXA2128 Application Processor writes the IDBR and sets the transfer
byte bit.
When the TWSI is in receive mode (master or slave), the PXA2128 Application
Processor reads IDBR data over the internal bus. The PXA2128 Application
Processor reads data from the IDBR when the IDBR receive-full interrupt is
signalled. The data moves from the Shift register to the IDBR when the
acknowledge cycle is complete. The TWSI inserts wait states until the IDBR is
read. See Section 12.4.6 for more information on the acknowledge pulse in
receive mode. After the software reads the IDBR, ICR[ACKNAK], and ICR[ACKNAK]
are written by the software, allowing the next byte transfer to proceed to the
TWSI bus.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C_TWSI_IDBR_RESERVED1_MASK 0xffffff00
#define  I2C_TWSI_IDBR_RESERVED1_SHIFT 8
#define  I2C_TWSI_IDBR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_IDBR_RESERVED1_MASK) >> I2C_TWSI_IDBR_RESERVED1_SHIFT)
#define  I2C_TWSI_IDBR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_IDBR_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_IDBR_RESERVED1_SHIFT))

#define  I2C_TWSI_IDBR_DATA_BUFFER_MASK 0xff
#define  I2C_TWSI_IDBR_DATA_BUFFER_SHIFT 0
#define  I2C_TWSI_IDBR_DATA_BUFFER_MASK_SHIFT(reg) (((reg) & I2C_TWSI_IDBR_DATA_BUFFER_MASK) >> I2C_TWSI_IDBR_DATA_BUFFER_SHIFT)
#define  I2C_TWSI_IDBR_DATA_BUFFER_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_IDBR_DATA_BUFFER_MASK) | (((uint32_t)val) << I2C_TWSI_IDBR_DATA_BUFFER_SHIFT))

//====================================================================
//Register: TWSI Control Register (TWSI_ICR)
/** \brief The PXA2128 Application Processor uses the bits in the TWSI Control register
(ICR) to control the TWSI unit.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C_TWSI_ICR_RESERVED1_MASK 0x80000000
#define  I2C_TWSI_ICR_RESERVED1_SHIFT 31
#define  I2C_TWSI_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_RESERVED1_MASK) >> I2C_TWSI_ICR_RESERVED1_SHIFT)
#define  I2C_TWSI_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_RESERVED1_SHIFT))

#define  I2C_TWSI_ICR_SDA_GFE_MASK 0x40000000
#define  I2C_TWSI_ICR_SDA_GFE_SHIFT 30
#define  I2C_TWSI_ICR_SDA_GFE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_SDA_GFE_MASK) >> I2C_TWSI_ICR_SDA_GFE_SHIFT)
#define  I2C_TWSI_ICR_SDA_GFE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_SDA_GFE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_SDA_GFE_SHIFT))

#define  I2C_TWSI_ICR_TXOV_IE_MASK 0x20000000
#define  I2C_TWSI_ICR_TXOV_IE_SHIFT 29
#define  I2C_TWSI_ICR_TXOV_IE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_TXOV_IE_MASK) >> I2C_TWSI_ICR_TXOV_IE_SHIFT)
#define  I2C_TWSI_ICR_TXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_TXOV_IE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_TXOV_IE_SHIFT))

#define  I2C_TWSI_ICR_RXUN_IE_MASK 0x10000000
#define  I2C_TWSI_ICR_RXUN_IE_SHIFT 28
#define  I2C_TWSI_ICR_RXUN_IE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_RXUN_IE_MASK) >> I2C_TWSI_ICR_RXUN_IE_SHIFT)
#define  I2C_TWSI_ICR_RXUN_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_RXUN_IE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_RXUN_IE_SHIFT))

#define  I2C_TWSI_ICR_DMA_EN_MASK 0x8000000
#define  I2C_TWSI_ICR_DMA_EN_SHIFT 27
#define  I2C_TWSI_ICR_DMA_EN_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_DMA_EN_MASK) >> I2C_TWSI_ICR_DMA_EN_SHIFT)
#define  I2C_TWSI_ICR_DMA_EN_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_DMA_EN_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_DMA_EN_SHIFT))

#define  I2C_TWSI_ICR_RXOV_IE_MASK 0x4000000
#define  I2C_TWSI_ICR_RXOV_IE_SHIFT 26
#define  I2C_TWSI_ICR_RXOV_IE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_RXOV_IE_MASK) >> I2C_TWSI_ICR_RXOV_IE_SHIFT)
#define  I2C_TWSI_ICR_RXOV_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_RXOV_IE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_RXOV_IE_SHIFT))

#define  I2C_TWSI_ICR_RXF_IE_MASK 0x2000000
#define  I2C_TWSI_ICR_RXF_IE_SHIFT 25
#define  I2C_TWSI_ICR_RXF_IE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_RXF_IE_MASK) >> I2C_TWSI_ICR_RXF_IE_SHIFT)
#define  I2C_TWSI_ICR_RXF_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_RXF_IE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_RXF_IE_SHIFT))

#define  I2C_TWSI_ICR_TXSR_IE_MASK 0x1000000
#define  I2C_TWSI_ICR_TXSR_IE_SHIFT 24
#define  I2C_TWSI_ICR_TXSR_IE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_TXSR_IE_MASK) >> I2C_TWSI_ICR_TXSR_IE_SHIFT)
#define  I2C_TWSI_ICR_TXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_TXSR_IE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_TXSR_IE_SHIFT))

#define  I2C_TWSI_ICR_RXSR_IE_MASK 0x800000
#define  I2C_TWSI_ICR_RXSR_IE_SHIFT 23
#define  I2C_TWSI_ICR_RXSR_IE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_RXSR_IE_MASK) >> I2C_TWSI_ICR_RXSR_IE_SHIFT)
#define  I2C_TWSI_ICR_RXSR_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_RXSR_IE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_RXSR_IE_SHIFT))

#define  I2C_TWSI_ICR_TXDONE_IE_MASK 0x400000
#define  I2C_TWSI_ICR_TXDONE_IE_SHIFT 22
#define  I2C_TWSI_ICR_TXDONE_IE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_TXDONE_IE_MASK) >> I2C_TWSI_ICR_TXDONE_IE_SHIFT)
#define  I2C_TWSI_ICR_TXDONE_IE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_TXDONE_IE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_TXDONE_IE_SHIFT))

#define  I2C_TWSI_ICR_TXBEGIN_MASK 0x200000
#define  I2C_TWSI_ICR_TXBEGIN_SHIFT 21
#define  I2C_TWSI_ICR_TXBEGIN_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_TXBEGIN_MASK) >> I2C_TWSI_ICR_TXBEGIN_SHIFT)
#define  I2C_TWSI_ICR_TXBEGIN_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_TXBEGIN_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_TXBEGIN_SHIFT))

#define  I2C_TWSI_ICR_FIFOEN_MASK 0x100000
#define  I2C_TWSI_ICR_FIFOEN_SHIFT 20
#define  I2C_TWSI_ICR_FIFOEN_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_FIFOEN_MASK) >> I2C_TWSI_ICR_FIFOEN_SHIFT)
#define  I2C_TWSI_ICR_FIFOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_FIFOEN_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_FIFOEN_SHIFT))

#define  I2C_TWSI_ICR_GPIOEN_MASK 0x80000
#define  I2C_TWSI_ICR_GPIOEN_SHIFT 19
#define  I2C_TWSI_ICR_GPIOEN_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_GPIOEN_MASK) >> I2C_TWSI_ICR_GPIOEN_SHIFT)
#define  I2C_TWSI_ICR_GPIOEN_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_GPIOEN_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_GPIOEN_SHIFT))

#define  I2C_TWSI_ICR_MSDE_MASK 0x40000
#define  I2C_TWSI_ICR_MSDE_SHIFT 18
#define  I2C_TWSI_ICR_MSDE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_MSDE_MASK) >> I2C_TWSI_ICR_MSDE_SHIFT)
#define  I2C_TWSI_ICR_MSDE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_MSDE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_MSDE_SHIFT))

#define  I2C_TWSI_ICR_MSDIE_MASK 0x20000
#define  I2C_TWSI_ICR_MSDIE_SHIFT 17
#define  I2C_TWSI_ICR_MSDIE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_MSDIE_MASK) >> I2C_TWSI_ICR_MSDIE_SHIFT)
#define  I2C_TWSI_ICR_MSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_MSDIE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_MSDIE_SHIFT))

#define  I2C_TWSI_ICR_MODE_MASK 0x18000
#define  I2C_TWSI_ICR_MODE_SHIFT 15
#define  I2C_TWSI_ICR_MODE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_MODE_MASK) >> I2C_TWSI_ICR_MODE_SHIFT)
#define  I2C_TWSI_ICR_MODE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_MODE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_MODE_SHIFT))

#define  I2C_TWSI_ICR_UR_MASK 0x4000
#define  I2C_TWSI_ICR_UR_SHIFT 14
#define  I2C_TWSI_ICR_UR_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_UR_MASK) >> I2C_TWSI_ICR_UR_SHIFT)
#define  I2C_TWSI_ICR_UR_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_UR_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_UR_SHIFT))

#define  I2C_TWSI_ICR_SADIE_MASK 0x2000
#define  I2C_TWSI_ICR_SADIE_SHIFT 13
#define  I2C_TWSI_ICR_SADIE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_SADIE_MASK) >> I2C_TWSI_ICR_SADIE_SHIFT)
#define  I2C_TWSI_ICR_SADIE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_SADIE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_SADIE_SHIFT))

#define  I2C_TWSI_ICR_ALDIE_MASK 0x1000
#define  I2C_TWSI_ICR_ALDIE_SHIFT 12
#define  I2C_TWSI_ICR_ALDIE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_ALDIE_MASK) >> I2C_TWSI_ICR_ALDIE_SHIFT)
#define  I2C_TWSI_ICR_ALDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_ALDIE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_ALDIE_SHIFT))

#define  I2C_TWSI_ICR_SSDIE_MASK 0x800
#define  I2C_TWSI_ICR_SSDIE_SHIFT 11
#define  I2C_TWSI_ICR_SSDIE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_SSDIE_MASK) >> I2C_TWSI_ICR_SSDIE_SHIFT)
#define  I2C_TWSI_ICR_SSDIE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_SSDIE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_SSDIE_SHIFT))

#define  I2C_TWSI_ICR_BEIE_MASK 0x400
#define  I2C_TWSI_ICR_BEIE_SHIFT 10
#define  I2C_TWSI_ICR_BEIE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_BEIE_MASK) >> I2C_TWSI_ICR_BEIE_SHIFT)
#define  I2C_TWSI_ICR_BEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_BEIE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_BEIE_SHIFT))

#define  I2C_TWSI_ICR_DRFIE_MASK 0x200
#define  I2C_TWSI_ICR_DRFIE_SHIFT 9
#define  I2C_TWSI_ICR_DRFIE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_DRFIE_MASK) >> I2C_TWSI_ICR_DRFIE_SHIFT)
#define  I2C_TWSI_ICR_DRFIE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_DRFIE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_DRFIE_SHIFT))

#define  I2C_TWSI_ICR_ITEIE_MASK 0x100
#define  I2C_TWSI_ICR_ITEIE_SHIFT 8
#define  I2C_TWSI_ICR_ITEIE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_ITEIE_MASK) >> I2C_TWSI_ICR_ITEIE_SHIFT)
#define  I2C_TWSI_ICR_ITEIE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_ITEIE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_ITEIE_SHIFT))

#define  I2C_TWSI_ICR_GCD_MASK 0x80
#define  I2C_TWSI_ICR_GCD_SHIFT 7
#define  I2C_TWSI_ICR_GCD_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_GCD_MASK) >> I2C_TWSI_ICR_GCD_SHIFT)
#define  I2C_TWSI_ICR_GCD_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_GCD_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_GCD_SHIFT))

#define  I2C_TWSI_ICR_IUE_MASK 0x40
#define  I2C_TWSI_ICR_IUE_SHIFT 6
#define  I2C_TWSI_ICR_IUE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_IUE_MASK) >> I2C_TWSI_ICR_IUE_SHIFT)
#define  I2C_TWSI_ICR_IUE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_IUE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_IUE_SHIFT))

#define  I2C_TWSI_ICR_SCLE_MASK 0x20
#define  I2C_TWSI_ICR_SCLE_SHIFT 5
#define  I2C_TWSI_ICR_SCLE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_SCLE_MASK) >> I2C_TWSI_ICR_SCLE_SHIFT)
#define  I2C_TWSI_ICR_SCLE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_SCLE_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_SCLE_SHIFT))

#define  I2C_TWSI_ICR_MA_MASK 0x10
#define  I2C_TWSI_ICR_MA_SHIFT 4
#define  I2C_TWSI_ICR_MA_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_MA_MASK) >> I2C_TWSI_ICR_MA_SHIFT)
#define  I2C_TWSI_ICR_MA_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_MA_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_MA_SHIFT))

#define  I2C_TWSI_ICR_TB_MASK 0x8
#define  I2C_TWSI_ICR_TB_SHIFT 3
#define  I2C_TWSI_ICR_TB_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_TB_MASK) >> I2C_TWSI_ICR_TB_SHIFT)
#define  I2C_TWSI_ICR_TB_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_TB_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_TB_SHIFT))

#define  I2C_TWSI_ICR_ACKNAK_MASK 0x4
#define  I2C_TWSI_ICR_ACKNAK_SHIFT 2
#define  I2C_TWSI_ICR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_ACKNAK_MASK) >> I2C_TWSI_ICR_ACKNAK_SHIFT)
#define  I2C_TWSI_ICR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_ACKNAK_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_ACKNAK_SHIFT))

#define  I2C_TWSI_ICR_STOP_MASK 0x2
#define  I2C_TWSI_ICR_STOP_SHIFT 1
#define  I2C_TWSI_ICR_STOP_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_STOP_MASK) >> I2C_TWSI_ICR_STOP_SHIFT)
#define  I2C_TWSI_ICR_STOP_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_STOP_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_STOP_SHIFT))

#define  I2C_TWSI_ICR_START_MASK 0x1
#define  I2C_TWSI_ICR_START_SHIFT 0
#define  I2C_TWSI_ICR_START_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ICR_START_MASK) >> I2C_TWSI_ICR_START_SHIFT)
#define  I2C_TWSI_ICR_START_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ICR_START_MASK) | (((uint32_t)val) << I2C_TWSI_ICR_START_SHIFT))

//====================================================================
//Register: TWSI Status Register (TWSI_ISR)
/** \brief TWSI interrupts are signalled to the PXA2128 Application Processor interrupt
controller by the TWSI Interrupt Status register. Software uses the ISR bits to
check the status of the TWSI unit and bus. ISR bits (bits 9-5) are updated after
the ACK/NAK bit has completed on the TWSI bus.
The ISR is also used to clear interrupts signalled from the TWSI bus interface
unit, and include the following:
- IDBR receive full
- IDBR transmit empty
- Slave address detected
- Bus error detected
- Stop condition detect
- Arbitration lost
- The TWSI has transmitted a STOP signal when configured as a master
- Transaction is done
- Receive FIFO threshold reached
- Transmit FIFO threshold reached
- Receive FIFO is full
- Receive FIFO overrun happened
- Receive FIFO underrun happened
- Transmit FIFO overrun happened*/
//====================================================================

#define  I2C_TWSI_ISR_RESERVED1_MASK 0xfff00000
#define  I2C_TWSI_ISR_RESERVED1_SHIFT 20
#define  I2C_TWSI_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_RESERVED1_MASK) >> I2C_TWSI_ISR_RESERVED1_SHIFT)
#define  I2C_TWSI_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_RESERVED1_SHIFT))

#define  I2C_TWSI_ISR_TXOV_MASK 0x80000
#define  I2C_TWSI_ISR_TXOV_SHIFT 19
#define  I2C_TWSI_ISR_TXOV_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_TXOV_MASK) >> I2C_TWSI_ISR_TXOV_SHIFT)
#define  I2C_TWSI_ISR_TXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_TXOV_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_TXOV_SHIFT))

#define  I2C_TWSI_ISR_RXUN_MASK 0x40000
#define  I2C_TWSI_ISR_RXUN_SHIFT 18
#define  I2C_TWSI_ISR_RXUN_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_RXUN_MASK) >> I2C_TWSI_ISR_RXUN_SHIFT)
#define  I2C_TWSI_ISR_RXUN_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_RXUN_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_RXUN_SHIFT))

#define  I2C_TWSI_ISR_RXOV_MASK 0x20000
#define  I2C_TWSI_ISR_RXOV_SHIFT 17
#define  I2C_TWSI_ISR_RXOV_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_RXOV_MASK) >> I2C_TWSI_ISR_RXOV_SHIFT)
#define  I2C_TWSI_ISR_RXOV_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_RXOV_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_RXOV_SHIFT))

#define  I2C_TWSI_ISR_RXF_MASK 0x10000
#define  I2C_TWSI_ISR_RXF_SHIFT 16
#define  I2C_TWSI_ISR_RXF_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_RXF_MASK) >> I2C_TWSI_ISR_RXF_SHIFT)
#define  I2C_TWSI_ISR_RXF_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_RXF_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_RXF_SHIFT))

#define  I2C_TWSI_ISR_TXSR_MASK 0x8000
#define  I2C_TWSI_ISR_TXSR_SHIFT 15
#define  I2C_TWSI_ISR_TXSR_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_TXSR_MASK) >> I2C_TWSI_ISR_TXSR_SHIFT)
#define  I2C_TWSI_ISR_TXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_TXSR_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_TXSR_SHIFT))

#define  I2C_TWSI_ISR_RXSR_MASK 0x4000
#define  I2C_TWSI_ISR_RXSR_SHIFT 14
#define  I2C_TWSI_ISR_RXSR_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_RXSR_MASK) >> I2C_TWSI_ISR_RXSR_SHIFT)
#define  I2C_TWSI_ISR_RXSR_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_RXSR_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_RXSR_SHIFT))

#define  I2C_TWSI_ISR_TXDONE_MASK 0x2000
#define  I2C_TWSI_ISR_TXDONE_SHIFT 13
#define  I2C_TWSI_ISR_TXDONE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_TXDONE_MASK) >> I2C_TWSI_ISR_TXDONE_SHIFT)
#define  I2C_TWSI_ISR_TXDONE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_TXDONE_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_TXDONE_SHIFT))

#define  I2C_TWSI_ISR_MSD_MASK 0x1000
#define  I2C_TWSI_ISR_MSD_SHIFT 12
#define  I2C_TWSI_ISR_MSD_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_MSD_MASK) >> I2C_TWSI_ISR_MSD_SHIFT)
#define  I2C_TWSI_ISR_MSD_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_MSD_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_MSD_SHIFT))

#define  I2C_TWSI_ISR_EBB_MASK 0x800
#define  I2C_TWSI_ISR_EBB_SHIFT 11
#define  I2C_TWSI_ISR_EBB_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_EBB_MASK) >> I2C_TWSI_ISR_EBB_SHIFT)
#define  I2C_TWSI_ISR_EBB_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_EBB_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_EBB_SHIFT))

#define  I2C_TWSI_ISR_BED_MASK 0x400
#define  I2C_TWSI_ISR_BED_SHIFT 10
#define  I2C_TWSI_ISR_BED_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_BED_MASK) >> I2C_TWSI_ISR_BED_SHIFT)
#define  I2C_TWSI_ISR_BED_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_BED_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_BED_SHIFT))

#define  I2C_TWSI_ISR_SAD_MASK 0x200
#define  I2C_TWSI_ISR_SAD_SHIFT 9
#define  I2C_TWSI_ISR_SAD_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_SAD_MASK) >> I2C_TWSI_ISR_SAD_SHIFT)
#define  I2C_TWSI_ISR_SAD_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_SAD_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_SAD_SHIFT))

#define  I2C_TWSI_ISR_GCAD_MASK 0x100
#define  I2C_TWSI_ISR_GCAD_SHIFT 8
#define  I2C_TWSI_ISR_GCAD_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_GCAD_MASK) >> I2C_TWSI_ISR_GCAD_SHIFT)
#define  I2C_TWSI_ISR_GCAD_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_GCAD_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_GCAD_SHIFT))

#define  I2C_TWSI_ISR_IRF_MASK 0x80
#define  I2C_TWSI_ISR_IRF_SHIFT 7
#define  I2C_TWSI_ISR_IRF_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_IRF_MASK) >> I2C_TWSI_ISR_IRF_SHIFT)
#define  I2C_TWSI_ISR_IRF_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_IRF_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_IRF_SHIFT))

#define  I2C_TWSI_ISR_ITE_MASK 0x40
#define  I2C_TWSI_ISR_ITE_SHIFT 6
#define  I2C_TWSI_ISR_ITE_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_ITE_MASK) >> I2C_TWSI_ISR_ITE_SHIFT)
#define  I2C_TWSI_ISR_ITE_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_ITE_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_ITE_SHIFT))

#define  I2C_TWSI_ISR_ALD_MASK 0x20
#define  I2C_TWSI_ISR_ALD_SHIFT 5
#define  I2C_TWSI_ISR_ALD_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_ALD_MASK) >> I2C_TWSI_ISR_ALD_SHIFT)
#define  I2C_TWSI_ISR_ALD_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_ALD_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_ALD_SHIFT))

#define  I2C_TWSI_ISR_SSD_MASK 0x10
#define  I2C_TWSI_ISR_SSD_SHIFT 4
#define  I2C_TWSI_ISR_SSD_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_SSD_MASK) >> I2C_TWSI_ISR_SSD_SHIFT)
#define  I2C_TWSI_ISR_SSD_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_SSD_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_SSD_SHIFT))

#define  I2C_TWSI_ISR_IBB_MASK 0x8
#define  I2C_TWSI_ISR_IBB_SHIFT 3
#define  I2C_TWSI_ISR_IBB_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_IBB_MASK) >> I2C_TWSI_ISR_IBB_SHIFT)
#define  I2C_TWSI_ISR_IBB_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_IBB_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_IBB_SHIFT))

#define  I2C_TWSI_ISR_UB_MASK 0x4
#define  I2C_TWSI_ISR_UB_SHIFT 2
#define  I2C_TWSI_ISR_UB_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_UB_MASK) >> I2C_TWSI_ISR_UB_SHIFT)
#define  I2C_TWSI_ISR_UB_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_UB_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_UB_SHIFT))

#define  I2C_TWSI_ISR_ACKNAK_MASK 0x2
#define  I2C_TWSI_ISR_ACKNAK_SHIFT 1
#define  I2C_TWSI_ISR_ACKNAK_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_ACKNAK_MASK) >> I2C_TWSI_ISR_ACKNAK_SHIFT)
#define  I2C_TWSI_ISR_ACKNAK_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_ACKNAK_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_ACKNAK_SHIFT))

#define  I2C_TWSI_ISR_RWM_MASK 0x1
#define  I2C_TWSI_ISR_RWM_SHIFT 0
#define  I2C_TWSI_ISR_RWM_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISR_RWM_MASK) >> I2C_TWSI_ISR_RWM_SHIFT)
#define  I2C_TWSI_ISR_RWM_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISR_RWM_MASK) | (((uint32_t)val) << I2C_TWSI_ISR_RWM_SHIFT))

//====================================================================
//Register: TWSI Slave Address Register (TWSI_ISAR)
/** \brief The ISAR defines the TWSI' s seven-bit slave address. In slave-receive mode, the
PXA2128 Application Processor responds when the seven-bit address matches the
value in this register. The PXA2128 Application Processor writes this register
before it enables TWSI operations. The ISAR is fully programmable (no address is
assigned to the TWSI) so it can be set to a value other than those of hard-wired
TWSI slave peripherals in the system.
These are read/write registers. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  I2C_TWSI_ISAR_RESERVED1_MASK 0xffffff80
#define  I2C_TWSI_ISAR_RESERVED1_SHIFT 7
#define  I2C_TWSI_ISAR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISAR_RESERVED1_MASK) >> I2C_TWSI_ISAR_RESERVED1_SHIFT)
#define  I2C_TWSI_ISAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISAR_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_ISAR_RESERVED1_SHIFT))

#define  I2C_TWSI_ISAR_SLAVE_ADDRESS_MASK 0x7f
#define  I2C_TWSI_ISAR_SLAVE_ADDRESS_SHIFT 0
#define  I2C_TWSI_ISAR_SLAVE_ADDRESS_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ISAR_SLAVE_ADDRESS_MASK) >> I2C_TWSI_ISAR_SLAVE_ADDRESS_SHIFT)
#define  I2C_TWSI_ISAR_SLAVE_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ISAR_SLAVE_ADDRESS_MASK) | (((uint32_t)val) << I2C_TWSI_ISAR_SLAVE_ADDRESS_SHIFT))

//====================================================================
//Register: TWSI Load Count Register (TWSI_ILCR)
/** \brief The TWSI must generate the SCL in master mode and the Load Count Monitor
register (ILCR) allows minor adjustments to this clock. The reset value of this
register are determined based on a 32.8 MHz TWSI input clock which allows the
maximum frequency to be derived for Fast (up to 400 Kbps) and Normal mode (up
to 100 Kbps). However, due to frequency restrictions on the TWSI input clock,
the default values of ILCR only generate an SCL than can support up to 1.8 Mbps
for HS mode.
If the alternate 66 MHz TWSI input clock is selected (via writing CCU,
FUNC_CLK_SEL to 'b11 while the TWSI is not enabled), the recommended value of
ILCR to achieve the necessary Fast, Normal and High Speed SCL frequencies
is 32'h 082C_BB56. This register must also be written while the TWSI is not
enabled.
Increasing the load value decreases the SCL frequency, while decreasing the load
raises the frequency. The amount of decrease or increase is equal to one TWSI
clock period for each value.
Note: Reset values also allow the highest possible SCL frequency that still meet
the minimum requirements listed in the TWSI Bus Specification Version 2.1. This
register should be written prior to enabling the TWSI and should not be changed
during bus activity. Writing all zeros to any of the 4 individual Load Values
causes the TWSI to not generate an SCL for that particular mode when the TWSI is
configured as a master. Extreme caution must be exercised when writing this
register.*/
//====================================================================

#define  I2C_TWSI_ILCR_HLVH_MASK 0xf8000000
#define  I2C_TWSI_ILCR_HLVH_SHIFT 27
#define  I2C_TWSI_ILCR_HLVH_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ILCR_HLVH_MASK) >> I2C_TWSI_ILCR_HLVH_SHIFT)
#define  I2C_TWSI_ILCR_HLVH_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ILCR_HLVH_MASK) | (((uint32_t)val) << I2C_TWSI_ILCR_HLVH_SHIFT))

#define  I2C_TWSI_ILCR_HLVL_MASK 0x7fc0000
#define  I2C_TWSI_ILCR_HLVL_SHIFT 18
#define  I2C_TWSI_ILCR_HLVL_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ILCR_HLVL_MASK) >> I2C_TWSI_ILCR_HLVL_SHIFT)
#define  I2C_TWSI_ILCR_HLVL_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ILCR_HLVL_MASK) | (((uint32_t)val) << I2C_TWSI_ILCR_HLVL_SHIFT))

#define  I2C_TWSI_ILCR_FLV_MASK 0x3fe00
#define  I2C_TWSI_ILCR_FLV_SHIFT 9
#define  I2C_TWSI_ILCR_FLV_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ILCR_FLV_MASK) >> I2C_TWSI_ILCR_FLV_SHIFT)
#define  I2C_TWSI_ILCR_FLV_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ILCR_FLV_MASK) | (((uint32_t)val) << I2C_TWSI_ILCR_FLV_SHIFT))

#define  I2C_TWSI_ILCR_SLV_MASK 0x1ff
#define  I2C_TWSI_ILCR_SLV_SHIFT 0
#define  I2C_TWSI_ILCR_SLV_MASK_SHIFT(reg) (((reg) & I2C_TWSI_ILCR_SLV_MASK) >> I2C_TWSI_ILCR_SLV_SHIFT)
#define  I2C_TWSI_ILCR_SLV_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_ILCR_SLV_MASK) | (((uint32_t)val) << I2C_TWSI_ILCR_SLV_SHIFT))

//====================================================================
//Register: TWSI Wait Count Register (TWSI_IWCR)
/** \brief The TWSI Wait Count register controls the setup and hold times during standard,
fast, or high speed. This register together with the ILCR register control the
setup and hold times for all modes.*/
//====================================================================

#define  I2C_TWSI_IWCR_RESERVED1_MASK 0xffff8000
#define  I2C_TWSI_IWCR_RESERVED1_SHIFT 15
#define  I2C_TWSI_IWCR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_IWCR_RESERVED1_MASK) >> I2C_TWSI_IWCR_RESERVED1_SHIFT)
#define  I2C_TWSI_IWCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_IWCR_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_IWCR_RESERVED1_SHIFT))

#define  I2C_TWSI_IWCR_HS_COUNT2_MASK 0x7c00
#define  I2C_TWSI_IWCR_HS_COUNT2_SHIFT 10
#define  I2C_TWSI_IWCR_HS_COUNT2_MASK_SHIFT(reg) (((reg) & I2C_TWSI_IWCR_HS_COUNT2_MASK) >> I2C_TWSI_IWCR_HS_COUNT2_SHIFT)
#define  I2C_TWSI_IWCR_HS_COUNT2_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_IWCR_HS_COUNT2_MASK) | (((uint32_t)val) << I2C_TWSI_IWCR_HS_COUNT2_SHIFT))

#define  I2C_TWSI_IWCR_HS_COUNT1_MASK 0x3e0
#define  I2C_TWSI_IWCR_HS_COUNT1_SHIFT 5
#define  I2C_TWSI_IWCR_HS_COUNT1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_IWCR_HS_COUNT1_MASK) >> I2C_TWSI_IWCR_HS_COUNT1_SHIFT)
#define  I2C_TWSI_IWCR_HS_COUNT1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_IWCR_HS_COUNT1_MASK) | (((uint32_t)val) << I2C_TWSI_IWCR_HS_COUNT1_SHIFT))

#define  I2C_TWSI_IWCR_COUNT_MASK 0x1f
#define  I2C_TWSI_IWCR_COUNT_SHIFT 0
#define  I2C_TWSI_IWCR_COUNT_MASK_SHIFT(reg) (((reg) & I2C_TWSI_IWCR_COUNT_MASK) >> I2C_TWSI_IWCR_COUNT_SHIFT)
#define  I2C_TWSI_IWCR_COUNT_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_IWCR_COUNT_MASK) | (((uint32_t)val) << I2C_TWSI_IWCR_COUNT_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Register (TWSI_WFIFO)
/** \brief The TWSI Write FIFO has 16 entries and each entry is 12-bit wide (4-bit control
+ 8-bit data). This FIFO can be filled up in PIO or DMA mode. Whenever this FIFO
threshold is reached, an interrupt or a dma request is generated.*/
//====================================================================

#define  I2C_TWSI_WFIFO_RESERVED1_MASK 0xfffff000
#define  I2C_TWSI_WFIFO_RESERVED1_SHIFT 12
#define  I2C_TWSI_WFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_WFIFO_RESERVED1_MASK) >> I2C_TWSI_WFIFO_RESERVED1_SHIFT)
#define  I2C_TWSI_WFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_WFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_WFIFO_RESERVED1_SHIFT))

#define  I2C_TWSI_WFIFO_CONTROL_MASK 0xf00
#define  I2C_TWSI_WFIFO_CONTROL_SHIFT 8
#define  I2C_TWSI_WFIFO_CONTROL_MASK_SHIFT(reg) (((reg) & I2C_TWSI_WFIFO_CONTROL_MASK) >> I2C_TWSI_WFIFO_CONTROL_SHIFT)
#define  I2C_TWSI_WFIFO_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_WFIFO_CONTROL_MASK) | (((uint32_t)val) << I2C_TWSI_WFIFO_CONTROL_SHIFT))

#define  I2C_TWSI_WFIFO_DATA_MASK 0xff
#define  I2C_TWSI_WFIFO_DATA_SHIFT 0
#define  I2C_TWSI_WFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C_TWSI_WFIFO_DATA_MASK) >> I2C_TWSI_WFIFO_DATA_SHIFT)
#define  I2C_TWSI_WFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_WFIFO_DATA_MASK) | (((uint32_t)val) << I2C_TWSI_WFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Write Pointer Register (TWSI_WFIFO_WPTR)
/** \brief The TWSI Write FIFO Pointer has the TX FIFO write entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C_TWSI_WFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C_TWSI_WFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C_TWSI_WFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_WFIFO_WPTR_RESERVED1_MASK) >> I2C_TWSI_WFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C_TWSI_WFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_WFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_WFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C_TWSI_WFIFO_WPTR_DATA_MASK 0x1f
#define  I2C_TWSI_WFIFO_WPTR_DATA_SHIFT 0
#define  I2C_TWSI_WFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C_TWSI_WFIFO_WPTR_DATA_MASK) >> I2C_TWSI_WFIFO_WPTR_DATA_SHIFT)
#define  I2C_TWSI_WFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_WFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C_TWSI_WFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Write FIFO Read Pointer Register (TWSI_WFIFO_RPTR)
/** \brief The TWSI Write FIFO Read Pointer has the TX FIFO read entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C_TWSI_WFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C_TWSI_WFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C_TWSI_WFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_WFIFO_RPTR_RESERVED1_MASK) >> I2C_TWSI_WFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C_TWSI_WFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_WFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_WFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C_TWSI_WFIFO_RPTR_DATA_MASK 0x1f
#define  I2C_TWSI_WFIFO_RPTR_DATA_SHIFT 0
#define  I2C_TWSI_WFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C_TWSI_WFIFO_RPTR_DATA_MASK) >> I2C_TWSI_WFIFO_RPTR_DATA_SHIFT)
#define  I2C_TWSI_WFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_WFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C_TWSI_WFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Register (TWSI_RFIFO)
/** \brief The TWSI Read FIFO has 16 entries and each entry is 8-bit wide (8-bit data).
This FIFO can be emptied in PIO or DMA mode. Whenever this FIFO is half full, an
interrupt or a dma request is generated.*/
//====================================================================

#define  I2C_TWSI_RFIFO_RESERVED1_MASK 0xffffff00
#define  I2C_TWSI_RFIFO_RESERVED1_SHIFT 8
#define  I2C_TWSI_RFIFO_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_RFIFO_RESERVED1_MASK) >> I2C_TWSI_RFIFO_RESERVED1_SHIFT)
#define  I2C_TWSI_RFIFO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_RFIFO_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_RFIFO_RESERVED1_SHIFT))

#define  I2C_TWSI_RFIFO_DATA_MASK 0xff
#define  I2C_TWSI_RFIFO_DATA_SHIFT 0
#define  I2C_TWSI_RFIFO_DATA_MASK_SHIFT(reg) (((reg) & I2C_TWSI_RFIFO_DATA_MASK) >> I2C_TWSI_RFIFO_DATA_SHIFT)
#define  I2C_TWSI_RFIFO_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_RFIFO_DATA_MASK) | (((uint32_t)val) << I2C_TWSI_RFIFO_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Write Pointer Register (TWSI_RFIFO_WPTR)
/** \brief The TWSI Read FIFO Write Pointer has the RX FIFO write entry location
information. This is a read/write register. Software can write 0 to it when it
wishes to flush the FIFO after interrupts like Bus error, Arbitration loss, etc.*/
//====================================================================

#define  I2C_TWSI_RFIFO_WPTR_RESERVED1_MASK 0xffffffe0
#define  I2C_TWSI_RFIFO_WPTR_RESERVED1_SHIFT 5
#define  I2C_TWSI_RFIFO_WPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_RFIFO_WPTR_RESERVED1_MASK) >> I2C_TWSI_RFIFO_WPTR_RESERVED1_SHIFT)
#define  I2C_TWSI_RFIFO_WPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_RFIFO_WPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_RFIFO_WPTR_RESERVED1_SHIFT))

#define  I2C_TWSI_RFIFO_WPTR_DATA_MASK 0x1f
#define  I2C_TWSI_RFIFO_WPTR_DATA_SHIFT 0
#define  I2C_TWSI_RFIFO_WPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C_TWSI_RFIFO_WPTR_DATA_MASK) >> I2C_TWSI_RFIFO_WPTR_DATA_SHIFT)
#define  I2C_TWSI_RFIFO_WPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_RFIFO_WPTR_DATA_MASK) | (((uint32_t)val) << I2C_TWSI_RFIFO_WPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI Read FIFO Read Pointer Register (TWSI_RFIFO_RPTR)
/** \brief The TWSI Read FIFO Read Pointer has the RX FIFO read entry location information.
This is a read/write register. Software can write 0 to it when it wishes to
flush the FIFO after an interrupt.*/
//====================================================================

#define  I2C_TWSI_RFIFO_RPTR_RESERVED1_MASK 0xffffffe0
#define  I2C_TWSI_RFIFO_RPTR_RESERVED1_SHIFT 5
#define  I2C_TWSI_RFIFO_RPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_RFIFO_RPTR_RESERVED1_MASK) >> I2C_TWSI_RFIFO_RPTR_RESERVED1_SHIFT)
#define  I2C_TWSI_RFIFO_RPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_RFIFO_RPTR_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_RFIFO_RPTR_RESERVED1_SHIFT))

#define  I2C_TWSI_RFIFO_RPTR_DATA_MASK 0x1f
#define  I2C_TWSI_RFIFO_RPTR_DATA_SHIFT 0
#define  I2C_TWSI_RFIFO_RPTR_DATA_MASK_SHIFT(reg) (((reg) & I2C_TWSI_RFIFO_RPTR_DATA_MASK) >> I2C_TWSI_RFIFO_RPTR_DATA_SHIFT)
#define  I2C_TWSI_RFIFO_RPTR_DATA_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_RFIFO_RPTR_DATA_MASK) | (((uint32_t)val) << I2C_TWSI_RFIFO_RPTR_DATA_SHIFT))

//====================================================================
//Register: TWSI FIFO Threshold Register (TWSI_FIFO_TSHLD)
/** \brief The FIFO threshold register had the threshold values for TXFIFO and RXFIFO. It
is a read/write register. The default values are 0(empty) for TXFIFO and 8(half
full) for RXFIFO.*/
//====================================================================

#define  I2C_TWSI_FIFO_TSHLD_RESERVED1_MASK 0xffe00000
#define  I2C_TWSI_FIFO_TSHLD_RESERVED1_SHIFT 21
#define  I2C_TWSI_FIFO_TSHLD_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_TWSI_FIFO_TSHLD_RESERVED1_MASK) >> I2C_TWSI_FIFO_TSHLD_RESERVED1_SHIFT)
#define  I2C_TWSI_FIFO_TSHLD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_FIFO_TSHLD_RESERVED1_MASK) | (((uint32_t)val) << I2C_TWSI_FIFO_TSHLD_RESERVED1_SHIFT))

#define  I2C_TWSI_FIFO_TSHLD_RX_MASK 0x1f0000
#define  I2C_TWSI_FIFO_TSHLD_RX_SHIFT 16
#define  I2C_TWSI_FIFO_TSHLD_RX_MASK_SHIFT(reg) (((reg) & I2C_TWSI_FIFO_TSHLD_RX_MASK) >> I2C_TWSI_FIFO_TSHLD_RX_SHIFT)
#define  I2C_TWSI_FIFO_TSHLD_RX_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_FIFO_TSHLD_RX_MASK) | (((uint32_t)val) << I2C_TWSI_FIFO_TSHLD_RX_SHIFT))

#define  I2C_TWSI_FIFO_TSHLD_RESERVED2_MASK 0xffe0
#define  I2C_TWSI_FIFO_TSHLD_RESERVED2_SHIFT 5
#define  I2C_TWSI_FIFO_TSHLD_RESERVED2_MASK_SHIFT(reg) (((reg) & I2C_TWSI_FIFO_TSHLD_RESERVED2_MASK) >> I2C_TWSI_FIFO_TSHLD_RESERVED2_SHIFT)
#define  I2C_TWSI_FIFO_TSHLD_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_FIFO_TSHLD_RESERVED2_MASK) | (((uint32_t)val) << I2C_TWSI_FIFO_TSHLD_RESERVED2_SHIFT))

#define  I2C_TWSI_FIFO_TSHLD_TX_MASK 0x1f
#define  I2C_TWSI_FIFO_TSHLD_TX_SHIFT 0
#define  I2C_TWSI_FIFO_TSHLD_TX_MASK_SHIFT(reg) (((reg) & I2C_TWSI_FIFO_TSHLD_TX_MASK) >> I2C_TWSI_FIFO_TSHLD_TX_SHIFT)
#define  I2C_TWSI_FIFO_TSHLD_TX_REPLACE_VAL(reg,val) (((reg) & ~I2C_TWSI_FIFO_TSHLD_TX_MASK) | (((uint32_t)val) << I2C_TWSI_FIFO_TSHLD_TX_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  I2C_REV0_MAJ_MASK 0xffff0000
#define  I2C_REV0_MAJ_SHIFT 16
#define  I2C_REV0_MAJ_MASK_SHIFT(reg) (((reg) & I2C_REV0_MAJ_MASK) >> I2C_REV0_MAJ_SHIFT)
#define  I2C_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~I2C_REV0_MAJ_MASK) | (((uint32_t)val) << I2C_REV0_MAJ_SHIFT))

#define  I2C_REV0_MID_MASK 0xffff
#define  I2C_REV0_MID_SHIFT 0
#define  I2C_REV0_MID_MASK_SHIFT(reg) (((reg) & I2C_REV0_MID_MASK) >> I2C_REV0_MID_SHIFT)
#define  I2C_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~I2C_REV0_MID_MASK) | (((uint32_t)val) << I2C_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  I2C_REV1_RESERVED1_MASK 0xffff0000
#define  I2C_REV1_RESERVED1_SHIFT 16
#define  I2C_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & I2C_REV1_RESERVED1_MASK) >> I2C_REV1_RESERVED1_SHIFT)
#define  I2C_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~I2C_REV1_RESERVED1_MASK) | (((uint32_t)val) << I2C_REV1_RESERVED1_SHIFT))

#define  I2C_REV1_CFG_MASK 0xffff
#define  I2C_REV1_CFG_SHIFT 0
#define  I2C_REV1_CFG_MASK_SHIFT(reg) (((reg) & I2C_REV1_CFG_MASK) >> I2C_REV1_CFG_SHIFT)
#define  I2C_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~I2C_REV1_CFG_MASK) | (((uint32_t)val) << I2C_REV1_CFG_SHIFT))

#endif // I2C
