 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file fGPIO_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _fGPIO_TOP_REGSTRUCTS_H_
#define _fGPIO_TOP_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: fGPIO Top Level (fGPIO_TOP)
/** \brief Register Descriptions for the fGPIO banks*/
//
//====================================================================

//====================================================================
//
//Register File: GpioA Registers (GpioA)
/** \brief (rev 1 . 1 . 3 . 2)
    The fGPIO block registers provide the means to configure the characteristics of each fGPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct fGPIOA_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: fGPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: fGPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: fGPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: fGPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: fGPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: fGPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: fGPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: fGPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: fGPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: fGPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: fGPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: fGPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: fGPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 2)
  volatile uint32_t ITER1;  ///< 0x54 [R/W]: Interrupt Target Enable Register (Instance 2 of 2)
} fGPIOA_REGS_t;

//====================================================================
//
//Register File: GpioB Registers (GpioB)
/** \brief (rev 1 . 1 . 3 . 2)
    The fGPIO block registers provide the means to configure the characteristics of each fGPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct fGPIOB_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: fGPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: fGPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: fGPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: fGPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: fGPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: fGPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: fGPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: fGPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: fGPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: fGPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: fGPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: fGPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: fGPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 2)
  volatile uint32_t ITER1;  ///< 0x54 [R/W]: Interrupt Target Enable Register (Instance 2 of 2)
} fGPIOB_REGS_t;

#endif // fGPIO_TOP
