 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file fGPIO_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _fGPIO_TOP_REGMASKS_H_
#define _fGPIO_TOP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: fGPIO Top Level (fGPIO_TOP)
/** \brief Register Descriptions for the fGPIO banks*/
//
//====================================================================

//====================================================================
//
//Register File: GpioA Registers (GpioA)
/** \brief (rev 1 . 1 . 3 . 2)
    The fGPIO block registers provide the means to configure the characteristics of each fGPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

//====================================================================
//Register: fGPIO Pin Direction Register (PDR)
/** \brief The bits in this register determine if the corresponding fGPIO pin is in input or output
      mode. A pair of set/clear registers are also provided to enable the setting and clearing
      of individual bits in this register.*/
//====================================================================

#define  fGPIOA_PDR_RESERVED1_MASK 0xffff8000
#define  fGPIOA_PDR_RESERVED1_SHIFT 15
#define  fGPIOA_PDR_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_PDR_RESERVED1_MASK) >> fGPIOA_PDR_RESERVED1_SHIFT)
#define  fGPIOA_PDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_PDR_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_PDR_RESERVED1_SHIFT))

#define  fGPIOA_PDR_PD_MASK 0x7fff
#define  fGPIOA_PDR_PD_SHIFT 0
#define  fGPIOA_PDR_PD_MASK_SHIFT(reg) (((reg) & fGPIOA_PDR_PD_MASK) >> fGPIOA_PDR_PD_SHIFT)
#define  fGPIOA_PDR_PD_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_PDR_PD_MASK) | (((uint32_t)val) << fGPIOA_PDR_PD_SHIFT))

//====================================================================
//Register: fGPIO Pin Output Set Register (PSR)
/** \brief Writing any bit in this register to a '1' will set the corresponding pin to '1' if
      that bit is in output mode (PDR bit set to '1'). Data bits corresponding to bits that
      are written as '0' in this register not be affected by the write to this register. Pins
      in input mode (PDR bit set to '0') will not be affected immediately by writes to this
      register, but when the pin is switched to output mode via the PDR register, the output
      state from the most recent write to the PSR or the PCR will be driven on the pin.*/
//====================================================================

#define  fGPIOA_PSR_RESERVED1_MASK 0xffff8000
#define  fGPIOA_PSR_RESERVED1_SHIFT 15
#define  fGPIOA_PSR_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_PSR_RESERVED1_MASK) >> fGPIOA_PSR_RESERVED1_SHIFT)
#define  fGPIOA_PSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_PSR_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_PSR_RESERVED1_SHIFT))

#define  fGPIOA_PSR_PS_MASK 0x7fff
#define  fGPIOA_PSR_PS_SHIFT 0
#define  fGPIOA_PSR_PS_MASK_SHIFT(reg) (((reg) & fGPIOA_PSR_PS_MASK) >> fGPIOA_PSR_PS_SHIFT)
#define  fGPIOA_PSR_PS_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_PSR_PS_MASK) | (((uint32_t)val) << fGPIOA_PSR_PS_SHIFT))

//====================================================================
//Register: fGPIO Pin Output Clear Register (PCR)
/** \brief Writing any bit in this register to a '1' will clear the corresponding pin to '0' if
      that bit is in output mode (PDR bit set to '1'). Data bits corresponding to bits that
      are written as '0' in this register not be affected by the write to this register. Pins
      in input mode (PDR bit set to '0') will not be affected immediately by writes to this
      register, but when the pin is switched to output mode via the PDR register, the output
      state from the most recent write to the PSR or the PCR will be driven on the pin.*/
//====================================================================

#define  fGPIOA_PCR_RESERVED1_MASK 0xffff8000
#define  fGPIOA_PCR_RESERVED1_SHIFT 15
#define  fGPIOA_PCR_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_PCR_RESERVED1_MASK) >> fGPIOA_PCR_RESERVED1_SHIFT)
#define  fGPIOA_PCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_PCR_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_PCR_RESERVED1_SHIFT))

#define  fGPIOA_PCR_PC_MASK 0x7fff
#define  fGPIOA_PCR_PC_SHIFT 0
#define  fGPIOA_PCR_PC_MASK_SHIFT(reg) (((reg) & fGPIOA_PCR_PC_MASK) >> fGPIOA_PCR_PC_SHIFT)
#define  fGPIOA_PCR_PC_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_PCR_PC_MASK) | (((uint32_t)val) << fGPIOA_PCR_PC_SHIFT))

//====================================================================
//Register: fGPIO Rising-Edge Detect Enable Register (RER)
/** \brief Setting a bit in this register enables rising-edge detection on the corresponding pin.
      When a rising edge (after deglitching, if deglitching is enabled for the pin) is detected
      on a pin which has the corresponding bit set in this register, the corresponding bit in
      the fGPIO Edge-detect status register will be set. <br />
      There are also a pair of set/clear registers for setting and clearing individual bits
      of this register. Reading this register will show the current rising-edge enable
      state of each bit, whether written directly at this address, or set/cleared via the
      set/clear registers.*/
//====================================================================

#define  fGPIOA_RER_RESERVED1_MASK 0xffff8000
#define  fGPIOA_RER_RESERVED1_SHIFT 15
#define  fGPIOA_RER_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_RER_RESERVED1_MASK) >> fGPIOA_RER_RESERVED1_SHIFT)
#define  fGPIOA_RER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_RER_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_RER_RESERVED1_SHIFT))

#define  fGPIOA_RER_RE_MASK 0x7fff
#define  fGPIOA_RER_RE_SHIFT 0
#define  fGPIOA_RER_RE_MASK_SHIFT(reg) (((reg) & fGPIOA_RER_RE_MASK) >> fGPIOA_RER_RE_SHIFT)
#define  fGPIOA_RER_RE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_RER_RE_MASK) | (((uint32_t)val) << fGPIOA_RER_RE_SHIFT))

//====================================================================
//Register: fGPIO Falling-Edge Detect Enable Register (FER)
/** \brief Setting a bit in this register enables falling-edge detection on the corresponding pin.
      When a falling edge (after deglitching, if deglitching is enabled for the pin) is detected
      on a pin which has the corresponding bit set in this register, the corresponding bit in
      the fGPIO Edge-detect status register will be set. <br />
      There are also a pair of set/clear registers for setting and clearing individual bits
      of this register. Reading this register will show the current falling-edge enable
      state of each bit, whether written directly at this address, or set/cleared via the
      set/clear registers.*/
//====================================================================

#define  fGPIOA_FER_RESERVED1_MASK 0xffff8000
#define  fGPIOA_FER_RESERVED1_SHIFT 15
#define  fGPIOA_FER_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_FER_RESERVED1_MASK) >> fGPIOA_FER_RESERVED1_SHIFT)
#define  fGPIOA_FER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_FER_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_FER_RESERVED1_SHIFT))

#define  fGPIOA_FER_FE_MASK 0x7fff
#define  fGPIOA_FER_FE_SHIFT 0
#define  fGPIOA_FER_FE_MASK_SHIFT(reg) (((reg) & fGPIOA_FER_FE_MASK) >> fGPIOA_FER_FE_SHIFT)
#define  fGPIOA_FER_FE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_FER_FE_MASK) | (((uint32_t)val) << fGPIOA_FER_FE_SHIFT))

//====================================================================
//Register: fGPIO Edge-detect Status Register (EDR)
/** \brief This register provides access to the edge-detect status of each pin. A pin may be enabled
      for rising-edge detect by setting the corresponding bit in the RER register, for
      falling-edge detect by setting the corresponding bit in the FER register, for detection
      of either kind of edge by setting the corresponding bits in both the RER and FER registers,
      or for no edge detection by clearing the corresponding bits in both the RER and FER
      registers. When an enabled edge is detected on a pin, the corresponding bit is set in
      this register. The bits in this register can be cleared by writing a '1' to the bit.*/
//====================================================================

#define  fGPIOA_EDR_RESERVED1_MASK 0xffff8000
#define  fGPIOA_EDR_RESERVED1_SHIFT 15
#define  fGPIOA_EDR_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_EDR_RESERVED1_MASK) >> fGPIOA_EDR_RESERVED1_SHIFT)
#define  fGPIOA_EDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_EDR_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_EDR_RESERVED1_SHIFT))

#define  fGPIOA_EDR_ED_MASK 0x7fff
#define  fGPIOA_EDR_ED_SHIFT 0
#define  fGPIOA_EDR_ED_MASK_SHIFT(reg) (((reg) & fGPIOA_EDR_ED_MASK) >> fGPIOA_EDR_ED_SHIFT)
#define  fGPIOA_EDR_ED_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_EDR_ED_MASK) | (((uint32_t)val) << fGPIOA_EDR_ED_SHIFT))

//====================================================================
//Register: fGPIO Output Direction Set Register (SDR)
/** \brief Writing any bit in this register to a '1' will set the corresponding bit in the PDR
      to '1'. Pin direction bits corresponding to bits that are written as '0' in this register
      will not be affected by the write to this register.*/
//====================================================================

#define  fGPIOA_SDR_RESERVED1_MASK 0xffff8000
#define  fGPIOA_SDR_RESERVED1_SHIFT 15
#define  fGPIOA_SDR_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_SDR_RESERVED1_MASK) >> fGPIOA_SDR_RESERVED1_SHIFT)
#define  fGPIOA_SDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_SDR_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_SDR_RESERVED1_SHIFT))

#define  fGPIOA_SDR_SD_MASK 0x7fff
#define  fGPIOA_SDR_SD_SHIFT 0
#define  fGPIOA_SDR_SD_MASK_SHIFT(reg) (((reg) & fGPIOA_SDR_SD_MASK) >> fGPIOA_SDR_SD_SHIFT)
#define  fGPIOA_SDR_SD_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_SDR_SD_MASK) | (((uint32_t)val) << fGPIOA_SDR_SD_SHIFT))

//====================================================================
//Register: fGPIO Output Direction Clear Register (CDR)
/** \brief Writing any bit in this register to a '1' will clear the corresponding PDR bit
      to '0'. Pin direction bits corresponding to bits that are written as '0' in this register
      will not be affected by the write to this register.*/
//====================================================================

#define  fGPIOA_CDR_RESERVED1_MASK 0xffff8000
#define  fGPIOA_CDR_RESERVED1_SHIFT 15
#define  fGPIOA_CDR_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_CDR_RESERVED1_MASK) >> fGPIOA_CDR_RESERVED1_SHIFT)
#define  fGPIOA_CDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_CDR_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_CDR_RESERVED1_SHIFT))

#define  fGPIOA_CDR_CD_MASK 0x7fff
#define  fGPIOA_CDR_CD_SHIFT 0
#define  fGPIOA_CDR_CD_MASK_SHIFT(reg) (((reg) & fGPIOA_CDR_CD_MASK) >> fGPIOA_CDR_CD_SHIFT)
#define  fGPIOA_CDR_CD_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_CDR_CD_MASK) | (((uint32_t)val) << fGPIOA_CDR_CD_SHIFT))

//====================================================================
//Register: fGPIO Bit-wise Set of Rising-Edge Detect Enable Register (SRER)
/** \brief Writing any bit in this register to a '1' will set the corresponding RER bit
      to '1'. Rising-edge detect enable bits corresponding to bits that are written as '0'
      in this register will not be affected by the write to this register.*/
//====================================================================

#define  fGPIOA_SRER_RESERVED1_MASK 0xffff8000
#define  fGPIOA_SRER_RESERVED1_SHIFT 15
#define  fGPIOA_SRER_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_SRER_RESERVED1_MASK) >> fGPIOA_SRER_RESERVED1_SHIFT)
#define  fGPIOA_SRER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_SRER_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_SRER_RESERVED1_SHIFT))

#define  fGPIOA_SRER_SRE_MASK 0x7fff
#define  fGPIOA_SRER_SRE_SHIFT 0
#define  fGPIOA_SRER_SRE_MASK_SHIFT(reg) (((reg) & fGPIOA_SRER_SRE_MASK) >> fGPIOA_SRER_SRE_SHIFT)
#define  fGPIOA_SRER_SRE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_SRER_SRE_MASK) | (((uint32_t)val) << fGPIOA_SRER_SRE_SHIFT))

//====================================================================
//Register: fGPIO Bit-wise Clear of Rising-Edge Detect Enable Register (CRER)
/** \brief Writing any bit in this register to a '1' will clear the corresponding RER bit
      to '0' if that bit is in semaphore mode. Rising-edge detect enable bits corresponding to
      bits that are written as '0' in this register will not be affected by the write to this
      register.*/
//====================================================================

#define  fGPIOA_CRER_RESERVED1_MASK 0xffff8000
#define  fGPIOA_CRER_RESERVED1_SHIFT 15
#define  fGPIOA_CRER_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_CRER_RESERVED1_MASK) >> fGPIOA_CRER_RESERVED1_SHIFT)
#define  fGPIOA_CRER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_CRER_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_CRER_RESERVED1_SHIFT))

#define  fGPIOA_CRER_CRE_MASK 0x7fff
#define  fGPIOA_CRER_CRE_SHIFT 0
#define  fGPIOA_CRER_CRE_MASK_SHIFT(reg) (((reg) & fGPIOA_CRER_CRE_MASK) >> fGPIOA_CRER_CRE_SHIFT)
#define  fGPIOA_CRER_CRE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_CRER_CRE_MASK) | (((uint32_t)val) << fGPIOA_CRER_CRE_SHIFT))

//====================================================================
//Register: fGPIO Bit-wise Set of Falling-Edge Detect Enable Register (SFER)
/** \brief Writing any bit in this register to a '1' will set the corresponding FER bit
      to '1'. Falling-edge detect enable bits corresponding to bits that are written as '0'
      in this register will not be affected by the write to this register.*/
//====================================================================

#define  fGPIOA_SFER_RESERVED1_MASK 0xffff8000
#define  fGPIOA_SFER_RESERVED1_SHIFT 15
#define  fGPIOA_SFER_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_SFER_RESERVED1_MASK) >> fGPIOA_SFER_RESERVED1_SHIFT)
#define  fGPIOA_SFER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_SFER_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_SFER_RESERVED1_SHIFT))

#define  fGPIOA_SFER_SFE_MASK 0x7fff
#define  fGPIOA_SFER_SFE_SHIFT 0
#define  fGPIOA_SFER_SFE_MASK_SHIFT(reg) (((reg) & fGPIOA_SFER_SFE_MASK) >> fGPIOA_SFER_SFE_SHIFT)
#define  fGPIOA_SFER_SFE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_SFER_SFE_MASK) | (((uint32_t)val) << fGPIOA_SFER_SFE_SHIFT))

//====================================================================
//Register: fGPIO Bit-wise Clear of Falling-Edge Detect Enable Register (CFER)
/** \brief Writing any bit in this register to a '1' will clear the corresponding FER bit
      to '0' if that bit is in semaphore mode. Falling-edge detect enable bits corresponding to
      bits that are written as '0' in this register will not be affected by the write to this
      register.*/
//====================================================================

#define  fGPIOA_CFER_RESERVED1_MASK 0xffff8000
#define  fGPIOA_CFER_RESERVED1_SHIFT 15
#define  fGPIOA_CFER_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_CFER_RESERVED1_MASK) >> fGPIOA_CFER_RESERVED1_SHIFT)
#define  fGPIOA_CFER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_CFER_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_CFER_RESERVED1_SHIFT))

#define  fGPIOA_CFER_CFE_MASK 0x7fff
#define  fGPIOA_CFER_CFE_SHIFT 0
#define  fGPIOA_CFER_CFE_MASK_SHIFT(reg) (((reg) & fGPIOA_CFER_CFE_MASK) >> fGPIOA_CFER_CFE_SHIFT)
#define  fGPIOA_CFER_CFE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_CFER_CFE_MASK) | (((uint32_t)val) << fGPIOA_CFER_CFE_SHIFT))

//====================================================================
//Register: fGPIO Pin Level Register (PLR)
/** \brief The current state of the fGPIO pins in this bank (deglitched, for those pins which have
      deglitching enabled), can be read from this register. The state can be read regardless
      of whether it is in input or output mode.*/
//====================================================================

#define  fGPIOA_PLR_RESERVED1_MASK 0xffff8000
#define  fGPIOA_PLR_RESERVED1_SHIFT 15
#define  fGPIOA_PLR_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_PLR_RESERVED1_MASK) >> fGPIOA_PLR_RESERVED1_SHIFT)
#define  fGPIOA_PLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_PLR_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_PLR_RESERVED1_SHIFT))

#define  fGPIOA_PLR_PL_MASK 0x7fff
#define  fGPIOA_PLR_PL_SHIFT 0
#define  fGPIOA_PLR_PL_MASK_SHIFT(reg) (((reg) & fGPIOA_PLR_PL_MASK) >> fGPIOA_PLR_PL_SHIFT)
#define  fGPIOA_PLR_PL_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_PLR_PL_MASK) | (((uint32_t)val) << fGPIOA_PLR_PL_SHIFT))

//====================================================================
//Register: Output Level Register (OLR)
/** \brief This register allows the output level of multiple pins to be changed in opposite directions
      at the same time. This is not possible with the PSR and PCR registers. To avoid needing
      to do a read-modify-write of this register to avoid changing pins that are not to be
      affected, use the OLDER (Output Level Direct-write Enable Register). Only pins with their
      corresponding bit set in the OLDER will be affected by writes to this register. Note that
      only pins that have their output enable set will have their pin levels affected by writes
      to this register. <br />
      Reading this register will return the value that is or would be driven
      on the pin if it is placed in output mode. In other words, its value depends on the
      combination of writes to the OLDER, OLR, PCR, and PSR registers that have occured.*/
//====================================================================

#define  fGPIOA_OLR_RESERVED1_MASK 0xffff8000
#define  fGPIOA_OLR_RESERVED1_SHIFT 15
#define  fGPIOA_OLR_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_OLR_RESERVED1_MASK) >> fGPIOA_OLR_RESERVED1_SHIFT)
#define  fGPIOA_OLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_OLR_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_OLR_RESERVED1_SHIFT))

#define  fGPIOA_OLR_OL_MASK 0x7fff
#define  fGPIOA_OLR_OL_SHIFT 0
#define  fGPIOA_OLR_OL_MASK_SHIFT(reg) (((reg) & fGPIOA_OLR_OL_MASK) >> fGPIOA_OLR_OL_SHIFT)
#define  fGPIOA_OLR_OL_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_OLR_OL_MASK) | (((uint32_t)val) << fGPIOA_OLR_OL_SHIFT))

//====================================================================
//Register: Output Level Direct-write Enable Register (OLDER)
/** \brief Setting a bit in this register enables the corresponding pin to be affected by writes
      to the OLR register. Pins that are not enabled for direct writes by this register can still
      have their output levels affected by writes to the PSR and PCR registers.*/
//====================================================================

#define  fGPIOA_OLDER_RESERVED1_MASK 0xffff8000
#define  fGPIOA_OLDER_RESERVED1_SHIFT 15
#define  fGPIOA_OLDER_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_OLDER_RESERVED1_MASK) >> fGPIOA_OLDER_RESERVED1_SHIFT)
#define  fGPIOA_OLDER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_OLDER_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_OLDER_RESERVED1_SHIFT))

#define  fGPIOA_OLDER_OLE_MASK 0x7fff
#define  fGPIOA_OLDER_OLE_SHIFT 0
#define  fGPIOA_OLDER_OLE_MASK_SHIFT(reg) (((reg) & fGPIOA_OLDER_OLE_MASK) >> fGPIOA_OLDER_OLE_SHIFT)
#define  fGPIOA_OLDER_OLE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_OLDER_OLE_MASK) | (((uint32_t)val) << fGPIOA_OLDER_OLE_SHIFT))

//====================================================================
//Register: Interrupt Target Enable Register (Instance 1 of 2) (ITER0)
/** \brief This register enables interrupts to be generated from the enabled edge detects of the
      corresponding bits. There is one enable register per configured interrupt target. (Instance 1 of 2)*/
//====================================================================

#define  fGPIOA_ITER0_RESERVED1_MASK 0xffff8000
#define  fGPIOA_ITER0_RESERVED1_SHIFT 15
#define  fGPIOA_ITER0_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_ITER0_RESERVED1_MASK) >> fGPIOA_ITER0_RESERVED1_SHIFT)
#define  fGPIOA_ITER0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_ITER0_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_ITER0_RESERVED1_SHIFT))

#define  fGPIOA_ITER0_IE_MASK 0x7fff
#define  fGPIOA_ITER0_IE_SHIFT 0
#define  fGPIOA_ITER0_IE_MASK_SHIFT(reg) (((reg) & fGPIOA_ITER0_IE_MASK) >> fGPIOA_ITER0_IE_SHIFT)
#define  fGPIOA_ITER0_IE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_ITER0_IE_MASK) | (((uint32_t)val) << fGPIOA_ITER0_IE_SHIFT))

//====================================================================
//Register: Interrupt Target Enable Register (Instance 2 of 2) (ITER1)
/** \brief This register enables interrupts to be generated from the enabled edge detects of the
      corresponding bits. There is one enable register per configured interrupt target. (Instance 2 of 2)*/
//====================================================================

#define  fGPIOA_ITER1_RESERVED1_MASK 0xffff8000
#define  fGPIOA_ITER1_RESERVED1_SHIFT 15
#define  fGPIOA_ITER1_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_ITER1_RESERVED1_MASK) >> fGPIOA_ITER1_RESERVED1_SHIFT)
#define  fGPIOA_ITER1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_ITER1_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_ITER1_RESERVED1_SHIFT))

#define  fGPIOA_ITER1_IE_MASK 0x7fff
#define  fGPIOA_ITER1_IE_SHIFT 0
#define  fGPIOA_ITER1_IE_MASK_SHIFT(reg) (((reg) & fGPIOA_ITER1_IE_MASK) >> fGPIOA_ITER1_IE_SHIFT)
#define  fGPIOA_ITER1_IE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_ITER1_IE_MASK) | (((uint32_t)val) << fGPIOA_ITER1_IE_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  fGPIOA_REV0_MAJ_MASK 0xffff0000
#define  fGPIOA_REV0_MAJ_SHIFT 16
#define  fGPIOA_REV0_MAJ_MASK_SHIFT(reg) (((reg) & fGPIOA_REV0_MAJ_MASK) >> fGPIOA_REV0_MAJ_SHIFT)
#define  fGPIOA_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_REV0_MAJ_MASK) | (((uint32_t)val) << fGPIOA_REV0_MAJ_SHIFT))

#define  fGPIOA_REV0_MID_MASK 0xffff
#define  fGPIOA_REV0_MID_SHIFT 0
#define  fGPIOA_REV0_MID_MASK_SHIFT(reg) (((reg) & fGPIOA_REV0_MID_MASK) >> fGPIOA_REV0_MID_SHIFT)
#define  fGPIOA_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_REV0_MID_MASK) | (((uint32_t)val) << fGPIOA_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  fGPIOA_REV1_RESERVED1_MASK 0xffff0000
#define  fGPIOA_REV1_RESERVED1_SHIFT 16
#define  fGPIOA_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOA_REV1_RESERVED1_MASK) >> fGPIOA_REV1_RESERVED1_SHIFT)
#define  fGPIOA_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_REV1_RESERVED1_MASK) | (((uint32_t)val) << fGPIOA_REV1_RESERVED1_SHIFT))

#define  fGPIOA_REV1_CFG_MASK 0xffff
#define  fGPIOA_REV1_CFG_SHIFT 0
#define  fGPIOA_REV1_CFG_MASK_SHIFT(reg) (((reg) & fGPIOA_REV1_CFG_MASK) >> fGPIOA_REV1_CFG_SHIFT)
#define  fGPIOA_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~fGPIOA_REV1_CFG_MASK) | (((uint32_t)val) << fGPIOA_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: GpioB Registers (GpioB)
/** \brief (rev 1 . 1 . 3 . 2)
    The fGPIO block registers provide the means to configure the characteristics of each fGPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

//====================================================================
//Register: fGPIO Pin Direction Register (PDR)
/** \brief The bits in this register determine if the corresponding fGPIO pin is in input or output
      mode. A pair of set/clear registers are also provided to enable the setting and clearing
      of individual bits in this register.*/
//====================================================================

#define  fGPIOB_PDR_PD_MASK 0xffffffff
#define  fGPIOB_PDR_PD_SHIFT 0
#define  fGPIOB_PDR_PD_MASK_SHIFT(reg) (((reg) & fGPIOB_PDR_PD_MASK) >> fGPIOB_PDR_PD_SHIFT)
#define  fGPIOB_PDR_PD_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_PDR_PD_MASK) | (((uint32_t)val) << fGPIOB_PDR_PD_SHIFT))

//====================================================================
//Register: fGPIO Pin Output Set Register (PSR)
/** \brief Writing any bit in this register to a '1' will set the corresponding pin to '1' if
      that bit is in output mode (PDR bit set to '1'). Data bits corresponding to bits that
      are written as '0' in this register not be affected by the write to this register. Pins
      in input mode (PDR bit set to '0') will not be affected immediately by writes to this
      register, but when the pin is switched to output mode via the PDR register, the output
      state from the most recent write to the PSR or the PCR will be driven on the pin.*/
//====================================================================

#define  fGPIOB_PSR_PS_MASK 0xffffffff
#define  fGPIOB_PSR_PS_SHIFT 0
#define  fGPIOB_PSR_PS_MASK_SHIFT(reg) (((reg) & fGPIOB_PSR_PS_MASK) >> fGPIOB_PSR_PS_SHIFT)
#define  fGPIOB_PSR_PS_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_PSR_PS_MASK) | (((uint32_t)val) << fGPIOB_PSR_PS_SHIFT))

//====================================================================
//Register: fGPIO Pin Output Clear Register (PCR)
/** \brief Writing any bit in this register to a '1' will clear the corresponding pin to '0' if
      that bit is in output mode (PDR bit set to '1'). Data bits corresponding to bits that
      are written as '0' in this register not be affected by the write to this register. Pins
      in input mode (PDR bit set to '0') will not be affected immediately by writes to this
      register, but when the pin is switched to output mode via the PDR register, the output
      state from the most recent write to the PSR or the PCR will be driven on the pin.*/
//====================================================================

#define  fGPIOB_PCR_PC_MASK 0xffffffff
#define  fGPIOB_PCR_PC_SHIFT 0
#define  fGPIOB_PCR_PC_MASK_SHIFT(reg) (((reg) & fGPIOB_PCR_PC_MASK) >> fGPIOB_PCR_PC_SHIFT)
#define  fGPIOB_PCR_PC_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_PCR_PC_MASK) | (((uint32_t)val) << fGPIOB_PCR_PC_SHIFT))

//====================================================================
//Register: fGPIO Rising-Edge Detect Enable Register (RER)
/** \brief Setting a bit in this register enables rising-edge detection on the corresponding pin.
      When a rising edge (after deglitching, if deglitching is enabled for the pin) is detected
      on a pin which has the corresponding bit set in this register, the corresponding bit in
      the fGPIO Edge-detect status register will be set. <br />
      There are also a pair of set/clear registers for setting and clearing individual bits
      of this register. Reading this register will show the current rising-edge enable
      state of each bit, whether written directly at this address, or set/cleared via the
      set/clear registers.*/
//====================================================================

#define  fGPIOB_RER_RE_MASK 0xffffffff
#define  fGPIOB_RER_RE_SHIFT 0
#define  fGPIOB_RER_RE_MASK_SHIFT(reg) (((reg) & fGPIOB_RER_RE_MASK) >> fGPIOB_RER_RE_SHIFT)
#define  fGPIOB_RER_RE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_RER_RE_MASK) | (((uint32_t)val) << fGPIOB_RER_RE_SHIFT))

//====================================================================
//Register: fGPIO Falling-Edge Detect Enable Register (FER)
/** \brief Setting a bit in this register enables falling-edge detection on the corresponding pin.
      When a falling edge (after deglitching, if deglitching is enabled for the pin) is detected
      on a pin which has the corresponding bit set in this register, the corresponding bit in
      the fGPIO Edge-detect status register will be set. <br />
      There are also a pair of set/clear registers for setting and clearing individual bits
      of this register. Reading this register will show the current falling-edge enable
      state of each bit, whether written directly at this address, or set/cleared via the
      set/clear registers.*/
//====================================================================

#define  fGPIOB_FER_FE_MASK 0xffffffff
#define  fGPIOB_FER_FE_SHIFT 0
#define  fGPIOB_FER_FE_MASK_SHIFT(reg) (((reg) & fGPIOB_FER_FE_MASK) >> fGPIOB_FER_FE_SHIFT)
#define  fGPIOB_FER_FE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_FER_FE_MASK) | (((uint32_t)val) << fGPIOB_FER_FE_SHIFT))

//====================================================================
//Register: fGPIO Edge-detect Status Register (EDR)
/** \brief This register provides access to the edge-detect status of each pin. A pin may be enabled
      for rising-edge detect by setting the corresponding bit in the RER register, for
      falling-edge detect by setting the corresponding bit in the FER register, for detection
      of either kind of edge by setting the corresponding bits in both the RER and FER registers,
      or for no edge detection by clearing the corresponding bits in both the RER and FER
      registers. When an enabled edge is detected on a pin, the corresponding bit is set in
      this register. The bits in this register can be cleared by writing a '1' to the bit.*/
//====================================================================

#define  fGPIOB_EDR_ED_MASK 0xffffffff
#define  fGPIOB_EDR_ED_SHIFT 0
#define  fGPIOB_EDR_ED_MASK_SHIFT(reg) (((reg) & fGPIOB_EDR_ED_MASK) >> fGPIOB_EDR_ED_SHIFT)
#define  fGPIOB_EDR_ED_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_EDR_ED_MASK) | (((uint32_t)val) << fGPIOB_EDR_ED_SHIFT))

//====================================================================
//Register: fGPIO Output Direction Set Register (SDR)
/** \brief Writing any bit in this register to a '1' will set the corresponding bit in the PDR
      to '1'. Pin direction bits corresponding to bits that are written as '0' in this register
      will not be affected by the write to this register.*/
//====================================================================

#define  fGPIOB_SDR_SD_MASK 0xffffffff
#define  fGPIOB_SDR_SD_SHIFT 0
#define  fGPIOB_SDR_SD_MASK_SHIFT(reg) (((reg) & fGPIOB_SDR_SD_MASK) >> fGPIOB_SDR_SD_SHIFT)
#define  fGPIOB_SDR_SD_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_SDR_SD_MASK) | (((uint32_t)val) << fGPIOB_SDR_SD_SHIFT))

//====================================================================
//Register: fGPIO Output Direction Clear Register (CDR)
/** \brief Writing any bit in this register to a '1' will clear the corresponding PDR bit
      to '0'. Pin direction bits corresponding to bits that are written as '0' in this register
      will not be affected by the write to this register.*/
//====================================================================

#define  fGPIOB_CDR_CD_MASK 0xffffffff
#define  fGPIOB_CDR_CD_SHIFT 0
#define  fGPIOB_CDR_CD_MASK_SHIFT(reg) (((reg) & fGPIOB_CDR_CD_MASK) >> fGPIOB_CDR_CD_SHIFT)
#define  fGPIOB_CDR_CD_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_CDR_CD_MASK) | (((uint32_t)val) << fGPIOB_CDR_CD_SHIFT))

//====================================================================
//Register: fGPIO Bit-wise Set of Rising-Edge Detect Enable Register (SRER)
/** \brief Writing any bit in this register to a '1' will set the corresponding RER bit
      to '1'. Rising-edge detect enable bits corresponding to bits that are written as '0'
      in this register will not be affected by the write to this register.*/
//====================================================================

#define  fGPIOB_SRER_SRE_MASK 0xffffffff
#define  fGPIOB_SRER_SRE_SHIFT 0
#define  fGPIOB_SRER_SRE_MASK_SHIFT(reg) (((reg) & fGPIOB_SRER_SRE_MASK) >> fGPIOB_SRER_SRE_SHIFT)
#define  fGPIOB_SRER_SRE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_SRER_SRE_MASK) | (((uint32_t)val) << fGPIOB_SRER_SRE_SHIFT))

//====================================================================
//Register: fGPIO Bit-wise Clear of Rising-Edge Detect Enable Register (CRER)
/** \brief Writing any bit in this register to a '1' will clear the corresponding RER bit
      to '0' if that bit is in semaphore mode. Rising-edge detect enable bits corresponding to
      bits that are written as '0' in this register will not be affected by the write to this
      register.*/
//====================================================================

#define  fGPIOB_CRER_CRE_MASK 0xffffffff
#define  fGPIOB_CRER_CRE_SHIFT 0
#define  fGPIOB_CRER_CRE_MASK_SHIFT(reg) (((reg) & fGPIOB_CRER_CRE_MASK) >> fGPIOB_CRER_CRE_SHIFT)
#define  fGPIOB_CRER_CRE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_CRER_CRE_MASK) | (((uint32_t)val) << fGPIOB_CRER_CRE_SHIFT))

//====================================================================
//Register: fGPIO Bit-wise Set of Falling-Edge Detect Enable Register (SFER)
/** \brief Writing any bit in this register to a '1' will set the corresponding FER bit
      to '1'. Falling-edge detect enable bits corresponding to bits that are written as '0'
      in this register will not be affected by the write to this register.*/
//====================================================================

#define  fGPIOB_SFER_SFE_MASK 0xffffffff
#define  fGPIOB_SFER_SFE_SHIFT 0
#define  fGPIOB_SFER_SFE_MASK_SHIFT(reg) (((reg) & fGPIOB_SFER_SFE_MASK) >> fGPIOB_SFER_SFE_SHIFT)
#define  fGPIOB_SFER_SFE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_SFER_SFE_MASK) | (((uint32_t)val) << fGPIOB_SFER_SFE_SHIFT))

//====================================================================
//Register: fGPIO Bit-wise Clear of Falling-Edge Detect Enable Register (CFER)
/** \brief Writing any bit in this register to a '1' will clear the corresponding FER bit
      to '0' if that bit is in semaphore mode. Falling-edge detect enable bits corresponding to
      bits that are written as '0' in this register will not be affected by the write to this
      register.*/
//====================================================================

#define  fGPIOB_CFER_CFE_MASK 0xffffffff
#define  fGPIOB_CFER_CFE_SHIFT 0
#define  fGPIOB_CFER_CFE_MASK_SHIFT(reg) (((reg) & fGPIOB_CFER_CFE_MASK) >> fGPIOB_CFER_CFE_SHIFT)
#define  fGPIOB_CFER_CFE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_CFER_CFE_MASK) | (((uint32_t)val) << fGPIOB_CFER_CFE_SHIFT))

//====================================================================
//Register: fGPIO Pin Level Register (PLR)
/** \brief The current state of the fGPIO pins in this bank (deglitched, for those pins which have
      deglitching enabled), can be read from this register. The state can be read regardless
      of whether it is in input or output mode.*/
//====================================================================

#define  fGPIOB_PLR_PL_MASK 0xffffffff
#define  fGPIOB_PLR_PL_SHIFT 0
#define  fGPIOB_PLR_PL_MASK_SHIFT(reg) (((reg) & fGPIOB_PLR_PL_MASK) >> fGPIOB_PLR_PL_SHIFT)
#define  fGPIOB_PLR_PL_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_PLR_PL_MASK) | (((uint32_t)val) << fGPIOB_PLR_PL_SHIFT))

//====================================================================
//Register: Output Level Register (OLR)
/** \brief This register allows the output level of multiple pins to be changed in opposite directions
      at the same time. This is not possible with the PSR and PCR registers. To avoid needing
      to do a read-modify-write of this register to avoid changing pins that are not to be
      affected, use the OLDER (Output Level Direct-write Enable Register). Only pins with their
      corresponding bit set in the OLDER will be affected by writes to this register. Note that
      only pins that have their output enable set will have their pin levels affected by writes
      to this register. <br />
      Reading this register will return the value that is or would be driven
      on the pin if it is placed in output mode. In other words, its value depends on the
      combination of writes to the OLDER, OLR, PCR, and PSR registers that have occured.*/
//====================================================================

#define  fGPIOB_OLR_OL_MASK 0xffffffff
#define  fGPIOB_OLR_OL_SHIFT 0
#define  fGPIOB_OLR_OL_MASK_SHIFT(reg) (((reg) & fGPIOB_OLR_OL_MASK) >> fGPIOB_OLR_OL_SHIFT)
#define  fGPIOB_OLR_OL_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_OLR_OL_MASK) | (((uint32_t)val) << fGPIOB_OLR_OL_SHIFT))

//====================================================================
//Register: Output Level Direct-write Enable Register (OLDER)
/** \brief Setting a bit in this register enables the corresponding pin to be affected by writes
      to the OLR register. Pins that are not enabled for direct writes by this register can still
      have their output levels affected by writes to the PSR and PCR registers.*/
//====================================================================

#define  fGPIOB_OLDER_OLE_MASK 0xffffffff
#define  fGPIOB_OLDER_OLE_SHIFT 0
#define  fGPIOB_OLDER_OLE_MASK_SHIFT(reg) (((reg) & fGPIOB_OLDER_OLE_MASK) >> fGPIOB_OLDER_OLE_SHIFT)
#define  fGPIOB_OLDER_OLE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_OLDER_OLE_MASK) | (((uint32_t)val) << fGPIOB_OLDER_OLE_SHIFT))

//====================================================================
//Register: Interrupt Target Enable Register (Instance 1 of 2) (ITER0)
/** \brief This register enables interrupts to be generated from the enabled edge detects of the
      corresponding bits. There is one enable register per configured interrupt target. (Instance 1 of 2)*/
//====================================================================

#define  fGPIOB_ITER0_IE_MASK 0xffffffff
#define  fGPIOB_ITER0_IE_SHIFT 0
#define  fGPIOB_ITER0_IE_MASK_SHIFT(reg) (((reg) & fGPIOB_ITER0_IE_MASK) >> fGPIOB_ITER0_IE_SHIFT)
#define  fGPIOB_ITER0_IE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_ITER0_IE_MASK) | (((uint32_t)val) << fGPIOB_ITER0_IE_SHIFT))

//====================================================================
//Register: Interrupt Target Enable Register (Instance 2 of 2) (ITER1)
/** \brief This register enables interrupts to be generated from the enabled edge detects of the
      corresponding bits. There is one enable register per configured interrupt target. (Instance 2 of 2)*/
//====================================================================

#define  fGPIOB_ITER1_IE_MASK 0xffffffff
#define  fGPIOB_ITER1_IE_SHIFT 0
#define  fGPIOB_ITER1_IE_MASK_SHIFT(reg) (((reg) & fGPIOB_ITER1_IE_MASK) >> fGPIOB_ITER1_IE_SHIFT)
#define  fGPIOB_ITER1_IE_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_ITER1_IE_MASK) | (((uint32_t)val) << fGPIOB_ITER1_IE_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  fGPIOB_REV0_MAJ_MASK 0xffff0000
#define  fGPIOB_REV0_MAJ_SHIFT 16
#define  fGPIOB_REV0_MAJ_MASK_SHIFT(reg) (((reg) & fGPIOB_REV0_MAJ_MASK) >> fGPIOB_REV0_MAJ_SHIFT)
#define  fGPIOB_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_REV0_MAJ_MASK) | (((uint32_t)val) << fGPIOB_REV0_MAJ_SHIFT))

#define  fGPIOB_REV0_MID_MASK 0xffff
#define  fGPIOB_REV0_MID_SHIFT 0
#define  fGPIOB_REV0_MID_MASK_SHIFT(reg) (((reg) & fGPIOB_REV0_MID_MASK) >> fGPIOB_REV0_MID_SHIFT)
#define  fGPIOB_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_REV0_MID_MASK) | (((uint32_t)val) << fGPIOB_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  fGPIOB_REV1_RESERVED1_MASK 0xffff0000
#define  fGPIOB_REV1_RESERVED1_SHIFT 16
#define  fGPIOB_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & fGPIOB_REV1_RESERVED1_MASK) >> fGPIOB_REV1_RESERVED1_SHIFT)
#define  fGPIOB_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_REV1_RESERVED1_MASK) | (((uint32_t)val) << fGPIOB_REV1_RESERVED1_SHIFT))

#define  fGPIOB_REV1_CFG_MASK 0xffff
#define  fGPIOB_REV1_CFG_SHIFT 0
#define  fGPIOB_REV1_CFG_MASK_SHIFT(reg) (((reg) & fGPIOB_REV1_CFG_MASK) >> fGPIOB_REV1_CFG_SHIFT)
#define  fGPIOB_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~fGPIOB_REV1_CFG_MASK) | (((uint32_t)val) << fGPIOB_REV1_CFG_SHIFT))

#endif // fGPIO_TOP
