 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file apb_top_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _AP_APB_REGSTRUCTS_H_
#define _AP_APB_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: AP APB Top (AP_APB)
/** \brief Register Descriptions for AP APB superblock*/
//
//====================================================================

//====================================================================
//
//Register File: I2C1 Registers (I2C1)
//
//====================================================================

typedef struct I2C1_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C1_REGS_t;

//====================================================================
//
//Register File: One Wire Registers (OWI)
/** \brief Registers for the 1-Wire Bus Master block*/
//
//====================================================================

typedef struct OWI_REGS_s
{
  volatile uint32_t W1CMDR;  ///< 0x0 [R/W]: OneWire Command Register
  volatile uint32_t W1TRR;  ///< 0x4 [R/W]: OneWire Transmit/Receive Buffer
  volatile uint32_t W1INTR;  ///< 0x8 [R]: OneWire Interrupt Register
  volatile uint32_t W1IER;  ///< 0xc [R/W]: OneWire Interrupt Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t W1CTRL;  ///< 0x14 [R/W]: OneWire Control Register
} OWI_REGS_t;

//====================================================================
//
//Register File: JTAG SW Registers (JTAG_SW)
//
//====================================================================

typedef struct JTAG_SW_REGS_s
{
  volatile uint32_t JTAGSW_EN;  ///< 0x0 [W]: Enable Software JTAG Register
  volatile uint32_t JTAGSW_CTRL;  ///< 0x4 [W]: Software JTAG Control Register
  volatile uint32_t JTAGSW_DATA;  ///< 0x8 [R]: Software JTAG Serial Data Register
  volatile uint32_t reserved0;
  volatile uint32_t JTAGSW_REV0;  ///< 0x10 [R]: Software JTAG Revision 0 Register
  volatile uint32_t JTAGSW_REV1;  ///< 0x14 [R]: Software JTAG Revision 1 Register
} JTAG_SW_REGS_t;

//====================================================================
//
//Register File: TIMEBASE2 Registers (TIMEBASE2)
/** \brief TIMEBASE2 block is used to generate timing periods that are useful to other blocks in the system, such as the APB Timers/watchdog, AUXADC, Engine Control, DDAC Audio, and DC Motor. By using a common configurable timebase, each block is not burdened with programmable dividers. <BR>
   TIMEBASE2 is programmable to generate desired period timing given an input reference clock. The reference clock can be fixed to a stable time standard such as a 25MHz crystal oscillator clock. <BR>
   TIMEBASE2 provides an APB register interface and output timebases, both in the bus clk domain. There are six output timebases provided - 1us, 10us, 100us, 1ms, 10ms, 100ms. Each output timebase is a train of single clock cycle pulses, where the start of each pulse is separated by the timebase perioud (1us, 10us, etc).*/
//
//====================================================================

typedef struct TIMEBASE2_REGS_s
{
  volatile uint32_t TCR;  ///< 0x0 [R/W]: Timebase Configuration Register
  volatile uint32_t TTR;  ///< 0x4 [R/W]: Timebase Testing Register
  volatile uint32_t REV0;  ///< 0x8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc [R]: IP Tagging Revision 1
} TIMEBASE2_REGS_t;

//====================================================================
//
//Register File: Timers Registers (Timers)
//
//====================================================================

typedef struct TIMERS_REGS_s
{
  volatile uint32_t TMR_CCR;  ///< 0x0 [R/W]: Timer Clock Control Register
  volatile uint32_t TMR_Tn_Mm0;  ///< 0x4 [R/W]: Timer Match Registers (Instance 1 of 9)
  volatile uint32_t TMR_Tn_Mm1;  ///< 0x8 [R/W]: Timer Match Registers (Instance 2 of 9)
  volatile uint32_t TMR_Tn_Mm2;  ///< 0xc [R/W]: Timer Match Registers (Instance 3 of 9)
  volatile uint32_t TMR_Tn_Mm3;  ///< 0x10 [R/W]: Timer Match Registers (Instance 4 of 9)
  volatile uint32_t TMR_Tn_Mm4;  ///< 0x14 [R/W]: Timer Match Registers (Instance 5 of 9)
  volatile uint32_t TMR_Tn_Mm5;  ///< 0x18 [R/W]: Timer Match Registers (Instance 6 of 9)
  volatile uint32_t TMR_Tn_Mm6;  ///< 0x1c [R/W]: Timer Match Registers (Instance 7 of 9)
  volatile uint32_t TMR_Tn_Mm7;  ///< 0x20 [R/W]: Timer Match Registers (Instance 8 of 9)
  volatile uint32_t TMR_Tn_Mm8;  ///< 0x24 [R/W]: Timer Match Registers (Instance 9 of 9)
  volatile uint32_t TMR_CRn0;  ///< 0x28 [R]: Timer Count Registers (Instance 1 of 3)
  volatile uint32_t TMR_CRn1;  ///< 0x2c [R]: Timer Count Registers (Instance 2 of 3)
  volatile uint32_t TMR_CRn2;  ///< 0x30 [R]: Timer Count Registers (Instance 3 of 3)
  volatile uint32_t TMR_SRn0;  ///< 0x34 [R]: Timer Status Registers (Instance 1 of 3)
  volatile uint32_t TMR_SRn1;  ///< 0x38 [R]: Timer Status Registers (Instance 2 of 3)
  volatile uint32_t TMR_SRn2;  ///< 0x3c [R]: Timer Status Registers (Instance 3 of 3)
  volatile uint32_t TMR_IERn0;  ///< 0x40 [R/W]: Timer Interrupt Enable Registers (Instance 1 of 3)
  volatile uint32_t TMR_IERn1;  ///< 0x44 [R/W]: Timer Interrupt Enable Registers (Instance 2 of 3)
  volatile uint32_t TMR_IERn2;  ///< 0x48 [R/W]: Timer Interrupt Enable Registers (Instance 3 of 3)
  volatile uint32_t TMR_PLVRn0;  ///< 0x4c [R/W]: Timer Preload Value Registers (Instance 1 of 3)
  volatile uint32_t TMR_PLVRn1;  ///< 0x50 [R/W]: Timer Preload Value Registers (Instance 2 of 3)
  volatile uint32_t TMR_PLVRn2;  ///< 0x54 [R/W]: Timer Preload Value Registers (Instance 3 of 3)
  volatile uint32_t TMR_PLCRn0;  ///< 0x58 [R/W]: Timer Preload Control Registers (Instance 1 of 3)
  volatile uint32_t TMR_PLCRn1;  ///< 0x5c [R/W]: Timer Preload Control Registers (Instance 2 of 3)
  volatile uint32_t TMR_PLCRn2;  ///< 0x60 [R/W]: Timer Preload Control Registers (Instance 3 of 3)
  volatile uint32_t TMR_WMER;  ///< 0x64 [R/W]: Timers Watchdog Match Enable Register
  volatile uint32_t TMR_WMR;  ///< 0x68 [R/W]: Timers Watchdog Match Register
  volatile uint32_t TMR_WVR;  ///< 0x6c [R]: Timers Watchdog Value Register
  volatile uint32_t TMR_WSR;  ///< 0x70 [R/W]: Timers Watchdog Status Register
  volatile uint32_t TMR_ICRn0;  ///< 0x74 [W]: Timer Interrupt Clear Registers (Instance 1 of 3)
  volatile uint32_t TMR_ICRn1;  ///< 0x78 [W]: Timer Interrupt Clear Registers (Instance 2 of 3)
  volatile uint32_t TMR_ICRn2;  ///< 0x7c [W]: Timer Interrupt Clear Registers (Instance 3 of 3)
  volatile uint32_t TMR_WICR;  ///< 0x80 [W]: Timers Watchdog Interrupt Clear Register
  volatile uint32_t TMR_CER;  ///< 0x84 [R/W]: Timers Count Enable Register
  volatile uint32_t TMR_CMR;  ///< 0x88 [R/W]: Timers Count Mode Register
  volatile uint32_t TMR_ILRn0;  ///< 0x8c [R/W]: Timer Interrupt Length Registers (Instance 1 of 3)
  volatile uint32_t TMR_ILRn1;  ///< 0x90 [R/W]: Timer Interrupt Length Registers (Instance 2 of 3)
  volatile uint32_t TMR_ILRn2;  ///< 0x94 [R/W]: Timer Interrupt Length Registers (Instance 3 of 3)
  volatile uint32_t TMR_WCR;  ///< 0x98 [W]: Timers Watchdog Counter Reset Register
  volatile uint32_t TMR_WFAR;  ///< 0x9c [W]: Timers Watchdog First Access Register
  volatile uint32_t TMR_WSAR;  ///< 0xa0 [W]: Timers Watchdog Second Access Register
  volatile uint32_t TMR_CVWRn0;  ///< 0xa4 [R/W]: Timer Counters Value Write for Read Request Register (Instance 1 of 3)
  volatile uint32_t TMR_CVWRn1;  ///< 0xa8 [R/W]: Timer Counters Value Write for Read Request Register (Instance 2 of 3)
  volatile uint32_t TMR_CVWRn2;  ///< 0xac [R/W]: Timer Counters Value Write for Read Request Register (Instance 3 of 3)
  volatile uint32_t TMR_CRSR;  ///< 0xb0 [R/W]: Timer Counters restart register
  volatile uint32_t TMR_OFCR;  ///< 0xb4 [R/W]: Timers On the Fly Configuration Register
  volatile uint32_t REV0;  ///< 0xb8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xbc [R]: IP Tagging Revision 1
} TIMERS_REGS_t;

//====================================================================
//
//Register File: AIB Access Registers (AIBAccess)
//
//====================================================================

typedef struct AIBACCESS_REGS_s
{
  volatile uint32_t APBC_ASFAR;  ///< 0x0 [R/W]: AIB Code Locked First Access Register
  volatile uint32_t APBC_ASSAR;  ///< 0x4 [R/W]: AIB Code Locked Second Access Register
} AIBACCESS_REGS_t;

//====================================================================
//
//Register File: UART4 Registers (UART4)
//
//====================================================================

typedef struct UART4_REGS_s
{
 union {
  volatile uint32_t UART_RBR;  ///< 0x0 [R]: Receive Buffer Register
  volatile uint32_t UART_THR;  ///< 0x0 [W]: Transmit Holding Register
  volatile uint32_t UART_DLL;  ///< 0x0 [R/W]: Divisor Latch Low Byte Register
 } union0;
 union {
  volatile uint32_t UART_IER;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t UART_DLH;  ///< 0x4 [R/W]: Divisor Latch High Byte Register
 } union1;
 union {
  volatile uint32_t UART_IIR;  ///< 0x8 [R]: Interrupt Identification Register
  volatile uint32_t UART_FCR;  ///< 0x8 [W]: FIFO Control Register
 } union2;
  volatile uint32_t UART_LCR;  ///< 0xc [R/W]: Line Control Register
  volatile uint32_t UART_MCR;  ///< 0x10 [R/W]: Modem Control Register
  volatile uint32_t UART_LSR;  ///< 0x14 [R]: Line Status Register
  volatile uint32_t UART_MSR;  ///< 0x18 [R]: Modem Status Register
  volatile uint32_t UART_SCR;  ///< 0x1c [R/W]: Scratchpad Register
  volatile uint32_t UART_ISR;  ///< 0x20 [R/W]: Infrared Selection Register
  volatile uint32_t UART_FOR;  ///< 0x24 [R]: Receive FIFO Occupancy Register
  volatile uint32_t UART_ABR;  ///< 0x28 [R/W]: Auto-Baud Control Register
  volatile uint32_t UART_ACR;  ///< 0x2c [R]: Auto-Baud Count Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} UART4_REGS_t;

//====================================================================
//
//Register File: UART2 Registers (UART2)
//
//====================================================================

typedef struct UART2_REGS_s
{
 union {
  volatile uint32_t UART_RBR;  ///< 0x0 [R]: Receive Buffer Register
  volatile uint32_t UART_THR;  ///< 0x0 [W]: Transmit Holding Register
  volatile uint32_t UART_DLL;  ///< 0x0 [R/W]: Divisor Latch Low Byte Register
 } union0;
 union {
  volatile uint32_t UART_IER;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t UART_DLH;  ///< 0x4 [R/W]: Divisor Latch High Byte Register
 } union1;
 union {
  volatile uint32_t UART_IIR;  ///< 0x8 [R]: Interrupt Identification Register
  volatile uint32_t UART_FCR;  ///< 0x8 [W]: FIFO Control Register
 } union2;
  volatile uint32_t UART_LCR;  ///< 0xc [R/W]: Line Control Register
  volatile uint32_t UART_MCR;  ///< 0x10 [R/W]: Modem Control Register
  volatile uint32_t UART_LSR;  ///< 0x14 [R]: Line Status Register
  volatile uint32_t UART_MSR;  ///< 0x18 [R]: Modem Status Register
  volatile uint32_t UART_SCR;  ///< 0x1c [R/W]: Scratchpad Register
  volatile uint32_t UART_ISR;  ///< 0x20 [R/W]: Infrared Selection Register
  volatile uint32_t UART_FOR;  ///< 0x24 [R]: Receive FIFO Occupancy Register
  volatile uint32_t UART_ABR;  ///< 0x28 [R/W]: Auto-Baud Control Register
  volatile uint32_t UART_ACR;  ///< 0x2c [R]: Auto-Baud Count Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} UART2_REGS_t;

//====================================================================
//
//Register File: UART3 Registers (UART3)
//
//====================================================================

typedef struct UART3_REGS_s
{
 union {
  volatile uint32_t UART_RBR;  ///< 0x0 [R]: Receive Buffer Register
  volatile uint32_t UART_THR;  ///< 0x0 [W]: Transmit Holding Register
  volatile uint32_t UART_DLL;  ///< 0x0 [R/W]: Divisor Latch Low Byte Register
 } union0;
 union {
  volatile uint32_t UART_IER;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t UART_DLH;  ///< 0x4 [R/W]: Divisor Latch High Byte Register
 } union1;
 union {
  volatile uint32_t UART_IIR;  ///< 0x8 [R]: Interrupt Identification Register
  volatile uint32_t UART_FCR;  ///< 0x8 [W]: FIFO Control Register
 } union2;
  volatile uint32_t UART_LCR;  ///< 0xc [R/W]: Line Control Register
  volatile uint32_t UART_MCR;  ///< 0x10 [R/W]: Modem Control Register
  volatile uint32_t UART_LSR;  ///< 0x14 [R]: Line Status Register
  volatile uint32_t UART_MSR;  ///< 0x18 [R]: Modem Status Register
  volatile uint32_t UART_SCR;  ///< 0x1c [R/W]: Scratchpad Register
  volatile uint32_t UART_ISR;  ///< 0x20 [R/W]: Infrared Selection Register
  volatile uint32_t UART_FOR;  ///< 0x24 [R]: Receive FIFO Occupancy Register
  volatile uint32_t UART_ABR;  ///< 0x28 [R/W]: Auto-Baud Control Register
  volatile uint32_t UART_ACR;  ///< 0x2c [R]: Auto-Baud Count Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} UART3_REGS_t;

//====================================================================
//
//Register File: GPIO Registers (GPIO)
/** \brief Register Descriptions for the GPIO banks*/
//
//====================================================================

//====================================================================
//
//Register File: Pad Edge Registers (PadEdge)
/** \brief (rev 0 . 1 . 0 . 0)
    Register Descriptions for the Pad Edge Detect banks*/
//
//====================================================================

typedef struct PADEDGE_REGS_s
{
  volatile uint32_t reserved0[8];
  volatile uint32_t REV0;  ///< 0x20 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x24 [R]: IP Tagging Revision 1
} PADEDGE_REGS_t;

//====================================================================
//
//Register File: IPC Registers (Instance 1 of 2) (IPC0)
/** \brief Register Descriptions for the IPC (rev 0 . 3 . 2 . 0)*/
//
//====================================================================

typedef struct IPC0_REGS_s
{
  volatile uint32_t IPC_ISRR;  ///< 0x0 [R]: IPC_ISRR
  volatile uint32_t IPC_WDR_0;  ///< 0x4 [W]: Write Data Register 0
  volatile uint32_t IPC_WDR_1;  ///< 0x8 [W]: Write Data Register 1
  volatile uint32_t IPC_ISRW;  ///< 0xc [W]: Interrupt Set Register Write
  volatile uint32_t IPC_ICR;  ///< 0x10 [W]: Interrupt Clear Register
  volatile uint32_t IPC_IIR;  ///< 0x14 [R]: Interrupt Identification Register
  volatile uint32_t IPC_RDR_0;  ///< 0x18 [R]: Read Data Register 0
  volatile uint32_t IPC_RDR_1;  ///< 0x1c [R]: Read Data Register 1
  volatile uint32_t IPC_MAJ_MID_REV;  ///< 0x20 [R]: Revision (Major and Mid) Register
  volatile uint32_t IPC_CFG_REV;  ///< 0x24 [R]: Revision (Configuration) Register
  volatile uint32_t IPC_DUMMY;  ///< 0x28 [W]: Dummy Register
} IPC0_REGS_t;

//====================================================================
//
//Register File: IPC Registers (Instance 2 of 2) (IPC1)
/** \brief Register Descriptions for the IPC (rev 0 . 3 . 2 . 0)*/
//
//====================================================================

typedef struct IPC1_REGS_s
{
  volatile uint32_t IPC_ISRR;  ///< 0x0 [R]: IPC_ISRR
  volatile uint32_t IPC_WDR_0;  ///< 0x4 [W]: Write Data Register 0
  volatile uint32_t IPC_WDR_1;  ///< 0x8 [W]: Write Data Register 1
  volatile uint32_t IPC_ISRW;  ///< 0xc [W]: Interrupt Set Register Write
  volatile uint32_t IPC_ICR;  ///< 0x10 [W]: Interrupt Clear Register
  volatile uint32_t IPC_IIR;  ///< 0x14 [R]: Interrupt Identification Register
  volatile uint32_t IPC_RDR_0;  ///< 0x18 [R]: Read Data Register 0
  volatile uint32_t IPC_RDR_1;  ///< 0x1c [R]: Read Data Register 1
  volatile uint32_t IPC_MAJ_MID_REV;  ///< 0x20 [R]: Revision (Major and Mid) Register
  volatile uint32_t IPC_CFG_REV;  ///< 0x24 [R]: Revision (Configuration) Register
  volatile uint32_t IPC_DUMMY;  ///< 0x28 [W]: Dummy Register
} IPC1_REGS_t;

//====================================================================
//
//Register File: APB Config Registers (apb_config)
//
//====================================================================

typedef struct APB_CONFIG_REGS_s
{
  volatile uint32_t DFTISLD_REV0;  ///< 0x0 [R]: DFT Island IP Tagging REV0
  volatile uint32_t DFTISLD_REV1;  ///< 0x4 [R]: DFT Island IP Tagging REV1
  volatile uint32_t NDSMC_REV0;  ///< 0x8 [R]: NDSMC IP Tagging REV0
  volatile uint32_t NDSMC_REV1;  ///< 0xc [R]: NDSMC IP Tagging REV1
  volatile uint32_t USB3DEV_REV0;  ///< 0x10 [R]: USB3DEV IP Tagging REV0
  volatile uint32_t USB3DEV_REV1;  ///< 0x14 [R]: USB3DEV IP Tagging REV1
  volatile uint32_t USB3HOST_REV0;  ///< 0x18 [R]: USB3HOST IP Tagging REV0
  volatile uint32_t USB3HOST_REV1;  ///< 0x1c [R]: USB3HOST IP Tagging REV1
  volatile uint32_t USB2HOST_REV0;  ///< 0x20 [R]: USB2HOST IP Tagging REV0
  volatile uint32_t USB2HOST_REV1;  ///< 0x24 [R]: USB2HOST IP Tagging REV1
  volatile uint32_t USB2DEVHOST_REV0;  ///< 0x28 [R]: USB2DEVHOST IP Tagging REV0
  volatile uint32_t USB2DEVHOST_REV1;  ///< 0x2c [R]: USB2DEVHOST IP Tagging REV1
  volatile uint32_t USB2TOP_REV0;  ///< 0x30 [R]: USB2TOP IP Tagging REV0
  volatile uint32_t USB2TOP_REV1;  ///< 0x34 [R]: USB2TOP IP Tagging REV1
  volatile uint32_t SATA_REV0;  ///< 0x38 [R]: SATA IP Tagging REV0
  volatile uint32_t SATA_REV1;  ///< 0x3c [R]: SATA IP Tagging REV1
  volatile uint32_t SQU_REV0;  ///< 0x40 [R]: SQU IP Tagging REV0
  volatile uint32_t SQU_REV1;  ///< 0x44 [R]: SQU IP Tagging REV1
  volatile uint32_t GC400_REV0;  ///< 0x48 [R]: GC400 IP Tagging REV0
  volatile uint32_t GC400_REV1;  ///< 0x4c [R]: GC400 IP Tagging REV1
  volatile uint32_t PDMA_REV0;  ///< 0x50 [R]: PDMA IP Tagging REV0
  volatile uint32_t PDMA_REV1;  ///< 0x54 [R]: PDMA IP Tagging REV1
  volatile uint32_t USB3HnD;  ///< 0x58 [R/W]: USB3_Host_Device
  volatile uint32_t strap_in;  ///< 0x5c [R]: Strap_in
  volatile uint32_t Fuse_Bank0_R0;  ///< 0x60 [R]: Fuse_Bank0_R0
  volatile uint32_t Fuse_Bank0_R1;  ///< 0x64 [R]: Fuse_Bank0_R1
  volatile uint32_t Fuse_Bank0_R2;  ///< 0x68 [R]: Fuse_Bank0_R2
  volatile uint32_t Fuse_Bank0_R3;  ///< 0x6c [R]: Fuse_Bank0_R3
  volatile uint32_t Fuse_Bank0_R4;  ///< 0x70 [R]: Fuse_Bank0_R4
  volatile uint32_t Fuse_Bank0_R5;  ///< 0x74 [R]: Fuse_Bank0_R5
  volatile uint32_t Fuse_Bank0_R6;  ///< 0x78 [R]: Fuse_Bank0_R6
  volatile uint32_t Fuse_Bank0_R7;  ///< 0x7c [R]: Fuse_Bank0_R7
  volatile uint32_t Fuse_Bank0_R8;  ///< 0x80 [R]: Fuse_Bank0_R8
  volatile uint32_t Fuse_Bank1_R0;  ///< 0x84 [R]: Fuse_Bank1_R0
  volatile uint32_t Fuse_Bank1_R1;  ///< 0x88 [R]: Fuse_Bank1_R1
  volatile uint32_t Fuse_Bank1_R2;  ///< 0x8c [R]: Fuse_Bank1_R2
  volatile uint32_t Fuse_Bank1_R3;  ///< 0x90 [R]: Fuse_Bank1_R3
  volatile uint32_t Fuse_Bank1_R4;  ///< 0x94 [R]: Fuse_Bank1_R4
  volatile uint32_t Fuse_Bank1_R5;  ///< 0x98 [R]: Fuse_Bank1_R5
  volatile uint32_t Fuse_Bank1_R6;  ///< 0x9c [R]: Fuse_Bank1_R6
  volatile uint32_t Fuse_Bank1_R7;  ///< 0xa0 [R]: Fuse_Bank1_R7
  volatile uint32_t Fuse_Bank1_R8;  ///< 0xa4 [R]: Fuse_Bank1_R8
  volatile uint32_t Fuse_Bank2_R0;  ///< 0xa8 [R]: Fuse_Bank2_R0
  volatile uint32_t Fuse_Bank2_R1;  ///< 0xac [R]: Fuse_Bank2_R1
  volatile uint32_t Fuse_Bank2_R2;  ///< 0xb0 [R]: Fuse_Bank2_R2
  volatile uint32_t Fuse_Bank2_R3;  ///< 0xb4 [R]: Fuse_Bank2_R3
  volatile uint32_t Fuse_Bank2_R4;  ///< 0xb8 [R]: Fuse_Bank2_R4
  volatile uint32_t Fuse_Bank2_R5;  ///< 0xbc [R]: Fuse_Bank2_R5
  volatile uint32_t Fuse_Bank2_R6;  ///< 0xc0 [R]: Fuse_Bank2_R6
  volatile uint32_t Fuse_Bank2_R7;  ///< 0xc4 [R]: Fuse_Bank2_R7
  volatile uint32_t Fuse_Bank2_R8;  ///< 0xc8 [R]: Fuse_Bank2_R8
  volatile uint32_t Fuse_Bank3_R0;  ///< 0xcc [R]: Fuse_Bank3_R0
  volatile uint32_t Fuse_Bank3_R1;  ///< 0xd0 [R]: Fuse_Bank3_R1
  volatile uint32_t Fuse_Bank3_R2;  ///< 0xd4 [R]: Fuse_Bank3_R2
  volatile uint32_t Fuse_Bank3_R3;  ///< 0xd8 [R]: Fuse_Bank3_R3
  volatile uint32_t Fuse_Bank3_R4;  ///< 0xdc [R]: Fuse_Bank3_R4
  volatile uint32_t Fuse_Bank3_R5;  ///< 0xe0 [R]: Fuse_Bank3_R5
  volatile uint32_t Fuse_Bank3_R6;  ///< 0xe4 [R]: Fuse_Bank3_R6
  volatile uint32_t Fuse_Bank3_R7;  ///< 0xe8 [R]: Fuse_Bank3_R7
  volatile uint32_t Fuse_Bank3_R8;  ///< 0xec [R]: Fuse_Bank3_R8
  volatile uint32_t Fuse_Bank4_R0;  ///< 0xf0 [R]: Fuse_Bank4_R0
  volatile uint32_t Fuse_Bank4_R1;  ///< 0xf4 [R]: Fuse_Bank4_R1
  volatile uint32_t Fuse_Bank4_R2;  ///< 0xf8 [R]: Fuse_Bank4_R2
  volatile uint32_t Fuse_Bank4_R3;  ///< 0xfc [R]: Fuse_Bank4_R3
  volatile uint32_t Fuse_Bank4_R4;  ///< 0x100 [R]: Fuse_Bank4_R4
  volatile uint32_t Fuse_Bank4_R5;  ///< 0x104 [R]: Fuse_Bank4_R5
  volatile uint32_t Fuse_Bank4_R6;  ///< 0x108 [R]: Fuse_Bank4_R6
  volatile uint32_t Fuse_Bank4_R7;  ///< 0x10c [R]: Fuse_Bank4_R7
  volatile uint32_t Fuse_Bank4_R8;  ///< 0x110 [R]: Fuse_Bank4_R8
  volatile uint32_t Fuse_Bank5_R0;  ///< 0x114 [R]: Fuse_Bank5_R0
  volatile uint32_t Fuse_Bank5_R1;  ///< 0x118 [R]: Fuse_Bank5_R1
  volatile uint32_t Fuse_Bank5_R2;  ///< 0x11c [R]: Fuse_Bank5_R2
  volatile uint32_t Fuse_Bank5_R3;  ///< 0x120 [R]: Fuse_Bank5_R3
  volatile uint32_t Fuse_Bank5_R4;  ///< 0x124 [R]: Fuse_Bank5_R4
  volatile uint32_t Fuse_Bank5_R5;  ///< 0x128 [R]: Fuse_Bank5_R5
  volatile uint32_t Fuse_Bank5_R6;  ///< 0x12c [R]: Fuse_Bank5_R6
  volatile uint32_t Fuse_Bank5_R7;  ///< 0x130 [R]: Fuse_Bank5_R7
  volatile uint32_t Fuse_Bank5_R8;  ///< 0x134 [R]: Fuse_Bank5_R8
  volatile uint32_t Fuse_Bank6_R0;  ///< 0x138 [R]: Fuse_Bank6_R0
  volatile uint32_t Fuse_Bank6_R1;  ///< 0x13c [R]: Fuse_Bank6_R1
  volatile uint32_t Fuse_Bank6_R2;  ///< 0x140 [R]: Fuse_Bank6_R2
  volatile uint32_t Fuse_Bank6_R3;  ///< 0x144 [R]: Fuse_Bank6_R3
  volatile uint32_t Fuse_Bank6_R4;  ///< 0x148 [R]: Fuse_Bank6_R4
  volatile uint32_t Fuse_Bank6_R5;  ///< 0x14c [R]: Fuse_Bank6_R5
  volatile uint32_t Fuse_Bank6_R6;  ///< 0x150 [R]: Fuse_Bank6_R6
  volatile uint32_t Fuse_Bank6_R7;  ///< 0x154 [R]: Fuse_Bank6_R7
  volatile uint32_t Fuse_Bank6_R8;  ///< 0x158 [R]: Fuse_Bank6_R8
  volatile uint32_t Fuse_Bank7_R0;  ///< 0x15c [R]: Fuse_Bank7_R0
  volatile uint32_t Fuse_Bank7_R1;  ///< 0x160 [R]: Fuse_Bank7_R1
  volatile uint32_t Fuse_Bank7_R2;  ///< 0x164 [R]: Fuse_Bank7_R2
  volatile uint32_t Fuse_Bank7_R3;  ///< 0x168 [R]: Fuse_Bank7_R3
  volatile uint32_t Fuse_Bank7_R4;  ///< 0x16c [R]: Fuse_Bank7_R4
  volatile uint32_t Fuse_Bank7_R5;  ///< 0x170 [R]: Fuse_Bank7_R5
  volatile uint32_t Fuse_Bank7_R6;  ///< 0x174 [R]: Fuse_Bank7_R6
  volatile uint32_t Fuse_Bank7_R7;  ///< 0x178 [R]: Fuse_Bank7_R7
  volatile uint32_t Fuse_Bank7_R8;  ///< 0x17c [R]: Fuse_Bank7_R8
  volatile uint32_t Fuse_Bank8_R0;  ///< 0x180 [R]: Fuse_Bank8_R0
  volatile uint32_t Fuse_Bank8_R1;  ///< 0x184 [R]: Fuse_Bank8_R1
  volatile uint32_t Fuse_Bank8_R2;  ///< 0x188 [R]: Fuse_Bank8_R2
  volatile uint32_t Fuse_Bank8_R3;  ///< 0x18c [R]: Fuse_Bank8_R3
  volatile uint32_t Fuse_Bank8_R4;  ///< 0x190 [R]: Fuse_Bank8_R4
  volatile uint32_t Fuse_Bank8_R5;  ///< 0x194 [R]: Fuse_Bank8_R5
  volatile uint32_t Fuse_Bank8_R6;  ///< 0x198 [R]: Fuse_Bank8_R6
  volatile uint32_t Fuse_Bank8_R7;  ///< 0x19c [R]: Fuse_Bank8_R7
  volatile uint32_t Fuse_Bank8_R8;  ///< 0x1a0 [R]: Fuse_Bank8_R8
  volatile uint32_t Fuse_Bank9_R0;  ///< 0x1a4 [R]: Fuse_Bank9_R0
  volatile uint32_t Fuse_Bank9_R1;  ///< 0x1a8 [R]: Fuse_Bank9_R1
  volatile uint32_t Fuse_Bank9_R2;  ///< 0x1ac [R]: Fuse_Bank9_R2
  volatile uint32_t Fuse_Bank9_R3;  ///< 0x1b0 [R]: Fuse_Bank9_R3
  volatile uint32_t Fuse_Bank9_R4;  ///< 0x1b4 [R]: Fuse_Bank9_R4
  volatile uint32_t Fuse_Bank9_R5;  ///< 0x1b8 [R]: Fuse_Bank9_R5
  volatile uint32_t Fuse_Bank9_R6;  ///< 0x1bc [R]: Fuse_Bank9_R6
  volatile uint32_t Fuse_Bank9_R7;  ///< 0x1c0 [R]: Fuse_Bank9_R7
  volatile uint32_t Fuse_Bank9_R8;  ///< 0x1c4 [R]: Fuse_Bank9_R8
  volatile uint32_t Fuse_Bank10_R0;  ///< 0x1c8 [R]: Fuse_Bank10_R0
  volatile uint32_t Fuse_Bank10_R1;  ///< 0x1cc [R]: Fuse_Bank10_R1
  volatile uint32_t Fuse_Bank10_R2;  ///< 0x1d0 [R]: Fuse_Bank10_R2
  volatile uint32_t Fuse_Bank10_R3;  ///< 0x1d4 [R]: Fuse_Bank10_R3
  volatile uint32_t Fuse_Bank10_R4;  ///< 0x1d8 [R]: Fuse_Bank10_R4
  volatile uint32_t Fuse_Bank10_R5;  ///< 0x1dc [R]: Fuse_Bank10_R5
  volatile uint32_t Fuse_Bank10_R6;  ///< 0x1e0 [R]: Fuse_Bank10_R6
  volatile uint32_t Fuse_Bank10_R7;  ///< 0x1e4 [R]: Fuse_Bank10_R7
  volatile uint32_t Fuse_Bank10_R8;  ///< 0x1e8 [R]: Fuse_Bank10_R8
  volatile uint32_t Fuse_Bank11_R0;  ///< 0x1ec [R]: Fuse_Bank11_R0
  volatile uint32_t Fuse_Bank11_R1;  ///< 0x1f0 [R]: Fuse_Bank11_R1
  volatile uint32_t Fuse_Bank11_R2;  ///< 0x1f4 [R]: Fuse_Bank11_R2
  volatile uint32_t Fuse_Bank11_R3;  ///< 0x1f8 [R]: Fuse_Bank11_R3
  volatile uint32_t Fuse_Bank11_R4;  ///< 0x1fc [R]: Fuse_Bank11_R4
  volatile uint32_t Fuse_Bank11_R5;  ///< 0x200 [R]: Fuse_Bank11_R5
  volatile uint32_t Fuse_Bank11_R6;  ///< 0x204 [R]: Fuse_Bank11_R6
  volatile uint32_t Fuse_Bank11_R7;  ///< 0x208 [R]: Fuse_Bank11_R7
  volatile uint32_t Fuse_Bank11_R8;  ///< 0x20c [R]: Fuse_Bank11_R8
  volatile uint32_t Fuse_Bank12_R0;  ///< 0x210 [R]: Fuse_Bank12_R0
  volatile uint32_t Fuse_Bank12_R1;  ///< 0x214 [R]: Fuse_Bank12_R1
  volatile uint32_t Fuse_Bank12_R2;  ///< 0x218 [R]: Fuse_Bank12_R2
  volatile uint32_t Fuse_Bank12_R3;  ///< 0x21c [R]: Fuse_Bank12_R3
  volatile uint32_t Fuse_Bank12_R4;  ///< 0x220 [R]: Fuse_Bank12_R4
  volatile uint32_t Fuse_Bank12_R5;  ///< 0x224 [R]: Fuse_Bank12_R5
  volatile uint32_t Fuse_Bank12_R6;  ///< 0x228 [R]: Fuse_Bank12_R6
  volatile uint32_t Fuse_Bank12_R7;  ///< 0x22c [R]: Fuse_Bank12_R7
  volatile uint32_t Fuse_Bank12_R8;  ///< 0x230 [R]: Fuse_Bank12_R8
  volatile uint32_t Fuse_Bank13_R0;  ///< 0x234 [R]: Fuse_Bank13_R0
  volatile uint32_t Fuse_Bank13_R1;  ///< 0x238 [R]: Fuse_Bank13_R1
  volatile uint32_t Fuse_Bank13_R2;  ///< 0x23c [R]: Fuse_Bank13_R2
  volatile uint32_t Fuse_Bank13_R3;  ///< 0x240 [R]: Fuse_Bank13_R3
  volatile uint32_t Fuse_Bank13_R4;  ///< 0x244 [R]: Fuse_Bank13_R4
  volatile uint32_t Fuse_Bank13_R5;  ///< 0x248 [R]: Fuse_Bank13_R5
  volatile uint32_t Fuse_Bank13_R6;  ///< 0x24c [R]: Fuse_Bank13_R6
  volatile uint32_t Fuse_Bank13_R7;  ///< 0x250 [R]: Fuse_Bank13_R7
  volatile uint32_t Fuse_Bank13_R8;  ///< 0x254 [R]: Fuse_Bank13_R8
  volatile uint32_t Fuse_Bank14_R0;  ///< 0x258 [R]: Fuse_Bank14_R0
  volatile uint32_t Fuse_Bank14_R1;  ///< 0x25c [R]: Fuse_Bank14_R1
  volatile uint32_t Fuse_Bank14_R2;  ///< 0x260 [R]: Fuse_Bank14_R2
  volatile uint32_t Fuse_Bank14_R3;  ///< 0x264 [R]: Fuse_Bank14_R3
  volatile uint32_t Fuse_Bank14_R4;  ///< 0x268 [R]: Fuse_Bank14_R4
  volatile uint32_t Fuse_Bank14_R5;  ///< 0x26c [R]: Fuse_Bank14_R5
  volatile uint32_t Fuse_Bank14_R6;  ///< 0x270 [R]: Fuse_Bank14_R6
  volatile uint32_t Fuse_Bank14_R7;  ///< 0x274 [R]: Fuse_Bank14_R7
  volatile uint32_t Fuse_Bank14_R8;  ///< 0x278 [R]: Fuse_Bank14_R8
  volatile uint32_t Fuse_Bank15_R0;  ///< 0x27c [R]: Fuse_Bank15_R0
  volatile uint32_t Fuse_Bank15_R1;  ///< 0x280 [R]: Fuse_Bank15_R1
  volatile uint32_t Fuse_Bank15_R2;  ///< 0x284 [R]: Fuse_Bank15_R2
  volatile uint32_t Fuse_Bank15_R3;  ///< 0x288 [R]: Fuse_Bank15_R3
  volatile uint32_t Fuse_Bank15_R4;  ///< 0x28c [R]: Fuse_Bank15_R4
  volatile uint32_t Fuse_Bank15_R5;  ///< 0x290 [R]: Fuse_Bank15_R5
  volatile uint32_t Fuse_Bank15_R6;  ///< 0x294 [R]: Fuse_Bank15_R6
  volatile uint32_t Fuse_Bank15_R7;  ///< 0x298 [R]: Fuse_Bank15_R7
  volatile uint32_t Fuse_Bank15_R8;  ///< 0x29c [R]: Fuse_Bank15_R8
} APB_CONFIG_REGS_t;

//====================================================================
//
//Register File: AIB Non Secure Registers - Padring (Padring)
/** \brief This register set includes all the registers for the padring I/O configuration*/
//
//====================================================================

//====================================================================
//
//Register File: AIB Non Secure Registers - AIB Extra Registers (AIB_Extra_Regs)
/** \brief This register set includes all the AIB registers for pad section control*/
//
//====================================================================

typedef struct AIB_EXTRA_REGS_REGS_s
{
  volatile uint32_t G3_ZPZN;  ///< 0x0 [R/W]: G3 Padsection ZP/ZN Register
  volatile uint32_t G4_ZPZN;  ///< 0x4 [R/W]: G4 Padsection ZP/ZN Register
  volatile uint32_t G6_ZPZN;  ///< 0x8 [R/W]: G6 Padsection ZP/ZN Register
  volatile uint32_t G7_ZPZN;  ///< 0xc [R/W]: G7 Padsection ZP/ZN Register
  volatile uint32_t G8_ZPZN;  ///< 0x10 [R/W]: G8 Padsection ZP/ZN Register
  volatile uint32_t G9_ZPZN;  ///< 0x14 [R/W]: G9 Padsection ZP/ZN Register
  volatile uint32_t G11_ZPZN;  ///< 0x18 [R/W]: G11 Padsection ZP/ZN Register
  volatile uint32_t V18EN;  ///< 0x1c [R/W]: V18EN control per pad section Register
  volatile uint32_t VSensor01;  ///< 0x20 [R/W]: VSensor01 Control Register
  volatile uint32_t VSensor02;  ///< 0x24 [R/W]: VSensor02 Control Register
  volatile uint32_t VSensor03;  ///< 0x28 [R/W]: VSensor03 Control Register
  volatile uint32_t VSensor04;  ///< 0x2c [R/W]: VSensor04 Control Register
  volatile uint32_t VSensor05;  ///< 0x30 [R/W]: VSensor05 Control Register
  volatile uint32_t CAL_EN;  ///< 0x34 [R/W]: Calibration Pad Enable Register
  volatile uint32_t CAL_ODR;  ///< 0x38 [R/W]: Calibration Pad On Die Resistor Control Register
  volatile uint32_t ZN;  ///< 0x3c [R/W]: ZN Calibration Value Register
  volatile uint32_t ZP;  ///< 0x40 [R/W]: ZP Calibration Value Register
  volatile uint32_t ZP_AFT_CAL;  ///< 0x44 [R/W]: ZP Calibration Setting After Cal. Register
  volatile uint32_t reserved0[234];
  volatile uint32_t SPARE0;  ///< 0x3f0 [R/W]: SPARE 0 Register
  volatile uint32_t SPARE1;  ///< 0x3f4 [R/W]: SPARE 1 Register
  volatile uint32_t SPARE2;  ///< 0x3f8 [R/W]: SPARE 2 Register
  volatile uint32_t SPARE3;  ///< 0x3fc [R/W]: SPARE 3 Register
} AIB_EXTRA_REGS_REGS_t;

//====================================================================
//
//Register File: AIB Secure Registers - Strap Override (Strap_Override)
//
//====================================================================

typedef struct STRAP_OVERRIDE_REGS_s
{
  volatile uint32_t SFO_FUSE_OVR_REG0;  ///< 0x0 [R/W]: Fuse Override Register 0
  volatile uint32_t SFO_FUSE_OVR_REG1;  ///< 0x4 [R/W]: Fuse Override Register 1
  volatile uint32_t SFO_FUSE_OVR_REG2;  ///< 0x8 [R/W]: Fuse Override Register 2
  volatile uint32_t SFO_FUSE_OVR_REG3;  ///< 0xc [R/W]: Fuse Override Register 3
  volatile uint32_t SFO_FUSE_OVR_REG4;  ///< 0x10 [R/W]: Fuse Override Register 4
  volatile uint32_t SFO_FUSE_OVR_REG5;  ///< 0x14 [R/W]: Fuse Override Register 5
  volatile uint32_t SFO_OVRD_CONF_REG0;  ///< 0x18 [R]: Overridden Configuration Register 0
  volatile uint32_t SFO_OVRD_CONF_REG1;  ///< 0x1c [R]: Overridden Configuration Register 1
  volatile uint32_t SFO_OVRD_CONF_REG2;  ///< 0x20 [R]: Overridden Configuration Register 2
  volatile uint32_t SFO_OVRD_CONF_REG3;  ///< 0x24 [R]: Overridden Configuration Register 3
  volatile uint32_t SFO_OVRD_CONF_REG4;  ///< 0x28 [R]: Overridden Configuration Register 4
  volatile uint32_t SFO_OVRD_CONF_REG5;  ///< 0x2c [R]: Overridden Configuration Register 5
} STRAP_OVERRIDE_REGS_t;

//====================================================================
//
//Register File: UART1 Registers (UART1)
//
//====================================================================

typedef struct UART1_REGS_s
{
 union {
  volatile uint32_t UART_RBR;  ///< 0x0 [R]: Receive Buffer Register
  volatile uint32_t UART_THR;  ///< 0x0 [W]: Transmit Holding Register
  volatile uint32_t UART_DLL;  ///< 0x0 [R/W]: Divisor Latch Low Byte Register
 } union0;
 union {
  volatile uint32_t UART_IER;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t UART_DLH;  ///< 0x4 [R/W]: Divisor Latch High Byte Register
 } union1;
 union {
  volatile uint32_t UART_IIR;  ///< 0x8 [R]: Interrupt Identification Register
  volatile uint32_t UART_FCR;  ///< 0x8 [W]: FIFO Control Register
 } union2;
  volatile uint32_t UART_LCR;  ///< 0xc [R/W]: Line Control Register
  volatile uint32_t UART_MCR;  ///< 0x10 [R/W]: Modem Control Register
  volatile uint32_t UART_LSR;  ///< 0x14 [R]: Line Status Register
  volatile uint32_t UART_MSR;  ///< 0x18 [R]: Modem Status Register
  volatile uint32_t UART_SCR;  ///< 0x1c [R/W]: Scratchpad Register
  volatile uint32_t UART_ISR;  ///< 0x20 [R/W]: Infrared Selection Register
  volatile uint32_t UART_FOR;  ///< 0x24 [R]: Receive FIFO Occupancy Register
  volatile uint32_t UART_ABR;  ///< 0x28 [R/W]: Auto-Baud Control Register
  volatile uint32_t UART_ACR;  ///< 0x2c [R]: Auto-Baud Count Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} UART1_REGS_t;

//====================================================================
//
//Register File: I2C2 Registers (I2C2)
//
//====================================================================

typedef struct I2C2_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C2_REGS_t;

//====================================================================
//
//Register File: I2C3 Registers (I2C3)
//
//====================================================================

typedef struct I2C3_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C3_REGS_t;

//====================================================================
//
//Register File: I2C4 Registers (I2C4)
//
//====================================================================

typedef struct I2C4_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C4_REGS_t;

//====================================================================
//
//Register File: I2C5 Registers (I2C5)
//
//====================================================================

typedef struct I2C5_REGS_s
{
  volatile uint32_t TWSI_IBMR;  ///< 0x0 [R]: TWSI Bus Monitor Register
  volatile uint32_t reserved0;
  volatile uint32_t TWSI_IDBR;  ///< 0x8 [R/W]: TWSI Data Buffer Register
  volatile uint32_t reserved1;
  volatile uint32_t TWSI_ICR;  ///< 0x10 [R/W]: TWSI Control Register
  volatile uint32_t reserved2;
  volatile uint32_t TWSI_ISR;  ///< 0x18 [R/W]: TWSI Status Register
  volatile uint32_t reserved3;
  volatile uint32_t TWSI_ISAR;  ///< 0x20 [R/W]: TWSI Slave Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TWSI_ILCR;  ///< 0x28 [R/W]: TWSI Load Count Register
  volatile uint32_t reserved5;
  volatile uint32_t TWSI_IWCR;  ///< 0x30 [R/W]: TWSI Wait Count Register
  volatile uint32_t reserved6[3];
  volatile uint32_t TWSI_WFIFO;  ///< 0x40 [W]: TWSI Write FIFO Register
  volatile uint32_t TWSI_WFIFO_WPTR;  ///< 0x44 [R/W]: TWSI Write FIFO Write Pointer Register
  volatile uint32_t TWSI_WFIFO_RPTR;  ///< 0x48 [R/W]: TWSI Write FIFO Read Pointer Register
  volatile uint32_t reserved7;
  volatile uint32_t TWSI_RFIFO;  ///< 0x50 [R]: TWSI Read FIFO Register
  volatile uint32_t TWSI_RFIFO_WPTR;  ///< 0x54 [R/W]: TWSI Read FIFO Write Pointer Register
  volatile uint32_t TWSI_RFIFO_RPTR;  ///< 0x58 [R/W]: TWSI Read FIFO Read Pointer Register
  volatile uint32_t reserved8;
  volatile uint32_t TWSI_FIFO_TSHLD;  ///< 0x60 [R/W]: TWSI FIFO Threshold Register
  volatile uint32_t reserved9[3];
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} I2C5_REGS_t;

//====================================================================
//
//Register File: SSP Registers (Instance 1 of 3) (SSP0)
//
//====================================================================

typedef struct SSP0_REGS_s
{
  volatile uint32_t SSP_SSCR0;  ///< 0x0 [R/W]: SSP Control Register 0
  volatile uint32_t SSP_SSCR1;  ///< 0x4 [R/W]: SSP Control Register 1
  volatile uint32_t SSP_SSSR;  ///< 0x8 [R]: SSP Status Register
  volatile uint32_t SSP_SSITR;  ///< 0xc [R/W]: SSP Interrupt Test Register
  volatile uint32_t SSP_SSDR;  ///< 0x10 [R/W]: SSP Data Register
  volatile uint32_t reserved0[5];
  volatile uint32_t SSP_SSTO;  ///< 0x28 [R/W]: SSP Time Out Register
  volatile uint32_t SSP_SSPSP;  ///< 0x2c [R/W]: SSP Programmable Serial Protocol Register
  volatile uint32_t SSP_SSTSA;  ///< 0x30 [R/W]: SSP TX Time Slot Active Register
  volatile uint32_t SSP_SSRSA;  ///< 0x34 [R/W]: SSP RX Time Slot Active Register
  volatile uint32_t SSP_SSTSS;  ///< 0x38 [R]: SSP Time Slot Status Register
  volatile uint32_t reserved1[17];
  volatile uint32_t SSP_GPS_ID;  ///< 0x80 [R]: GPS Controller ID Register
  volatile uint32_t SSP_GPS_CSR;  ///< 0x84 [R/W]: GPS Control and Status Register
  volatile uint32_t SSP_GPS_TSCNT;  ///< 0x88 [R]: Time Sync Count Register
  volatile uint32_t SSP_GPS_TSCNT_ADJ;  ///< 0x8c [R]: Time Sync Count Adjust Register
  volatile uint32_t reserved2[12];
  volatile uint32_t SSP_SPI_MOD;  ///< 0xc0 [R/W]: Modified SPI Mode Register
  volatile uint32_t REV0;  ///< 0xc4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc8 [R]: IP Tagging Revision 1
} SSP0_REGS_t;

//====================================================================
//
//Register File: SSP Registers (Instance 2 of 3) (SSP1)
//
//====================================================================

typedef struct SSP1_REGS_s
{
  volatile uint32_t SSP_SSCR0;  ///< 0x0 [R/W]: SSP Control Register 0
  volatile uint32_t SSP_SSCR1;  ///< 0x4 [R/W]: SSP Control Register 1
  volatile uint32_t SSP_SSSR;  ///< 0x8 [R]: SSP Status Register
  volatile uint32_t SSP_SSITR;  ///< 0xc [R/W]: SSP Interrupt Test Register
  volatile uint32_t SSP_SSDR;  ///< 0x10 [R/W]: SSP Data Register
  volatile uint32_t reserved0[5];
  volatile uint32_t SSP_SSTO;  ///< 0x28 [R/W]: SSP Time Out Register
  volatile uint32_t SSP_SSPSP;  ///< 0x2c [R/W]: SSP Programmable Serial Protocol Register
  volatile uint32_t SSP_SSTSA;  ///< 0x30 [R/W]: SSP TX Time Slot Active Register
  volatile uint32_t SSP_SSRSA;  ///< 0x34 [R/W]: SSP RX Time Slot Active Register
  volatile uint32_t SSP_SSTSS;  ///< 0x38 [R]: SSP Time Slot Status Register
  volatile uint32_t reserved1[17];
  volatile uint32_t SSP_GPS_ID;  ///< 0x80 [R]: GPS Controller ID Register
  volatile uint32_t SSP_GPS_CSR;  ///< 0x84 [R/W]: GPS Control and Status Register
  volatile uint32_t SSP_GPS_TSCNT;  ///< 0x88 [R]: Time Sync Count Register
  volatile uint32_t SSP_GPS_TSCNT_ADJ;  ///< 0x8c [R]: Time Sync Count Adjust Register
  volatile uint32_t reserved2[12];
  volatile uint32_t SSP_SPI_MOD;  ///< 0xc0 [R/W]: Modified SPI Mode Register
  volatile uint32_t REV0;  ///< 0xc4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc8 [R]: IP Tagging Revision 1
} SSP1_REGS_t;

//====================================================================
//
//Register File: SSP Registers (Instance 3 of 3) (SSP2)
//
//====================================================================

typedef struct SSP2_REGS_s
{
  volatile uint32_t SSP_SSCR0;  ///< 0x0 [R/W]: SSP Control Register 0
  volatile uint32_t SSP_SSCR1;  ///< 0x4 [R/W]: SSP Control Register 1
  volatile uint32_t SSP_SSSR;  ///< 0x8 [R]: SSP Status Register
  volatile uint32_t SSP_SSITR;  ///< 0xc [R/W]: SSP Interrupt Test Register
  volatile uint32_t SSP_SSDR;  ///< 0x10 [R/W]: SSP Data Register
  volatile uint32_t reserved0[5];
  volatile uint32_t SSP_SSTO;  ///< 0x28 [R/W]: SSP Time Out Register
  volatile uint32_t SSP_SSPSP;  ///< 0x2c [R/W]: SSP Programmable Serial Protocol Register
  volatile uint32_t SSP_SSTSA;  ///< 0x30 [R/W]: SSP TX Time Slot Active Register
  volatile uint32_t SSP_SSRSA;  ///< 0x34 [R/W]: SSP RX Time Slot Active Register
  volatile uint32_t SSP_SSTSS;  ///< 0x38 [R]: SSP Time Slot Status Register
  volatile uint32_t reserved1[17];
  volatile uint32_t SSP_GPS_ID;  ///< 0x80 [R]: GPS Controller ID Register
  volatile uint32_t SSP_GPS_CSR;  ///< 0x84 [R/W]: GPS Control and Status Register
  volatile uint32_t SSP_GPS_TSCNT;  ///< 0x88 [R]: Time Sync Count Register
  volatile uint32_t SSP_GPS_TSCNT_ADJ;  ///< 0x8c [R]: Time Sync Count Adjust Register
  volatile uint32_t reserved2[12];
  volatile uint32_t SSP_SPI_MOD;  ///< 0xc0 [R/W]: Modified SPI Mode Register
  volatile uint32_t REV0;  ///< 0xc4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc8 [R]: IP Tagging Revision 1
} SSP2_REGS_t;

//====================================================================
//
//Register File: RIPC Registers (RIPC)
/** \brief Register Descriptions for the RIPC (rev 0 . 1 . 1 . 1)*/
//
//====================================================================

typedef struct RIPC_REGS_s
{
  volatile uint32_t RIPCx_STATUS_REG;  ///< 0x0 [R/W]: RIPCx Status Register
  volatile uint32_t RIPCx_INT_REG0;  ///< 0x4 [R/W]: RIPCx Int Request Register (Instance 1 of 3)
  volatile uint32_t RIPCx_INT_REG1;  ///< 0x8 [R/W]: RIPCx Int Request Register (Instance 2 of 3)
  volatile uint32_t RIPCx_INT_REG2;  ///< 0xc [R/W]: RIPCx Int Request Register (Instance 3 of 3)
  volatile uint32_t RIPCx_INT_STAT_REG;  ///< 0x10 [R]: RIPCx Interrupt Status Register
  volatile uint32_t RIPCx_MAJ_MID_REV_REG;  ///< 0x14 [R]: Revision (Major and Mid) Register
  volatile uint32_t RIPCx_CFG_REV_REG;  ///< 0x18 [R]: Revision (Major and Mid) Register
} RIPC_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 0 Registers (GPIO_Gpio0)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO0_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO0_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 1 Registers (GPIO_Gpio1)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO1_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO1_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 2 Registers (GPIO_Gpio2)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO2_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO2_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 3 Registers (GPIO_Gpio3)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO3_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO3_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 4 Registers (GPIO_Gpio4)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO4_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO4_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 5 Registers (GPIO_Gpio5)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO5_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO5_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 6 Registers (GPIO_Gpio6)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO6_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO6_REGS_t;

//====================================================================
//
//Register File: Gpio Bank 7 Registers (GPIO_Gpio7)
/** \brief (rev 1 . 1 . 3 . 0)
    The GPIO block registers provide the means to configure the characteristics of each GPIO pin,
    as well as the means for firmware to control/observe these pins.*/
//
//====================================================================

typedef struct GPIO_GPIO7_REGS_s
{
  volatile uint32_t PLR;  ///< 0x0 [R]: GPIO Pin Level Register
  volatile uint32_t PDR;  ///< 0x4 [R/W]: GPIO Pin Direction Register
  volatile uint32_t PSR;  ///< 0x8 [W]: GPIO Pin Output Set Register
  volatile uint32_t PCR;  ///< 0xc [W]: GPIO Pin Output Clear Register
  volatile uint32_t RER;  ///< 0x10 [R/W]: GPIO Rising-Edge Detect Enable Register
  volatile uint32_t FER;  ///< 0x14 [R/W]: GPIO Falling-Edge Detect Enable Register
  volatile uint32_t EDR;  ///< 0x18 [R/W]: GPIO Edge-detect Status Register
  volatile uint32_t SDR;  ///< 0x1c [W]: GPIO Output Direction Set Register
  volatile uint32_t CDR;  ///< 0x20 [W]: GPIO Output Direction Clear Register
  volatile uint32_t SRER;  ///< 0x24 [W]: GPIO Bit-wise Set of Rising-Edge Detect Enable Register
  volatile uint32_t CRER;  ///< 0x28 [W]: GPIO Bit-wise Clear of Rising-Edge Detect Enable Register
  volatile uint32_t SFER;  ///< 0x2c [W]: GPIO Bit-wise Set of Falling-Edge Detect Enable Register
  volatile uint32_t CFER;  ///< 0x30 [W]: GPIO Bit-wise Clear of Falling-Edge Detect Enable Register
  volatile uint32_t OLR;  ///< 0x34 [R/W]: Output Level Register
  volatile uint32_t OLDER;  ///< 0x38 [R/W]: Output Level Direct-write Enable Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[2];
  volatile uint32_t ITER0;  ///< 0x50 [R/W]: Interrupt Target Enable Register (Instance 1 of 1)
} GPIO_GPIO7_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 0 Register (PadEdge_EdgeDetect0)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT0_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT0_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 1 Register (PadEdge_EdgeDetect1)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT1_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT1_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 2 Register (PadEdge_EdgeDetect2)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT2_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT2_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 3 Register (PadEdge_EdgeDetect3)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT3_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT3_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 4 Register (PadEdge_EdgeDetect4)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT4_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT4_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 5 Register (PadEdge_EdgeDetect5)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT5_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT5_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 6 Register (PadEdge_EdgeDetect6)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT6_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT6_REGS_t;

//====================================================================
//
//Register File: Edge Detect Bank 7 Register (PadEdge_EdgeDetect7)
//
//====================================================================

typedef struct PADEDGE_EDGEDETECT7_REGS_s
{
  volatile uint32_t EDGE;  ///< 0x0 [R]: Edge Detect
} PADEDGE_EDGEDETECT7_REGS_t;

//====================================================================
//
//Register File: IO_PAD0 Configuration Registers (Padring_IO_PAD0)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD0_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD0 Configuration Register
} PADRING_IO_PAD0_REGS_t;

//====================================================================
//
//Register File: IO_PAD1 Configuration Registers (Padring_IO_PAD1)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD1_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD1 Configuration Register
} PADRING_IO_PAD1_REGS_t;

//====================================================================
//
//Register File: IO_PAD2 Configuration Registers (Padring_IO_PAD2)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD2_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD2 Configuration Register
} PADRING_IO_PAD2_REGS_t;

//====================================================================
//
//Register File: IO_PAD3 Configuration Registers (Padring_IO_PAD3)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD3_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD3 Configuration Register
} PADRING_IO_PAD3_REGS_t;

//====================================================================
//
//Register File: IO_PAD4 Configuration Registers (Padring_IO_PAD4)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD4_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD4 Configuration Register
} PADRING_IO_PAD4_REGS_t;

//====================================================================
//
//Register File: IO_PAD5 Configuration Registers (Padring_IO_PAD5)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD5_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD5 Configuration Register
} PADRING_IO_PAD5_REGS_t;

//====================================================================
//
//Register File: IO_PAD6 Configuration Registers (Padring_IO_PAD6)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD6_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD6 Configuration Register
} PADRING_IO_PAD6_REGS_t;

//====================================================================
//
//Register File: IO_PAD7 Configuration Registers (Padring_IO_PAD7)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD7_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD7 Configuration Register
} PADRING_IO_PAD7_REGS_t;

//====================================================================
//
//Register File: IO_PAD8 Configuration Registers (Padring_IO_PAD8)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD8_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD8 Configuration Register
} PADRING_IO_PAD8_REGS_t;

//====================================================================
//
//Register File: IO_PAD9 Configuration Registers (Padring_IO_PAD9)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD9_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD9 Configuration Register
} PADRING_IO_PAD9_REGS_t;

//====================================================================
//
//Register File: IO_PAD10 Configuration Registers (Padring_IO_PAD10)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD10_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD10 Configuration Register
} PADRING_IO_PAD10_REGS_t;

//====================================================================
//
//Register File: IO_PAD11 Configuration Registers (Padring_IO_PAD11)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD11_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD11 Configuration Register
} PADRING_IO_PAD11_REGS_t;

//====================================================================
//
//Register File: IO_PAD12 Configuration Registers (Padring_IO_PAD12)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD12_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD12 Configuration Register
} PADRING_IO_PAD12_REGS_t;

//====================================================================
//
//Register File: IO_PAD13 Configuration Registers (Padring_IO_PAD13)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD13_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD13 Configuration Register
} PADRING_IO_PAD13_REGS_t;

//====================================================================
//
//Register File: IO_PAD14 Configuration Registers (Padring_IO_PAD14)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD14_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD14 Configuration Register
} PADRING_IO_PAD14_REGS_t;

//====================================================================
//
//Register File: IO_PAD15 Configuration Registers (Padring_IO_PAD15)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD15_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD15 Configuration Register
} PADRING_IO_PAD15_REGS_t;

//====================================================================
//
//Register File: IO_PAD16 Configuration Registers (Padring_IO_PAD16)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD16_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD16 Configuration Register
} PADRING_IO_PAD16_REGS_t;

//====================================================================
//
//Register File: IO_PAD17 Configuration Registers (Padring_IO_PAD17)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD17_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD17 Configuration Register
} PADRING_IO_PAD17_REGS_t;

//====================================================================
//
//Register File: IO_PAD18 Configuration Registers (Padring_IO_PAD18)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD18_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD18 Configuration Register
} PADRING_IO_PAD18_REGS_t;

//====================================================================
//
//Register File: IO_PAD19 Configuration Registers (Padring_IO_PAD19)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD19_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD19 Configuration Register
} PADRING_IO_PAD19_REGS_t;

//====================================================================
//
//Register File: IO_PAD20 Configuration Registers (Padring_IO_PAD20)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD20_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD20 Configuration Register
} PADRING_IO_PAD20_REGS_t;

//====================================================================
//
//Register File: IO_PAD21 Configuration Registers (Padring_IO_PAD21)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD21_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD21 Configuration Register
} PADRING_IO_PAD21_REGS_t;

//====================================================================
//
//Register File: IO_PAD22 Configuration Registers (Padring_IO_PAD22)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD22_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD22 Configuration Register
} PADRING_IO_PAD22_REGS_t;

//====================================================================
//
//Register File: IO_PAD23 Configuration Registers (Padring_IO_PAD23)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD23_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD23 Configuration Register
} PADRING_IO_PAD23_REGS_t;

//====================================================================
//
//Register File: IO_PAD24 Configuration Registers (Padring_IO_PAD24)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD24_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD24 Configuration Register
} PADRING_IO_PAD24_REGS_t;

//====================================================================
//
//Register File: IO_PAD25 Configuration Registers (Padring_IO_PAD25)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD25_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD25 Configuration Register
} PADRING_IO_PAD25_REGS_t;

//====================================================================
//
//Register File: IO_PAD26 Configuration Registers (Padring_IO_PAD26)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD26_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD26 Configuration Register
} PADRING_IO_PAD26_REGS_t;

//====================================================================
//
//Register File: IO_PAD27 Configuration Registers (Padring_IO_PAD27)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD27_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD27 Configuration Register
} PADRING_IO_PAD27_REGS_t;

//====================================================================
//
//Register File: IO_PAD28 Configuration Registers (Padring_IO_PAD28)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD28_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD28 Configuration Register
} PADRING_IO_PAD28_REGS_t;

//====================================================================
//
//Register File: IO_PAD29 Configuration Registers (Padring_IO_PAD29)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD29_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD29 Configuration Register
} PADRING_IO_PAD29_REGS_t;

//====================================================================
//
//Register File: IO_PAD30 Configuration Registers (Padring_IO_PAD30)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD30_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD30 Configuration Register
} PADRING_IO_PAD30_REGS_t;

//====================================================================
//
//Register File: IO_PAD31 Configuration Registers (Padring_IO_PAD31)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD31_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD31 Configuration Register
} PADRING_IO_PAD31_REGS_t;

//====================================================================
//
//Register File: IO_PAD32 Configuration Registers (Padring_IO_PAD32)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD32_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD32 Configuration Register
} PADRING_IO_PAD32_REGS_t;

//====================================================================
//
//Register File: IO_PAD33 Configuration Registers (Padring_IO_PAD33)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD33_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD33 Configuration Register
} PADRING_IO_PAD33_REGS_t;

//====================================================================
//
//Register File: IO_PAD34 Configuration Registers (Padring_IO_PAD34)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD34_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD34 Configuration Register
} PADRING_IO_PAD34_REGS_t;

//====================================================================
//
//Register File: IO_PAD35 Configuration Registers (Padring_IO_PAD35)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD35_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD35 Configuration Register
} PADRING_IO_PAD35_REGS_t;

//====================================================================
//
//Register File: IO_PAD36 Configuration Registers (Padring_IO_PAD36)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD36_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD36 Configuration Register
} PADRING_IO_PAD36_REGS_t;

//====================================================================
//
//Register File: IO_PAD37 Configuration Registers (Padring_IO_PAD37)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD37_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD37 Configuration Register
} PADRING_IO_PAD37_REGS_t;

//====================================================================
//
//Register File: IO_PAD38 Configuration Registers (Padring_IO_PAD38)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD38_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD38 Configuration Register
} PADRING_IO_PAD38_REGS_t;

//====================================================================
//
//Register File: IO_PAD39 Configuration Registers (Padring_IO_PAD39)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD39_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD39 Configuration Register
} PADRING_IO_PAD39_REGS_t;

//====================================================================
//
//Register File: IO_PAD40 Configuration Registers (Padring_IO_PAD40)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD40_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD40 Configuration Register
} PADRING_IO_PAD40_REGS_t;

//====================================================================
//
//Register File: IO_PAD41 Configuration Registers (Padring_IO_PAD41)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD41_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD41 Configuration Register
} PADRING_IO_PAD41_REGS_t;

//====================================================================
//
//Register File: IO_PAD42 Configuration Registers (Padring_IO_PAD42)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD42_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD42 Configuration Register
} PADRING_IO_PAD42_REGS_t;

//====================================================================
//
//Register File: IO_PAD43 Configuration Registers (Padring_IO_PAD43)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD43_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD43 Configuration Register
} PADRING_IO_PAD43_REGS_t;

//====================================================================
//
//Register File: IO_PAD44 Configuration Registers (Padring_IO_PAD44)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD44_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD44 Configuration Register
} PADRING_IO_PAD44_REGS_t;

//====================================================================
//
//Register File: IO_PAD45 Configuration Registers (Padring_IO_PAD45)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD45_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD45 Configuration Register
} PADRING_IO_PAD45_REGS_t;

//====================================================================
//
//Register File: IO_PAD46 Configuration Registers (Padring_IO_PAD46)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD46_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD46 Configuration Register
} PADRING_IO_PAD46_REGS_t;

//====================================================================
//
//Register File: IO_PAD47 Configuration Registers (Padring_IO_PAD47)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD47_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD47 Configuration Register
} PADRING_IO_PAD47_REGS_t;

//====================================================================
//
//Register File: IO_PAD48 Configuration Registers (Padring_IO_PAD48)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD48_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD48 Configuration Register
} PADRING_IO_PAD48_REGS_t;

//====================================================================
//
//Register File: IO_PAD49 Configuration Registers (Padring_IO_PAD49)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD49_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD49 Configuration Register
} PADRING_IO_PAD49_REGS_t;

//====================================================================
//
//Register File: IO_PAD50 Configuration Registers (Padring_IO_PAD50)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD50_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD50 Configuration Register
} PADRING_IO_PAD50_REGS_t;

//====================================================================
//
//Register File: IO_PAD51 Configuration Registers (Padring_IO_PAD51)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD51_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD51 Configuration Register
} PADRING_IO_PAD51_REGS_t;

//====================================================================
//
//Register File: IO_PAD52 Configuration Registers (Padring_IO_PAD52)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD52_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD52 Configuration Register
} PADRING_IO_PAD52_REGS_t;

//====================================================================
//
//Register File: IO_PAD53 Configuration Registers (Padring_IO_PAD53)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD53_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD53 Configuration Register
} PADRING_IO_PAD53_REGS_t;

//====================================================================
//
//Register File: IO_PAD54 Configuration Registers (Padring_IO_PAD54)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD54_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD54 Configuration Register
} PADRING_IO_PAD54_REGS_t;

//====================================================================
//
//Register File: IO_PAD55 Configuration Registers (Padring_IO_PAD55)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD55_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD55 Configuration Register
} PADRING_IO_PAD55_REGS_t;

//====================================================================
//
//Register File: IO_PAD56 Configuration Registers (Padring_IO_PAD56)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD56_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD56 Configuration Register
} PADRING_IO_PAD56_REGS_t;

//====================================================================
//
//Register File: IO_PAD57 Configuration Registers (Padring_IO_PAD57)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD57_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD57 Configuration Register
} PADRING_IO_PAD57_REGS_t;

//====================================================================
//
//Register File: IO_PAD58 Configuration Registers (Padring_IO_PAD58)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD58_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD58 Configuration Register
} PADRING_IO_PAD58_REGS_t;

//====================================================================
//
//Register File: IO_PAD59 Configuration Registers (Padring_IO_PAD59)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD59_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD59 Configuration Register
} PADRING_IO_PAD59_REGS_t;

//====================================================================
//
//Register File: IO_PAD60 Configuration Registers (Padring_IO_PAD60)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD60_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD60 Configuration Register
} PADRING_IO_PAD60_REGS_t;

//====================================================================
//
//Register File: IO_PAD61 Configuration Registers (Padring_IO_PAD61)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD61_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD61 Configuration Register
} PADRING_IO_PAD61_REGS_t;

//====================================================================
//
//Register File: IO_PAD62 Configuration Registers (Padring_IO_PAD62)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD62_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD62 Configuration Register
} PADRING_IO_PAD62_REGS_t;

//====================================================================
//
//Register File: IO_PAD63 Configuration Registers (Padring_IO_PAD63)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD63_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD63 Configuration Register
} PADRING_IO_PAD63_REGS_t;

//====================================================================
//
//Register File: IO_PAD64 Configuration Registers (Padring_IO_PAD64)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD64_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD64 Configuration Register
} PADRING_IO_PAD64_REGS_t;

//====================================================================
//
//Register File: IO_PAD65 Configuration Registers (Padring_IO_PAD65)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD65_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD65 Configuration Register
} PADRING_IO_PAD65_REGS_t;

//====================================================================
//
//Register File: IO_PAD66 Configuration Registers (Padring_IO_PAD66)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD66_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD66 Configuration Register
} PADRING_IO_PAD66_REGS_t;

//====================================================================
//
//Register File: IO_PAD67 Configuration Registers (Padring_IO_PAD67)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD67_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD67 Configuration Register
} PADRING_IO_PAD67_REGS_t;

//====================================================================
//
//Register File: IO_PAD68 Configuration Registers (Padring_IO_PAD68)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD68_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD68 Configuration Register
} PADRING_IO_PAD68_REGS_t;

//====================================================================
//
//Register File: IO_PAD69 Configuration Registers (Padring_IO_PAD69)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD69_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD69 Configuration Register
} PADRING_IO_PAD69_REGS_t;

//====================================================================
//
//Register File: IO_PAD70 Configuration Registers (Padring_IO_PAD70)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD70_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD70 Configuration Register
} PADRING_IO_PAD70_REGS_t;

//====================================================================
//
//Register File: IO_PAD71 Configuration Registers (Padring_IO_PAD71)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD71_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD71 Configuration Register
} PADRING_IO_PAD71_REGS_t;

//====================================================================
//
//Register File: IO_PAD72 Configuration Registers (Padring_IO_PAD72)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD72_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD72 Configuration Register
} PADRING_IO_PAD72_REGS_t;

//====================================================================
//
//Register File: IO_PAD73 Configuration Registers (Padring_IO_PAD73)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD73_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD73 Configuration Register
} PADRING_IO_PAD73_REGS_t;

//====================================================================
//
//Register File: IO_PAD74 Configuration Registers (Padring_IO_PAD74)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD74_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD74 Configuration Register
} PADRING_IO_PAD74_REGS_t;

//====================================================================
//
//Register File: IO_PAD75 Configuration Registers (Padring_IO_PAD75)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD75_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD75 Configuration Register
} PADRING_IO_PAD75_REGS_t;

//====================================================================
//
//Register File: IO_PAD76 Configuration Registers (Padring_IO_PAD76)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD76_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD76 Configuration Register
} PADRING_IO_PAD76_REGS_t;

//====================================================================
//
//Register File: IO_PAD77 Configuration Registers (Padring_IO_PAD77)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD77_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD77 Configuration Register
} PADRING_IO_PAD77_REGS_t;

//====================================================================
//
//Register File: IO_PAD78 Configuration Registers (Padring_IO_PAD78)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD78_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD78 Configuration Register
} PADRING_IO_PAD78_REGS_t;

//====================================================================
//
//Register File: IO_PAD79 Configuration Registers (Padring_IO_PAD79)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD79_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD79 Configuration Register
} PADRING_IO_PAD79_REGS_t;

//====================================================================
//
//Register File: IO_PAD80 Configuration Registers (Padring_IO_PAD80)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD80_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD80 Configuration Register
} PADRING_IO_PAD80_REGS_t;

//====================================================================
//
//Register File: IO_PAD81 Configuration Registers (Padring_IO_PAD81)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD81_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD81 Configuration Register
} PADRING_IO_PAD81_REGS_t;

//====================================================================
//
//Register File: IO_PAD82 Configuration Registers (Padring_IO_PAD82)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD82_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD82 Configuration Register
} PADRING_IO_PAD82_REGS_t;

//====================================================================
//
//Register File: IO_PAD83 Configuration Registers (Padring_IO_PAD83)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD83_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD83 Configuration Register
} PADRING_IO_PAD83_REGS_t;

//====================================================================
//
//Register File: IO_PAD84 Configuration Registers (Padring_IO_PAD84)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD84_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD84 Configuration Register
} PADRING_IO_PAD84_REGS_t;

//====================================================================
//
//Register File: IO_PAD85 Configuration Registers (Padring_IO_PAD85)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD85_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD85 Configuration Register
} PADRING_IO_PAD85_REGS_t;

//====================================================================
//
//Register File: IO_PAD86 Configuration Registers (Padring_IO_PAD86)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD86_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD86 Configuration Register
} PADRING_IO_PAD86_REGS_t;

//====================================================================
//
//Register File: IO_PAD87 Configuration Registers (Padring_IO_PAD87)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD87_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD87 Configuration Register
} PADRING_IO_PAD87_REGS_t;

//====================================================================
//
//Register File: IO_PAD88 Configuration Registers (Padring_IO_PAD88)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD88_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD88 Configuration Register
} PADRING_IO_PAD88_REGS_t;

//====================================================================
//
//Register File: IO_PAD89 Configuration Registers (Padring_IO_PAD89)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD89_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD89 Configuration Register
} PADRING_IO_PAD89_REGS_t;

//====================================================================
//
//Register File: IO_PAD90 Configuration Registers (Padring_IO_PAD90)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD90_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD90 Configuration Register
} PADRING_IO_PAD90_REGS_t;

//====================================================================
//
//Register File: IO_PAD91 Configuration Registers (Padring_IO_PAD91)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD91_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD91 Configuration Register
} PADRING_IO_PAD91_REGS_t;

//====================================================================
//
//Register File: IO_PAD92 Configuration Registers (Padring_IO_PAD92)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD92_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD92 Configuration Register
} PADRING_IO_PAD92_REGS_t;

//====================================================================
//
//Register File: IO_PAD93 Configuration Registers (Padring_IO_PAD93)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD93_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD93 Configuration Register
} PADRING_IO_PAD93_REGS_t;

//====================================================================
//
//Register File: IO_PAD94 Configuration Registers (Padring_IO_PAD94)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD94_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD94 Configuration Register
} PADRING_IO_PAD94_REGS_t;

//====================================================================
//
//Register File: IO_PAD95 Configuration Registers (Padring_IO_PAD95)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD95_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD95 Configuration Register
} PADRING_IO_PAD95_REGS_t;

//====================================================================
//
//Register File: IO_PAD96 Configuration Registers (Padring_IO_PAD96)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD96_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD96 Configuration Register
} PADRING_IO_PAD96_REGS_t;

//====================================================================
//
//Register File: IO_PAD97 Configuration Registers (Padring_IO_PAD97)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD97_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD97 Configuration Register
} PADRING_IO_PAD97_REGS_t;

//====================================================================
//
//Register File: IO_PAD98 Configuration Registers (Padring_IO_PAD98)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD98_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD98 Configuration Register
} PADRING_IO_PAD98_REGS_t;

//====================================================================
//
//Register File: IO_PAD99 Configuration Registers (Padring_IO_PAD99)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD99_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD99 Configuration Register
} PADRING_IO_PAD99_REGS_t;

//====================================================================
//
//Register File: IO_PAD100 Configuration Registers (Padring_IO_PAD100)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD100_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD100 Configuration Register
} PADRING_IO_PAD100_REGS_t;

//====================================================================
//
//Register File: IO_PAD101 Configuration Registers (Padring_IO_PAD101)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD101_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD101 Configuration Register
} PADRING_IO_PAD101_REGS_t;

//====================================================================
//
//Register File: IO_PAD102 Configuration Registers (Padring_IO_PAD102)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD102_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD102 Configuration Register
} PADRING_IO_PAD102_REGS_t;

//====================================================================
//
//Register File: IO_PAD103 Configuration Registers (Padring_IO_PAD103)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD103_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD103 Configuration Register
} PADRING_IO_PAD103_REGS_t;

//====================================================================
//
//Register File: IO_PAD104 Configuration Registers (Padring_IO_PAD104)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD104_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD104 Configuration Register
} PADRING_IO_PAD104_REGS_t;

//====================================================================
//
//Register File: IO_PAD105 Configuration Registers (Padring_IO_PAD105)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD105_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD105 Configuration Register
} PADRING_IO_PAD105_REGS_t;

//====================================================================
//
//Register File: IO_PAD106 Configuration Registers (Padring_IO_PAD106)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD106_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD106 Configuration Register
} PADRING_IO_PAD106_REGS_t;

//====================================================================
//
//Register File: IO_PAD107 Configuration Registers (Padring_IO_PAD107)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD107_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD107 Configuration Register
} PADRING_IO_PAD107_REGS_t;

//====================================================================
//
//Register File: IO_PAD108 Configuration Registers (Padring_IO_PAD108)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD108_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD108 Configuration Register
} PADRING_IO_PAD108_REGS_t;

//====================================================================
//
//Register File: IO_PAD109 Configuration Registers (Padring_IO_PAD109)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD109_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD109 Configuration Register
} PADRING_IO_PAD109_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D0 Configuration Registers (Padring_VID_LVDSo_D0)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D0_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D0 Configuration Register
} PADRING_VID_LVDSO_D0_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D1 Configuration Registers (Padring_VID_LVDSo_D1)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D1_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D1 Configuration Register
} PADRING_VID_LVDSO_D1_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D2 Configuration Registers (Padring_VID_LVDSo_D2)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D2_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D2 Configuration Register
} PADRING_VID_LVDSO_D2_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D3 Configuration Registers (Padring_VID_LVDSo_D3)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D3_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D3 Configuration Register
} PADRING_VID_LVDSO_D3_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D4 Configuration Registers (Padring_VID_LVDSo_D4)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D4_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D4 Configuration Register
} PADRING_VID_LVDSO_D4_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D5 Configuration Registers (Padring_VID_LVDSo_D5)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D5_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D5 Configuration Register
} PADRING_VID_LVDSO_D5_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D6 Configuration Registers (Padring_VID_LVDSo_D6)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D6_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D6 Configuration Register
} PADRING_VID_LVDSO_D6_REGS_t;

//====================================================================
//
//Register File: VID_LVDSo_D7 Configuration Registers (Padring_VID_LVDSo_D7)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_VID_LVDSO_D7_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: VID_LVDSo_D7 Configuration Register
} PADRING_VID_LVDSO_D7_REGS_t;

//====================================================================
//
//Register File: IO_PAD110 Configuration Registers (Padring_IO_PAD110)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD110_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD110 Configuration Register
} PADRING_IO_PAD110_REGS_t;

//====================================================================
//
//Register File: IO_PAD111 Configuration Registers (Padring_IO_PAD111)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD111_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD111 Configuration Register
} PADRING_IO_PAD111_REGS_t;

//====================================================================
//
//Register File: IO_PAD112 Configuration Registers (Padring_IO_PAD112)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD112_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD112 Configuration Register
} PADRING_IO_PAD112_REGS_t;

//====================================================================
//
//Register File: IO_PAD113 Configuration Registers (Padring_IO_PAD113)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD113_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD113 Configuration Register
} PADRING_IO_PAD113_REGS_t;

//====================================================================
//
//Register File: IO_PAD114 Configuration Registers (Padring_IO_PAD114)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD114_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD114 Configuration Register
} PADRING_IO_PAD114_REGS_t;

//====================================================================
//
//Register File: IO_PAD115 Configuration Registers (Padring_IO_PAD115)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD115_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD115 Configuration Register
} PADRING_IO_PAD115_REGS_t;

//====================================================================
//
//Register File: IO_PAD116 Configuration Registers (Padring_IO_PAD116)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD116_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD116 Configuration Register
} PADRING_IO_PAD116_REGS_t;

//====================================================================
//
//Register File: IO_PAD117 Configuration Registers (Padring_IO_PAD117)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD117_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD117 Configuration Register
} PADRING_IO_PAD117_REGS_t;

//====================================================================
//
//Register File: IO_PAD118 Configuration Registers (Padring_IO_PAD118)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD118_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD118 Configuration Register
} PADRING_IO_PAD118_REGS_t;

//====================================================================
//
//Register File: IO_PAD119 Configuration Registers (Padring_IO_PAD119)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD119_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD119 Configuration Register
} PADRING_IO_PAD119_REGS_t;

//====================================================================
//
//Register File: IO_PAD120 Configuration Registers (Padring_IO_PAD120)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD120_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD120 Configuration Register
} PADRING_IO_PAD120_REGS_t;

//====================================================================
//
//Register File: IO_PAD121 Configuration Registers (Padring_IO_PAD121)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD121_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD121 Configuration Register
} PADRING_IO_PAD121_REGS_t;

//====================================================================
//
//Register File: IO_PAD122 Configuration Registers (Padring_IO_PAD122)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD122_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD122 Configuration Register
} PADRING_IO_PAD122_REGS_t;

//====================================================================
//
//Register File: IO_PAD123 Configuration Registers (Padring_IO_PAD123)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD123_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD123 Configuration Register
} PADRING_IO_PAD123_REGS_t;

//====================================================================
//
//Register File: IO_PAD124 Configuration Registers (Padring_IO_PAD124)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD124_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD124 Configuration Register
} PADRING_IO_PAD124_REGS_t;

//====================================================================
//
//Register File: IO_PAD125 Configuration Registers (Padring_IO_PAD125)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD125_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD125 Configuration Register
} PADRING_IO_PAD125_REGS_t;

//====================================================================
//
//Register File: IO_PAD126 Configuration Registers (Padring_IO_PAD126)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD126_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD126 Configuration Register
} PADRING_IO_PAD126_REGS_t;

//====================================================================
//
//Register File: IO_PAD127 Configuration Registers (Padring_IO_PAD127)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD127_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD127 Configuration Register
} PADRING_IO_PAD127_REGS_t;

//====================================================================
//
//Register File: IO_PAD128 Configuration Registers (Padring_IO_PAD128)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD128_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD128 Configuration Register
} PADRING_IO_PAD128_REGS_t;

//====================================================================
//
//Register File: IO_PAD129 Configuration Registers (Padring_IO_PAD129)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD129_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD129 Configuration Register
} PADRING_IO_PAD129_REGS_t;

//====================================================================
//
//Register File: IO_PAD130 Configuration Registers (Padring_IO_PAD130)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD130_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD130 Configuration Register
} PADRING_IO_PAD130_REGS_t;

//====================================================================
//
//Register File: IO_PAD131 Configuration Registers (Padring_IO_PAD131)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD131_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD131 Configuration Register
} PADRING_IO_PAD131_REGS_t;

//====================================================================
//
//Register File: IO_PAD132 Configuration Registers (Padring_IO_PAD132)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD132_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD132 Configuration Register
} PADRING_IO_PAD132_REGS_t;

//====================================================================
//
//Register File: IO_PAD133 Configuration Registers (Padring_IO_PAD133)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD133_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD133 Configuration Register
} PADRING_IO_PAD133_REGS_t;

//====================================================================
//
//Register File: IO_PAD134 Configuration Registers (Padring_IO_PAD134)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD134_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD134 Configuration Register
} PADRING_IO_PAD134_REGS_t;

//====================================================================
//
//Register File: IO_PAD135 Configuration Registers (Padring_IO_PAD135)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD135_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD135 Configuration Register
} PADRING_IO_PAD135_REGS_t;

//====================================================================
//
//Register File: IO_PAD136 Configuration Registers (Padring_IO_PAD136)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD136_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD136 Configuration Register
} PADRING_IO_PAD136_REGS_t;

//====================================================================
//
//Register File: IO_PAD137 Configuration Registers (Padring_IO_PAD137)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD137_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD137 Configuration Register
} PADRING_IO_PAD137_REGS_t;

//====================================================================
//
//Register File: IO_PAD138 Configuration Registers (Padring_IO_PAD138)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD138_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD138 Configuration Register
} PADRING_IO_PAD138_REGS_t;

//====================================================================
//
//Register File: IO_PAD139 Configuration Registers (Padring_IO_PAD139)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD139_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD139 Configuration Register
} PADRING_IO_PAD139_REGS_t;

//====================================================================
//
//Register File: IO_PAD140 Configuration Registers (Padring_IO_PAD140)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD140_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD140 Configuration Register
} PADRING_IO_PAD140_REGS_t;

//====================================================================
//
//Register File: IO_PAD141 Configuration Registers (Padring_IO_PAD141)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD141_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD141 Configuration Register
} PADRING_IO_PAD141_REGS_t;

//====================================================================
//
//Register File: IO_PAD142 Configuration Registers (Padring_IO_PAD142)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD142_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD142 Configuration Register
} PADRING_IO_PAD142_REGS_t;

//====================================================================
//
//Register File: IO_PAD143 Configuration Registers (Padring_IO_PAD143)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD143_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD143 Configuration Register
} PADRING_IO_PAD143_REGS_t;

//====================================================================
//
//Register File: IO_PAD144 Configuration Registers (Padring_IO_PAD144)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD144_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD144 Configuration Register
} PADRING_IO_PAD144_REGS_t;

//====================================================================
//
//Register File: IO_PAD145 Configuration Registers (Padring_IO_PAD145)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD145_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD145 Configuration Register
} PADRING_IO_PAD145_REGS_t;

//====================================================================
//
//Register File: IO_PAD146 Configuration Registers (Padring_IO_PAD146)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD146_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD146 Configuration Register
} PADRING_IO_PAD146_REGS_t;

//====================================================================
//
//Register File: IO_PAD147 Configuration Registers (Padring_IO_PAD147)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD147_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD147 Configuration Register
} PADRING_IO_PAD147_REGS_t;

//====================================================================
//
//Register File: IO_PAD148 Configuration Registers (Padring_IO_PAD148)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD148_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD148 Configuration Register
} PADRING_IO_PAD148_REGS_t;

//====================================================================
//
//Register File: IO_PAD149 Configuration Registers (Padring_IO_PAD149)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD149_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD149 Configuration Register
} PADRING_IO_PAD149_REGS_t;

//====================================================================
//
//Register File: IO_PAD150 Configuration Registers (Padring_IO_PAD150)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD150_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD150 Configuration Register
} PADRING_IO_PAD150_REGS_t;

//====================================================================
//
//Register File: IO_PAD151 Configuration Registers (Padring_IO_PAD151)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD151_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD151 Configuration Register
} PADRING_IO_PAD151_REGS_t;

//====================================================================
//
//Register File: IO_PAD152 Configuration Registers (Padring_IO_PAD152)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD152_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD152 Configuration Register
} PADRING_IO_PAD152_REGS_t;

//====================================================================
//
//Register File: IO_PAD153 Configuration Registers (Padring_IO_PAD153)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD153_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD153 Configuration Register
} PADRING_IO_PAD153_REGS_t;

//====================================================================
//
//Register File: IO_PAD154 Configuration Registers (Padring_IO_PAD154)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD154_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD154 Configuration Register
} PADRING_IO_PAD154_REGS_t;

//====================================================================
//
//Register File: IO_PAD155 Configuration Registers (Padring_IO_PAD155)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD155_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD155 Configuration Register
} PADRING_IO_PAD155_REGS_t;

//====================================================================
//
//Register File: IO_PAD156 Configuration Registers (Padring_IO_PAD156)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD156_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD156 Configuration Register
} PADRING_IO_PAD156_REGS_t;

//====================================================================
//
//Register File: IO_PAD157 Configuration Registers (Padring_IO_PAD157)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD157_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD157 Configuration Register
} PADRING_IO_PAD157_REGS_t;

//====================================================================
//
//Register File: IO_PAD158 Configuration Registers (Padring_IO_PAD158)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD158_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD158 Configuration Register
} PADRING_IO_PAD158_REGS_t;

//====================================================================
//
//Register File: IO_PAD159 Configuration Registers (Padring_IO_PAD159)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD159_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD159 Configuration Register
} PADRING_IO_PAD159_REGS_t;

//====================================================================
//
//Register File: IO_PAD160 Configuration Registers (Padring_IO_PAD160)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD160_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD160 Configuration Register
} PADRING_IO_PAD160_REGS_t;

//====================================================================
//
//Register File: IO_PAD161 Configuration Registers (Padring_IO_PAD161)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD161_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD161 Configuration Register
} PADRING_IO_PAD161_REGS_t;

//====================================================================
//
//Register File: IO_PAD162 Configuration Registers (Padring_IO_PAD162)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD162_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD162 Configuration Register
} PADRING_IO_PAD162_REGS_t;

//====================================================================
//
//Register File: IO_PAD163 Configuration Registers (Padring_IO_PAD163)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD163_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD163 Configuration Register
} PADRING_IO_PAD163_REGS_t;

//====================================================================
//
//Register File: IO_PAD164 Configuration Registers (Padring_IO_PAD164)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD164_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD164 Configuration Register
} PADRING_IO_PAD164_REGS_t;

//====================================================================
//
//Register File: IO_PAD165 Configuration Registers (Padring_IO_PAD165)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD165_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD165 Configuration Register
} PADRING_IO_PAD165_REGS_t;

//====================================================================
//
//Register File: IO_PAD166 Configuration Registers (Padring_IO_PAD166)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD166_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD166 Configuration Register
} PADRING_IO_PAD166_REGS_t;

//====================================================================
//
//Register File: IO_PAD167 Configuration Registers (Padring_IO_PAD167)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD167_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD167 Configuration Register
} PADRING_IO_PAD167_REGS_t;

//====================================================================
//
//Register File: IO_PAD168 Configuration Registers (Padring_IO_PAD168)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD168_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD168 Configuration Register
} PADRING_IO_PAD168_REGS_t;

//====================================================================
//
//Register File: IO_PAD169 Configuration Registers (Padring_IO_PAD169)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD169_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD169 Configuration Register
} PADRING_IO_PAD169_REGS_t;

//====================================================================
//
//Register File: IO_PAD170 Configuration Registers (Padring_IO_PAD170)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD170_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD170 Configuration Register
} PADRING_IO_PAD170_REGS_t;

//====================================================================
//
//Register File: IO_PAD171 Configuration Registers (Padring_IO_PAD171)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD171_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD171 Configuration Register
} PADRING_IO_PAD171_REGS_t;

//====================================================================
//
//Register File: IO_PAD172 Configuration Registers (Padring_IO_PAD172)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD172_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD172 Configuration Register
} PADRING_IO_PAD172_REGS_t;

//====================================================================
//
//Register File: IO_PAD173 Configuration Registers (Padring_IO_PAD173)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD173_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD173 Configuration Register
} PADRING_IO_PAD173_REGS_t;

//====================================================================
//
//Register File: IO_PAD174 Configuration Registers (Padring_IO_PAD174)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD174_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD174 Configuration Register
} PADRING_IO_PAD174_REGS_t;

//====================================================================
//
//Register File: IO_PAD175 Configuration Registers (Padring_IO_PAD175)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD175_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD175 Configuration Register
} PADRING_IO_PAD175_REGS_t;

//====================================================================
//
//Register File: IO_PAD176 Configuration Registers (Padring_IO_PAD176)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD176_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD176 Configuration Register
} PADRING_IO_PAD176_REGS_t;

//====================================================================
//
//Register File: IO_PAD177 Configuration Registers (Padring_IO_PAD177)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD177_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD177 Configuration Register
} PADRING_IO_PAD177_REGS_t;

//====================================================================
//
//Register File: IO_PAD178 Configuration Registers (Padring_IO_PAD178)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD178_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD178 Configuration Register
} PADRING_IO_PAD178_REGS_t;

//====================================================================
//
//Register File: IO_PAD179 Configuration Registers (Padring_IO_PAD179)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD179_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD179 Configuration Register
} PADRING_IO_PAD179_REGS_t;

//====================================================================
//
//Register File: IO_PAD180 Configuration Registers (Padring_IO_PAD180)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD180_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD180 Configuration Register
} PADRING_IO_PAD180_REGS_t;

//====================================================================
//
//Register File: IO_PAD181 Configuration Registers (Padring_IO_PAD181)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD181_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD181 Configuration Register
} PADRING_IO_PAD181_REGS_t;

//====================================================================
//
//Register File: IO_PAD182 Configuration Registers (Padring_IO_PAD182)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD182_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD182 Configuration Register
} PADRING_IO_PAD182_REGS_t;

//====================================================================
//
//Register File: IO_PAD183 Configuration Registers (Padring_IO_PAD183)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD183_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD183 Configuration Register
} PADRING_IO_PAD183_REGS_t;

//====================================================================
//
//Register File: IO_PAD184 Configuration Registers (Padring_IO_PAD184)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD184_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD184 Configuration Register
} PADRING_IO_PAD184_REGS_t;

//====================================================================
//
//Register File: IO_PAD185 Configuration Registers (Padring_IO_PAD185)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD185_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD185 Configuration Register
} PADRING_IO_PAD185_REGS_t;

//====================================================================
//
//Register File: IO_PAD186 Configuration Registers (Padring_IO_PAD186)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD186_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD186 Configuration Register
} PADRING_IO_PAD186_REGS_t;

//====================================================================
//
//Register File: IO_PAD187 Configuration Registers (Padring_IO_PAD187)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD187_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD187 Configuration Register
} PADRING_IO_PAD187_REGS_t;

//====================================================================
//
//Register File: IO_PAD188 Configuration Registers (Padring_IO_PAD188)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD188_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD188 Configuration Register
} PADRING_IO_PAD188_REGS_t;

//====================================================================
//
//Register File: IO_PAD189 Configuration Registers (Padring_IO_PAD189)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD189_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD189 Configuration Register
} PADRING_IO_PAD189_REGS_t;

//====================================================================
//
//Register File: IO_PAD190 Configuration Registers (Padring_IO_PAD190)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD190_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD190 Configuration Register
} PADRING_IO_PAD190_REGS_t;

//====================================================================
//
//Register File: IO_PAD191 Configuration Registers (Padring_IO_PAD191)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD191_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD191 Configuration Register
} PADRING_IO_PAD191_REGS_t;

//====================================================================
//
//Register File: IO_PAD192 Configuration Registers (Padring_IO_PAD192)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD192_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD192 Configuration Register
} PADRING_IO_PAD192_REGS_t;

//====================================================================
//
//Register File: SCIF0_LVDSo_CLK Configuration Registers (Padring_SCIF0_LVDSo_CLK)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF0_LVDSO_CLK_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF0_LVDSo_CLK Configuration Register
} PADRING_SCIF0_LVDSO_CLK_REGS_t;

//====================================================================
//
//Register File: SCIF0_LVDSi_CLK Configuration Registers (Padring_SCIF0_LVDSi_CLK)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF0_LVDSI_CLK_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF0_LVDSi_CLK Configuration Register
} PADRING_SCIF0_LVDSI_CLK_REGS_t;

//====================================================================
//
//Register File: SCIF0_LVDSi_D0 Configuration Registers (Padring_SCIF0_LVDSi_D0)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF0_LVDSI_D0_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF0_LVDSi_D0 Configuration Register
} PADRING_SCIF0_LVDSI_D0_REGS_t;

//====================================================================
//
//Register File: SCIF0_LVDSi_D1 Configuration Registers (Padring_SCIF0_LVDSi_D1)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF0_LVDSI_D1_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF0_LVDSi_D1 Configuration Register
} PADRING_SCIF0_LVDSI_D1_REGS_t;

//====================================================================
//
//Register File: SCIF0_LVDSi_D2 Configuration Registers (Padring_SCIF0_LVDSi_D2)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF0_LVDSI_D2_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF0_LVDSi_D2 Configuration Register
} PADRING_SCIF0_LVDSI_D2_REGS_t;

//====================================================================
//
//Register File: SCIF1_LVDSo_CLK Configuration Registers (Padring_SCIF1_LVDSo_CLK)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF1_LVDSO_CLK_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF1_LVDSo_CLK Configuration Register
} PADRING_SCIF1_LVDSO_CLK_REGS_t;

//====================================================================
//
//Register File: SCIF1_LVDSi_CLK Configuration Registers (Padring_SCIF1_LVDSi_CLK)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF1_LVDSI_CLK_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF1_LVDSi_CLK Configuration Register
} PADRING_SCIF1_LVDSI_CLK_REGS_t;

//====================================================================
//
//Register File: SCIF1_LVDSi_D0 Configuration Registers (Padring_SCIF1_LVDSi_D0)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF1_LVDSI_D0_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF1_LVDSi_D0 Configuration Register
} PADRING_SCIF1_LVDSI_D0_REGS_t;

//====================================================================
//
//Register File: SCIF1_LVDSi_D1 Configuration Registers (Padring_SCIF1_LVDSi_D1)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF1_LVDSI_D1_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF1_LVDSi_D1 Configuration Register
} PADRING_SCIF1_LVDSI_D1_REGS_t;

//====================================================================
//
//Register File: SCIF1_LVDSi_D2 Configuration Registers (Padring_SCIF1_LVDSi_D2)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_SCIF1_LVDSI_D2_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: SCIF1_LVDSi_D2 Configuration Register
} PADRING_SCIF1_LVDSI_D2_REGS_t;

//====================================================================
//
//Register File: IO_PAD193 Configuration Registers (Padring_IO_PAD193)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD193_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD193 Configuration Register
} PADRING_IO_PAD193_REGS_t;

//====================================================================
//
//Register File: IO_PAD194 Configuration Registers (Padring_IO_PAD194)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD194_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD194 Configuration Register
} PADRING_IO_PAD194_REGS_t;

//====================================================================
//
//Register File: IO_PAD195 Configuration Registers (Padring_IO_PAD195)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD195_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD195 Configuration Register
} PADRING_IO_PAD195_REGS_t;

//====================================================================
//
//Register File: IO_PAD196 Configuration Registers (Padring_IO_PAD196)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD196_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD196 Configuration Register
} PADRING_IO_PAD196_REGS_t;

//====================================================================
//
//Register File: IO_PAD197 Configuration Registers (Padring_IO_PAD197)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD197_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD197 Configuration Register
} PADRING_IO_PAD197_REGS_t;

//====================================================================
//
//Register File: IO_PAD198 Configuration Registers (Padring_IO_PAD198)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD198_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD198 Configuration Register
} PADRING_IO_PAD198_REGS_t;

//====================================================================
//
//Register File: IO_PAD199 Configuration Registers (Padring_IO_PAD199)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD199_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD199 Configuration Register
} PADRING_IO_PAD199_REGS_t;

//====================================================================
//
//Register File: IO_PAD200 Configuration Registers (Padring_IO_PAD200)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD200_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD200 Configuration Register
} PADRING_IO_PAD200_REGS_t;

//====================================================================
//
//Register File: IO_PAD201 Configuration Registers (Padring_IO_PAD201)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD201_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD201 Configuration Register
} PADRING_IO_PAD201_REGS_t;

//====================================================================
//
//Register File: IO_PAD202 Configuration Registers (Padring_IO_PAD202)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD202_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD202 Configuration Register
} PADRING_IO_PAD202_REGS_t;

//====================================================================
//
//Register File: IO_PAD203 Configuration Registers (Padring_IO_PAD203)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD203_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD203 Configuration Register
} PADRING_IO_PAD203_REGS_t;

//====================================================================
//
//Register File: IO_PAD204 Configuration Registers (Padring_IO_PAD204)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD204_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD204 Configuration Register
} PADRING_IO_PAD204_REGS_t;

//====================================================================
//
//Register File: IO_PAD205 Configuration Registers (Padring_IO_PAD205)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD205_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD205 Configuration Register
} PADRING_IO_PAD205_REGS_t;

//====================================================================
//
//Register File: IO_PAD206 Configuration Registers (Padring_IO_PAD206)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD206_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD206 Configuration Register
} PADRING_IO_PAD206_REGS_t;

//====================================================================
//
//Register File: IO_PAD207 Configuration Registers (Padring_IO_PAD207)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD207_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD207 Configuration Register
} PADRING_IO_PAD207_REGS_t;

//====================================================================
//
//Register File: IO_PAD208 Configuration Registers (Padring_IO_PAD208)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD208_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD208 Configuration Register
} PADRING_IO_PAD208_REGS_t;

//====================================================================
//
//Register File: IO_PAD209 Configuration Registers (Padring_IO_PAD209)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD209_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD209 Configuration Register
} PADRING_IO_PAD209_REGS_t;

//====================================================================
//
//Register File: IO_PAD210 Configuration Registers (Padring_IO_PAD210)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD210_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD210 Configuration Register
} PADRING_IO_PAD210_REGS_t;

//====================================================================
//
//Register File: IO_PAD211 Configuration Registers (Padring_IO_PAD211)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD211_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD211 Configuration Register
} PADRING_IO_PAD211_REGS_t;

//====================================================================
//
//Register File: IO_PAD212 Configuration Registers (Padring_IO_PAD212)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD212_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD212 Configuration Register
} PADRING_IO_PAD212_REGS_t;

//====================================================================
//
//Register File: IO_PAD213 Configuration Registers (Padring_IO_PAD213)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD213_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD213 Configuration Register
} PADRING_IO_PAD213_REGS_t;

//====================================================================
//
//Register File: IO_PAD214 Configuration Registers (Padring_IO_PAD214)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD214_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD214 Configuration Register
} PADRING_IO_PAD214_REGS_t;

//====================================================================
//
//Register File: IO_PAD215 Configuration Registers (Padring_IO_PAD215)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD215_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD215 Configuration Register
} PADRING_IO_PAD215_REGS_t;

//====================================================================
//
//Register File: IO_PAD216 Configuration Registers (Padring_IO_PAD216)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD216_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD216 Configuration Register
} PADRING_IO_PAD216_REGS_t;

//====================================================================
//
//Register File: IO_PAD217 Configuration Registers (Padring_IO_PAD217)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD217_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD217 Configuration Register
} PADRING_IO_PAD217_REGS_t;

//====================================================================
//
//Register File: IO_PAD218 Configuration Registers (Padring_IO_PAD218)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD218_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD218 Configuration Register
} PADRING_IO_PAD218_REGS_t;

//====================================================================
//
//Register File: IO_PAD219 Configuration Registers (Padring_IO_PAD219)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD219_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD219 Configuration Register
} PADRING_IO_PAD219_REGS_t;

//====================================================================
//
//Register File: IO_PAD220 Configuration Registers (Padring_IO_PAD220)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD220_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD220 Configuration Register
} PADRING_IO_PAD220_REGS_t;

//====================================================================
//
//Register File: IO_PAD221 Configuration Registers (Padring_IO_PAD221)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD221_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD221 Configuration Register
} PADRING_IO_PAD221_REGS_t;

//====================================================================
//
//Register File: IO_PAD222 Configuration Registers (Padring_IO_PAD222)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD222_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD222 Configuration Register
} PADRING_IO_PAD222_REGS_t;

//====================================================================
//
//Register File: IO_PAD223 Configuration Registers (Padring_IO_PAD223)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD223_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD223 Configuration Register
} PADRING_IO_PAD223_REGS_t;

//====================================================================
//
//Register File: IO_PAD224 Configuration Registers (Padring_IO_PAD224)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD224_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD224 Configuration Register
} PADRING_IO_PAD224_REGS_t;

//====================================================================
//
//Register File: IO_PAD225 Configuration Registers (Padring_IO_PAD225)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

typedef struct PADRING_IO_PAD225_REGS_s
{
  volatile uint32_t PIOCFG;  ///< 0x0 [R/W]: IO_PAD225 Configuration Register
} PADRING_IO_PAD225_REGS_t;

#endif // AP_APB
