 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file apb_extra_logic_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _APB_EXTRA_LOGIC_REGMASKS_H_
#define _APB_EXTRA_LOGIC_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: APB EXTRA LOGIC Registers (APB_EXTRA_LOGIC)
/** \brief This register set includes a group of scratch pad APB registers*/
//
//====================================================================

//====================================================================
//Register: Extra1 Register (extra1)
/** \brief This is an extra register that can be used as F/W scratch pad, it currently has no effect on hardware.*/
//====================================================================

#define  APB_EXTRA_LOGIC_EXTRA1_EXTRA1_MASK 0xffffffff
#define  APB_EXTRA_LOGIC_EXTRA1_EXTRA1_SHIFT 0
#define  APB_EXTRA_LOGIC_EXTRA1_EXTRA1_MASK_SHIFT(reg) (((reg) & APB_EXTRA_LOGIC_EXTRA1_EXTRA1_MASK) >> APB_EXTRA_LOGIC_EXTRA1_EXTRA1_SHIFT)
#define  APB_EXTRA_LOGIC_EXTRA1_EXTRA1_REPLACE_VAL(reg,val) (((reg) & ~APB_EXTRA_LOGIC_EXTRA1_EXTRA1_MASK) | (((uint32_t)val) << APB_EXTRA_LOGIC_EXTRA1_EXTRA1_SHIFT))

//====================================================================
//Register: Spare1 Register (spare1)
/** \brief This is an spare register that can be used as F/W scratch pad, it currently has no effect on hardware.*/
//====================================================================

#define  APB_EXTRA_LOGIC_SPARE1_SPARE1_MASK 0xffffffff
#define  APB_EXTRA_LOGIC_SPARE1_SPARE1_SHIFT 0
#define  APB_EXTRA_LOGIC_SPARE1_SPARE1_MASK_SHIFT(reg) (((reg) & APB_EXTRA_LOGIC_SPARE1_SPARE1_MASK) >> APB_EXTRA_LOGIC_SPARE1_SPARE1_SHIFT)
#define  APB_EXTRA_LOGIC_SPARE1_SPARE1_REPLACE_VAL(reg,val) (((reg) & ~APB_EXTRA_LOGIC_SPARE1_SPARE1_MASK) | (((uint32_t)val) << APB_EXTRA_LOGIC_SPARE1_SPARE1_SHIFT))

//====================================================================
//Register: Spare2 Register (spare2)
/** \brief This is an spare register that can be used as F/W scratch pad, it currently has no effect on hardware.*/
//====================================================================

#define  APB_EXTRA_LOGIC_SPARE2_SPARE2_MASK 0xffffffff
#define  APB_EXTRA_LOGIC_SPARE2_SPARE2_SHIFT 0
#define  APB_EXTRA_LOGIC_SPARE2_SPARE2_MASK_SHIFT(reg) (((reg) & APB_EXTRA_LOGIC_SPARE2_SPARE2_MASK) >> APB_EXTRA_LOGIC_SPARE2_SPARE2_SHIFT)
#define  APB_EXTRA_LOGIC_SPARE2_SPARE2_REPLACE_VAL(reg,val) (((reg) & ~APB_EXTRA_LOGIC_SPARE2_SPARE2_MASK) | (((uint32_t)val) << APB_EXTRA_LOGIC_SPARE2_SPARE2_SHIFT))

//====================================================================
//Register: Spare3 Register (spare3)
/** \brief This is an spare register that can be used as F/W scratch pad, it currently has no effect on hardware.*/
//====================================================================

#define  APB_EXTRA_LOGIC_SPARE3_SPARE3_MASK 0xffffffff
#define  APB_EXTRA_LOGIC_SPARE3_SPARE3_SHIFT 0
#define  APB_EXTRA_LOGIC_SPARE3_SPARE3_MASK_SHIFT(reg) (((reg) & APB_EXTRA_LOGIC_SPARE3_SPARE3_MASK) >> APB_EXTRA_LOGIC_SPARE3_SPARE3_SHIFT)
#define  APB_EXTRA_LOGIC_SPARE3_SPARE3_REPLACE_VAL(reg,val) (((reg) & ~APB_EXTRA_LOGIC_SPARE3_SPARE3_MASK) | (((uint32_t)val) << APB_EXTRA_LOGIC_SPARE3_SPARE3_SHIFT))

//====================================================================
//Register: Spare4 Register (spare4)
/** \brief This is an spare register that can be used as F/W scratch pad, it currently has no effect on hardware.*/
//====================================================================

#define  APB_EXTRA_LOGIC_SPARE4_SPARE4_MASK 0xffffffff
#define  APB_EXTRA_LOGIC_SPARE4_SPARE4_SHIFT 0
#define  APB_EXTRA_LOGIC_SPARE4_SPARE4_MASK_SHIFT(reg) (((reg) & APB_EXTRA_LOGIC_SPARE4_SPARE4_MASK) >> APB_EXTRA_LOGIC_SPARE4_SPARE4_SHIFT)
#define  APB_EXTRA_LOGIC_SPARE4_SPARE4_REPLACE_VAL(reg,val) (((reg) & ~APB_EXTRA_LOGIC_SPARE4_SPARE4_MASK) | (((uint32_t)val) << APB_EXTRA_LOGIC_SPARE4_SPARE4_SHIFT))

#endif // APB_EXTRA_LOGIC
