 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file apb_config_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _APB_CONFIG_REGMASKS_H_
#define _APB_CONFIG_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: apb_config (apb_config)
//
//====================================================================

//====================================================================
//Register: DFT Island IP Tagging REV0 (DFTISLD_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_DFTISLD_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_DFTISLD_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_DFTISLD_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_DFTISLD_REV0_MAJ_MASK) >> APB_CONFIG_DFTISLD_REV0_MAJ_SHIFT)
#define  APB_CONFIG_DFTISLD_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_DFTISLD_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_DFTISLD_REV0_MAJ_SHIFT))

#define  APB_CONFIG_DFTISLD_REV0_MID_MASK 0xffff
#define  APB_CONFIG_DFTISLD_REV0_MID_SHIFT 0
#define  APB_CONFIG_DFTISLD_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_DFTISLD_REV0_MID_MASK) >> APB_CONFIG_DFTISLD_REV0_MID_SHIFT)
#define  APB_CONFIG_DFTISLD_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_DFTISLD_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_DFTISLD_REV0_MID_SHIFT))

//====================================================================
//Register: DFT Island IP Tagging REV1 (DFTISLD_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_DFTISLD_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_DFTISLD_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_DFTISLD_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_DFTISLD_REV1_RESERVED1_MASK) >> APB_CONFIG_DFTISLD_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_DFTISLD_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_DFTISLD_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_DFTISLD_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_DFTISLD_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_DFTISLD_REV1_CFG_SHIFT 0
#define  APB_CONFIG_DFTISLD_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_DFTISLD_REV1_CFG_MASK) >> APB_CONFIG_DFTISLD_REV1_CFG_SHIFT)
#define  APB_CONFIG_DFTISLD_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_DFTISLD_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_DFTISLD_REV1_CFG_SHIFT))

//====================================================================
//Register: NDSMC IP Tagging REV0 (NDSMC_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_NDSMC_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_NDSMC_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_NDSMC_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_NDSMC_REV0_MAJ_MASK) >> APB_CONFIG_NDSMC_REV0_MAJ_SHIFT)
#define  APB_CONFIG_NDSMC_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_NDSMC_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_NDSMC_REV0_MAJ_SHIFT))

#define  APB_CONFIG_NDSMC_REV0_MID_MASK 0xffff
#define  APB_CONFIG_NDSMC_REV0_MID_SHIFT 0
#define  APB_CONFIG_NDSMC_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_NDSMC_REV0_MID_MASK) >> APB_CONFIG_NDSMC_REV0_MID_SHIFT)
#define  APB_CONFIG_NDSMC_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_NDSMC_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_NDSMC_REV0_MID_SHIFT))

//====================================================================
//Register: NDSMC IP Tagging REV1 (NDSMC_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_NDSMC_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_NDSMC_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_NDSMC_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_NDSMC_REV1_RESERVED1_MASK) >> APB_CONFIG_NDSMC_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_NDSMC_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_NDSMC_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_NDSMC_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_NDSMC_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_NDSMC_REV1_CFG_SHIFT 0
#define  APB_CONFIG_NDSMC_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_NDSMC_REV1_CFG_MASK) >> APB_CONFIG_NDSMC_REV1_CFG_SHIFT)
#define  APB_CONFIG_NDSMC_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_NDSMC_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_NDSMC_REV1_CFG_SHIFT))

//====================================================================
//Register: USB3DEV IP Tagging REV0 (USB3DEV_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_USB3DEV_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_USB3DEV_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_USB3DEV_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3DEV_REV0_MAJ_MASK) >> APB_CONFIG_USB3DEV_REV0_MAJ_SHIFT)
#define  APB_CONFIG_USB3DEV_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3DEV_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_USB3DEV_REV0_MAJ_SHIFT))

#define  APB_CONFIG_USB3DEV_REV0_MID_MASK 0xffff
#define  APB_CONFIG_USB3DEV_REV0_MID_SHIFT 0
#define  APB_CONFIG_USB3DEV_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3DEV_REV0_MID_MASK) >> APB_CONFIG_USB3DEV_REV0_MID_SHIFT)
#define  APB_CONFIG_USB3DEV_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3DEV_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_USB3DEV_REV0_MID_SHIFT))

//====================================================================
//Register: USB3DEV IP Tagging REV1 (USB3DEV_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB3DEV_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_USB3DEV_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_USB3DEV_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3DEV_REV1_RESERVED1_MASK) >> APB_CONFIG_USB3DEV_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_USB3DEV_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3DEV_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB3DEV_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_USB3DEV_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_USB3DEV_REV1_CFG_SHIFT 0
#define  APB_CONFIG_USB3DEV_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3DEV_REV1_CFG_MASK) >> APB_CONFIG_USB3DEV_REV1_CFG_SHIFT)
#define  APB_CONFIG_USB3DEV_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3DEV_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_USB3DEV_REV1_CFG_SHIFT))

//====================================================================
//Register: USB3HOST IP Tagging REV0 (USB3HOST_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_USB3HOST_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_USB3HOST_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_USB3HOST_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HOST_REV0_MAJ_MASK) >> APB_CONFIG_USB3HOST_REV0_MAJ_SHIFT)
#define  APB_CONFIG_USB3HOST_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HOST_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HOST_REV0_MAJ_SHIFT))

#define  APB_CONFIG_USB3HOST_REV0_MID_MASK 0xffff
#define  APB_CONFIG_USB3HOST_REV0_MID_SHIFT 0
#define  APB_CONFIG_USB3HOST_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HOST_REV0_MID_MASK) >> APB_CONFIG_USB3HOST_REV0_MID_SHIFT)
#define  APB_CONFIG_USB3HOST_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HOST_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HOST_REV0_MID_SHIFT))

//====================================================================
//Register: USB3HOST IP Tagging REV1 (USB3HOST_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB3HOST_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_USB3HOST_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_USB3HOST_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HOST_REV1_RESERVED1_MASK) >> APB_CONFIG_USB3HOST_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_USB3HOST_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HOST_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HOST_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_USB3HOST_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_USB3HOST_REV1_CFG_SHIFT 0
#define  APB_CONFIG_USB3HOST_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HOST_REV1_CFG_MASK) >> APB_CONFIG_USB3HOST_REV1_CFG_SHIFT)
#define  APB_CONFIG_USB3HOST_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HOST_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HOST_REV1_CFG_SHIFT))

//====================================================================
//Register: USB2HOST IP Tagging REV0 (USB2HOST_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_USB2HOST_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_USB2HOST_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_USB2HOST_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2HOST_REV0_MAJ_MASK) >> APB_CONFIG_USB2HOST_REV0_MAJ_SHIFT)
#define  APB_CONFIG_USB2HOST_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2HOST_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_USB2HOST_REV0_MAJ_SHIFT))

#define  APB_CONFIG_USB2HOST_REV0_MID_MASK 0xffff
#define  APB_CONFIG_USB2HOST_REV0_MID_SHIFT 0
#define  APB_CONFIG_USB2HOST_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2HOST_REV0_MID_MASK) >> APB_CONFIG_USB2HOST_REV0_MID_SHIFT)
#define  APB_CONFIG_USB2HOST_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2HOST_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_USB2HOST_REV0_MID_SHIFT))

//====================================================================
//Register: USB2HOST IP Tagging REV1 (USB2HOST_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB2HOST_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_USB2HOST_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_USB2HOST_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2HOST_REV1_RESERVED1_MASK) >> APB_CONFIG_USB2HOST_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_USB2HOST_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2HOST_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB2HOST_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_USB2HOST_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_USB2HOST_REV1_CFG_SHIFT 0
#define  APB_CONFIG_USB2HOST_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2HOST_REV1_CFG_MASK) >> APB_CONFIG_USB2HOST_REV1_CFG_SHIFT)
#define  APB_CONFIG_USB2HOST_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2HOST_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_USB2HOST_REV1_CFG_SHIFT))

//====================================================================
//Register: USB2DEVHOST IP Tagging REV0 (USB2DEVHOST_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_USB2DEVHOST_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_USB2DEVHOST_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_USB2DEVHOST_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2DEVHOST_REV0_MAJ_MASK) >> APB_CONFIG_USB2DEVHOST_REV0_MAJ_SHIFT)
#define  APB_CONFIG_USB2DEVHOST_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2DEVHOST_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_USB2DEVHOST_REV0_MAJ_SHIFT))

#define  APB_CONFIG_USB2DEVHOST_REV0_MID_MASK 0xffff
#define  APB_CONFIG_USB2DEVHOST_REV0_MID_SHIFT 0
#define  APB_CONFIG_USB2DEVHOST_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2DEVHOST_REV0_MID_MASK) >> APB_CONFIG_USB2DEVHOST_REV0_MID_SHIFT)
#define  APB_CONFIG_USB2DEVHOST_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2DEVHOST_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_USB2DEVHOST_REV0_MID_SHIFT))

//====================================================================
//Register: USB2DEVHOST IP Tagging REV1 (USB2DEVHOST_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_MASK) >> APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB2DEVHOST_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_USB2DEVHOST_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_USB2DEVHOST_REV1_CFG_SHIFT 0
#define  APB_CONFIG_USB2DEVHOST_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2DEVHOST_REV1_CFG_MASK) >> APB_CONFIG_USB2DEVHOST_REV1_CFG_SHIFT)
#define  APB_CONFIG_USB2DEVHOST_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2DEVHOST_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_USB2DEVHOST_REV1_CFG_SHIFT))

//====================================================================
//Register: USB2TOP IP Tagging REV0 (USB2TOP_REV0)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB2TOP_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_USB2TOP_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_USB2TOP_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2TOP_REV0_MAJ_MASK) >> APB_CONFIG_USB2TOP_REV0_MAJ_SHIFT)
#define  APB_CONFIG_USB2TOP_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2TOP_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_USB2TOP_REV0_MAJ_SHIFT))

#define  APB_CONFIG_USB2TOP_REV0_MID_MASK 0xffff
#define  APB_CONFIG_USB2TOP_REV0_MID_SHIFT 0
#define  APB_CONFIG_USB2TOP_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2TOP_REV0_MID_MASK) >> APB_CONFIG_USB2TOP_REV0_MID_SHIFT)
#define  APB_CONFIG_USB2TOP_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2TOP_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_USB2TOP_REV0_MID_SHIFT))

//====================================================================
//Register: USB2TOP IP Tagging REV1 (USB2TOP_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_USB2TOP_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_USB2TOP_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_USB2TOP_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2TOP_REV1_RESERVED1_MASK) >> APB_CONFIG_USB2TOP_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_USB2TOP_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2TOP_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB2TOP_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_USB2TOP_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_USB2TOP_REV1_CFG_SHIFT 0
#define  APB_CONFIG_USB2TOP_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB2TOP_REV1_CFG_MASK) >> APB_CONFIG_USB2TOP_REV1_CFG_SHIFT)
#define  APB_CONFIG_USB2TOP_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB2TOP_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_USB2TOP_REV1_CFG_SHIFT))

//====================================================================
//Register: SATA IP Tagging REV0 (SATA_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_SATA_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_SATA_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_SATA_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SATA_REV0_MAJ_MASK) >> APB_CONFIG_SATA_REV0_MAJ_SHIFT)
#define  APB_CONFIG_SATA_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SATA_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_SATA_REV0_MAJ_SHIFT))

#define  APB_CONFIG_SATA_REV0_MID_MASK 0xffff
#define  APB_CONFIG_SATA_REV0_MID_SHIFT 0
#define  APB_CONFIG_SATA_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SATA_REV0_MID_MASK) >> APB_CONFIG_SATA_REV0_MID_SHIFT)
#define  APB_CONFIG_SATA_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SATA_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_SATA_REV0_MID_SHIFT))

//====================================================================
//Register: SATA IP Tagging REV1 (SATA_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_SATA_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_SATA_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_SATA_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SATA_REV1_RESERVED1_MASK) >> APB_CONFIG_SATA_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_SATA_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SATA_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_SATA_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_SATA_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_SATA_REV1_CFG_SHIFT 0
#define  APB_CONFIG_SATA_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SATA_REV1_CFG_MASK) >> APB_CONFIG_SATA_REV1_CFG_SHIFT)
#define  APB_CONFIG_SATA_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SATA_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_SATA_REV1_CFG_SHIFT))

//====================================================================
//Register: SQU IP Tagging REV0 (SQU_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_SQU_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_SQU_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_SQU_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SQU_REV0_MAJ_MASK) >> APB_CONFIG_SQU_REV0_MAJ_SHIFT)
#define  APB_CONFIG_SQU_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SQU_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_SQU_REV0_MAJ_SHIFT))

#define  APB_CONFIG_SQU_REV0_MID_MASK 0xffff
#define  APB_CONFIG_SQU_REV0_MID_SHIFT 0
#define  APB_CONFIG_SQU_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SQU_REV0_MID_MASK) >> APB_CONFIG_SQU_REV0_MID_SHIFT)
#define  APB_CONFIG_SQU_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SQU_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_SQU_REV0_MID_SHIFT))

//====================================================================
//Register: SQU IP Tagging REV1 (SQU_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_SQU_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_SQU_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_SQU_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SQU_REV1_RESERVED1_MASK) >> APB_CONFIG_SQU_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_SQU_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SQU_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_SQU_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_SQU_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_SQU_REV1_CFG_SHIFT 0
#define  APB_CONFIG_SQU_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_SQU_REV1_CFG_MASK) >> APB_CONFIG_SQU_REV1_CFG_SHIFT)
#define  APB_CONFIG_SQU_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_SQU_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_SQU_REV1_CFG_SHIFT))

//====================================================================
//Register: GC400 IP Tagging REV0 (GC400_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_GC400_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_GC400_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_GC400_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_GC400_REV0_MAJ_MASK) >> APB_CONFIG_GC400_REV0_MAJ_SHIFT)
#define  APB_CONFIG_GC400_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_GC400_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_GC400_REV0_MAJ_SHIFT))

#define  APB_CONFIG_GC400_REV0_MID_MASK 0xffff
#define  APB_CONFIG_GC400_REV0_MID_SHIFT 0
#define  APB_CONFIG_GC400_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_GC400_REV0_MID_MASK) >> APB_CONFIG_GC400_REV0_MID_SHIFT)
#define  APB_CONFIG_GC400_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_GC400_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_GC400_REV0_MID_SHIFT))

//====================================================================
//Register: GC400 IP Tagging REV1 (GC400_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_GC400_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_GC400_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_GC400_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_GC400_REV1_RESERVED1_MASK) >> APB_CONFIG_GC400_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_GC400_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_GC400_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_GC400_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_GC400_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_GC400_REV1_CFG_SHIFT 0
#define  APB_CONFIG_GC400_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_GC400_REV1_CFG_MASK) >> APB_CONFIG_GC400_REV1_CFG_SHIFT)
#define  APB_CONFIG_GC400_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_GC400_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_GC400_REV1_CFG_SHIFT))

//====================================================================
//Register: PDMA IP Tagging REV0 (PDMA_REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  APB_CONFIG_PDMA_REV0_MAJ_MASK 0xffff0000
#define  APB_CONFIG_PDMA_REV0_MAJ_SHIFT 16
#define  APB_CONFIG_PDMA_REV0_MAJ_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDMA_REV0_MAJ_MASK) >> APB_CONFIG_PDMA_REV0_MAJ_SHIFT)
#define  APB_CONFIG_PDMA_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDMA_REV0_MAJ_MASK) | (((uint32_t)val) << APB_CONFIG_PDMA_REV0_MAJ_SHIFT))

#define  APB_CONFIG_PDMA_REV0_MID_MASK 0xffff
#define  APB_CONFIG_PDMA_REV0_MID_SHIFT 0
#define  APB_CONFIG_PDMA_REV0_MID_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDMA_REV0_MID_MASK) >> APB_CONFIG_PDMA_REV0_MID_SHIFT)
#define  APB_CONFIG_PDMA_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDMA_REV0_MID_MASK) | (((uint32_t)val) << APB_CONFIG_PDMA_REV0_MID_SHIFT))

//====================================================================
//Register: PDMA IP Tagging REV1 (PDMA_REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  APB_CONFIG_PDMA_REV1_RESERVED1_MASK 0xffff0000
#define  APB_CONFIG_PDMA_REV1_RESERVED1_SHIFT 16
#define  APB_CONFIG_PDMA_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDMA_REV1_RESERVED1_MASK) >> APB_CONFIG_PDMA_REV1_RESERVED1_SHIFT)
#define  APB_CONFIG_PDMA_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDMA_REV1_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_PDMA_REV1_RESERVED1_SHIFT))

#define  APB_CONFIG_PDMA_REV1_CFG_MASK 0xffff
#define  APB_CONFIG_PDMA_REV1_CFG_SHIFT 0
#define  APB_CONFIG_PDMA_REV1_CFG_MASK_SHIFT(reg) (((reg) & APB_CONFIG_PDMA_REV1_CFG_MASK) >> APB_CONFIG_PDMA_REV1_CFG_SHIFT)
#define  APB_CONFIG_PDMA_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_PDMA_REV1_CFG_MASK) | (((uint32_t)val) << APB_CONFIG_PDMA_REV1_CFG_SHIFT))

//====================================================================
//Register: USB3_Host_Device (USB3HnD)
/** \brief Provide means for firmware to read USB3HnD fuse bit reset value and program the register for downstream driver.*/
//====================================================================

#define  APB_CONFIG_USB3HND_RESERVED1_MASK 0xfffffffe
#define  APB_CONFIG_USB3HND_RESERVED1_SHIFT 1
#define  APB_CONFIG_USB3HND_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HND_RESERVED1_MASK) >> APB_CONFIG_USB3HND_RESERVED1_SHIFT)
#define  APB_CONFIG_USB3HND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HND_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HND_RESERVED1_SHIFT))

#define  APB_CONFIG_USB3HND_USB3HND_MASK 0x1
#define  APB_CONFIG_USB3HND_USB3HND_SHIFT 0
#define  APB_CONFIG_USB3HND_USB3HND_MASK_SHIFT(reg) (((reg) & APB_CONFIG_USB3HND_USB3HND_MASK) >> APB_CONFIG_USB3HND_USB3HND_SHIFT)
#define  APB_CONFIG_USB3HND_USB3HND_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_USB3HND_USB3HND_MASK) | (((uint32_t)val) << APB_CONFIG_USB3HND_USB3HND_SHIFT))

//====================================================================
//Register: Strap_in (strap_in)
/** \brief Provide means for firmware to read the 8-bit strap_in value.*/
//====================================================================

#define  APB_CONFIG_STRAP_IN_RESERVED1_MASK 0xffffff00
#define  APB_CONFIG_STRAP_IN_RESERVED1_SHIFT 8
#define  APB_CONFIG_STRAP_IN_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_STRAP_IN_RESERVED1_MASK) >> APB_CONFIG_STRAP_IN_RESERVED1_SHIFT)
#define  APB_CONFIG_STRAP_IN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_STRAP_IN_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_STRAP_IN_RESERVED1_SHIFT))

#define  APB_CONFIG_STRAP_IN_STRAP_IN_MASK 0xff
#define  APB_CONFIG_STRAP_IN_STRAP_IN_SHIFT 0
#define  APB_CONFIG_STRAP_IN_STRAP_IN_MASK_SHIFT(reg) (((reg) & APB_CONFIG_STRAP_IN_STRAP_IN_MASK) >> APB_CONFIG_STRAP_IN_STRAP_IN_SHIFT)
#define  APB_CONFIG_STRAP_IN_STRAP_IN_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_STRAP_IN_STRAP_IN_MASK) | (((uint32_t)val) << APB_CONFIG_STRAP_IN_STRAP_IN_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R0 (Fuse_Bank0_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R1 (Fuse_Bank0_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R2 (Fuse_Bank0_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R3 (Fuse_Bank0_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R4 (Fuse_Bank0_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R5 (Fuse_Bank0_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R6 (Fuse_Bank0_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R7 (Fuse_Bank0_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank0_R8 (Fuse_Bank0_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank0 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK0_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK0_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK0_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK0_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK0_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R0 (Fuse_Bank1_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R1 (Fuse_Bank1_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R2 (Fuse_Bank1_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R3 (Fuse_Bank1_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R4 (Fuse_Bank1_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R5 (Fuse_Bank1_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R6 (Fuse_Bank1_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R7 (Fuse_Bank1_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank1_R8 (Fuse_Bank1_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank1 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK1_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK1_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK1_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK1_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK1_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R0 (Fuse_Bank2_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R1 (Fuse_Bank2_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R2 (Fuse_Bank2_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R3 (Fuse_Bank2_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R4 (Fuse_Bank2_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R5 (Fuse_Bank2_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R6 (Fuse_Bank2_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R7 (Fuse_Bank2_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank2_R8 (Fuse_Bank2_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank2 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK2_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK2_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK2_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK2_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK2_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R0 (Fuse_Bank3_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R1 (Fuse_Bank3_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R2 (Fuse_Bank3_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R3 (Fuse_Bank3_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R4 (Fuse_Bank3_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R5 (Fuse_Bank3_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R6 (Fuse_Bank3_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R7 (Fuse_Bank3_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank3_R8 (Fuse_Bank3_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank3 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK3_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK3_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK3_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK3_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK3_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R0 (Fuse_Bank4_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R1 (Fuse_Bank4_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R2 (Fuse_Bank4_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R3 (Fuse_Bank4_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R4 (Fuse_Bank4_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R5 (Fuse_Bank4_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R6 (Fuse_Bank4_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R7 (Fuse_Bank4_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank4_R8 (Fuse_Bank4_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank4 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK4_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK4_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK4_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK4_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK4_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R0 (Fuse_Bank5_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R1 (Fuse_Bank5_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R2 (Fuse_Bank5_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R3 (Fuse_Bank5_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R4 (Fuse_Bank5_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R5 (Fuse_Bank5_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R6 (Fuse_Bank5_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R7 (Fuse_Bank5_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank5_R8 (Fuse_Bank5_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank5 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK5_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK5_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK5_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK5_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK5_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R0 (Fuse_Bank6_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R1 (Fuse_Bank6_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R2 (Fuse_Bank6_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R3 (Fuse_Bank6_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R4 (Fuse_Bank6_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R5 (Fuse_Bank6_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R6 (Fuse_Bank6_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R7 (Fuse_Bank6_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank6_R8 (Fuse_Bank6_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank6 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK6_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK6_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK6_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK6_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK6_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R0 (Fuse_Bank7_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R1 (Fuse_Bank7_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R2 (Fuse_Bank7_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R3 (Fuse_Bank7_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R4 (Fuse_Bank7_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R5 (Fuse_Bank7_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R6 (Fuse_Bank7_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R7 (Fuse_Bank7_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank7_R8 (Fuse_Bank7_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank7 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK7_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK7_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK7_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK7_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK7_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R0 (Fuse_Bank8_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R1 (Fuse_Bank8_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R2 (Fuse_Bank8_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R3 (Fuse_Bank8_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R4 (Fuse_Bank8_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R5 (Fuse_Bank8_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R6 (Fuse_Bank8_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R7 (Fuse_Bank8_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank8_R8 (Fuse_Bank8_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank8 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK8_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK8_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK8_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK8_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK8_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R0 (Fuse_Bank9_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R1 (Fuse_Bank9_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R2 (Fuse_Bank9_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R3 (Fuse_Bank9_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R4 (Fuse_Bank9_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R5 (Fuse_Bank9_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R6 (Fuse_Bank9_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R7 (Fuse_Bank9_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank9_R8 (Fuse_Bank9_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank9 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK9_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK9_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK9_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK9_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK9_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R0 (Fuse_Bank10_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R1 (Fuse_Bank10_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R2 (Fuse_Bank10_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R3 (Fuse_Bank10_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R4 (Fuse_Bank10_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R5 (Fuse_Bank10_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R6 (Fuse_Bank10_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R7 (Fuse_Bank10_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank10_R8 (Fuse_Bank10_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank10 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK10_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK10_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK10_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK10_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK10_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R0 (Fuse_Bank11_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R1 (Fuse_Bank11_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R2 (Fuse_Bank11_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R3 (Fuse_Bank11_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R4 (Fuse_Bank11_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R5 (Fuse_Bank11_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R6 (Fuse_Bank11_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R7 (Fuse_Bank11_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank11_R8 (Fuse_Bank11_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank11 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK11_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK11_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK11_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK11_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK11_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R0 (Fuse_Bank12_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R1 (Fuse_Bank12_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R2 (Fuse_Bank12_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R3 (Fuse_Bank12_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R4 (Fuse_Bank12_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R5 (Fuse_Bank12_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R6 (Fuse_Bank12_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R7 (Fuse_Bank12_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank12_R8 (Fuse_Bank12_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank12 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK12_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK12_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK12_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK12_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK12_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R0 (Fuse_Bank13_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R1 (Fuse_Bank13_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R2 (Fuse_Bank13_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R3 (Fuse_Bank13_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R4 (Fuse_Bank13_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R5 (Fuse_Bank13_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R6 (Fuse_Bank13_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R7 (Fuse_Bank13_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank13_R8 (Fuse_Bank13_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank13 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK13_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK13_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK13_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK13_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK13_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R0 (Fuse_Bank14_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R1 (Fuse_Bank14_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R2 (Fuse_Bank14_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R3 (Fuse_Bank14_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R4 (Fuse_Bank14_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R5 (Fuse_Bank14_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R6 (Fuse_Bank14_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R7 (Fuse_Bank14_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank14_R8 (Fuse_Bank14_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank14 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK14_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK14_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK14_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK14_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK14_R8_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R0 (Fuse_Bank15_R0)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R0_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R1 (Fuse_Bank15_R1)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R1_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R2 (Fuse_Bank15_R2)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R2_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R3 (Fuse_Bank15_R3)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R3_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R4 (Fuse_Bank15_R4)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R4_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R5 (Fuse_Bank15_R5)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R5_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R6 (Fuse_Bank15_R6)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R6_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R7 (Fuse_Bank15_R7)
/** \brief Provide means for firmware to read the 32-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_MASK 0xffffffff
#define  APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R7_FUSE_VALUE_SHIFT))

//====================================================================
//Register: Fuse_Bank15_R8 (Fuse_Bank15_R8)
/** \brief Provide means for firmware to read the 9-bit Fuse Bank15 value.*/
//====================================================================

#define  APB_CONFIG_FUSE_BANK15_R8_RESERVED1_MASK 0xfffffe00
#define  APB_CONFIG_FUSE_BANK15_R8_RESERVED1_SHIFT 9
#define  APB_CONFIG_FUSE_BANK15_R8_RESERVED1_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R8_RESERVED1_MASK) >> APB_CONFIG_FUSE_BANK15_R8_RESERVED1_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R8_RESERVED1_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R8_RESERVED1_SHIFT))

#define  APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_MASK 0x1ff
#define  APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_SHIFT 0
#define  APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_MASK_SHIFT(reg) (((reg) & APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_MASK) >> APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_SHIFT)
#define  APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_MASK) | (((uint32_t)val) << APB_CONFIG_FUSE_BANK15_R8_FUSE_VALUE_SHIFT))

#endif // APB_CONFIG
