 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file aib_extra_logic_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _AIB_EXTRA_LOGIC_REGSTRUCTS_H_
#define _AIB_EXTRA_LOGIC_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: AIB EXTRA LOGIC PADRING CONFIG Registers (AIB_EXTRA_LOGIC)
/** \brief This register set includes all the AIB registers for pad section control*/
//
//====================================================================

typedef struct AIB_EXTRA_LOGIC_REGS_s
{
  volatile uint32_t G3_ZPZN;  ///< 0x0 [R/W]: G3 Padsection ZP/ZN Register
  volatile uint32_t G4_ZPZN;  ///< 0x4 [R/W]: G4 Padsection ZP/ZN Register
  volatile uint32_t G6_ZPZN;  ///< 0x8 [R/W]: G6 Padsection ZP/ZN Register
  volatile uint32_t G7_ZPZN;  ///< 0xc [R/W]: G7 Padsection ZP/ZN Register
  volatile uint32_t G8_ZPZN;  ///< 0x10 [R/W]: G8 Padsection ZP/ZN Register
  volatile uint32_t G9_ZPZN;  ///< 0x14 [R/W]: G9 Padsection ZP/ZN Register
  volatile uint32_t G11_ZPZN;  ///< 0x18 [R/W]: G11 Padsection ZP/ZN Register
  volatile uint32_t V18EN;  ///< 0x1c [R/W]: V18EN control per pad section Register
  volatile uint32_t VSensor01;  ///< 0x20 [R/W]: VSensor01 Control Register
  volatile uint32_t VSensor02;  ///< 0x24 [R/W]: VSensor02 Control Register
  volatile uint32_t VSensor03;  ///< 0x28 [R/W]: VSensor03 Control Register
  volatile uint32_t VSensor04;  ///< 0x2c [R/W]: VSensor04 Control Register
  volatile uint32_t VSensor05;  ///< 0x30 [R/W]: VSensor05 Control Register
  volatile uint32_t CAL_EN;  ///< 0x34 [R/W]: Calibration Pad Enable Register
  volatile uint32_t CAL_ODR;  ///< 0x38 [R/W]: Calibration Pad On Die Resistor Control Register
  volatile uint32_t ZN;  ///< 0x3c [R/W]: ZN Calibration Value Register
  volatile uint32_t ZP;  ///< 0x40 [R/W]: ZP Calibration Value Register
  volatile uint32_t ZP_AFT_CAL;  ///< 0x44 [R/W]: ZP Calibration Setting After Cal. Register
  volatile uint32_t reserved0[234];
  volatile uint32_t SPARE0;  ///< 0x3f0 [R/W]: SPARE 0 Register
  volatile uint32_t SPARE1;  ///< 0x3f4 [R/W]: SPARE 1 Register
  volatile uint32_t SPARE2;  ///< 0x3f8 [R/W]: SPARE 2 Register
  volatile uint32_t SPARE3;  ///< 0x3fc [R/W]: SPARE 3 Register
} AIB_EXTRA_LOGIC_REGS_t;

#endif // AIB_EXTRA_LOGIC
