 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file aib_extra_logic_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _AIB_EXTRA_LOGIC_REGMASKS_H_
#define _AIB_EXTRA_LOGIC_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: AIB EXTRA LOGIC PADRING CONFIG Registers (AIB_EXTRA_LOGIC)
/** \brief This register set includes all the AIB registers for pad section control*/
//
//====================================================================

//====================================================================
//Register: G3 Padsection ZP/ZN Register (G3_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G3 pad section.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_G3_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_G3_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_G3_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G3_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_G3_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_G3_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G3_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G3_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_G3_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_LOGIC_G3_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_LOGIC_G3_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G3_ZPZN_ZN_MASK) >> AIB_EXTRA_LOGIC_G3_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_LOGIC_G3_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G3_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G3_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_LOGIC_G3_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_LOGIC_G3_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_LOGIC_G3_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G3_ZPZN_ZP_MASK) >> AIB_EXTRA_LOGIC_G3_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_LOGIC_G3_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G3_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G3_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G4 Padsection ZP/ZN Register (G4_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G4 pad section.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_G4_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_G4_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_G4_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G4_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_G4_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_G4_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G4_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G4_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_G4_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_LOGIC_G4_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_LOGIC_G4_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G4_ZPZN_ZN_MASK) >> AIB_EXTRA_LOGIC_G4_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_LOGIC_G4_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G4_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G4_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_LOGIC_G4_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_LOGIC_G4_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_LOGIC_G4_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G4_ZPZN_ZP_MASK) >> AIB_EXTRA_LOGIC_G4_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_LOGIC_G4_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G4_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G4_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G6 Padsection ZP/ZN Register (G6_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G6 pad section.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_G6_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_G6_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_G6_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G6_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_G6_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_G6_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G6_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G6_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_G6_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_LOGIC_G6_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_LOGIC_G6_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G6_ZPZN_ZN_MASK) >> AIB_EXTRA_LOGIC_G6_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_LOGIC_G6_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G6_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G6_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_LOGIC_G6_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_LOGIC_G6_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_LOGIC_G6_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G6_ZPZN_ZP_MASK) >> AIB_EXTRA_LOGIC_G6_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_LOGIC_G6_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G6_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G6_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G7 Padsection ZP/ZN Register (G7_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G7 pad section.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_G7_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_G7_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_G7_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G7_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_G7_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_G7_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G7_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G7_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_G7_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_LOGIC_G7_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_LOGIC_G7_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G7_ZPZN_ZN_MASK) >> AIB_EXTRA_LOGIC_G7_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_LOGIC_G7_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G7_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G7_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_LOGIC_G7_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_LOGIC_G7_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_LOGIC_G7_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G7_ZPZN_ZP_MASK) >> AIB_EXTRA_LOGIC_G7_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_LOGIC_G7_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G7_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G7_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G8 Padsection ZP/ZN Register (G8_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G8 pad section.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_G8_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_G8_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_G8_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G8_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_G8_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_G8_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G8_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G8_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_G8_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_LOGIC_G8_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_LOGIC_G8_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G8_ZPZN_ZN_MASK) >> AIB_EXTRA_LOGIC_G8_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_LOGIC_G8_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G8_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G8_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_LOGIC_G8_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_LOGIC_G8_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_LOGIC_G8_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G8_ZPZN_ZP_MASK) >> AIB_EXTRA_LOGIC_G8_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_LOGIC_G8_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G8_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G8_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G9 Padsection ZP/ZN Register (G9_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G9 pad section.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_G9_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_G9_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_G9_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G9_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_G9_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_G9_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G9_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G9_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_G9_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_LOGIC_G9_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_LOGIC_G9_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G9_ZPZN_ZN_MASK) >> AIB_EXTRA_LOGIC_G9_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_LOGIC_G9_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G9_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G9_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_LOGIC_G9_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_LOGIC_G9_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_LOGIC_G9_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G9_ZPZN_ZP_MASK) >> AIB_EXTRA_LOGIC_G9_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_LOGIC_G9_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G9_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G9_ZPZN_ZP_SHIFT))

//====================================================================
//Register: G11 Padsection ZP/ZN Register (G11_ZPZN)
/** \brief This register is used to control the ZP/ZN settinings for pads in the G11 pad section.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_G11_ZPZN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_G11_ZPZN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_G11_ZPZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G11_ZPZN_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_G11_ZPZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_G11_ZPZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G11_ZPZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G11_ZPZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_G11_ZPZN_ZN_MASK 0xf0
#define  AIB_EXTRA_LOGIC_G11_ZPZN_ZN_SHIFT 4
#define  AIB_EXTRA_LOGIC_G11_ZPZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G11_ZPZN_ZN_MASK) >> AIB_EXTRA_LOGIC_G11_ZPZN_ZN_SHIFT)
#define  AIB_EXTRA_LOGIC_G11_ZPZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G11_ZPZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G11_ZPZN_ZN_SHIFT))

#define  AIB_EXTRA_LOGIC_G11_ZPZN_ZP_MASK 0xf
#define  AIB_EXTRA_LOGIC_G11_ZPZN_ZP_SHIFT 0
#define  AIB_EXTRA_LOGIC_G11_ZPZN_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_G11_ZPZN_ZP_MASK) >> AIB_EXTRA_LOGIC_G11_ZPZN_ZP_SHIFT)
#define  AIB_EXTRA_LOGIC_G11_ZPZN_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_G11_ZPZN_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_G11_ZPZN_ZP_SHIFT))

//====================================================================
//Register: V18EN control per pad section Register (V18EN)
/** \brief This register is used to control the 1.8v enable for the various pad sections that can be switched from 3.3v to 1.8v.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_V18EN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_V18EN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_V18EN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_V18EN_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_V18EN_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_V18EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_V18EN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_V18EN_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_V18EN_NOTUSED_MASK 0xf0
#define  AIB_EXTRA_LOGIC_V18EN_NOTUSED_SHIFT 4
#define  AIB_EXTRA_LOGIC_V18EN_NOTUSED_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_V18EN_NOTUSED_MASK) >> AIB_EXTRA_LOGIC_V18EN_NOTUSED_SHIFT)
#define  AIB_EXTRA_LOGIC_V18EN_NOTUSED_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_V18EN_NOTUSED_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_V18EN_NOTUSED_SHIFT))

#define  AIB_EXTRA_LOGIC_V18EN_G11_V18EN_MASK 0x8
#define  AIB_EXTRA_LOGIC_V18EN_G11_V18EN_SHIFT 3
#define  AIB_EXTRA_LOGIC_V18EN_G11_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_V18EN_G11_V18EN_MASK) >> AIB_EXTRA_LOGIC_V18EN_G11_V18EN_SHIFT)
#define  AIB_EXTRA_LOGIC_V18EN_G11_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_V18EN_G11_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_V18EN_G11_V18EN_SHIFT))

#define  AIB_EXTRA_LOGIC_V18EN_G10_V18EN_MASK 0x4
#define  AIB_EXTRA_LOGIC_V18EN_G10_V18EN_SHIFT 2
#define  AIB_EXTRA_LOGIC_V18EN_G10_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_V18EN_G10_V18EN_MASK) >> AIB_EXTRA_LOGIC_V18EN_G10_V18EN_SHIFT)
#define  AIB_EXTRA_LOGIC_V18EN_G10_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_V18EN_G10_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_V18EN_G10_V18EN_SHIFT))

#define  AIB_EXTRA_LOGIC_V18EN_G5_V18EN_MASK 0x2
#define  AIB_EXTRA_LOGIC_V18EN_G5_V18EN_SHIFT 1
#define  AIB_EXTRA_LOGIC_V18EN_G5_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_V18EN_G5_V18EN_MASK) >> AIB_EXTRA_LOGIC_V18EN_G5_V18EN_SHIFT)
#define  AIB_EXTRA_LOGIC_V18EN_G5_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_V18EN_G5_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_V18EN_G5_V18EN_SHIFT))

#define  AIB_EXTRA_LOGIC_V18EN_G4_V18EN_MASK 0x1
#define  AIB_EXTRA_LOGIC_V18EN_G4_V18EN_SHIFT 0
#define  AIB_EXTRA_LOGIC_V18EN_G4_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_V18EN_G4_V18EN_MASK) >> AIB_EXTRA_LOGIC_V18EN_G4_V18EN_SHIFT)
#define  AIB_EXTRA_LOGIC_V18EN_G4_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_V18EN_G4_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_V18EN_G4_V18EN_SHIFT))

//====================================================================
//Register: VSensor01 Control Register (VSensor01)
/** \brief This register is used to control the Vsensor Pad in the G3 pad section. <br>
 VSENSOR Truth Table
 <table>
  <tr>
    <th>LOW_VDDB</th><th>BYPASS</th><th>DISABLE</th><th>VSENSOR</th><th>Vsensor LATCH output</th><th>V18EN_Ring</th>
  </tr>
  <tr>
   <td>0</td><td>X</td><td>X</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br/>0 if VDD gt 2.3v<br/>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>0</td><td>0</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>0</td><td>Enabled but bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow V18EN_IN</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>1</td><td>Disabled<br>(1)</td><td>Maintain State<br>(2)</td><td>Follow V18EN_IN</td>
  </tr>
 </table>
 <br/>
(1) Vsensor is disabled because VDD is ready and DISABLE=1. Setting DISABLE back to 0 or powering off VDD will re-enable Vsensor. <br />
(2) For the existing Vsensor LATCH output to be correct, DISABLE must remains 0 for at least 100us after both 1.8V and VDD are powered up. <br />*/
//====================================================================

#define  AIB_EXTRA_LOGIC_VSENSOR01_RESERVED1_MASK 0xffff0000
#define  AIB_EXTRA_LOGIC_VSENSOR01_RESERVED1_SHIFT 16
#define  AIB_EXTRA_LOGIC_VSENSOR01_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR01_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_VSENSOR01_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR01_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR01_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR01_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR01_V18EN_OUT_MASK 0x8000
#define  AIB_EXTRA_LOGIC_VSENSOR01_V18EN_OUT_SHIFT 15
#define  AIB_EXTRA_LOGIC_VSENSOR01_V18EN_OUT_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR01_V18EN_OUT_MASK) >> AIB_EXTRA_LOGIC_VSENSOR01_V18EN_OUT_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR01_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR01_V18EN_OUT_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR01_V18EN_OUT_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR01_RESERVED2_MASK 0x7f00
#define  AIB_EXTRA_LOGIC_VSENSOR01_RESERVED2_SHIFT 8
#define  AIB_EXTRA_LOGIC_VSENSOR01_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR01_RESERVED2_MASK) >> AIB_EXTRA_LOGIC_VSENSOR01_RESERVED2_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR01_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR01_RESERVED2_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR01_TE_MASK 0x80
#define  AIB_EXTRA_LOGIC_VSENSOR01_TE_SHIFT 7
#define  AIB_EXTRA_LOGIC_VSENSOR01_TE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR01_TE_MASK) >> AIB_EXTRA_LOGIC_VSENSOR01_TE_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR01_TE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR01_TE_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR01_TE_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR01_TP_SEL_MASK 0x70
#define  AIB_EXTRA_LOGIC_VSENSOR01_TP_SEL_SHIFT 4
#define  AIB_EXTRA_LOGIC_VSENSOR01_TP_SEL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR01_TP_SEL_MASK) >> AIB_EXTRA_LOGIC_VSENSOR01_TP_SEL_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR01_TP_SEL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR01_TP_SEL_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR01_TP_SEL_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR01_DISABLE_MASK 0x8
#define  AIB_EXTRA_LOGIC_VSENSOR01_DISABLE_SHIFT 3
#define  AIB_EXTRA_LOGIC_VSENSOR01_DISABLE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR01_DISABLE_MASK) >> AIB_EXTRA_LOGIC_VSENSOR01_DISABLE_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR01_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR01_DISABLE_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR01_DISABLE_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR01_VTHRESH_MASK 0x4
#define  AIB_EXTRA_LOGIC_VSENSOR01_VTHRESH_SHIFT 2
#define  AIB_EXTRA_LOGIC_VSENSOR01_VTHRESH_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR01_VTHRESH_MASK) >> AIB_EXTRA_LOGIC_VSENSOR01_VTHRESH_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR01_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR01_VTHRESH_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR01_VTHRESH_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR01_BYPASS_MASK 0x2
#define  AIB_EXTRA_LOGIC_VSENSOR01_BYPASS_SHIFT 1
#define  AIB_EXTRA_LOGIC_VSENSOR01_BYPASS_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR01_BYPASS_MASK) >> AIB_EXTRA_LOGIC_VSENSOR01_BYPASS_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR01_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR01_BYPASS_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR01_BYPASS_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR01_V18EN_MASK 0x1
#define  AIB_EXTRA_LOGIC_VSENSOR01_V18EN_SHIFT 0
#define  AIB_EXTRA_LOGIC_VSENSOR01_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR01_V18EN_MASK) >> AIB_EXTRA_LOGIC_VSENSOR01_V18EN_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR01_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR01_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR01_V18EN_SHIFT))

//====================================================================
//Register: VSensor02 Control Register (VSensor02)
/** \brief This register is used to control Vsensor Pad for the G6 pad section. <br />
 VSENSOR Truth Table
 <table>
  <tr>
    <th>LOW_VDDB</th><th>BYPASS</th><th>DISABLE</th><th>VSENSOR</th><th>Vsensor LATCH output</th><th>V18EN_Ring</th>
  </tr>
  <tr>
   <td>0</td><td>X</td><td>X</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br/>0 if VDD gt 2.3v<br/>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>0</td><td>0</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>0</td><td>Enabled but bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow V18EN_IN</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>1</td><td>Disabled<br>(1)</td><td>Maintain State<br>(2)</td><td>Follow V18EN_IN</td>
  </tr>
 </table>
 <br/>
(1) Vsensor is disabled because VDD is ready and DISABLE=1. Setting DISABLE back to 0 or powering off VDD will re-enable Vsensor. <br />
(2) For the existing Vsensor LATCH output to be correct, DISABLE must remains 0 for at least 100us after both 1.8V and VDD are powered up. <br />*/
//====================================================================

#define  AIB_EXTRA_LOGIC_VSENSOR02_RESERVED1_MASK 0xffff0000
#define  AIB_EXTRA_LOGIC_VSENSOR02_RESERVED1_SHIFT 16
#define  AIB_EXTRA_LOGIC_VSENSOR02_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR02_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_VSENSOR02_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR02_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR02_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR02_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR02_V18EN_OUT_MASK 0x8000
#define  AIB_EXTRA_LOGIC_VSENSOR02_V18EN_OUT_SHIFT 15
#define  AIB_EXTRA_LOGIC_VSENSOR02_V18EN_OUT_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR02_V18EN_OUT_MASK) >> AIB_EXTRA_LOGIC_VSENSOR02_V18EN_OUT_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR02_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR02_V18EN_OUT_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR02_V18EN_OUT_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR02_RESERVED2_MASK 0x7f00
#define  AIB_EXTRA_LOGIC_VSENSOR02_RESERVED2_SHIFT 8
#define  AIB_EXTRA_LOGIC_VSENSOR02_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR02_RESERVED2_MASK) >> AIB_EXTRA_LOGIC_VSENSOR02_RESERVED2_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR02_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR02_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR02_RESERVED2_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR02_TE_MASK 0x80
#define  AIB_EXTRA_LOGIC_VSENSOR02_TE_SHIFT 7
#define  AIB_EXTRA_LOGIC_VSENSOR02_TE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR02_TE_MASK) >> AIB_EXTRA_LOGIC_VSENSOR02_TE_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR02_TE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR02_TE_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR02_TE_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR02_TP_SEL_MASK 0x70
#define  AIB_EXTRA_LOGIC_VSENSOR02_TP_SEL_SHIFT 4
#define  AIB_EXTRA_LOGIC_VSENSOR02_TP_SEL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR02_TP_SEL_MASK) >> AIB_EXTRA_LOGIC_VSENSOR02_TP_SEL_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR02_TP_SEL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR02_TP_SEL_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR02_TP_SEL_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR02_DISABLE_MASK 0x8
#define  AIB_EXTRA_LOGIC_VSENSOR02_DISABLE_SHIFT 3
#define  AIB_EXTRA_LOGIC_VSENSOR02_DISABLE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR02_DISABLE_MASK) >> AIB_EXTRA_LOGIC_VSENSOR02_DISABLE_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR02_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR02_DISABLE_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR02_DISABLE_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR02_VTHRESH_MASK 0x4
#define  AIB_EXTRA_LOGIC_VSENSOR02_VTHRESH_SHIFT 2
#define  AIB_EXTRA_LOGIC_VSENSOR02_VTHRESH_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR02_VTHRESH_MASK) >> AIB_EXTRA_LOGIC_VSENSOR02_VTHRESH_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR02_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR02_VTHRESH_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR02_VTHRESH_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR02_BYPASS_MASK 0x2
#define  AIB_EXTRA_LOGIC_VSENSOR02_BYPASS_SHIFT 1
#define  AIB_EXTRA_LOGIC_VSENSOR02_BYPASS_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR02_BYPASS_MASK) >> AIB_EXTRA_LOGIC_VSENSOR02_BYPASS_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR02_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR02_BYPASS_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR02_BYPASS_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR02_V18EN_MASK 0x1
#define  AIB_EXTRA_LOGIC_VSENSOR02_V18EN_SHIFT 0
#define  AIB_EXTRA_LOGIC_VSENSOR02_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR02_V18EN_MASK) >> AIB_EXTRA_LOGIC_VSENSOR02_V18EN_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR02_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR02_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR02_V18EN_SHIFT))

//====================================================================
//Register: VSensor03 Control Register (VSensor03)
/** \brief This register is used to control Vsensor Pad for the G7 pad section. <br />
 VSENSOR Truth Table
 <table>
  <tr>
    <th>LOW_VDDB</th><th>BYPASS</th><th>DISABLE</th><th>VSENSOR</th><th>Vsensor LATCH output</th><th>V18EN_Ring</th>
  </tr>
  <tr>
   <td>0</td><td>X</td><td>X</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br/>0 if VDD gt 2.3v<br/>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>0</td><td>0</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>0</td><td>Enabled but bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow V18EN_IN</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>1</td><td>Disabled<br>(1)</td><td>Maintain State<br>(2)</td><td>Follow V18EN_IN</td>
  </tr>
 </table>
 <br/>
(1) Vsensor is disabled because VDD is ready and DISABLE=1. Setting DISABLE back to 0 or powering off VDD will re-enable Vsensor. <br />
(2) For the existing Vsensor LATCH output to be correct, DISABLE must remains 0 for at least 100us after both 1.8V and VDD are powered up. <br />*/
//====================================================================

#define  AIB_EXTRA_LOGIC_VSENSOR03_RESERVED1_MASK 0xffff0000
#define  AIB_EXTRA_LOGIC_VSENSOR03_RESERVED1_SHIFT 16
#define  AIB_EXTRA_LOGIC_VSENSOR03_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR03_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_VSENSOR03_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR03_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR03_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR03_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR03_V18EN_OUT_MASK 0x8000
#define  AIB_EXTRA_LOGIC_VSENSOR03_V18EN_OUT_SHIFT 15
#define  AIB_EXTRA_LOGIC_VSENSOR03_V18EN_OUT_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR03_V18EN_OUT_MASK) >> AIB_EXTRA_LOGIC_VSENSOR03_V18EN_OUT_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR03_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR03_V18EN_OUT_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR03_V18EN_OUT_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR03_RESERVED2_MASK 0x7f00
#define  AIB_EXTRA_LOGIC_VSENSOR03_RESERVED2_SHIFT 8
#define  AIB_EXTRA_LOGIC_VSENSOR03_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR03_RESERVED2_MASK) >> AIB_EXTRA_LOGIC_VSENSOR03_RESERVED2_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR03_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR03_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR03_RESERVED2_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR03_TE_MASK 0x80
#define  AIB_EXTRA_LOGIC_VSENSOR03_TE_SHIFT 7
#define  AIB_EXTRA_LOGIC_VSENSOR03_TE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR03_TE_MASK) >> AIB_EXTRA_LOGIC_VSENSOR03_TE_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR03_TE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR03_TE_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR03_TE_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR03_TP_SEL_MASK 0x70
#define  AIB_EXTRA_LOGIC_VSENSOR03_TP_SEL_SHIFT 4
#define  AIB_EXTRA_LOGIC_VSENSOR03_TP_SEL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR03_TP_SEL_MASK) >> AIB_EXTRA_LOGIC_VSENSOR03_TP_SEL_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR03_TP_SEL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR03_TP_SEL_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR03_TP_SEL_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR03_DISABLE_MASK 0x8
#define  AIB_EXTRA_LOGIC_VSENSOR03_DISABLE_SHIFT 3
#define  AIB_EXTRA_LOGIC_VSENSOR03_DISABLE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR03_DISABLE_MASK) >> AIB_EXTRA_LOGIC_VSENSOR03_DISABLE_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR03_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR03_DISABLE_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR03_DISABLE_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR03_VTHRESH_MASK 0x4
#define  AIB_EXTRA_LOGIC_VSENSOR03_VTHRESH_SHIFT 2
#define  AIB_EXTRA_LOGIC_VSENSOR03_VTHRESH_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR03_VTHRESH_MASK) >> AIB_EXTRA_LOGIC_VSENSOR03_VTHRESH_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR03_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR03_VTHRESH_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR03_VTHRESH_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR03_BYPASS_MASK 0x2
#define  AIB_EXTRA_LOGIC_VSENSOR03_BYPASS_SHIFT 1
#define  AIB_EXTRA_LOGIC_VSENSOR03_BYPASS_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR03_BYPASS_MASK) >> AIB_EXTRA_LOGIC_VSENSOR03_BYPASS_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR03_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR03_BYPASS_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR03_BYPASS_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR03_V18EN_MASK 0x1
#define  AIB_EXTRA_LOGIC_VSENSOR03_V18EN_SHIFT 0
#define  AIB_EXTRA_LOGIC_VSENSOR03_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR03_V18EN_MASK) >> AIB_EXTRA_LOGIC_VSENSOR03_V18EN_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR03_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR03_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR03_V18EN_SHIFT))

//====================================================================
//Register: VSensor04 Control Register (VSensor04)
/** \brief This register is used to control Vsensor Pad for the G8 pad section. <br />
 VSENSOR Truth Table
 <table>
  <tr>
    <th>LOW_VDDB</th><th>BYPASS</th><th>DISABLE</th><th>VSENSOR</th><th>Vsensor LATCH output</th><th>V18EN_Ring</th>
  </tr>
  <tr>
   <td>0</td><td>X</td><td>X</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br/>0 if VDD gt 2.3v<br/>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>0</td><td>0</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>0</td><td>Enabled but bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow V18EN_IN</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>1</td><td>Disabled<br>(1)</td><td>Maintain State<br>(2)</td><td>Follow V18EN_IN</td>
  </tr>
 </table>
 <br/>
(1) Vsensor is disabled because VDD is ready and DISABLE=1. Setting DISABLE back to 0 or powering off VDD will re-enable Vsensor. <br />
(2) For the existing Vsensor LATCH output to be correct, DISABLE must remains 0 for at least 100us after both 1.8V and VDD are powered up. <br />*/
//====================================================================

#define  AIB_EXTRA_LOGIC_VSENSOR04_RESERVED1_MASK 0xffff0000
#define  AIB_EXTRA_LOGIC_VSENSOR04_RESERVED1_SHIFT 16
#define  AIB_EXTRA_LOGIC_VSENSOR04_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR04_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_VSENSOR04_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR04_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR04_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR04_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR04_V18EN_OUT_MASK 0x8000
#define  AIB_EXTRA_LOGIC_VSENSOR04_V18EN_OUT_SHIFT 15
#define  AIB_EXTRA_LOGIC_VSENSOR04_V18EN_OUT_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR04_V18EN_OUT_MASK) >> AIB_EXTRA_LOGIC_VSENSOR04_V18EN_OUT_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR04_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR04_V18EN_OUT_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR04_V18EN_OUT_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR04_RESERVED2_MASK 0x7f00
#define  AIB_EXTRA_LOGIC_VSENSOR04_RESERVED2_SHIFT 8
#define  AIB_EXTRA_LOGIC_VSENSOR04_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR04_RESERVED2_MASK) >> AIB_EXTRA_LOGIC_VSENSOR04_RESERVED2_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR04_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR04_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR04_RESERVED2_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR04_TE_MASK 0x80
#define  AIB_EXTRA_LOGIC_VSENSOR04_TE_SHIFT 7
#define  AIB_EXTRA_LOGIC_VSENSOR04_TE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR04_TE_MASK) >> AIB_EXTRA_LOGIC_VSENSOR04_TE_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR04_TE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR04_TE_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR04_TE_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR04_TP_SEL_MASK 0x70
#define  AIB_EXTRA_LOGIC_VSENSOR04_TP_SEL_SHIFT 4
#define  AIB_EXTRA_LOGIC_VSENSOR04_TP_SEL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR04_TP_SEL_MASK) >> AIB_EXTRA_LOGIC_VSENSOR04_TP_SEL_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR04_TP_SEL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR04_TP_SEL_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR04_TP_SEL_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR04_DISABLE_MASK 0x8
#define  AIB_EXTRA_LOGIC_VSENSOR04_DISABLE_SHIFT 3
#define  AIB_EXTRA_LOGIC_VSENSOR04_DISABLE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR04_DISABLE_MASK) >> AIB_EXTRA_LOGIC_VSENSOR04_DISABLE_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR04_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR04_DISABLE_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR04_DISABLE_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR04_VTHRESH_MASK 0x4
#define  AIB_EXTRA_LOGIC_VSENSOR04_VTHRESH_SHIFT 2
#define  AIB_EXTRA_LOGIC_VSENSOR04_VTHRESH_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR04_VTHRESH_MASK) >> AIB_EXTRA_LOGIC_VSENSOR04_VTHRESH_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR04_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR04_VTHRESH_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR04_VTHRESH_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR04_BYPASS_MASK 0x2
#define  AIB_EXTRA_LOGIC_VSENSOR04_BYPASS_SHIFT 1
#define  AIB_EXTRA_LOGIC_VSENSOR04_BYPASS_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR04_BYPASS_MASK) >> AIB_EXTRA_LOGIC_VSENSOR04_BYPASS_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR04_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR04_BYPASS_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR04_BYPASS_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR04_V18EN_MASK 0x1
#define  AIB_EXTRA_LOGIC_VSENSOR04_V18EN_SHIFT 0
#define  AIB_EXTRA_LOGIC_VSENSOR04_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR04_V18EN_MASK) >> AIB_EXTRA_LOGIC_VSENSOR04_V18EN_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR04_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR04_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR04_V18EN_SHIFT))

//====================================================================
//Register: VSensor05 Control Register (VSensor05)
/** \brief This register is used to control Vsensor Pad for the G9 pad section. <br />
 VSENSOR Truth Table
 <table>
  <tr>
    <th>LOW_VDDB</th><th>BYPASS</th><th>DISABLE</th><th>VSENSOR</th><th>Vsensor LATCH output</th><th>V18EN_Ring</th>
  </tr>
  <tr>
   <td>0</td><td>X</td><td>X</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br/>0 if VDD gt 2.3v<br/>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>0</td><td>0</td><td>Enabled and NOT bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow Vsensor</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>0</td><td>Enabled but bypassed</td><td>Driven by VSENSOR:<br>0 if VDD gt 2.3v<br>1 if VDD lt 2.3v</td><td>Follow V18EN_IN</td>
  </tr>
  <tr>
   <td>1</td><td>1</td><td>1</td><td>Disabled<br>(1)</td><td>Maintain State<br>(2)</td><td>Follow V18EN_IN</td>
  </tr>
 </table>
 <br/>
(1) Vsensor is disabled because VDD is ready and DISABLE=1. Setting DISABLE back to 0 or powering off VDD will re-enable Vsensor. <br />
(2) For the existing Vsensor LATCH output to be correct, DISABLE must remains 0 for at least 100us after both 1.8V and VDD are powered up. <br />*/
//====================================================================

#define  AIB_EXTRA_LOGIC_VSENSOR05_RESERVED1_MASK 0xffff0000
#define  AIB_EXTRA_LOGIC_VSENSOR05_RESERVED1_SHIFT 16
#define  AIB_EXTRA_LOGIC_VSENSOR05_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR05_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_VSENSOR05_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR05_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR05_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR05_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR05_V18EN_OUT_MASK 0x8000
#define  AIB_EXTRA_LOGIC_VSENSOR05_V18EN_OUT_SHIFT 15
#define  AIB_EXTRA_LOGIC_VSENSOR05_V18EN_OUT_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR05_V18EN_OUT_MASK) >> AIB_EXTRA_LOGIC_VSENSOR05_V18EN_OUT_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR05_V18EN_OUT_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR05_V18EN_OUT_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR05_V18EN_OUT_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR05_RESERVED2_MASK 0x7f00
#define  AIB_EXTRA_LOGIC_VSENSOR05_RESERVED2_SHIFT 8
#define  AIB_EXTRA_LOGIC_VSENSOR05_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR05_RESERVED2_MASK) >> AIB_EXTRA_LOGIC_VSENSOR05_RESERVED2_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR05_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR05_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR05_RESERVED2_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR05_TE_MASK 0x80
#define  AIB_EXTRA_LOGIC_VSENSOR05_TE_SHIFT 7
#define  AIB_EXTRA_LOGIC_VSENSOR05_TE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR05_TE_MASK) >> AIB_EXTRA_LOGIC_VSENSOR05_TE_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR05_TE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR05_TE_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR05_TE_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR05_TP_SEL_MASK 0x70
#define  AIB_EXTRA_LOGIC_VSENSOR05_TP_SEL_SHIFT 4
#define  AIB_EXTRA_LOGIC_VSENSOR05_TP_SEL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR05_TP_SEL_MASK) >> AIB_EXTRA_LOGIC_VSENSOR05_TP_SEL_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR05_TP_SEL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR05_TP_SEL_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR05_TP_SEL_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR05_DISABLE_MASK 0x8
#define  AIB_EXTRA_LOGIC_VSENSOR05_DISABLE_SHIFT 3
#define  AIB_EXTRA_LOGIC_VSENSOR05_DISABLE_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR05_DISABLE_MASK) >> AIB_EXTRA_LOGIC_VSENSOR05_DISABLE_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR05_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR05_DISABLE_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR05_DISABLE_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR05_VTHRESH_MASK 0x4
#define  AIB_EXTRA_LOGIC_VSENSOR05_VTHRESH_SHIFT 2
#define  AIB_EXTRA_LOGIC_VSENSOR05_VTHRESH_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR05_VTHRESH_MASK) >> AIB_EXTRA_LOGIC_VSENSOR05_VTHRESH_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR05_VTHRESH_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR05_VTHRESH_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR05_VTHRESH_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR05_BYPASS_MASK 0x2
#define  AIB_EXTRA_LOGIC_VSENSOR05_BYPASS_SHIFT 1
#define  AIB_EXTRA_LOGIC_VSENSOR05_BYPASS_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR05_BYPASS_MASK) >> AIB_EXTRA_LOGIC_VSENSOR05_BYPASS_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR05_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR05_BYPASS_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR05_BYPASS_SHIFT))

#define  AIB_EXTRA_LOGIC_VSENSOR05_V18EN_MASK 0x1
#define  AIB_EXTRA_LOGIC_VSENSOR05_V18EN_SHIFT 0
#define  AIB_EXTRA_LOGIC_VSENSOR05_V18EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_VSENSOR05_V18EN_MASK) >> AIB_EXTRA_LOGIC_VSENSOR05_V18EN_SHIFT)
#define  AIB_EXTRA_LOGIC_VSENSOR05_V18EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_VSENSOR05_V18EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_VSENSOR05_V18EN_SHIFT))

//====================================================================
//Register: Calibration Pad Enable Register (CAL_EN)
/** \brief Calibration pad enable and feed back register.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_CAL_EN_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_CAL_EN_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_CAL_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_CAL_EN_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_CAL_EN_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_CAL_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_CAL_EN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_CAL_EN_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_N_INC_MASK 0x80
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_N_INC_SHIFT 7
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_N_INC_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_CAL_EN_CAL_N_INC_MASK) >> AIB_EXTRA_LOGIC_CAL_EN_CAL_N_INC_SHIFT)
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_N_INC_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_CAL_EN_CAL_N_INC_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_CAL_EN_CAL_N_INC_SHIFT))

#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_P_INC_MASK 0x40
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_P_INC_SHIFT 6
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_P_INC_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_CAL_EN_CAL_P_INC_MASK) >> AIB_EXTRA_LOGIC_CAL_EN_CAL_P_INC_SHIFT)
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_P_INC_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_CAL_EN_CAL_P_INC_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_CAL_EN_CAL_P_INC_SHIFT))

#define  AIB_EXTRA_LOGIC_CAL_EN_RESERVED2_MASK 0x3c
#define  AIB_EXTRA_LOGIC_CAL_EN_RESERVED2_SHIFT 2
#define  AIB_EXTRA_LOGIC_CAL_EN_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_CAL_EN_RESERVED2_MASK) >> AIB_EXTRA_LOGIC_CAL_EN_RESERVED2_SHIFT)
#define  AIB_EXTRA_LOGIC_CAL_EN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_CAL_EN_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_CAL_EN_RESERVED2_SHIFT))

#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_N_EN_MASK 0x2
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_N_EN_SHIFT 1
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_N_EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_CAL_EN_CAL_N_EN_MASK) >> AIB_EXTRA_LOGIC_CAL_EN_CAL_N_EN_SHIFT)
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_N_EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_CAL_EN_CAL_N_EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_CAL_EN_CAL_N_EN_SHIFT))

#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_P_EN_MASK 0x1
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_P_EN_SHIFT 0
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_P_EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_CAL_EN_CAL_P_EN_MASK) >> AIB_EXTRA_LOGIC_CAL_EN_CAL_P_EN_SHIFT)
#define  AIB_EXTRA_LOGIC_CAL_EN_CAL_P_EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_CAL_EN_CAL_P_EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_CAL_EN_CAL_P_EN_SHIFT))

//====================================================================
//Register: Calibration Pad On Die Resistor Control Register (CAL_ODR)
/** \brief Calibration pad enable and feed back register.Register controls weather ODR is enabled and which value to use.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_CAL_ODR_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_CAL_ODR_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_CAL_ODR_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_CAL_ODR_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_CAL_ODR_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_CAL_ODR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_CAL_ODR_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_CAL_ODR_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_CAL_ODR_ODR_EN_MASK 0x80
#define  AIB_EXTRA_LOGIC_CAL_ODR_ODR_EN_SHIFT 7
#define  AIB_EXTRA_LOGIC_CAL_ODR_ODR_EN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_CAL_ODR_ODR_EN_MASK) >> AIB_EXTRA_LOGIC_CAL_ODR_ODR_EN_SHIFT)
#define  AIB_EXTRA_LOGIC_CAL_ODR_ODR_EN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_CAL_ODR_ODR_EN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_CAL_ODR_ODR_EN_SHIFT))

#define  AIB_EXTRA_LOGIC_CAL_ODR_RESERVED2_MASK 0x78
#define  AIB_EXTRA_LOGIC_CAL_ODR_RESERVED2_SHIFT 3
#define  AIB_EXTRA_LOGIC_CAL_ODR_RESERVED2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_CAL_ODR_RESERVED2_MASK) >> AIB_EXTRA_LOGIC_CAL_ODR_RESERVED2_SHIFT)
#define  AIB_EXTRA_LOGIC_CAL_ODR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_CAL_ODR_RESERVED2_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_CAL_ODR_RESERVED2_SHIFT))

#define  AIB_EXTRA_LOGIC_CAL_ODR_ODR_MASK 0x7
#define  AIB_EXTRA_LOGIC_CAL_ODR_ODR_SHIFT 0
#define  AIB_EXTRA_LOGIC_CAL_ODR_ODR_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_CAL_ODR_ODR_MASK) >> AIB_EXTRA_LOGIC_CAL_ODR_ODR_SHIFT)
#define  AIB_EXTRA_LOGIC_CAL_ODR_ODR_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_CAL_ODR_ODR_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_CAL_ODR_ODR_SHIFT))

//====================================================================
//Register: ZN Calibration Value Register (ZN)
/** \brief ZN ADJUSTvalue.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_ZN_RESERVED1_MASK 0xfffffff0
#define  AIB_EXTRA_LOGIC_ZN_RESERVED1_SHIFT 4
#define  AIB_EXTRA_LOGIC_ZN_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_ZN_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_ZN_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_ZN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_ZN_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_ZN_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_ZN_ZN_MASK 0xf
#define  AIB_EXTRA_LOGIC_ZN_ZN_SHIFT 0
#define  AIB_EXTRA_LOGIC_ZN_ZN_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_ZN_ZN_MASK) >> AIB_EXTRA_LOGIC_ZN_ZN_SHIFT)
#define  AIB_EXTRA_LOGIC_ZN_ZN_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_ZN_ZN_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_ZN_ZN_SHIFT))

//====================================================================
//Register: ZP Calibration Value Register (ZP)
/** \brief ZP ADJUST value.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_ZP_RESERVED1_MASK 0xfffffff0
#define  AIB_EXTRA_LOGIC_ZP_RESERVED1_SHIFT 4
#define  AIB_EXTRA_LOGIC_ZP_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_ZP_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_ZP_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_ZP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_ZP_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_ZP_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_ZP_ZP_MASK 0xf
#define  AIB_EXTRA_LOGIC_ZP_ZP_SHIFT 0
#define  AIB_EXTRA_LOGIC_ZP_ZP_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_ZP_ZP_MASK) >> AIB_EXTRA_LOGIC_ZP_ZP_SHIFT)
#define  AIB_EXTRA_LOGIC_ZP_ZP_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_ZP_ZP_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_ZP_ZP_SHIFT))

//====================================================================
//Register: ZP Calibration Setting After Cal. Register (ZP_AFT_CAL)
/** \brief Calibrated ZP value.*/
//====================================================================

#define  AIB_EXTRA_LOGIC_ZP_AFT_CAL_RESERVED1_MASK 0xfffffff0
#define  AIB_EXTRA_LOGIC_ZP_AFT_CAL_RESERVED1_SHIFT 4
#define  AIB_EXTRA_LOGIC_ZP_AFT_CAL_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_ZP_AFT_CAL_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_ZP_AFT_CAL_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_ZP_AFT_CAL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_ZP_AFT_CAL_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_ZP_AFT_CAL_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_ZP_AFT_CAL_ZP_AFT_CAL_MASK 0xf
#define  AIB_EXTRA_LOGIC_ZP_AFT_CAL_ZP_AFT_CAL_SHIFT 0
#define  AIB_EXTRA_LOGIC_ZP_AFT_CAL_ZP_AFT_CAL_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_ZP_AFT_CAL_ZP_AFT_CAL_MASK) >> AIB_EXTRA_LOGIC_ZP_AFT_CAL_ZP_AFT_CAL_SHIFT)
#define  AIB_EXTRA_LOGIC_ZP_AFT_CAL_ZP_AFT_CAL_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_ZP_AFT_CAL_ZP_AFT_CAL_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_ZP_AFT_CAL_ZP_AFT_CAL_SHIFT))

//====================================================================
//Register: SPARE 0 Register (SPARE0)
/** \brief This is an 8 bit spare register that F/W can use as scratchpad area*/
//====================================================================

#define  AIB_EXTRA_LOGIC_SPARE0_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_SPARE0_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_SPARE0_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_SPARE0_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_SPARE0_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_SPARE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_SPARE0_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_SPARE0_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_SPARE0_SPARE0_MASK 0xff
#define  AIB_EXTRA_LOGIC_SPARE0_SPARE0_SHIFT 0
#define  AIB_EXTRA_LOGIC_SPARE0_SPARE0_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_SPARE0_SPARE0_MASK) >> AIB_EXTRA_LOGIC_SPARE0_SPARE0_SHIFT)
#define  AIB_EXTRA_LOGIC_SPARE0_SPARE0_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_SPARE0_SPARE0_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_SPARE0_SPARE0_SHIFT))

//====================================================================
//Register: SPARE 1 Register (SPARE1)
/** \brief This is an 8 bit spare register that F/W can use as scratchpad area*/
//====================================================================

#define  AIB_EXTRA_LOGIC_SPARE1_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_SPARE1_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_SPARE1_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_SPARE1_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_SPARE1_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_SPARE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_SPARE1_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_SPARE1_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_SPARE1_SPARE1_MASK 0xff
#define  AIB_EXTRA_LOGIC_SPARE1_SPARE1_SHIFT 0
#define  AIB_EXTRA_LOGIC_SPARE1_SPARE1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_SPARE1_SPARE1_MASK) >> AIB_EXTRA_LOGIC_SPARE1_SPARE1_SHIFT)
#define  AIB_EXTRA_LOGIC_SPARE1_SPARE1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_SPARE1_SPARE1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_SPARE1_SPARE1_SHIFT))

//====================================================================
//Register: SPARE 2 Register (SPARE2)
/** \brief This is an 8 bit spare register that F/W can use as scratchpad area*/
//====================================================================

#define  AIB_EXTRA_LOGIC_SPARE2_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_SPARE2_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_SPARE2_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_SPARE2_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_SPARE2_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_SPARE2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_SPARE2_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_SPARE2_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_SPARE2_SPARE2_MASK 0xff
#define  AIB_EXTRA_LOGIC_SPARE2_SPARE2_SHIFT 0
#define  AIB_EXTRA_LOGIC_SPARE2_SPARE2_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_SPARE2_SPARE2_MASK) >> AIB_EXTRA_LOGIC_SPARE2_SPARE2_SHIFT)
#define  AIB_EXTRA_LOGIC_SPARE2_SPARE2_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_SPARE2_SPARE2_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_SPARE2_SPARE2_SHIFT))

//====================================================================
//Register: SPARE 3 Register (SPARE3)
/** \brief This is an 8 bit spare register that F/W can use as scratchpad area*/
//====================================================================

#define  AIB_EXTRA_LOGIC_SPARE3_RESERVED1_MASK 0xffffff00
#define  AIB_EXTRA_LOGIC_SPARE3_RESERVED1_SHIFT 8
#define  AIB_EXTRA_LOGIC_SPARE3_RESERVED1_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_SPARE3_RESERVED1_MASK) >> AIB_EXTRA_LOGIC_SPARE3_RESERVED1_SHIFT)
#define  AIB_EXTRA_LOGIC_SPARE3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_SPARE3_RESERVED1_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_SPARE3_RESERVED1_SHIFT))

#define  AIB_EXTRA_LOGIC_SPARE3_SPARE3_MASK 0xff
#define  AIB_EXTRA_LOGIC_SPARE3_SPARE3_SHIFT 0
#define  AIB_EXTRA_LOGIC_SPARE3_SPARE3_MASK_SHIFT(reg) (((reg) & AIB_EXTRA_LOGIC_SPARE3_SPARE3_MASK) >> AIB_EXTRA_LOGIC_SPARE3_SPARE3_SHIFT)
#define  AIB_EXTRA_LOGIC_SPARE3_SPARE3_REPLACE_VAL(reg,val) (((reg) & ~AIB_EXTRA_LOGIC_SPARE3_SPARE3_MASK) | (((uint32_t)val) << AIB_EXTRA_LOGIC_SPARE3_SPARE3_SHIFT))

#endif // AIB_EXTRA_LOGIC
