 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file Zx_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _ZX_REGSTRUCTS_H_
#define _ZX_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Zx Register Set (Zx)
/** \brief Top-level register file for Zx*/
//
//====================================================================

typedef struct ZX_REGS_s
{
  volatile uint32_t ZCR;  ///< 0x0 [R/W]: Zx Configuration Register
  volatile uint32_t ZSR;  ///< 0x4 [R]: Zx Status Register
  volatile uint32_t ZIER;  ///< 0x8 [R/W]: Zx Interrupt Enable Register
  volatile uint32_t ZIPR;  ///< 0xc [R]: Zx Interrupt Pending Register
  volatile uint32_t ZIAR;  ///< 0x10 [R]: Zx Interrupt Active Register
  volatile uint32_t ZICR;  ///< 0x14 [W]: Zx Interrupt Clear Register
  volatile uint32_t ZIFR;  ///< 0x18 [W]: Zx Interrupt Force Register
  volatile uint32_t ZDWR;  ///< 0x1c [W]: Zx Descriptor Write Register
  volatile uint32_t ZDRR;  ///< 0x20 [R]: Zx Descriptor Read Register
  volatile uint32_t ZLLR;  ///< 0x24 [R/W]: Zx Line Length Register
  volatile uint32_t ZBPR;  ///< 0x28 [R]: Zx Bytes Processed Register
  volatile uint32_t ZCSR;  ///< 0x2c [R]: Zx Cmd Source Register
  volatile uint32_t ZCBR;  ///< 0x30 [R]: Zx Cmd Bytes Register
  volatile uint32_t ZPSR;  ///< 0x34 [R]: Zx Pix Source Register
  volatile uint32_t reserved0;
  volatile uint32_t ZIHR;  ///< 0x3c [R/W]: Zx Image Height Register
  volatile uint32_t ZMHR;  ///< 0x40 [R/W]: Zx Merge High Threshold Register
  volatile uint32_t ZMLR;  ///< 0x44 [R/W]: Zx Merge Low Threshold Register
} ZX_REGS_t;

#endif // ZX
