 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file Zx_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _ZX_REGMASKS_H_
#define _ZX_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Zx Register Set (Zx)
/** \brief Top-level register file for Zx*/
//
//====================================================================

//====================================================================
//Register: Zx Configuration Register (ZCR)
/** \brief Register used to configure various aspects of the Zx block.*/
//====================================================================

#define  ZX_ZCR_RESERVED1_MASK 0xff000000
#define  ZX_ZCR_RESERVED1_SHIFT 24
#define  ZX_ZCR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZCR_RESERVED1_MASK) >> ZX_ZCR_RESERVED1_SHIFT)
#define  ZX_ZCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZCR_RESERVED1_SHIFT))

#define  ZX_ZCR_OUTSEL3_MASK 0xc00000
#define  ZX_ZCR_OUTSEL3_SHIFT 22
#define  ZX_ZCR_OUTSEL3_MASK_SHIFT(reg) (((reg) & ZX_ZCR_OUTSEL3_MASK) >> ZX_ZCR_OUTSEL3_SHIFT)
#define  ZX_ZCR_OUTSEL3_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_OUTSEL3_MASK) | (((uint32_t)val) << ZX_ZCR_OUTSEL3_SHIFT))

#define  ZX_ZCR_OUTSEL2_MASK 0x300000
#define  ZX_ZCR_OUTSEL2_SHIFT 20
#define  ZX_ZCR_OUTSEL2_MASK_SHIFT(reg) (((reg) & ZX_ZCR_OUTSEL2_MASK) >> ZX_ZCR_OUTSEL2_SHIFT)
#define  ZX_ZCR_OUTSEL2_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_OUTSEL2_MASK) | (((uint32_t)val) << ZX_ZCR_OUTSEL2_SHIFT))

#define  ZX_ZCR_OUTSEL1_MASK 0xc0000
#define  ZX_ZCR_OUTSEL1_SHIFT 18
#define  ZX_ZCR_OUTSEL1_MASK_SHIFT(reg) (((reg) & ZX_ZCR_OUTSEL1_MASK) >> ZX_ZCR_OUTSEL1_SHIFT)
#define  ZX_ZCR_OUTSEL1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_OUTSEL1_MASK) | (((uint32_t)val) << ZX_ZCR_OUTSEL1_SHIFT))

#define  ZX_ZCR_OUTSEL0_MASK 0x30000
#define  ZX_ZCR_OUTSEL0_SHIFT 16
#define  ZX_ZCR_OUTSEL0_MASK_SHIFT(reg) (((reg) & ZX_ZCR_OUTSEL0_MASK) >> ZX_ZCR_OUTSEL0_SHIFT)
#define  ZX_ZCR_OUTSEL0_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_OUTSEL0_MASK) | (((uint32_t)val) << ZX_ZCR_OUTSEL0_SHIFT))

#define  ZX_ZCR_RESERVED2_MASK 0x8000
#define  ZX_ZCR_RESERVED2_SHIFT 15
#define  ZX_ZCR_RESERVED2_MASK_SHIFT(reg) (((reg) & ZX_ZCR_RESERVED2_MASK) >> ZX_ZCR_RESERVED2_SHIFT)
#define  ZX_ZCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_RESERVED2_MASK) | (((uint32_t)val) << ZX_ZCR_RESERVED2_SHIFT))

#define  ZX_ZCR_HANDSHAKEEN_MASK 0x4000
#define  ZX_ZCR_HANDSHAKEEN_SHIFT 14
#define  ZX_ZCR_HANDSHAKEEN_MASK_SHIFT(reg) (((reg) & ZX_ZCR_HANDSHAKEEN_MASK) >> ZX_ZCR_HANDSHAKEEN_SHIFT)
#define  ZX_ZCR_HANDSHAKEEN_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_HANDSHAKEEN_MASK) | (((uint32_t)val) << ZX_ZCR_HANDSHAKEEN_SHIFT))

#define  ZX_ZCR_COLORMODE_MASK 0x2000
#define  ZX_ZCR_COLORMODE_SHIFT 13
#define  ZX_ZCR_COLORMODE_MASK_SHIFT(reg) (((reg) & ZX_ZCR_COLORMODE_MASK) >> ZX_ZCR_COLORMODE_SHIFT)
#define  ZX_ZCR_COLORMODE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_COLORMODE_MASK) | (((uint32_t)val) << ZX_ZCR_COLORMODE_SHIFT))

#define  ZX_ZCR_MERGEMODE_MASK 0x1800
#define  ZX_ZCR_MERGEMODE_SHIFT 11
#define  ZX_ZCR_MERGEMODE_MASK_SHIFT(reg) (((reg) & ZX_ZCR_MERGEMODE_MASK) >> ZX_ZCR_MERGEMODE_SHIFT)
#define  ZX_ZCR_MERGEMODE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_MERGEMODE_MASK) | (((uint32_t)val) << ZX_ZCR_MERGEMODE_SHIFT))

#define  ZX_ZCR_THRESHMODE_MASK 0x400
#define  ZX_ZCR_THRESHMODE_SHIFT 10
#define  ZX_ZCR_THRESHMODE_MASK_SHIFT(reg) (((reg) & ZX_ZCR_THRESHMODE_MASK) >> ZX_ZCR_THRESHMODE_SHIFT)
#define  ZX_ZCR_THRESHMODE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_THRESHMODE_MASK) | (((uint32_t)val) << ZX_ZCR_THRESHMODE_SHIFT))

#define  ZX_ZCR_RESERVED3_MASK 0x300
#define  ZX_ZCR_RESERVED3_SHIFT 8
#define  ZX_ZCR_RESERVED3_MASK_SHIFT(reg) (((reg) & ZX_ZCR_RESERVED3_MASK) >> ZX_ZCR_RESERVED3_SHIFT)
#define  ZX_ZCR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_RESERVED3_MASK) | (((uint32_t)val) << ZX_ZCR_RESERVED3_SHIFT))

#define  ZX_ZCR_STOPONEOI_MASK 0x80
#define  ZX_ZCR_STOPONEOI_SHIFT 7
#define  ZX_ZCR_STOPONEOI_MASK_SHIFT(reg) (((reg) & ZX_ZCR_STOPONEOI_MASK) >> ZX_ZCR_STOPONEOI_SHIFT)
#define  ZX_ZCR_STOPONEOI_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_STOPONEOI_MASK) | (((uint32_t)val) << ZX_ZCR_STOPONEOI_SHIFT))

#define  ZX_ZCR_RESERVED4_MASK 0x70
#define  ZX_ZCR_RESERVED4_SHIFT 4
#define  ZX_ZCR_RESERVED4_MASK_SHIFT(reg) (((reg) & ZX_ZCR_RESERVED4_MASK) >> ZX_ZCR_RESERVED4_SHIFT)
#define  ZX_ZCR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_RESERVED4_MASK) | (((uint32_t)val) << ZX_ZCR_RESERVED4_SHIFT))

#define  ZX_ZCR_BURSTLENGTH_MASK 0x8
#define  ZX_ZCR_BURSTLENGTH_SHIFT 3
#define  ZX_ZCR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & ZX_ZCR_BURSTLENGTH_MASK) >> ZX_ZCR_BURSTLENGTH_SHIFT)
#define  ZX_ZCR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_BURSTLENGTH_MASK) | (((uint32_t)val) << ZX_ZCR_BURSTLENGTH_SHIFT))

#define  ZX_ZCR_RESERVED5_MASK 0x4
#define  ZX_ZCR_RESERVED5_SHIFT 2
#define  ZX_ZCR_RESERVED5_MASK_SHIFT(reg) (((reg) & ZX_ZCR_RESERVED5_MASK) >> ZX_ZCR_RESERVED5_SHIFT)
#define  ZX_ZCR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_RESERVED5_MASK) | (((uint32_t)val) << ZX_ZCR_RESERVED5_SHIFT))

#define  ZX_ZCR_ENABLELCM_MASK 0x2
#define  ZX_ZCR_ENABLELCM_SHIFT 1
#define  ZX_ZCR_ENABLELCM_MASK_SHIFT(reg) (((reg) & ZX_ZCR_ENABLELCM_MASK) >> ZX_ZCR_ENABLELCM_SHIFT)
#define  ZX_ZCR_ENABLELCM_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_ENABLELCM_MASK) | (((uint32_t)val) << ZX_ZCR_ENABLELCM_SHIFT))

#define  ZX_ZCR_ENABLE_MASK 0x1
#define  ZX_ZCR_ENABLE_SHIFT 0
#define  ZX_ZCR_ENABLE_MASK_SHIFT(reg) (((reg) & ZX_ZCR_ENABLE_MASK) >> ZX_ZCR_ENABLE_SHIFT)
#define  ZX_ZCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCR_ENABLE_MASK) | (((uint32_t)val) << ZX_ZCR_ENABLE_SHIFT))

//====================================================================
//Register: Zx Status Register (ZSR)
/** \brief This register contains status bits used for development and debug*/
//====================================================================

#define  ZX_ZSR_RESERVED1_MASK 0xff000000
#define  ZX_ZSR_RESERVED1_SHIFT 24
#define  ZX_ZSR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZSR_RESERVED1_MASK) >> ZX_ZSR_RESERVED1_SHIFT)
#define  ZX_ZSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZSR_RESERVED1_SHIFT))

#define  ZX_ZSR_ERRORCODE_MASK 0xff0000
#define  ZX_ZSR_ERRORCODE_SHIFT 16
#define  ZX_ZSR_ERRORCODE_MASK_SHIFT(reg) (((reg) & ZX_ZSR_ERRORCODE_MASK) >> ZX_ZSR_ERRORCODE_SHIFT)
#define  ZX_ZSR_ERRORCODE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_ERRORCODE_MASK) | (((uint32_t)val) << ZX_ZSR_ERRORCODE_SHIFT))

#define  ZX_ZSR_RESERVED2_MASK 0x8000
#define  ZX_ZSR_RESERVED2_SHIFT 15
#define  ZX_ZSR_RESERVED2_MASK_SHIFT(reg) (((reg) & ZX_ZSR_RESERVED2_MASK) >> ZX_ZSR_RESERVED2_SHIFT)
#define  ZX_ZSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_RESERVED2_MASK) | (((uint32_t)val) << ZX_ZSR_RESERVED2_SHIFT))

#define  ZX_ZSR_OUTMODE_MASK 0x6000
#define  ZX_ZSR_OUTMODE_SHIFT 13
#define  ZX_ZSR_OUTMODE_MASK_SHIFT(reg) (((reg) & ZX_ZSR_OUTMODE_MASK) >> ZX_ZSR_OUTMODE_SHIFT)
#define  ZX_ZSR_OUTMODE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_OUTMODE_MASK) | (((uint32_t)val) << ZX_ZSR_OUTMODE_SHIFT))

#define  ZX_ZSR_OUTHALT_MASK 0x1000
#define  ZX_ZSR_OUTHALT_SHIFT 12
#define  ZX_ZSR_OUTHALT_MASK_SHIFT(reg) (((reg) & ZX_ZSR_OUTHALT_MASK) >> ZX_ZSR_OUTHALT_SHIFT)
#define  ZX_ZSR_OUTHALT_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_OUTHALT_MASK) | (((uint32_t)val) << ZX_ZSR_OUTHALT_SHIFT))

#define  ZX_ZSR_PARTIALCMD_MASK 0x800
#define  ZX_ZSR_PARTIALCMD_SHIFT 11
#define  ZX_ZSR_PARTIALCMD_MASK_SHIFT(reg) (((reg) & ZX_ZSR_PARTIALCMD_MASK) >> ZX_ZSR_PARTIALCMD_SHIFT)
#define  ZX_ZSR_PARTIALCMD_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_PARTIALCMD_MASK) | (((uint32_t)val) << ZX_ZSR_PARTIALCMD_SHIFT))

#define  ZX_ZSR_PIXDMABUSY_MASK 0x400
#define  ZX_ZSR_PIXDMABUSY_SHIFT 10
#define  ZX_ZSR_PIXDMABUSY_MASK_SHIFT(reg) (((reg) & ZX_ZSR_PIXDMABUSY_MASK) >> ZX_ZSR_PIXDMABUSY_SHIFT)
#define  ZX_ZSR_PIXDMABUSY_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_PIXDMABUSY_MASK) | (((uint32_t)val) << ZX_ZSR_PIXDMABUSY_SHIFT))

#define  ZX_ZSR_ZXDMABUSY_MASK 0x200
#define  ZX_ZSR_ZXDMABUSY_SHIFT 9
#define  ZX_ZSR_ZXDMABUSY_MASK_SHIFT(reg) (((reg) & ZX_ZSR_ZXDMABUSY_MASK) >> ZX_ZSR_ZXDMABUSY_SHIFT)
#define  ZX_ZSR_ZXDMABUSY_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_ZXDMABUSY_MASK) | (((uint32_t)val) << ZX_ZSR_ZXDMABUSY_SHIFT))

#define  ZX_ZSR_RESERVED3_MASK 0x100
#define  ZX_ZSR_RESERVED3_SHIFT 8
#define  ZX_ZSR_RESERVED3_MASK_SHIFT(reg) (((reg) & ZX_ZSR_RESERVED3_MASK) >> ZX_ZSR_RESERVED3_SHIFT)
#define  ZX_ZSR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_RESERVED3_MASK) | (((uint32_t)val) << ZX_ZSR_RESERVED3_SHIFT))

#define  ZX_ZSR_PIXBUFFULL_MASK 0x80
#define  ZX_ZSR_PIXBUFFULL_SHIFT 7
#define  ZX_ZSR_PIXBUFFULL_MASK_SHIFT(reg) (((reg) & ZX_ZSR_PIXBUFFULL_MASK) >> ZX_ZSR_PIXBUFFULL_SHIFT)
#define  ZX_ZSR_PIXBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_PIXBUFFULL_MASK) | (((uint32_t)val) << ZX_ZSR_PIXBUFFULL_SHIFT))

#define  ZX_ZSR_PIXBUFEMPTY_MASK 0x40
#define  ZX_ZSR_PIXBUFEMPTY_SHIFT 6
#define  ZX_ZSR_PIXBUFEMPTY_MASK_SHIFT(reg) (((reg) & ZX_ZSR_PIXBUFEMPTY_MASK) >> ZX_ZSR_PIXBUFEMPTY_SHIFT)
#define  ZX_ZSR_PIXBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_PIXBUFEMPTY_MASK) | (((uint32_t)val) << ZX_ZSR_PIXBUFEMPTY_SHIFT))

#define  ZX_ZSR_ZXBUFFULL_MASK 0x20
#define  ZX_ZSR_ZXBUFFULL_SHIFT 5
#define  ZX_ZSR_ZXBUFFULL_MASK_SHIFT(reg) (((reg) & ZX_ZSR_ZXBUFFULL_MASK) >> ZX_ZSR_ZXBUFFULL_SHIFT)
#define  ZX_ZSR_ZXBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_ZXBUFFULL_MASK) | (((uint32_t)val) << ZX_ZSR_ZXBUFFULL_SHIFT))

#define  ZX_ZSR_ZXBUFEMPTY_MASK 0x10
#define  ZX_ZSR_ZXBUFEMPTY_SHIFT 4
#define  ZX_ZSR_ZXBUFEMPTY_MASK_SHIFT(reg) (((reg) & ZX_ZSR_ZXBUFEMPTY_MASK) >> ZX_ZSR_ZXBUFEMPTY_SHIFT)
#define  ZX_ZSR_ZXBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_ZXBUFEMPTY_MASK) | (((uint32_t)val) << ZX_ZSR_ZXBUFEMPTY_SHIFT))

#define  ZX_ZSR_RESERVED4_MASK 0x8
#define  ZX_ZSR_RESERVED4_SHIFT 3
#define  ZX_ZSR_RESERVED4_MASK_SHIFT(reg) (((reg) & ZX_ZSR_RESERVED4_MASK) >> ZX_ZSR_RESERVED4_SHIFT)
#define  ZX_ZSR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_RESERVED4_MASK) | (((uint32_t)val) << ZX_ZSR_RESERVED4_SHIFT))

#define  ZX_ZSR_DMAPAUSED_MASK 0x4
#define  ZX_ZSR_DMAPAUSED_SHIFT 2
#define  ZX_ZSR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & ZX_ZSR_DMAPAUSED_MASK) >> ZX_ZSR_DMAPAUSED_SHIFT)
#define  ZX_ZSR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_DMAPAUSED_MASK) | (((uint32_t)val) << ZX_ZSR_DMAPAUSED_SHIFT))

#define  ZX_ZSR_PAUSEAFTER_MASK 0x2
#define  ZX_ZSR_PAUSEAFTER_SHIFT 1
#define  ZX_ZSR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & ZX_ZSR_PAUSEAFTER_MASK) >> ZX_ZSR_PAUSEAFTER_SHIFT)
#define  ZX_ZSR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_PAUSEAFTER_MASK) | (((uint32_t)val) << ZX_ZSR_PAUSEAFTER_SHIFT))

#define  ZX_ZSR_PAUSEBEFORE_MASK 0x1
#define  ZX_ZSR_PAUSEBEFORE_SHIFT 0
#define  ZX_ZSR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & ZX_ZSR_PAUSEBEFORE_MASK) >> ZX_ZSR_PAUSEBEFORE_SHIFT)
#define  ZX_ZSR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZSR_PAUSEBEFORE_MASK) | (((uint32_t)val) << ZX_ZSR_PAUSEBEFORE_SHIFT))

//====================================================================
//Register: Zx Interrupt Enable Register (ZIER)
/** \brief This register contains individual enable bits for each interrupt cause*/
//====================================================================

#define  ZX_ZIER_RESERVED1_MASK 0xffffffe0
#define  ZX_ZIER_RESERVED1_SHIFT 5
#define  ZX_ZIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZIER_RESERVED1_MASK) >> ZX_ZIER_RESERVED1_SHIFT)
#define  ZX_ZIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIER_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZIER_RESERVED1_SHIFT))

#define  ZX_ZIER_ENDOFIMAGE_MASK 0x10
#define  ZX_ZIER_ENDOFIMAGE_SHIFT 4
#define  ZX_ZIER_ENDOFIMAGE_MASK_SHIFT(reg) (((reg) & ZX_ZIER_ENDOFIMAGE_MASK) >> ZX_ZIER_ENDOFIMAGE_SHIFT)
#define  ZX_ZIER_ENDOFIMAGE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIER_ENDOFIMAGE_MASK) | (((uint32_t)val) << ZX_ZIER_ENDOFIMAGE_SHIFT))

#define  ZX_ZIER_CLEARCOMPLETE_MASK 0x8
#define  ZX_ZIER_CLEARCOMPLETE_SHIFT 3
#define  ZX_ZIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ZX_ZIER_CLEARCOMPLETE_MASK) >> ZX_ZIER_CLEARCOMPLETE_SHIFT)
#define  ZX_ZIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ZX_ZIER_CLEARCOMPLETE_SHIFT))

#define  ZX_ZIER_ILLEGALCMD_MASK 0x4
#define  ZX_ZIER_ILLEGALCMD_SHIFT 2
#define  ZX_ZIER_ILLEGALCMD_MASK_SHIFT(reg) (((reg) & ZX_ZIER_ILLEGALCMD_MASK) >> ZX_ZIER_ILLEGALCMD_SHIFT)
#define  ZX_ZIER_ILLEGALCMD_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIER_ILLEGALCMD_MASK) | (((uint32_t)val) << ZX_ZIER_ILLEGALCMD_SHIFT))

#define  ZX_ZIER_DESC_MASK 0x2
#define  ZX_ZIER_DESC_SHIFT 1
#define  ZX_ZIER_DESC_MASK_SHIFT(reg) (((reg) & ZX_ZIER_DESC_MASK) >> ZX_ZIER_DESC_SHIFT)
#define  ZX_ZIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIER_DESC_MASK) | (((uint32_t)val) << ZX_ZIER_DESC_SHIFT))

#define  ZX_ZIER_OWN_MASK 0x1
#define  ZX_ZIER_OWN_SHIFT 0
#define  ZX_ZIER_OWN_MASK_SHIFT(reg) (((reg) & ZX_ZIER_OWN_MASK) >> ZX_ZIER_OWN_SHIFT)
#define  ZX_ZIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIER_OWN_MASK) | (((uint32_t)val) << ZX_ZIER_OWN_SHIFT))

//====================================================================
//Register: Zx Interrupt Pending Register (ZIPR)
/** \brief This register contains individual pending bits for each interrupt cause*/
//====================================================================

#define  ZX_ZIPR_RESERVED1_MASK 0xffffffe0
#define  ZX_ZIPR_RESERVED1_SHIFT 5
#define  ZX_ZIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZIPR_RESERVED1_MASK) >> ZX_ZIPR_RESERVED1_SHIFT)
#define  ZX_ZIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIPR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZIPR_RESERVED1_SHIFT))

#define  ZX_ZIPR_ENDOFIMAGE_MASK 0x10
#define  ZX_ZIPR_ENDOFIMAGE_SHIFT 4
#define  ZX_ZIPR_ENDOFIMAGE_MASK_SHIFT(reg) (((reg) & ZX_ZIPR_ENDOFIMAGE_MASK) >> ZX_ZIPR_ENDOFIMAGE_SHIFT)
#define  ZX_ZIPR_ENDOFIMAGE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIPR_ENDOFIMAGE_MASK) | (((uint32_t)val) << ZX_ZIPR_ENDOFIMAGE_SHIFT))

#define  ZX_ZIPR_CLEARCOMPLETE_MASK 0x8
#define  ZX_ZIPR_CLEARCOMPLETE_SHIFT 3
#define  ZX_ZIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ZX_ZIPR_CLEARCOMPLETE_MASK) >> ZX_ZIPR_CLEARCOMPLETE_SHIFT)
#define  ZX_ZIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ZX_ZIPR_CLEARCOMPLETE_SHIFT))

#define  ZX_ZIPR_ILLEGALCMD_MASK 0x4
#define  ZX_ZIPR_ILLEGALCMD_SHIFT 2
#define  ZX_ZIPR_ILLEGALCMD_MASK_SHIFT(reg) (((reg) & ZX_ZIPR_ILLEGALCMD_MASK) >> ZX_ZIPR_ILLEGALCMD_SHIFT)
#define  ZX_ZIPR_ILLEGALCMD_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIPR_ILLEGALCMD_MASK) | (((uint32_t)val) << ZX_ZIPR_ILLEGALCMD_SHIFT))

#define  ZX_ZIPR_DESC_MASK 0x2
#define  ZX_ZIPR_DESC_SHIFT 1
#define  ZX_ZIPR_DESC_MASK_SHIFT(reg) (((reg) & ZX_ZIPR_DESC_MASK) >> ZX_ZIPR_DESC_SHIFT)
#define  ZX_ZIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIPR_DESC_MASK) | (((uint32_t)val) << ZX_ZIPR_DESC_SHIFT))

#define  ZX_ZIPR_OWN_MASK 0x1
#define  ZX_ZIPR_OWN_SHIFT 0
#define  ZX_ZIPR_OWN_MASK_SHIFT(reg) (((reg) & ZX_ZIPR_OWN_MASK) >> ZX_ZIPR_OWN_SHIFT)
#define  ZX_ZIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIPR_OWN_MASK) | (((uint32_t)val) << ZX_ZIPR_OWN_SHIFT))

//====================================================================
//Register: Zx Interrupt Active Register (ZIAR)
/** \brief This register contains individual active bits for each interrupt cause*/
//====================================================================

#define  ZX_ZIAR_RESERVED1_MASK 0xffffffe0
#define  ZX_ZIAR_RESERVED1_SHIFT 5
#define  ZX_ZIAR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZIAR_RESERVED1_MASK) >> ZX_ZIAR_RESERVED1_SHIFT)
#define  ZX_ZIAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIAR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZIAR_RESERVED1_SHIFT))

#define  ZX_ZIAR_ENDOFIMAGE_MASK 0x10
#define  ZX_ZIAR_ENDOFIMAGE_SHIFT 4
#define  ZX_ZIAR_ENDOFIMAGE_MASK_SHIFT(reg) (((reg) & ZX_ZIAR_ENDOFIMAGE_MASK) >> ZX_ZIAR_ENDOFIMAGE_SHIFT)
#define  ZX_ZIAR_ENDOFIMAGE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIAR_ENDOFIMAGE_MASK) | (((uint32_t)val) << ZX_ZIAR_ENDOFIMAGE_SHIFT))

#define  ZX_ZIAR_CLEARCOMPLETE_MASK 0x8
#define  ZX_ZIAR_CLEARCOMPLETE_SHIFT 3
#define  ZX_ZIAR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ZX_ZIAR_CLEARCOMPLETE_MASK) >> ZX_ZIAR_CLEARCOMPLETE_SHIFT)
#define  ZX_ZIAR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIAR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ZX_ZIAR_CLEARCOMPLETE_SHIFT))

#define  ZX_ZIAR_ILLEGALCMD_MASK 0x4
#define  ZX_ZIAR_ILLEGALCMD_SHIFT 2
#define  ZX_ZIAR_ILLEGALCMD_MASK_SHIFT(reg) (((reg) & ZX_ZIAR_ILLEGALCMD_MASK) >> ZX_ZIAR_ILLEGALCMD_SHIFT)
#define  ZX_ZIAR_ILLEGALCMD_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIAR_ILLEGALCMD_MASK) | (((uint32_t)val) << ZX_ZIAR_ILLEGALCMD_SHIFT))

#define  ZX_ZIAR_DESC_MASK 0x2
#define  ZX_ZIAR_DESC_SHIFT 1
#define  ZX_ZIAR_DESC_MASK_SHIFT(reg) (((reg) & ZX_ZIAR_DESC_MASK) >> ZX_ZIAR_DESC_SHIFT)
#define  ZX_ZIAR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIAR_DESC_MASK) | (((uint32_t)val) << ZX_ZIAR_DESC_SHIFT))

#define  ZX_ZIAR_OWN_MASK 0x1
#define  ZX_ZIAR_OWN_SHIFT 0
#define  ZX_ZIAR_OWN_MASK_SHIFT(reg) (((reg) & ZX_ZIAR_OWN_MASK) >> ZX_ZIAR_OWN_SHIFT)
#define  ZX_ZIAR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIAR_OWN_MASK) | (((uint32_t)val) << ZX_ZIAR_OWN_SHIFT))

//====================================================================
//Register: Zx Interrupt Clear Register (ZICR)
/** \brief This register contains individual clear bits for each interrupt cause*/
//====================================================================

#define  ZX_ZICR_RESERVED1_MASK 0xffffffe0
#define  ZX_ZICR_RESERVED1_SHIFT 5
#define  ZX_ZICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZICR_RESERVED1_MASK) >> ZX_ZICR_RESERVED1_SHIFT)
#define  ZX_ZICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZICR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZICR_RESERVED1_SHIFT))

#define  ZX_ZICR_ENDOFIMAGE_MASK 0x10
#define  ZX_ZICR_ENDOFIMAGE_SHIFT 4
#define  ZX_ZICR_ENDOFIMAGE_MASK_SHIFT(reg) (((reg) & ZX_ZICR_ENDOFIMAGE_MASK) >> ZX_ZICR_ENDOFIMAGE_SHIFT)
#define  ZX_ZICR_ENDOFIMAGE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZICR_ENDOFIMAGE_MASK) | (((uint32_t)val) << ZX_ZICR_ENDOFIMAGE_SHIFT))

#define  ZX_ZICR_CLEARCOMPLETE_MASK 0x8
#define  ZX_ZICR_CLEARCOMPLETE_SHIFT 3
#define  ZX_ZICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ZX_ZICR_CLEARCOMPLETE_MASK) >> ZX_ZICR_CLEARCOMPLETE_SHIFT)
#define  ZX_ZICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ZX_ZICR_CLEARCOMPLETE_SHIFT))

#define  ZX_ZICR_ILLEGALCMD_MASK 0x4
#define  ZX_ZICR_ILLEGALCMD_SHIFT 2
#define  ZX_ZICR_ILLEGALCMD_MASK_SHIFT(reg) (((reg) & ZX_ZICR_ILLEGALCMD_MASK) >> ZX_ZICR_ILLEGALCMD_SHIFT)
#define  ZX_ZICR_ILLEGALCMD_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZICR_ILLEGALCMD_MASK) | (((uint32_t)val) << ZX_ZICR_ILLEGALCMD_SHIFT))

#define  ZX_ZICR_DESC_MASK 0x2
#define  ZX_ZICR_DESC_SHIFT 1
#define  ZX_ZICR_DESC_MASK_SHIFT(reg) (((reg) & ZX_ZICR_DESC_MASK) >> ZX_ZICR_DESC_SHIFT)
#define  ZX_ZICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZICR_DESC_MASK) | (((uint32_t)val) << ZX_ZICR_DESC_SHIFT))

#define  ZX_ZICR_OWN_MASK 0x1
#define  ZX_ZICR_OWN_SHIFT 0
#define  ZX_ZICR_OWN_MASK_SHIFT(reg) (((reg) & ZX_ZICR_OWN_MASK) >> ZX_ZICR_OWN_SHIFT)
#define  ZX_ZICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZICR_OWN_MASK) | (((uint32_t)val) << ZX_ZICR_OWN_SHIFT))

//====================================================================
//Register: Zx Interrupt Force Register (ZIFR)
/** \brief This register contains individual force bits for each interrupt cause*/
//====================================================================

#define  ZX_ZIFR_RESERVED1_MASK 0xffffffe0
#define  ZX_ZIFR_RESERVED1_SHIFT 5
#define  ZX_ZIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZIFR_RESERVED1_MASK) >> ZX_ZIFR_RESERVED1_SHIFT)
#define  ZX_ZIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIFR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZIFR_RESERVED1_SHIFT))

#define  ZX_ZIFR_ENDOFIMAGE_MASK 0x10
#define  ZX_ZIFR_ENDOFIMAGE_SHIFT 4
#define  ZX_ZIFR_ENDOFIMAGE_MASK_SHIFT(reg) (((reg) & ZX_ZIFR_ENDOFIMAGE_MASK) >> ZX_ZIFR_ENDOFIMAGE_SHIFT)
#define  ZX_ZIFR_ENDOFIMAGE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIFR_ENDOFIMAGE_MASK) | (((uint32_t)val) << ZX_ZIFR_ENDOFIMAGE_SHIFT))

#define  ZX_ZIFR_CLEARCOMPLETE_MASK 0x8
#define  ZX_ZIFR_CLEARCOMPLETE_SHIFT 3
#define  ZX_ZIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ZX_ZIFR_CLEARCOMPLETE_MASK) >> ZX_ZIFR_CLEARCOMPLETE_SHIFT)
#define  ZX_ZIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ZX_ZIFR_CLEARCOMPLETE_SHIFT))

#define  ZX_ZIFR_ILLEGALCMD_MASK 0x4
#define  ZX_ZIFR_ILLEGALCMD_SHIFT 2
#define  ZX_ZIFR_ILLEGALCMD_MASK_SHIFT(reg) (((reg) & ZX_ZIFR_ILLEGALCMD_MASK) >> ZX_ZIFR_ILLEGALCMD_SHIFT)
#define  ZX_ZIFR_ILLEGALCMD_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIFR_ILLEGALCMD_MASK) | (((uint32_t)val) << ZX_ZIFR_ILLEGALCMD_SHIFT))

#define  ZX_ZIFR_DESC_MASK 0x2
#define  ZX_ZIFR_DESC_SHIFT 1
#define  ZX_ZIFR_DESC_MASK_SHIFT(reg) (((reg) & ZX_ZIFR_DESC_MASK) >> ZX_ZIFR_DESC_SHIFT)
#define  ZX_ZIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIFR_DESC_MASK) | (((uint32_t)val) << ZX_ZIFR_DESC_SHIFT))

#define  ZX_ZIFR_OWN_MASK 0x1
#define  ZX_ZIFR_OWN_SHIFT 0
#define  ZX_ZIFR_OWN_MASK_SHIFT(reg) (((reg) & ZX_ZIFR_OWN_MASK) >> ZX_ZIFR_OWN_SHIFT)
#define  ZX_ZIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIFR_OWN_MASK) | (((uint32_t)val) << ZX_ZIFR_OWN_SHIFT))

//====================================================================
//Register: Zx Descriptor Write Register (ZDWR)
/** \brief Write descriptor and start DMA*/
//====================================================================

#define  ZX_ZDWR_DESC_MASK 0xfffffff0
#define  ZX_ZDWR_DESC_SHIFT 4
#define  ZX_ZDWR_DESC_MASK_SHIFT(reg) (((reg) & ZX_ZDWR_DESC_MASK) >> ZX_ZDWR_DESC_SHIFT)
#define  ZX_ZDWR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZDWR_DESC_MASK) | (((uint32_t)val) << ZX_ZDWR_DESC_SHIFT))

#define  ZX_ZDWR_RESERVED1_MASK 0xf
#define  ZX_ZDWR_RESERVED1_SHIFT 0
#define  ZX_ZDWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZDWR_RESERVED1_MASK) >> ZX_ZDWR_RESERVED1_SHIFT)
#define  ZX_ZDWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZDWR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZDWR_RESERVED1_SHIFT))

//====================================================================
//Register: Zx Descriptor Read Register (ZDRR)
/** \brief Current descriptor location*/
//====================================================================

#define  ZX_ZDRR_DESC_MASK 0xffffffff
#define  ZX_ZDRR_DESC_SHIFT 0
#define  ZX_ZDRR_DESC_MASK_SHIFT(reg) (((reg) & ZX_ZDRR_DESC_MASK) >> ZX_ZDRR_DESC_SHIFT)
#define  ZX_ZDRR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZDRR_DESC_MASK) | (((uint32_t)val) << ZX_ZDRR_DESC_SHIFT))

//====================================================================
//Register: Zx Line Length Register (ZLLR)
//====================================================================

#define  ZX_ZLLR_RESERVED1_MASK 0xffff0000
#define  ZX_ZLLR_RESERVED1_SHIFT 16
#define  ZX_ZLLR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZLLR_RESERVED1_MASK) >> ZX_ZLLR_RESERVED1_SHIFT)
#define  ZX_ZLLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZLLR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZLLR_RESERVED1_SHIFT))

#define  ZX_ZLLR_LINELENGTH_MASK 0xffff
#define  ZX_ZLLR_LINELENGTH_SHIFT 0
#define  ZX_ZLLR_LINELENGTH_MASK_SHIFT(reg) (((reg) & ZX_ZLLR_LINELENGTH_MASK) >> ZX_ZLLR_LINELENGTH_SHIFT)
#define  ZX_ZLLR_LINELENGTH_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZLLR_LINELENGTH_MASK) | (((uint32_t)val) << ZX_ZLLR_LINELENGTH_SHIFT))

//====================================================================
//Register: Zx Bytes Processed Register (ZBPR)
//====================================================================

#define  ZX_ZBPR_BYTESPROCESSED_MASK 0xffffffff
#define  ZX_ZBPR_BYTESPROCESSED_SHIFT 0
#define  ZX_ZBPR_BYTESPROCESSED_MASK_SHIFT(reg) (((reg) & ZX_ZBPR_BYTESPROCESSED_MASK) >> ZX_ZBPR_BYTESPROCESSED_SHIFT)
#define  ZX_ZBPR_BYTESPROCESSED_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZBPR_BYTESPROCESSED_MASK) | (((uint32_t)val) << ZX_ZBPR_BYTESPROCESSED_SHIFT))

//====================================================================
//Register: Zx Cmd Source Register (ZCSR)
//====================================================================

#define  ZX_ZCSR_SOURCE_MASK 0xffffffff
#define  ZX_ZCSR_SOURCE_SHIFT 0
#define  ZX_ZCSR_SOURCE_MASK_SHIFT(reg) (((reg) & ZX_ZCSR_SOURCE_MASK) >> ZX_ZCSR_SOURCE_SHIFT)
#define  ZX_ZCSR_SOURCE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCSR_SOURCE_MASK) | (((uint32_t)val) << ZX_ZCSR_SOURCE_SHIFT))

//====================================================================
//Register: Zx Cmd Bytes Register (ZCBR)
//====================================================================

#define  ZX_ZCBR_RESERVED1_MASK 0xff000000
#define  ZX_ZCBR_RESERVED1_SHIFT 24
#define  ZX_ZCBR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZCBR_RESERVED1_MASK) >> ZX_ZCBR_RESERVED1_SHIFT)
#define  ZX_ZCBR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCBR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZCBR_RESERVED1_SHIFT))

#define  ZX_ZCBR_BYTES_MASK 0xffffff
#define  ZX_ZCBR_BYTES_SHIFT 0
#define  ZX_ZCBR_BYTES_MASK_SHIFT(reg) (((reg) & ZX_ZCBR_BYTES_MASK) >> ZX_ZCBR_BYTES_SHIFT)
#define  ZX_ZCBR_BYTES_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZCBR_BYTES_MASK) | (((uint32_t)val) << ZX_ZCBR_BYTES_SHIFT))

//====================================================================
//Register: Zx Pix Source Register (ZPSR)
//====================================================================

#define  ZX_ZPSR_SOURCE_MASK 0xffffffff
#define  ZX_ZPSR_SOURCE_SHIFT 0
#define  ZX_ZPSR_SOURCE_MASK_SHIFT(reg) (((reg) & ZX_ZPSR_SOURCE_MASK) >> ZX_ZPSR_SOURCE_SHIFT)
#define  ZX_ZPSR_SOURCE_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZPSR_SOURCE_MASK) | (((uint32_t)val) << ZX_ZPSR_SOURCE_SHIFT))

//====================================================================
//Register: Zx Image Height Register (ZIHR)
//====================================================================

#define  ZX_ZIHR_RESERVED1_MASK 0xffff0000
#define  ZX_ZIHR_RESERVED1_SHIFT 16
#define  ZX_ZIHR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZIHR_RESERVED1_MASK) >> ZX_ZIHR_RESERVED1_SHIFT)
#define  ZX_ZIHR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIHR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZIHR_RESERVED1_SHIFT))

#define  ZX_ZIHR_IMAGEHEIGHT_MASK 0xffff
#define  ZX_ZIHR_IMAGEHEIGHT_SHIFT 0
#define  ZX_ZIHR_IMAGEHEIGHT_MASK_SHIFT(reg) (((reg) & ZX_ZIHR_IMAGEHEIGHT_MASK) >> ZX_ZIHR_IMAGEHEIGHT_SHIFT)
#define  ZX_ZIHR_IMAGEHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZIHR_IMAGEHEIGHT_MASK) | (((uint32_t)val) << ZX_ZIHR_IMAGEHEIGHT_SHIFT))

//====================================================================
//Register: Zx Merge High Threshold Register (ZMHR)
//====================================================================

#define  ZX_ZMHR_COLOR0_MASK 0xff000000
#define  ZX_ZMHR_COLOR0_SHIFT 24
#define  ZX_ZMHR_COLOR0_MASK_SHIFT(reg) (((reg) & ZX_ZMHR_COLOR0_MASK) >> ZX_ZMHR_COLOR0_SHIFT)
#define  ZX_ZMHR_COLOR0_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZMHR_COLOR0_MASK) | (((uint32_t)val) << ZX_ZMHR_COLOR0_SHIFT))

#define  ZX_ZMHR_COLOR1_MASK 0xff0000
#define  ZX_ZMHR_COLOR1_SHIFT 16
#define  ZX_ZMHR_COLOR1_MASK_SHIFT(reg) (((reg) & ZX_ZMHR_COLOR1_MASK) >> ZX_ZMHR_COLOR1_SHIFT)
#define  ZX_ZMHR_COLOR1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZMHR_COLOR1_MASK) | (((uint32_t)val) << ZX_ZMHR_COLOR1_SHIFT))

#define  ZX_ZMHR_COLOR2_MASK 0xff00
#define  ZX_ZMHR_COLOR2_SHIFT 8
#define  ZX_ZMHR_COLOR2_MASK_SHIFT(reg) (((reg) & ZX_ZMHR_COLOR2_MASK) >> ZX_ZMHR_COLOR2_SHIFT)
#define  ZX_ZMHR_COLOR2_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZMHR_COLOR2_MASK) | (((uint32_t)val) << ZX_ZMHR_COLOR2_SHIFT))

#define  ZX_ZMHR_RESERVED1_MASK 0xff
#define  ZX_ZMHR_RESERVED1_SHIFT 0
#define  ZX_ZMHR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZMHR_RESERVED1_MASK) >> ZX_ZMHR_RESERVED1_SHIFT)
#define  ZX_ZMHR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZMHR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZMHR_RESERVED1_SHIFT))

//====================================================================
//Register: Zx Merge Low Threshold Register (ZMLR)
//====================================================================

#define  ZX_ZMLR_COLOR0_MASK 0xff000000
#define  ZX_ZMLR_COLOR0_SHIFT 24
#define  ZX_ZMLR_COLOR0_MASK_SHIFT(reg) (((reg) & ZX_ZMLR_COLOR0_MASK) >> ZX_ZMLR_COLOR0_SHIFT)
#define  ZX_ZMLR_COLOR0_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZMLR_COLOR0_MASK) | (((uint32_t)val) << ZX_ZMLR_COLOR0_SHIFT))

#define  ZX_ZMLR_COLOR1_MASK 0xff0000
#define  ZX_ZMLR_COLOR1_SHIFT 16
#define  ZX_ZMLR_COLOR1_MASK_SHIFT(reg) (((reg) & ZX_ZMLR_COLOR1_MASK) >> ZX_ZMLR_COLOR1_SHIFT)
#define  ZX_ZMLR_COLOR1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZMLR_COLOR1_MASK) | (((uint32_t)val) << ZX_ZMLR_COLOR1_SHIFT))

#define  ZX_ZMLR_COLOR2_MASK 0xff00
#define  ZX_ZMLR_COLOR2_SHIFT 8
#define  ZX_ZMLR_COLOR2_MASK_SHIFT(reg) (((reg) & ZX_ZMLR_COLOR2_MASK) >> ZX_ZMLR_COLOR2_SHIFT)
#define  ZX_ZMLR_COLOR2_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZMLR_COLOR2_MASK) | (((uint32_t)val) << ZX_ZMLR_COLOR2_SHIFT))

#define  ZX_ZMLR_RESERVED1_MASK 0xff
#define  ZX_ZMLR_RESERVED1_SHIFT 0
#define  ZX_ZMLR_RESERVED1_MASK_SHIFT(reg) (((reg) & ZX_ZMLR_RESERVED1_MASK) >> ZX_ZMLR_RESERVED1_SHIFT)
#define  ZX_ZMLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ZX_ZMLR_RESERVED1_MASK) | (((uint32_t)val) << ZX_ZMLR_RESERVED1_SHIFT))

#endif // ZX
