 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file XYScale_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _XYSCALE_REGMASKS_H_
#define _XYSCALE_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: XYScale (XYScale)
/** \brief Register Descriptions for the PIE XYScale block
    (rev 0 . 3 . 4 . 2)*/
//
//====================================================================

//====================================================================
//Register: Configure X-Y Scale Register (CSR)
/** \brief Bit [8] Switches Algorithms between Running Average Pixel Replication (reset to zero) and
      Linear Mode (set to one).</p>
      Bits [17:16] round up instead of truncate for a potentially closer desired output.
      The round-up bits only work in Running Average Pixel Replication Mode. Bit 16 is used by
      the Y scaler and bit 17 is used by the X scaler. These bits must be set prior to turning
      off Bypass bit 0. Bit 18 was used for rounding in a previous implementation. It is
      unused in this version for backwards compatibility.</p>
      Bypass is ORed into the synchronous reset, and the synchronous reset must be active for
      one clock in order for any reset value to take hold. Therefore, when rounding, two
      sequential writes must be written to the Configuration Register, one with the bits set
      and bypass bit 0 set as well, the second with bypass reset to zero to start functional
      operation.*/
//====================================================================

#define  XYSCALE_CSR_RESERVED1_MASK 0xfff80000
#define  XYSCALE_CSR_RESERVED1_SHIFT 19
#define  XYSCALE_CSR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_RESERVED1_MASK) >> XYSCALE_CSR_RESERVED1_SHIFT)
#define  XYSCALE_CSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CSR_RESERVED1_SHIFT))

#define  XYSCALE_CSR_RU_MASK 0x70000
#define  XYSCALE_CSR_RU_SHIFT 16
#define  XYSCALE_CSR_RU_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_RU_MASK) >> XYSCALE_CSR_RU_SHIFT)
#define  XYSCALE_CSR_RU_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_RU_MASK) | (((uint32_t)val) << XYSCALE_CSR_RU_SHIFT))

#define  XYSCALE_CSR_RESERVED2_MASK 0xfe00
#define  XYSCALE_CSR_RESERVED2_SHIFT 9
#define  XYSCALE_CSR_RESERVED2_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_RESERVED2_MASK) >> XYSCALE_CSR_RESERVED2_SHIFT)
#define  XYSCALE_CSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_RESERVED2_MASK) | (((uint32_t)val) << XYSCALE_CSR_RESERVED2_SHIFT))

#define  XYSCALE_CSR_LM_MASK 0x100
#define  XYSCALE_CSR_LM_SHIFT 8
#define  XYSCALE_CSR_LM_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_LM_MASK) >> XYSCALE_CSR_LM_SHIFT)
#define  XYSCALE_CSR_LM_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_LM_MASK) | (((uint32_t)val) << XYSCALE_CSR_LM_SHIFT))

#define  XYSCALE_CSR_RESERVED3_MASK 0xfe
#define  XYSCALE_CSR_RESERVED3_SHIFT 1
#define  XYSCALE_CSR_RESERVED3_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_RESERVED3_MASK) >> XYSCALE_CSR_RESERVED3_SHIFT)
#define  XYSCALE_CSR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_RESERVED3_MASK) | (((uint32_t)val) << XYSCALE_CSR_RESERVED3_SHIFT))

#define  XYSCALE_CSR_B_MASK 0x1
#define  XYSCALE_CSR_B_SHIFT 0
#define  XYSCALE_CSR_B_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_B_MASK) >> XYSCALE_CSR_B_SHIFT)
#define  XYSCALE_CSR_B_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_B_MASK) | (((uint32_t)val) << XYSCALE_CSR_B_SHIFT))

//====================================================================
//Register: Output Strip Column Count Register (CCR)
/** \brief <p>The Output Column Count may also be thought of as the number of x-direction pixels
      in a given output line. This value may exceed the scaled output count of the input pixels
      in which case data padding will be used to make up the difference. In the case where this
      value is less than the scaled output count the output is cut short to this new count. Data
      padding will either use individual fill data as setup in the color X fill data registers
      below, or if the Replicate Mode bit is set, will use the last column data values to pad
      with.</p>
      <p>This replaces a pad count that extends the data size to some optimal DMA sizing,
      and adds the feature of being able to cut short output data. </p>
      <p>Once written, this register will stick through all subsequent strips until
      changed.</p>*/
//====================================================================

#define  XYSCALE_CCR_RESERVED1_MASK 0xfe000000
#define  XYSCALE_CCR_RESERVED1_SHIFT 25
#define  XYSCALE_CCR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CCR_RESERVED1_MASK) >> XYSCALE_CCR_RESERVED1_SHIFT)
#define  XYSCALE_CCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CCR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CCR_RESERVED1_SHIFT))

#define  XYSCALE_CCR_RM_MASK 0x1000000
#define  XYSCALE_CCR_RM_SHIFT 24
#define  XYSCALE_CCR_RM_MASK_SHIFT(reg) (((reg) & XYSCALE_CCR_RM_MASK) >> XYSCALE_CCR_RM_SHIFT)
#define  XYSCALE_CCR_RM_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CCR_RM_MASK) | (((uint32_t)val) << XYSCALE_CCR_RM_SHIFT))

#define  XYSCALE_CCR_RESERVED2_MASK 0xfc0000
#define  XYSCALE_CCR_RESERVED2_SHIFT 18
#define  XYSCALE_CCR_RESERVED2_MASK_SHIFT(reg) (((reg) & XYSCALE_CCR_RESERVED2_MASK) >> XYSCALE_CCR_RESERVED2_SHIFT)
#define  XYSCALE_CCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CCR_RESERVED2_MASK) | (((uint32_t)val) << XYSCALE_CCR_RESERVED2_SHIFT))

#define  XYSCALE_CCR_CC_MASK 0x3ffff
#define  XYSCALE_CCR_CC_SHIFT 0
#define  XYSCALE_CCR_CC_MASK_SHIFT(reg) (((reg) & XYSCALE_CCR_CC_MASK) >> XYSCALE_CCR_CC_SHIFT)
#define  XYSCALE_CCR_CC_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CCR_CC_MASK) | (((uint32_t)val) << XYSCALE_CCR_CC_SHIFT))

//====================================================================
//Register: Color 2 and Color 1 Fill Data Register (CFR1)
//====================================================================

#define  XYSCALE_CFR1_RESERVED1_MASK 0xff000000
#define  XYSCALE_CFR1_RESERVED1_SHIFT 24
#define  XYSCALE_CFR1_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR1_RESERVED1_MASK) >> XYSCALE_CFR1_RESERVED1_SHIFT)
#define  XYSCALE_CFR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR1_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CFR1_RESERVED1_SHIFT))

#define  XYSCALE_CFR1_FILL2_MASK 0xff0000
#define  XYSCALE_CFR1_FILL2_SHIFT 16
#define  XYSCALE_CFR1_FILL2_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR1_FILL2_MASK) >> XYSCALE_CFR1_FILL2_SHIFT)
#define  XYSCALE_CFR1_FILL2_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR1_FILL2_MASK) | (((uint32_t)val) << XYSCALE_CFR1_FILL2_SHIFT))

#define  XYSCALE_CFR1_RESERVED2_MASK 0xff00
#define  XYSCALE_CFR1_RESERVED2_SHIFT 8
#define  XYSCALE_CFR1_RESERVED2_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR1_RESERVED2_MASK) >> XYSCALE_CFR1_RESERVED2_SHIFT)
#define  XYSCALE_CFR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR1_RESERVED2_MASK) | (((uint32_t)val) << XYSCALE_CFR1_RESERVED2_SHIFT))

#define  XYSCALE_CFR1_FILL1_MASK 0xff
#define  XYSCALE_CFR1_FILL1_SHIFT 0
#define  XYSCALE_CFR1_FILL1_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR1_FILL1_MASK) >> XYSCALE_CFR1_FILL1_SHIFT)
#define  XYSCALE_CFR1_FILL1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR1_FILL1_MASK) | (((uint32_t)val) << XYSCALE_CFR1_FILL1_SHIFT))

//====================================================================
//Register: Color 0 Fill Data Register (CFR2)
//====================================================================

#define  XYSCALE_CFR2_RESERVED1_MASK 0xffffff00
#define  XYSCALE_CFR2_RESERVED1_SHIFT 8
#define  XYSCALE_CFR2_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR2_RESERVED1_MASK) >> XYSCALE_CFR2_RESERVED1_SHIFT)
#define  XYSCALE_CFR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR2_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CFR2_RESERVED1_SHIFT))

#define  XYSCALE_CFR2_FILL0_MASK 0xff
#define  XYSCALE_CFR2_FILL0_SHIFT 0
#define  XYSCALE_CFR2_FILL0_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR2_FILL0_MASK) >> XYSCALE_CFR2_FILL0_SHIFT)
#define  XYSCALE_CFR2_FILL0_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR2_FILL0_MASK) | (((uint32_t)val) << XYSCALE_CFR2_FILL0_SHIFT))

//====================================================================
//Register: Horizontal Scale Register (HSR)
/** \brief Scale factor x-direction
      The following table is for reference, loading the scale, transpose and edge count.
      Previous versions of this block also included (X and Y scale - normal) values. This version
      includes these registers for backward firmware compatibility but no longer uses them.
      New firmware driver no longer needs to set the (scale - normal) values.
      <table>
      <th>Hex Program Values</th><th>Mode:</th><th>Running Average Pixel Replication Mode</th><th colspan=4>Bi-Linear Mode</th></tr>
      <tr><td> </td><td>Register:</td><td>(scaleX/Y)</td><td>(scaleX/Y)</td><td>(scaleX/Y)</td><td>(scaleX/YsubN)</td><td>(transposeX/Y)</td></tr>
      <tr><td> </td><td>Bits:</td><td>S: Scale Factor</td><td>S: Scale Factor</td><td>E: Edge pixel count</td><td>S: Scale Factor minus Normal</td><td>Dx/Dy: x/y-direction Delta Initial Value</td></tr>
      <tr><td>Scale</td><td>Percentage</td><td>Hex value</td><td>Hex value</td><td>Hex value</td><td>Hex value</td><td>Hex value</td></tr>
      <tr><td>1x</td><td>100%</td><td>1_0000h</td><td>1_0000h</td><td>0h</td><td>0_0000h</td><td>0_0000h</td></tr>
      <tr><td> </td><td>100.00153%</td><td>1_0001h</td><td>0_FFFFh</td><td>1h</td><td>F_FFFFh</td><td>0_FFFEh</td></tr>
      <tr><td>1.01x</td><td>101%</td><td>1_028Fh</td><td>0_FD77h</td><td>1h</td><td>F_FD77h</td><td>0_FC32h</td></tr>
      <tr><td>1.5x</td><td>150%</td><td>1_8000h</td><td>0_AAAAh</td><td>1h</td><td>F_AAAAh</td><td>0_7FFFh</td></tr>
      <tr><td>2x</td><td>200%</td><td>2_0000h</td><td>0_8000h</td><td>1h</td><td>F_8000h</td><td>0_4000h</td></tr>
      <tr><td>3x</td><td>300%</td><td>3_0000h</td><td>0_5555h</td><td>1h</td><td>F_5555h</td><td>0_0000h</td></tr>
      <tr><td>4x</td><td>400%</td><td>4_0000h</td><td>0_4000h</td><td>2h</td><td>F_4000h</td><td>0_2000h</td></tr>
      <tr><td></td><td>99%</td><td>0_FD70h</td><td>1_0295h</td><td>0h</td><td>0_0295</td><td>0_0014h</td></tr>
      <tr><td></td><td>99.99847%</td><td>0_FFFFh</td><td>1_0001h</td><td>0h</td><td>0_0001h</td><td>0_0000h</td></tr>
      <tr><td>.75x</td><td></td><td>0_C000h</td><td>1_5555h</td><td>0h</td><td>0_5555h</td><td>0_2AAAh</td></tr>
      <tr><td>.5x</td><td>50%</td><td>0_8000h</td><td>2_0000h</td><td>0h</td><td>1_0000h</td><td>0_8000h</td></tr>
      <tr><td>.25x</td><td>25%</td><td>0_4000h</td><td>N/A</td><td>N/A</td><td>N/A</td><td>N/A</td></tr>
      </table>
      <p>Once written, this register will stick through all subsequent strips until changed.
      The edge pixel count is ignored if in Average Pixel Replication mode. The edge pixel count
      is reloaded internally for the first column of each new row. An internal countdown commences
      to zero before the scale gets underway. The pixels are padded with the first input pixel of
      each row.</p>*/
//====================================================================

#define  XYSCALE_HSR_RESERVED1_MASK 0xf0000000
#define  XYSCALE_HSR_RESERVED1_SHIFT 28
#define  XYSCALE_HSR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_HSR_RESERVED1_MASK) >> XYSCALE_HSR_RESERVED1_SHIFT)
#define  XYSCALE_HSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_HSR_RESERVED1_SHIFT))

#define  XYSCALE_HSR_E_MASK 0xf000000
#define  XYSCALE_HSR_E_SHIFT 24
#define  XYSCALE_HSR_E_MASK_SHIFT(reg) (((reg) & XYSCALE_HSR_E_MASK) >> XYSCALE_HSR_E_SHIFT)
#define  XYSCALE_HSR_E_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSR_E_MASK) | (((uint32_t)val) << XYSCALE_HSR_E_SHIFT))

#define  XYSCALE_HSR_RESERVED2_MASK 0xf00000
#define  XYSCALE_HSR_RESERVED2_SHIFT 20
#define  XYSCALE_HSR_RESERVED2_MASK_SHIFT(reg) (((reg) & XYSCALE_HSR_RESERVED2_MASK) >> XYSCALE_HSR_RESERVED2_SHIFT)
#define  XYSCALE_HSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSR_RESERVED2_MASK) | (((uint32_t)val) << XYSCALE_HSR_RESERVED2_SHIFT))

#define  XYSCALE_HSR_S_MASK 0xfffff
#define  XYSCALE_HSR_S_SHIFT 0
#define  XYSCALE_HSR_S_MASK_SHIFT(reg) (((reg) & XYSCALE_HSR_S_MASK) >> XYSCALE_HSR_S_SHIFT)
#define  XYSCALE_HSR_S_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSR_S_MASK) | (((uint32_t)val) << XYSCALE_HSR_S_SHIFT))

//====================================================================
//Register: Vertical Scale Register (VSR)
/** \brief Vertical Scale does not implement the Edge Pixel Pad Option. Instead firmware is required
      to pad the top and bottom of page with extra bits when enlarging an image. The reason for
      any padding is that the bi-linear scale when enlarging will have its output transpose grid
      overlapping the input grid, such that the overlapping output pixels can only reference one
      input pixel and a slope cannot be determined.*/
//====================================================================

#define  XYSCALE_VSR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_VSR_RESERVED1_SHIFT 20
#define  XYSCALE_VSR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_VSR_RESERVED1_MASK) >> XYSCALE_VSR_RESERVED1_SHIFT)
#define  XYSCALE_VSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_VSR_RESERVED1_SHIFT))

#define  XYSCALE_VSR_S_MASK 0xfffff
#define  XYSCALE_VSR_S_SHIFT 0
#define  XYSCALE_VSR_S_MASK_SHIFT(reg) (((reg) & XYSCALE_VSR_S_MASK) >> XYSCALE_VSR_S_SHIFT)
#define  XYSCALE_VSR_S_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSR_S_MASK) | (((uint32_t)val) << XYSCALE_VSR_S_SHIFT))

//====================================================================
//Register: Horizontal Scale Minus Normal Register (HSMR)
/** \brief This register is included for backward compatibility but is not used in this version
      of the XYScale module.</p>
      Scale factor x-direction minus the Normal. Only required for linear mode operation.*/
//====================================================================

#define  XYSCALE_HSMR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_HSMR_RESERVED1_SHIFT 20
#define  XYSCALE_HSMR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_HSMR_RESERVED1_MASK) >> XYSCALE_HSMR_RESERVED1_SHIFT)
#define  XYSCALE_HSMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSMR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_HSMR_RESERVED1_SHIFT))

#define  XYSCALE_HSMR_S_MASK 0xfffff
#define  XYSCALE_HSMR_S_SHIFT 0
#define  XYSCALE_HSMR_S_MASK_SHIFT(reg) (((reg) & XYSCALE_HSMR_S_MASK) >> XYSCALE_HSMR_S_SHIFT)
#define  XYSCALE_HSMR_S_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSMR_S_MASK) | (((uint32_t)val) << XYSCALE_HSMR_S_SHIFT))

//====================================================================
//Register: Vertical Scale Minus Normal Register (VSMR)
/** \brief This register is included for backward compatibility but is not used in this version
      of the XYScale module.</p>
      Scale factor y-direction minus the Normal. Only required for linear mode operation.*/
//====================================================================

#define  XYSCALE_VSMR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_VSMR_RESERVED1_SHIFT 20
#define  XYSCALE_VSMR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_VSMR_RESERVED1_MASK) >> XYSCALE_VSMR_RESERVED1_SHIFT)
#define  XYSCALE_VSMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSMR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_VSMR_RESERVED1_SHIFT))

#define  XYSCALE_VSMR_S_MASK 0xfffff
#define  XYSCALE_VSMR_S_SHIFT 0
#define  XYSCALE_VSMR_S_MASK_SHIFT(reg) (((reg) & XYSCALE_VSMR_S_MASK) >> XYSCALE_VSMR_S_SHIFT)
#define  XYSCALE_VSMR_S_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSMR_S_MASK) | (((uint32_t)val) << XYSCALE_VSMR_S_SHIFT))

//====================================================================
//Register: X-Transpose Configuration Register (XTR)
/** \brief This register in conjunction with the Horizontal Scale register stores configuration
      information beyond scale factors that the X-Y Scale block uses. The Dx calculation
      requires values from the Horizontal Scale register, which should be calculated first.
      Within the block, the Dx value is automatically re-loaded at the beginning of
      each line.*/
//====================================================================

#define  XYSCALE_XTR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_XTR_RESERVED1_SHIFT 20
#define  XYSCALE_XTR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_XTR_RESERVED1_MASK) >> XYSCALE_XTR_RESERVED1_SHIFT)
#define  XYSCALE_XTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_XTR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_XTR_RESERVED1_SHIFT))

#define  XYSCALE_XTR_DX_MASK 0xfffff
#define  XYSCALE_XTR_DX_SHIFT 0
#define  XYSCALE_XTR_DX_MASK_SHIFT(reg) (((reg) & XYSCALE_XTR_DX_MASK) >> XYSCALE_XTR_DX_SHIFT)
#define  XYSCALE_XTR_DX_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_XTR_DX_MASK) | (((uint32_t)val) << XYSCALE_XTR_DX_SHIFT))

//====================================================================
//Register: Y-Transpose Configuration Register (YTR)
/** \brief In linear mode, this register in conjunction with the Vertical Scale register
      stores configuration information beyond scale factors that the X-Y Scale block uses.
      Calculation of Dy requires values from the Vertical Scale register which should be
      calculated first. The Vertical Edge Pixel Count is determined as if it were being
      used. In actuality, FW is padding the top & bottom of strips. Typically, Dy
      is loaded only once for top of page. The transpose in the vertical direction is
      maintained by the Current Y-Start register. The value from the Current Y-Start
      register can be saved when stopping the current image. This register can then
      be initialized to start an alternate image. When returning to the original image
      the value that was saved from the Current Y-Start register should be re-written into
      this register before re-starting the image on the next strip.*/
//====================================================================

#define  XYSCALE_YTR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_YTR_RESERVED1_SHIFT 20
#define  XYSCALE_YTR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_YTR_RESERVED1_MASK) >> XYSCALE_YTR_RESERVED1_SHIFT)
#define  XYSCALE_YTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_YTR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_YTR_RESERVED1_SHIFT))

#define  XYSCALE_YTR_DY_MASK 0xfffff
#define  XYSCALE_YTR_DY_SHIFT 0
#define  XYSCALE_YTR_DY_MASK_SHIFT(reg) (((reg) & XYSCALE_YTR_DY_MASK) >> XYSCALE_YTR_DY_SHIFT)
#define  XYSCALE_YTR_DY_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_YTR_DY_MASK) | (((uint32_t)val) << XYSCALE_YTR_DY_SHIFT))

//====================================================================
//Register: Current X-Start Register (CXR)
/** \brief This register allows read access of the current internal start Dx register. The initial
      value comes from the X-Transpose Register and can be read back as such during page
      initialization.*/
//====================================================================

#define  XYSCALE_CXR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_CXR_RESERVED1_SHIFT 20
#define  XYSCALE_CXR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CXR_RESERVED1_MASK) >> XYSCALE_CXR_RESERVED1_SHIFT)
#define  XYSCALE_CXR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CXR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CXR_RESERVED1_SHIFT))

#define  XYSCALE_CXR_DX_MASK 0xfffff
#define  XYSCALE_CXR_DX_SHIFT 0
#define  XYSCALE_CXR_DX_MASK_SHIFT(reg) (((reg) & XYSCALE_CXR_DX_MASK) >> XYSCALE_CXR_DX_SHIFT)
#define  XYSCALE_CXR_DX_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CXR_DX_MASK) | (((uint32_t)val) << XYSCALE_CXR_DX_SHIFT))

//====================================================================
//Register: Current Y Transpose Register (CYR)
/** \brief In linear mode, this register allows read access of the current internal Dy register. The
      initial value comes from the Y-Transpose Register and can be read back as such during page
      initialization. When switching between images, the value of this register should be read and
      saved before starting the other image, and then the saved value should be written to the
      Y-Transpose Register before resuming the original image.*/
//====================================================================

#define  XYSCALE_CYR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_CYR_RESERVED1_SHIFT 20
#define  XYSCALE_CYR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CYR_RESERVED1_MASK) >> XYSCALE_CYR_RESERVED1_SHIFT)
#define  XYSCALE_CYR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CYR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CYR_RESERVED1_SHIFT))

#define  XYSCALE_CYR_DY_MASK 0xfffff
#define  XYSCALE_CYR_DY_SHIFT 0
#define  XYSCALE_CYR_DY_MASK_SHIFT(reg) (((reg) & XYSCALE_CYR_DY_MASK) >> XYSCALE_CYR_DY_SHIFT)
#define  XYSCALE_CYR_DY_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CYR_DY_MASK) | (((uint32_t)val) << XYSCALE_CYR_DY_SHIFT))

//====================================================================
//Register: Vertical Start Percentage (VSPR)
/** \brief For RAPR mode, at the beginning of an image this register should be initialized to the
      normal or 2^16 (10000h). When switching between images, the value from the VCPR should be
      saved off before starting the new image. When retuning to the original image the saved value
      should be written back into this register.*/
//====================================================================

#define  XYSCALE_VSPR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_VSPR_RESERVED1_SHIFT 20
#define  XYSCALE_VSPR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_VSPR_RESERVED1_MASK) >> XYSCALE_VSPR_RESERVED1_SHIFT)
#define  XYSCALE_VSPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSPR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_VSPR_RESERVED1_SHIFT))

#define  XYSCALE_VSPR_P_MASK 0xfffff
#define  XYSCALE_VSPR_P_SHIFT 0
#define  XYSCALE_VSPR_P_MASK_SHIFT(reg) (((reg) & XYSCALE_VSPR_P_MASK) >> XYSCALE_VSPR_P_SHIFT)
#define  XYSCALE_VSPR_P_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSPR_P_MASK) | (((uint32_t)val) << XYSCALE_VSPR_P_SHIFT))

//====================================================================
//Register: Horizontal Current/End Percentage Register (HCPR)
/** \brief In RAPR mode, the first column of each strip starts with a percentage of the normal or 2^16
      (1000h), and has a running percentage as the X-Y Scale traverses horizontally. This register
      allows looking at the current (or ending) percentage. The normal is re-loaded once the column
      count has been met. This is for debug purposes only.*/
//====================================================================

#define  XYSCALE_HCPR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_HCPR_RESERVED1_SHIFT 20
#define  XYSCALE_HCPR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_HCPR_RESERVED1_MASK) >> XYSCALE_HCPR_RESERVED1_SHIFT)
#define  XYSCALE_HCPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HCPR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_HCPR_RESERVED1_SHIFT))

#define  XYSCALE_HCPR_P_MASK 0xfffff
#define  XYSCALE_HCPR_P_SHIFT 0
#define  XYSCALE_HCPR_P_MASK_SHIFT(reg) (((reg) & XYSCALE_HCPR_P_MASK) >> XYSCALE_HCPR_P_SHIFT)
#define  XYSCALE_HCPR_P_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HCPR_P_MASK) | (((uint32_t)val) << XYSCALE_HCPR_P_SHIFT))

//====================================================================
//Register: Vertical Current/End Percentage Register (VCPR)
/** \brief In RAPR mode, this register tracks the vertical percentage while traversing pixels in a
      column. This register is read only, and may be used to save off the current percentage at
      the end of a strip before switching to a different image. This saved-off value can then be
      written into the VSPR register when re-starting the original image.*/
//====================================================================

#define  XYSCALE_VCPR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_VCPR_RESERVED1_SHIFT 20
#define  XYSCALE_VCPR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_VCPR_RESERVED1_MASK) >> XYSCALE_VCPR_RESERVED1_SHIFT)
#define  XYSCALE_VCPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VCPR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_VCPR_RESERVED1_SHIFT))

#define  XYSCALE_VCPR_P_MASK 0xfffff
#define  XYSCALE_VCPR_P_SHIFT 0
#define  XYSCALE_VCPR_P_MASK_SHIFT(reg) (((reg) & XYSCALE_VCPR_P_MASK) >> XYSCALE_VCPR_P_SHIFT)
#define  XYSCALE_VCPR_P_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VCPR_P_MASK) | (((uint32_t)val) << XYSCALE_VCPR_P_SHIFT))

//====================================================================
//Register: Observation Register (XOR)
/** \brief This register is included for backward compatibility but is not used in this version
      of the XYScale module. Fields are no longer valid and all reads will return 0</p>
      This read only register is for observation of certain XYScale internals.*/
//====================================================================

#define  XYSCALE_XOR_RESERVED1_MASK 0xffffffff
#define  XYSCALE_XOR_RESERVED1_SHIFT 0
#define  XYSCALE_XOR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_XOR_RESERVED1_MASK) >> XYSCALE_XOR_RESERVED1_SHIFT)
#define  XYSCALE_XOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_XOR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_XOR_RESERVED1_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  XYSCALE_REV0_MAJ_MASK 0xffff0000
#define  XYSCALE_REV0_MAJ_SHIFT 16
#define  XYSCALE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & XYSCALE_REV0_MAJ_MASK) >> XYSCALE_REV0_MAJ_SHIFT)
#define  XYSCALE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_REV0_MAJ_MASK) | (((uint32_t)val) << XYSCALE_REV0_MAJ_SHIFT))

#define  XYSCALE_REV0_MID_MASK 0xffff
#define  XYSCALE_REV0_MID_SHIFT 0
#define  XYSCALE_REV0_MID_MASK_SHIFT(reg) (((reg) & XYSCALE_REV0_MID_MASK) >> XYSCALE_REV0_MID_SHIFT)
#define  XYSCALE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_REV0_MID_MASK) | (((uint32_t)val) << XYSCALE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  XYSCALE_REV1_RESERVED1_MASK 0xffff0000
#define  XYSCALE_REV1_RESERVED1_SHIFT 16
#define  XYSCALE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_REV1_RESERVED1_MASK) >> XYSCALE_REV1_RESERVED1_SHIFT)
#define  XYSCALE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_REV1_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_REV1_RESERVED1_SHIFT))

#define  XYSCALE_REV1_CFG_MASK 0xffff
#define  XYSCALE_REV1_CFG_SHIFT 0
#define  XYSCALE_REV1_CFG_MASK_SHIFT(reg) (((reg) & XYSCALE_REV1_CFG_MASK) >> XYSCALE_REV1_CFG_SHIFT)
#define  XYSCALE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_REV1_CFG_MASK) | (((uint32_t)val) << XYSCALE_REV1_CFG_SHIFT))

#endif // XYSCALE
