 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file WaveGenLUT_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _WAVEGEN_LUT_REGSTRUCTS_H_
#define _WAVEGEN_LUT_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Waveform Generator block registers (WaveGen_LUT)
/** \brief The following registers are used to configure the Waveform Generator (WaveGen) block. The WaveGen output will be low-pass filtered by an external RC circuit to produce a DC voltage. <br/>
    Please note that the intended use of the WaveGen block in Delta-Sigma mode is to generate precise DC voltages that would be unobtainable with a PWM. Delta-Sigma mode (default) should not be used to generate fixed-frequency squarewaves. This is because, due to the nature of Delta-Sigma Modulators, different duty cycles produce different output frequencies.*/
//
//====================================================================

typedef struct WAVEGEN_LUT_REGS_s
{
  volatile uint32_t REV0;  ///< 0x0 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4 [R]: IP Tagging Revision 1
  volatile uint32_t WCR;  ///< 0x8 [R/W]: WCR : WaveGen Configuration Register
  volatile uint32_t WTR;  ///< 0xc [R/W]: WTR : WaveGen Timestep Register
  volatile uint32_t WSLR;  ///< 0x10 [R/W]: WSLR : WaveGen Segment Length Register
  volatile uint32_t WOSR;  ///< 0x14 [R]: WOSR : WaveGen Output Status Register
  volatile uint32_t reserved0[2];
  volatile uint32_t WGLUT0;  ///< 0x20 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 1 of 64)
  volatile uint32_t WGLUT1;  ///< 0x24 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 2 of 64)
  volatile uint32_t WGLUT2;  ///< 0x28 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 3 of 64)
  volatile uint32_t WGLUT3;  ///< 0x2c [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 4 of 64)
  volatile uint32_t WGLUT4;  ///< 0x30 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 5 of 64)
  volatile uint32_t WGLUT5;  ///< 0x34 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 6 of 64)
  volatile uint32_t WGLUT6;  ///< 0x38 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 7 of 64)
  volatile uint32_t WGLUT7;  ///< 0x3c [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 8 of 64)
  volatile uint32_t WGLUT8;  ///< 0x40 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 9 of 64)
  volatile uint32_t WGLUT9;  ///< 0x44 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 10 of 64)
  volatile uint32_t WGLUT10;  ///< 0x48 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 11 of 64)
  volatile uint32_t WGLUT11;  ///< 0x4c [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 12 of 64)
  volatile uint32_t WGLUT12;  ///< 0x50 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 13 of 64)
  volatile uint32_t WGLUT13;  ///< 0x54 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 14 of 64)
  volatile uint32_t WGLUT14;  ///< 0x58 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 15 of 64)
  volatile uint32_t WGLUT15;  ///< 0x5c [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 16 of 64)
  volatile uint32_t WGLUT16;  ///< 0x60 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 17 of 64)
  volatile uint32_t WGLUT17;  ///< 0x64 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 18 of 64)
  volatile uint32_t WGLUT18;  ///< 0x68 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 19 of 64)
  volatile uint32_t WGLUT19;  ///< 0x6c [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 20 of 64)
  volatile uint32_t WGLUT20;  ///< 0x70 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 21 of 64)
  volatile uint32_t WGLUT21;  ///< 0x74 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 22 of 64)
  volatile uint32_t WGLUT22;  ///< 0x78 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 23 of 64)
  volatile uint32_t WGLUT23;  ///< 0x7c [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 24 of 64)
  volatile uint32_t WGLUT24;  ///< 0x80 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 25 of 64)
  volatile uint32_t WGLUT25;  ///< 0x84 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 26 of 64)
  volatile uint32_t WGLUT26;  ///< 0x88 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 27 of 64)
  volatile uint32_t WGLUT27;  ///< 0x8c [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 28 of 64)
  volatile uint32_t WGLUT28;  ///< 0x90 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 29 of 64)
  volatile uint32_t WGLUT29;  ///< 0x94 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 30 of 64)
  volatile uint32_t WGLUT30;  ///< 0x98 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 31 of 64)
  volatile uint32_t WGLUT31;  ///< 0x9c [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 32 of 64)
  volatile uint32_t WGLUT32;  ///< 0xa0 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 33 of 64)
  volatile uint32_t WGLUT33;  ///< 0xa4 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 34 of 64)
  volatile uint32_t WGLUT34;  ///< 0xa8 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 35 of 64)
  volatile uint32_t WGLUT35;  ///< 0xac [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 36 of 64)
  volatile uint32_t WGLUT36;  ///< 0xb0 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 37 of 64)
  volatile uint32_t WGLUT37;  ///< 0xb4 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 38 of 64)
  volatile uint32_t WGLUT38;  ///< 0xb8 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 39 of 64)
  volatile uint32_t WGLUT39;  ///< 0xbc [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 40 of 64)
  volatile uint32_t WGLUT40;  ///< 0xc0 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 41 of 64)
  volatile uint32_t WGLUT41;  ///< 0xc4 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 42 of 64)
  volatile uint32_t WGLUT42;  ///< 0xc8 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 43 of 64)
  volatile uint32_t WGLUT43;  ///< 0xcc [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 44 of 64)
  volatile uint32_t WGLUT44;  ///< 0xd0 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 45 of 64)
  volatile uint32_t WGLUT45;  ///< 0xd4 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 46 of 64)
  volatile uint32_t WGLUT46;  ///< 0xd8 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 47 of 64)
  volatile uint32_t WGLUT47;  ///< 0xdc [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 48 of 64)
  volatile uint32_t WGLUT48;  ///< 0xe0 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 49 of 64)
  volatile uint32_t WGLUT49;  ///< 0xe4 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 50 of 64)
  volatile uint32_t WGLUT50;  ///< 0xe8 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 51 of 64)
  volatile uint32_t WGLUT51;  ///< 0xec [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 52 of 64)
  volatile uint32_t WGLUT52;  ///< 0xf0 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 53 of 64)
  volatile uint32_t WGLUT53;  ///< 0xf4 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 54 of 64)
  volatile uint32_t WGLUT54;  ///< 0xf8 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 55 of 64)
  volatile uint32_t WGLUT55;  ///< 0xfc [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 56 of 64)
  volatile uint32_t WGLUT56;  ///< 0x100 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 57 of 64)
  volatile uint32_t WGLUT57;  ///< 0x104 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 58 of 64)
  volatile uint32_t WGLUT58;  ///< 0x108 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 59 of 64)
  volatile uint32_t WGLUT59;  ///< 0x10c [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 60 of 64)
  volatile uint32_t WGLUT60;  ///< 0x110 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 61 of 64)
  volatile uint32_t WGLUT61;  ///< 0x114 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 62 of 64)
  volatile uint32_t WGLUT62;  ///< 0x118 [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 63 of 64)
  volatile uint32_t WGLUT63;  ///< 0x11c [R/W]: WGLUTx : WaveGen DAC Input LUT (Instance 64 of 64)
} WAVEGEN_LUT_REGS_t;

#endif // WAVEGEN_LUT
