 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file VCAP_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _VCAP_REGSTRUCTS_H_
#define _VCAP_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: VCAP (VCAP)
/** \brief Top-level register file for the VCAP (Camera Capture) block
(rev 0 . 1 . 0 . 1)*/
//
//====================================================================

typedef struct VCAP_REGS_s
{
  volatile uint32_t rb4VCapControl;  ///< 0x0 [R/W]: VCap Control Register
  volatile uint32_t rb4VCapCounter;  ///< 0x4 [W]: VCap Counter Register
  volatile uint32_t rb4VCapCounterObs;  ///< 0x8 [R]: VCap Counter Observation Register
  volatile uint32_t rb4VCapPixelObs;  ///< 0xc [R]: VCap Pixel Observation Register
  volatile uint32_t rb4VCapLineCount;  ///< 0x10 [W]: VCap Line Count Register
  volatile uint32_t rb4VCapLineCountObs;  ///< 0x14 [R]: VCap Line Count Observation Register
  volatile uint32_t rb4VCapIrqEnb;  ///< 0x18 [R/W]: VCap IRQ Enable Register
  volatile uint32_t rb4VCapIrqPnd;  ///< 0x1c [R]: VCap IRQ Pending Register
  volatile uint32_t rb4VCapIrqAck;  ///< 0x20 [W]: VCap IRQ Acknowledge Register
  volatile uint32_t rb4VCapIrqForce;  ///< 0x24 [W]: VCap IRQ Force Register
  volatile uint32_t rb4VCapClk;  ///< 0x28 [R/W]: VCAP Clock Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} VCAP_REGS_t;

#endif // VCAP
