 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file VCAP_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _VCAP_REGMASKS_H_
#define _VCAP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: VCAP (VCAP)
/** \brief Top-level register file for the VCAP (Camera Capture) block
(rev 0 . 1 . 0 . 1)*/
//
//====================================================================

//====================================================================
//Register: VCap Control Register (rb4VCapControl)
/** \brief This register contains control bits for the VCap Camera Capture block.*/
//====================================================================

#define  VCAP_RB4VCAPCONTROL_RESERVED1_MASK 0xffe00000
#define  VCAP_RB4VCAPCONTROL_RESERVED1_SHIFT 21
#define  VCAP_RB4VCAPCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_RESERVED1_MASK) >> VCAP_RB4VCAPCONTROL_RESERVED1_SHIFT)
#define  VCAP_RB4VCAPCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_RESERVED1_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_RESERVED1_SHIFT))

#define  VCAP_RB4VCAPCONTROL_LINE_IMG_CNT_MASK_EN_MASK 0x100000
#define  VCAP_RB4VCAPCONTROL_LINE_IMG_CNT_MASK_EN_SHIFT 20
#define  VCAP_RB4VCAPCONTROL_LINE_IMG_CNT_MASK_EN_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_LINE_IMG_CNT_MASK_EN_MASK) >> VCAP_RB4VCAPCONTROL_LINE_IMG_CNT_MASK_EN_SHIFT)
#define  VCAP_RB4VCAPCONTROL_LINE_IMG_CNT_MASK_EN_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_LINE_IMG_CNT_MASK_EN_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_LINE_IMG_CNT_MASK_EN_SHIFT))

#define  VCAP_RB4VCAPCONTROL_PXL_LINE_CNT_MASK_EN_MASK 0x80000
#define  VCAP_RB4VCAPCONTROL_PXL_LINE_CNT_MASK_EN_SHIFT 19
#define  VCAP_RB4VCAPCONTROL_PXL_LINE_CNT_MASK_EN_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_PXL_LINE_CNT_MASK_EN_MASK) >> VCAP_RB4VCAPCONTROL_PXL_LINE_CNT_MASK_EN_SHIFT)
#define  VCAP_RB4VCAPCONTROL_PXL_LINE_CNT_MASK_EN_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_PXL_LINE_CNT_MASK_EN_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_PXL_LINE_CNT_MASK_EN_SHIFT))

#define  VCAP_RB4VCAPCONTROL_EOI_EN_MASK 0x40000
#define  VCAP_RB4VCAPCONTROL_EOI_EN_SHIFT 18
#define  VCAP_RB4VCAPCONTROL_EOI_EN_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_EOI_EN_MASK) >> VCAP_RB4VCAPCONTROL_EOI_EN_SHIFT)
#define  VCAP_RB4VCAPCONTROL_EOI_EN_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_EOI_EN_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_EOI_EN_SHIFT))

#define  VCAP_RB4VCAPCONTROL_SINGLE_FRAME_MASK 0x20000
#define  VCAP_RB4VCAPCONTROL_SINGLE_FRAME_SHIFT 17
#define  VCAP_RB4VCAPCONTROL_SINGLE_FRAME_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_SINGLE_FRAME_MASK) >> VCAP_RB4VCAPCONTROL_SINGLE_FRAME_SHIFT)
#define  VCAP_RB4VCAPCONTROL_SINGLE_FRAME_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_SINGLE_FRAME_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_SINGLE_FRAME_SHIFT))

#define  VCAP_RB4VCAPCONTROL_NEXT_FRAME_ARM_MASK 0x10000
#define  VCAP_RB4VCAPCONTROL_NEXT_FRAME_ARM_SHIFT 16
#define  VCAP_RB4VCAPCONTROL_NEXT_FRAME_ARM_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_NEXT_FRAME_ARM_MASK) >> VCAP_RB4VCAPCONTROL_NEXT_FRAME_ARM_SHIFT)
#define  VCAP_RB4VCAPCONTROL_NEXT_FRAME_ARM_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_NEXT_FRAME_ARM_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_NEXT_FRAME_ARM_SHIFT))

#define  VCAP_RB4VCAPCONTROL_RISE_EDGE_SAMP_MASK 0x8000
#define  VCAP_RB4VCAPCONTROL_RISE_EDGE_SAMP_SHIFT 15
#define  VCAP_RB4VCAPCONTROL_RISE_EDGE_SAMP_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_RISE_EDGE_SAMP_MASK) >> VCAP_RB4VCAPCONTROL_RISE_EDGE_SAMP_SHIFT)
#define  VCAP_RB4VCAPCONTROL_RISE_EDGE_SAMP_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_RISE_EDGE_SAMP_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_RISE_EDGE_SAMP_SHIFT))

#define  VCAP_RB4VCAPCONTROL_FALL_EDGE_SAMP_MASK 0x4000
#define  VCAP_RB4VCAPCONTROL_FALL_EDGE_SAMP_SHIFT 14
#define  VCAP_RB4VCAPCONTROL_FALL_EDGE_SAMP_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_FALL_EDGE_SAMP_MASK) >> VCAP_RB4VCAPCONTROL_FALL_EDGE_SAMP_SHIFT)
#define  VCAP_RB4VCAPCONTROL_FALL_EDGE_SAMP_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_FALL_EDGE_SAMP_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_FALL_EDGE_SAMP_SHIFT))

#define  VCAP_RB4VCAPCONTROL_FAST_EDGE_MASK 0x2000
#define  VCAP_RB4VCAPCONTROL_FAST_EDGE_SHIFT 13
#define  VCAP_RB4VCAPCONTROL_FAST_EDGE_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_FAST_EDGE_MASK) >> VCAP_RB4VCAPCONTROL_FAST_EDGE_SHIFT)
#define  VCAP_RB4VCAPCONTROL_FAST_EDGE_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_FAST_EDGE_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_FAST_EDGE_SHIFT))

#define  VCAP_RB4VCAPCONTROL_ST_EDGE_SEL_MASK 0x1000
#define  VCAP_RB4VCAPCONTROL_ST_EDGE_SEL_SHIFT 12
#define  VCAP_RB4VCAPCONTROL_ST_EDGE_SEL_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_ST_EDGE_SEL_MASK) >> VCAP_RB4VCAPCONTROL_ST_EDGE_SEL_SHIFT)
#define  VCAP_RB4VCAPCONTROL_ST_EDGE_SEL_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_ST_EDGE_SEL_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_ST_EDGE_SEL_SHIFT))

#define  VCAP_RB4VCAPCONTROL_VS_EDGE_SEL_MASK 0x800
#define  VCAP_RB4VCAPCONTROL_VS_EDGE_SEL_SHIFT 11
#define  VCAP_RB4VCAPCONTROL_VS_EDGE_SEL_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_VS_EDGE_SEL_MASK) >> VCAP_RB4VCAPCONTROL_VS_EDGE_SEL_SHIFT)
#define  VCAP_RB4VCAPCONTROL_VS_EDGE_SEL_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_VS_EDGE_SEL_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_VS_EDGE_SEL_SHIFT))

#define  VCAP_RB4VCAPCONTROL_HS_EDGE_SEL_MASK 0x400
#define  VCAP_RB4VCAPCONTROL_HS_EDGE_SEL_SHIFT 10
#define  VCAP_RB4VCAPCONTROL_HS_EDGE_SEL_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_HS_EDGE_SEL_MASK) >> VCAP_RB4VCAPCONTROL_HS_EDGE_SEL_SHIFT)
#define  VCAP_RB4VCAPCONTROL_HS_EDGE_SEL_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_HS_EDGE_SEL_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_HS_EDGE_SEL_SHIFT))

#define  VCAP_RB4VCAPCONTROL_VS_POL_MASK 0x200
#define  VCAP_RB4VCAPCONTROL_VS_POL_SHIFT 9
#define  VCAP_RB4VCAPCONTROL_VS_POL_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_VS_POL_MASK) >> VCAP_RB4VCAPCONTROL_VS_POL_SHIFT)
#define  VCAP_RB4VCAPCONTROL_VS_POL_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_VS_POL_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_VS_POL_SHIFT))

#define  VCAP_RB4VCAPCONTROL_HS_POL_MASK 0x100
#define  VCAP_RB4VCAPCONTROL_HS_POL_SHIFT 8
#define  VCAP_RB4VCAPCONTROL_HS_POL_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_HS_POL_MASK) >> VCAP_RB4VCAPCONTROL_HS_POL_SHIFT)
#define  VCAP_RB4VCAPCONTROL_HS_POL_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_HS_POL_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_HS_POL_SHIFT))

#define  VCAP_RB4VCAPCONTROL_SOFT_RST_MASK 0x80
#define  VCAP_RB4VCAPCONTROL_SOFT_RST_SHIFT 7
#define  VCAP_RB4VCAPCONTROL_SOFT_RST_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_SOFT_RST_MASK) >> VCAP_RB4VCAPCONTROL_SOFT_RST_SHIFT)
#define  VCAP_RB4VCAPCONTROL_SOFT_RST_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_SOFT_RST_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_SOFT_RST_SHIFT))

#define  VCAP_RB4VCAPCONTROL_RESERVED2_MASK 0x40
#define  VCAP_RB4VCAPCONTROL_RESERVED2_SHIFT 6
#define  VCAP_RB4VCAPCONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_RESERVED2_MASK) >> VCAP_RB4VCAPCONTROL_RESERVED2_SHIFT)
#define  VCAP_RB4VCAPCONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_RESERVED2_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_RESERVED2_SHIFT))

#define  VCAP_RB4VCAPCONTROL_RESERVED3_MASK 0x20
#define  VCAP_RB4VCAPCONTROL_RESERVED3_SHIFT 5
#define  VCAP_RB4VCAPCONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_RESERVED3_MASK) >> VCAP_RB4VCAPCONTROL_RESERVED3_SHIFT)
#define  VCAP_RB4VCAPCONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_RESERVED3_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_RESERVED3_SHIFT))

#define  VCAP_RB4VCAPCONTROL_PXL_CNTR_EN_MASK 0x10
#define  VCAP_RB4VCAPCONTROL_PXL_CNTR_EN_SHIFT 4
#define  VCAP_RB4VCAPCONTROL_PXL_CNTR_EN_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_PXL_CNTR_EN_MASK) >> VCAP_RB4VCAPCONTROL_PXL_CNTR_EN_SHIFT)
#define  VCAP_RB4VCAPCONTROL_PXL_CNTR_EN_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_PXL_CNTR_EN_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_PXL_CNTR_EN_SHIFT))

#define  VCAP_RB4VCAPCONTROL_RESERVED4_MASK 0x8
#define  VCAP_RB4VCAPCONTROL_RESERVED4_SHIFT 3
#define  VCAP_RB4VCAPCONTROL_RESERVED4_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_RESERVED4_MASK) >> VCAP_RB4VCAPCONTROL_RESERVED4_SHIFT)
#define  VCAP_RB4VCAPCONTROL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_RESERVED4_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_RESERVED4_SHIFT))

#define  VCAP_RB4VCAPCONTROL_GATE_ON_VS_MASK 0x4
#define  VCAP_RB4VCAPCONTROL_GATE_ON_VS_SHIFT 2
#define  VCAP_RB4VCAPCONTROL_GATE_ON_VS_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_GATE_ON_VS_MASK) >> VCAP_RB4VCAPCONTROL_GATE_ON_VS_SHIFT)
#define  VCAP_RB4VCAPCONTROL_GATE_ON_VS_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_GATE_ON_VS_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_GATE_ON_VS_SHIFT))

#define  VCAP_RB4VCAPCONTROL_GATE_ON_HS_MASK 0x2
#define  VCAP_RB4VCAPCONTROL_GATE_ON_HS_SHIFT 1
#define  VCAP_RB4VCAPCONTROL_GATE_ON_HS_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_GATE_ON_HS_MASK) >> VCAP_RB4VCAPCONTROL_GATE_ON_HS_SHIFT)
#define  VCAP_RB4VCAPCONTROL_GATE_ON_HS_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_GATE_ON_HS_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_GATE_ON_HS_SHIFT))

#define  VCAP_RB4VCAPCONTROL_CAP_ENB_MASK 0x1
#define  VCAP_RB4VCAPCONTROL_CAP_ENB_SHIFT 0
#define  VCAP_RB4VCAPCONTROL_CAP_ENB_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCONTROL_CAP_ENB_MASK) >> VCAP_RB4VCAPCONTROL_CAP_ENB_SHIFT)
#define  VCAP_RB4VCAPCONTROL_CAP_ENB_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCONTROL_CAP_ENB_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCONTROL_CAP_ENB_SHIFT))

//====================================================================
//Register: VCap Counter Register (rb4VCapCounter)
/** \brief This register contains the pixel counter.
   If the Counter Enable bit = '1' in the rb2VCapControl register, then the counter counts down. This register should be pre-loaded with the desired number of pixels to capture. As each pixel is received into the data fifo, the counter is decremented. An interrupt can be generated when the count reaches zero.*/
//====================================================================

#define  VCAP_RB4VCAPCOUNTER_RESERVED1_MASK 0xff000000
#define  VCAP_RB4VCAPCOUNTER_RESERVED1_SHIFT 24
#define  VCAP_RB4VCAPCOUNTER_RESERVED1_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCOUNTER_RESERVED1_MASK) >> VCAP_RB4VCAPCOUNTER_RESERVED1_SHIFT)
#define  VCAP_RB4VCAPCOUNTER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCOUNTER_RESERVED1_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCOUNTER_RESERVED1_SHIFT))

#define  VCAP_RB4VCAPCOUNTER_PXL_CNTR_MASK 0xffffff
#define  VCAP_RB4VCAPCOUNTER_PXL_CNTR_SHIFT 0
#define  VCAP_RB4VCAPCOUNTER_PXL_CNTR_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCOUNTER_PXL_CNTR_MASK) >> VCAP_RB4VCAPCOUNTER_PXL_CNTR_SHIFT)
#define  VCAP_RB4VCAPCOUNTER_PXL_CNTR_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCOUNTER_PXL_CNTR_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCOUNTER_PXL_CNTR_SHIFT))

//====================================================================
//Register: VCap Counter Observation Register (rb4VCapCounterObs)
/** \brief This register allows read-only observation of the current pixel counter value.*/
//====================================================================

#define  VCAP_RB4VCAPCOUNTEROBS_RESERVED1_MASK 0xff000000
#define  VCAP_RB4VCAPCOUNTEROBS_RESERVED1_SHIFT 24
#define  VCAP_RB4VCAPCOUNTEROBS_RESERVED1_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCOUNTEROBS_RESERVED1_MASK) >> VCAP_RB4VCAPCOUNTEROBS_RESERVED1_SHIFT)
#define  VCAP_RB4VCAPCOUNTEROBS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCOUNTEROBS_RESERVED1_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCOUNTEROBS_RESERVED1_SHIFT))

#define  VCAP_RB4VCAPCOUNTEROBS_PXL_CNTR_OBS_MASK 0xffffff
#define  VCAP_RB4VCAPCOUNTEROBS_PXL_CNTR_OBS_SHIFT 0
#define  VCAP_RB4VCAPCOUNTEROBS_PXL_CNTR_OBS_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCOUNTEROBS_PXL_CNTR_OBS_MASK) >> VCAP_RB4VCAPCOUNTEROBS_PXL_CNTR_OBS_SHIFT)
#define  VCAP_RB4VCAPCOUNTEROBS_PXL_CNTR_OBS_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCOUNTEROBS_PXL_CNTR_OBS_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCOUNTEROBS_PXL_CNTR_OBS_SHIFT))

//====================================================================
//Register: VCap Pixel Observation Register (rb4VCapPixelObs)
/** \brief This register allows read-only observation of the current pixel value.*/
//====================================================================

#define  VCAP_RB4VCAPPIXELOBS_RESERVED1_MASK 0xffe00000
#define  VCAP_RB4VCAPPIXELOBS_RESERVED1_SHIFT 21
#define  VCAP_RB4VCAPPIXELOBS_RESERVED1_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPPIXELOBS_RESERVED1_MASK) >> VCAP_RB4VCAPPIXELOBS_RESERVED1_SHIFT)
#define  VCAP_RB4VCAPPIXELOBS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPPIXELOBS_RESERVED1_MASK) | (((uint32_t)val) << VCAP_RB4VCAPPIXELOBS_RESERVED1_SHIFT))

#define  VCAP_RB4VCAPPIXELOBS_PXL_OBS_MASK 0x1fffff
#define  VCAP_RB4VCAPPIXELOBS_PXL_OBS_SHIFT 0
#define  VCAP_RB4VCAPPIXELOBS_PXL_OBS_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPPIXELOBS_PXL_OBS_MASK) >> VCAP_RB4VCAPPIXELOBS_PXL_OBS_SHIFT)
#define  VCAP_RB4VCAPPIXELOBS_PXL_OBS_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPPIXELOBS_PXL_OBS_MASK) | (((uint32_t)val) << VCAP_RB4VCAPPIXELOBS_PXL_OBS_SHIFT))

//====================================================================
//Register: VCap Line Count Register (rb4VCapLineCount)
/** \brief This register provides setting of the pixels/line and lines/image count values. This register is write only but values may be observed in rb4VCapLineCountObs register.*/
//====================================================================

#define  VCAP_RB4VCAPLINECOUNT_LINE_IMG_CNT_MASK 0xffff0000
#define  VCAP_RB4VCAPLINECOUNT_LINE_IMG_CNT_SHIFT 16
#define  VCAP_RB4VCAPLINECOUNT_LINE_IMG_CNT_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPLINECOUNT_LINE_IMG_CNT_MASK) >> VCAP_RB4VCAPLINECOUNT_LINE_IMG_CNT_SHIFT)
#define  VCAP_RB4VCAPLINECOUNT_LINE_IMG_CNT_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPLINECOUNT_LINE_IMG_CNT_MASK) | (((uint32_t)val) << VCAP_RB4VCAPLINECOUNT_LINE_IMG_CNT_SHIFT))

#define  VCAP_RB4VCAPLINECOUNT_PXL_LINE_CNT_MASK 0xffff
#define  VCAP_RB4VCAPLINECOUNT_PXL_LINE_CNT_SHIFT 0
#define  VCAP_RB4VCAPLINECOUNT_PXL_LINE_CNT_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPLINECOUNT_PXL_LINE_CNT_MASK) >> VCAP_RB4VCAPLINECOUNT_PXL_LINE_CNT_SHIFT)
#define  VCAP_RB4VCAPLINECOUNT_PXL_LINE_CNT_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPLINECOUNT_PXL_LINE_CNT_MASK) | (((uint32_t)val) << VCAP_RB4VCAPLINECOUNT_PXL_LINE_CNT_SHIFT))

//====================================================================
//Register: VCap Line Count Observation Register (rb4VCapLineCountObs)
/** \brief This register allows read-only observation of the pixels/line and lines/image current count values. These are decrementing counters.*/
//====================================================================

#define  VCAP_RB4VCAPLINECOUNTOBS_LINE_IMG_CNT_OBS_MASK 0xffff0000
#define  VCAP_RB4VCAPLINECOUNTOBS_LINE_IMG_CNT_OBS_SHIFT 16
#define  VCAP_RB4VCAPLINECOUNTOBS_LINE_IMG_CNT_OBS_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPLINECOUNTOBS_LINE_IMG_CNT_OBS_MASK) >> VCAP_RB4VCAPLINECOUNTOBS_LINE_IMG_CNT_OBS_SHIFT)
#define  VCAP_RB4VCAPLINECOUNTOBS_LINE_IMG_CNT_OBS_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPLINECOUNTOBS_LINE_IMG_CNT_OBS_MASK) | (((uint32_t)val) << VCAP_RB4VCAPLINECOUNTOBS_LINE_IMG_CNT_OBS_SHIFT))

#define  VCAP_RB4VCAPLINECOUNTOBS_PXL_LINE_CNT_OBS_MASK 0xffff
#define  VCAP_RB4VCAPLINECOUNTOBS_PXL_LINE_CNT_OBS_SHIFT 0
#define  VCAP_RB4VCAPLINECOUNTOBS_PXL_LINE_CNT_OBS_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPLINECOUNTOBS_PXL_LINE_CNT_OBS_MASK) >> VCAP_RB4VCAPLINECOUNTOBS_PXL_LINE_CNT_OBS_SHIFT)
#define  VCAP_RB4VCAPLINECOUNTOBS_PXL_LINE_CNT_OBS_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPLINECOUNTOBS_PXL_LINE_CNT_OBS_MASK) | (((uint32_t)val) << VCAP_RB4VCAPLINECOUNTOBS_PXL_LINE_CNT_OBS_SHIFT))

//====================================================================
//Register: VCap IRQ Enable Register (rb4VCapIrqEnb)
/** \brief The controller generates several interrupt conditions.
   The HS interrupt indicates a rising or falling edge on the HS input (edge selectable via control register). Similarly, for VS and ST edge interrupts.
   The Overflow interrupt indicates an incoming pixel was received prior to the previous pixel being accepted by the downstream block.
   The Counter interrupt is generated when the Countdown Enable bit ='1' in rb2VCapCtonrol, and the rb4VCapCounter register has counted down to zero.
   Writing a '1' to an enable bit will enable that interrupt source. All interrupt sources are OR'd together for a single interrupt output from the block.
   Writing a '1' to the irq force bit will force VCap to issue an irq to the interrupt controller until cleared. The force bit is used only for testing.*/
//====================================================================

#define  VCAP_RB4VCAPIRQENB_RESERVED1_MASK 0xffffffe0
#define  VCAP_RB4VCAPIRQENB_RESERVED1_SHIFT 5
#define  VCAP_RB4VCAPIRQENB_RESERVED1_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQENB_RESERVED1_MASK) >> VCAP_RB4VCAPIRQENB_RESERVED1_SHIFT)
#define  VCAP_RB4VCAPIRQENB_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQENB_RESERVED1_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQENB_RESERVED1_SHIFT))

#define  VCAP_RB4VCAPIRQENB_IRQ_CNTR_ENB_MASK 0x10
#define  VCAP_RB4VCAPIRQENB_IRQ_CNTR_ENB_SHIFT 4
#define  VCAP_RB4VCAPIRQENB_IRQ_CNTR_ENB_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQENB_IRQ_CNTR_ENB_MASK) >> VCAP_RB4VCAPIRQENB_IRQ_CNTR_ENB_SHIFT)
#define  VCAP_RB4VCAPIRQENB_IRQ_CNTR_ENB_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQENB_IRQ_CNTR_ENB_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQENB_IRQ_CNTR_ENB_SHIFT))

#define  VCAP_RB4VCAPIRQENB_IRQ_OVFLW_ENB_MASK 0x8
#define  VCAP_RB4VCAPIRQENB_IRQ_OVFLW_ENB_SHIFT 3
#define  VCAP_RB4VCAPIRQENB_IRQ_OVFLW_ENB_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQENB_IRQ_OVFLW_ENB_MASK) >> VCAP_RB4VCAPIRQENB_IRQ_OVFLW_ENB_SHIFT)
#define  VCAP_RB4VCAPIRQENB_IRQ_OVFLW_ENB_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQENB_IRQ_OVFLW_ENB_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQENB_IRQ_OVFLW_ENB_SHIFT))

#define  VCAP_RB4VCAPIRQENB_IRQ_ST_ENB_MASK 0x4
#define  VCAP_RB4VCAPIRQENB_IRQ_ST_ENB_SHIFT 2
#define  VCAP_RB4VCAPIRQENB_IRQ_ST_ENB_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQENB_IRQ_ST_ENB_MASK) >> VCAP_RB4VCAPIRQENB_IRQ_ST_ENB_SHIFT)
#define  VCAP_RB4VCAPIRQENB_IRQ_ST_ENB_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQENB_IRQ_ST_ENB_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQENB_IRQ_ST_ENB_SHIFT))

#define  VCAP_RB4VCAPIRQENB_IRQ_VS_ENB_MASK 0x2
#define  VCAP_RB4VCAPIRQENB_IRQ_VS_ENB_SHIFT 1
#define  VCAP_RB4VCAPIRQENB_IRQ_VS_ENB_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQENB_IRQ_VS_ENB_MASK) >> VCAP_RB4VCAPIRQENB_IRQ_VS_ENB_SHIFT)
#define  VCAP_RB4VCAPIRQENB_IRQ_VS_ENB_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQENB_IRQ_VS_ENB_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQENB_IRQ_VS_ENB_SHIFT))

#define  VCAP_RB4VCAPIRQENB_IRQ_HS_ENB_MASK 0x1
#define  VCAP_RB4VCAPIRQENB_IRQ_HS_ENB_SHIFT 0
#define  VCAP_RB4VCAPIRQENB_IRQ_HS_ENB_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQENB_IRQ_HS_ENB_MASK) >> VCAP_RB4VCAPIRQENB_IRQ_HS_ENB_SHIFT)
#define  VCAP_RB4VCAPIRQENB_IRQ_HS_ENB_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQENB_IRQ_HS_ENB_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQENB_IRQ_HS_ENB_SHIFT))

//====================================================================
//Register: VCap IRQ Pending Register (rb4VCapIrqPnd)
/** \brief This register provides read-only bits for observing any pending VCAP interrupts.*/
//====================================================================

#define  VCAP_RB4VCAPIRQPND_RESERVED1_MASK 0xffffffe0
#define  VCAP_RB4VCAPIRQPND_RESERVED1_SHIFT 5
#define  VCAP_RB4VCAPIRQPND_RESERVED1_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQPND_RESERVED1_MASK) >> VCAP_RB4VCAPIRQPND_RESERVED1_SHIFT)
#define  VCAP_RB4VCAPIRQPND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQPND_RESERVED1_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQPND_RESERVED1_SHIFT))

#define  VCAP_RB4VCAPIRQPND_IRQ_CNTR_PNDG_MASK 0x10
#define  VCAP_RB4VCAPIRQPND_IRQ_CNTR_PNDG_SHIFT 4
#define  VCAP_RB4VCAPIRQPND_IRQ_CNTR_PNDG_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQPND_IRQ_CNTR_PNDG_MASK) >> VCAP_RB4VCAPIRQPND_IRQ_CNTR_PNDG_SHIFT)
#define  VCAP_RB4VCAPIRQPND_IRQ_CNTR_PNDG_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQPND_IRQ_CNTR_PNDG_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQPND_IRQ_CNTR_PNDG_SHIFT))

#define  VCAP_RB4VCAPIRQPND_IRQ_OVFLW_PNDG_MASK 0x8
#define  VCAP_RB4VCAPIRQPND_IRQ_OVFLW_PNDG_SHIFT 3
#define  VCAP_RB4VCAPIRQPND_IRQ_OVFLW_PNDG_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQPND_IRQ_OVFLW_PNDG_MASK) >> VCAP_RB4VCAPIRQPND_IRQ_OVFLW_PNDG_SHIFT)
#define  VCAP_RB4VCAPIRQPND_IRQ_OVFLW_PNDG_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQPND_IRQ_OVFLW_PNDG_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQPND_IRQ_OVFLW_PNDG_SHIFT))

#define  VCAP_RB4VCAPIRQPND_IRQ_ST_PNDG_MASK 0x4
#define  VCAP_RB4VCAPIRQPND_IRQ_ST_PNDG_SHIFT 2
#define  VCAP_RB4VCAPIRQPND_IRQ_ST_PNDG_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQPND_IRQ_ST_PNDG_MASK) >> VCAP_RB4VCAPIRQPND_IRQ_ST_PNDG_SHIFT)
#define  VCAP_RB4VCAPIRQPND_IRQ_ST_PNDG_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQPND_IRQ_ST_PNDG_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQPND_IRQ_ST_PNDG_SHIFT))

#define  VCAP_RB4VCAPIRQPND_IRQ_VS_PNDG_MASK 0x2
#define  VCAP_RB4VCAPIRQPND_IRQ_VS_PNDG_SHIFT 1
#define  VCAP_RB4VCAPIRQPND_IRQ_VS_PNDG_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQPND_IRQ_VS_PNDG_MASK) >> VCAP_RB4VCAPIRQPND_IRQ_VS_PNDG_SHIFT)
#define  VCAP_RB4VCAPIRQPND_IRQ_VS_PNDG_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQPND_IRQ_VS_PNDG_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQPND_IRQ_VS_PNDG_SHIFT))

#define  VCAP_RB4VCAPIRQPND_IRQ_HS_PNDG_MASK 0x1
#define  VCAP_RB4VCAPIRQPND_IRQ_HS_PNDG_SHIFT 0
#define  VCAP_RB4VCAPIRQPND_IRQ_HS_PNDG_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQPND_IRQ_HS_PNDG_MASK) >> VCAP_RB4VCAPIRQPND_IRQ_HS_PNDG_SHIFT)
#define  VCAP_RB4VCAPIRQPND_IRQ_HS_PNDG_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQPND_IRQ_HS_PNDG_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQPND_IRQ_HS_PNDG_SHIFT))

//====================================================================
//Register: VCap IRQ Acknowledge Register (rb4VCapIrqAck)
/** \brief This register provides write-only bits for acknowledging(clearing) any pending VCAP interrupts.*/
//====================================================================

#define  VCAP_RB4VCAPIRQACK_RESERVED1_MASK 0xffffffe0
#define  VCAP_RB4VCAPIRQACK_RESERVED1_SHIFT 5
#define  VCAP_RB4VCAPIRQACK_RESERVED1_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQACK_RESERVED1_MASK) >> VCAP_RB4VCAPIRQACK_RESERVED1_SHIFT)
#define  VCAP_RB4VCAPIRQACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQACK_RESERVED1_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQACK_RESERVED1_SHIFT))

#define  VCAP_RB4VCAPIRQACK_IRQ_CNTR_ACK_MASK 0x10
#define  VCAP_RB4VCAPIRQACK_IRQ_CNTR_ACK_SHIFT 4
#define  VCAP_RB4VCAPIRQACK_IRQ_CNTR_ACK_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQACK_IRQ_CNTR_ACK_MASK) >> VCAP_RB4VCAPIRQACK_IRQ_CNTR_ACK_SHIFT)
#define  VCAP_RB4VCAPIRQACK_IRQ_CNTR_ACK_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQACK_IRQ_CNTR_ACK_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQACK_IRQ_CNTR_ACK_SHIFT))

#define  VCAP_RB4VCAPIRQACK_IRQ_OVFLW_ACK_MASK 0x8
#define  VCAP_RB4VCAPIRQACK_IRQ_OVFLW_ACK_SHIFT 3
#define  VCAP_RB4VCAPIRQACK_IRQ_OVFLW_ACK_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQACK_IRQ_OVFLW_ACK_MASK) >> VCAP_RB4VCAPIRQACK_IRQ_OVFLW_ACK_SHIFT)
#define  VCAP_RB4VCAPIRQACK_IRQ_OVFLW_ACK_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQACK_IRQ_OVFLW_ACK_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQACK_IRQ_OVFLW_ACK_SHIFT))

#define  VCAP_RB4VCAPIRQACK_IRQ_ST_ACK_MASK 0x4
#define  VCAP_RB4VCAPIRQACK_IRQ_ST_ACK_SHIFT 2
#define  VCAP_RB4VCAPIRQACK_IRQ_ST_ACK_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQACK_IRQ_ST_ACK_MASK) >> VCAP_RB4VCAPIRQACK_IRQ_ST_ACK_SHIFT)
#define  VCAP_RB4VCAPIRQACK_IRQ_ST_ACK_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQACK_IRQ_ST_ACK_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQACK_IRQ_ST_ACK_SHIFT))

#define  VCAP_RB4VCAPIRQACK_IRQ_VS_ACK_MASK 0x2
#define  VCAP_RB4VCAPIRQACK_IRQ_VS_ACK_SHIFT 1
#define  VCAP_RB4VCAPIRQACK_IRQ_VS_ACK_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQACK_IRQ_VS_ACK_MASK) >> VCAP_RB4VCAPIRQACK_IRQ_VS_ACK_SHIFT)
#define  VCAP_RB4VCAPIRQACK_IRQ_VS_ACK_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQACK_IRQ_VS_ACK_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQACK_IRQ_VS_ACK_SHIFT))

#define  VCAP_RB4VCAPIRQACK_IRQ_HS_ACK_MASK 0x1
#define  VCAP_RB4VCAPIRQACK_IRQ_HS_ACK_SHIFT 0
#define  VCAP_RB4VCAPIRQACK_IRQ_HS_ACK_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQACK_IRQ_HS_ACK_MASK) >> VCAP_RB4VCAPIRQACK_IRQ_HS_ACK_SHIFT)
#define  VCAP_RB4VCAPIRQACK_IRQ_HS_ACK_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQACK_IRQ_HS_ACK_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQACK_IRQ_HS_ACK_SHIFT))

//====================================================================
//Register: VCap IRQ Force Register (rb4VCapIrqForce)
/** \brief This register provides write-only bits for forcing(for test purposes) any VCAP interrupts.*/
//====================================================================

#define  VCAP_RB4VCAPIRQFORCE_RESERVED1_MASK 0xffffffe0
#define  VCAP_RB4VCAPIRQFORCE_RESERVED1_SHIFT 5
#define  VCAP_RB4VCAPIRQFORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQFORCE_RESERVED1_MASK) >> VCAP_RB4VCAPIRQFORCE_RESERVED1_SHIFT)
#define  VCAP_RB4VCAPIRQFORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQFORCE_RESERVED1_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQFORCE_RESERVED1_SHIFT))

#define  VCAP_RB4VCAPIRQFORCE_IRQ_CNTR_FORCE_MASK 0x10
#define  VCAP_RB4VCAPIRQFORCE_IRQ_CNTR_FORCE_SHIFT 4
#define  VCAP_RB4VCAPIRQFORCE_IRQ_CNTR_FORCE_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQFORCE_IRQ_CNTR_FORCE_MASK) >> VCAP_RB4VCAPIRQFORCE_IRQ_CNTR_FORCE_SHIFT)
#define  VCAP_RB4VCAPIRQFORCE_IRQ_CNTR_FORCE_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQFORCE_IRQ_CNTR_FORCE_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQFORCE_IRQ_CNTR_FORCE_SHIFT))

#define  VCAP_RB4VCAPIRQFORCE_IRQ_OVFLW_FORCE_MASK 0x8
#define  VCAP_RB4VCAPIRQFORCE_IRQ_OVFLW_FORCE_SHIFT 3
#define  VCAP_RB4VCAPIRQFORCE_IRQ_OVFLW_FORCE_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQFORCE_IRQ_OVFLW_FORCE_MASK) >> VCAP_RB4VCAPIRQFORCE_IRQ_OVFLW_FORCE_SHIFT)
#define  VCAP_RB4VCAPIRQFORCE_IRQ_OVFLW_FORCE_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQFORCE_IRQ_OVFLW_FORCE_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQFORCE_IRQ_OVFLW_FORCE_SHIFT))

#define  VCAP_RB4VCAPIRQFORCE_IRQ_ST_FORCE_MASK 0x4
#define  VCAP_RB4VCAPIRQFORCE_IRQ_ST_FORCE_SHIFT 2
#define  VCAP_RB4VCAPIRQFORCE_IRQ_ST_FORCE_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQFORCE_IRQ_ST_FORCE_MASK) >> VCAP_RB4VCAPIRQFORCE_IRQ_ST_FORCE_SHIFT)
#define  VCAP_RB4VCAPIRQFORCE_IRQ_ST_FORCE_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQFORCE_IRQ_ST_FORCE_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQFORCE_IRQ_ST_FORCE_SHIFT))

#define  VCAP_RB4VCAPIRQFORCE_IRQ_VS_FORCE_MASK 0x2
#define  VCAP_RB4VCAPIRQFORCE_IRQ_VS_FORCE_SHIFT 1
#define  VCAP_RB4VCAPIRQFORCE_IRQ_VS_FORCE_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQFORCE_IRQ_VS_FORCE_MASK) >> VCAP_RB4VCAPIRQFORCE_IRQ_VS_FORCE_SHIFT)
#define  VCAP_RB4VCAPIRQFORCE_IRQ_VS_FORCE_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQFORCE_IRQ_VS_FORCE_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQFORCE_IRQ_VS_FORCE_SHIFT))

#define  VCAP_RB4VCAPIRQFORCE_IRQ_HS_FORCE_MASK 0x1
#define  VCAP_RB4VCAPIRQFORCE_IRQ_HS_FORCE_SHIFT 0
#define  VCAP_RB4VCAPIRQFORCE_IRQ_HS_FORCE_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPIRQFORCE_IRQ_HS_FORCE_MASK) >> VCAP_RB4VCAPIRQFORCE_IRQ_HS_FORCE_SHIFT)
#define  VCAP_RB4VCAPIRQFORCE_IRQ_HS_FORCE_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPIRQFORCE_IRQ_HS_FORCE_MASK) | (((uint32_t)val) << VCAP_RB4VCAPIRQFORCE_IRQ_HS_FORCE_SHIFT))

//====================================================================
//Register: VCAP Clock Register (rb4VCapClk)
/** \brief This register contains settings related to the VCAP Clock output to the Camera sensor. The system clock source may be dithered (200MHz) or non-dithered (~209MHz) and is the same as selected for the SCAN block.*/
//====================================================================

#define  VCAP_RB4VCAPCLK_VCAP_CLK_OUT_EN_MASK 0x80000000
#define  VCAP_RB4VCAPCLK_VCAP_CLK_OUT_EN_SHIFT 31
#define  VCAP_RB4VCAPCLK_VCAP_CLK_OUT_EN_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCLK_VCAP_CLK_OUT_EN_MASK) >> VCAP_RB4VCAPCLK_VCAP_CLK_OUT_EN_SHIFT)
#define  VCAP_RB4VCAPCLK_VCAP_CLK_OUT_EN_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCLK_VCAP_CLK_OUT_EN_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCLK_VCAP_CLK_OUT_EN_SHIFT))

#define  VCAP_RB4VCAPCLK_RESERVED1_MASK 0x7fff0000
#define  VCAP_RB4VCAPCLK_RESERVED1_SHIFT 16
#define  VCAP_RB4VCAPCLK_RESERVED1_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCLK_RESERVED1_MASK) >> VCAP_RB4VCAPCLK_RESERVED1_SHIFT)
#define  VCAP_RB4VCAPCLK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCLK_RESERVED1_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCLK_RESERVED1_SHIFT))

#define  VCAP_RB4VCAPCLK_CLK_HIGH_MASK 0xff00
#define  VCAP_RB4VCAPCLK_CLK_HIGH_SHIFT 8
#define  VCAP_RB4VCAPCLK_CLK_HIGH_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCLK_CLK_HIGH_MASK) >> VCAP_RB4VCAPCLK_CLK_HIGH_SHIFT)
#define  VCAP_RB4VCAPCLK_CLK_HIGH_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCLK_CLK_HIGH_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCLK_CLK_HIGH_SHIFT))

#define  VCAP_RB4VCAPCLK_CLK_LOW_MASK 0xff
#define  VCAP_RB4VCAPCLK_CLK_LOW_SHIFT 0
#define  VCAP_RB4VCAPCLK_CLK_LOW_MASK_SHIFT(reg) (((reg) & VCAP_RB4VCAPCLK_CLK_LOW_MASK) >> VCAP_RB4VCAPCLK_CLK_LOW_SHIFT)
#define  VCAP_RB4VCAPCLK_CLK_LOW_REPLACE_VAL(reg,val) (((reg) & ~VCAP_RB4VCAPCLK_CLK_LOW_MASK) | (((uint32_t)val) << VCAP_RB4VCAPCLK_CLK_LOW_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  VCAP_REV0_MAJ_MASK 0xffff0000
#define  VCAP_REV0_MAJ_SHIFT 16
#define  VCAP_REV0_MAJ_MASK_SHIFT(reg) (((reg) & VCAP_REV0_MAJ_MASK) >> VCAP_REV0_MAJ_SHIFT)
#define  VCAP_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~VCAP_REV0_MAJ_MASK) | (((uint32_t)val) << VCAP_REV0_MAJ_SHIFT))

#define  VCAP_REV0_MID_MASK 0xffff
#define  VCAP_REV0_MID_SHIFT 0
#define  VCAP_REV0_MID_MASK_SHIFT(reg) (((reg) & VCAP_REV0_MID_MASK) >> VCAP_REV0_MID_SHIFT)
#define  VCAP_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~VCAP_REV0_MID_MASK) | (((uint32_t)val) << VCAP_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  VCAP_REV1_RESERVED1_MASK 0xffff0000
#define  VCAP_REV1_RESERVED1_SHIFT 16
#define  VCAP_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & VCAP_REV1_RESERVED1_MASK) >> VCAP_REV1_RESERVED1_SHIFT)
#define  VCAP_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCAP_REV1_RESERVED1_MASK) | (((uint32_t)val) << VCAP_REV1_RESERVED1_SHIFT))

#define  VCAP_REV1_CFG_MASK 0xffff
#define  VCAP_REV1_CFG_SHIFT 0
#define  VCAP_REV1_CFG_MASK_SHIFT(reg) (((reg) & VCAP_REV1_CFG_MASK) >> VCAP_REV1_CFG_SHIFT)
#define  VCAP_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~VCAP_REV1_CFG_MASK) | (((uint32_t)val) << VCAP_REV1_CFG_SHIFT))

#endif // VCAP
