 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file USB3D_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _USB3D_REGSTRUCTS_H_
#define _USB3D_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: USB3D (USB3D)
//
//====================================================================

//====================================================================
//
//Register File: USB 3.0 device SuperSpeed registers (USB3D_SS)
//
//====================================================================

typedef struct USB3D_SS_REGS_s
{
  volatile uint32_t DEV_INFO_REG;  ///< 0x0 [R/W]: DEV_INFO_REG
  volatile uint32_t DEV_TAG_REG;  ///< 0x4 [R]: DEV_TAG_REG
  volatile uint32_t LOW_POWER_LFPS_SIGNAL_VAL_REG_1;  ///< 0x8 [R/W]: LOW_POWER_LFPS_SIGNAL_VAL_REG_1
  volatile uint32_t LOW_POWER_LFPS_SIGNAL_VAL_REG_2;  ///< 0xc [R/W]: LOW_POWER_LFPS_SIGNAL_VAL_REG_2
  volatile uint32_t LOW_POWER_LFPS_SIGNAL_VAL_REG_3;  ///< 0x10 [R/W]: LOW_POWER_LFPS_SIGNAL_VAL_REG_3
  volatile uint32_t LOW_POWER_LFPS_SIGNAL_VAL_REG_4;  ///< 0x14 [R/W]: LOW_POWER_LFPS_SIGNAL_VAL_REG_4
  volatile uint32_t LOW_POWER_LFPS_SIGNAL_VAL_REG_5;  ///< 0x18 [R/W]: LOW_POWER_LFPS_SIGNAL_VAL_REG_5
  volatile uint32_t LOW_POWER_LFPS_SIGNAL_VAL_REG_6;  ///< 0x1c [R/W]: LOW_POWER_LFPS_SIGNAL_VAL_REG_6
  volatile uint32_t COUNTER_PULSE_VALUE_REG;  ///< 0x20 [R/W]: COUNTER_PULSE_VALUE_REG
  volatile uint32_t REF_INT_STATUS_REG;  ///< 0x24 [R/W]: REF_INT_STATUS_REG
  volatile uint32_t REF_INT_ENABLE_REG;  ///< 0x28 [R/W]: REF_INT_ENABLE_REG
  volatile uint32_t USB3_GLOBAL_CONTROL_STATUS_REG;  ///< 0x2c [R/W]: USB3_GLOBAL_CONTROL_STATUS_REG
  volatile uint32_t SYSTEM_DEBUG_REG;  ///< 0x30 [R]: SYSTEM_DEBUG_REG
  volatile uint32_t EP0_ACK_TIMEOUT_VALUE_REG;  ///< 0x34 [R/W]: EP0_ACK_TIMEOUT_VALUE_REG
  volatile uint32_t ACK_TIMEOUT_VALUE_REG;  ///< 0x38 [R/W]: ACK_TIMEOUT_VALUE_REG
  volatile uint32_t RX_IDLE_DELAY_COUNTER_REG;  ///< 0x3c [R/W]: RX_IDLE_DELAY_COUNTER_REG
  volatile uint32_t BACK_DOOR_REG;  ///< 0x40 [R/W]: BACK_DOOR_REG
  volatile uint32_t TEST_BUS_MUX_REG;  ///< 0x44 [R/W]: TEST_BUS_MUX_REG
  volatile uint32_t CLOCK_GATING_ENABLE_REG;  ///< 0x48 [R/W]: CLOCK_GATING_ENABLE_REG
  volatile uint32_t POWER_GATING_ENABLE_REG;  ///< 0x4c [R/W]: POWER_GATING_ENABLE_REG
  volatile uint32_t reserved0[30];
  volatile uint32_t POWER_MANAGEMENT_DEVICE_REG;  ///< 0xc8 [R]: POWER_MANAGEMENT_DEVICE_REG
  volatile uint32_t POWER_MANAGEMENT_SOC_REG;  ///< 0xcc [R/W]: POWER_MANAGEMENT_SOC_REG
  volatile uint32_t LOW_POWER_STATUS_REG;  ///< 0xd0 [R]: LOW_POWER_STATUS_REG
  volatile uint32_t SOFTWARE_RESET_REG;  ///< 0xd4 [R/W]: SOFTWARE_RESET_REG
  volatile uint32_t TOP_INTERRUPT_STATUS_REG;  ///< 0xd8 [R/W]: TOP_INTERRUPT_STATUS_REG
  volatile uint32_t TOP_INTERRUPT_ENABLE_REG;  ///< 0xdc [R/W]: TOP_INTERRUPT_ENABLE_REG
  volatile uint32_t TOP_INTERRUPT_STATUS_EN_REG;  ///< 0xe0 [R/W]: TOP_INTERRUPT_STATUS_EN_REG
  volatile uint32_t reserved1[43];
  volatile uint32_t TSEQ_COUNTER_U1U2_TIMEOUT_REG;  ///< 0x190 [R/W]: TSEQ_COUNTER_U1U2_TIMEOUT_REG
  volatile uint32_t TIMER_TIMEOUT_REG_1;  ///< 0x194 [R/W]: TIMER_TIMEOUT_REG_1
  volatile uint32_t TIMER_TIMEOUT_REG_2;  ///< 0x198 [R/W]: TIMER_TIMEOUT_REG_2
  volatile uint32_t LFPS_TX_CONFIG_REG;  ///< 0x19c [R/W]: LFPS_TX_CONFIG_REG
  volatile uint32_t LFPS_RX_CONFIG_REG;  ///< 0x1a0 [R/W]: LFPS_RX_CONFIG_REG
  volatile uint32_t LFPS_WR_TRESET_VAL_REG;  ///< 0x1a4 [R/W]: LFPS_WR_TRESET_VAL_REG
  volatile uint32_t COUNTER_DELAY_TX_REG;  ///< 0x1a8 [R/W]: COUNTER_DELAY_TX_REG
  volatile uint32_t reserved2[93];
  volatile uint32_t DEV_USB_ADDRESS_REG;  ///< 0x320 [R]: DEV_USB_ADDRESS_REG
  volatile uint32_t FUNCTION_WAKEUP_REG;  ///< 0x324 [R/W]: FUNCTION_WAKEUP_REG
  volatile uint32_t ENDPOINT_0_CONFIG_REG;  ///< 0x328 [R/W]: ENDPOINT_0_CONFIG_REG
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_1;  ///< 0x32c [R/W]: OUT_ENDPOINT_CONFIG_REG_1
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_2;  ///< 0x330 [R/W]: OUT_ENDPOINT_CONFIG_REG_2
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_3;  ///< 0x334 [R/W]: OUT_ENDPOINT_CONFIG_REG_3
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_4;  ///< 0x338 [R/W]: OUT_ENDPOINT_CONFIG_REG_4
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_5;  ///< 0x33c [R/W]: OUT_ENDPOINT_CONFIG_REG_5
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_6;  ///< 0x340 [R/W]: OUT_ENDPOINT_CONFIG_REG_6
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_7;  ///< 0x344 [R/W]: OUT_ENDPOINT_CONFIG_REG_7
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_8;  ///< 0x348 [R/W]: OUT_ENDPOINT_CONFIG_REG_8
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_9;  ///< 0x34c [R/W]: OUT_ENDPOINT_CONFIG_REG_9
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_10;  ///< 0x350 [R/W]: OUT_ENDPOINT_CONFIG_REG_10
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_11;  ///< 0x354 [R/W]: OUT_ENDPOINT_CONFIG_REG_11
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_12;  ///< 0x358 [R/W]: OUT_ENDPOINT_CONFIG_REG_12
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_13;  ///< 0x35c [R/W]: OUT_ENDPOINT_CONFIG_REG_13
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_14;  ///< 0x360 [R/W]: OUT_ENDPOINT_CONFIG_REG_14
  volatile uint32_t OUT_ENDPOINT_CONFIG_REG_15;  ///< 0x364 [R/W]: OUT_ENDPOINT_CONFIG_REG_15
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_1;  ///< 0x368 [R/W]: IN_ENDPOINT_CONFIG_REG_1
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_2;  ///< 0x36c [R/W]: IN_ENDPOINT_CONFIG_REG_2
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_3;  ///< 0x370 [R/W]: IN_ENDPOINT_CONFIG_REG_3
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_4;  ///< 0x374 [R/W]: IN_ENDPOINT_CONFIG_REG_4
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_5;  ///< 0x378 [R/W]: IN_ENDPOINT_CONFIG_REG_5
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_6;  ///< 0x37c [R/W]: IN_ENDPOINT_CONFIG_REG_6
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_7;  ///< 0x380 [R/W]: IN_ENDPOINT_CONFIG_REG_7
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_8;  ///< 0x384 [R/W]: IN_ENDPOINT_CONFIG_REG_8
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_9;  ///< 0x388 [R/W]: IN_ENDPOINT_CONFIG_REG_9
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_10;  ///< 0x38c [R/W]: IN_ENDPOINT_CONFIG_REG_10
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_11;  ///< 0x390 [R/W]: IN_ENDPOINT_CONFIG_REG_11
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_12;  ///< 0x394 [R/W]: IN_ENDPOINT_CONFIG_REG_12
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_13;  ///< 0x398 [R/W]: IN_ENDPOINT_CONFIG_REG_13
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_14;  ///< 0x39c [R/W]: IN_ENDPOINT_CONFIG_REG_14
  volatile uint32_t IN_ENDPOINT_CONFIG_REG_15;  ///< 0x3a0 [R/W]: IN_ENDPOINT_CONFIG_REG_15
  volatile uint32_t PHY_CFG_REG;  ///< 0x3a4 [R/W]: PHY_CFG_REG
  volatile uint32_t BUS_INTERVAL_LTM_REG;  ///< 0x3a8 [R/W]: BUS_INTERVAL_LTM_REG
  volatile uint32_t ISO_TIME_STAMP_COUNTER_REG;  ///< 0x3ac [R]: ISO_TIME_STAMP_COUNTER_REG
  volatile uint32_t CREDIT_HP_AND_U2_TIMER_REG;  ///< 0x3b0 [R/W]: CREDIT_HP_AND_U2_TIMER_REG
  volatile uint32_t PM_LC_TIMER_TIME_OUT_REG;  ///< 0x3b4 [R/W]: PM_LC_TIMER_TIME_OUT_REG
  volatile uint32_t SS_CORE_INTERRUPT_REG;  ///< 0x3b8 [R/W]: SS_CORE_INTERRUPT_REG
  volatile uint32_t SS_CORE_INTERRUPT_EN_REG;  ///< 0x3bc [R/W]: SS_CORE_INTERRUPT_EN_REG
  volatile uint32_t EP_IN_BINTERVAL_REG_1_2_3;  ///< 0x3c0 [R/W]: EP_IN_BINTERVAL_REG_1_TO_3
  volatile uint32_t EP_IN_BINTERVAL_REG_4_5_6_7;  ///< 0x3c4 [R/W]: EP_IN_BINTERVAL_REG_4_TO_7
  volatile uint32_t EP_IN_BINTERVAL_REG_8_9_10_11;  ///< 0x3c8 [R/W]: EP_IN_BINTERVAL_REG_8_TO_11
  volatile uint32_t EP_IN_BINTERVAL_REG_12_13_14_15;  ///< 0x3cc [R/W]: EP_IN_BINTERVAL_REG_12_TO_15
  volatile uint32_t EP_OUT_BINTERVAL_REG_1_2_3;  ///< 0x3d0 [R/W]: EP_OUT_BINTERVAL_REG_1_TO_3
  volatile uint32_t EP_OUT_BINTERVAL_REG_4_5_6_7;  ///< 0x3d4 [R/W]: EP_OUT_BINTERVAL_REG_4_TO_7
  volatile uint32_t EP_OUT_BINTERVAL_REG_8_9_10_11;  ///< 0x3d8 [R/W]: EP_OUT_BINTERVAL_REG_8_TO_11
  volatile uint32_t EP_OUT_BINTERVAL_REG_12_13_14_15;  ///< 0x3dc [R/W]: EP_OUT_BINTERVAL_REG_12_TO_15
  volatile uint32_t EP_HOST_ERROR_STATUS_REG;  ///< 0x3e0 [R/W]: EP_HOST_ERROR_STATUS_REG
  volatile uint32_t PING_TIMEOUT_REG;  ///< 0x3e4 [R/W]: PING_TIMEOUT_REG
  volatile uint32_t UX_EXIT_DETECTION_DELAY_REG;  ///< 0x3e8 [R/W]: UX_EXIT_DETECTION_DELAY_REG
  volatile uint32_t TX_TSI_NUM_REG;  ///< 0x3ec [R/W]: TX_TSI_NUM_REG
  volatile uint32_t START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG;  ///< 0x3f0 [R/W]: START_STATE_DELAY_AND_MIN_TS2_HOT_RESET
  volatile uint32_t LOWPOWER_MANAGEMENT_REG;  ///< 0x3f4 [R/W]: LOWPOWER_MANAGEMENT_REG
  volatile uint32_t USB3_SETUP_DP_LOW_REG;  ///< 0x3f8 [R]: USB3_SETUP_DP_LOW_REG
  volatile uint32_t USB3_SETUP_DP_HIGH_REG;  ///< 0x3fc [R]: USB3_SETUP_DP_HIGH_REG
  volatile uint32_t USB3_SETUP_CONTROL_REG;  ///< 0x400 [R/W]: USB3_SETUP_CONTROL_REG
  volatile uint32_t DELAY_U1_CNT_INIT_VALUE_REG;  ///< 0x404 [R/W]: DELAY_U1_CNT_INIT_VALUE_REG
  volatile uint32_t DELAY_U2_CNT_INIT_VALUE_REG;  ///< 0x408 [R/W]: DELAY_U2_CNT_INIT_VALUE_REG
  volatile uint32_t NO_BURST_MODE_REG;  ///< 0x40c [R/W]: NO_BURST_MODE_REG
  volatile uint32_t reserved3[240];
  volatile uint32_t DMA_GLOBAL_CONFIG_REG;  ///< 0x7d0 [R/W]: DMA_GLOBAL_CONFIG_REG
  volatile uint32_t BULK_STREAMING_ENABLE_REG;  ///< 0x7d4 [R/W]: BULK_STREAMING_ENABLE_REG
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_1;  ///< 0x7d8 [R]: EP_OUT_RCV_STREAM_ID_REG_1
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_2;  ///< 0x7dc [R]: EP_OUT_RCV_STREAM_ID_REG_2
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_3;  ///< 0x7e0 [R]: EP_OUT_RCV_STREAM_ID_REG_3
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_4;  ///< 0x7e4 [R]: EP_OUT_RCV_STREAM_ID_REG_4
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_5;  ///< 0x7e8 [R]: EP_OUT_RCV_STREAM_ID_REG_5
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_6;  ///< 0x7ec [R]: EP_OUT_RCV_STREAM_ID_REG_6
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_7;  ///< 0x7f0 [R]: EP_OUT_RCV_STREAM_ID_REG_7
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_8;  ///< 0x7f4 [R]: EP_OUT_RCV_STREAM_ID_REG_8
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_9;  ///< 0x7f8 [R]: EP_OUT_RCV_STREAM_ID_REG_9
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_10;  ///< 0x7fc [R]: EP_OUT_RCV_STREAM_ID_REG_10
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_11;  ///< 0x800 [R]: EP_OUT_RCV_STREAM_ID_REG_11
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_12;  ///< 0x804 [R]: EP_OUT_RCV_STREAM_ID_REG_12
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_13;  ///< 0x808 [R]: EP_OUT_RCV_STREAM_ID_REG_13
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_14;  ///< 0x80c [R]: EP_OUT_RCV_STREAM_ID_REG_14
  volatile uint32_t EP_OUT_RCV_STREAM_ID_REG_15;  ///< 0x810 [R]: EP_OUT_RCV_STREAM_ID_REG_15
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_1;  ///< 0x814 [R]: EP_IN_RCV_STREAM_ID_REG_1
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_2;  ///< 0x818 [R]: EP_IN_RCV_STREAM_ID_REG_2
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_3;  ///< 0x81c [R]: EP_IN_RCV_STREAM_ID_REG_3
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_4;  ///< 0x820 [R]: EP_IN_RCV_STREAM_ID_REG_4
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_5;  ///< 0x824 [R]: EP_IN_RCV_STREAM_ID_REG_5
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_6;  ///< 0x828 [R]: EP_IN_RCV_STREAM_ID_REG_6
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_7;  ///< 0x82c [R]: EP_IN_RCV_STREAM_ID_REG_7
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_8;  ///< 0x830 [R]: EP_IN_RCV_STREAM_ID_REG_8
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_9;  ///< 0x834 [R]: EP_IN_RCV_STREAM_ID_REG_9
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_10;  ///< 0x838 [R]: EP_IN_RCV_STREAM_ID_REG_10
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_11;  ///< 0x83c [R]: EP_IN_RCV_STREAM_ID_REG_11
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_12;  ///< 0x840 [R]: EP_IN_RCV_STREAM_ID_REG_12
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_13;  ///< 0x844 [R]: EP_IN_RCV_STREAM_ID_REG_13
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_14;  ///< 0x848 [R]: EP_IN_RCV_STREAM_ID_REG_14
  volatile uint32_t EP_IN_RCV_STREAM_ID_REG_15;  ///< 0x84c [R]: EP_IN_RCV_STREAM_ID_REG_15
  volatile uint32_t DMA_COMPLETE_SUCCESS_STATUS_REG;  ///< 0x850 [W]: DMA_COMPLETE_SUCCESS_STATUS_REG
  volatile uint32_t DMA_COMPLETE_ERROR_STATUS_REG;  ///< 0x854 [W]: DMA_COMPLETE_ERROR_STATUS_REG
  volatile uint32_t DMA_BD_FETCH_ERROR_STATUS_REG;  ///< 0x858 [W]: DMA_BD_FETCH_ERROR_STATUS_REG
  volatile uint32_t DMA_BD_FETCH_ERROR_EN_REG;  ///< 0x85c [R/W]: DMA_BD_FETCH_ERROR_EN_REG
  volatile uint32_t DMA_DATA_ERROR_STATUS_REG;  ///< 0x860 [W]: DMA_DATA_ERROR_STATUS_REG
  volatile uint32_t DMA_DATA_ERROR_EN_REG;  ///< 0x864 [R/W]: DMA_DATA_ERROR_EN_REG
  volatile uint32_t DMA_ERROR_HANDLING_MODE_REG;  ///< 0x868 [R/W]: DMA_ERROR_HANDLING_MODE_REG
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_0;  ///< 0x86c [R/W]: EP_OUT_RX_DMA_CONFIG_REG_0
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_1;  ///< 0x870 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_1
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_2;  ///< 0x874 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_2
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_3;  ///< 0x878 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_3
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_4;  ///< 0x87c [R/W]: EP_OUT_RX_DMA_CONFIG_REG_4
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_5;  ///< 0x880 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_5
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_6;  ///< 0x884 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_6
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_7;  ///< 0x888 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_7
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_8;  ///< 0x88c [R/W]: EP_OUT_RX_DMA_CONFIG_REG_8
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_9;  ///< 0x890 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_9
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_10;  ///< 0x894 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_10
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_11;  ///< 0x898 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_11
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_12;  ///< 0x89c [R/W]: EP_OUT_RX_DMA_CONFIG_REG_12
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_13;  ///< 0x8a0 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_13
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_14;  ///< 0x8a4 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_14
  volatile uint32_t EP_OUT_RX_DMA_CONFIG_REG_15;  ///< 0x8a8 [R/W]: EP_OUT_RX_DMA_CONFIG_REG_15
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_0;  ///< 0x8ac [R/W]: EP_IN_TX_DMA_CONFIG_REG_0
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_1;  ///< 0x8b0 [R/W]: EP_IN_TX_DMA_CONFIG_REG_1
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_2;  ///< 0x8b4 [R/W]: EP_IN_TX_DMA_CONFIG_REG_2
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_3;  ///< 0x8b8 [R/W]: EP_IN_TX_DMA_CONFIG_REG_3
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_4;  ///< 0x8bc [R/W]: EP_IN_TX_DMA_CONFIG_REG_4
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_5;  ///< 0x8c0 [R/W]: EP_IN_TX_DMA_CONFIG_REG_5
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_6;  ///< 0x8c4 [R/W]: EP_IN_TX_DMA_CONFIG_REG_6
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_7;  ///< 0x8c8 [R/W]: EP_IN_TX_DMA_CONFIG_REG_7
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_8;  ///< 0x8cc [R/W]: EP_IN_TX_DMA_CONFIG_REG_8
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_9;  ///< 0x8d0 [R/W]: EP_IN_TX_DMA_CONFIG_REG_9
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_10;  ///< 0x8d4 [R/W]: EP_IN_TX_DMA_CONFIG_REG_10
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_11;  ///< 0x8d8 [R/W]: EP_IN_TX_DMA_CONFIG_REG_11
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_12;  ///< 0x8dc [R/W]: EP_IN_TX_DMA_CONFIG_REG_12
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_13;  ///< 0x8e0 [R/W]: EP_IN_TX_DMA_CONFIG_REG_13
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_14;  ///< 0x8e4 [R/W]: EP_IN_TX_DMA_CONFIG_REG_14
  volatile uint32_t EP_IN_TX_DMA_CONFIG_REG_15;  ///< 0x8e8 [R/W]: EP_IN_TX_DMA_CONFIG_REG_15
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_0;  ///< 0x8ec [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_0
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_1;  ///< 0x8f0 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_1
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_2;  ///< 0x8f4 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_2
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_3;  ///< 0x8f8 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_3
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_4;  ///< 0x8fc [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_4
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_5;  ///< 0x900 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_5
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_6;  ///< 0x904 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_6
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_7;  ///< 0x908 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_7
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_8;  ///< 0x90c [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_8
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_9;  ///< 0x910 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_9
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_10;  ///< 0x914 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_10
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_11;  ///< 0x918 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_11
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_12;  ///< 0x91c [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_12
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_13;  ///< 0x920 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_13
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_14;  ///< 0x924 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_14
  volatile uint32_t EP_OUT_RX_DMA_START_ADDRESS_REG_15;  ///< 0x928 [R/W]: EP_OUT_RX_DMA_START_ADDRESS_REG_15
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_0;  ///< 0x92c [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_0
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_1;  ///< 0x930 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_1
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_2;  ///< 0x934 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_2
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_3;  ///< 0x938 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_3
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_4;  ///< 0x93c [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_4
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_5;  ///< 0x940 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_5
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_6;  ///< 0x944 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_6
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_7;  ///< 0x948 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_7
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_8;  ///< 0x94c [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_8
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_9;  ///< 0x950 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_9
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_10;  ///< 0x954 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_10
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_11;  ///< 0x958 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_11
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_12;  ///< 0x95c [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_12
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_13;  ///< 0x960 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_13
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_14;  ///< 0x964 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_14
  volatile uint32_t EP_IN_TX_DMA_START_ADDRESS_REG_15;  ///< 0x968 [R/W]: EP_IN_TX_DMA_START_ADDRESS_REG_15
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_0;  ///< 0x96c [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_0
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_1;  ///< 0x970 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_1
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_2;  ///< 0x974 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_2
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_3;  ///< 0x978 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_3
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_4;  ///< 0x97c [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_4
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_5;  ///< 0x980 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_5
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_6;  ///< 0x984 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_6
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_7;  ///< 0x988 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_7
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_8;  ///< 0x98c [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_8
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_9;  ///< 0x990 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_9
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_10;  ///< 0x994 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_10
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_11;  ///< 0x998 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_11
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_12;  ///< 0x99c [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_12
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_13;  ///< 0x9a0 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_13
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_14;  ///< 0x9a4 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_14
  volatile uint32_t EP_OUT_DMA_ERROR_ADDRESS_REG_15;  ///< 0x9a8 [R]: EP_OUT_DMA_ERROR_ADDRESS_REG_15
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_0;  ///< 0x9ac [R]: EP_IN_DMA_ERROR_ADDRESS_REG_0
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_1;  ///< 0x9b0 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_1
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_2;  ///< 0x9b4 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_2
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_3;  ///< 0x9b8 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_3
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_4;  ///< 0x9bc [R]: EP_IN_DMA_ERROR_ADDRESS_REG_4
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_5;  ///< 0x9c0 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_5
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_6;  ///< 0x9c4 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_6
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_7;  ///< 0x9c8 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_7
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_8;  ///< 0x9cc [R]: EP_IN_DMA_ERROR_ADDRESS_REG_8
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_9;  ///< 0x9d0 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_9
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_10;  ///< 0x9d4 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_10
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_11;  ///< 0x9d8 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_11
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_12;  ///< 0x9dc [R]: EP_IN_DMA_ERROR_ADDRESS_REG_12
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_13;  ///< 0x9e0 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_13
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_14;  ///< 0x9e4 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_14
  volatile uint32_t EP_IN_DMA_ERROR_ADDRESS_REG_15;  ///< 0x9e8 [R]: EP_IN_DMA_ERROR_ADDRESS_REG_15
  volatile uint32_t DMA_SUSPEND_REG;  ///< 0x9ec [R/W]: DMA_SUSPEND_REG
  volatile uint32_t DMA_SUSPEND_DONE_REG;  ///< 0x9f0 [W]: DMA_SUSPEND_DONE_REG
  volatile uint32_t DMA_HALT_REG;  ///< 0x9f4 [R/W]: DMA_HALT_REG
  volatile uint32_t DMA_HALT_DONE_REG;  ///< 0x9f8 [W]: DMA_HALT_DONE_REG
  volatile uint32_t AXI_TIMEOUT_VAL_REG_0;  ///< 0x9fc [R/W]: AXI_TIMEOUT_VAL_REG_0
  volatile uint32_t AXI_STATE_REG_1;  ///< 0xa00 [R]: AXI_STATE_REG_1
  volatile uint32_t AXI_STATE_REG_2;  ///< 0xa04 [R]: AXI_STATE_REG_2
  volatile uint32_t AXI_STATE_REG_3;  ///< 0xa08 [R]: AXI_STATE_REG_3
  volatile uint32_t SS_SYS_INT_REG;  ///< 0xa0c [R/W]: SS_SYS_INT_REG
  volatile uint32_t SS_SYS_INT_EN_REG;  ///< 0xa10 [R/W]: SS_SYS_INT_EN_REG
  volatile uint32_t AXI_ERROR_RESPONSE_CODE_REG_1;  ///< 0xa14 [R]: AXI_ERROR_RESPONSE_CODE_REG_1
  volatile uint32_t AXI_ERROR_REPONSE_CODE_REG_2;  ///< 0xa18 [R]: AXI_ERROR_RESPONSE_CODE_REG_2
  volatile uint32_t AXI_ERROR_RESPONSE_CODE_REG_3;  ///< 0xa1c [R]: AXI_ERROR_RESPONSE_CODE_REG_3
  volatile uint32_t AXI_ERROR_RESPONSE_CODE_REG_4;  ///< 0xa20 [R]: AXI_ERROR_RESPONSE_CODE_REG_4
  volatile uint32_t DMA_STATE_REG_1;  ///< 0xa24 [R/W]: DMA_STATE_REG_1
  volatile uint32_t DMA_STATE_REG_2;  ///< 0xa28 [R/W]: DMA_STATE_REG_2
  volatile uint32_t DMA_STATE_REG_3;  ///< 0xa2c [R/W]: DMA_STATE_REG_3
  volatile uint32_t DMA_STATE_REG_4;  ///< 0xa30 [R]: DMA_STATE_REG_4
  volatile uint32_t DMA_STATE_REG_5;  ///< 0xa34 [R]: DMA_STATE_REG_5
  volatile uint32_t SEGMENT_COUNTER_REG_0;  ///< 0xa38 [R]: SEGMENT_COUNTER_REG_0
  volatile uint32_t SEGMENT_COUNTER_REG_1;  ///< 0xa3c [R]: SEGMENT_COUNTER_REG_1
  volatile uint32_t SEGMENT_COUNTER_REG_2;  ///< 0xa40 [R]: SEGMENT_COUNTER_REG_2
  volatile uint32_t SEGMENT_COUNTER_REG_3;  ///< 0xa44 [R]: SEGMENT_COUNTER_REG_3
  volatile uint32_t SEGMENT_COUNTER_REG_4;  ///< 0xa48 [R]: SEGMENT_COUNTER_REG_4
  volatile uint32_t SEGMENT_COUNTER_REG_5;  ///< 0xa4c [R]: SEGMENT_COUNTER_REG_5
  volatile uint32_t SEGMENT_COUNTER_REG_6;  ///< 0xa50 [R]: SEGMENT_COUNTER_REG_6
  volatile uint32_t SEGMENT_COUNTER_REG_7;  ///< 0xa54 [R]: SEGMENT_COUNTER_REG_7
  volatile uint32_t SEGMENT_COUNTER_REG_8;  ///< 0xa58 [R]: SEGMENT_COUNTER_REG_8
  volatile uint32_t SEGMENT_COUNTER_REG_9;  ///< 0xa5c [R]: SEGMENT_COUNTER_REG_9
  volatile uint32_t SEGMENT_COUNTER_REG_10;  ///< 0xa60 [R]: SEGMENT_COUNTER_REG_10
  volatile uint32_t SEGMENT_COUNTER_REG_11;  ///< 0xa64 [R]: SEGMENT_COUNTER_REG_11
  volatile uint32_t SEGMENT_COUNTER_REG_12;  ///< 0xa68 [R]: SEGMENT_COUNTER_REG_12
  volatile uint32_t SEGMENT_COUNTER_REG_13;  ///< 0xa6c [R]: SEGMENT_COUNTER_REG_13
  volatile uint32_t SEGMENT_COUNTER_REG_14;  ///< 0xa70 [R]: SEGMENT_COUNTER_REG_14
  volatile uint32_t SEGMENT_COUNTER_REG_15;  ///< 0xa74 [R]: SEGMENT_COUNTER_REG_15
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_0;  ///< 0xa78 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_0
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_1;  ///< 0xa7c [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_1
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_2;  ///< 0xa80 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_2
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_3;  ///< 0xa84 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_3
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_4;  ///< 0xa88 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_4
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_5;  ///< 0xa8c [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_5
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_6;  ///< 0xa90 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_6
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_7;  ///< 0xa94 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_7
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_8;  ///< 0xa98 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_8
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_9;  ///< 0xa9c [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_9
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_10;  ///< 0xaa0 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_10
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_11;  ///< 0xaa4 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_11
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_12;  ///< 0xaa8 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_12
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_13;  ///< 0xaac [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_13
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_14;  ///< 0xab0 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_14
  volatile uint32_t EP_IN_DONEQ_START_ADDRESS_REG_15;  ///< 0xab4 [R/W]: EP_IN_DONEQ_START_ADDRESS_REG_15
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_0;  ///< 0xab8 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_0
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_1;  ///< 0xabc [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_1
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_2;  ///< 0xac0 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_2
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_3;  ///< 0xac4 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_3
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_4;  ///< 0xac8 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_4
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_5;  ///< 0xacc [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_5
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_6;  ///< 0xad0 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_6
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_7;  ///< 0xad4 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_7
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_8;  ///< 0xad8 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_8
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_9;  ///< 0xadc [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_9
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_10;  ///< 0xae0 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_10
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_11;  ///< 0xae4 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_11
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_12;  ///< 0xae8 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_12
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_13;  ///< 0xaec [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_13
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_14;  ///< 0xaf0 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_14
  volatile uint32_t EP_IN_DONEQ_END_ADDRESS_REG_15;  ///< 0xaf4 [R/W]: EP_IN_DONEQ_END_ADDRESS_REG_15
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_0;  ///< 0xaf8 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_0
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_1;  ///< 0xafc [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_1
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_2;  ///< 0xb00 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_2
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_3;  ///< 0xb04 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_3
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_4;  ///< 0xb08 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_4
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_5;  ///< 0xb0c [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_5
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_6;  ///< 0xb10 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_6
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_7;  ///< 0xb14 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_7
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_8;  ///< 0xb18 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_8
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_9;  ///< 0xb1c [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_9
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_10;  ///< 0xb20 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_10
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_11;  ///< 0xb24 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_11
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_12;  ///< 0xb28 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_12
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_13;  ///< 0xb2c [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_13
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_14;  ///< 0xb30 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_14
  volatile uint32_t EP_OUT_DONEQ_START_ADDRESS_REG_15;  ///< 0xb34 [R/W]: EP_OUT_DONEQ_START_ADDRESS_REG_15
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_0;  ///< 0xb38 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_0
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_1;  ///< 0xb3c [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_1
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_2;  ///< 0xb40 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_2
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_3;  ///< 0xb44 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_3
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_4;  ///< 0xb48 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_4
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_5;  ///< 0xb4c [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_5
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_6;  ///< 0xb50 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_6
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_7;  ///< 0xb54 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_7
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_8;  ///< 0xb58 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_8
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_9;  ///< 0xb5c [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_9
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_10;  ///< 0xb60 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_10
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_11;  ///< 0xb64 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_11
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_12;  ///< 0xb68 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_12
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_13;  ///< 0xb6c [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_13
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_14;  ///< 0xb70 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_14
  volatile uint32_t EP_OUT_DONEQ_END_ADDRESS_REG_15;  ///< 0xb74 [R/W]: EP_OUT_DONEQ_END_ADDRESS_REG_15
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_0;  ///< 0xb78 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_0
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_1;  ///< 0xb7c [R]: EP_IN_DONEQ_WRITE_POINTER_REG_1
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_2;  ///< 0xb80 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_2
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_3;  ///< 0xb84 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_3
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_4;  ///< 0xb88 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_4
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_5;  ///< 0xb8c [R]: EP_IN_DONEQ_WRITE_POINTER_REG_5
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_6;  ///< 0xb90 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_6
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_7;  ///< 0xb94 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_7
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_8;  ///< 0xb98 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_8
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_9;  ///< 0xb9c [R]: EP_IN_DONEQ_WRITE_POINTER_REG_9
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_10;  ///< 0xba0 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_10
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_11;  ///< 0xba4 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_11
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_12;  ///< 0xba8 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_12
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_13;  ///< 0xbac [R]: EP_IN_DONEQ_WRITE_POINTER_REG_13
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_14;  ///< 0xbb0 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_14
  volatile uint32_t EP_IN_DONEQ_WRITE_POINTER_REG_15;  ///< 0xbb4 [R]: EP_IN_DONEQ_WRITE_POINTER_REG_15
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_0;  ///< 0xbb8 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_0
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_1;  ///< 0xbbc [R/W]: EP_IN_DONEQ_READ_POINTER_REG_1
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_2;  ///< 0xbc0 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_2
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_3;  ///< 0xbc4 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_3
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_4;  ///< 0xbc8 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_4
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_5;  ///< 0xbcc [R/W]: EP_IN_DONEQ_READ_POINTER_REG_5
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_6;  ///< 0xbd0 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_6
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_7;  ///< 0xbd4 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_7
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_8;  ///< 0xbd8 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_8
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_9;  ///< 0xbdc [R/W]: EP_IN_DONEQ_READ_POINTER_REG_9
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_10;  ///< 0xbe0 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_10
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_11;  ///< 0xbe4 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_11
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_12;  ///< 0xbe8 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_12
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_13;  ///< 0xbec [R/W]: EP_IN_DONEQ_READ_POINTER_REG_13
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_14;  ///< 0xbf0 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_14
  volatile uint32_t EP_IN_DONEQ_READ_POINTER_REG_15;  ///< 0xbf4 [R/W]: EP_IN_DONEQ_READ_POINTER_REG_15
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_0;  ///< 0xbf8 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_0
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_1;  ///< 0xbfc [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_1
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_2;  ///< 0xc00 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_2
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_3;  ///< 0xc04 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_3
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_4;  ///< 0xc08 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_4
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_5;  ///< 0xc0c [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_5
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_6;  ///< 0xc10 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_6
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_7;  ///< 0xc14 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_7
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_8;  ///< 0xc18 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_8
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_9;  ///< 0xc1c [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_9
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_10;  ///< 0xc20 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_10
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_11;  ///< 0xc24 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_11
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_12;  ///< 0xc28 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_12
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_13;  ///< 0xc2c [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_13
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_14;  ///< 0xc30 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_14
  volatile uint32_t EP_OUT_DONEQ_WRITE_POINTER_REG_15;  ///< 0xc34 [R]: EP_OUT_DONEQ_WRITE_POINTER_REG_15
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_0;  ///< 0xc38 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_0
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_1;  ///< 0xc3c [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_1
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_2;  ///< 0xc40 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_2
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_3;  ///< 0xc44 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_3
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_4;  ///< 0xc48 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_4
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_5;  ///< 0xc4c [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_5
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_6;  ///< 0xc50 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_6
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_7;  ///< 0xc54 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_7
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_8;  ///< 0xc58 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_8
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_9;  ///< 0xc5c [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_9
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_10;  ///< 0xc60 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_10
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_11;  ///< 0xc64 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_11
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_12;  ///< 0xc68 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_12
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_13;  ///< 0xc6c [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_13
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_14;  ///< 0xc70 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_14
  volatile uint32_t EP_OUT_DONEQ_READ_POINTER_REG_15;  ///< 0xc74 [R/W]: EP_OUT_DONEQ_READ_POINTER_REG_15
  volatile uint32_t DONEQ_FULL_STATUS_REG;  ///< 0xc78 [R]: DONEQ_FULL_STATUS_REG
  volatile uint32_t ABORT_REQ_STATUS_REG;  ///< 0xc7c [R/W]: ABORT_REQ_STATUS_REG
  volatile uint32_t ABORT_ACK_STATUS_REG;  ///< 0xc80 [R]: ABORT_ACK_STATUS_REG
  volatile uint32_t ABORT_ID_REG_1;  ///< 0xc84 [R/W]: ABORT_ID_REG_1
  volatile uint32_t ABORT_ID_REG_2;  ///< 0xc88 [R/W]: ABORT_ID_REG_2
  volatile uint32_t ABORT_ID_REG_3;  ///< 0xc8c [R/W]: ABORT_ID_REG_3
  volatile uint32_t ABORT_ID_REG_4;  ///< 0xc90 [R/W]: ABORT_ID_REG_4
  volatile uint32_t ABORT_ID_REG_5;  ///< 0xc94 [R/W]: ABORT_ID_REG_5
  volatile uint32_t ABORT_ID_REG_6;  ///< 0xc98 [R/W]: ABORT_ID_REG_6
  volatile uint32_t ABORT_ID_REG_7;  ///< 0xc9c [R/W]: ABORT_ID_REG_7
  volatile uint32_t ABORT_ID_REG_8;  ///< 0xca0 [R/W]: ABORT_ID_REG_8
  volatile uint32_t ABORT_ID_REG_9;  ///< 0xca4 [R/W]: ABORT_ID_REG_9
  volatile uint32_t ABORT_ID_REG_10;  ///< 0xca8 [R/W]: ABORT_ID_REG_10
  volatile uint32_t ABORT_ID_REG_11;  ///< 0xcac [R/W]: ABORT_ID_REG_11
  volatile uint32_t ABORT_ID_REG_12;  ///< 0xcb0 [R/W]: ABORT_ID_REG_12
  volatile uint32_t ABORT_ID_REG_13;  ///< 0xcb4 [R/W]: ABORT_ID_REG_13
  volatile uint32_t ABORT_ID_REG_14;  ///< 0xcb8 [R/W]: ABORT_ID_REG_14
  volatile uint32_t ABORT_ID_REG_15;  ///< 0xcbc [R/W]: ABORT_ID_REG_15
  volatile uint32_t FLUSHED_BD_COUNTER_REG_1;  ///< 0xcc0 [R]: FLUSHED_BD_COUNTER_REG_1
  volatile uint32_t FLUSHED_BD_COUNTER_REG_2;  ///< 0xcc4 [R]: FLUSHED_BD_COUNTER_REG_2
  volatile uint32_t FLUSHED_BD_COUNTER_REG_3;  ///< 0xcc8 [R]: FLUSHED_BD_COUNTER_REG_3
  volatile uint32_t FLUSHED_BD_COUNTER_REG_4;  ///< 0xccc [R]: FLUSHED_BD_COUNTER_REG_4
  volatile uint32_t FLUSHED_BD_COUNTER_REG_5;  ///< 0xcd0 [R]: FLUSHED_BD_COUNTER_REG_5
  volatile uint32_t FLUSHED_BD_COUNTER_REG_6;  ///< 0xcd4 [R]: FLUSHED_BD_COUNTER_REG_6
  volatile uint32_t FLUSHED_BD_COUNTER_REG_7;  ///< 0xcd8 [R]: FLUSHED_BD_COUNTER_REG_7
  volatile uint32_t FLUSHED_BD_COUNTER_REG_8;  ///< 0xcdc [R]: FLUSHED_BD_COUNTER_REG_8
  volatile uint32_t FLUSHED_BD_COUNTER_REG_9;  ///< 0xce0 [R]: FLUSHED_BD_COUNTER_REG_9
  volatile uint32_t FLUSHED_BD_COUNTER_REG_10;  ///< 0xce4 [R]: FLUSHED_BD_COUNTER_REG_10
  volatile uint32_t FLUSHED_BD_COUNTER_REG_11;  ///< 0xce8 [R]: FLUSHED_BD_COUNTER_REG_11
  volatile uint32_t FLUSHED_BD_COUNTER_REG_12;  ///< 0xcec [R]: FLUSHED_BD_COUNTER_REG_12
  volatile uint32_t FLUSHED_BD_COUNTER_REG_13;  ///< 0xcf0 [R]: FLUSHED_BD_COUNTER_REG_13
  volatile uint32_t FLUSHED_BD_COUNTER_REG_14;  ///< 0xcf4 [R]: FLUSHED_BD_COUNTER_REG_14
  volatile uint32_t FLUSHED_BD_COUNTER_REG_15;  ///< 0xcf8 [R]: FLUSHED_BD_COUNTER_REG_15
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_1;  ///< 0xcfc [R]: EP_IN_FLUSHED_SID_BITMAP_REG_1
  volatile uint32_t reserved4[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_2;  ///< 0xd1c [R]: EP_IN_FLUSHED_SID_BITMAP_REG_2
  volatile uint32_t reserved5[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_3;  ///< 0xd3c [R]: EP_IN_FLUSHED_SID_BITMAP_REG_3
  volatile uint32_t reserved6[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_4;  ///< 0xd5c [R]: EP_IN_FLUSHED_SID_BITMAP_REG_4
  volatile uint32_t reserved7[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_5;  ///< 0xd7c [R]: EP_IN_FLUSHED_SID_BITMAP_REG_5
  volatile uint32_t reserved8[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_6;  ///< 0xd9c [R]: EP_IN_FLUSHED_SID_BITMAP_REG_6
  volatile uint32_t reserved9[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_7;  ///< 0xdbc [R]: EP_IN_FLUSHED_SID_BITMAP_REG_7
  volatile uint32_t reserved10[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_8;  ///< 0xddc [R]: EP_IN_FLUSHED_SID_BITMAP_REG_8
  volatile uint32_t reserved11[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_9;  ///< 0xdfc [R]: EP_IN_FLUSHED_SID_BITMAP_REG_9
  volatile uint32_t reserved12[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_10;  ///< 0xe1c [R]: EP_IN_FLUSHED_SID_BITMAP_REG_10
  volatile uint32_t reserved13[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_11;  ///< 0xe3c [R]: EP_IN_FLUSHED_SID_BITMAP_REG_11
  volatile uint32_t reserved14[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_12;  ///< 0xe5c [R]: EP_IN_FLUSHED_SID_BITMAP_REG_12
  volatile uint32_t reserved15[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_13;  ///< 0xe7c [R]: EP_IN_FLUSHED_SID_BITMAP_REG_13
  volatile uint32_t reserved16[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_14;  ///< 0xe9c [R]: EP_IN_FLUSHED_SID_BITMAP_REG_14
  volatile uint32_t reserved17[7];
  volatile uint32_t EP_IN_FLUSHED_SID_BITMAP_REG_15;  ///< 0xebc [R]: EP_IN_FLUSHED_SID_BITMAP_REG_15
  volatile uint32_t reserved18[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_1;  ///< 0xedc [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_1
  volatile uint32_t reserved19[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_2;  ///< 0xefc [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_2
  volatile uint32_t reserved20[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_3;  ///< 0xf1c [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_3
  volatile uint32_t reserved21[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_4;  ///< 0xf3c [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_4
  volatile uint32_t reserved22[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_5;  ///< 0xf5c [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_5
  volatile uint32_t reserved23[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_6;  ///< 0xf7c [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_6
  volatile uint32_t reserved24[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_7;  ///< 0xf9c [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_7
  volatile uint32_t reserved25[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_8;  ///< 0xfbc [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_8
  volatile uint32_t reserved26[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_9;  ///< 0xfdc [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_9
  volatile uint32_t reserved27[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_10;  ///< 0xffc [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_10
  volatile uint32_t reserved28[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_11;  ///< 0x101c [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_11
  volatile uint32_t reserved29[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_12;  ///< 0x103c [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_12
  volatile uint32_t reserved30[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_13;  ///< 0x105c [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_13
  volatile uint32_t reserved31[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_14;  ///< 0x107c [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_14
  volatile uint32_t reserved32[7];
  volatile uint32_t EP_OUT_FLUSHED_SID_BITMAP_REG_15;  ///< 0x109c [R]: EP_OUT_FLUSHED_SID_BITMAP_REG_15
  volatile uint32_t reserved33[7];
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_1;  ///< 0x10bc [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_1
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_2;  ///< 0x10c0 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_2
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_3;  ///< 0x10c4 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_3
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_4;  ///< 0x10c8 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_4
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_5;  ///< 0x10cc [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_5
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_6;  ///< 0x10d0 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_6
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_7;  ///< 0x10d4 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_7
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_8;  ///< 0x10d8 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_8
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_9;  ///< 0x10dc [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_9
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_10;  ///< 0x10e0 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_10
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_11;  ///< 0x10e4 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_11
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_12;  ///< 0x10e8 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_12
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_13;  ///< 0x10ec [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_13
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_14;  ///< 0x10f0 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_14
  volatile uint32_t EP_IN_NRDYQ_HEAD_POINTER_REG_15;  ///< 0x10f4 [R]: EP_IN_NRDYQ_HEAD_POINTER_REG_15
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_1;  ///< 0x10f8 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_1
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_2;  ///< 0x10fc [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_2
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_3;  ///< 0x1100 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_3
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_4;  ///< 0x1104 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_4
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_5;  ///< 0x1108 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_5
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_6;  ///< 0x110c [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_6
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_7;  ///< 0x1110 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_7
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_8;  ///< 0x1114 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_8
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_9;  ///< 0x1118 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_9
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_10;  ///< 0x111c [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_10
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_11;  ///< 0x1120 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_11
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_12;  ///< 0x1124 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_12
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_13;  ///< 0x1128 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_13
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_14;  ///< 0x112c [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_14
  volatile uint32_t EP_OUT_NRDYQ_HEAD_POINTER_REG_15;  ///< 0x1130 [R]: EP_OUT_NRDYQ_HEAD_POINTER_REG_15
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_1;  ///< 0x1134 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_1
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_2;  ///< 0x1138 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_2
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_3;  ///< 0x113c [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_3
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_4;  ///< 0x1140 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_4
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_5;  ///< 0x1144 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_5
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_6;  ///< 0x1148 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_6
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_7;  ///< 0x114c [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_7
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_8;  ///< 0x1150 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_8
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_9;  ///< 0x1154 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_9
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_10;  ///< 0x1158 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_10
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_11;  ///< 0x115c [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_11
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_12;  ///< 0x1160 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_12
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_13;  ///< 0x1164 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_13
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_14;  ///< 0x1168 [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_14
  volatile uint32_t EP_IN_NRDYQ_TAIL_POINTER_REG_15;  ///< 0x116c [R]: EP_IN_NRDYQ_TAIL_POINTER_REG_15
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_1;  ///< 0x1170 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_1
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_2;  ///< 0x1174 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_2
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_3;  ///< 0x1178 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_3
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_4;  ///< 0x117c [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_4
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_5;  ///< 0x1180 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_5
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_6;  ///< 0x1184 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_6
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_7;  ///< 0x1188 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_7
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_8;  ///< 0x118c [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_8
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_9;  ///< 0x1190 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_9
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_10;  ///< 0x1194 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_10
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_11;  ///< 0x1198 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_11
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_12;  ///< 0x119c [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_12
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_13;  ///< 0x11a0 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_13
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_14;  ///< 0x11a4 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_14
  volatile uint32_t EP_OUT_NRDYQ_TAIL_POINTER_REG_15;  ///< 0x11a8 [R]: EP_OUT_NRDYQ_TAIL_POINTER_REG_15
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_1;  ///< 0x11ac [R]: EP_IN_RDYQ_HEAD_POINTER_REG_1
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_2;  ///< 0x11b0 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_2
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_3;  ///< 0x11b4 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_3
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_4;  ///< 0x11b8 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_4
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_5;  ///< 0x11bc [R]: EP_IN_RDYQ_HEAD_POINTER_REG_5
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_6;  ///< 0x11c0 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_6
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_7;  ///< 0x11c4 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_7
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_8;  ///< 0x11c8 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_8
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_9;  ///< 0x11cc [R]: EP_IN_RDYQ_HEAD_POINTER_REG_9
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_10;  ///< 0x11d0 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_10
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_11;  ///< 0x11d4 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_11
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_12;  ///< 0x11d8 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_12
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_13;  ///< 0x11dc [R]: EP_IN_RDYQ_HEAD_POINTER_REG_13
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_14;  ///< 0x11e0 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_14
  volatile uint32_t EP_IN_RDYQ_HEAD_POINTER_REG_15;  ///< 0x11e4 [R]: EP_IN_RDYQ_HEAD_POINTER_REG_15
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_1;  ///< 0x11e8 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_1
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_2;  ///< 0x11ec [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_2
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_3;  ///< 0x11f0 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_3
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_4;  ///< 0x11f4 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_4
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_5;  ///< 0x11f8 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_5
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_6;  ///< 0x11fc [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_6
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_7;  ///< 0x1200 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_7
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_8;  ///< 0x1204 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_8
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_9;  ///< 0x1208 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_9
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_10;  ///< 0x120c [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_10
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_11;  ///< 0x1210 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_11
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_12;  ///< 0x1214 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_12
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_13;  ///< 0x1218 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_13
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_14;  ///< 0x121c [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_14
  volatile uint32_t EP_OUT_RDYQ_HEAD_POINTER_REG_15;  ///< 0x1220 [R]: EP_OUT_RDYQ_HEAD_POINTER_REG_15
  volatile uint32_t BULK_STREAMING_INT_STATUS_REG;  ///< 0x1224 [R]: BULK_STREAMING_INT_STATUS_REG
  volatile uint32_t BULK_STREAMING_INT_ENABLE_REG;  ///< 0x1228 [R/W]: BULK_STREAMING_INT_ENABLE_REG
  volatile uint32_t PRIME_RCV_STATUS_REG;  ///< 0x122c [R/W]: PRIME_RCV_STATUS_REG
  volatile uint32_t HIMD_RCV_STATUS_REG;  ///< 0x1230 [R/W]: HIMD_RCV_STATUS_REG
  volatile uint32_t STREAM_REJ_STATUS_REG;  ///< 0x1234 [R/W]: STREAM_REJ_STATUS_REG
  volatile uint32_t HOST_FLOWCTRL_STATUS_REG;  ///< 0x1238 [R/W]: HOST_FLOWCTRL_STATUS_REG
  volatile uint32_t BD_MEM_IN_REG_1;  ///< 0x123c [R]: BD_MEM_IN_REG_1
  volatile uint32_t reserved34[9];
  volatile uint32_t PL_DEBUG_REG_1;  ///< 0x1264 [R]: PL_DEBUG_REG_1
  volatile uint32_t PL_DEBUG_REG_2;  ///< 0x1268 [R]: PL_DEBUG_REG_2
  volatile uint32_t PL_DEBUG_REG_3;  ///< 0x126c [R]: PL_DEBUG_REG_3
  volatile uint32_t PL_DEBUG_REG_4;  ///< 0x1270 [R]: PL_DEBUG_REG_4
  volatile uint32_t DMA_DBG_IN_REG_1;  ///< 0x1274 [R]: DMA_DBG_IN_REG_1
  volatile uint32_t DMA_DBG_IN_REG_2;  ///< 0x1278 [R]: DMA_DBG_IN_REG_1
  volatile uint32_t DMA_DBG_OUT_REG_1;  ///< 0x127c [R]: DMA_DBG_OUT_REG_1
  volatile uint32_t DMA_DBG_OUT_REG_2;  ///< 0x1280 [R]: DMA_DBG_IN_REG_1
  volatile uint32_t DMA_ENABLE;  ///< 0x1284 [R/W]: DMA_ENABLE
} USB3D_SS_REGS_t;

//====================================================================
//
//Register File: USB 3.0 device legacy speed registers (USB2D)
//
//====================================================================

typedef struct USB2D_REGS_s
{
  volatile uint32_t ID;  ///< 0x0 [R]: Identification Register
  volatile uint32_t HWGENERAL;  ///< 0x4 [R]: ChipIdea General Hardware Parameters Register
  volatile uint32_t reserved0;
  volatile uint32_t HWDEVICE;  ///< 0xc [R]: Device Hardware Parameters Register
  volatile uint32_t HWTXBUF;  ///< 0x10 [R]: TX Buffer Parameters Register
  volatile uint32_t HWRXBUF;  ///< 0x14 [R]: RX Buffer Parameters Register
  volatile uint32_t reserved1[26];
  volatile uint32_t GPTIMER0LD;  ///< 0x80 [R/W]: Timer 0 Duration Register
  volatile uint32_t GPTIMER0CTRL;  ///< 0x84 [R/W]: Timer 0 Control Register
  volatile uint32_t GPTIMER1LD;  ///< 0x88 [R/W]: Timer 1 Duration Register
  volatile uint32_t GPTIMER1CTRL;  ///< 0x8c [R/W]: Timer 1 Control Register
  volatile uint32_t SBUSCFG;  ///< 0x90 [R/W]: System Bus Control Register
  volatile uint32_t reserved2[27];
  volatile uint32_t HCIV_CAPLENGTH;  ///< 0x100 [R]: EHCI Version / Capability Length Register
  volatile uint32_t reserved3[7];
  volatile uint32_t DCIVERSION;  ///< 0x120 [R]: Device Controller Version Register
  volatile uint32_t DCCPARAMS;  ///< 0x124 [R]: Device Capability Register
  volatile uint32_t reserved4[6];
  volatile uint32_t USBCMD;  ///< 0x140 [R/W]: USB Command Register
  volatile uint32_t USBSTS;  ///< 0x144 [R/W]: USB Status Register
  volatile uint32_t USBINTR;  ///< 0x148 [R/W]: USB Interrupt Register
  volatile uint32_t FRINDEX;  ///< 0x14c [R]: Frame Index Register
  volatile uint32_t reserved5;
  volatile uint32_t DEVICEADDR;  ///< 0x154 [R/W]: Device Address Register
  volatile uint32_t EPLISTADDR;  ///< 0x158 [R/W]: Endpoint List Address Register
  volatile uint32_t reserved6;
  volatile uint32_t BURSTSIZE;  ///< 0x160 [R/W]: Burst Size Register
  volatile uint32_t reserved7[5];
  volatile uint32_t ENDPTNAK;  ///< 0x178 [R/W]: Endpoint NAK Register
  volatile uint32_t ENDPTNAKEN;  ///< 0x17c [R/W]: Endpoint NAK Enable Register
  volatile uint32_t reserved8;
  volatile uint32_t PORTSC;  ///< 0x184 [R/W]: Port Status Control Register
  volatile uint32_t reserved9[8];
  volatile uint32_t USBMODE;  ///< 0x1a8 [R/W]: USB Device Mode Register
  volatile uint32_t ENDPTSETUPSTAT;  ///< 0x1ac [R/W]: Endpoint Setup Status Register
  volatile uint32_t ENDPTPRIME;  ///< 0x1b0 [R/W]: Endpoint Initialization Register
  volatile uint32_t ENDPTFLUSH;  ///< 0x1b4 [R/W]: Endpoint De-Initialize Register
  volatile uint32_t ENDPTSTAT;  ///< 0x1b8 [R]: Endpoint Status Register
  volatile uint32_t ENDPTCOMPLETE;  ///< 0x1bc [R/W]: Endpoint Complete Register
  volatile uint32_t ENDPTCTRL_0;  ///< 0x1c0 [R/W]: Endpoint Control 0 Register
  volatile uint32_t ENDPTCTRL1;  ///< 0x1c4 [R/W]: Endpoint Control Register (Instance 1 of 15)
  volatile uint32_t ENDPTCTRL2;  ///< 0x1c8 [R/W]: Endpoint Control Register (Instance 2 of 15)
  volatile uint32_t ENDPTCTRL3;  ///< 0x1cc [R/W]: Endpoint Control Register (Instance 3 of 15)
  volatile uint32_t ENDPTCTRL4;  ///< 0x1d0 [R/W]: Endpoint Control Register (Instance 4 of 15)
  volatile uint32_t ENDPTCTRL5;  ///< 0x1d4 [R/W]: Endpoint Control Register (Instance 5 of 15)
  volatile uint32_t ENDPTCTRL6;  ///< 0x1d8 [R/W]: Endpoint Control Register (Instance 6 of 15)
  volatile uint32_t ENDPTCTRL7;  ///< 0x1dc [R/W]: Endpoint Control Register (Instance 7 of 15)
  volatile uint32_t ENDPTCTRL8;  ///< 0x1e0 [R/W]: Endpoint Control Register (Instance 8 of 15)
  volatile uint32_t ENDPTCTRL9;  ///< 0x1e4 [R/W]: Endpoint Control Register (Instance 9 of 15)
  volatile uint32_t ENDPTCTRL10;  ///< 0x1e8 [R/W]: Endpoint Control Register (Instance 10 of 15)
  volatile uint32_t ENDPTCTRL11;  ///< 0x1ec [R/W]: Endpoint Control Register (Instance 11 of 15)
  volatile uint32_t ENDPTCTRL12;  ///< 0x1f0 [R/W]: Endpoint Control Register (Instance 12 of 15)
  volatile uint32_t ENDPTCTRL13;  ///< 0x1f4 [R/W]: Endpoint Control Register (Instance 13 of 15)
  volatile uint32_t ENDPTCTRL14;  ///< 0x1f8 [R/W]: Endpoint Control Register (Instance 14 of 15)
  volatile uint32_t ENDPTCTRL15;  ///< 0x1fc [R/W]: Endpoint Control Register (Instance 15 of 15)
} USB2D_REGS_t;

#endif // USB3D
