 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file USB3D_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _USB3D_REGMASKS_H_
#define _USB3D_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: USB3D (USB3D)
//
//====================================================================

//====================================================================
//
//Register File: USB 3.0 device SuperSpeed registers (USB3D_SS)
//
//====================================================================

//====================================================================
//Register: DEV_INFO_REG (DEV_INFO_REG)
//====================================================================

#define  USB3D_SS_DEV_INFO_REG_RESERVED1_MASK 0xfffc0000
#define  USB3D_SS_DEV_INFO_REG_RESERVED1_SHIFT 18
#define  USB3D_SS_DEV_INFO_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DEV_INFO_REG_RESERVED1_MASK) >> USB3D_SS_DEV_INFO_REG_RESERVED1_SHIFT)
#define  USB3D_SS_DEV_INFO_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DEV_INFO_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_DEV_INFO_REG_RESERVED1_SHIFT))

#define  USB3D_SS_DEV_INFO_REG_DEVICE_SPEED_MASK 0x30000
#define  USB3D_SS_DEV_INFO_REG_DEVICE_SPEED_SHIFT 16
#define  USB3D_SS_DEV_INFO_REG_DEVICE_SPEED_MASK_SHIFT(reg) (((reg) & USB3D_SS_DEV_INFO_REG_DEVICE_SPEED_MASK) >> USB3D_SS_DEV_INFO_REG_DEVICE_SPEED_SHIFT)
#define  USB3D_SS_DEV_INFO_REG_DEVICE_SPEED_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DEV_INFO_REG_DEVICE_SPEED_MASK) | (((uint32_t)val) << USB3D_SS_DEV_INFO_REG_DEVICE_SPEED_SHIFT))

#define  USB3D_SS_DEV_INFO_REG_VERSION_ID_MASK 0xffff
#define  USB3D_SS_DEV_INFO_REG_VERSION_ID_SHIFT 0
#define  USB3D_SS_DEV_INFO_REG_VERSION_ID_MASK_SHIFT(reg) (((reg) & USB3D_SS_DEV_INFO_REG_VERSION_ID_MASK) >> USB3D_SS_DEV_INFO_REG_VERSION_ID_SHIFT)
#define  USB3D_SS_DEV_INFO_REG_VERSION_ID_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DEV_INFO_REG_VERSION_ID_MASK) | (((uint32_t)val) << USB3D_SS_DEV_INFO_REG_VERSION_ID_SHIFT))

//====================================================================
//Register: DEV_TAG_REG (DEV_TAG_REG)
//====================================================================

#define  USB3D_SS_DEV_TAG_REG_RESERVED1_MASK 0xffffffff
#define  USB3D_SS_DEV_TAG_REG_RESERVED1_SHIFT 0
#define  USB3D_SS_DEV_TAG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DEV_TAG_REG_RESERVED1_MASK) >> USB3D_SS_DEV_TAG_REG_RESERVED1_SHIFT)
#define  USB3D_SS_DEV_TAG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DEV_TAG_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_DEV_TAG_REG_RESERVED1_SHIFT))

//====================================================================
//Register: LOW_POWER_LFPS_SIGNAL_VAL_REG_1 (LOW_POWER_LFPS_SIGNAL_VAL_REG_1)
//====================================================================

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED1_MASK 0xf0000000
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED1_SHIFT 28
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED1_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_TX_U1_T12_T11_MASK 0xf000000
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_TX_U1_T12_T11_SHIFT 24
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_TX_U1_T12_T11_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_TX_U1_T12_T11_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_TX_U1_T12_T11_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_TX_U1_T12_T11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_TX_U1_T12_T11_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_TX_U1_T12_T11_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U3_T13_T11_MASK 0xff0000
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U3_T13_T11_SHIFT 16
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U3_T13_T11_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U3_T13_T11_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U3_T13_T11_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U3_T13_T11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U3_T13_T11_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U3_T13_T11_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED2_MASK 0xe000
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED2_SHIFT 13
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED2_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED2_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED2_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U2_T13_T11_MASK 0x1f00
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U2_T13_T11_SHIFT 8
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U2_T13_T11_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U2_T13_T11_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U2_T13_T11_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U2_T13_T11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U2_T13_T11_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_LFPS_RX_U2_T13_T11_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED3_MASK 0xff
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED3_SHIFT 0
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED3_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED3_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_1_RESERVED3_SHIFT))

//====================================================================
//Register: LOW_POWER_LFPS_SIGNAL_VAL_REG_2 (LOW_POWER_LFPS_SIGNAL_VAL_REG_2)
//====================================================================

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED1_MASK 0xff000000
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED1_SHIFT 24
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED1_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U3_T11_T10_MASK 0xff0000
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U3_T11_T10_SHIFT 16
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U3_T11_T10_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U3_T11_T10_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U3_T11_T10_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U3_T11_T10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U3_T11_T10_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U3_T11_T10_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U2_T11_T10_MASK 0xff00
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U2_T11_T10_SHIFT 8
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U2_T11_T10_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U2_T11_T10_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U2_T11_T10_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U2_T11_T10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U2_T11_T10_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U2_T11_T10_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED2_MASK 0xf0
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED2_SHIFT 4
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED2_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED2_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_RESERVED2_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U1_T11_T10_MASK 0xf
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U1_T11_T10_SHIFT 0
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U1_T11_T10_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U1_T11_T10_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U1_T11_T10_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U1_T11_T10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U1_T11_T10_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_2_LFPS_RX_U1_T11_T10_SHIFT))

//====================================================================
//Register: LOW_POWER_LFPS_SIGNAL_VAL_REG_3 (LOW_POWER_LFPS_SIGNAL_VAL_REG_3)
//====================================================================

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U3_T11_T10_MASK 0xffff8000
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U3_T11_T10_SHIFT 15
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U3_T11_T10_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U3_T11_T10_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U3_T11_T10_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U3_T11_T10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U3_T11_T10_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U3_T11_T10_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U2_T11_T10_MASK 0x7fff
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U2_T11_T10_SHIFT 0
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U2_T11_T10_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U2_T11_T10_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U2_T11_T10_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U2_T11_T10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U2_T11_T10_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_3_LFPS_TX_U2_T11_T10_SHIFT))

//====================================================================
//Register: LOW_POWER_LFPS_SIGNAL_VAL_REG_4 (LOW_POWER_LFPS_SIGNAL_VAL_REG_4)
//====================================================================

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U3_T12_T11_MASK 0xffff8000
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U3_T12_T11_SHIFT 15
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U3_T12_T11_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U3_T12_T11_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U3_T12_T11_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U3_T12_T11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U3_T12_T11_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U3_T12_T11_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U2_T12_T11_MASK 0x7fff
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U2_T12_T11_SHIFT 0
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U2_T12_T11_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U2_T12_T11_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U2_T12_T11_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U2_T12_T11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U2_T12_T11_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_4_LFPS_TX_U2_T12_T11_SHIFT))

//====================================================================
//Register: LOW_POWER_LFPS_SIGNAL_VAL_REG_5 (LOW_POWER_LFPS_SIGNAL_VAL_REG_5)
//====================================================================

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_TX_U1_T11_T10_MASK 0xffff0000
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_TX_U1_T11_T10_SHIFT 16
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_TX_U1_T11_T10_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_TX_U1_T11_T10_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_TX_U1_T11_T10_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_TX_U1_T11_T10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_TX_U1_T11_T10_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_TX_U1_T11_T10_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_RX_U1_T13_T11_MASK 0xffff
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_RX_U1_T13_T11_SHIFT 0
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_RX_U1_T13_T11_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_RX_U1_T13_T11_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_RX_U1_T13_T11_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_RX_U1_T13_T11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_RX_U1_T13_T11_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_5_LFPS_RX_U1_T13_T11_SHIFT))

//====================================================================
//Register: LOW_POWER_LFPS_SIGNAL_VAL_REG_6 (LOW_POWER_LFPS_SIGNAL_VAL_REG_6)
//====================================================================

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL2_MASK 0xffff0000
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL2_SHIFT 16
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL2_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL2_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL2_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL2_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL2_SHIFT))

#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL1_MASK 0xffff
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL1_SHIFT 0
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL1_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL1_MASK) >> USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL1_SHIFT)
#define  USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL1_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_LFPS_SIGNAL_VAL_REG_6_LFPS_RX_U1_T13_T11_VAL1_SHIFT))

//====================================================================
//Register: COUNTER_PULSE_VALUE_REG (COUNTER_PULSE_VALUE_REG)
//====================================================================

#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100NS_MASK 0xff000000
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100NS_SHIFT 24
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100NS_MASK_SHIFT(reg) (((reg) & USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100NS_MASK) >> USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100NS_SHIFT)
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100NS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100NS_MASK) | (((uint32_t)val) << USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100NS_SHIFT))

#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_RESERVED1_MASK 0xf00000
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_RESERVED1_SHIFT 20
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_COUNTER_PULSE_VALUE_REG_RESERVED1_MASK) >> USB3D_SS_COUNTER_PULSE_VALUE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_COUNTER_PULSE_VALUE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_COUNTER_PULSE_VALUE_REG_RESERVED1_SHIFT))

#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10MS_MASK 0xf0000
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10MS_SHIFT 16
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10MS_MASK_SHIFT(reg) (((reg) & USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10MS_MASK) >> USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10MS_SHIFT)
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10MS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10MS_MASK) | (((uint32_t)val) << USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10MS_SHIFT))

#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1MS_MASK 0xf000
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1MS_SHIFT 12
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1MS_MASK_SHIFT(reg) (((reg) & USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1MS_MASK) >> USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1MS_SHIFT)
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1MS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1MS_MASK) | (((uint32_t)val) << USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1MS_SHIFT))

#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100US_MASK 0xf00
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100US_SHIFT 8
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100US_MASK_SHIFT(reg) (((reg) & USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100US_MASK) >> USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100US_SHIFT)
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100US_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100US_MASK) | (((uint32_t)val) << USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_100US_SHIFT))

#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10US_MASK 0xf0
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10US_SHIFT 4
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10US_MASK_SHIFT(reg) (((reg) & USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10US_MASK) >> USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10US_SHIFT)
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10US_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10US_MASK) | (((uint32_t)val) << USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_10US_SHIFT))

#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1US_MASK 0xf
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1US_SHIFT 0
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1US_MASK_SHIFT(reg) (((reg) & USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1US_MASK) >> USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1US_SHIFT)
#define  USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1US_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1US_MASK) | (((uint32_t)val) << USB3D_SS_COUNTER_PULSE_VALUE_REG_USB3_COUNTER_PULSE_1US_SHIFT))

//====================================================================
//Register: REF_INT_STATUS_REG (REF_INT_STATUS_REG)
//====================================================================

#define  USB3D_SS_REF_INT_STATUS_REG_USB2_CNT_STAT_MASK 0x80000000
#define  USB3D_SS_REF_INT_STATUS_REG_USB2_CNT_STAT_SHIFT 31
#define  USB3D_SS_REF_INT_STATUS_REG_USB2_CNT_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_STATUS_REG_USB2_CNT_STAT_MASK) >> USB3D_SS_REF_INT_STATUS_REG_USB2_CNT_STAT_SHIFT)
#define  USB3D_SS_REF_INT_STATUS_REG_USB2_CNT_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_STATUS_REG_USB2_CNT_STAT_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_STATUS_REG_USB2_CNT_STAT_SHIFT))

#define  USB3D_SS_REF_INT_STATUS_REG_USB2_DISCNT_STAT_MASK 0x40000000
#define  USB3D_SS_REF_INT_STATUS_REG_USB2_DISCNT_STAT_SHIFT 30
#define  USB3D_SS_REF_INT_STATUS_REG_USB2_DISCNT_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_STATUS_REG_USB2_DISCNT_STAT_MASK) >> USB3D_SS_REF_INT_STATUS_REG_USB2_DISCNT_STAT_SHIFT)
#define  USB3D_SS_REF_INT_STATUS_REG_USB2_DISCNT_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_STATUS_REG_USB2_DISCNT_STAT_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_STATUS_REG_USB2_DISCNT_STAT_SHIFT))

#define  USB3D_SS_REF_INT_STATUS_REG_RESUME_REC_MASK 0x20000000
#define  USB3D_SS_REF_INT_STATUS_REG_RESUME_REC_SHIFT 29
#define  USB3D_SS_REF_INT_STATUS_REG_RESUME_REC_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_STATUS_REG_RESUME_REC_MASK) >> USB3D_SS_REF_INT_STATUS_REG_RESUME_REC_SHIFT)
#define  USB3D_SS_REF_INT_STATUS_REG_RESUME_REC_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_STATUS_REG_RESUME_REC_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_STATUS_REG_RESUME_REC_SHIFT))

#define  USB3D_SS_REF_INT_STATUS_REG_SUSPEND_REC_MASK 0x10000000
#define  USB3D_SS_REF_INT_STATUS_REG_SUSPEND_REC_SHIFT 28
#define  USB3D_SS_REF_INT_STATUS_REG_SUSPEND_REC_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_STATUS_REG_SUSPEND_REC_MASK) >> USB3D_SS_REF_INT_STATUS_REG_SUSPEND_REC_SHIFT)
#define  USB3D_SS_REF_INT_STATUS_REG_SUSPEND_REC_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_STATUS_REG_SUSPEND_REC_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_STATUS_REG_SUSPEND_REC_SHIFT))

#define  USB3D_SS_REF_INT_STATUS_REG_RESET_REC_MASK 0x8000000
#define  USB3D_SS_REF_INT_STATUS_REG_RESET_REC_SHIFT 27
#define  USB3D_SS_REF_INT_STATUS_REG_RESET_REC_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_STATUS_REG_RESET_REC_MASK) >> USB3D_SS_REF_INT_STATUS_REG_RESET_REC_SHIFT)
#define  USB3D_SS_REF_INT_STATUS_REG_RESET_REC_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_STATUS_REG_RESET_REC_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_STATUS_REG_RESET_REC_SHIFT))

#define  USB3D_SS_REF_INT_STATUS_REG_POWER_ON_REC_MASK 0x4000000
#define  USB3D_SS_REF_INT_STATUS_REG_POWER_ON_REC_SHIFT 26
#define  USB3D_SS_REF_INT_STATUS_REG_POWER_ON_REC_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_STATUS_REG_POWER_ON_REC_MASK) >> USB3D_SS_REF_INT_STATUS_REG_POWER_ON_REC_SHIFT)
#define  USB3D_SS_REF_INT_STATUS_REG_POWER_ON_REC_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_STATUS_REG_POWER_ON_REC_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_STATUS_REG_POWER_ON_REC_SHIFT))

#define  USB3D_SS_REF_INT_STATUS_REG_POWER_OFF_REC_MASK 0x2000000
#define  USB3D_SS_REF_INT_STATUS_REG_POWER_OFF_REC_SHIFT 25
#define  USB3D_SS_REF_INT_STATUS_REG_POWER_OFF_REC_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_STATUS_REG_POWER_OFF_REC_MASK) >> USB3D_SS_REF_INT_STATUS_REG_POWER_OFF_REC_SHIFT)
#define  USB3D_SS_REF_INT_STATUS_REG_POWER_OFF_REC_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_STATUS_REG_POWER_OFF_REC_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_STATUS_REG_POWER_OFF_REC_SHIFT))

#define  USB3D_SS_REF_INT_STATUS_REG_RESERVED1_MASK 0x1ffffff
#define  USB3D_SS_REF_INT_STATUS_REG_RESERVED1_SHIFT 0
#define  USB3D_SS_REF_INT_STATUS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_STATUS_REG_RESERVED1_MASK) >> USB3D_SS_REF_INT_STATUS_REG_RESERVED1_SHIFT)
#define  USB3D_SS_REF_INT_STATUS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_STATUS_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_STATUS_REG_RESERVED1_SHIFT))

//====================================================================
//Register: REF_INT_ENABLE_REG (REF_INT_ENABLE_REG)
//====================================================================

#define  USB3D_SS_REF_INT_ENABLE_REG_USB2_CNT_STAT_EN_MASK 0x80000000
#define  USB3D_SS_REF_INT_ENABLE_REG_USB2_CNT_STAT_EN_SHIFT 31
#define  USB3D_SS_REF_INT_ENABLE_REG_USB2_CNT_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_ENABLE_REG_USB2_CNT_STAT_EN_MASK) >> USB3D_SS_REF_INT_ENABLE_REG_USB2_CNT_STAT_EN_SHIFT)
#define  USB3D_SS_REF_INT_ENABLE_REG_USB2_CNT_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_ENABLE_REG_USB2_CNT_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_ENABLE_REG_USB2_CNT_STAT_EN_SHIFT))

#define  USB3D_SS_REF_INT_ENABLE_REG_USB2_DISCNT_STAT_EN_MASK 0x40000000
#define  USB3D_SS_REF_INT_ENABLE_REG_USB2_DISCNT_STAT_EN_SHIFT 30
#define  USB3D_SS_REF_INT_ENABLE_REG_USB2_DISCNT_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_ENABLE_REG_USB2_DISCNT_STAT_EN_MASK) >> USB3D_SS_REF_INT_ENABLE_REG_USB2_DISCNT_STAT_EN_SHIFT)
#define  USB3D_SS_REF_INT_ENABLE_REG_USB2_DISCNT_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_ENABLE_REG_USB2_DISCNT_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_ENABLE_REG_USB2_DISCNT_STAT_EN_SHIFT))

#define  USB3D_SS_REF_INT_ENABLE_REG_RESUME_REC_EN_MASK 0x20000000
#define  USB3D_SS_REF_INT_ENABLE_REG_RESUME_REC_EN_SHIFT 29
#define  USB3D_SS_REF_INT_ENABLE_REG_RESUME_REC_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_ENABLE_REG_RESUME_REC_EN_MASK) >> USB3D_SS_REF_INT_ENABLE_REG_RESUME_REC_EN_SHIFT)
#define  USB3D_SS_REF_INT_ENABLE_REG_RESUME_REC_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_ENABLE_REG_RESUME_REC_EN_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_ENABLE_REG_RESUME_REC_EN_SHIFT))

#define  USB3D_SS_REF_INT_ENABLE_REG_SUSPEND_REC_EN_MASK 0x10000000
#define  USB3D_SS_REF_INT_ENABLE_REG_SUSPEND_REC_EN_SHIFT 28
#define  USB3D_SS_REF_INT_ENABLE_REG_SUSPEND_REC_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_ENABLE_REG_SUSPEND_REC_EN_MASK) >> USB3D_SS_REF_INT_ENABLE_REG_SUSPEND_REC_EN_SHIFT)
#define  USB3D_SS_REF_INT_ENABLE_REG_SUSPEND_REC_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_ENABLE_REG_SUSPEND_REC_EN_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_ENABLE_REG_SUSPEND_REC_EN_SHIFT))

#define  USB3D_SS_REF_INT_ENABLE_REG_RESET_REC_EN_MASK 0x8000000
#define  USB3D_SS_REF_INT_ENABLE_REG_RESET_REC_EN_SHIFT 27
#define  USB3D_SS_REF_INT_ENABLE_REG_RESET_REC_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_ENABLE_REG_RESET_REC_EN_MASK) >> USB3D_SS_REF_INT_ENABLE_REG_RESET_REC_EN_SHIFT)
#define  USB3D_SS_REF_INT_ENABLE_REG_RESET_REC_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_ENABLE_REG_RESET_REC_EN_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_ENABLE_REG_RESET_REC_EN_SHIFT))

#define  USB3D_SS_REF_INT_ENABLE_REG_POWER_ON_REC_EN_MASK 0x4000000
#define  USB3D_SS_REF_INT_ENABLE_REG_POWER_ON_REC_EN_SHIFT 26
#define  USB3D_SS_REF_INT_ENABLE_REG_POWER_ON_REC_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_ENABLE_REG_POWER_ON_REC_EN_MASK) >> USB3D_SS_REF_INT_ENABLE_REG_POWER_ON_REC_EN_SHIFT)
#define  USB3D_SS_REF_INT_ENABLE_REG_POWER_ON_REC_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_ENABLE_REG_POWER_ON_REC_EN_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_ENABLE_REG_POWER_ON_REC_EN_SHIFT))

#define  USB3D_SS_REF_INT_ENABLE_REG_POWER_OFF_REC_EN_MASK 0x2000000
#define  USB3D_SS_REF_INT_ENABLE_REG_POWER_OFF_REC_EN_SHIFT 25
#define  USB3D_SS_REF_INT_ENABLE_REG_POWER_OFF_REC_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_ENABLE_REG_POWER_OFF_REC_EN_MASK) >> USB3D_SS_REF_INT_ENABLE_REG_POWER_OFF_REC_EN_SHIFT)
#define  USB3D_SS_REF_INT_ENABLE_REG_POWER_OFF_REC_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_ENABLE_REG_POWER_OFF_REC_EN_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_ENABLE_REG_POWER_OFF_REC_EN_SHIFT))

#define  USB3D_SS_REF_INT_ENABLE_REG_RESERVED1_MASK 0x1ffffff
#define  USB3D_SS_REF_INT_ENABLE_REG_RESERVED1_SHIFT 0
#define  USB3D_SS_REF_INT_ENABLE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_REF_INT_ENABLE_REG_RESERVED1_MASK) >> USB3D_SS_REF_INT_ENABLE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_REF_INT_ENABLE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_REF_INT_ENABLE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_REF_INT_ENABLE_REG_RESERVED1_SHIFT))

//====================================================================
//Register: USB3_GLOBAL_CONTROL_STATUS_REG (USB3_GLOBAL_CONTROL_STATUS_REG)
//====================================================================

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOFT_CONNECT_MASK 0x80000000
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOFT_CONNECT_SHIFT 31
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOFT_CONNECT_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOFT_CONNECT_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOFT_CONNECT_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOFT_CONNECT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOFT_CONNECT_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOFT_CONNECT_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED1_MASK 0x40000000
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED1_SHIFT 30
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED1_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED1_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED1_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SAFE_MODE_MASK 0x20000000
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SAFE_MODE_SHIFT 29
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SAFE_MODE_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SAFE_MODE_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SAFE_MODE_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SAFE_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SAFE_MODE_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SAFE_MODE_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SWRST_WITH_PHYRST_MASK 0x10000000
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SWRST_WITH_PHYRST_SHIFT 28
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SWRST_WITH_PHYRST_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SWRST_WITH_PHYRST_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SWRST_WITH_PHYRST_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SWRST_WITH_PHYRST_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SWRST_WITH_PHYRST_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SWRST_WITH_PHYRST_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOC_REGISTER_ACCESS_MASK 0x8000000
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOC_REGISTER_ACCESS_SHIFT 27
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOC_REGISTER_ACCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOC_REGISTER_ACCESS_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOC_REGISTER_ACCESS_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOC_REGISTER_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOC_REGISTER_ACCESS_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SOC_REGISTER_ACCESS_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB3_GATING_MASK 0x4000000
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB3_GATING_SHIFT 26
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB3_GATING_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB3_GATING_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB3_GATING_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB3_GATING_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB3_GATING_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB3_GATING_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB2_GATING_MASK 0x2000000
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB2_GATING_SHIFT 25
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB2_GATING_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB2_GATING_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB2_GATING_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB2_GATING_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB2_GATING_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_DISABLE_USB2_GATING_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED2_MASK 0x1ff0000
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED2_SHIFT 16
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED2_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED2_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED2_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SSFAIL_CNT_MASK 0xf000
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SSFAIL_CNT_SHIFT 12
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SSFAIL_CNT_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SSFAIL_CNT_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SSFAIL_CNT_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SSFAIL_CNT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SSFAIL_CNT_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SSFAIL_CNT_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_REG_SSFAIL_CNT_MASK 0xf00
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_REG_SSFAIL_CNT_SHIFT 8
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_REG_SSFAIL_CNT_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_REG_SSFAIL_CNT_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_REG_SSFAIL_CNT_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_REG_SSFAIL_CNT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_REG_SSFAIL_CNT_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_REG_SSFAIL_CNT_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB3_LFPS_EXIT_UX_MASK 0x80
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB3_LFPS_EXIT_UX_SHIFT 7
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB3_LFPS_EXIT_UX_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB3_LFPS_EXIT_UX_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB3_LFPS_EXIT_UX_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB3_LFPS_EXIT_UX_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB3_LFPS_EXIT_UX_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB3_LFPS_EXIT_UX_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED3_MASK 0x60
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED3_SHIFT 5
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED3_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED3_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED3_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_ATMPSS_FAIL_MASK 0x10
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_ATMPSS_FAIL_SHIFT 4
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_ATMPSS_FAIL_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_ATMPSS_FAIL_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_ATMPSS_FAIL_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_ATMPSS_FAIL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_ATMPSS_FAIL_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_ATMPSS_FAIL_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SS_VBUS_MASK 0x8
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SS_VBUS_SHIFT 3
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SS_VBUS_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SS_VBUS_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SS_VBUS_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SS_VBUS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SS_VBUS_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_SS_VBUS_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_POWERPRESENT_MASK 0x4
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_POWERPRESENT_SHIFT 2
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_POWERPRESENT_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_POWERPRESENT_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_POWERPRESENT_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_POWERPRESENT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_POWERPRESENT_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_POWERPRESENT_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED4_MASK 0x2
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED4_SHIFT 1
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED4_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED4_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED4_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED4_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_RESERVED4_SHIFT))

#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_BUS_RESET_MASK 0x1
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_BUS_RESET_SHIFT 0
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_BUS_RESET_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_BUS_RESET_MASK) >> USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_BUS_RESET_SHIFT)
#define  USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_BUS_RESET_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_BUS_RESET_MASK) | (((uint32_t)val) << USB3D_SS_USB3_GLOBAL_CONTROL_STATUS_REG_USB2_BUS_RESET_SHIFT))

//====================================================================
//Register: SYSTEM_DEBUG_REG (SYSTEM_DEBUG_REG)
//====================================================================

#define  USB3D_SS_SYSTEM_DEBUG_REG_RESERVED1_MASK 0xe0000000
#define  USB3D_SS_SYSTEM_DEBUG_REG_RESERVED1_SHIFT 29
#define  USB3D_SS_SYSTEM_DEBUG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_SYSTEM_DEBUG_REG_RESERVED1_MASK) >> USB3D_SS_SYSTEM_DEBUG_REG_RESERVED1_SHIFT)
#define  USB3D_SS_SYSTEM_DEBUG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SYSTEM_DEBUG_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_SYSTEM_DEBUG_REG_RESERVED1_SHIFT))

#define  USB3D_SS_SYSTEM_DEBUG_REG_LTSSM_STATE_MASK 0x1f000000
#define  USB3D_SS_SYSTEM_DEBUG_REG_LTSSM_STATE_SHIFT 24
#define  USB3D_SS_SYSTEM_DEBUG_REG_LTSSM_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_SYSTEM_DEBUG_REG_LTSSM_STATE_MASK) >> USB3D_SS_SYSTEM_DEBUG_REG_LTSSM_STATE_SHIFT)
#define  USB3D_SS_SYSTEM_DEBUG_REG_LTSSM_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SYSTEM_DEBUG_REG_LTSSM_STATE_MASK) | (((uint32_t)val) << USB3D_SS_SYSTEM_DEBUG_REG_LTSSM_STATE_SHIFT))

#define  USB3D_SS_SYSTEM_DEBUG_REG_RESERVED2_MASK 0xffff00
#define  USB3D_SS_SYSTEM_DEBUG_REG_RESERVED2_SHIFT 8
#define  USB3D_SS_SYSTEM_DEBUG_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_SYSTEM_DEBUG_REG_RESERVED2_MASK) >> USB3D_SS_SYSTEM_DEBUG_REG_RESERVED2_SHIFT)
#define  USB3D_SS_SYSTEM_DEBUG_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SYSTEM_DEBUG_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_SYSTEM_DEBUG_REG_RESERVED2_SHIFT))

#define  USB3D_SS_SYSTEM_DEBUG_REG_DPMU_STATE_MASK 0xf0
#define  USB3D_SS_SYSTEM_DEBUG_REG_DPMU_STATE_SHIFT 4
#define  USB3D_SS_SYSTEM_DEBUG_REG_DPMU_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_SYSTEM_DEBUG_REG_DPMU_STATE_MASK) >> USB3D_SS_SYSTEM_DEBUG_REG_DPMU_STATE_SHIFT)
#define  USB3D_SS_SYSTEM_DEBUG_REG_DPMU_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SYSTEM_DEBUG_REG_DPMU_STATE_MASK) | (((uint32_t)val) << USB3D_SS_SYSTEM_DEBUG_REG_DPMU_STATE_SHIFT))

#define  USB3D_SS_SYSTEM_DEBUG_REG_SPEED_SWITCH_STATE_MASK 0xf
#define  USB3D_SS_SYSTEM_DEBUG_REG_SPEED_SWITCH_STATE_SHIFT 0
#define  USB3D_SS_SYSTEM_DEBUG_REG_SPEED_SWITCH_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_SYSTEM_DEBUG_REG_SPEED_SWITCH_STATE_MASK) >> USB3D_SS_SYSTEM_DEBUG_REG_SPEED_SWITCH_STATE_SHIFT)
#define  USB3D_SS_SYSTEM_DEBUG_REG_SPEED_SWITCH_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SYSTEM_DEBUG_REG_SPEED_SWITCH_STATE_MASK) | (((uint32_t)val) << USB3D_SS_SYSTEM_DEBUG_REG_SPEED_SWITCH_STATE_SHIFT))

//====================================================================
//Register: EP0_ACK_TIMEOUT_VALUE_REG (EP0_ACK_TIMEOUT_VALUE_REG)
//====================================================================

#define  USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_RESERVED1_SHIFT 16
#define  USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_RESERVED1_MASK) >> USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_RESERVED1_SHIFT))

#define  USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_EP0_ACK_TIMEOUT_VALUE_MASK 0xffff
#define  USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_EP0_ACK_TIMEOUT_VALUE_SHIFT 0
#define  USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_EP0_ACK_TIMEOUT_VALUE_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_EP0_ACK_TIMEOUT_VALUE_MASK) >> USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_EP0_ACK_TIMEOUT_VALUE_SHIFT)
#define  USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_EP0_ACK_TIMEOUT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_EP0_ACK_TIMEOUT_VALUE_MASK) | (((uint32_t)val) << USB3D_SS_EP0_ACK_TIMEOUT_VALUE_REG_EP0_ACK_TIMEOUT_VALUE_SHIFT))

//====================================================================
//Register: ACK_TIMEOUT_VALUE_REG (ACK_TIMEOUT_VALUE_REG)
//====================================================================

#define  USB3D_SS_ACK_TIMEOUT_VALUE_REG_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_ACK_TIMEOUT_VALUE_REG_RESERVED1_SHIFT 16
#define  USB3D_SS_ACK_TIMEOUT_VALUE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_ACK_TIMEOUT_VALUE_REG_RESERVED1_MASK) >> USB3D_SS_ACK_TIMEOUT_VALUE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_ACK_TIMEOUT_VALUE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ACK_TIMEOUT_VALUE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_ACK_TIMEOUT_VALUE_REG_RESERVED1_SHIFT))

#define  USB3D_SS_ACK_TIMEOUT_VALUE_REG_ACK_TIMEOUT_VALUE_MASK 0xffff
#define  USB3D_SS_ACK_TIMEOUT_VALUE_REG_ACK_TIMEOUT_VALUE_SHIFT 0
#define  USB3D_SS_ACK_TIMEOUT_VALUE_REG_ACK_TIMEOUT_VALUE_MASK_SHIFT(reg) (((reg) & USB3D_SS_ACK_TIMEOUT_VALUE_REG_ACK_TIMEOUT_VALUE_MASK) >> USB3D_SS_ACK_TIMEOUT_VALUE_REG_ACK_TIMEOUT_VALUE_SHIFT)
#define  USB3D_SS_ACK_TIMEOUT_VALUE_REG_ACK_TIMEOUT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ACK_TIMEOUT_VALUE_REG_ACK_TIMEOUT_VALUE_MASK) | (((uint32_t)val) << USB3D_SS_ACK_TIMEOUT_VALUE_REG_ACK_TIMEOUT_VALUE_SHIFT))

//====================================================================
//Register: RX_IDLE_DELAY_COUNTER_REG (RX_IDLE_DELAY_COUNTER_REG)
//====================================================================

#define  USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RESERVED1_SHIFT 16
#define  USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RESERVED1_MASK) >> USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RESERVED1_SHIFT)
#define  USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RESERVED1_SHIFT))

#define  USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RX_IDLE_DELAY_COUNTER_MASK 0xffff
#define  USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RX_IDLE_DELAY_COUNTER_SHIFT 0
#define  USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RX_IDLE_DELAY_COUNTER_MASK_SHIFT(reg) (((reg) & USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RX_IDLE_DELAY_COUNTER_MASK) >> USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RX_IDLE_DELAY_COUNTER_SHIFT)
#define  USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RX_IDLE_DELAY_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RX_IDLE_DELAY_COUNTER_MASK) | (((uint32_t)val) << USB3D_SS_RX_IDLE_DELAY_COUNTER_REG_RX_IDLE_DELAY_COUNTER_SHIFT))

//====================================================================
//Register: BACK_DOOR_REG (BACK_DOOR_REG)
//====================================================================

#define  USB3D_SS_BACK_DOOR_REG_USB3_COUNTER_PULSE_256US_MASK 0xff000000
#define  USB3D_SS_BACK_DOOR_REG_USB3_COUNTER_PULSE_256US_SHIFT 24
#define  USB3D_SS_BACK_DOOR_REG_USB3_COUNTER_PULSE_256US_MASK_SHIFT(reg) (((reg) & USB3D_SS_BACK_DOOR_REG_USB3_COUNTER_PULSE_256US_MASK) >> USB3D_SS_BACK_DOOR_REG_USB3_COUNTER_PULSE_256US_SHIFT)
#define  USB3D_SS_BACK_DOOR_REG_USB3_COUNTER_PULSE_256US_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BACK_DOOR_REG_USB3_COUNTER_PULSE_256US_MASK) | (((uint32_t)val) << USB3D_SS_BACK_DOOR_REG_USB3_COUNTER_PULSE_256US_SHIFT))

#define  USB3D_SS_BACK_DOOR_REG_RESERVED1_MASK 0xfffffc
#define  USB3D_SS_BACK_DOOR_REG_RESERVED1_SHIFT 2
#define  USB3D_SS_BACK_DOOR_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_BACK_DOOR_REG_RESERVED1_MASK) >> USB3D_SS_BACK_DOOR_REG_RESERVED1_SHIFT)
#define  USB3D_SS_BACK_DOOR_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BACK_DOOR_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_BACK_DOOR_REG_RESERVED1_SHIFT))

#define  USB3D_SS_BACK_DOOR_REG_NO_GATING_MASK 0x2
#define  USB3D_SS_BACK_DOOR_REG_NO_GATING_SHIFT 1
#define  USB3D_SS_BACK_DOOR_REG_NO_GATING_MASK_SHIFT(reg) (((reg) & USB3D_SS_BACK_DOOR_REG_NO_GATING_MASK) >> USB3D_SS_BACK_DOOR_REG_NO_GATING_SHIFT)
#define  USB3D_SS_BACK_DOOR_REG_NO_GATING_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BACK_DOOR_REG_NO_GATING_MASK) | (((uint32_t)val) << USB3D_SS_BACK_DOOR_REG_NO_GATING_SHIFT))

#define  USB3D_SS_BACK_DOOR_REG_BK_DOOR_MASK 0x1
#define  USB3D_SS_BACK_DOOR_REG_BK_DOOR_SHIFT 0
#define  USB3D_SS_BACK_DOOR_REG_BK_DOOR_MASK_SHIFT(reg) (((reg) & USB3D_SS_BACK_DOOR_REG_BK_DOOR_MASK) >> USB3D_SS_BACK_DOOR_REG_BK_DOOR_SHIFT)
#define  USB3D_SS_BACK_DOOR_REG_BK_DOOR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BACK_DOOR_REG_BK_DOOR_MASK) | (((uint32_t)val) << USB3D_SS_BACK_DOOR_REG_BK_DOOR_SHIFT))

//====================================================================
//Register: TEST_BUS_MUX_REG (TEST_BUS_MUX_REG)
//====================================================================

#define  USB3D_SS_TEST_BUS_MUX_REG_RESERVED1_MASK 0xffffff00
#define  USB3D_SS_TEST_BUS_MUX_REG_RESERVED1_SHIFT 8
#define  USB3D_SS_TEST_BUS_MUX_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_TEST_BUS_MUX_REG_RESERVED1_MASK) >> USB3D_SS_TEST_BUS_MUX_REG_RESERVED1_SHIFT)
#define  USB3D_SS_TEST_BUS_MUX_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TEST_BUS_MUX_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_TEST_BUS_MUX_REG_RESERVED1_SHIFT))

#define  USB3D_SS_TEST_BUS_MUX_REG_TEST_BUS_MUX_MASK 0xff
#define  USB3D_SS_TEST_BUS_MUX_REG_TEST_BUS_MUX_SHIFT 0
#define  USB3D_SS_TEST_BUS_MUX_REG_TEST_BUS_MUX_MASK_SHIFT(reg) (((reg) & USB3D_SS_TEST_BUS_MUX_REG_TEST_BUS_MUX_MASK) >> USB3D_SS_TEST_BUS_MUX_REG_TEST_BUS_MUX_SHIFT)
#define  USB3D_SS_TEST_BUS_MUX_REG_TEST_BUS_MUX_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TEST_BUS_MUX_REG_TEST_BUS_MUX_MASK) | (((uint32_t)val) << USB3D_SS_TEST_BUS_MUX_REG_TEST_BUS_MUX_SHIFT))

//====================================================================
//Register: CLOCK_GATING_ENABLE_REG (CLOCK_GATING_ENABLE_REG)
//====================================================================

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED1_MASK 0xffffc000
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED1_SHIFT 14
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED1_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED1_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_SLEEP_CLK_EN_MASK 0x2000
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_SLEEP_CLK_EN_SHIFT 13
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_SLEEP_CLK_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_SLEEP_CLK_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_SLEEP_CLK_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_SLEEP_CLK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_SLEEP_CLK_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_SLEEP_CLK_EN_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L2_USB2_SYS_CLK_GATING_EN_MASK 0x1000
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L2_USB2_SYS_CLK_GATING_EN_SHIFT 12
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L2_USB2_SYS_CLK_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L2_USB2_SYS_CLK_GATING_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L2_USB2_SYS_CLK_GATING_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L2_USB2_SYS_CLK_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L2_USB2_SYS_CLK_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L2_USB2_SYS_CLK_GATING_EN_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L1_CLK_GATING_EN_MASK 0x800
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L1_CLK_GATING_EN_SHIFT 11
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L1_CLK_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L1_CLK_GATING_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L1_CLK_GATING_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L1_CLK_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L1_CLK_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_USB2_L1_CLK_GATING_EN_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED2_MASK 0x400
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED2_SHIFT 10
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED2_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED2_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED2_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_PHY_P3_REF_CLK_GATING_EN_MASK 0x200
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_PHY_P3_REF_CLK_GATING_EN_SHIFT 9
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_PHY_P3_REF_CLK_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_PHY_P3_REF_CLK_GATING_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_PHY_P3_REF_CLK_GATING_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_PHY_P3_REF_CLK_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_PHY_P3_REF_CLK_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_PHY_P3_REF_CLK_GATING_EN_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_REF_CLK_GATING_EN_MASK 0x100
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_REF_CLK_GATING_EN_SHIFT 8
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_REF_CLK_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_REF_CLK_GATING_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_REF_CLK_GATING_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_REF_CLK_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_REF_CLK_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_REF_CLK_GATING_EN_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D3_SYS_CLK_TREE_GATING_EN_MASK 0x80
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D3_SYS_CLK_TREE_GATING_EN_SHIFT 7
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D3_SYS_CLK_TREE_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_D3_SYS_CLK_TREE_GATING_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_D3_SYS_CLK_TREE_GATING_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D3_SYS_CLK_TREE_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_D3_SYS_CLK_TREE_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_D3_SYS_CLK_TREE_GATING_EN_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_SS_SYS_CLK_GATING_EN_MASK 0x40
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_SS_SYS_CLK_GATING_EN_SHIFT 6
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_SS_SYS_CLK_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_SS_SYS_CLK_GATING_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_SS_SYS_CLK_GATING_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_SS_SYS_CLK_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_SS_SYS_CLK_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_P3_SS_SYS_CLK_GATING_EN_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D2_SYS_CLK_TREE_GATING_EN_MASK 0x20
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D2_SYS_CLK_TREE_GATING_EN_SHIFT 5
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D2_SYS_CLK_TREE_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_D2_SYS_CLK_TREE_GATING_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_D2_SYS_CLK_TREE_GATING_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D2_SYS_CLK_TREE_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_D2_SYS_CLK_TREE_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_D2_SYS_CLK_TREE_GATING_EN_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D1_SYS_CLK_TREE_GATING_EN_MASK 0x10
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D1_SYS_CLK_TREE_GATING_EN_SHIFT 4
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D1_SYS_CLK_TREE_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_D1_SYS_CLK_TREE_GATING_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_D1_SYS_CLK_TREE_GATING_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_D1_SYS_CLK_TREE_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_D1_SYS_CLK_TREE_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_D1_SYS_CLK_TREE_GATING_EN_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P2_CLK_GATING_EN_MASK 0x8
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P2_CLK_GATING_EN_SHIFT 3
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P2_CLK_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_P2_CLK_GATING_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_P2_CLK_GATING_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P2_CLK_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_P2_CLK_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_P2_CLK_GATING_EN_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED3_MASK 0x6
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED3_SHIFT 1
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED3_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED3_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_RESERVED3_SHIFT))

#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P1_CLK_GATING_EN_MASK 0x1
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P1_CLK_GATING_EN_SHIFT 0
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P1_CLK_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_CLOCK_GATING_ENABLE_REG_P1_CLK_GATING_EN_MASK) >> USB3D_SS_CLOCK_GATING_ENABLE_REG_P1_CLK_GATING_EN_SHIFT)
#define  USB3D_SS_CLOCK_GATING_ENABLE_REG_P1_CLK_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CLOCK_GATING_ENABLE_REG_P1_CLK_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_CLOCK_GATING_ENABLE_REG_P1_CLK_GATING_EN_SHIFT))

//====================================================================
//Register: POWER_GATING_ENABLE_REG (POWER_GATING_ENABLE_REG)
//====================================================================

#define  USB3D_SS_POWER_GATING_ENABLE_REG_RESERVED1_MASK 0xfffffff0
#define  USB3D_SS_POWER_GATING_ENABLE_REG_RESERVED1_SHIFT 4
#define  USB3D_SS_POWER_GATING_ENABLE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_GATING_ENABLE_REG_RESERVED1_MASK) >> USB3D_SS_POWER_GATING_ENABLE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_POWER_GATING_ENABLE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_GATING_ENABLE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_POWER_GATING_ENABLE_REG_RESERVED1_SHIFT))

#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB2_PHY_POWER_GATING_EN_MASK 0x8
#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB2_PHY_POWER_GATING_EN_SHIFT 3
#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB2_PHY_POWER_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_GATING_ENABLE_REG_USB2_PHY_POWER_GATING_EN_MASK) >> USB3D_SS_POWER_GATING_ENABLE_REG_USB2_PHY_POWER_GATING_EN_SHIFT)
#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB2_PHY_POWER_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_GATING_ENABLE_REG_USB2_PHY_POWER_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_POWER_GATING_ENABLE_REG_USB2_PHY_POWER_GATING_EN_SHIFT))

#define  USB3D_SS_POWER_GATING_ENABLE_REG_SS_PHY_POWER_GATING_EN_MASK 0x4
#define  USB3D_SS_POWER_GATING_ENABLE_REG_SS_PHY_POWER_GATING_EN_SHIFT 2
#define  USB3D_SS_POWER_GATING_ENABLE_REG_SS_PHY_POWER_GATING_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_GATING_ENABLE_REG_SS_PHY_POWER_GATING_EN_MASK) >> USB3D_SS_POWER_GATING_ENABLE_REG_SS_PHY_POWER_GATING_EN_SHIFT)
#define  USB3D_SS_POWER_GATING_ENABLE_REG_SS_PHY_POWER_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_GATING_ENABLE_REG_SS_PHY_POWER_GATING_EN_MASK) | (((uint32_t)val) << USB3D_SS_POWER_GATING_ENABLE_REG_SS_PHY_POWER_GATING_EN_SHIFT))

#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN2_MASK 0x2
#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN2_SHIFT 1
#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN2_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN2_MASK) >> USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN2_SHIFT)
#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN2_MASK) | (((uint32_t)val) << USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN2_SHIFT))

#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN1_MASK 0x1
#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN1_SHIFT 0
#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN1_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN1_MASK) >> USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN1_SHIFT)
#define  USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN1_MASK) | (((uint32_t)val) << USB3D_SS_POWER_GATING_ENABLE_REG_USB3_CORE_POWER_GATING_EN1_SHIFT))

//====================================================================
//Register: POWER_MANAGEMENT_DEVICE_REG (POWER_MANAGEMENT_DEVICE_REG)
/** \brief if power_gating is register controlled, this register is accessable even the
power is gated.*/
//====================================================================

#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED1_SHIFT 16
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED1_MASK) >> USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED1_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWACK_MASK 0x8000
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWACK_SHIFT 15
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWACK_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWACK_MASK) >> USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWACK_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWACK_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWACK_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWACK_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED2_MASK 0x7fc0
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED2_SHIFT 6
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED2_MASK) >> USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED2_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_RESERVED2_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DPREQ_MASK 0x38
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DPREQ_SHIFT 3
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DPREQ_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DPREQ_MASK) >> USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DPREQ_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DPREQ_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DPREQ_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DPREQ_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DCREQ_MASK 0x6
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DCREQ_SHIFT 1
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DCREQ_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DCREQ_MASK) >> USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DCREQ_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DCREQ_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DCREQ_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DCREQ_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWREQ_MASK 0x1
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWREQ_SHIFT 0
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWREQ_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWREQ_MASK) >> USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWREQ_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWREQ_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWREQ_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_DEVICE_REG_DWREQ_SHIFT))

//====================================================================
//Register: POWER_MANAGEMENT_SOC_REG (POWER_MANAGEMENT_SOC_REG)
/** \brief if power_gating is register controlled, this register is accessable even the
power is gated.*/
//====================================================================

#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED1_SHIFT 16
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED1_MASK) >> USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED1_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED1_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPACK_MASK 0xe000
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPACK_SHIFT 13
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPACK_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPACK_MASK) >> USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPACK_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPACK_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPACK_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPACK_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCACK_MASK 0x1800
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCACK_SHIFT 11
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCACK_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCACK_MASK) >> USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCACK_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCACK_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCACK_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCACK_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED2_MASK 0x7c0
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED2_SHIFT 6
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED2_MASK) >> USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED2_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_SOC_REG_RESERVED2_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPREQ_MASK 0x38
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPREQ_SHIFT 3
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPREQ_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPREQ_MASK) >> USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPREQ_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPREQ_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPREQ_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSPREQ_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCREQ_MASK 0x6
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCREQ_SHIFT 1
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCREQ_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCREQ_MASK) >> USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCREQ_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCREQ_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCREQ_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSCREQ_SHIFT))

#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSWREQ_MASK 0x1
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSWREQ_SHIFT 0
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSWREQ_MASK_SHIFT(reg) (((reg) & USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSWREQ_MASK) >> USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSWREQ_SHIFT)
#define  USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSWREQ_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSWREQ_MASK) | (((uint32_t)val) << USB3D_SS_POWER_MANAGEMENT_SOC_REG_SYSWREQ_SHIFT))

//====================================================================
//Register: LOW_POWER_STATUS_REG (LOW_POWER_STATUS_REG)
/** \brief if power_gating is register controlled, this register is accessable even the
power is gated.*/
//====================================================================

#define  USB3D_SS_LOW_POWER_STATUS_REG_RESERVED1_MASK 0xffffff80
#define  USB3D_SS_LOW_POWER_STATUS_REG_RESERVED1_SHIFT 7
#define  USB3D_SS_LOW_POWER_STATUS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_STATUS_REG_RESERVED1_MASK) >> USB3D_SS_LOW_POWER_STATUS_REG_RESERVED1_SHIFT)
#define  USB3D_SS_LOW_POWER_STATUS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_STATUS_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_STATUS_REG_RESERVED1_SHIFT))

#define  USB3D_SS_LOW_POWER_STATUS_REG_POWERPRESENT_MASK 0x40
#define  USB3D_SS_LOW_POWER_STATUS_REG_POWERPRESENT_SHIFT 6
#define  USB3D_SS_LOW_POWER_STATUS_REG_POWERPRESENT_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_STATUS_REG_POWERPRESENT_MASK) >> USB3D_SS_LOW_POWER_STATUS_REG_POWERPRESENT_SHIFT)
#define  USB3D_SS_LOW_POWER_STATUS_REG_POWERPRESENT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_STATUS_REG_POWERPRESENT_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_STATUS_REG_POWERPRESENT_SHIFT))

#define  USB3D_SS_LOW_POWER_STATUS_REG_PRESENT_STATE_MASK 0x3e
#define  USB3D_SS_LOW_POWER_STATUS_REG_PRESENT_STATE_SHIFT 1
#define  USB3D_SS_LOW_POWER_STATUS_REG_PRESENT_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_STATUS_REG_PRESENT_STATE_MASK) >> USB3D_SS_LOW_POWER_STATUS_REG_PRESENT_STATE_SHIFT)
#define  USB3D_SS_LOW_POWER_STATUS_REG_PRESENT_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_STATUS_REG_PRESENT_STATE_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_STATUS_REG_PRESENT_STATE_SHIFT))

#define  USB3D_SS_LOW_POWER_STATUS_REG_USB2_RUN_MASK 0x1
#define  USB3D_SS_LOW_POWER_STATUS_REG_USB2_RUN_SHIFT 0
#define  USB3D_SS_LOW_POWER_STATUS_REG_USB2_RUN_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOW_POWER_STATUS_REG_USB2_RUN_MASK) >> USB3D_SS_LOW_POWER_STATUS_REG_USB2_RUN_SHIFT)
#define  USB3D_SS_LOW_POWER_STATUS_REG_USB2_RUN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOW_POWER_STATUS_REG_USB2_RUN_MASK) | (((uint32_t)val) << USB3D_SS_LOW_POWER_STATUS_REG_USB2_RUN_SHIFT))

//====================================================================
//Register: SOFTWARE_RESET_REG (SOFTWARE_RESET_REG)
/** \brief if power_gating is register controlled, this register is accessable even the
power is gated.*/
//====================================================================

#define  USB3D_SS_SOFTWARE_RESET_REG_RESERVED1_MASK 0xfffffffe
#define  USB3D_SS_SOFTWARE_RESET_REG_RESERVED1_SHIFT 1
#define  USB3D_SS_SOFTWARE_RESET_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_SOFTWARE_RESET_REG_RESERVED1_MASK) >> USB3D_SS_SOFTWARE_RESET_REG_RESERVED1_SHIFT)
#define  USB3D_SS_SOFTWARE_RESET_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SOFTWARE_RESET_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_SOFTWARE_RESET_REG_RESERVED1_SHIFT))

#define  USB3D_SS_SOFTWARE_RESET_REG_SOFTWARE_RESET_MASK 0x1
#define  USB3D_SS_SOFTWARE_RESET_REG_SOFTWARE_RESET_SHIFT 0
#define  USB3D_SS_SOFTWARE_RESET_REG_SOFTWARE_RESET_MASK_SHIFT(reg) (((reg) & USB3D_SS_SOFTWARE_RESET_REG_SOFTWARE_RESET_MASK) >> USB3D_SS_SOFTWARE_RESET_REG_SOFTWARE_RESET_SHIFT)
#define  USB3D_SS_SOFTWARE_RESET_REG_SOFTWARE_RESET_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SOFTWARE_RESET_REG_SOFTWARE_RESET_MASK) | (((uint32_t)val) << USB3D_SS_SOFTWARE_RESET_REG_SOFTWARE_RESET_SHIFT))

//====================================================================
//Register: TOP_INTERRUPT_STATUS_REG (TOP_INTERRUPT_STATUS_REG)
/** \brief if power_gating is register controlled, this register is accessable even the
power is gated.*/
//====================================================================

#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_RESERVED1_MASK 0xffffffc0
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_RESERVED1_SHIFT 6
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_REG_RESERVED1_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_REG_RESERVED1_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_REG_RESERVED1_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_VBUS_INT_MASK 0x20
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_VBUS_INT_SHIFT 5
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_VBUS_INT_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_REG_VBUS_INT_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_REG_VBUS_INT_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_VBUS_INT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_REG_VBUS_INT_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_REG_VBUS_INT_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_PME_MASK 0x10
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_PME_SHIFT 4
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_PME_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_REG_PME_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_REG_PME_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_PME_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_REG_PME_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_REG_PME_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_REF_INT_MASK 0x8
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_REF_INT_SHIFT 3
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_REF_INT_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_REG_REF_INT_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_REG_REF_INT_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_REF_INT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_REG_REF_INT_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_REG_REF_INT_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_CORE_INT_MASK 0x4
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_CORE_INT_SHIFT 2
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_CORE_INT_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_CORE_INT_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_CORE_INT_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_CORE_INT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_CORE_INT_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_CORE_INT_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_SYS_INT_MASK 0x2
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_SYS_INT_SHIFT 1
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_SYS_INT_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_SYS_INT_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_SYS_INT_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_SYS_INT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_SYS_INT_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_REG_SS_SYS_INT_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_USB2_INT_MASK 0x1
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_USB2_INT_SHIFT 0
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_USB2_INT_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_REG_USB2_INT_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_REG_USB2_INT_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_REG_USB2_INT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_REG_USB2_INT_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_REG_USB2_INT_SHIFT))

//====================================================================
//Register: TOP_INTERRUPT_ENABLE_REG (TOP_INTERRUPT_ENABLE_REG)
/** \brief if power_gating is register controlled, this register is accessable even the
power is gated.*/
//====================================================================

#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_RESERVED1_MASK 0xffffffe0
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_RESERVED1_SHIFT 5
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_ENABLE_REG_RESERVED1_MASK) >> USB3D_SS_TOP_INTERRUPT_ENABLE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_ENABLE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_ENABLE_REG_RESERVED1_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_PME_EN_MASK 0x10
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_PME_EN_SHIFT 4
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_PME_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_ENABLE_REG_PME_EN_MASK) >> USB3D_SS_TOP_INTERRUPT_ENABLE_REG_PME_EN_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_PME_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_ENABLE_REG_PME_EN_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_ENABLE_REG_PME_EN_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_REF_INT_EN_MASK 0x8
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_REF_INT_EN_SHIFT 3
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_REF_INT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_ENABLE_REG_REF_INT_EN_MASK) >> USB3D_SS_TOP_INTERRUPT_ENABLE_REG_REF_INT_EN_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_REF_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_ENABLE_REG_REF_INT_EN_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_ENABLE_REG_REF_INT_EN_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_CORE_INT_EN_MASK 0x4
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_CORE_INT_EN_SHIFT 2
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_CORE_INT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_CORE_INT_EN_MASK) >> USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_CORE_INT_EN_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_CORE_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_CORE_INT_EN_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_CORE_INT_EN_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_SYS_INT_EN_MASK 0x2
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_SYS_INT_EN_SHIFT 1
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_SYS_INT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_SYS_INT_EN_MASK) >> USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_SYS_INT_EN_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_SYS_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_SYS_INT_EN_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_ENABLE_REG_SS_SYS_INT_EN_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_USB2_INT_EN_MASK 0x1
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_USB2_INT_EN_SHIFT 0
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_USB2_INT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_ENABLE_REG_USB2_INT_EN_MASK) >> USB3D_SS_TOP_INTERRUPT_ENABLE_REG_USB2_INT_EN_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_ENABLE_REG_USB2_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_ENABLE_REG_USB2_INT_EN_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_ENABLE_REG_USB2_INT_EN_SHIFT))

//====================================================================
//Register: TOP_INTERRUPT_STATUS_EN_REG (TOP_INTERRUPT_STATUS_EN_REG)
/** \brief if power_gating is register controlled, this register is accessable even the
power is gated.*/
//====================================================================

#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED1_SHIFT 16
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED1_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED1_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED1_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWACK_INT_EN_MASK 0x8000
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWACK_INT_EN_SHIFT 15
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWACK_INT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWACK_INT_EN_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWACK_INT_EN_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWACK_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWACK_INT_EN_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWACK_INT_EN_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED2_MASK 0x7ff0
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED2_SHIFT 4
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED2_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED2_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED2_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DPREQ_INT_EN_MASK 0x8
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DPREQ_INT_EN_SHIFT 3
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DPREQ_INT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DPREQ_INT_EN_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DPREQ_INT_EN_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DPREQ_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DPREQ_INT_EN_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DPREQ_INT_EN_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED3_MASK 0x6
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED3_SHIFT 1
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED3_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED3_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_RESERVED3_SHIFT))

#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWREQ_INT_EN_MASK 0x1
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWREQ_INT_EN_SHIFT 0
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWREQ_INT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWREQ_INT_EN_MASK) >> USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWREQ_INT_EN_SHIFT)
#define  USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWREQ_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWREQ_INT_EN_MASK) | (((uint32_t)val) << USB3D_SS_TOP_INTERRUPT_STATUS_EN_REG_DWREQ_INT_EN_SHIFT))

//====================================================================
//Register: TSEQ_COUNTER_U1U2_TIMEOUT_REG (TSEQ_COUNTER_U1U2_TIMEOUT_REG)
//====================================================================

#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_LTSSM_RXEQ_CC_VAL_MASK 0xffff0000
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_LTSSM_RXEQ_CC_VAL_SHIFT 16
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_LTSSM_RXEQ_CC_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_LTSSM_RXEQ_CC_VAL_MASK) >> USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_LTSSM_RXEQ_CC_VAL_SHIFT)
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_LTSSM_RXEQ_CC_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_LTSSM_RXEQ_CC_VAL_MASK) | (((uint32_t)val) << USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_LTSSM_RXEQ_CC_VAL_SHIFT))

#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED1_MASK 0x8000
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED1_SHIFT 15
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED1_MASK) >> USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED1_SHIFT)
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED1_SHIFT))

#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U2_EXIT_TTO_VAL_MASK 0x7f00
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U2_EXIT_TTO_VAL_SHIFT 8
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U2_EXIT_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U2_EXIT_TTO_VAL_MASK) >> USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U2_EXIT_TTO_VAL_SHIFT)
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U2_EXIT_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U2_EXIT_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U2_EXIT_TTO_VAL_SHIFT))

#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED2_MASK 0x80
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED2_SHIFT 7
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED2_MASK) >> USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED2_SHIFT)
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_RESERVED2_SHIFT))

#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U1_EXIT_TTO_VAL_MASK 0x7f
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U1_EXIT_TTO_VAL_SHIFT 0
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U1_EXIT_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U1_EXIT_TTO_VAL_MASK) >> USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U1_EXIT_TTO_VAL_SHIFT)
#define  USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U1_EXIT_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U1_EXIT_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_TSEQ_COUNTER_U1U2_TIMEOUT_REG_USB3_U1_EXIT_TTO_VAL_SHIFT))

//====================================================================
//Register: TIMER_TIMEOUT_REG_1 (TIMER_TIMEOUT_REG_1)
//====================================================================

#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED1_MASK 0xe0000000
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED1_SHIFT 29
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED1_MASK) >> USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_2MS_TTO_VAL_MASK 0x1f000000
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_2MS_TTO_VAL_SHIFT 24
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_2MS_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_2MS_TTO_VAL_MASK) >> USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_2MS_TTO_VAL_SHIFT)
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_2MS_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_2MS_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_2MS_TTO_VAL_SHIFT))

#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED2_MASK 0x800000
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED2_SHIFT 23
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED2_MASK) >> USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED2_SHIFT)
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED2_SHIFT))

#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_6MS_TTO_VAL_MASK 0x7f0000
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_6MS_TTO_VAL_SHIFT 16
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_6MS_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_6MS_TTO_VAL_MASK) >> USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_6MS_TTO_VAL_SHIFT)
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_6MS_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_6MS_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_6MS_TTO_VAL_SHIFT))

#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_12MS_TTO_VAL_MASK 0xff00
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_12MS_TTO_VAL_SHIFT 8
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_12MS_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_12MS_TTO_VAL_MASK) >> USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_12MS_TTO_VAL_SHIFT)
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_12MS_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_12MS_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_12MS_TTO_VAL_SHIFT))

#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED3_MASK 0xc0
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED3_SHIFT 6
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED3_MASK) >> USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED3_SHIFT)
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_TIMER_TIMEOUT_REG_1_RESERVED3_SHIFT))

#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_100MS_TTO_VAL_MASK 0x3f
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_100MS_TTO_VAL_SHIFT 0
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_100MS_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_100MS_TTO_VAL_MASK) >> USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_100MS_TTO_VAL_SHIFT)
#define  USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_100MS_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_100MS_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_TIMER_TIMEOUT_REG_1_USB3_LTSSM_100MS_TTO_VAL_SHIFT))

//====================================================================
//Register: TIMER_TIMEOUT_REG_2 (TIMER_TIMEOUT_REG_2)
//====================================================================

#define  USB3D_SS_TIMER_TIMEOUT_REG_2_RESERVED1_MASK 0xffffff00
#define  USB3D_SS_TIMER_TIMEOUT_REG_2_RESERVED1_SHIFT 8
#define  USB3D_SS_TIMER_TIMEOUT_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_TIMER_TIMEOUT_REG_2_RESERVED1_MASK) >> USB3D_SS_TIMER_TIMEOUT_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_TIMER_TIMEOUT_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TIMER_TIMEOUT_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_TIMER_TIMEOUT_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_TIMER_TIMEOUT_REG_2_USB3_LTSSM_360MS_TTO_VAL_MASK 0xff
#define  USB3D_SS_TIMER_TIMEOUT_REG_2_USB3_LTSSM_360MS_TTO_VAL_SHIFT 0
#define  USB3D_SS_TIMER_TIMEOUT_REG_2_USB3_LTSSM_360MS_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_TIMER_TIMEOUT_REG_2_USB3_LTSSM_360MS_TTO_VAL_MASK) >> USB3D_SS_TIMER_TIMEOUT_REG_2_USB3_LTSSM_360MS_TTO_VAL_SHIFT)
#define  USB3D_SS_TIMER_TIMEOUT_REG_2_USB3_LTSSM_360MS_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TIMER_TIMEOUT_REG_2_USB3_LTSSM_360MS_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_TIMER_TIMEOUT_REG_2_USB3_LTSSM_360MS_TTO_VAL_SHIFT))

//====================================================================
//Register: LFPS_TX_CONFIG_REG (LFPS_TX_CONFIG_REG)
//====================================================================

#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED1_MASK 0xf0000000
#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED1_SHIFT 28
#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED1_MASK) >> USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED1_SHIFT)
#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED1_SHIFT))

#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_MASK 0xf000000
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_SHIFT 24
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_MASK) >> USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_SHIFT)
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_SHIFT))

#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_PING_MASK 0xff0000
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_PING_SHIFT 16
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_PING_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_PING_MASK) >> USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_PING_SHIFT)
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_PING_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_PING_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TREPEAT_PING_SHIFT))

#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED2_MASK 0xf000
#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED2_SHIFT 12
#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED2_MASK) >> USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED2_SHIFT)
#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED2_SHIFT))

#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_POLLING_MASK 0xf00
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_POLLING_SHIFT 8
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_POLLING_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_POLLING_MASK) >> USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_POLLING_SHIFT)
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_POLLING_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_POLLING_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_POLLING_SHIFT))

#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED3_MASK 0xf0
#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED3_SHIFT 4
#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED3_MASK) >> USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED3_SHIFT)
#define  USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_TX_CONFIG_REG_RESERVED3_SHIFT))

#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_PING_MASK 0xf
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_PING_SHIFT 0
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_PING_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_PING_MASK) >> USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_PING_SHIFT)
#define  USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_PING_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_PING_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_TX_CONFIG_REG_LFPS_TX_TBURST_PING_SHIFT))

//====================================================================
//Register: LFPS_RX_CONFIG_REG (LFPS_RX_CONFIG_REG)
//====================================================================

#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED1_MASK 0xf8000000
#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED1_SHIFT 27
#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED1_MASK) >> USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED1_SHIFT)
#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED1_SHIFT))

#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_MASK 0x7000000
#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_SHIFT 24
#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_MASK) >> USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_SHIFT)
#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_TX_TREPEAT_POLLING_SHIFT))

#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TREPEAT_PING_MASK 0xff0000
#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TREPEAT_PING_SHIFT 16
#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TREPEAT_PING_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TREPEAT_PING_MASK) >> USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TREPEAT_PING_SHIFT)
#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TREPEAT_PING_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TREPEAT_PING_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TREPEAT_PING_SHIFT))

#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED2_MASK 0xf000
#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED2_SHIFT 12
#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED2_MASK) >> USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED2_SHIFT)
#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED2_SHIFT))

#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TBURST_POLLING_MASK 0xf00
#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TBURST_POLLING_SHIFT 8
#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TBURST_POLLING_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TBURST_POLLING_MASK) >> USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TBURST_POLLING_SHIFT)
#define  USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TBURST_POLLING_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TBURST_POLLING_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_RX_CONFIG_REG_LFPS_RX_TBURST_POLLING_SHIFT))

#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED3_MASK 0xff
#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED3_SHIFT 0
#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED3_MASK) >> USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED3_SHIFT)
#define  USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_RX_CONFIG_REG_RESERVED3_SHIFT))

//====================================================================
//Register: LFPS_WR_TRESET_VAL_REG (LFPS_WR_TRESET_VAL_REG)
//====================================================================

#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED1_MASK 0xffff8000
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED1_SHIFT 15
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED1_MASK) >> USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED1_SHIFT)
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED1_SHIFT))

#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESET_TOTAL_MASK 0x7f00
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESET_TOTAL_SHIFT 8
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESET_TOTAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESET_TOTAL_MASK) >> USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESET_TOTAL_SHIFT)
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESET_TOTAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESET_TOTAL_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESET_TOTAL_SHIFT))

#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED2_MASK 0x80
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED2_SHIFT 7
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED2_MASK) >> USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED2_SHIFT)
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_WR_TRESET_VAL_REG_RESERVED2_SHIFT))

#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESETDELAY_MIN_MASK 0x7f
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESETDELAY_MIN_SHIFT 0
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESETDELAY_MIN_MASK_SHIFT(reg) (((reg) & USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESETDELAY_MIN_MASK) >> USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESETDELAY_MIN_SHIFT)
#define  USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESETDELAY_MIN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESETDELAY_MIN_MASK) | (((uint32_t)val) << USB3D_SS_LFPS_WR_TRESET_VAL_REG_LFPS_WR_TRESETDELAY_MIN_SHIFT))

//====================================================================
//Register: COUNTER_DELAY_TX_REG (COUNTER_DELAY_TX_REG)
//====================================================================

#define  USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_POLLING_LFPS_MASK 0xffff0000
#define  USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_POLLING_LFPS_SHIFT 16
#define  USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_POLLING_LFPS_MASK_SHIFT(reg) (((reg) & USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_POLLING_LFPS_MASK) >> USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_POLLING_LFPS_SHIFT)
#define  USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_POLLING_LFPS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_POLLING_LFPS_MASK) | (((uint32_t)val) << USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_POLLING_LFPS_SHIFT))

#define  USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_PING_LFPS_MASK 0xffff
#define  USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_PING_LFPS_SHIFT 0
#define  USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_PING_LFPS_MASK_SHIFT(reg) (((reg) & USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_PING_LFPS_MASK) >> USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_PING_LFPS_SHIFT)
#define  USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_PING_LFPS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_PING_LFPS_MASK) | (((uint32_t)val) << USB3D_SS_COUNTER_DELAY_TX_REG_CNTR_DELAY_TX_PING_LFPS_SHIFT))

//====================================================================
//Register: DEV_USB_ADDRESS_REG (DEV_USB_ADDRESS_REG)
//====================================================================

#define  USB3D_SS_DEV_USB_ADDRESS_REG_RESERVED1_MASK 0xffffff80
#define  USB3D_SS_DEV_USB_ADDRESS_REG_RESERVED1_SHIFT 7
#define  USB3D_SS_DEV_USB_ADDRESS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DEV_USB_ADDRESS_REG_RESERVED1_MASK) >> USB3D_SS_DEV_USB_ADDRESS_REG_RESERVED1_SHIFT)
#define  USB3D_SS_DEV_USB_ADDRESS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DEV_USB_ADDRESS_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_DEV_USB_ADDRESS_REG_RESERVED1_SHIFT))

#define  USB3D_SS_DEV_USB_ADDRESS_REG_DEV_REG_USB_DEV_ADDR_MASK 0x7f
#define  USB3D_SS_DEV_USB_ADDRESS_REG_DEV_REG_USB_DEV_ADDR_SHIFT 0
#define  USB3D_SS_DEV_USB_ADDRESS_REG_DEV_REG_USB_DEV_ADDR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DEV_USB_ADDRESS_REG_DEV_REG_USB_DEV_ADDR_MASK) >> USB3D_SS_DEV_USB_ADDRESS_REG_DEV_REG_USB_DEV_ADDR_SHIFT)
#define  USB3D_SS_DEV_USB_ADDRESS_REG_DEV_REG_USB_DEV_ADDR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DEV_USB_ADDRESS_REG_DEV_REG_USB_DEV_ADDR_MASK) | (((uint32_t)val) << USB3D_SS_DEV_USB_ADDRESS_REG_DEV_REG_USB_DEV_ADDR_SHIFT))

//====================================================================
//Register: FUNCTION_WAKEUP_REG (FUNCTION_WAKEUP_REG)
//====================================================================

#define  USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_INTERFACE_NUM_MASK 0xff000000
#define  USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_INTERFACE_NUM_SHIFT 24
#define  USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_INTERFACE_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_INTERFACE_NUM_MASK) >> USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_INTERFACE_NUM_SHIFT)
#define  USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_INTERFACE_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_INTERFACE_NUM_MASK) | (((uint32_t)val) << USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_INTERFACE_NUM_SHIFT))

#define  USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_ENABLE_MASK 0x800000
#define  USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_ENABLE_SHIFT 23
#define  USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_ENABLE_MASK) >> USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_ENABLE_SHIFT)
#define  USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_FUNCTION_WAKEUP_REG_FN_WP_NOTIFICATION_ENABLE_SHIFT))

#define  USB3D_SS_FUNCTION_WAKEUP_REG_RESERVED1_MASK 0x7fffff
#define  USB3D_SS_FUNCTION_WAKEUP_REG_RESERVED1_SHIFT 0
#define  USB3D_SS_FUNCTION_WAKEUP_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_FUNCTION_WAKEUP_REG_RESERVED1_MASK) >> USB3D_SS_FUNCTION_WAKEUP_REG_RESERVED1_SHIFT)
#define  USB3D_SS_FUNCTION_WAKEUP_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_FUNCTION_WAKEUP_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_FUNCTION_WAKEUP_REG_RESERVED1_SHIFT))

//====================================================================
//Register: ENDPOINT_0_CONFIG_REG (ENDPOINT_0_CONFIG_REG)
//====================================================================

#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_ENDPOINT_0_CONFIG_REG_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED1_MASK 0xf000
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED1_SHIFT 12
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED1_MASK) >> USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED1_SHIFT)
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED1_SHIFT))

#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EP_STALL_N_MASK 0x800
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EP_STALL_N_SHIFT 11
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_ENDPOINT_0_CONFIG_REG_EP_STALL_N_MASK) >> USB3D_SS_ENDPOINT_0_CONFIG_REG_EP_STALL_N_SHIFT)
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ENDPOINT_0_CONFIG_REG_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_ENDPOINT_0_CONFIG_REG_EP_STALL_N_SHIFT))

#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_PREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_PREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_PREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_ENDPOINT_0_CONFIG_REG_PREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_ENDPOINT_0_CONFIG_REG_PREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_PREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ENDPOINT_0_CONFIG_REG_PREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_ENDPOINT_0_CONFIG_REG_PREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_CHG_STAGE_MASK 0x80
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_CHG_STAGE_SHIFT 7
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_CHG_STAGE_MASK_SHIFT(reg) (((reg) & USB3D_SS_ENDPOINT_0_CONFIG_REG_CHG_STAGE_MASK) >> USB3D_SS_ENDPOINT_0_CONFIG_REG_CHG_STAGE_SHIFT)
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_CHG_STAGE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ENDPOINT_0_CONFIG_REG_CHG_STAGE_MASK) | (((uint32_t)val) << USB3D_SS_ENDPOINT_0_CONFIG_REG_CHG_STAGE_SHIFT))

#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED2_MASK 0x7f
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED2_SHIFT 0
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED2_MASK) >> USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED2_SHIFT)
#define  USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_ENDPOINT_0_CONFIG_REG_RESERVED2_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_1 (OUT_ENDPOINT_CONFIG_REG_1)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_2 (OUT_ENDPOINT_CONFIG_REG_2)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_3 (OUT_ENDPOINT_CONFIG_REG_3)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_4 (OUT_ENDPOINT_CONFIG_REG_4)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_5 (OUT_ENDPOINT_CONFIG_REG_5)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_6 (OUT_ENDPOINT_CONFIG_REG_6)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_7 (OUT_ENDPOINT_CONFIG_REG_7)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_8 (OUT_ENDPOINT_CONFIG_REG_8)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_9 (OUT_ENDPOINT_CONFIG_REG_9)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_10 (OUT_ENDPOINT_CONFIG_REG_10)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_11 (OUT_ENDPOINT_CONFIG_REG_11)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_12 (OUT_ENDPOINT_CONFIG_REG_12)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_13 (OUT_ENDPOINT_CONFIG_REG_13)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_14 (OUT_ENDPOINT_CONFIG_REG_14)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: OUT_ENDPOINT_CONFIG_REG_15 (OUT_ENDPOINT_CONFIG_REG_15)
//====================================================================

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_N_MASK 0xff000000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_N_SHIFT 24
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_LOWER_N_MASK 0xff0000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT 16
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_LOWER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED1_MASK 0x8000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED1_SHIFT 15
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED1_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED1_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED1_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED2_MASK 0x3000
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED2_SHIFT 12
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED2_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED2_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED2_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EP_STALL_N_MASK 0x800
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EP_STALL_N_SHIFT 11
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EP_STALL_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EP_STALL_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EP_STALL_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EP_STALL_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EP_STALL_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EP_STALL_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_UPPER_N_MASK 0x700
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT 8
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_UPPER_N_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED3_MASK 0x80
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED3_SHIFT 7
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED3_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED3_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_RESERVED3_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_MASK) >> USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_OUT_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_1 (IN_ENDPOINT_CONFIG_REG_1)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_1_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_2 (IN_ENDPOINT_CONFIG_REG_2)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_2_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_3 (IN_ENDPOINT_CONFIG_REG_3)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_3_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_4 (IN_ENDPOINT_CONFIG_REG_4)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_4_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_5 (IN_ENDPOINT_CONFIG_REG_5)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_5_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_6 (IN_ENDPOINT_CONFIG_REG_6)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_6_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_7 (IN_ENDPOINT_CONFIG_REG_7)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_7_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_8 (IN_ENDPOINT_CONFIG_REG_8)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_8_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_9 (IN_ENDPOINT_CONFIG_REG_9)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_9_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_10 (IN_ENDPOINT_CONFIG_REG_10)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_10_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_11 (IN_ENDPOINT_CONFIG_REG_11)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_11_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_12 (IN_ENDPOINT_CONFIG_REG_12)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_12_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_13 (IN_ENDPOINT_CONFIG_REG_13)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_13_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_14 (IN_ENDPOINT_CONFIG_REG_14)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_14_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: IN_ENDPOINT_CONFIG_REG_15 (IN_ENDPOINT_CONFIG_REG_15)
//====================================================================

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_IN_N_MASK 0xff000000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_IN_N_SHIFT 24
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_BURST_SIZE_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK 0xff0000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT 16
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_LOWER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_LOWER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_LOWER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED1_MASK 0x8000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED1_SHIFT 15
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED1_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED1_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED1_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_MASK 0x4000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_SHIFT 14
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESET_SEQ_NUM_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED2_MASK 0x3000
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED2_SHIFT 12
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED2_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED2_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED2_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EP_STALL_IN_N_MASK 0x800
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EP_STALL_IN_N_SHIFT 11
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EP_STALL_IN_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EP_STALL_IN_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EP_STALL_IN_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EP_STALL_IN_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EP_STALL_IN_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EP_STALL_IN_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK 0x700
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT 8
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_UPPER_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_UPPER_N_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_EPREG_MAX_PKT_SIZE_IN_UPPER_N_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED3_MASK 0x80
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED3_SHIFT 7
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED3_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED3_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_RESERVED3_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_MASK 0x40
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_SHIFT 6
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_ENABLE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_MASK 0x30
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_SHIFT 4
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_TYPE_SHIFT))

#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_MASK 0xf
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_SHIFT 0
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_MASK_SHIFT(reg) (((reg) & USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_MASK) >> USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_SHIFT)
#define  USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_MASK) | (((uint32_t)val) << USB3D_SS_IN_ENDPOINT_CONFIG_REG_15_ENDPOINT_NUM_SHIFT))

//====================================================================
//Register: PHY_CFG_REG (PHY_CFG_REG)
//====================================================================

#define  USB3D_SS_PHY_CFG_REG_RESERVED1_MASK 0xff800000
#define  USB3D_SS_PHY_CFG_REG_RESERVED1_SHIFT 23
#define  USB3D_SS_PHY_CFG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_PHY_CFG_REG_RESERVED1_MASK) >> USB3D_SS_PHY_CFG_REG_RESERVED1_SHIFT)
#define  USB3D_SS_PHY_CFG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PHY_CFG_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_PHY_CFG_REG_RESERVED1_SHIFT))

#define  USB3D_SS_PHY_CFG_REG_PORT_CAP_REG_MASK 0x7f0000
#define  USB3D_SS_PHY_CFG_REG_PORT_CAP_REG_SHIFT 16
#define  USB3D_SS_PHY_CFG_REG_PORT_CAP_REG_MASK_SHIFT(reg) (((reg) & USB3D_SS_PHY_CFG_REG_PORT_CAP_REG_MASK) >> USB3D_SS_PHY_CFG_REG_PORT_CAP_REG_SHIFT)
#define  USB3D_SS_PHY_CFG_REG_PORT_CAP_REG_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PHY_CFG_REG_PORT_CAP_REG_MASK) | (((uint32_t)val) << USB3D_SS_PHY_CFG_REG_PORT_CAP_REG_SHIFT))

#define  USB3D_SS_PHY_CFG_REG_RESERVED2_MASK 0xf000
#define  USB3D_SS_PHY_CFG_REG_RESERVED2_SHIFT 12
#define  USB3D_SS_PHY_CFG_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_PHY_CFG_REG_RESERVED2_MASK) >> USB3D_SS_PHY_CFG_REG_RESERVED2_SHIFT)
#define  USB3D_SS_PHY_CFG_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PHY_CFG_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_PHY_CFG_REG_RESERVED2_SHIFT))

#define  USB3D_SS_PHY_CFG_REG_USB3_SELF_PWD_DEVICE_MASK 0x800
#define  USB3D_SS_PHY_CFG_REG_USB3_SELF_PWD_DEVICE_SHIFT 11
#define  USB3D_SS_PHY_CFG_REG_USB3_SELF_PWD_DEVICE_MASK_SHIFT(reg) (((reg) & USB3D_SS_PHY_CFG_REG_USB3_SELF_PWD_DEVICE_MASK) >> USB3D_SS_PHY_CFG_REG_USB3_SELF_PWD_DEVICE_SHIFT)
#define  USB3D_SS_PHY_CFG_REG_USB3_SELF_PWD_DEVICE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PHY_CFG_REG_USB3_SELF_PWD_DEVICE_MASK) | (((uint32_t)val) << USB3D_SS_PHY_CFG_REG_USB3_SELF_PWD_DEVICE_SHIFT))

#define  USB3D_SS_PHY_CFG_REG_USB3_PHY_DISABLE_SCRAMBLE_MASK 0x400
#define  USB3D_SS_PHY_CFG_REG_USB3_PHY_DISABLE_SCRAMBLE_SHIFT 10
#define  USB3D_SS_PHY_CFG_REG_USB3_PHY_DISABLE_SCRAMBLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_PHY_CFG_REG_USB3_PHY_DISABLE_SCRAMBLE_MASK) >> USB3D_SS_PHY_CFG_REG_USB3_PHY_DISABLE_SCRAMBLE_SHIFT)
#define  USB3D_SS_PHY_CFG_REG_USB3_PHY_DISABLE_SCRAMBLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PHY_CFG_REG_USB3_PHY_DISABLE_SCRAMBLE_MASK) | (((uint32_t)val) << USB3D_SS_PHY_CFG_REG_USB3_PHY_DISABLE_SCRAMBLE_SHIFT))

#define  USB3D_SS_PHY_CFG_REG_USB3_LFPS_EXIT_MASK 0x200
#define  USB3D_SS_PHY_CFG_REG_USB3_LFPS_EXIT_SHIFT 9
#define  USB3D_SS_PHY_CFG_REG_USB3_LFPS_EXIT_MASK_SHIFT(reg) (((reg) & USB3D_SS_PHY_CFG_REG_USB3_LFPS_EXIT_MASK) >> USB3D_SS_PHY_CFG_REG_USB3_LFPS_EXIT_SHIFT)
#define  USB3D_SS_PHY_CFG_REG_USB3_LFPS_EXIT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PHY_CFG_REG_USB3_LFPS_EXIT_MASK) | (((uint32_t)val) << USB3D_SS_PHY_CFG_REG_USB3_LFPS_EXIT_SHIFT))

#define  USB3D_SS_PHY_CFG_REG_RESERVED3_MASK 0x1e0
#define  USB3D_SS_PHY_CFG_REG_RESERVED3_SHIFT 5
#define  USB3D_SS_PHY_CFG_REG_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_PHY_CFG_REG_RESERVED3_MASK) >> USB3D_SS_PHY_CFG_REG_RESERVED3_SHIFT)
#define  USB3D_SS_PHY_CFG_REG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PHY_CFG_REG_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_PHY_CFG_REG_RESERVED3_SHIFT))

#define  USB3D_SS_PHY_CFG_REG_LTSSM_ST_MASK 0x1f
#define  USB3D_SS_PHY_CFG_REG_LTSSM_ST_SHIFT 0
#define  USB3D_SS_PHY_CFG_REG_LTSSM_ST_MASK_SHIFT(reg) (((reg) & USB3D_SS_PHY_CFG_REG_LTSSM_ST_MASK) >> USB3D_SS_PHY_CFG_REG_LTSSM_ST_SHIFT)
#define  USB3D_SS_PHY_CFG_REG_LTSSM_ST_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PHY_CFG_REG_LTSSM_ST_MASK) | (((uint32_t)val) << USB3D_SS_PHY_CFG_REG_LTSSM_ST_SHIFT))

//====================================================================
//Register: BUS_INTERVAL_LTM_REG (BUS_INTERVAL_LTM_REG)
//====================================================================

#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ADJUST_VALUE_MASK 0xffff0000
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ADJUST_VALUE_SHIFT 16
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ADJUST_VALUE_MASK_SHIFT(reg) (((reg) & USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ADJUST_VALUE_MASK) >> USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ADJUST_VALUE_SHIFT)
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ADJUST_VALUE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ADJUST_VALUE_MASK) | (((uint32_t)val) << USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ADJUST_VALUE_SHIFT))

#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ENABLE_MASK 0x8000
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ENABLE_SHIFT 15
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ENABLE_MASK) >> USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ENABLE_SHIFT)
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_BUS_INT_ENABLE_SHIFT))

#define  USB3D_SS_BUS_INTERVAL_LTM_REG_RESERVED1_MASK 0x6000
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_RESERVED1_SHIFT 13
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_BUS_INTERVAL_LTM_REG_RESERVED1_MASK) >> USB3D_SS_BUS_INTERVAL_LTM_REG_RESERVED1_SHIFT)
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BUS_INTERVAL_LTM_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_BUS_INTERVAL_LTM_REG_RESERVED1_SHIFT))

#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_BELT_MASK 0x1ffe
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_BELT_SHIFT 1
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_BELT_MASK_SHIFT(reg) (((reg) & USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_BELT_MASK) >> USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_BELT_SHIFT)
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_BELT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_BELT_MASK) | (((uint32_t)val) << USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_BELT_SHIFT))

#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_ENABLE_MASK 0x1
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_ENABLE_SHIFT 0
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_ENABLE_MASK_SHIFT(reg) (((reg) & USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_ENABLE_MASK) >> USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_ENABLE_SHIFT)
#define  USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_ENABLE_MASK) | (((uint32_t)val) << USB3D_SS_BUS_INTERVAL_LTM_REG_USB3_LTM_ENABLE_SHIFT))

//====================================================================
//Register: ISO_TIME_STAMP_COUNTER_REG (ISO_TIME_STAMP_COUNTER_REG)
//====================================================================

#define  USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_RESERVED1_MASK 0xf8000000
#define  USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_RESERVED1_SHIFT 27
#define  USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_RESERVED1_MASK) >> USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_RESERVED1_SHIFT)
#define  USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_RESERVED1_SHIFT))

#define  USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_PL_RCV_ISOC_TIME_STAMP_MASK 0x7ffffff
#define  USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_PL_RCV_ISOC_TIME_STAMP_SHIFT 0
#define  USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_PL_RCV_ISOC_TIME_STAMP_MASK_SHIFT(reg) (((reg) & USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_PL_RCV_ISOC_TIME_STAMP_MASK) >> USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_PL_RCV_ISOC_TIME_STAMP_SHIFT)
#define  USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_PL_RCV_ISOC_TIME_STAMP_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_PL_RCV_ISOC_TIME_STAMP_MASK) | (((uint32_t)val) << USB3D_SS_ISO_TIME_STAMP_COUNTER_REG_PL_RCV_ISOC_TIME_STAMP_SHIFT))

//====================================================================
//Register: CREDIT_HP_AND_U2_TIMER_REG (CREDIT_HP_AND_U2_TIMER_REG)
//====================================================================

#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED1_MASK 0xff800000
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED1_SHIFT 23
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED1_MASK) >> USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED1_SHIFT)
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED1_SHIFT))

#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_CREDIT_HP_TTO_VAL_MASK 0x7f0000
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_CREDIT_HP_TTO_VAL_SHIFT 16
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_CREDIT_HP_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_CREDIT_HP_TTO_VAL_MASK) >> USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_CREDIT_HP_TTO_VAL_SHIFT)
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_CREDIT_HP_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_CREDIT_HP_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_CREDIT_HP_TTO_VAL_SHIFT))

#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED2_MASK 0x8000
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED2_SHIFT 15
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED2_MASK) >> USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED2_SHIFT)
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RESERVED2_SHIFT))

#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RECV_RESUME_MASK 0x4000
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RECV_RESUME_SHIFT 14
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RECV_RESUME_MASK_SHIFT(reg) (((reg) & USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RECV_RESUME_MASK) >> USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RECV_RESUME_SHIFT)
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RECV_RESUME_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RECV_RESUME_MASK) | (((uint32_t)val) << USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_RECV_RESUME_SHIFT))

#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_PENDING_HP_TTO_VAL_MASK 0x3f00
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_PENDING_HP_TTO_VAL_SHIFT 8
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_PENDING_HP_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_PENDING_HP_TTO_VAL_MASK) >> USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_PENDING_HP_TTO_VAL_SHIFT)
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_PENDING_HP_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_PENDING_HP_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_PENDING_HP_TTO_VAL_SHIFT))

#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_U2_INACTIVITY_TTO_VAL_MASK 0xff
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_U2_INACTIVITY_TTO_VAL_SHIFT 0
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_U2_INACTIVITY_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_U2_INACTIVITY_TTO_VAL_MASK) >> USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_U2_INACTIVITY_TTO_VAL_SHIFT)
#define  USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_U2_INACTIVITY_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_U2_INACTIVITY_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_CREDIT_HP_AND_U2_TIMER_REG_USB3_U2_INACTIVITY_TTO_VAL_SHIFT))

//====================================================================
//Register: PM_LC_TIMER_TIME_OUT_REG (PM_LC_TIMER_TIME_OUT_REG)
//====================================================================

#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_RESERVED1_MASK 0xff000000
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_RESERVED1_SHIFT 24
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_RESERVED1_MASK) >> USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_RESERVED1_SHIFT)
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_RESERVED1_SHIFT))

#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_NOLC_TIMEOUT_VAL_MASK 0xf00000
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_NOLC_TIMEOUT_VAL_SHIFT 20
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_NOLC_TIMEOUT_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_NOLC_TIMEOUT_VAL_MASK) >> USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_NOLC_TIMEOUT_VAL_SHIFT)
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_NOLC_TIMEOUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_NOLC_TIMEOUT_VAL_MASK) | (((uint32_t)val) << USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_NOLC_TIMEOUT_VAL_SHIFT))

#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_LUP_CTO_VAL_MASK 0xf0000
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_LUP_CTO_VAL_SHIFT 16
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_LUP_CTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_LUP_CTO_VAL_MASK) >> USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_LUP_CTO_VAL_SHIFT)
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_LUP_CTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_LUP_CTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_LUP_CTO_VAL_SHIFT))

#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_ENTRY_TTO_VAL_MASK 0xff00
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_ENTRY_TTO_VAL_SHIFT 8
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_ENTRY_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_ENTRY_TTO_VAL_MASK) >> USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_ENTRY_TTO_VAL_SHIFT)
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_ENTRY_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_ENTRY_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_ENTRY_TTO_VAL_SHIFT))

#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_LC_TTO_VAL_MASK 0xff
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_LC_TTO_VAL_SHIFT 0
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_LC_TTO_VAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_LC_TTO_VAL_MASK) >> USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_LC_TTO_VAL_SHIFT)
#define  USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_LC_TTO_VAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_LC_TTO_VAL_MASK) | (((uint32_t)val) << USB3D_SS_PM_LC_TIMER_TIME_OUT_REG_USB3_PM_LC_TTO_VAL_SHIFT))

//====================================================================
//Register: SS_CORE_INTERRUPT_REG (SS_CORE_INTERRUPT_REG)
//====================================================================

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED1_MASK 0xffff8000
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED1_SHIFT 15
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED1_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED1_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED1_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_SETUP_REC_MASK 0x4000
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_SETUP_REC_SHIFT 14
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_SETUP_REC_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_SETUP_REC_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_SETUP_REC_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_SETUP_REC_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_SETUP_REC_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_SETUP_REC_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_TRANS_REC_MASK 0x2000
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_TRANS_REC_SHIFT 13
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_TRANS_REC_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_TRANS_REC_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_TRANS_REC_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_TRANS_REC_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_TRANS_REC_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_TRANS_REC_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_ITP_REC_MASK 0x1000
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_ITP_REC_SHIFT 12
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_ITP_REC_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_ITP_REC_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_ITP_REC_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_ITP_REC_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_ITP_REC_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_ITP_REC_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_HOT_RESET_REC_MASK 0x800
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_HOT_RESET_REC_SHIFT 11
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_HOT_RESET_REC_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_HOT_RESET_REC_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_HOT_RESET_REC_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_HOT_RESET_REC_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_HOT_RESET_REC_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_HOT_RESET_REC_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED2_MASK 0x600
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED2_SHIFT 9
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED2_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED2_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_RESERVED2_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_LTSSM_ST_CHANGE_MASK 0x100
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_LTSSM_ST_CHANGE_SHIFT 8
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_LTSSM_ST_CHANGE_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_LTSSM_ST_CHANGE_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_LTSSM_ST_CHANGE_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_LTSSM_ST_CHANGE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_LTSSM_ST_CHANGE_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_LTSSM_ST_CHANGE_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_DECODE_ERR_8_10B_MASK 0x80
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_DECODE_ERR_8_10B_SHIFT 7
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_DECODE_ERR_8_10B_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_DECODE_ERR_8_10B_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_DECODE_ERR_8_10B_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_DECODE_ERR_8_10B_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_DECODE_ERR_8_10B_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_DECODE_ERR_8_10B_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_DISPARITY_ERR_MASK 0x40
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_DISPARITY_ERR_SHIFT 6
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_DISPARITY_ERR_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_DISPARITY_ERR_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_DISPARITY_ERR_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_DISPARITY_ERR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_DISPARITY_ERR_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_DISPARITY_ERR_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_HOST_ERR_MASK 0x20
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_HOST_ERR_SHIFT 5
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_HOST_ERR_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_HOST_ERR_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_HOST_ERR_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_HOST_ERR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_HOST_ERR_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_HOST_ERR_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_BUS_TIMEOUT_ERROR_MASK 0x10
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_BUS_TIMEOUT_ERROR_SHIFT 4
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_BUS_TIMEOUT_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_BUS_TIMEOUT_ERROR_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_BUS_TIMEOUT_ERROR_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_BUS_TIMEOUT_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_BUS_TIMEOUT_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_BUS_TIMEOUT_ERROR_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_PHY_RXERR_MASK 0x8
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_PHY_RXERR_SHIFT 3
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_PHY_RXERR_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_PHY_RXERR_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_PHY_RXERR_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_PHY_RXERR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_PHY_RXERR_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_PHY_RXERR_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC16_ERROR_MASK 0x4
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC16_ERROR_SHIFT 2
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC16_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_CRC16_ERROR_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_CRC16_ERROR_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC16_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_CRC16_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_CRC16_ERROR_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC5_ERROR_MASK 0x2
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC5_ERROR_SHIFT 1
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC5_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_CRC5_ERROR_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_CRC5_ERROR_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC5_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_CRC5_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_CRC5_ERROR_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC32_ERROR_MASK 0x1
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC32_ERROR_SHIFT 0
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC32_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_REG_CRC32_ERROR_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_REG_CRC32_ERROR_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_REG_CRC32_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_REG_CRC32_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_REG_CRC32_ERROR_SHIFT))

//====================================================================
//Register: SS_CORE_INTERRUPT_EN_REG (SS_CORE_INTERRUPT_EN_REG)
//====================================================================

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED1_MASK 0xffff8000
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED1_SHIFT 15
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED1_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED1_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED1_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_SETUP_REC_EN_MASK 0x4000
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_SETUP_REC_EN_SHIFT 14
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_SETUP_REC_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_SETUP_REC_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_SETUP_REC_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_SETUP_REC_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_SETUP_REC_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_SETUP_REC_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_TRANS_REC_EN_MASK 0x2000
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_TRANS_REC_EN_SHIFT 13
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_TRANS_REC_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_TRANS_REC_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_TRANS_REC_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_TRANS_REC_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_TRANS_REC_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_TRANS_REC_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_ITP_REC_EN_MASK 0x1000
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_ITP_REC_EN_SHIFT 12
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_ITP_REC_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_ITP_REC_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_ITP_REC_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_ITP_REC_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_ITP_REC_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_ITP_REC_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOT_RESET_REC_EN_MASK 0x800
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOT_RESET_REC_EN_SHIFT 11
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOT_RESET_REC_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOT_RESET_REC_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOT_RESET_REC_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOT_RESET_REC_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOT_RESET_REC_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOT_RESET_REC_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED2_MASK 0x600
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED2_SHIFT 9
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED2_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED2_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_RESERVED2_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_LTSSM_ST_CHANGE_EN_MASK 0x100
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_LTSSM_ST_CHANGE_EN_SHIFT 8
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_LTSSM_ST_CHANGE_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_LTSSM_ST_CHANGE_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_LTSSM_ST_CHANGE_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_LTSSM_ST_CHANGE_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_LTSSM_ST_CHANGE_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_LTSSM_ST_CHANGE_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DECODE_ERR_8_10B_EN_MASK 0x80
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DECODE_ERR_8_10B_EN_SHIFT 7
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DECODE_ERR_8_10B_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DECODE_ERR_8_10B_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DECODE_ERR_8_10B_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DECODE_ERR_8_10B_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DECODE_ERR_8_10B_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DECODE_ERR_8_10B_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DISPARITY_ERR_EN_MASK 0x40
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DISPARITY_ERR_EN_SHIFT 6
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DISPARITY_ERR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DISPARITY_ERR_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DISPARITY_ERR_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DISPARITY_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DISPARITY_ERR_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_DISPARITY_ERR_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOST_ERR_EN_MASK 0x20
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOST_ERR_EN_SHIFT 5
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOST_ERR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOST_ERR_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOST_ERR_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOST_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOST_ERR_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_HOST_ERR_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_BUS_TIMEOUT_ERROR_EN_MASK 0x10
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_BUS_TIMEOUT_ERROR_EN_SHIFT 4
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_BUS_TIMEOUT_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_BUS_TIMEOUT_ERROR_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_BUS_TIMEOUT_ERROR_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_BUS_TIMEOUT_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_BUS_TIMEOUT_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_BUS_TIMEOUT_ERROR_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_PHY_RXERR_EN_MASK 0x8
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_PHY_RXERR_EN_SHIFT 3
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_PHY_RXERR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_PHY_RXERR_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_PHY_RXERR_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_PHY_RXERR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_PHY_RXERR_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_PHY_RXERR_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC16_ERROR_EN_MASK 0x4
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC16_ERROR_EN_SHIFT 2
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC16_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC16_ERROR_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC16_ERROR_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC16_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC16_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC16_ERROR_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC5_ERROR_EN_MASK 0x2
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC5_ERROR_EN_SHIFT 1
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC5_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC5_ERROR_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC5_ERROR_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC5_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC5_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC5_ERROR_EN_SHIFT))

#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC32_ERROR_EN_MASK 0x1
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC32_ERROR_EN_SHIFT 0
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC32_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC32_ERROR_EN_MASK) >> USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC32_ERROR_EN_SHIFT)
#define  USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC32_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC32_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_CORE_INTERRUPT_EN_REG_CRC32_ERROR_EN_SHIFT))

//====================================================================
//Register: EP_IN_BINTERVAL_REG_1_TO_3 (EP_IN_BINTERVAL_REG_1_2_3)
//====================================================================

#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_3_MASK 0xff000000
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_3_SHIFT 24
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_3_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_3_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_3_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_3_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_2_MASK 0xff0000
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_2_SHIFT 16
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_2_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_2_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_2_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_1_MASK 0xff00
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_1_SHIFT 8
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_1_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_1_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_EP_IN_BINTERVAL_1_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_RESERVED1_MASK 0xff
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_RESERVED1_SHIFT 0
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_RESERVED1_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_1_2_3_RESERVED1_SHIFT))

//====================================================================
//Register: EP_IN_BINTERVAL_REG_4_TO_7 (EP_IN_BINTERVAL_REG_4_5_6_7)
//====================================================================

#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_7_MASK 0xff000000
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_7_SHIFT 24
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_7_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_7_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_7_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_7_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_6_MASK 0xff0000
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_6_SHIFT 16
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_6_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_6_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_6_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_6_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_5_MASK 0xff00
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_5_SHIFT 8
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_5_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_5_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_5_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_5_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_4_MASK 0xff
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_4_SHIFT 0
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_4_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_4_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_4_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_4_5_6_7_EP_IN_BINTERVAL_4_SHIFT))

//====================================================================
//Register: EP_IN_BINTERVAL_REG_8_TO_11 (EP_IN_BINTERVAL_REG_8_9_10_11)
//====================================================================

#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_11_MASK 0xff000000
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_11_SHIFT 24
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_11_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_11_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_11_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_11_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_10_MASK 0xff0000
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_10_SHIFT 16
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_10_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_10_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_10_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_10_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_9_MASK 0xff00
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_9_SHIFT 8
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_9_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_9_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_9_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_9_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_8_MASK 0xff
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_8_SHIFT 0
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_8_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_8_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_8_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_8_9_10_11_EP_IN_BINTERVAL_8_SHIFT))

//====================================================================
//Register: EP_IN_BINTERVAL_REG_12_TO_15 (EP_IN_BINTERVAL_REG_12_13_14_15)
//====================================================================

#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_15_MASK 0xff000000
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_15_SHIFT 24
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_15_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_15_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_15_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_15_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_14_MASK 0xff0000
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_14_SHIFT 16
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_14_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_14_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_14_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_14_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_13_MASK 0xff00
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_13_SHIFT 8
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_13_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_13_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_13_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_13_SHIFT))

#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_12_MASK 0xff
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_12_SHIFT 0
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_12_MASK) >> USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_12_SHIFT)
#define  USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_12_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_BINTERVAL_REG_12_13_14_15_EP_IN_BINTERVAL_12_SHIFT))

//====================================================================
//Register: EP_OUT_BINTERVAL_REG_1_TO_3 (EP_OUT_BINTERVAL_REG_1_2_3)
//====================================================================

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_3_MASK 0xff000000
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_3_SHIFT 24
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_3_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_3_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_3_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_3_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_2_MASK 0xff0000
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_2_SHIFT 16
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_2_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_2_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_2_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_1_MASK 0xff00
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_1_SHIFT 8
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_1_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_1_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_EP_OUT_BINTERVAL_1_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_RESERVED1_MASK 0xff
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_RESERVED1_SHIFT 0
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_RESERVED1_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_1_2_3_RESERVED1_SHIFT))

//====================================================================
//Register: EP_OUT_BINTERVAL_REG_4_TO_7 (EP_OUT_BINTERVAL_REG_4_5_6_7)
//====================================================================

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_7_MASK 0xff000000
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_7_SHIFT 24
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_7_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_7_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_7_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_7_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_6_MASK 0xff0000
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_6_SHIFT 16
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_6_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_6_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_6_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_6_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_5_MASK 0xff00
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_5_SHIFT 8
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_5_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_5_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_5_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_5_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_4_MASK 0xff
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_4_SHIFT 0
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_4_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_4_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_4_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_4_5_6_7_EP_OUT_BINTERVAL_4_SHIFT))

//====================================================================
//Register: EP_OUT_BINTERVAL_REG_8_TO_11 (EP_OUT_BINTERVAL_REG_8_9_10_11)
//====================================================================

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_11_MASK 0xff000000
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_11_SHIFT 24
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_11_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_11_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_11_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_11_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_10_MASK 0xff0000
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_10_SHIFT 16
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_10_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_10_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_10_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_10_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_9_MASK 0xff00
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_9_SHIFT 8
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_9_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_9_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_9_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_9_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_8_MASK 0xff
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_8_SHIFT 0
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_8_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_8_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_8_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_8_9_10_11_EP_OUT_BINTERVAL_8_SHIFT))

//====================================================================
//Register: EP_OUT_BINTERVAL_REG_12_TO_15 (EP_OUT_BINTERVAL_REG_12_13_14_15)
//====================================================================

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_15_MASK 0xff000000
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_15_SHIFT 24
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_15_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_15_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_15_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_15_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_14_MASK 0xff0000
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_14_SHIFT 16
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_14_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_14_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_14_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_14_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_13_MASK 0xff00
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_13_SHIFT 8
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_13_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_13_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_13_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_13_SHIFT))

#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_12_MASK 0xff
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_12_SHIFT 0
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_12_MASK) >> USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_12_SHIFT)
#define  USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_12_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_BINTERVAL_REG_12_13_14_15_EP_OUT_BINTERVAL_12_SHIFT))

//====================================================================
//Register: EP_HOST_ERROR_STATUS_REG (EP_HOST_ERROR_STATUS_REG)
//====================================================================

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_RESERVED1_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_RESERVED1_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_RESERVED1_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_15_MASK 0x8000
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_15_SHIFT 15
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_15_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_15_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_15_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_15_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_14_MASK 0x4000
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_14_SHIFT 14
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_14_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_14_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_14_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_14_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_13_MASK 0x2000
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_13_SHIFT 13
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_13_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_13_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_13_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_13_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_12_MASK 0x1000
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_12_SHIFT 12
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_12_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_12_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_12_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_12_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_11_MASK 0x800
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_11_SHIFT 11
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_11_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_11_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_11_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_11_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_10_MASK 0x400
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_10_SHIFT 10
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_10_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_10_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_10_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_10_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_9_MASK 0x200
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_9_SHIFT 9
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_9_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_9_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_9_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_9_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_8_MASK 0x100
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_8_SHIFT 8
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_8_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_8_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_8_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_8_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_7_MASK 0x80
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_7_SHIFT 7
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_7_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_7_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_7_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_7_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_6_MASK 0x40
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_6_SHIFT 6
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_6_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_6_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_6_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_6_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_5_MASK 0x20
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_5_SHIFT 5
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_5_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_5_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_5_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_5_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_4_MASK 0x10
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_4_SHIFT 4
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_4_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_4_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_4_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_4_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_3_MASK 0x8
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_3_SHIFT 3
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_3_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_3_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_3_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_3_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_2_MASK 0x4
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_2_SHIFT 2
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_2_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_2_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_2_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_2_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_1_MASK 0x2
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_1_SHIFT 1
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_1_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_1_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_1_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_1_SHIFT))

#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_0_MASK 0x1
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_0_SHIFT 0
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_0_MASK) >> USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_0_SHIFT)
#define  USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_0_MASK) | (((uint32_t)val) << USB3D_SS_EP_HOST_ERROR_STATUS_REG_USB3_EP_HOST_ERROR_0_SHIFT))

//====================================================================
//Register: PING_TIMEOUT_REG (PING_TIMEOUT_REG)
//====================================================================

#define  USB3D_SS_PING_TIMEOUT_REG_RESERVED1_MASK 0xffffffe0
#define  USB3D_SS_PING_TIMEOUT_REG_RESERVED1_SHIFT 5
#define  USB3D_SS_PING_TIMEOUT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_PING_TIMEOUT_REG_RESERVED1_MASK) >> USB3D_SS_PING_TIMEOUT_REG_RESERVED1_SHIFT)
#define  USB3D_SS_PING_TIMEOUT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PING_TIMEOUT_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_PING_TIMEOUT_REG_RESERVED1_SHIFT))

#define  USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_DIR_MASK 0x10
#define  USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_DIR_SHIFT 4
#define  USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_DIR_MASK_SHIFT(reg) (((reg) & USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_DIR_MASK) >> USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_DIR_SHIFT)
#define  USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_DIR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_DIR_MASK) | (((uint32_t)val) << USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_DIR_SHIFT))

#define  USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_NO_MASK 0xf
#define  USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_NO_SHIFT 0
#define  USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_NO_MASK_SHIFT(reg) (((reg) & USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_NO_MASK) >> USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_NO_SHIFT)
#define  USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_NO_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_NO_MASK) | (((uint32_t)val) << USB3D_SS_PING_TIMEOUT_REG_TPING_TIMEOUT_EP_NO_SHIFT))

//====================================================================
//Register: UX_EXIT_DETECTION_DELAY_REG (UX_EXIT_DETECTION_DELAY_REG)
//====================================================================

#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_HOST_INIT_UX_DLY_EN_MASK 0x80000000
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_HOST_INIT_UX_DLY_EN_SHIFT 31
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_HOST_INIT_UX_DLY_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_HOST_INIT_UX_DLY_EN_MASK) >> USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_HOST_INIT_UX_DLY_EN_SHIFT)
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_HOST_INIT_UX_DLY_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_HOST_INIT_UX_DLY_EN_MASK) | (((uint32_t)val) << USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_HOST_INIT_UX_DLY_EN_SHIFT))

#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_DEV_INIT_UX_DLY_EN_MASK 0x40000000
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_DEV_INIT_UX_DLY_EN_SHIFT 30
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_DEV_INIT_UX_DLY_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_DEV_INIT_UX_DLY_EN_MASK) >> USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_DEV_INIT_UX_DLY_EN_SHIFT)
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_DEV_INIT_UX_DLY_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_DEV_INIT_UX_DLY_EN_MASK) | (((uint32_t)val) << USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_DEV_INIT_UX_DLY_EN_SHIFT))

#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_RESERVED1_MASK 0x3fff0000
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_RESERVED1_SHIFT 16
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_RESERVED1_MASK) >> USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_RESERVED1_SHIFT)
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_RESERVED1_SHIFT))

#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_LFPS_DETECT_DLY_CNT_MASK 0xffff
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_LFPS_DETECT_DLY_CNT_SHIFT 0
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_LFPS_DETECT_DLY_CNT_MASK_SHIFT(reg) (((reg) & USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_LFPS_DETECT_DLY_CNT_MASK) >> USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_LFPS_DETECT_DLY_CNT_SHIFT)
#define  USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_LFPS_DETECT_DLY_CNT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_LFPS_DETECT_DLY_CNT_MASK) | (((uint32_t)val) << USB3D_SS_UX_EXIT_DETECTION_DELAY_REG_LFPS_DETECT_DLY_CNT_SHIFT))

//====================================================================
//Register: TX_TSI_NUM_REG (TX_TSI_NUM_REG)
//====================================================================

#define  USB3D_SS_TX_TSI_NUM_REG_MIN_NUM_TX_TS1_MASK 0xffff0000
#define  USB3D_SS_TX_TSI_NUM_REG_MIN_NUM_TX_TS1_SHIFT 16
#define  USB3D_SS_TX_TSI_NUM_REG_MIN_NUM_TX_TS1_MASK_SHIFT(reg) (((reg) & USB3D_SS_TX_TSI_NUM_REG_MIN_NUM_TX_TS1_MASK) >> USB3D_SS_TX_TSI_NUM_REG_MIN_NUM_TX_TS1_SHIFT)
#define  USB3D_SS_TX_TSI_NUM_REG_MIN_NUM_TX_TS1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TX_TSI_NUM_REG_MIN_NUM_TX_TS1_MASK) | (((uint32_t)val) << USB3D_SS_TX_TSI_NUM_REG_MIN_NUM_TX_TS1_SHIFT))

#define  USB3D_SS_TX_TSI_NUM_REG_MAX_NUM_TX_TS1_MASK 0xffff
#define  USB3D_SS_TX_TSI_NUM_REG_MAX_NUM_TX_TS1_SHIFT 0
#define  USB3D_SS_TX_TSI_NUM_REG_MAX_NUM_TX_TS1_MASK_SHIFT(reg) (((reg) & USB3D_SS_TX_TSI_NUM_REG_MAX_NUM_TX_TS1_MASK) >> USB3D_SS_TX_TSI_NUM_REG_MAX_NUM_TX_TS1_SHIFT)
#define  USB3D_SS_TX_TSI_NUM_REG_MAX_NUM_TX_TS1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_TX_TSI_NUM_REG_MAX_NUM_TX_TS1_MASK) | (((uint32_t)val) << USB3D_SS_TX_TSI_NUM_REG_MAX_NUM_TX_TS1_SHIFT))

//====================================================================
//Register: START_STATE_DELAY_AND_MIN_TS2_HOT_RESET (START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG)
//====================================================================

#define  USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_MIN_NUM_TX_TS2_HOT_RESET_ASSERT_MASK 0xffff0000
#define  USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_MIN_NUM_TX_TS2_HOT_RESET_ASSERT_SHIFT 16
#define  USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_MIN_NUM_TX_TS2_HOT_RESET_ASSERT_MASK_SHIFT(reg) (((reg) & USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_MIN_NUM_TX_TS2_HOT_RESET_ASSERT_MASK) >> USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_MIN_NUM_TX_TS2_HOT_RESET_ASSERT_SHIFT)
#define  USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_MIN_NUM_TX_TS2_HOT_RESET_ASSERT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_MIN_NUM_TX_TS2_HOT_RESET_ASSERT_MASK) | (((uint32_t)val) << USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_MIN_NUM_TX_TS2_HOT_RESET_ASSERT_SHIFT))

#define  USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_START_STATE_DELAY_AFTER_RX_TERM_ON_MASK 0xffff
#define  USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_START_STATE_DELAY_AFTER_RX_TERM_ON_SHIFT 0
#define  USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_START_STATE_DELAY_AFTER_RX_TERM_ON_MASK_SHIFT(reg) (((reg) & USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_START_STATE_DELAY_AFTER_RX_TERM_ON_MASK) >> USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_START_STATE_DELAY_AFTER_RX_TERM_ON_SHIFT)
#define  USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_START_STATE_DELAY_AFTER_RX_TERM_ON_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_START_STATE_DELAY_AFTER_RX_TERM_ON_MASK) | (((uint32_t)val) << USB3D_SS_START_STATE_DELAY_AND_MIN_TS2_HOT_RESET_REG_START_STATE_DELAY_AFTER_RX_TERM_ON_SHIFT))

//====================================================================
//Register: LOWPOWER_MANAGEMENT_REG (LOWPOWER_MANAGEMENT_REG)
//====================================================================

#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_RESERVED1_MASK 0xfffffff0
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_RESERVED1_SHIFT 4
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOWPOWER_MANAGEMENT_REG_RESERVED1_MASK) >> USB3D_SS_LOWPOWER_MANAGEMENT_REG_RESERVED1_SHIFT)
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOWPOWER_MANAGEMENT_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_LOWPOWER_MANAGEMENT_REG_RESERVED1_SHIFT))

#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U2_MASK 0x8
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U2_SHIFT 3
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U2_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U2_MASK) >> USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U2_SHIFT)
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U2_MASK) | (((uint32_t)val) << USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U2_SHIFT))

#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U1_MASK 0x4
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U1_SHIFT 2
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U1_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U1_MASK) >> USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U1_SHIFT)
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U1_MASK) | (((uint32_t)val) << USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_INIT_U1_SHIFT))

#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U2_MASK 0x2
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U2_SHIFT 1
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U2_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U2_MASK) >> USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U2_SHIFT)
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U2_MASK) | (((uint32_t)val) << USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U2_SHIFT))

#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U1_MASK 0x1
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U1_SHIFT 0
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U1_MASK_SHIFT(reg) (((reg) & USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U1_MASK) >> USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U1_SHIFT)
#define  USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U1_MASK) | (((uint32_t)val) << USB3D_SS_LOWPOWER_MANAGEMENT_REG_SW_EN_REJECT_U1_SHIFT))

//====================================================================
//Register: USB3_SETUP_DP_LOW_REG (USB3_SETUP_DP_LOW_REG)
//====================================================================

#define  USB3D_SS_USB3_SETUP_DP_LOW_REG_SETUP_REG_LOW_MASK 0xffffffff
#define  USB3D_SS_USB3_SETUP_DP_LOW_REG_SETUP_REG_LOW_SHIFT 0
#define  USB3D_SS_USB3_SETUP_DP_LOW_REG_SETUP_REG_LOW_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_SETUP_DP_LOW_REG_SETUP_REG_LOW_MASK) >> USB3D_SS_USB3_SETUP_DP_LOW_REG_SETUP_REG_LOW_SHIFT)
#define  USB3D_SS_USB3_SETUP_DP_LOW_REG_SETUP_REG_LOW_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_SETUP_DP_LOW_REG_SETUP_REG_LOW_MASK) | (((uint32_t)val) << USB3D_SS_USB3_SETUP_DP_LOW_REG_SETUP_REG_LOW_SHIFT))

//====================================================================
//Register: USB3_SETUP_DP_HIGH_REG (USB3_SETUP_DP_HIGH_REG)
//====================================================================

#define  USB3D_SS_USB3_SETUP_DP_HIGH_REG_SETUP_REG_HIGH_MASK 0xffffffff
#define  USB3D_SS_USB3_SETUP_DP_HIGH_REG_SETUP_REG_HIGH_SHIFT 0
#define  USB3D_SS_USB3_SETUP_DP_HIGH_REG_SETUP_REG_HIGH_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_SETUP_DP_HIGH_REG_SETUP_REG_HIGH_MASK) >> USB3D_SS_USB3_SETUP_DP_HIGH_REG_SETUP_REG_HIGH_SHIFT)
#define  USB3D_SS_USB3_SETUP_DP_HIGH_REG_SETUP_REG_HIGH_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_SETUP_DP_HIGH_REG_SETUP_REG_HIGH_MASK) | (((uint32_t)val) << USB3D_SS_USB3_SETUP_DP_HIGH_REG_SETUP_REG_HIGH_SHIFT))

//====================================================================
//Register: USB3_SETUP_CONTROL_REG (USB3_SETUP_CONTROL_REG)
//====================================================================

#define  USB3D_SS_USB3_SETUP_CONTROL_REG_RESERVED1_MASK 0xfffffffe
#define  USB3D_SS_USB3_SETUP_CONTROL_REG_RESERVED1_SHIFT 1
#define  USB3D_SS_USB3_SETUP_CONTROL_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_SETUP_CONTROL_REG_RESERVED1_MASK) >> USB3D_SS_USB3_SETUP_CONTROL_REG_RESERVED1_SHIFT)
#define  USB3D_SS_USB3_SETUP_CONTROL_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_SETUP_CONTROL_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_USB3_SETUP_CONTROL_REG_RESERVED1_SHIFT))

#define  USB3D_SS_USB3_SETUP_CONTROL_REG_SETUP_DATA_FETCHED_MASK 0x1
#define  USB3D_SS_USB3_SETUP_CONTROL_REG_SETUP_DATA_FETCHED_SHIFT 0
#define  USB3D_SS_USB3_SETUP_CONTROL_REG_SETUP_DATA_FETCHED_MASK_SHIFT(reg) (((reg) & USB3D_SS_USB3_SETUP_CONTROL_REG_SETUP_DATA_FETCHED_MASK) >> USB3D_SS_USB3_SETUP_CONTROL_REG_SETUP_DATA_FETCHED_SHIFT)
#define  USB3D_SS_USB3_SETUP_CONTROL_REG_SETUP_DATA_FETCHED_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_USB3_SETUP_CONTROL_REG_SETUP_DATA_FETCHED_MASK) | (((uint32_t)val) << USB3D_SS_USB3_SETUP_CONTROL_REG_SETUP_DATA_FETCHED_SHIFT))

//====================================================================
//Register: DELAY_U1_CNT_INIT_VALUE_REG (DELAY_U1_CNT_INIT_VALUE_REG)
//====================================================================

#define  USB3D_SS_DELAY_U1_CNT_INIT_VALUE_REG_DELAY_U1_CNT_INIT_VALUE_MASK 0xffffffff
#define  USB3D_SS_DELAY_U1_CNT_INIT_VALUE_REG_DELAY_U1_CNT_INIT_VALUE_SHIFT 0
#define  USB3D_SS_DELAY_U1_CNT_INIT_VALUE_REG_DELAY_U1_CNT_INIT_VALUE_MASK_SHIFT(reg) (((reg) & USB3D_SS_DELAY_U1_CNT_INIT_VALUE_REG_DELAY_U1_CNT_INIT_VALUE_MASK) >> USB3D_SS_DELAY_U1_CNT_INIT_VALUE_REG_DELAY_U1_CNT_INIT_VALUE_SHIFT)
#define  USB3D_SS_DELAY_U1_CNT_INIT_VALUE_REG_DELAY_U1_CNT_INIT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DELAY_U1_CNT_INIT_VALUE_REG_DELAY_U1_CNT_INIT_VALUE_MASK) | (((uint32_t)val) << USB3D_SS_DELAY_U1_CNT_INIT_VALUE_REG_DELAY_U1_CNT_INIT_VALUE_SHIFT))

//====================================================================
//Register: DELAY_U2_CNT_INIT_VALUE_REG (DELAY_U2_CNT_INIT_VALUE_REG)
//====================================================================

#define  USB3D_SS_DELAY_U2_CNT_INIT_VALUE_REG_DELAY_U2_CNT_INIT_VALUE_MASK 0xffffffff
#define  USB3D_SS_DELAY_U2_CNT_INIT_VALUE_REG_DELAY_U2_CNT_INIT_VALUE_SHIFT 0
#define  USB3D_SS_DELAY_U2_CNT_INIT_VALUE_REG_DELAY_U2_CNT_INIT_VALUE_MASK_SHIFT(reg) (((reg) & USB3D_SS_DELAY_U2_CNT_INIT_VALUE_REG_DELAY_U2_CNT_INIT_VALUE_MASK) >> USB3D_SS_DELAY_U2_CNT_INIT_VALUE_REG_DELAY_U2_CNT_INIT_VALUE_SHIFT)
#define  USB3D_SS_DELAY_U2_CNT_INIT_VALUE_REG_DELAY_U2_CNT_INIT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DELAY_U2_CNT_INIT_VALUE_REG_DELAY_U2_CNT_INIT_VALUE_MASK) | (((uint32_t)val) << USB3D_SS_DELAY_U2_CNT_INIT_VALUE_REG_DELAY_U2_CNT_INIT_VALUE_SHIFT))

//====================================================================
//Register: NO_BURST_MODE_REG (NO_BURST_MODE_REG)
//====================================================================

#define  USB3D_SS_NO_BURST_MODE_REG_RESERVED1_MASK 0xfffffffe
#define  USB3D_SS_NO_BURST_MODE_REG_RESERVED1_SHIFT 1
#define  USB3D_SS_NO_BURST_MODE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_NO_BURST_MODE_REG_RESERVED1_MASK) >> USB3D_SS_NO_BURST_MODE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_NO_BURST_MODE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_NO_BURST_MODE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_NO_BURST_MODE_REG_RESERVED1_SHIFT))

#define  USB3D_SS_NO_BURST_MODE_REG_NO_BURST_MODE_MASK 0x1
#define  USB3D_SS_NO_BURST_MODE_REG_NO_BURST_MODE_SHIFT 0
#define  USB3D_SS_NO_BURST_MODE_REG_NO_BURST_MODE_MASK_SHIFT(reg) (((reg) & USB3D_SS_NO_BURST_MODE_REG_NO_BURST_MODE_MASK) >> USB3D_SS_NO_BURST_MODE_REG_NO_BURST_MODE_SHIFT)
#define  USB3D_SS_NO_BURST_MODE_REG_NO_BURST_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_NO_BURST_MODE_REG_NO_BURST_MODE_MASK) | (((uint32_t)val) << USB3D_SS_NO_BURST_MODE_REG_NO_BURST_MODE_SHIFT))

//====================================================================
//Register: DMA_GLOBAL_CONFIG_REG (DMA_GLOBAL_CONFIG_REG)
//====================================================================

#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_RESERVED1_MASK 0xffffff00
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_RESERVED1_SHIFT 8
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_GLOBAL_CONFIG_REG_RESERVED1_MASK) >> USB3D_SS_DMA_GLOBAL_CONFIG_REG_RESERVED1_SHIFT)
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_GLOBAL_CONFIG_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_GLOBAL_CONFIG_REG_RESERVED1_SHIFT))

#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_STAT_EN_MASK 0x80
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_STAT_EN_SHIFT 7
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_STAT_EN_MASK) >> USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_STAT_EN_SHIFT)
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_STAT_EN_SHIFT))

#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_RXFIFO_RESET_MASK 0x40
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_RXFIFO_RESET_SHIFT 6
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_RXFIFO_RESET_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_RXFIFO_RESET_MASK) >> USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_RXFIFO_RESET_SHIFT)
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_RXFIFO_RESET_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_RXFIFO_RESET_MASK) | (((uint32_t)val) << USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_RXFIFO_RESET_SHIFT))

#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_TXFIFO_RESET_MASK 0x20
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_TXFIFO_RESET_SHIFT 5
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_TXFIFO_RESET_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_TXFIFO_RESET_MASK) >> USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_TXFIFO_RESET_SHIFT)
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_TXFIFO_RESET_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_TXFIFO_RESET_MASK) | (((uint32_t)val) << USB3D_SS_DMA_GLOBAL_CONFIG_REG_GLOBAL_TXFIFO_RESET_SHIFT))

#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_ISO_CONTROL_MASK 0x10
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_ISO_CONTROL_SHIFT 4
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_ISO_CONTROL_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_ISO_CONTROL_MASK) >> USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_ISO_CONTROL_SHIFT)
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_ISO_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_ISO_CONTROL_MASK) | (((uint32_t)val) << USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_ISO_CONTROL_SHIFT))

#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_INTCLR_MODE_MASK 0x8
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_INTCLR_MODE_SHIFT 3
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_INTCLR_MODE_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_INTCLR_MODE_MASK) >> USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_INTCLR_MODE_SHIFT)
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_INTCLR_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_INTCLR_MODE_MASK) | (((uint32_t)val) << USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_INTCLR_MODE_SHIFT))

#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_MASK 0x4
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_SHIFT 2
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_MASK) >> USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_SHIFT)
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_MASK) | (((uint32_t)val) << USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_DONE_SHIFT))

#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RUN_MASK 0x2
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RUN_SHIFT 1
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RUN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RUN_MASK) >> USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RUN_SHIFT)
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RUN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RUN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RUN_SHIFT))

#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_MASK 0x1
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_SHIFT 0
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_MASK) >> USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_SHIFT)
#define  USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_MASK) | (((uint32_t)val) << USB3D_SS_DMA_GLOBAL_CONFIG_REG_DMA_RESET_SHIFT))

//====================================================================
//Register: BULK_STREAMING_ENABLE_REG (BULK_STREAMING_ENABLE_REG)
//====================================================================

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_15_MASK 0x80000000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_15_SHIFT 31
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_15_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_15_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_15_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_15_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_14_MASK 0x40000000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_14_SHIFT 30
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_14_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_14_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_14_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_14_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_13_MASK 0x20000000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_13_SHIFT 29
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_13_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_13_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_13_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_13_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_12_MASK 0x10000000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_12_SHIFT 28
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_12_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_12_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_12_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_12_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_11_MASK 0x8000000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_11_SHIFT 27
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_11_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_11_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_11_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_11_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_10_MASK 0x4000000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_10_SHIFT 26
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_10_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_10_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_10_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_10_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_9_MASK 0x2000000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_9_SHIFT 25
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_9_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_9_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_9_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_9_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_8_MASK 0x1000000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_8_SHIFT 24
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_8_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_8_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_8_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_8_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_7_MASK 0x800000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_7_SHIFT 23
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_7_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_7_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_7_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_7_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_6_MASK 0x400000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_6_SHIFT 22
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_6_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_6_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_6_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_6_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_5_MASK 0x200000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_5_SHIFT 21
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_5_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_5_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_5_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_5_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_4_MASK 0x100000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_4_SHIFT 20
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_4_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_4_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_4_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_4_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_3_MASK 0x80000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_3_SHIFT 19
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_3_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_3_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_3_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_3_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_2_MASK 0x40000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_2_SHIFT 18
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_2_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_2_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_2_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_2_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_1_MASK 0x20000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_1_SHIFT 17
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_1_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_1_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_1_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_IN_1_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED1_MASK 0x10000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED1_SHIFT 16
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED1_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED1_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_15_MASK 0x8000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_15_SHIFT 15
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_15_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_15_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_15_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_15_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_14_MASK 0x4000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_14_SHIFT 14
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_14_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_14_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_14_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_14_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_13_MASK 0x2000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_13_SHIFT 13
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_13_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_13_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_13_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_13_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_12_MASK 0x1000
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_12_SHIFT 12
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_12_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_12_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_12_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_12_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_11_MASK 0x800
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_11_SHIFT 11
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_11_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_11_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_11_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_11_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_10_MASK 0x400
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_10_SHIFT 10
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_10_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_10_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_10_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_10_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_9_MASK 0x200
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_9_SHIFT 9
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_9_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_9_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_9_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_9_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_8_MASK 0x100
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_8_SHIFT 8
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_8_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_8_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_8_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_8_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_7_MASK 0x80
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_7_SHIFT 7
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_7_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_7_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_7_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_7_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_6_MASK 0x40
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_6_SHIFT 6
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_6_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_6_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_6_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_6_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_5_MASK 0x20
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_5_SHIFT 5
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_5_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_5_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_5_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_5_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_4_MASK 0x10
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_4_SHIFT 4
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_4_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_4_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_4_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_4_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_3_MASK 0x8
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_3_SHIFT 3
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_3_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_3_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_3_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_3_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_2_MASK 0x4
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_2_SHIFT 2
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_2_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_2_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_2_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_2_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_1_MASK 0x2
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_1_SHIFT 1
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_1_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_1_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_1_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_BULK_STREAMING_ENABLE_OUT_1_SHIFT))

#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED2_MASK 0x1
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED2_SHIFT 0
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED2_MASK) >> USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED2_SHIFT)
#define  USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_BULK_STREAMING_ENABLE_REG_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_1 (EP_OUT_RCV_STREAM_ID_REG_1)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_EP_OUT_RCV_STREAM_ID_1_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_EP_OUT_RCV_STREAM_ID_1_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_EP_OUT_RCV_STREAM_ID_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_EP_OUT_RCV_STREAM_ID_1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_EP_OUT_RCV_STREAM_ID_1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_EP_OUT_RCV_STREAM_ID_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_EP_OUT_RCV_STREAM_ID_1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_1_EP_OUT_RCV_STREAM_ID_1_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_2 (EP_OUT_RCV_STREAM_ID_REG_2)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_EP_OUT_RCV_STREAM_ID_2_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_EP_OUT_RCV_STREAM_ID_2_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_EP_OUT_RCV_STREAM_ID_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_EP_OUT_RCV_STREAM_ID_2_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_EP_OUT_RCV_STREAM_ID_2_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_EP_OUT_RCV_STREAM_ID_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_EP_OUT_RCV_STREAM_ID_2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_2_EP_OUT_RCV_STREAM_ID_2_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_3 (EP_OUT_RCV_STREAM_ID_REG_3)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_EP_OUT_RCV_STREAM_ID_3_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_EP_OUT_RCV_STREAM_ID_3_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_EP_OUT_RCV_STREAM_ID_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_EP_OUT_RCV_STREAM_ID_3_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_EP_OUT_RCV_STREAM_ID_3_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_EP_OUT_RCV_STREAM_ID_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_EP_OUT_RCV_STREAM_ID_3_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_3_EP_OUT_RCV_STREAM_ID_3_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_4 (EP_OUT_RCV_STREAM_ID_REG_4)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_EP_OUT_RCV_STREAM_ID_4_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_EP_OUT_RCV_STREAM_ID_4_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_EP_OUT_RCV_STREAM_ID_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_EP_OUT_RCV_STREAM_ID_4_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_EP_OUT_RCV_STREAM_ID_4_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_EP_OUT_RCV_STREAM_ID_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_EP_OUT_RCV_STREAM_ID_4_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_4_EP_OUT_RCV_STREAM_ID_4_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_5 (EP_OUT_RCV_STREAM_ID_REG_5)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_EP_OUT_RCV_STREAM_ID_5_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_EP_OUT_RCV_STREAM_ID_5_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_EP_OUT_RCV_STREAM_ID_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_EP_OUT_RCV_STREAM_ID_5_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_EP_OUT_RCV_STREAM_ID_5_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_EP_OUT_RCV_STREAM_ID_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_EP_OUT_RCV_STREAM_ID_5_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_5_EP_OUT_RCV_STREAM_ID_5_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_6 (EP_OUT_RCV_STREAM_ID_REG_6)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_EP_OUT_RCV_STREAM_ID_6_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_EP_OUT_RCV_STREAM_ID_6_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_EP_OUT_RCV_STREAM_ID_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_EP_OUT_RCV_STREAM_ID_6_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_EP_OUT_RCV_STREAM_ID_6_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_EP_OUT_RCV_STREAM_ID_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_EP_OUT_RCV_STREAM_ID_6_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_6_EP_OUT_RCV_STREAM_ID_6_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_7 (EP_OUT_RCV_STREAM_ID_REG_7)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_EP_OUT_RCV_STREAM_ID_7_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_EP_OUT_RCV_STREAM_ID_7_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_EP_OUT_RCV_STREAM_ID_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_EP_OUT_RCV_STREAM_ID_7_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_EP_OUT_RCV_STREAM_ID_7_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_EP_OUT_RCV_STREAM_ID_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_EP_OUT_RCV_STREAM_ID_7_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_7_EP_OUT_RCV_STREAM_ID_7_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_8 (EP_OUT_RCV_STREAM_ID_REG_8)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_EP_OUT_RCV_STREAM_ID_8_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_EP_OUT_RCV_STREAM_ID_8_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_EP_OUT_RCV_STREAM_ID_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_EP_OUT_RCV_STREAM_ID_8_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_EP_OUT_RCV_STREAM_ID_8_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_EP_OUT_RCV_STREAM_ID_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_EP_OUT_RCV_STREAM_ID_8_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_8_EP_OUT_RCV_STREAM_ID_8_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_9 (EP_OUT_RCV_STREAM_ID_REG_9)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_EP_OUT_RCV_STREAM_ID_9_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_EP_OUT_RCV_STREAM_ID_9_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_EP_OUT_RCV_STREAM_ID_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_EP_OUT_RCV_STREAM_ID_9_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_EP_OUT_RCV_STREAM_ID_9_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_EP_OUT_RCV_STREAM_ID_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_EP_OUT_RCV_STREAM_ID_9_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_9_EP_OUT_RCV_STREAM_ID_9_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_10 (EP_OUT_RCV_STREAM_ID_REG_10)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_EP_OUT_RCV_STREAM_ID_10_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_EP_OUT_RCV_STREAM_ID_10_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_EP_OUT_RCV_STREAM_ID_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_EP_OUT_RCV_STREAM_ID_10_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_EP_OUT_RCV_STREAM_ID_10_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_EP_OUT_RCV_STREAM_ID_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_EP_OUT_RCV_STREAM_ID_10_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_10_EP_OUT_RCV_STREAM_ID_10_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_11 (EP_OUT_RCV_STREAM_ID_REG_11)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_EP_OUT_RCV_STREAM_ID_11_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_EP_OUT_RCV_STREAM_ID_11_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_EP_OUT_RCV_STREAM_ID_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_EP_OUT_RCV_STREAM_ID_11_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_EP_OUT_RCV_STREAM_ID_11_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_EP_OUT_RCV_STREAM_ID_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_EP_OUT_RCV_STREAM_ID_11_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_11_EP_OUT_RCV_STREAM_ID_11_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_12 (EP_OUT_RCV_STREAM_ID_REG_12)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_EP_OUT_RCV_STREAM_ID_12_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_EP_OUT_RCV_STREAM_ID_12_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_EP_OUT_RCV_STREAM_ID_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_EP_OUT_RCV_STREAM_ID_12_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_EP_OUT_RCV_STREAM_ID_12_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_EP_OUT_RCV_STREAM_ID_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_EP_OUT_RCV_STREAM_ID_12_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_12_EP_OUT_RCV_STREAM_ID_12_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_13 (EP_OUT_RCV_STREAM_ID_REG_13)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_EP_OUT_RCV_STREAM_ID_13_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_EP_OUT_RCV_STREAM_ID_13_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_EP_OUT_RCV_STREAM_ID_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_EP_OUT_RCV_STREAM_ID_13_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_EP_OUT_RCV_STREAM_ID_13_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_EP_OUT_RCV_STREAM_ID_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_EP_OUT_RCV_STREAM_ID_13_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_13_EP_OUT_RCV_STREAM_ID_13_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_14 (EP_OUT_RCV_STREAM_ID_REG_14)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_EP_OUT_RCV_STREAM_ID_14_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_EP_OUT_RCV_STREAM_ID_14_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_EP_OUT_RCV_STREAM_ID_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_EP_OUT_RCV_STREAM_ID_14_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_EP_OUT_RCV_STREAM_ID_14_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_EP_OUT_RCV_STREAM_ID_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_EP_OUT_RCV_STREAM_ID_14_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_14_EP_OUT_RCV_STREAM_ID_14_SHIFT))

//====================================================================
//Register: EP_OUT_RCV_STREAM_ID_REG_15 (EP_OUT_RCV_STREAM_ID_REG_15)
//====================================================================

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_EP_OUT_RCV_STREAM_ID_15_MASK 0xffff
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_EP_OUT_RCV_STREAM_ID_15_SHIFT 0
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_EP_OUT_RCV_STREAM_ID_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_EP_OUT_RCV_STREAM_ID_15_MASK) >> USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_EP_OUT_RCV_STREAM_ID_15_SHIFT)
#define  USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_EP_OUT_RCV_STREAM_ID_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_EP_OUT_RCV_STREAM_ID_15_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RCV_STREAM_ID_REG_15_EP_OUT_RCV_STREAM_ID_15_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_1 (EP_IN_RCV_STREAM_ID_REG_1)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_EP_IN_RCV_STREAM_ID_1_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_EP_IN_RCV_STREAM_ID_1_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_EP_IN_RCV_STREAM_ID_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_EP_IN_RCV_STREAM_ID_1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_EP_IN_RCV_STREAM_ID_1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_EP_IN_RCV_STREAM_ID_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_EP_IN_RCV_STREAM_ID_1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_1_EP_IN_RCV_STREAM_ID_1_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_2 (EP_IN_RCV_STREAM_ID_REG_2)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_EP_IN_RCV_STREAM_ID_2_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_EP_IN_RCV_STREAM_ID_2_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_EP_IN_RCV_STREAM_ID_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_EP_IN_RCV_STREAM_ID_2_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_EP_IN_RCV_STREAM_ID_2_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_EP_IN_RCV_STREAM_ID_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_EP_IN_RCV_STREAM_ID_2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_2_EP_IN_RCV_STREAM_ID_2_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_3 (EP_IN_RCV_STREAM_ID_REG_3)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_EP_IN_RCV_STREAM_ID_3_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_EP_IN_RCV_STREAM_ID_3_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_EP_IN_RCV_STREAM_ID_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_EP_IN_RCV_STREAM_ID_3_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_EP_IN_RCV_STREAM_ID_3_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_EP_IN_RCV_STREAM_ID_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_EP_IN_RCV_STREAM_ID_3_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_3_EP_IN_RCV_STREAM_ID_3_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_4 (EP_IN_RCV_STREAM_ID_REG_4)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_EP_IN_RCV_STREAM_ID_4_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_EP_IN_RCV_STREAM_ID_4_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_EP_IN_RCV_STREAM_ID_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_EP_IN_RCV_STREAM_ID_4_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_EP_IN_RCV_STREAM_ID_4_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_EP_IN_RCV_STREAM_ID_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_EP_IN_RCV_STREAM_ID_4_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_4_EP_IN_RCV_STREAM_ID_4_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_5 (EP_IN_RCV_STREAM_ID_REG_5)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_EP_IN_RCV_STREAM_ID_5_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_EP_IN_RCV_STREAM_ID_5_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_EP_IN_RCV_STREAM_ID_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_EP_IN_RCV_STREAM_ID_5_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_EP_IN_RCV_STREAM_ID_5_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_EP_IN_RCV_STREAM_ID_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_EP_IN_RCV_STREAM_ID_5_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_5_EP_IN_RCV_STREAM_ID_5_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_6 (EP_IN_RCV_STREAM_ID_REG_6)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_EP_IN_RCV_STREAM_ID_6_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_EP_IN_RCV_STREAM_ID_6_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_EP_IN_RCV_STREAM_ID_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_EP_IN_RCV_STREAM_ID_6_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_EP_IN_RCV_STREAM_ID_6_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_EP_IN_RCV_STREAM_ID_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_EP_IN_RCV_STREAM_ID_6_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_6_EP_IN_RCV_STREAM_ID_6_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_7 (EP_IN_RCV_STREAM_ID_REG_7)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_EP_IN_RCV_STREAM_ID_7_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_EP_IN_RCV_STREAM_ID_7_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_EP_IN_RCV_STREAM_ID_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_EP_IN_RCV_STREAM_ID_7_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_EP_IN_RCV_STREAM_ID_7_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_EP_IN_RCV_STREAM_ID_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_EP_IN_RCV_STREAM_ID_7_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_7_EP_IN_RCV_STREAM_ID_7_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_8 (EP_IN_RCV_STREAM_ID_REG_8)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_EP_IN_RCV_STREAM_ID_8_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_EP_IN_RCV_STREAM_ID_8_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_EP_IN_RCV_STREAM_ID_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_EP_IN_RCV_STREAM_ID_8_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_EP_IN_RCV_STREAM_ID_8_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_EP_IN_RCV_STREAM_ID_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_EP_IN_RCV_STREAM_ID_8_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_8_EP_IN_RCV_STREAM_ID_8_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_9 (EP_IN_RCV_STREAM_ID_REG_9)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_EP_IN_RCV_STREAM_ID_9_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_EP_IN_RCV_STREAM_ID_9_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_EP_IN_RCV_STREAM_ID_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_EP_IN_RCV_STREAM_ID_9_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_EP_IN_RCV_STREAM_ID_9_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_EP_IN_RCV_STREAM_ID_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_EP_IN_RCV_STREAM_ID_9_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_9_EP_IN_RCV_STREAM_ID_9_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_10 (EP_IN_RCV_STREAM_ID_REG_10)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_EP_IN_RCV_STREAM_ID_10_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_EP_IN_RCV_STREAM_ID_10_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_EP_IN_RCV_STREAM_ID_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_EP_IN_RCV_STREAM_ID_10_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_EP_IN_RCV_STREAM_ID_10_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_EP_IN_RCV_STREAM_ID_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_EP_IN_RCV_STREAM_ID_10_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_10_EP_IN_RCV_STREAM_ID_10_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_11 (EP_IN_RCV_STREAM_ID_REG_11)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_EP_IN_RCV_STREAM_ID_11_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_EP_IN_RCV_STREAM_ID_11_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_EP_IN_RCV_STREAM_ID_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_EP_IN_RCV_STREAM_ID_11_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_EP_IN_RCV_STREAM_ID_11_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_EP_IN_RCV_STREAM_ID_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_EP_IN_RCV_STREAM_ID_11_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_11_EP_IN_RCV_STREAM_ID_11_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_12 (EP_IN_RCV_STREAM_ID_REG_12)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_EP_IN_RCV_STREAM_ID_12_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_EP_IN_RCV_STREAM_ID_12_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_EP_IN_RCV_STREAM_ID_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_EP_IN_RCV_STREAM_ID_12_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_EP_IN_RCV_STREAM_ID_12_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_EP_IN_RCV_STREAM_ID_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_EP_IN_RCV_STREAM_ID_12_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_12_EP_IN_RCV_STREAM_ID_12_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_13 (EP_IN_RCV_STREAM_ID_REG_13)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_EP_IN_RCV_STREAM_ID_13_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_EP_IN_RCV_STREAM_ID_13_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_EP_IN_RCV_STREAM_ID_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_EP_IN_RCV_STREAM_ID_13_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_EP_IN_RCV_STREAM_ID_13_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_EP_IN_RCV_STREAM_ID_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_EP_IN_RCV_STREAM_ID_13_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_13_EP_IN_RCV_STREAM_ID_13_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_14 (EP_IN_RCV_STREAM_ID_REG_14)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_EP_IN_RCV_STREAM_ID_14_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_EP_IN_RCV_STREAM_ID_14_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_EP_IN_RCV_STREAM_ID_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_EP_IN_RCV_STREAM_ID_14_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_EP_IN_RCV_STREAM_ID_14_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_EP_IN_RCV_STREAM_ID_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_EP_IN_RCV_STREAM_ID_14_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_14_EP_IN_RCV_STREAM_ID_14_SHIFT))

//====================================================================
//Register: EP_IN_RCV_STREAM_ID_REG_15 (EP_IN_RCV_STREAM_ID_REG_15)
//====================================================================

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_RESERVED1_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_EP_IN_RCV_STREAM_ID_15_MASK 0xffff
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_EP_IN_RCV_STREAM_ID_15_SHIFT 0
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_EP_IN_RCV_STREAM_ID_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_EP_IN_RCV_STREAM_ID_15_MASK) >> USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_EP_IN_RCV_STREAM_ID_15_SHIFT)
#define  USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_EP_IN_RCV_STREAM_ID_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_EP_IN_RCV_STREAM_ID_15_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_RCV_STREAM_ID_REG_15_EP_IN_RCV_STREAM_ID_15_SHIFT))

//====================================================================
//Register: DMA_COMPLETE_SUCCESS_STATUS_REG (DMA_COMPLETE_SUCCESS_STATUS_REG)
//====================================================================

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_15_DMA_SUCCESS_MASK 0x80000000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_15_DMA_SUCCESS_SHIFT 31
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_15_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_15_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_15_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_15_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_15_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_15_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_14_DMA_SUCCESS_MASK 0x40000000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_14_DMA_SUCCESS_SHIFT 30
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_14_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_14_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_14_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_14_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_14_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_14_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_13_DMA_SUCCESS_MASK 0x20000000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_13_DMA_SUCCESS_SHIFT 29
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_13_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_13_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_13_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_13_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_13_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_13_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_12_DMA_SUCCESS_MASK 0x10000000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_12_DMA_SUCCESS_SHIFT 28
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_12_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_12_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_12_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_12_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_12_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_12_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_11_DMA_SUCCESS_MASK 0x8000000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_11_DMA_SUCCESS_SHIFT 27
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_11_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_11_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_11_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_11_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_11_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_11_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_10_DMA_SUCCESS_MASK 0x4000000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_10_DMA_SUCCESS_SHIFT 26
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_10_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_10_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_10_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_10_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_10_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_10_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_9_DMA_SUCCESS_MASK 0x2000000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_9_DMA_SUCCESS_SHIFT 25
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_9_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_9_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_9_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_9_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_9_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_9_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_8_DMA_SUCCESS_MASK 0x1000000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_8_DMA_SUCCESS_SHIFT 24
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_8_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_8_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_8_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_8_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_8_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_8_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_7_DMA_SUCCESS_MASK 0x800000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_7_DMA_SUCCESS_SHIFT 23
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_7_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_7_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_7_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_7_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_7_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_7_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_6_DMA_SUCCESS_MASK 0x400000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_6_DMA_SUCCESS_SHIFT 22
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_6_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_6_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_6_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_6_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_6_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_6_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_5_DMA_SUCCESS_MASK 0x200000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_5_DMA_SUCCESS_SHIFT 21
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_5_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_5_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_5_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_5_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_5_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_5_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_4_DMA_SUCCESS_MASK 0x100000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_4_DMA_SUCCESS_SHIFT 20
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_4_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_4_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_4_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_4_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_4_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_4_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_3_DMA_SUCCESS_MASK 0x80000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_3_DMA_SUCCESS_SHIFT 19
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_3_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_3_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_3_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_3_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_3_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_3_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_2_DMA_SUCCESS_MASK 0x40000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_2_DMA_SUCCESS_SHIFT 18
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_2_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_2_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_2_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_2_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_2_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_2_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_1_DMA_SUCCESS_MASK 0x20000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_1_DMA_SUCCESS_SHIFT 17
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_1_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_1_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_1_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_1_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_1_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_1_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_0_DMA_SUCCESS_MASK 0x10000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_0_DMA_SUCCESS_SHIFT 16
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_0_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_0_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_0_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_0_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_0_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_IN_0_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_15_DMA_SUCCESS_MASK 0x8000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_15_DMA_SUCCESS_SHIFT 15
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_15_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_15_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_15_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_15_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_15_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_15_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_14_DMA_SUCCESS_MASK 0x4000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_14_DMA_SUCCESS_SHIFT 14
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_14_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_14_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_14_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_14_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_14_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_14_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_13_DMA_SUCCESS_MASK 0x2000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_13_DMA_SUCCESS_SHIFT 13
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_13_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_13_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_13_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_13_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_13_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_13_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_12_DMA_SUCCESS_MASK 0x1000
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_12_DMA_SUCCESS_SHIFT 12
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_12_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_12_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_12_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_12_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_12_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_12_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_11_DMA_SUCCESS_MASK 0x800
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_11_DMA_SUCCESS_SHIFT 11
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_11_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_11_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_11_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_11_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_11_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_11_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_10_DMA_SUCCESS_MASK 0x400
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_10_DMA_SUCCESS_SHIFT 10
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_10_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_10_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_10_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_10_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_10_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_10_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_9_DMA_SUCCESS_MASK 0x200
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_9_DMA_SUCCESS_SHIFT 9
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_9_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_9_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_9_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_9_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_9_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_9_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_8_DMA_SUCCESS_MASK 0x100
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_8_DMA_SUCCESS_SHIFT 8
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_8_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_8_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_8_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_8_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_8_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_8_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_7_DMA_SUCCESS_MASK 0x80
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_7_DMA_SUCCESS_SHIFT 7
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_7_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_7_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_7_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_7_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_7_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_7_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_6_DMA_SUCCESS_MASK 0x40
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_6_DMA_SUCCESS_SHIFT 6
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_6_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_6_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_6_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_6_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_6_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_6_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_5_DMA_SUCCESS_MASK 0x20
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_5_DMA_SUCCESS_SHIFT 5
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_5_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_5_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_5_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_5_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_5_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_5_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_4_DMA_SUCCESS_MASK 0x10
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_4_DMA_SUCCESS_SHIFT 4
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_4_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_4_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_4_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_4_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_4_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_4_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_3_DMA_SUCCESS_MASK 0x8
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_3_DMA_SUCCESS_SHIFT 3
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_3_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_3_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_3_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_3_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_3_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_3_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_2_DMA_SUCCESS_MASK 0x4
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_2_DMA_SUCCESS_SHIFT 2
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_2_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_2_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_2_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_2_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_2_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_2_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_1_DMA_SUCCESS_MASK 0x2
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_1_DMA_SUCCESS_SHIFT 1
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_1_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_1_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_1_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_1_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_1_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_1_DMA_SUCCESS_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_0_DMA_SUCCESS_MASK 0x1
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_0_DMA_SUCCESS_SHIFT 0
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_0_DMA_SUCCESS_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_0_DMA_SUCCESS_MASK) >> USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_0_DMA_SUCCESS_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_0_DMA_SUCCESS_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_0_DMA_SUCCESS_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_SUCCESS_STATUS_REG_EP_OUT_0_DMA_SUCCESS_SHIFT))

//====================================================================
//Register: DMA_COMPLETE_ERROR_STATUS_REG (DMA_COMPLETE_ERROR_STATUS_REG)
//====================================================================

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_15_DMA_ERROR_MASK 0x80000000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_15_DMA_ERROR_SHIFT 31
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_15_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_15_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_15_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_15_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_15_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_15_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_14_DMA_ERROR_MASK 0x40000000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_14_DMA_ERROR_SHIFT 30
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_14_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_14_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_14_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_14_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_14_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_14_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_13_DMA_ERROR_MASK 0x20000000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_13_DMA_ERROR_SHIFT 29
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_13_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_13_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_13_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_13_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_13_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_13_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_12_DMA_ERROR_MASK 0x10000000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_12_DMA_ERROR_SHIFT 28
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_12_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_12_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_12_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_12_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_12_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_12_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_11_DMA_ERROR_MASK 0x8000000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_11_DMA_ERROR_SHIFT 27
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_11_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_11_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_11_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_11_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_11_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_11_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_10_DMA_ERROR_MASK 0x4000000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_10_DMA_ERROR_SHIFT 26
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_10_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_10_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_10_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_10_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_10_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_10_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_9_DMA_ERROR_MASK 0x2000000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_9_DMA_ERROR_SHIFT 25
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_9_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_9_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_9_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_9_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_9_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_9_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_8_DMA_ERROR_MASK 0x1000000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_8_DMA_ERROR_SHIFT 24
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_8_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_8_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_8_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_8_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_8_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_8_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_7_DMA_ERROR_MASK 0x800000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_7_DMA_ERROR_SHIFT 23
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_7_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_7_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_7_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_7_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_7_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_7_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_6_DMA_ERROR_MASK 0x400000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_6_DMA_ERROR_SHIFT 22
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_6_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_6_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_6_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_6_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_6_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_6_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_5_DMA_ERROR_MASK 0x200000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_5_DMA_ERROR_SHIFT 21
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_5_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_5_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_5_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_5_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_5_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_5_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_4_DMA_ERROR_MASK 0x100000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_4_DMA_ERROR_SHIFT 20
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_4_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_4_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_4_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_4_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_4_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_4_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_3_DMA_ERROR_MASK 0x80000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_3_DMA_ERROR_SHIFT 19
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_3_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_3_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_3_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_3_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_3_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_3_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_2_DMA_ERROR_MASK 0x40000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_2_DMA_ERROR_SHIFT 18
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_2_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_2_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_2_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_2_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_2_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_2_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_1_DMA_ERROR_MASK 0x20000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_1_DMA_ERROR_SHIFT 17
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_1_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_1_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_1_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_1_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_1_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_1_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_0_DMA_ERROR_MASK 0x10000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_0_DMA_ERROR_SHIFT 16
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_0_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_0_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_0_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_0_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_0_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_IN_0_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_15_DMA_ERROR_MASK 0x8000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_15_DMA_ERROR_SHIFT 15
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_15_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_15_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_15_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_15_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_15_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_15_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_14_DMA_ERROR_MASK 0x4000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_14_DMA_ERROR_SHIFT 14
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_14_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_14_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_14_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_14_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_14_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_14_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_13_DMA_ERROR_MASK 0x2000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_13_DMA_ERROR_SHIFT 13
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_13_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_13_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_13_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_13_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_13_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_13_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_12_DMA_ERROR_MASK 0x1000
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_12_DMA_ERROR_SHIFT 12
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_12_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_12_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_12_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_12_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_12_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_12_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_11_DMA_ERROR_MASK 0x800
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_11_DMA_ERROR_SHIFT 11
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_11_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_11_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_11_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_11_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_11_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_11_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_10_DMA_ERROR_MASK 0x400
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_10_DMA_ERROR_SHIFT 10
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_10_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_10_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_10_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_10_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_10_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_10_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_9_DMA_ERROR_MASK 0x200
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_9_DMA_ERROR_SHIFT 9
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_9_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_9_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_9_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_9_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_9_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_9_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_8_DMA_ERROR_MASK 0x100
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_8_DMA_ERROR_SHIFT 8
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_8_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_8_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_8_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_8_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_8_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_8_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_7_DMA_ERROR_MASK 0x80
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_7_DMA_ERROR_SHIFT 7
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_7_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_7_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_7_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_7_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_7_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_7_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_6_DMA_ERROR_MASK 0x40
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_6_DMA_ERROR_SHIFT 6
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_6_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_6_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_6_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_6_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_6_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_6_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_5_DMA_ERROR_MASK 0x20
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_5_DMA_ERROR_SHIFT 5
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_5_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_5_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_5_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_5_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_5_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_5_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_4_DMA_ERROR_MASK 0x10
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_4_DMA_ERROR_SHIFT 4
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_4_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_4_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_4_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_4_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_4_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_4_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_3_DMA_ERROR_MASK 0x8
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_3_DMA_ERROR_SHIFT 3
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_3_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_3_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_3_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_3_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_3_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_3_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_2_DMA_ERROR_MASK 0x4
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_2_DMA_ERROR_SHIFT 2
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_2_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_2_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_2_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_2_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_2_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_2_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_1_DMA_ERROR_MASK 0x2
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_1_DMA_ERROR_SHIFT 1
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_1_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_1_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_1_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_1_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_1_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_1_DMA_ERROR_SHIFT))

#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_0_DMA_ERROR_MASK 0x1
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_0_DMA_ERROR_SHIFT 0
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_0_DMA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_0_DMA_ERROR_MASK) >> USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_0_DMA_ERROR_SHIFT)
#define  USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_0_DMA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_0_DMA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_COMPLETE_ERROR_STATUS_REG_EP_OUT_0_DMA_ERROR_SHIFT))

//====================================================================
//Register: DMA_BD_FETCH_ERROR_STATUS_REG (DMA_BD_FETCH_ERROR_STATUS_REG)
//====================================================================

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_15_DMA_BD_FETCH_ERROR_MASK 0x80000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_15_DMA_BD_FETCH_ERROR_SHIFT 31
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_15_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_15_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_15_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_15_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_15_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_15_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_14_DMA_BD_FETCH_ERROR_MASK 0x40000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_14_DMA_BD_FETCH_ERROR_SHIFT 30
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_14_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_14_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_14_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_14_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_14_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_14_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_13_DMA_BD_FETCH_ERROR_MASK 0x20000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_13_DMA_BD_FETCH_ERROR_SHIFT 29
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_13_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_13_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_13_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_13_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_13_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_13_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_12_DMA_BD_FETCH_ERROR_MASK 0x10000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_12_DMA_BD_FETCH_ERROR_SHIFT 28
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_12_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_12_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_12_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_12_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_12_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_12_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_11_DMA_BD_FETCH_ERROR_MASK 0x8000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_11_DMA_BD_FETCH_ERROR_SHIFT 27
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_11_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_11_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_11_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_11_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_11_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_11_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_10_DMA_BD_FETCH_ERROR_MASK 0x4000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_10_DMA_BD_FETCH_ERROR_SHIFT 26
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_10_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_10_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_10_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_10_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_10_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_10_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_9_DMA_BD_FETCH_ERROR_MASK 0x2000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_9_DMA_BD_FETCH_ERROR_SHIFT 25
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_9_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_9_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_9_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_9_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_9_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_9_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_8_DMA_BD_FETCH_ERROR_MASK 0x1000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_8_DMA_BD_FETCH_ERROR_SHIFT 24
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_8_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_8_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_8_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_8_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_8_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_8_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_7_DMA_BD_FETCH_ERROR_MASK 0x800000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_7_DMA_BD_FETCH_ERROR_SHIFT 23
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_7_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_7_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_7_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_7_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_7_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_7_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_6_DMA_BD_FETCH_ERROR_MASK 0x400000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_6_DMA_BD_FETCH_ERROR_SHIFT 22
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_6_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_6_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_6_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_6_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_6_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_6_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_5_DMA_BD_FETCH_ERROR_MASK 0x200000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_5_DMA_BD_FETCH_ERROR_SHIFT 21
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_5_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_5_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_5_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_5_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_5_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_5_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_4_DMA_BD_FETCH_ERROR_MASK 0x100000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_4_DMA_BD_FETCH_ERROR_SHIFT 20
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_4_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_4_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_4_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_4_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_4_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_4_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_3_DMA_BD_FETCH_ERROR_MASK 0x80000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_3_DMA_BD_FETCH_ERROR_SHIFT 19
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_3_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_3_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_3_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_3_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_3_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_3_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_2_DMA_BD_FETCH_ERROR_MASK 0x40000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_2_DMA_BD_FETCH_ERROR_SHIFT 18
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_2_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_2_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_2_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_2_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_2_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_2_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_1_DMA_BD_FETCH_ERROR_MASK 0x20000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_1_DMA_BD_FETCH_ERROR_SHIFT 17
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_1_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_1_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_1_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_1_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_1_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_1_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_0_DMA_BD_FETCH_ERROR_MASK 0x10000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_0_DMA_BD_FETCH_ERROR_SHIFT 16
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_0_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_0_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_0_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_0_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_0_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_IN_0_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_MASK 0x8000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_SHIFT 15
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_MASK 0x4000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_SHIFT 14
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_MASK 0x2000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_SHIFT 13
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_MASK 0x1000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_SHIFT 12
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_MASK 0x800
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_SHIFT 11
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_MASK 0x400
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_SHIFT 10
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_MASK 0x200
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_SHIFT 9
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_MASK 0x100
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_SHIFT 8
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_MASK 0x80
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_SHIFT 7
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_MASK 0x40
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_SHIFT 6
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_MASK 0x20
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_SHIFT 5
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_MASK 0x10
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_SHIFT 4
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_MASK 0x8
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_SHIFT 3
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_MASK 0x4
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_SHIFT 2
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_MASK 0x2
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_SHIFT 1
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_MASK 0x1
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_SHIFT 0
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_STATUS_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_SHIFT))

//====================================================================
//Register: DMA_BD_FETCH_ERROR_EN_REG (DMA_BD_FETCH_ERROR_EN_REG)
//====================================================================

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_15_DMA_BD_FETCH_ERROR_EN_MASK 0x80000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_15_DMA_BD_FETCH_ERROR_EN_SHIFT 31
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_15_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_15_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_15_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_15_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_15_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_15_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_14_DMA_BD_FETCH_ERROR_EN_MASK 0x40000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_14_DMA_BD_FETCH_ERROR_EN_SHIFT 30
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_14_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_14_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_14_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_14_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_14_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_14_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_13_DMA_BD_FETCH_ERROR_EN_MASK 0x20000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_13_DMA_BD_FETCH_ERROR_EN_SHIFT 29
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_13_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_13_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_13_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_13_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_13_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_13_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_12_DMA_BD_FETCH_ERROR_EN_MASK 0x10000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_12_DMA_BD_FETCH_ERROR_EN_SHIFT 28
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_12_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_12_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_12_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_12_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_12_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_12_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_11_DMA_BD_FETCH_ERROR_EN_MASK 0x8000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_11_DMA_BD_FETCH_ERROR_EN_SHIFT 27
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_11_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_11_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_11_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_11_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_11_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_11_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_10_DMA_BD_FETCH_ERROR_EN_MASK 0x4000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_10_DMA_BD_FETCH_ERROR_EN_SHIFT 26
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_10_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_10_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_10_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_10_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_10_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_10_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_9_DMA_BD_FETCH_ERROR_EN_MASK 0x2000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_9_DMA_BD_FETCH_ERROR_EN_SHIFT 25
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_9_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_9_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_9_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_9_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_9_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_9_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_8_DMA_BD_FETCH_ERROR_EN_MASK 0x1000000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_8_DMA_BD_FETCH_ERROR_EN_SHIFT 24
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_8_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_8_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_8_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_8_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_8_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_8_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_7_DMA_BD_FETCH_ERROR_EN_MASK 0x800000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_7_DMA_BD_FETCH_ERROR_EN_SHIFT 23
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_7_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_7_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_7_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_7_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_7_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_7_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_6_DMA_BD_FETCH_ERROR_EN_MASK 0x400000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_6_DMA_BD_FETCH_ERROR_EN_SHIFT 22
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_6_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_6_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_6_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_6_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_6_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_6_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_5_DMA_BD_FETCH_ERROR_EN_MASK 0x200000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_5_DMA_BD_FETCH_ERROR_EN_SHIFT 21
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_5_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_5_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_5_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_5_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_5_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_5_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_4_DMA_BD_FETCH_ERROR_EN_MASK 0x100000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_4_DMA_BD_FETCH_ERROR_EN_SHIFT 20
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_4_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_4_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_4_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_4_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_4_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_4_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_3_DMA_BD_FETCH_ERROR_EN_MASK 0x80000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_3_DMA_BD_FETCH_ERROR_EN_SHIFT 19
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_3_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_3_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_3_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_3_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_3_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_3_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_2_DMA_BD_FETCH_ERROR_EN_MASK 0x40000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_2_DMA_BD_FETCH_ERROR_EN_SHIFT 18
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_2_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_2_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_2_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_2_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_2_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_2_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_1_DMA_BD_FETCH_ERROR_EN_MASK 0x20000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_1_DMA_BD_FETCH_ERROR_EN_SHIFT 17
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_1_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_1_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_1_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_1_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_1_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_1_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_0_DMA_BD_FETCH_ERROR_EN_MASK 0x10000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_0_DMA_BD_FETCH_ERROR_EN_SHIFT 16
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_0_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_0_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_0_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_0_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_0_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_IN_0_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_EN_MASK 0x8000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_EN_SHIFT 15
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_15_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_EN_MASK 0x4000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_EN_SHIFT 14
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_14_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_EN_MASK 0x2000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_EN_SHIFT 13
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_13_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_EN_MASK 0x1000
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_EN_SHIFT 12
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_12_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_EN_MASK 0x800
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_EN_SHIFT 11
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_11_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_EN_MASK 0x400
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_EN_SHIFT 10
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_10_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_EN_MASK 0x200
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_EN_SHIFT 9
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_9_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_EN_MASK 0x100
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_EN_SHIFT 8
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_8_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_EN_MASK 0x80
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_EN_SHIFT 7
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_7_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_EN_MASK 0x40
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_EN_SHIFT 6
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_6_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_EN_MASK 0x20
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_EN_SHIFT 5
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_5_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_EN_MASK 0x10
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_EN_SHIFT 4
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_4_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_EN_MASK 0x8
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_EN_SHIFT 3
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_3_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_EN_MASK 0x4
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_EN_SHIFT 2
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_2_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_EN_MASK 0x2
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_EN_SHIFT 1
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_1_DMA_BD_FETCH_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_EN_MASK 0x1
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_EN_SHIFT 0
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_EN_MASK) >> USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_BD_FETCH_ERROR_EN_REG_EP_OUT_0_DMA_BD_FETCH_ERROR_EN_SHIFT))

//====================================================================
//Register: DMA_DATA_ERROR_STATUS_REG (DMA_DATA_ERROR_STATUS_REG)
//====================================================================

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_15_DMA_DATA_ERROR_MASK 0x80000000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_15_DMA_DATA_ERROR_SHIFT 31
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_15_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_15_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_15_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_15_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_15_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_15_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_14_DMA_DATA_ERROR_MASK 0x40000000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_14_DMA_DATA_ERROR_SHIFT 30
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_14_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_14_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_14_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_14_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_14_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_14_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_13_DMA_DATA_ERROR_MASK 0x20000000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_13_DMA_DATA_ERROR_SHIFT 29
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_13_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_13_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_13_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_13_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_13_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_13_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_12_DMA_DATA_ERROR_MASK 0x10000000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_12_DMA_DATA_ERROR_SHIFT 28
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_12_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_12_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_12_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_12_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_12_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_12_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_11_DMA_DATA_ERROR_MASK 0x8000000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_11_DMA_DATA_ERROR_SHIFT 27
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_11_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_11_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_11_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_11_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_11_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_11_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_10_DMA_DATA_ERROR_MASK 0x4000000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_10_DMA_DATA_ERROR_SHIFT 26
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_10_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_10_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_10_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_10_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_10_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_10_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_9_DMA_DATA_ERROR_MASK 0x2000000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_9_DMA_DATA_ERROR_SHIFT 25
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_9_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_9_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_9_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_9_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_9_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_9_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_8_DMA_DATA_ERROR_MASK 0x1000000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_8_DMA_DATA_ERROR_SHIFT 24
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_8_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_8_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_8_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_8_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_8_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_8_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_7_DMA_DATA_ERROR_MASK 0x800000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_7_DMA_DATA_ERROR_SHIFT 23
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_7_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_7_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_7_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_7_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_7_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_7_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_6_DMA_DATA_ERROR_MASK 0x400000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_6_DMA_DATA_ERROR_SHIFT 22
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_6_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_6_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_6_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_6_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_6_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_6_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_5_DMA_DATA_ERROR_MASK 0x200000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_5_DMA_DATA_ERROR_SHIFT 21
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_5_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_5_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_5_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_5_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_5_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_5_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_4_DMA_DATA_ERROR_MASK 0x100000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_4_DMA_DATA_ERROR_SHIFT 20
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_4_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_4_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_4_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_4_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_4_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_4_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_3_DMA_DATA_ERROR_MASK 0x80000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_3_DMA_DATA_ERROR_SHIFT 19
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_3_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_3_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_3_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_3_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_3_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_3_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_2_DMA_DATA_ERROR_MASK 0x40000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_2_DMA_DATA_ERROR_SHIFT 18
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_2_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_2_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_2_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_2_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_2_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_2_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_1_DMA_DATA_ERROR_MASK 0x20000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_1_DMA_DATA_ERROR_SHIFT 17
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_1_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_1_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_1_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_1_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_1_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_1_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_0_DMA_DATA_ERROR_MASK 0x10000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_0_DMA_DATA_ERROR_SHIFT 16
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_0_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_0_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_0_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_0_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_0_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_IN_0_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_15_DMA_DATA_ERROR_MASK 0x8000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_15_DMA_DATA_ERROR_SHIFT 15
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_15_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_15_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_15_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_15_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_15_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_15_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_14_DMA_DATA_ERROR_MASK 0x4000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_14_DMA_DATA_ERROR_SHIFT 14
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_14_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_14_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_14_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_14_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_14_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_14_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_13_DMA_DATA_ERROR_MASK 0x2000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_13_DMA_DATA_ERROR_SHIFT 13
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_13_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_13_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_13_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_13_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_13_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_13_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_12_DMA_DATA_ERROR_MASK 0x1000
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_12_DMA_DATA_ERROR_SHIFT 12
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_12_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_12_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_12_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_12_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_12_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_12_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_11_DMA_DATA_ERROR_MASK 0x800
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_11_DMA_DATA_ERROR_SHIFT 11
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_11_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_11_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_11_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_11_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_11_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_11_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_10_DMA_DATA_ERROR_MASK 0x400
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_10_DMA_DATA_ERROR_SHIFT 10
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_10_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_10_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_10_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_10_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_10_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_10_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_9_DMA_DATA_ERROR_MASK 0x200
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_9_DMA_DATA_ERROR_SHIFT 9
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_9_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_9_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_9_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_9_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_9_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_9_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_8_DMA_DATA_ERROR_MASK 0x100
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_8_DMA_DATA_ERROR_SHIFT 8
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_8_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_8_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_8_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_8_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_8_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_8_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_7_DMA_DATA_ERROR_MASK 0x80
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_7_DMA_DATA_ERROR_SHIFT 7
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_7_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_7_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_7_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_7_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_7_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_7_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_6_DMA_DATA_ERROR_MASK 0x40
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_6_DMA_DATA_ERROR_SHIFT 6
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_6_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_6_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_6_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_6_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_6_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_6_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_5_DMA_DATA_ERROR_MASK 0x20
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_5_DMA_DATA_ERROR_SHIFT 5
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_5_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_5_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_5_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_5_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_5_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_5_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_4_DMA_DATA_ERROR_MASK 0x10
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_4_DMA_DATA_ERROR_SHIFT 4
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_4_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_4_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_4_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_4_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_4_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_4_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_3_DMA_DATA_ERROR_MASK 0x8
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_3_DMA_DATA_ERROR_SHIFT 3
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_3_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_3_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_3_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_3_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_3_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_3_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_2_DMA_DATA_ERROR_MASK 0x4
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_2_DMA_DATA_ERROR_SHIFT 2
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_2_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_2_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_2_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_2_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_2_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_2_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_1_DMA_DATA_ERROR_MASK 0x2
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_1_DMA_DATA_ERROR_SHIFT 1
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_1_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_1_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_1_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_1_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_1_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_1_DMA_DATA_ERROR_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_0_DMA_DATA_ERROR_MASK 0x1
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_0_DMA_DATA_ERROR_SHIFT 0
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_0_DMA_DATA_ERROR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_0_DMA_DATA_ERROR_MASK) >> USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_0_DMA_DATA_ERROR_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_0_DMA_DATA_ERROR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_0_DMA_DATA_ERROR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_STATUS_REG_EP_OUT_0_DMA_DATA_ERROR_SHIFT))

//====================================================================
//Register: DMA_DATA_ERROR_EN_REG (DMA_DATA_ERROR_EN_REG)
//====================================================================

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_15_DMA_DATA_ERROR_EN_MASK 0x80000000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_15_DMA_DATA_ERROR_EN_SHIFT 31
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_15_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_15_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_15_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_15_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_15_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_15_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_14_DMA_DATA_ERROR_EN_MASK 0x40000000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_14_DMA_DATA_ERROR_EN_SHIFT 30
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_14_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_14_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_14_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_14_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_14_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_14_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_13_DMA_DATA_ERROR_EN_MASK 0x20000000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_13_DMA_DATA_ERROR_EN_SHIFT 29
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_13_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_13_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_13_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_13_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_13_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_13_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_12_DMA_DATA_ERROR_EN_MASK 0x10000000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_12_DMA_DATA_ERROR_EN_SHIFT 28
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_12_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_12_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_12_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_12_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_12_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_12_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_11_DMA_DATA_ERROR_EN_MASK 0x8000000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_11_DMA_DATA_ERROR_EN_SHIFT 27
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_11_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_11_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_11_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_11_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_11_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_11_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_10_DMA_DATA_ERROR_EN_MASK 0x4000000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_10_DMA_DATA_ERROR_EN_SHIFT 26
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_10_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_10_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_10_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_10_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_10_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_10_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_9_DMA_DATA_ERROR_EN_MASK 0x2000000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_9_DMA_DATA_ERROR_EN_SHIFT 25
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_9_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_9_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_9_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_9_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_9_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_9_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_8_DMA_DATA_ERROR_EN_MASK 0x1000000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_8_DMA_DATA_ERROR_EN_SHIFT 24
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_8_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_8_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_8_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_8_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_8_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_8_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_7_DMA_DATA_ERROR_EN_MASK 0x800000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_7_DMA_DATA_ERROR_EN_SHIFT 23
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_7_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_7_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_7_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_7_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_7_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_7_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_6_DMA_DATA_ERROR_EN_MASK 0x400000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_6_DMA_DATA_ERROR_EN_SHIFT 22
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_6_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_6_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_6_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_6_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_6_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_6_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_5_DMA_DATA_ERROR_EN_MASK 0x200000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_5_DMA_DATA_ERROR_EN_SHIFT 21
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_5_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_5_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_5_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_5_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_5_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_5_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_4_DMA_DATA_ERROR_EN_MASK 0x100000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_4_DMA_DATA_ERROR_EN_SHIFT 20
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_4_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_4_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_4_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_4_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_4_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_4_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_3_DMA_DATA_ERROR_EN_MASK 0x80000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_3_DMA_DATA_ERROR_EN_SHIFT 19
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_3_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_3_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_3_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_3_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_3_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_3_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_2_DMA_DATA_ERROR_EN_MASK 0x40000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_2_DMA_DATA_ERROR_EN_SHIFT 18
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_2_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_2_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_2_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_2_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_2_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_2_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_1_DMA_DATA_ERROR_EN_MASK 0x20000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_1_DMA_DATA_ERROR_EN_SHIFT 17
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_1_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_1_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_1_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_1_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_1_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_1_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_0_DMA_DATA_ERROR_EN_MASK 0x10000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_0_DMA_DATA_ERROR_EN_SHIFT 16
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_0_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_0_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_0_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_0_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_0_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_IN_0_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_15_DMA_DATA_ERROR_EN_MASK 0x8000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_15_DMA_DATA_ERROR_EN_SHIFT 15
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_15_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_15_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_15_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_15_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_15_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_15_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_14_DMA_DATA_ERROR_EN_MASK 0x4000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_14_DMA_DATA_ERROR_EN_SHIFT 14
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_14_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_14_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_14_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_14_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_14_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_14_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_13_DMA_DATA_ERROR_EN_MASK 0x2000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_13_DMA_DATA_ERROR_EN_SHIFT 13
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_13_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_13_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_13_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_13_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_13_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_13_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_12_DMA_DATA_ERROR_EN_MASK 0x1000
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_12_DMA_DATA_ERROR_EN_SHIFT 12
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_12_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_12_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_12_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_12_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_12_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_12_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_11_DMA_DATA_ERROR_EN_MASK 0x800
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_11_DMA_DATA_ERROR_EN_SHIFT 11
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_11_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_11_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_11_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_11_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_11_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_11_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_10_DMA_DATA_ERROR_EN_MASK 0x400
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_10_DMA_DATA_ERROR_EN_SHIFT 10
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_10_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_10_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_10_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_10_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_10_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_10_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_9_DMA_DATA_ERROR_EN_MASK 0x200
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_9_DMA_DATA_ERROR_EN_SHIFT 9
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_9_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_9_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_9_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_9_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_9_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_9_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_8_DMA_DATA_ERROR_EN_MASK 0x100
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_8_DMA_DATA_ERROR_EN_SHIFT 8
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_8_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_8_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_8_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_8_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_8_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_8_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_7_DMA_DATA_ERROR_EN_MASK 0x80
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_7_DMA_DATA_ERROR_EN_SHIFT 7
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_7_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_7_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_7_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_7_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_7_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_7_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_6_DMA_DATA_ERROR_EN_MASK 0x40
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_6_DMA_DATA_ERROR_EN_SHIFT 6
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_6_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_6_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_6_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_6_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_6_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_6_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_5_DMA_DATA_ERROR_EN_MASK 0x20
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_5_DMA_DATA_ERROR_EN_SHIFT 5
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_5_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_5_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_5_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_5_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_5_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_5_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_4_DMA_DATA_ERROR_EN_MASK 0x10
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_4_DMA_DATA_ERROR_EN_SHIFT 4
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_4_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_4_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_4_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_4_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_4_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_4_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_3_DMA_DATA_ERROR_EN_MASK 0x8
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_3_DMA_DATA_ERROR_EN_SHIFT 3
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_3_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_3_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_3_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_3_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_3_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_3_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_2_DMA_DATA_ERROR_EN_MASK 0x4
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_2_DMA_DATA_ERROR_EN_SHIFT 2
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_2_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_2_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_2_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_2_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_2_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_2_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_1_DMA_DATA_ERROR_EN_MASK 0x2
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_1_DMA_DATA_ERROR_EN_SHIFT 1
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_1_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_1_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_1_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_1_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_1_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_1_DMA_DATA_ERROR_EN_SHIFT))

#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_0_DMA_DATA_ERROR_EN_MASK 0x1
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_0_DMA_DATA_ERROR_EN_SHIFT 0
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_0_DMA_DATA_ERROR_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_0_DMA_DATA_ERROR_EN_MASK) >> USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_0_DMA_DATA_ERROR_EN_SHIFT)
#define  USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_0_DMA_DATA_ERROR_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_0_DMA_DATA_ERROR_EN_MASK) | (((uint32_t)val) << USB3D_SS_DMA_DATA_ERROR_EN_REG_EP_OUT_0_DMA_DATA_ERROR_EN_SHIFT))

//====================================================================
//Register: DMA_ERROR_HANDLING_MODE_REG (DMA_ERROR_HANDLING_MODE_REG)
//====================================================================

#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_RESERVED1_MASK 0xfffffff0
#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_RESERVED1_SHIFT 4
#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_RESERVED1_MASK) >> USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_RESERVED1_SHIFT)
#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_RESERVED1_SHIFT))

#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_INBAND_RESET_MODE_MASK 0xc
#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_INBAND_RESET_MODE_SHIFT 2
#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_INBAND_RESET_MODE_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_INBAND_RESET_MODE_MASK) >> USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_INBAND_RESET_MODE_SHIFT)
#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_INBAND_RESET_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_INBAND_RESET_MODE_MASK) | (((uint32_t)val) << USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_INBAND_RESET_MODE_SHIFT))

#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_DMA_ERROR_MODE_MASK 0x3
#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_DMA_ERROR_MODE_SHIFT 0
#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_DMA_ERROR_MODE_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_DMA_ERROR_MODE_MASK) >> USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_DMA_ERROR_MODE_SHIFT)
#define  USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_DMA_ERROR_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_DMA_ERROR_MODE_MASK) | (((uint32_t)val) << USB3D_SS_DMA_ERROR_HANDLING_MODE_REG_DMA_ERROR_MODE_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_0 (EP_OUT_RX_DMA_CONFIG_REG_0)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_0_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_1 (EP_OUT_RX_DMA_CONFIG_REG_1)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_1_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_2 (EP_OUT_RX_DMA_CONFIG_REG_2)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_2_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_3 (EP_OUT_RX_DMA_CONFIG_REG_3)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_3_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_4 (EP_OUT_RX_DMA_CONFIG_REG_4)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_4_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_5 (EP_OUT_RX_DMA_CONFIG_REG_5)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_5_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_6 (EP_OUT_RX_DMA_CONFIG_REG_6)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_6_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_7 (EP_OUT_RX_DMA_CONFIG_REG_7)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_7_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_8 (EP_OUT_RX_DMA_CONFIG_REG_8)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_8_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_9 (EP_OUT_RX_DMA_CONFIG_REG_9)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_9_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_10 (EP_OUT_RX_DMA_CONFIG_REG_10)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_10_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_11 (EP_OUT_RX_DMA_CONFIG_REG_11)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_11_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_12 (EP_OUT_RX_DMA_CONFIG_REG_12)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_12_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_13 (EP_OUT_RX_DMA_CONFIG_REG_13)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_13_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_14 (EP_OUT_RX_DMA_CONFIG_REG_14)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_14_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_CONFIG_REG_15 (EP_OUT_RX_DMA_CONFIG_REG_15)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED1_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED1_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED1_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_START_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_START_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RX_DMA_START_SHIFT))

#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED2_MASK) >> USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED2_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_CONFIG_REG_15_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_0 (EP_IN_TX_DMA_CONFIG_REG_0)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_0_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_1 (EP_IN_TX_DMA_CONFIG_REG_1)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_1_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_2 (EP_IN_TX_DMA_CONFIG_REG_2)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_2_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_3 (EP_IN_TX_DMA_CONFIG_REG_3)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_3_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_4 (EP_IN_TX_DMA_CONFIG_REG_4)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_4_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_5 (EP_IN_TX_DMA_CONFIG_REG_5)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_5_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_6 (EP_IN_TX_DMA_CONFIG_REG_6)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_6_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_7 (EP_IN_TX_DMA_CONFIG_REG_7)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_7_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_8 (EP_IN_TX_DMA_CONFIG_REG_8)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_8_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_9 (EP_IN_TX_DMA_CONFIG_REG_9)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_9_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_10 (EP_IN_TX_DMA_CONFIG_REG_10)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_10_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_11 (EP_IN_TX_DMA_CONFIG_REG_11)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_11_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_12 (EP_IN_TX_DMA_CONFIG_REG_12)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_12_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_13 (EP_IN_TX_DMA_CONFIG_REG_13)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_13_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_14 (EP_IN_TX_DMA_CONFIG_REG_14)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_14_RESERVED2_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_CONFIG_REG_15 (EP_IN_TX_DMA_CONFIG_REG_15)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED1_MASK 0xffff0000
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED1_SHIFT 16
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED1_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED1_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED1_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_INTERVAL_MASK 0xff00
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_INTERVAL_SHIFT 8
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_INTERVAL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_INTERVAL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_INTERVAL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_INTERVAL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_INTERVAL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_MASK 0x80
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_SHIFT 7
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_POLL_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_START_MASK 0x40
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_START_SHIFT 6
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_START_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_START_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_START_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_START_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_START_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_TX_DMA_START_SHIFT))

#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED2_MASK 0x3f
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED2_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED2_MASK) >> USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED2_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_CONFIG_REG_15_RESERVED2_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_0 (EP_OUT_RX_DMA_START_ADDRESS_REG_0)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_0_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_0_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_0_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_0_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_0_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_0_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_0_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_0_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_1 (EP_OUT_RX_DMA_START_ADDRESS_REG_1)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_1_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_1_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_1_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_1_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_1_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_1_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_1_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_1_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_2 (EP_OUT_RX_DMA_START_ADDRESS_REG_2)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_2_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_2_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_2_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_2_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_2_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_2_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_2_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_2_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_3 (EP_OUT_RX_DMA_START_ADDRESS_REG_3)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_3_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_3_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_3_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_3_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_3_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_3_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_3_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_3_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_4 (EP_OUT_RX_DMA_START_ADDRESS_REG_4)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_4_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_4_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_4_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_4_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_4_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_4_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_4_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_4_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_5 (EP_OUT_RX_DMA_START_ADDRESS_REG_5)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_5_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_5_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_5_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_5_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_5_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_5_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_5_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_5_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_6 (EP_OUT_RX_DMA_START_ADDRESS_REG_6)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_6_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_6_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_6_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_6_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_6_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_6_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_6_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_6_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_7 (EP_OUT_RX_DMA_START_ADDRESS_REG_7)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_7_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_7_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_7_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_7_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_7_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_7_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_7_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_7_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_8 (EP_OUT_RX_DMA_START_ADDRESS_REG_8)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_8_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_8_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_8_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_8_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_8_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_8_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_8_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_8_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_9 (EP_OUT_RX_DMA_START_ADDRESS_REG_9)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_9_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_9_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_9_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_9_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_9_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_9_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_9_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_9_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_10 (EP_OUT_RX_DMA_START_ADDRESS_REG_10)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_10_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_10_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_10_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_10_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_10_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_10_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_10_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_10_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_11 (EP_OUT_RX_DMA_START_ADDRESS_REG_11)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_11_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_11_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_11_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_11_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_11_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_11_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_11_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_11_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_12 (EP_OUT_RX_DMA_START_ADDRESS_REG_12)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_12_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_12_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_12_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_12_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_12_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_12_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_12_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_12_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_13 (EP_OUT_RX_DMA_START_ADDRESS_REG_13)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_13_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_13_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_13_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_13_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_13_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_13_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_13_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_13_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_14 (EP_OUT_RX_DMA_START_ADDRESS_REG_14)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_14_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_14_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_14_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_14_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_14_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_14_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_14_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_14_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_RX_DMA_START_ADDRESS_REG_15 (EP_OUT_RX_DMA_START_ADDRESS_REG_15)
//====================================================================

#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_15_CSR_ODF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_15_CSR_ODF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_15_CSR_ODF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_15_CSR_ODF_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_15_CSR_ODF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_15_CSR_ODF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_15_CSR_ODF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_RX_DMA_START_ADDRESS_REG_15_CSR_ODF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_0 (EP_IN_TX_DMA_START_ADDRESS_REG_0)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_0_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_0_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_0_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_0_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_0_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_0_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_0_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_0_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_1 (EP_IN_TX_DMA_START_ADDRESS_REG_1)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_1_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_1_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_1_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_1_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_1_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_1_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_1_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_1_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_2 (EP_IN_TX_DMA_START_ADDRESS_REG_2)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_2_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_2_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_2_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_2_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_2_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_2_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_2_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_2_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_3 (EP_IN_TX_DMA_START_ADDRESS_REG_3)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_3_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_3_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_3_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_3_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_3_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_3_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_3_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_3_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_4 (EP_IN_TX_DMA_START_ADDRESS_REG_4)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_4_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_4_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_4_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_4_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_4_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_4_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_4_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_4_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_5 (EP_IN_TX_DMA_START_ADDRESS_REG_5)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_5_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_5_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_5_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_5_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_5_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_5_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_5_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_5_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_6 (EP_IN_TX_DMA_START_ADDRESS_REG_6)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_6_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_6_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_6_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_6_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_6_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_6_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_6_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_6_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_7 (EP_IN_TX_DMA_START_ADDRESS_REG_7)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_7_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_7_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_7_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_7_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_7_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_7_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_7_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_7_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_8 (EP_IN_TX_DMA_START_ADDRESS_REG_8)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_8_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_8_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_8_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_8_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_8_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_8_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_8_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_8_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_9 (EP_IN_TX_DMA_START_ADDRESS_REG_9)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_9_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_9_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_9_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_9_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_9_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_9_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_9_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_9_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_10 (EP_IN_TX_DMA_START_ADDRESS_REG_10)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_10_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_10_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_10_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_10_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_10_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_10_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_10_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_10_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_11 (EP_IN_TX_DMA_START_ADDRESS_REG_11)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_11_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_11_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_11_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_11_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_11_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_11_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_11_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_11_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_12 (EP_IN_TX_DMA_START_ADDRESS_REG_12)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_12_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_12_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_12_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_12_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_12_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_12_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_12_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_12_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_13 (EP_IN_TX_DMA_START_ADDRESS_REG_13)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_13_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_13_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_13_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_13_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_13_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_13_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_13_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_13_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_14 (EP_IN_TX_DMA_START_ADDRESS_REG_14)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_14_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_14_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_14_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_14_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_14_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_14_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_14_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_14_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_TX_DMA_START_ADDRESS_REG_15 (EP_IN_TX_DMA_START_ADDRESS_REG_15)
//====================================================================

#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_15_CSR_IDF_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_15_CSR_IDF_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_15_CSR_IDF_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_15_CSR_IDF_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_15_CSR_IDF_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_15_CSR_IDF_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_15_CSR_IDF_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_TX_DMA_START_ADDRESS_REG_15_CSR_IDF_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_0 (EP_OUT_DMA_ERROR_ADDRESS_REG_0)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_0_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_0_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_0_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_0_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_0_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_0_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_0_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_0_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_1 (EP_OUT_DMA_ERROR_ADDRESS_REG_1)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_1_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_1_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_1_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_1_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_1_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_1_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_1_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_1_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_2 (EP_OUT_DMA_ERROR_ADDRESS_REG_2)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_2_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_2_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_2_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_2_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_2_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_2_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_2_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_2_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_3 (EP_OUT_DMA_ERROR_ADDRESS_REG_3)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_3_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_3_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_3_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_3_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_3_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_3_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_3_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_3_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_4 (EP_OUT_DMA_ERROR_ADDRESS_REG_4)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_4_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_4_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_4_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_4_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_4_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_4_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_4_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_4_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_5 (EP_OUT_DMA_ERROR_ADDRESS_REG_5)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_5_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_5_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_5_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_5_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_5_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_5_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_5_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_5_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_6 (EP_OUT_DMA_ERROR_ADDRESS_REG_6)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_6_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_6_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_6_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_6_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_6_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_6_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_6_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_6_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_7 (EP_OUT_DMA_ERROR_ADDRESS_REG_7)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_7_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_7_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_7_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_7_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_7_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_7_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_7_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_7_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_8 (EP_OUT_DMA_ERROR_ADDRESS_REG_8)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_8_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_8_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_8_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_8_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_8_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_8_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_8_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_8_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_9 (EP_OUT_DMA_ERROR_ADDRESS_REG_9)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_9_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_9_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_9_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_9_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_9_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_9_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_9_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_9_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_10 (EP_OUT_DMA_ERROR_ADDRESS_REG_10)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_10_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_10_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_10_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_10_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_10_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_10_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_10_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_10_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_11 (EP_OUT_DMA_ERROR_ADDRESS_REG_11)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_11_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_11_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_11_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_11_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_11_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_11_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_11_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_11_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_12 (EP_OUT_DMA_ERROR_ADDRESS_REG_12)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_12_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_12_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_12_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_12_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_12_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_12_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_12_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_12_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_13 (EP_OUT_DMA_ERROR_ADDRESS_REG_13)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_13_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_13_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_13_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_13_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_13_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_13_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_13_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_13_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_14 (EP_OUT_DMA_ERROR_ADDRESS_REG_14)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_14_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_14_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_14_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_14_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_14_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_14_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_14_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_14_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_OUT_DMA_ERROR_ADDRESS_REG_15 (EP_OUT_DMA_ERROR_ADDRESS_REG_15)
//====================================================================

#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_15_OUT_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_15_OUT_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_15_OUT_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_15_OUT_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_15_OUT_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_15_OUT_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_15_OUT_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DMA_ERROR_ADDRESS_REG_15_OUT_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_0 (EP_IN_DMA_ERROR_ADDRESS_REG_0)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_0_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_0_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_0_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_0_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_0_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_0_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_0_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_0_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_1 (EP_IN_DMA_ERROR_ADDRESS_REG_1)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_1_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_1_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_1_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_1_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_1_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_1_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_1_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_1_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_2 (EP_IN_DMA_ERROR_ADDRESS_REG_2)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_2_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_2_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_2_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_2_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_2_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_2_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_2_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_2_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_3 (EP_IN_DMA_ERROR_ADDRESS_REG_3)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_3_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_3_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_3_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_3_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_3_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_3_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_3_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_3_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_4 (EP_IN_DMA_ERROR_ADDRESS_REG_4)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_4_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_4_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_4_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_4_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_4_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_4_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_4_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_4_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_5 (EP_IN_DMA_ERROR_ADDRESS_REG_5)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_5_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_5_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_5_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_5_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_5_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_5_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_5_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_5_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_6 (EP_IN_DMA_ERROR_ADDRESS_REG_6)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_6_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_6_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_6_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_6_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_6_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_6_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_6_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_6_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_7 (EP_IN_DMA_ERROR_ADDRESS_REG_7)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_7_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_7_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_7_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_7_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_7_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_7_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_7_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_7_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_8 (EP_IN_DMA_ERROR_ADDRESS_REG_8)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_8_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_8_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_8_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_8_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_8_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_8_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_8_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_8_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_9 (EP_IN_DMA_ERROR_ADDRESS_REG_9)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_9_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_9_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_9_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_9_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_9_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_9_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_9_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_9_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_10 (EP_IN_DMA_ERROR_ADDRESS_REG_10)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_10_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_10_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_10_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_10_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_10_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_10_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_10_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_10_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_11 (EP_IN_DMA_ERROR_ADDRESS_REG_11)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_11_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_11_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_11_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_11_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_11_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_11_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_11_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_11_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_12 (EP_IN_DMA_ERROR_ADDRESS_REG_12)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_12_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_12_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_12_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_12_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_12_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_12_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_12_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_12_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_13 (EP_IN_DMA_ERROR_ADDRESS_REG_13)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_13_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_13_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_13_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_13_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_13_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_13_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_13_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_13_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_14 (EP_IN_DMA_ERROR_ADDRESS_REG_14)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_14_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_14_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_14_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_14_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_14_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_14_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_14_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_14_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: EP_IN_DMA_ERROR_ADDRESS_REG_15 (EP_IN_DMA_ERROR_ADDRESS_REG_15)
//====================================================================

#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_15_IN_DMA_ERR_ADDR_O_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_15_IN_DMA_ERR_ADDR_O_N_SHIFT 0
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_15_IN_DMA_ERR_ADDR_O_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_15_IN_DMA_ERR_ADDR_O_N_MASK) >> USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_15_IN_DMA_ERR_ADDR_O_N_SHIFT)
#define  USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_15_IN_DMA_ERR_ADDR_O_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_15_IN_DMA_ERR_ADDR_O_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DMA_ERROR_ADDRESS_REG_15_IN_DMA_ERR_ADDR_O_N_SHIFT))

//====================================================================
//Register: DMA_SUSPEND_REG (DMA_SUSPEND_REG)
//====================================================================

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_15_MASK 0x80000000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_15_SHIFT 31
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_15_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_15_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_15_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_15_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_14_MASK 0x40000000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_14_SHIFT 30
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_14_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_14_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_14_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_14_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_13_MASK 0x20000000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_13_SHIFT 29
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_13_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_13_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_13_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_13_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_12_MASK 0x10000000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_12_SHIFT 28
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_12_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_12_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_12_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_12_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_11_MASK 0x8000000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_11_SHIFT 27
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_11_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_11_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_11_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_11_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_10_MASK 0x4000000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_10_SHIFT 26
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_10_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_10_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_10_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_10_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_9_MASK 0x2000000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_9_SHIFT 25
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_9_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_9_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_9_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_9_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_8_MASK 0x1000000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_8_SHIFT 24
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_8_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_8_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_8_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_8_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_7_MASK 0x800000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_7_SHIFT 23
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_7_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_7_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_7_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_7_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_6_MASK 0x400000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_6_SHIFT 22
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_6_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_6_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_6_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_6_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_5_MASK 0x200000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_5_SHIFT 21
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_5_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_5_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_5_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_5_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_4_MASK 0x100000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_4_SHIFT 20
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_4_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_4_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_4_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_4_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_3_MASK 0x80000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_3_SHIFT 19
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_3_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_3_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_3_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_3_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_2_MASK 0x40000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_2_SHIFT 18
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_2_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_2_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_2_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_2_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_1_MASK 0x20000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_1_SHIFT 17
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_1_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_1_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_1_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_0_MASK 0x10000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_0_SHIFT 16
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_0_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_0_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_0_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_IN_DMA_SUSPEND_I_0_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_15_MASK 0x8000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_15_SHIFT 15
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_15_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_15_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_15_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_15_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_14_MASK 0x4000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_14_SHIFT 14
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_14_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_14_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_14_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_14_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_13_MASK 0x2000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_13_SHIFT 13
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_13_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_13_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_13_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_13_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_12_MASK 0x1000
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_12_SHIFT 12
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_12_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_12_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_12_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_12_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_11_MASK 0x800
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_11_SHIFT 11
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_11_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_11_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_11_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_11_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_10_MASK 0x400
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_10_SHIFT 10
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_10_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_10_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_10_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_10_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_9_MASK 0x200
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_9_SHIFT 9
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_9_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_9_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_9_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_9_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_8_MASK 0x100
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_8_SHIFT 8
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_8_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_8_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_8_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_8_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_7_MASK 0x80
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_7_SHIFT 7
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_7_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_7_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_7_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_7_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_6_MASK 0x40
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_6_SHIFT 6
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_6_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_6_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_6_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_6_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_5_MASK 0x20
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_5_SHIFT 5
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_5_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_5_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_5_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_5_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_4_MASK 0x10
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_4_SHIFT 4
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_4_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_4_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_4_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_4_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_3_MASK 0x8
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_3_SHIFT 3
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_3_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_3_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_3_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_3_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_2_MASK 0x4
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_2_SHIFT 2
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_2_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_2_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_2_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_2_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_1_MASK 0x2
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_1_SHIFT 1
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_1_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_1_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_1_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_0_MASK 0x1
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_0_SHIFT 0
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_0_MASK) >> USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_0_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_0_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_REG_CSR_OUT_DMA_SUSPEND_I_0_SHIFT))

//====================================================================
//Register: DMA_SUSPEND_DONE_REG (DMA_SUSPEND_DONE_REG)
//====================================================================

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_15_MASK 0x80000000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_15_SHIFT 31
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_15_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_15_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_15_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_15_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_14_MASK 0x40000000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_14_SHIFT 30
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_14_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_14_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_14_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_14_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_13_MASK 0x20000000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_13_SHIFT 29
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_13_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_13_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_13_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_13_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_12_MASK 0x10000000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_12_SHIFT 28
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_12_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_12_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_12_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_12_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_11_MASK 0x8000000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_11_SHIFT 27
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_11_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_11_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_11_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_11_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_10_MASK 0x4000000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_10_SHIFT 26
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_10_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_10_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_10_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_10_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_9_MASK 0x2000000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_9_SHIFT 25
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_9_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_9_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_9_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_9_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_8_MASK 0x1000000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_8_SHIFT 24
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_8_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_8_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_8_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_8_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_7_MASK 0x800000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_7_SHIFT 23
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_7_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_7_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_7_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_7_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_6_MASK 0x400000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_6_SHIFT 22
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_6_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_6_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_6_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_6_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_5_MASK 0x200000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_5_SHIFT 21
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_5_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_5_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_5_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_5_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_4_MASK 0x100000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_4_SHIFT 20
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_4_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_4_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_4_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_4_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_3_MASK 0x80000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_3_SHIFT 19
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_3_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_3_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_3_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_3_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_2_MASK 0x40000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_2_SHIFT 18
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_2_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_2_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_2_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_2_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_1_MASK 0x20000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_1_SHIFT 17
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_1_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_1_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_1_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_0_MASK 0x10000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_0_SHIFT 16
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_0_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_0_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_0_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_IN_DMA_SUSPEND_DONE_0_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_15_MASK 0x8000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_15_SHIFT 15
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_15_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_15_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_15_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_15_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_14_MASK 0x4000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_14_SHIFT 14
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_14_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_14_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_14_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_14_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_13_MASK 0x2000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_13_SHIFT 13
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_13_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_13_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_13_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_13_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_12_MASK 0x1000
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_12_SHIFT 12
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_12_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_12_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_12_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_12_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_11_MASK 0x800
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_11_SHIFT 11
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_11_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_11_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_11_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_11_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_10_MASK 0x400
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_10_SHIFT 10
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_10_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_10_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_10_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_10_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_9_MASK 0x200
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_9_SHIFT 9
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_9_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_9_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_9_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_9_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_8_MASK 0x100
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_8_SHIFT 8
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_8_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_8_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_8_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_8_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_7_MASK 0x80
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_7_SHIFT 7
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_7_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_7_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_7_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_7_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_6_MASK 0x40
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_6_SHIFT 6
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_6_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_6_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_6_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_6_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_5_MASK 0x20
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_5_SHIFT 5
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_5_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_5_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_5_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_5_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_4_MASK 0x10
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_4_SHIFT 4
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_4_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_4_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_4_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_4_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_3_MASK 0x8
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_3_SHIFT 3
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_3_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_3_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_3_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_3_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_2_MASK 0x4
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_2_SHIFT 2
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_2_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_2_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_2_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_2_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_1_MASK 0x2
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_1_SHIFT 1
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_1_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_1_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_1_SHIFT))

#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_0_MASK 0x1
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_0_SHIFT 0
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_0_MASK) >> USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_0_SHIFT)
#define  USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_0_MASK) | (((uint32_t)val) << USB3D_SS_DMA_SUSPEND_DONE_REG_CSR_OUT_DMA_SUSPEND_DONE_0_SHIFT))

//====================================================================
//Register: DMA_HALT_REG (DMA_HALT_REG)
//====================================================================

#define  USB3D_SS_DMA_HALT_REG_CSR_IN_DMA_HALT_I_N_MASK 0xffff0000
#define  USB3D_SS_DMA_HALT_REG_CSR_IN_DMA_HALT_I_N_SHIFT 16
#define  USB3D_SS_DMA_HALT_REG_CSR_IN_DMA_HALT_I_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_HALT_REG_CSR_IN_DMA_HALT_I_N_MASK) >> USB3D_SS_DMA_HALT_REG_CSR_IN_DMA_HALT_I_N_SHIFT)
#define  USB3D_SS_DMA_HALT_REG_CSR_IN_DMA_HALT_I_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_HALT_REG_CSR_IN_DMA_HALT_I_N_MASK) | (((uint32_t)val) << USB3D_SS_DMA_HALT_REG_CSR_IN_DMA_HALT_I_N_SHIFT))

#define  USB3D_SS_DMA_HALT_REG_CSR_OUT_DMA_HALT_I_N_MASK 0xffff
#define  USB3D_SS_DMA_HALT_REG_CSR_OUT_DMA_HALT_I_N_SHIFT 0
#define  USB3D_SS_DMA_HALT_REG_CSR_OUT_DMA_HALT_I_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_HALT_REG_CSR_OUT_DMA_HALT_I_N_MASK) >> USB3D_SS_DMA_HALT_REG_CSR_OUT_DMA_HALT_I_N_SHIFT)
#define  USB3D_SS_DMA_HALT_REG_CSR_OUT_DMA_HALT_I_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_HALT_REG_CSR_OUT_DMA_HALT_I_N_MASK) | (((uint32_t)val) << USB3D_SS_DMA_HALT_REG_CSR_OUT_DMA_HALT_I_N_SHIFT))

//====================================================================
//Register: DMA_HALT_DONE_REG (DMA_HALT_DONE_REG)
//====================================================================

#define  USB3D_SS_DMA_HALT_DONE_REG_CSR_IN_DMA_HALT_DONE_N_MASK 0xffff0000
#define  USB3D_SS_DMA_HALT_DONE_REG_CSR_IN_DMA_HALT_DONE_N_SHIFT 16
#define  USB3D_SS_DMA_HALT_DONE_REG_CSR_IN_DMA_HALT_DONE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_HALT_DONE_REG_CSR_IN_DMA_HALT_DONE_N_MASK) >> USB3D_SS_DMA_HALT_DONE_REG_CSR_IN_DMA_HALT_DONE_N_SHIFT)
#define  USB3D_SS_DMA_HALT_DONE_REG_CSR_IN_DMA_HALT_DONE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_HALT_DONE_REG_CSR_IN_DMA_HALT_DONE_N_MASK) | (((uint32_t)val) << USB3D_SS_DMA_HALT_DONE_REG_CSR_IN_DMA_HALT_DONE_N_SHIFT))

#define  USB3D_SS_DMA_HALT_DONE_REG_CSR_OUT_DMA_HALT_DONE_N_MASK 0xffff
#define  USB3D_SS_DMA_HALT_DONE_REG_CSR_OUT_DMA_HALT_DONE_N_SHIFT 0
#define  USB3D_SS_DMA_HALT_DONE_REG_CSR_OUT_DMA_HALT_DONE_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_HALT_DONE_REG_CSR_OUT_DMA_HALT_DONE_N_MASK) >> USB3D_SS_DMA_HALT_DONE_REG_CSR_OUT_DMA_HALT_DONE_N_SHIFT)
#define  USB3D_SS_DMA_HALT_DONE_REG_CSR_OUT_DMA_HALT_DONE_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_HALT_DONE_REG_CSR_OUT_DMA_HALT_DONE_N_MASK) | (((uint32_t)val) << USB3D_SS_DMA_HALT_DONE_REG_CSR_OUT_DMA_HALT_DONE_N_SHIFT))

//====================================================================
//Register: AXI_TIMEOUT_VAL_REG_0 (AXI_TIMEOUT_VAL_REG_0)
//====================================================================

#define  USB3D_SS_AXI_TIMEOUT_VAL_REG_0_AXI_TIMEOUT_0_MASK 0xffffffff
#define  USB3D_SS_AXI_TIMEOUT_VAL_REG_0_AXI_TIMEOUT_0_SHIFT 0
#define  USB3D_SS_AXI_TIMEOUT_VAL_REG_0_AXI_TIMEOUT_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_TIMEOUT_VAL_REG_0_AXI_TIMEOUT_0_MASK) >> USB3D_SS_AXI_TIMEOUT_VAL_REG_0_AXI_TIMEOUT_0_SHIFT)
#define  USB3D_SS_AXI_TIMEOUT_VAL_REG_0_AXI_TIMEOUT_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_TIMEOUT_VAL_REG_0_AXI_TIMEOUT_0_MASK) | (((uint32_t)val) << USB3D_SS_AXI_TIMEOUT_VAL_REG_0_AXI_TIMEOUT_0_SHIFT))

//====================================================================
//Register: AXI_STATE_REG_1 (AXI_STATE_REG_1)
//====================================================================

#define  USB3D_SS_AXI_STATE_REG_1_RESERVED1_MASK 0xffffffc0
#define  USB3D_SS_AXI_STATE_REG_1_RESERVED1_SHIFT 6
#define  USB3D_SS_AXI_STATE_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_1_RESERVED1_MASK) >> USB3D_SS_AXI_STATE_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_1_AMST_WR_BACK_STATE_MASK 0x30
#define  USB3D_SS_AXI_STATE_REG_1_AMST_WR_BACK_STATE_SHIFT 4
#define  USB3D_SS_AXI_STATE_REG_1_AMST_WR_BACK_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_1_AMST_WR_BACK_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_1_AMST_WR_BACK_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_1_AMST_WR_BACK_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_1_AMST_WR_BACK_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_1_AMST_WR_BACK_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_1_RESERVED2_MASK 0xc
#define  USB3D_SS_AXI_STATE_REG_1_RESERVED2_SHIFT 2
#define  USB3D_SS_AXI_STATE_REG_1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_1_RESERVED2_MASK) >> USB3D_SS_AXI_STATE_REG_1_RESERVED2_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_1_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_1_RESERVED2_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_1_AMST_RD_BACK_STATE_MASK 0x3
#define  USB3D_SS_AXI_STATE_REG_1_AMST_RD_BACK_STATE_SHIFT 0
#define  USB3D_SS_AXI_STATE_REG_1_AMST_RD_BACK_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_1_AMST_RD_BACK_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_1_AMST_RD_BACK_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_1_AMST_RD_BACK_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_1_AMST_RD_BACK_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_1_AMST_RD_BACK_STATE_SHIFT))

//====================================================================
//Register: AXI_STATE_REG_2 (AXI_STATE_REG_2)
//====================================================================

#define  USB3D_SS_AXI_STATE_REG_2_RESERVED1_MASK 0xff800000
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED1_SHIFT 23
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_RESERVED1_MASK) >> USB3D_SS_AXI_STATE_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_REQ_STATE_MASK 0x700000
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_REQ_STATE_SHIFT 20
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_REQ_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_REQ_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_REQ_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_REQ_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_REQ_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_REQ_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_RESERVED2_MASK 0xe0000
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED2_SHIFT 17
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_RESERVED2_MASK) >> USB3D_SS_AXI_STATE_REG_2_RESERVED2_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_RESERVED2_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_RESP_STATE_MASK 0x10000
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_RESP_STATE_SHIFT 16
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_RESP_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_RESP_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_RESP_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_RESP_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_RESP_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_0_WR_RESP_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_RESERVED3_MASK 0x8000
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED3_SHIFT 15
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_RESERVED3_MASK) >> USB3D_SS_AXI_STATE_REG_2_RESERVED3_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_RESERVED3_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_REQ_STATE_MASK 0x7000
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_REQ_STATE_SHIFT 12
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_REQ_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_REQ_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_REQ_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_REQ_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_REQ_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_REQ_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_RESERVED4_MASK 0xe00
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED4_SHIFT 9
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED4_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_RESERVED4_MASK) >> USB3D_SS_AXI_STATE_REG_2_RESERVED4_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_RESERVED4_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_RESERVED4_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_RESP_STATE_MASK 0x100
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_RESP_STATE_SHIFT 8
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_RESP_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_RESP_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_RESP_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_RESP_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_RESP_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_1_WR_RESP_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_RESERVED5_MASK 0x80
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED5_SHIFT 7
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED5_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_RESERVED5_MASK) >> USB3D_SS_AXI_STATE_REG_2_RESERVED5_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_RESERVED5_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_RESERVED5_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_REQ_STATE_MASK 0x70
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_REQ_STATE_SHIFT 4
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_REQ_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_REQ_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_REQ_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_REQ_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_REQ_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_REQ_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_RESERVE_6_MASK 0xe
#define  USB3D_SS_AXI_STATE_REG_2_RESERVE_6_SHIFT 1
#define  USB3D_SS_AXI_STATE_REG_2_RESERVE_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_RESERVE_6_MASK) >> USB3D_SS_AXI_STATE_REG_2_RESERVE_6_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_RESERVE_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_RESERVE_6_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_RESERVE_6_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_RESP_STATE_MASK 0x1
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_RESP_STATE_SHIFT 0
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_RESP_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_RESP_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_RESP_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_RESP_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_RESP_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_2_USB_AXI_WR_2_WR_RESP_STATE_SHIFT))

//====================================================================
//Register: AXI_STATE_REG_3 (AXI_STATE_REG_3)
//====================================================================

#define  USB3D_SS_AXI_STATE_REG_3_RESERVED1_MASK 0xff800000
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED1_SHIFT 23
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_RESERVED1_MASK) >> USB3D_SS_AXI_STATE_REG_3_RESERVED1_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_RESERVED1_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_REQ_STATE_MASK 0x700000
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_REQ_STATE_SHIFT 20
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_REQ_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_REQ_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_REQ_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_REQ_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_REQ_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_REQ_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_RESERVED2_MASK 0xe0000
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED2_SHIFT 17
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_RESERVED2_MASK) >> USB3D_SS_AXI_STATE_REG_3_RESERVED2_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_RESERVED2_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_RESP_STATE_MASK 0x10000
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_RESP_STATE_SHIFT 16
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_RESP_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_RESP_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_RESP_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_RESP_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_RESP_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_0_RD_RESP_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_RESERVED3_MASK 0x8000
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED3_SHIFT 15
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_RESERVED3_MASK) >> USB3D_SS_AXI_STATE_REG_3_RESERVED3_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_RESERVED3_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_REQ_STATE_MASK 0x7000
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_REQ_STATE_SHIFT 12
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_REQ_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_REQ_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_REQ_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_REQ_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_REQ_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_REQ_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_RESERVED4_MASK 0xe00
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED4_SHIFT 9
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED4_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_RESERVED4_MASK) >> USB3D_SS_AXI_STATE_REG_3_RESERVED4_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_RESERVED4_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_RESERVED4_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_RESP_STATE_MASK 0x100
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_RESP_STATE_SHIFT 8
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_RESP_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_RESP_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_RESP_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_RESP_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_RESP_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_1_RD_RESP_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_RESERVED5_MASK 0x80
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED5_SHIFT 7
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED5_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_RESERVED5_MASK) >> USB3D_SS_AXI_STATE_REG_3_RESERVED5_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_RESERVED5_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_RESERVED5_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_REQ_STATE_MASK 0x70
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_REQ_STATE_SHIFT 4
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_REQ_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_REQ_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_REQ_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_REQ_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_REQ_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_REQ_STATE_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_RESERVE_6_MASK 0xe
#define  USB3D_SS_AXI_STATE_REG_3_RESERVE_6_SHIFT 1
#define  USB3D_SS_AXI_STATE_REG_3_RESERVE_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_RESERVE_6_MASK) >> USB3D_SS_AXI_STATE_REG_3_RESERVE_6_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_RESERVE_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_RESERVE_6_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_RESERVE_6_SHIFT))

#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_RESP_STATE_MASK 0x1
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_RESP_STATE_SHIFT 0
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_RESP_STATE_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_RESP_STATE_MASK) >> USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_RESP_STATE_SHIFT)
#define  USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_RESP_STATE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_RESP_STATE_MASK) | (((uint32_t)val) << USB3D_SS_AXI_STATE_REG_3_USB_AXI_RD_2_RD_RESP_STATE_SHIFT))

//====================================================================
//Register: SS_SYS_INT_REG (SS_SYS_INT_REG)
//====================================================================

#define  USB3D_SS_SS_SYS_INT_REG_RESERVED1_MASK 0xc0000000
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED1_SHIFT 30
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_RESERVED1_MASK) >> USB3D_SS_SS_SYS_INT_REG_RESERVED1_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_RESERVED1_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_DATA_ERROR_INT_MASK 0x20000000
#define  USB3D_SS_SS_SYS_INT_REG_AXI_DATA_ERROR_INT_SHIFT 29
#define  USB3D_SS_SS_SYS_INT_REG_AXI_DATA_ERROR_INT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_DATA_ERROR_INT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_DATA_ERROR_INT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_DATA_ERROR_INT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_DATA_ERROR_INT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_DATA_ERROR_INT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_BDF_ERROR_INT_MASK 0x10000000
#define  USB3D_SS_SS_SYS_INT_REG_AXI_BDF_ERROR_INT_SHIFT 28
#define  USB3D_SS_SS_SYS_INT_REG_AXI_BDF_ERROR_INT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_BDF_ERROR_INT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_BDF_ERROR_INT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_BDF_ERROR_INT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_BDF_ERROR_INT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_BDF_ERROR_INT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_DMA_CSR_DONEQ_FULL_MASK 0x8000000
#define  USB3D_SS_SS_SYS_INT_REG_DMA_CSR_DONEQ_FULL_SHIFT 27
#define  USB3D_SS_SS_SYS_INT_REG_DMA_CSR_DONEQ_FULL_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_DMA_CSR_DONEQ_FULL_MASK) >> USB3D_SS_SS_SYS_INT_REG_DMA_CSR_DONEQ_FULL_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_DMA_CSR_DONEQ_FULL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_DMA_CSR_DONEQ_FULL_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_DMA_CSR_DONEQ_FULL_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_BULK_STREAM_INTERRUPT_MASK 0x4000000
#define  USB3D_SS_SS_SYS_INT_REG_BULK_STREAM_INTERRUPT_SHIFT 26
#define  USB3D_SS_SS_SYS_INT_REG_BULK_STREAM_INTERRUPT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_BULK_STREAM_INTERRUPT_MASK) >> USB3D_SS_SS_SYS_INT_REG_BULK_STREAM_INTERRUPT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_BULK_STREAM_INTERRUPT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_BULK_STREAM_INTERRUPT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_BULK_STREAM_INTERRUPT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_DMA_REC_MASK 0x2000000
#define  USB3D_SS_SS_SYS_INT_REG_DMA_REC_SHIFT 25
#define  USB3D_SS_SS_SYS_INT_REG_DMA_REC_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_DMA_REC_MASK) >> USB3D_SS_SS_SYS_INT_REG_DMA_REC_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_DMA_REC_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_DMA_REC_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_DMA_REC_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_HALT_ALL_DONE_MASK 0x1000000
#define  USB3D_SS_SS_SYS_INT_REG_HALT_ALL_DONE_SHIFT 24
#define  USB3D_SS_SS_SYS_INT_REG_HALT_ALL_DONE_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_HALT_ALL_DONE_MASK) >> USB3D_SS_SS_SYS_INT_REG_HALT_ALL_DONE_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_HALT_ALL_DONE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_HALT_ALL_DONE_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_HALT_ALL_DONE_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_RESERVED2_MASK 0xc00000
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED2_SHIFT 22
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_RESERVED2_MASK) >> USB3D_SS_SS_SYS_INT_REG_RESERVED2_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_RESERVED2_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_2_MASK 0x200000
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_2_SHIFT 21
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_2_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_2_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_2_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_2_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_2_MASK 0x100000
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_2_SHIFT 20
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_2_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_2_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_2_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_2_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_1_MASK 0x80000
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_1_SHIFT 19
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_1_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_1_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_1_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_1_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_1_MASK 0x40000
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_1_SHIFT 18
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_1_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_1_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_1_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_1_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_0_MASK 0x20000
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_0_SHIFT 17
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_0_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_0_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_0_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_RD_MAS_TIMEOUT_0_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_0_MASK 0x10000
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_0_SHIFT 16
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_0_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_0_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_0_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_WR_MAS_TIMEOUT_0_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_RESERVED3_MASK 0xc000
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED3_SHIFT 14
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_RESERVED3_MASK) >> USB3D_SS_SS_SYS_INT_REG_RESERVED3_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_RESERVED3_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_2_STAT_MASK 0x2000
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_2_STAT_SHIFT 13
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_2_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_2_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_2_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_2_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_2_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_2_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_1_STAT_MASK 0x1000
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_1_STAT_SHIFT 12
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_1_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_1_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_1_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_1_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_1_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_1_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_0_STAT_MASK 0x800
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_0_STAT_SHIFT 11
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_0_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_0_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_0_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_0_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_0_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_RD_ERR_0_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_2_STAT_MASK 0x400
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_2_STAT_SHIFT 10
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_2_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_2_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_2_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_2_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_2_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_2_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_1_STAT_MASK 0x200
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_1_STAT_SHIFT 9
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_1_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_1_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_1_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_1_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_1_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_1_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_0_STAT_MASK 0x100
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_0_STAT_SHIFT 8
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_0_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_0_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_0_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_0_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_0_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_WR_ERR_0_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_RESERVED4_MASK 0xc0
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED4_SHIFT 6
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED4_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_RESERVED4_MASK) >> USB3D_SS_SS_SYS_INT_REG_RESERVED4_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_RESERVED4_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_RESERVED4_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_2_REQ_ZEROLEN_STAT_MASK 0x20
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_2_REQ_ZEROLEN_STAT_SHIFT 5
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_2_REQ_ZEROLEN_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_RD_2_REQ_ZEROLEN_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_RD_2_REQ_ZEROLEN_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_2_REQ_ZEROLEN_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_RD_2_REQ_ZEROLEN_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_RD_2_REQ_ZEROLEN_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_2_REQ_ZEROLEN_STAT_MASK 0x10
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_2_REQ_ZEROLEN_STAT_SHIFT 4
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_2_REQ_ZEROLEN_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_WR_2_REQ_ZEROLEN_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_WR_2_REQ_ZEROLEN_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_2_REQ_ZEROLEN_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_WR_2_REQ_ZEROLEN_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_WR_2_REQ_ZEROLEN_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_1_REQ_ZEROLEN_STAT_MASK 0x8
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_1_REQ_ZEROLEN_STAT_SHIFT 3
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_1_REQ_ZEROLEN_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_RD_1_REQ_ZEROLEN_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_RD_1_REQ_ZEROLEN_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_1_REQ_ZEROLEN_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_RD_1_REQ_ZEROLEN_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_RD_1_REQ_ZEROLEN_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_1_REQ_ZEROLEN_STAT_MASK 0x4
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_1_REQ_ZEROLEN_STAT_SHIFT 2
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_1_REQ_ZEROLEN_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_WR_1_REQ_ZEROLEN_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_WR_1_REQ_ZEROLEN_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_1_REQ_ZEROLEN_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_WR_1_REQ_ZEROLEN_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_WR_1_REQ_ZEROLEN_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_0_REQ_ZEROLEN_STAT_MASK 0x2
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_0_REQ_ZEROLEN_STAT_SHIFT 1
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_0_REQ_ZEROLEN_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_RD_0_REQ_ZEROLEN_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_RD_0_REQ_ZEROLEN_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_RD_0_REQ_ZEROLEN_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_RD_0_REQ_ZEROLEN_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_RD_0_REQ_ZEROLEN_STAT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_0_REQ_ZEROLEN_STAT_MASK 0x1
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_0_REQ_ZEROLEN_STAT_SHIFT 0
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_0_REQ_ZEROLEN_STAT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_REG_AXI_WR_0_REQ_ZEROLEN_STAT_MASK) >> USB3D_SS_SS_SYS_INT_REG_AXI_WR_0_REQ_ZEROLEN_STAT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_REG_AXI_WR_0_REQ_ZEROLEN_STAT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_REG_AXI_WR_0_REQ_ZEROLEN_STAT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_REG_AXI_WR_0_REQ_ZEROLEN_STAT_SHIFT))

//====================================================================
//Register: SS_SYS_INT_EN_REG (SS_SYS_INT_EN_REG)
/** \brief This register provides an interrupt mask for the SS_SYS_INT_REG, defining for
each status bit if an interrupt is issued when the corresponding condition
occurs.
For a description of the conditions for each bit, refer to the description of
the SS_SYS_INT_REG.*/
//====================================================================

#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED1_MASK 0xc0000000
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED1_SHIFT 30
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_RESERVED1_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_RESERVED1_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_RESERVED1_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_DATA_ERROR_INT_MASK 0x20000000
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_DATA_ERROR_INT_SHIFT 29
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_DATA_ERROR_INT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_DATA_ERROR_INT_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_DATA_ERROR_INT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_DATA_ERROR_INT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_DATA_ERROR_INT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_DATA_ERROR_INT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_BDF_ERROR_INT_MASK 0x10000000
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_BDF_ERROR_INT_SHIFT 28
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_BDF_ERROR_INT_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_BDF_ERROR_INT_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_BDF_ERROR_INT_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_BDF_ERROR_INT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_BDF_ERROR_INT_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_BDF_ERROR_INT_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_DMA_CSR_DONEQ_FULL_EN_MASK 0x8000000
#define  USB3D_SS_SS_SYS_INT_EN_REG_DMA_CSR_DONEQ_FULL_EN_SHIFT 27
#define  USB3D_SS_SS_SYS_INT_EN_REG_DMA_CSR_DONEQ_FULL_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_DMA_CSR_DONEQ_FULL_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_DMA_CSR_DONEQ_FULL_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_DMA_CSR_DONEQ_FULL_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_DMA_CSR_DONEQ_FULL_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_DMA_CSR_DONEQ_FULL_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_BULK_STREAM_INTERRUPT_EN_MASK 0x4000000
#define  USB3D_SS_SS_SYS_INT_EN_REG_BULK_STREAM_INTERRUPT_EN_SHIFT 26
#define  USB3D_SS_SS_SYS_INT_EN_REG_BULK_STREAM_INTERRUPT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_BULK_STREAM_INTERRUPT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_BULK_STREAM_INTERRUPT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_BULK_STREAM_INTERRUPT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_BULK_STREAM_INTERRUPT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_BULK_STREAM_INTERRUPT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_DMA_REC_EN_MASK 0x2000000
#define  USB3D_SS_SS_SYS_INT_EN_REG_DMA_REC_EN_SHIFT 25
#define  USB3D_SS_SS_SYS_INT_EN_REG_DMA_REC_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_DMA_REC_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_DMA_REC_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_DMA_REC_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_DMA_REC_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_DMA_REC_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_HALT_ALL_DONE_EN_MASK 0x1000000
#define  USB3D_SS_SS_SYS_INT_EN_REG_HALT_ALL_DONE_EN_SHIFT 24
#define  USB3D_SS_SS_SYS_INT_EN_REG_HALT_ALL_DONE_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_HALT_ALL_DONE_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_HALT_ALL_DONE_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_HALT_ALL_DONE_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_HALT_ALL_DONE_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_HALT_ALL_DONE_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED2_MASK 0xc00000
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED2_SHIFT 22
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_RESERVED2_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_RESERVED2_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_RESERVED2_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_2_EN_MASK 0x200000
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_2_EN_SHIFT 21
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_2_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_2_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_2_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_2_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_2_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_2_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_2_EN_MASK 0x100000
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_2_EN_SHIFT 20
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_2_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_2_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_2_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_2_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_2_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_2_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_1_EN_MASK 0x80000
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_1_EN_SHIFT 19
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_1_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_1_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_1_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_1_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_1_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_1_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_1_EN_MASK 0x40000
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_1_EN_SHIFT 18
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_1_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_1_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_1_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_1_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_1_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_1_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_0_EN_MASK 0x20000
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_0_EN_SHIFT 17
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_0_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_0_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_0_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_0_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_0_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_MAS_TIMEOUT_0_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_0_EN_MASK 0x10000
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_0_EN_SHIFT 16
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_0_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_0_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_0_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_0_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_0_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_MAS_TIMEOUT_0_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED3_MASK 0xc000
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED3_SHIFT 14
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_RESERVED3_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_RESERVED3_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_RESERVED3_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_2_STAT_EN_MASK 0x2000
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_2_STAT_EN_SHIFT 13
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_2_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_2_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_2_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_2_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_2_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_2_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_1_STAT_EN_MASK 0x1000
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_1_STAT_EN_SHIFT 12
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_1_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_1_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_1_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_1_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_1_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_1_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_0_STAT_EN_MASK 0x800
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_0_STAT_EN_SHIFT 11
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_0_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_0_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_0_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_0_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_0_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_ERR_0_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_2_STAT_EN_MASK 0x400
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_2_STAT_EN_SHIFT 10
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_2_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_2_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_2_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_2_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_2_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_2_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_1_STAT_EN_MASK 0x200
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_1_STAT_EN_SHIFT 9
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_1_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_1_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_1_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_1_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_1_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_1_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_0_STAT_EN_MASK 0x100
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_0_STAT_EN_SHIFT 8
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_0_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_0_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_0_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_0_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_0_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_ERR_0_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED4_MASK 0xc0
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED4_SHIFT 6
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED4_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_RESERVED4_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_RESERVED4_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_RESERVED4_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_RESERVED4_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_2_REQ_ZEROLEN_STAT_EN_MASK 0x20
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_2_REQ_ZEROLEN_STAT_EN_SHIFT 5
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_2_REQ_ZEROLEN_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_2_REQ_ZEROLEN_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_2_REQ_ZEROLEN_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_2_REQ_ZEROLEN_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_2_REQ_ZEROLEN_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_2_REQ_ZEROLEN_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_2_REQ_ZEROLEN_STAT_EN_MASK 0x10
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_2_REQ_ZEROLEN_STAT_EN_SHIFT 4
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_2_REQ_ZEROLEN_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_2_REQ_ZEROLEN_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_2_REQ_ZEROLEN_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_2_REQ_ZEROLEN_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_2_REQ_ZEROLEN_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_2_REQ_ZEROLEN_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_1_REQ_ZEROLEN_STAT_EN_MASK 0x8
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_1_REQ_ZEROLEN_STAT_EN_SHIFT 3
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_1_REQ_ZEROLEN_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_1_REQ_ZEROLEN_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_1_REQ_ZEROLEN_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_1_REQ_ZEROLEN_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_1_REQ_ZEROLEN_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_1_REQ_ZEROLEN_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_1_REQ_ZEROLEN_STAT_EN_MASK 0x4
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_1_REQ_ZEROLEN_STAT_EN_SHIFT 2
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_1_REQ_ZEROLEN_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_1_REQ_ZEROLEN_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_1_REQ_ZEROLEN_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_1_REQ_ZEROLEN_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_1_REQ_ZEROLEN_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_1_REQ_ZEROLEN_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_0_REQ_ZEROLEN_STAT_EN_MASK 0x2
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_0_REQ_ZEROLEN_STAT_EN_SHIFT 1
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_0_REQ_ZEROLEN_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_0_REQ_ZEROLEN_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_0_REQ_ZEROLEN_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_0_REQ_ZEROLEN_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_0_REQ_ZEROLEN_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_RD_0_REQ_ZEROLEN_STAT_EN_SHIFT))

#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_0_REQ_ZEROLEN_STAT_EN_MASK 0x1
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_0_REQ_ZEROLEN_STAT_EN_SHIFT 0
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_0_REQ_ZEROLEN_STAT_EN_MASK_SHIFT(reg) (((reg) & USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_0_REQ_ZEROLEN_STAT_EN_MASK) >> USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_0_REQ_ZEROLEN_STAT_EN_SHIFT)
#define  USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_0_REQ_ZEROLEN_STAT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_0_REQ_ZEROLEN_STAT_EN_MASK) | (((uint32_t)val) << USB3D_SS_SS_SYS_INT_EN_REG_AXI_WR_0_REQ_ZEROLEN_STAT_EN_SHIFT))

//====================================================================
//Register: AXI_ERROR_RESPONSE_CODE_REG_1 (AXI_ERROR_RESPONSE_CODE_REG_1)
//====================================================================

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED1_MASK 0xe0000000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED1_SHIFT 29
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED1_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_1_MASK 0x1ff00000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_1_SHIFT 20
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_1_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_1_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_1_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED2_MASK 0xc0000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED2_SHIFT 18
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED2_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED2_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED2_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_1_MASK 0x30000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_1_SHIFT 16
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_1_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_1_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_1_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED3_MASK 0xe000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED3_SHIFT 13
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED3_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED3_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED3_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_0_MASK 0x1ff0
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_0_SHIFT 4
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_0_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_0_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_0_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_RESPID_0_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED4_MASK 0xc
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED4_SHIFT 2
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED4_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED4_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED4_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED4_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_RESERVED4_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_0_MASK 0x3
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_0_SHIFT 0
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_0_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_0_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_0_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_1_AXI_WR_ERR_0_SHIFT))

//====================================================================
//Register: AXI_ERROR_RESPONSE_CODE_REG_2 (AXI_ERROR_REPONSE_CODE_REG_2)
//====================================================================

#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED1_MASK 0xffffe000
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED1_SHIFT 13
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED1_MASK) >> USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_RESPID_2_MASK 0x1ff0
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_RESPID_2_SHIFT 4
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_RESPID_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_RESPID_2_MASK) >> USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_RESPID_2_SHIFT)
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_RESPID_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_RESPID_2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_RESPID_2_SHIFT))

#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED2_MASK 0xc
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED2_SHIFT 2
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED2_MASK) >> USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED2_SHIFT)
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_RESERVED2_SHIFT))

#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_ERR_2_MASK 0x3
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_ERR_2_SHIFT 0
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_ERR_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_ERR_2_MASK) >> USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_ERR_2_SHIFT)
#define  USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_ERR_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_ERR_2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_REPONSE_CODE_REG_2_AXI_WR_ERR_2_SHIFT))

//====================================================================
//Register: AXI_ERROR_RESPONSE_CODE_REG_3 (AXI_ERROR_RESPONSE_CODE_REG_3)
//====================================================================

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED1_MASK 0xe0000000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED1_SHIFT 29
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED1_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED1_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED1_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_1_MASK 0x1ff00000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_1_SHIFT 20
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_1_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_1_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_1_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED2_MASK 0xc0000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED2_SHIFT 18
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED2_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED2_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED2_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_1_MASK 0x30000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_1_SHIFT 16
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_1_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_1_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_1_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED3_MASK 0xe000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED3_SHIFT 13
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED3_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED3_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED3_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED3_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED3_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_0_MASK 0x1ff0
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_0_SHIFT 4
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_0_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_0_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_0_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_RESPID_0_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED4_MASK 0xc
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED4_SHIFT 2
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED4_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED4_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED4_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED4_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_RESERVED4_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_0_MASK 0x3
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_0_SHIFT 0
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_0_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_0_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_0_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_3_AXI_RD_ERR_0_SHIFT))

//====================================================================
//Register: AXI_ERROR_RESPONSE_CODE_REG_4 (AXI_ERROR_RESPONSE_CODE_REG_4)
//====================================================================

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED1_MASK 0xffffe000
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED1_SHIFT 13
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED1_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED1_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED1_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_RESPID_2_MASK 0x1ff0
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_RESPID_2_SHIFT 4
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_RESPID_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_RESPID_2_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_RESPID_2_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_RESPID_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_RESPID_2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_RESPID_2_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED2_MASK 0xc
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED2_SHIFT 2
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED2_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED2_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_RESERVED2_SHIFT))

#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_ERR_2_MASK 0x3
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_ERR_2_SHIFT 0
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_ERR_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_ERR_2_MASK) >> USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_ERR_2_SHIFT)
#define  USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_ERR_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_ERR_2_MASK) | (((uint32_t)val) << USB3D_SS_AXI_ERROR_RESPONSE_CODE_REG_4_AXI_RD_ERR_2_SHIFT))

//====================================================================
//Register: DMA_STATE_REG_1 (DMA_STATE_REG_1)
/** \brief This register is for internal usage, debug only.*/
//====================================================================

#define  USB3D_SS_DMA_STATE_REG_1_RESERVED1_MASK 0xfffffff0
#define  USB3D_SS_DMA_STATE_REG_1_RESERVED1_SHIFT 4
#define  USB3D_SS_DMA_STATE_REG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_1_RESERVED1_MASK) >> USB3D_SS_DMA_STATE_REG_1_RESERVED1_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_1_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_1_RESERVED1_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_1_DBG_DMA_MUX_MASK 0xf
#define  USB3D_SS_DMA_STATE_REG_1_DBG_DMA_MUX_SHIFT 0
#define  USB3D_SS_DMA_STATE_REG_1_DBG_DMA_MUX_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_1_DBG_DMA_MUX_MASK) >> USB3D_SS_DMA_STATE_REG_1_DBG_DMA_MUX_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_1_DBG_DMA_MUX_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_1_DBG_DMA_MUX_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_1_DBG_DMA_MUX_SHIFT))

//====================================================================
//Register: DMA_STATE_REG_2 (DMA_STATE_REG_2)
//====================================================================

#define  USB3D_SS_DMA_STATE_REG_2_RESERVED1_MASK 0xc0000000
#define  USB3D_SS_DMA_STATE_REG_2_RESERVED1_SHIFT 30
#define  USB3D_SS_DMA_STATE_REG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_2_RESERVED1_MASK) >> USB3D_SS_DMA_STATE_REG_2_RESERVED1_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_2_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_2_RESERVED1_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CHACHE_EMPTY_MASK 0x3f000000
#define  USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CHACHE_EMPTY_SHIFT 24
#define  USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CHACHE_EMPTY_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CHACHE_EMPTY_MASK) >> USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CHACHE_EMPTY_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CHACHE_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CHACHE_EMPTY_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CHACHE_EMPTY_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_2_DBG_EP_WRITE_FIFO_FULL_MASK 0x800000
#define  USB3D_SS_DMA_STATE_REG_2_DBG_EP_WRITE_FIFO_FULL_SHIFT 23
#define  USB3D_SS_DMA_STATE_REG_2_DBG_EP_WRITE_FIFO_FULL_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_2_DBG_EP_WRITE_FIFO_FULL_MASK) >> USB3D_SS_DMA_STATE_REG_2_DBG_EP_WRITE_FIFO_FULL_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_2_DBG_EP_WRITE_FIFO_FULL_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_2_DBG_EP_WRITE_FIFO_FULL_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_2_DBG_EP_WRITE_FIFO_FULL_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_2_DBG_WRITE_AVAIL_BUF_CNT_MASK 0x7c0000
#define  USB3D_SS_DMA_STATE_REG_2_DBG_WRITE_AVAIL_BUF_CNT_SHIFT 18
#define  USB3D_SS_DMA_STATE_REG_2_DBG_WRITE_AVAIL_BUF_CNT_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_2_DBG_WRITE_AVAIL_BUF_CNT_MASK) >> USB3D_SS_DMA_STATE_REG_2_DBG_WRITE_AVAIL_BUF_CNT_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_2_DBG_WRITE_AVAIL_BUF_CNT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_2_DBG_WRITE_AVAIL_BUF_CNT_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_2_DBG_WRITE_AVAIL_BUF_CNT_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CACHE_PTR_MASK 0x30000
#define  USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CACHE_PTR_SHIFT 16
#define  USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CACHE_PTR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CACHE_PTR_MASK) >> USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CACHE_PTR_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CACHE_PTR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CACHE_PTR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_2_DBG_DMA_OUT_CACHE_PTR_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_2_DBG_ST_DMA_OUT_CACHE_MASK 0xffff
#define  USB3D_SS_DMA_STATE_REG_2_DBG_ST_DMA_OUT_CACHE_SHIFT 0
#define  USB3D_SS_DMA_STATE_REG_2_DBG_ST_DMA_OUT_CACHE_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_2_DBG_ST_DMA_OUT_CACHE_MASK) >> USB3D_SS_DMA_STATE_REG_2_DBG_ST_DMA_OUT_CACHE_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_2_DBG_ST_DMA_OUT_CACHE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_2_DBG_ST_DMA_OUT_CACHE_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_2_DBG_ST_DMA_OUT_CACHE_SHIFT))

//====================================================================
//Register: DMA_STATE_REG_3 (DMA_STATE_REG_3)
//====================================================================

#define  USB3D_SS_DMA_STATE_REG_3_RESERVED1_MASK 0xc0000000
#define  USB3D_SS_DMA_STATE_REG_3_RESERVED1_SHIFT 30
#define  USB3D_SS_DMA_STATE_REG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_3_RESERVED1_MASK) >> USB3D_SS_DMA_STATE_REG_3_RESERVED1_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_3_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_3_RESERVED1_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_EMPTY_MASK 0x3f000000
#define  USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_EMPTY_SHIFT 24
#define  USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_EMPTY_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_EMPTY_MASK) >> USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_EMPTY_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_EMPTY_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_EMPTY_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_3_DBG_EP_READ_FIFO_EMPTY_MASK 0x800000
#define  USB3D_SS_DMA_STATE_REG_3_DBG_EP_READ_FIFO_EMPTY_SHIFT 23
#define  USB3D_SS_DMA_STATE_REG_3_DBG_EP_READ_FIFO_EMPTY_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_3_DBG_EP_READ_FIFO_EMPTY_MASK) >> USB3D_SS_DMA_STATE_REG_3_DBG_EP_READ_FIFO_EMPTY_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_3_DBG_EP_READ_FIFO_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_3_DBG_EP_READ_FIFO_EMPTY_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_3_DBG_EP_READ_FIFO_EMPTY_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_3_DBG_READ_AVAIL_BUF_CNT_MASK 0x7c0000
#define  USB3D_SS_DMA_STATE_REG_3_DBG_READ_AVAIL_BUF_CNT_SHIFT 18
#define  USB3D_SS_DMA_STATE_REG_3_DBG_READ_AVAIL_BUF_CNT_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_3_DBG_READ_AVAIL_BUF_CNT_MASK) >> USB3D_SS_DMA_STATE_REG_3_DBG_READ_AVAIL_BUF_CNT_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_3_DBG_READ_AVAIL_BUF_CNT_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_3_DBG_READ_AVAIL_BUF_CNT_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_3_DBG_READ_AVAIL_BUF_CNT_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_PTR_MASK 0x30000
#define  USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_PTR_SHIFT 16
#define  USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_PTR_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_PTR_MASK) >> USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_PTR_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_PTR_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_PTR_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_3_DBG_DMA_IN_CACHE_PTR_SHIFT))

#define  USB3D_SS_DMA_STATE_REG_3_DBG_ST_DMA_IN_CACHE_MASK 0xffff
#define  USB3D_SS_DMA_STATE_REG_3_DBG_ST_DMA_IN_CACHE_SHIFT 0
#define  USB3D_SS_DMA_STATE_REG_3_DBG_ST_DMA_IN_CACHE_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_3_DBG_ST_DMA_IN_CACHE_MASK) >> USB3D_SS_DMA_STATE_REG_3_DBG_ST_DMA_IN_CACHE_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_3_DBG_ST_DMA_IN_CACHE_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_3_DBG_ST_DMA_IN_CACHE_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_3_DBG_ST_DMA_IN_CACHE_SHIFT))

//====================================================================
//Register: DMA_STATE_REG_4 (DMA_STATE_REG_4)
//====================================================================

#define  USB3D_SS_DMA_STATE_REG_4_RESERVED1_MASK 0xffffffff
#define  USB3D_SS_DMA_STATE_REG_4_RESERVED1_SHIFT 0
#define  USB3D_SS_DMA_STATE_REG_4_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_4_RESERVED1_MASK) >> USB3D_SS_DMA_STATE_REG_4_RESERVED1_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_4_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_4_RESERVED1_SHIFT))

//====================================================================
//Register: DMA_STATE_REG_5 (DMA_STATE_REG_5)
//====================================================================

#define  USB3D_SS_DMA_STATE_REG_5_RESERVED1_MASK 0xffffffff
#define  USB3D_SS_DMA_STATE_REG_5_RESERVED1_SHIFT 0
#define  USB3D_SS_DMA_STATE_REG_5_RESERVED1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DMA_STATE_REG_5_RESERVED1_MASK) >> USB3D_SS_DMA_STATE_REG_5_RESERVED1_SHIFT)
#define  USB3D_SS_DMA_STATE_REG_5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DMA_STATE_REG_5_RESERVED1_MASK) | (((uint32_t)val) << USB3D_SS_DMA_STATE_REG_5_RESERVED1_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_0 (SEGMENT_COUNTER_REG_0)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_0_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_0_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_0_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_0_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_0_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_0_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_0_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_0_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_0_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_0_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_0_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_0_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_0_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_0_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_0_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_0_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_1 (SEGMENT_COUNTER_REG_1)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_1_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_1_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_1_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_1_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_1_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_1_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_1_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_1_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_1_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_1_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_1_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_1_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_1_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_1_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_1_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_1_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_2 (SEGMENT_COUNTER_REG_2)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_2_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_2_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_2_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_2_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_2_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_2_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_2_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_2_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_2_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_2_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_2_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_2_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_2_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_2_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_2_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_2_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_3 (SEGMENT_COUNTER_REG_3)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_3_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_3_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_3_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_3_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_3_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_3_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_3_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_3_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_3_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_3_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_3_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_3_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_3_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_3_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_3_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_3_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_4 (SEGMENT_COUNTER_REG_4)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_4_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_4_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_4_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_4_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_4_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_4_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_4_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_4_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_4_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_4_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_4_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_4_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_4_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_4_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_4_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_4_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_5 (SEGMENT_COUNTER_REG_5)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_5_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_5_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_5_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_5_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_5_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_5_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_5_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_5_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_5_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_5_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_5_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_5_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_5_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_5_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_5_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_5_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_6 (SEGMENT_COUNTER_REG_6)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_6_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_6_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_6_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_6_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_6_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_6_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_6_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_6_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_6_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_6_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_6_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_6_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_6_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_6_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_6_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_6_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_7 (SEGMENT_COUNTER_REG_7)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_7_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_7_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_7_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_7_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_7_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_7_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_7_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_7_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_7_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_7_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_7_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_7_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_7_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_7_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_7_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_7_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_8 (SEGMENT_COUNTER_REG_8)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_8_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_8_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_8_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_8_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_8_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_8_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_8_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_8_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_8_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_8_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_8_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_8_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_8_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_8_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_8_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_8_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_9 (SEGMENT_COUNTER_REG_9)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_9_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_9_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_9_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_9_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_9_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_9_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_9_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_9_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_9_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_9_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_9_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_9_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_9_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_9_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_9_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_9_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_10 (SEGMENT_COUNTER_REG_10)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_10_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_10_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_10_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_10_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_10_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_10_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_10_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_10_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_10_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_10_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_10_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_10_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_10_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_10_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_10_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_10_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_11 (SEGMENT_COUNTER_REG_11)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_11_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_11_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_11_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_11_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_11_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_11_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_11_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_11_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_11_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_11_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_11_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_11_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_11_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_11_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_11_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_11_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_12 (SEGMENT_COUNTER_REG_12)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_12_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_12_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_12_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_12_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_12_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_12_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_12_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_12_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_12_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_12_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_12_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_12_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_12_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_12_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_12_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_12_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_13 (SEGMENT_COUNTER_REG_13)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_13_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_13_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_13_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_13_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_13_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_13_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_13_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_13_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_13_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_13_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_13_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_13_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_13_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_13_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_13_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_13_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_14 (SEGMENT_COUNTER_REG_14)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_14_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_14_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_14_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_14_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_14_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_14_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_14_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_14_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_14_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_14_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_14_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_14_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_14_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_14_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_14_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_14_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: SEGMENT_COUNTER_REG_15 (SEGMENT_COUNTER_REG_15)
//====================================================================

#define  USB3D_SS_SEGMENT_COUNTER_REG_15_IN_SEG_CNT_N_MASK 0xffff0000
#define  USB3D_SS_SEGMENT_COUNTER_REG_15_IN_SEG_CNT_N_SHIFT 16
#define  USB3D_SS_SEGMENT_COUNTER_REG_15_IN_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_15_IN_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_15_IN_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_15_IN_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_15_IN_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_15_IN_SEG_CNT_N_SHIFT))

#define  USB3D_SS_SEGMENT_COUNTER_REG_15_OUT_SEG_CNT_N_MASK 0xffff
#define  USB3D_SS_SEGMENT_COUNTER_REG_15_OUT_SEG_CNT_N_SHIFT 0
#define  USB3D_SS_SEGMENT_COUNTER_REG_15_OUT_SEG_CNT_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_SEGMENT_COUNTER_REG_15_OUT_SEG_CNT_N_MASK) >> USB3D_SS_SEGMENT_COUNTER_REG_15_OUT_SEG_CNT_N_SHIFT)
#define  USB3D_SS_SEGMENT_COUNTER_REG_15_OUT_SEG_CNT_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_SEGMENT_COUNTER_REG_15_OUT_SEG_CNT_N_MASK) | (((uint32_t)val) << USB3D_SS_SEGMENT_COUNTER_REG_15_OUT_SEG_CNT_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_0 (EP_IN_DONEQ_START_ADDRESS_REG_0)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_0_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_0_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_0_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_0_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_0_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_0_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_0_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_0_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_1 (EP_IN_DONEQ_START_ADDRESS_REG_1)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_1_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_1_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_1_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_1_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_1_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_1_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_1_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_1_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_2 (EP_IN_DONEQ_START_ADDRESS_REG_2)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_2_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_2_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_2_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_2_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_2_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_2_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_2_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_2_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_3 (EP_IN_DONEQ_START_ADDRESS_REG_3)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_3_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_3_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_3_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_3_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_3_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_3_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_3_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_3_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_4 (EP_IN_DONEQ_START_ADDRESS_REG_4)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_4_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_4_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_4_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_4_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_4_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_4_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_4_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_4_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_5 (EP_IN_DONEQ_START_ADDRESS_REG_5)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_5_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_5_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_5_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_5_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_5_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_5_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_5_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_5_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_6 (EP_IN_DONEQ_START_ADDRESS_REG_6)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_6_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_6_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_6_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_6_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_6_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_6_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_6_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_6_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_7 (EP_IN_DONEQ_START_ADDRESS_REG_7)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_7_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_7_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_7_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_7_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_7_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_7_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_7_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_7_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_8 (EP_IN_DONEQ_START_ADDRESS_REG_8)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_8_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_8_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_8_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_8_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_8_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_8_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_8_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_8_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_9 (EP_IN_DONEQ_START_ADDRESS_REG_9)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_9_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_9_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_9_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_9_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_9_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_9_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_9_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_9_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_10 (EP_IN_DONEQ_START_ADDRESS_REG_10)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_10_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_10_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_10_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_10_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_10_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_10_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_10_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_10_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_11 (EP_IN_DONEQ_START_ADDRESS_REG_11)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_11_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_11_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_11_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_11_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_11_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_11_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_11_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_11_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_12 (EP_IN_DONEQ_START_ADDRESS_REG_12)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_12_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_12_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_12_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_12_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_12_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_12_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_12_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_12_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_13 (EP_IN_DONEQ_START_ADDRESS_REG_13)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_13_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_13_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_13_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_13_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_13_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_13_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_13_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_13_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_14 (EP_IN_DONEQ_START_ADDRESS_REG_14)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_14_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_14_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_14_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_14_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_14_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_14_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_14_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_14_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_START_ADDRESS_REG_15 (EP_IN_DONEQ_START_ADDRESS_REG_15)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_15_IN_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_15_IN_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_15_IN_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_15_IN_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_15_IN_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_15_IN_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_15_IN_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_START_ADDRESS_REG_15_IN_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_0 (EP_IN_DONEQ_END_ADDRESS_REG_0)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_0_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_0_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_0_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_0_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_0_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_0_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_0_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_0_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_1 (EP_IN_DONEQ_END_ADDRESS_REG_1)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_1_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_1_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_1_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_1_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_1_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_1_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_1_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_1_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_2 (EP_IN_DONEQ_END_ADDRESS_REG_2)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_2_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_2_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_2_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_2_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_2_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_2_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_2_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_2_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_3 (EP_IN_DONEQ_END_ADDRESS_REG_3)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_3_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_3_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_3_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_3_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_3_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_3_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_3_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_3_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_4 (EP_IN_DONEQ_END_ADDRESS_REG_4)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_4_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_4_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_4_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_4_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_4_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_4_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_4_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_4_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_5 (EP_IN_DONEQ_END_ADDRESS_REG_5)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_5_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_5_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_5_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_5_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_5_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_5_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_5_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_5_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_6 (EP_IN_DONEQ_END_ADDRESS_REG_6)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_6_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_6_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_6_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_6_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_6_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_6_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_6_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_6_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_7 (EP_IN_DONEQ_END_ADDRESS_REG_7)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_7_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_7_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_7_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_7_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_7_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_7_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_7_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_7_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_8 (EP_IN_DONEQ_END_ADDRESS_REG_8)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_8_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_8_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_8_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_8_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_8_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_8_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_8_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_8_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_9 (EP_IN_DONEQ_END_ADDRESS_REG_9)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_9_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_9_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_9_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_9_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_9_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_9_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_9_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_9_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_10 (EP_IN_DONEQ_END_ADDRESS_REG_10)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_10_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_10_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_10_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_10_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_10_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_10_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_10_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_10_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_11 (EP_IN_DONEQ_END_ADDRESS_REG_11)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_11_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_11_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_11_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_11_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_11_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_11_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_11_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_11_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_12 (EP_IN_DONEQ_END_ADDRESS_REG_12)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_12_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_12_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_12_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_12_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_12_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_12_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_12_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_12_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_13 (EP_IN_DONEQ_END_ADDRESS_REG_13)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_13_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_13_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_13_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_13_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_13_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_13_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_13_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_13_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_14 (EP_IN_DONEQ_END_ADDRESS_REG_14)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_14_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_14_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_14_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_14_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_14_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_14_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_14_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_14_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_END_ADDRESS_REG_15 (EP_IN_DONEQ_END_ADDRESS_REG_15)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_15_IN_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_15_IN_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_15_IN_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_15_IN_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_15_IN_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_15_IN_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_15_IN_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_END_ADDRESS_REG_15_IN_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_0 (EP_OUT_DONEQ_START_ADDRESS_REG_0)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_0_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_0_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_0_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_0_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_0_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_0_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_0_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_0_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_1 (EP_OUT_DONEQ_START_ADDRESS_REG_1)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_1_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_1_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_1_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_1_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_1_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_1_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_1_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_1_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_2 (EP_OUT_DONEQ_START_ADDRESS_REG_2)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_2_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_2_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_2_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_2_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_2_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_2_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_2_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_2_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_3 (EP_OUT_DONEQ_START_ADDRESS_REG_3)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_3_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_3_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_3_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_3_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_3_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_3_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_3_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_3_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_4 (EP_OUT_DONEQ_START_ADDRESS_REG_4)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_4_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_4_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_4_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_4_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_4_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_4_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_4_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_4_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_5 (EP_OUT_DONEQ_START_ADDRESS_REG_5)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_5_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_5_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_5_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_5_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_5_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_5_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_5_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_5_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_6 (EP_OUT_DONEQ_START_ADDRESS_REG_6)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_6_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_6_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_6_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_6_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_6_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_6_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_6_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_6_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_7 (EP_OUT_DONEQ_START_ADDRESS_REG_7)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_7_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_7_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_7_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_7_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_7_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_7_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_7_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_7_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_8 (EP_OUT_DONEQ_START_ADDRESS_REG_8)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_8_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_8_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_8_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_8_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_8_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_8_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_8_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_8_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_9 (EP_OUT_DONEQ_START_ADDRESS_REG_9)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_9_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_9_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_9_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_9_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_9_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_9_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_9_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_9_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_10 (EP_OUT_DONEQ_START_ADDRESS_REG_10)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_10_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_10_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_10_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_10_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_10_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_10_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_10_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_10_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_11 (EP_OUT_DONEQ_START_ADDRESS_REG_11)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_11_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_11_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_11_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_11_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_11_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_11_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_11_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_11_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_12 (EP_OUT_DONEQ_START_ADDRESS_REG_12)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_12_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_12_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_12_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_12_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_12_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_12_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_12_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_12_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_13 (EP_OUT_DONEQ_START_ADDRESS_REG_13)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_13_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_13_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_13_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_13_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_13_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_13_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_13_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_13_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_14 (EP_OUT_DONEQ_START_ADDRESS_REG_14)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_14_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_14_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_14_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_14_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_14_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_14_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_14_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_14_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_START_ADDRESS_REG_15 (EP_OUT_DONEQ_START_ADDRESS_REG_15)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_15_OUT_DONEQ_START_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_15_OUT_DONEQ_START_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_15_OUT_DONEQ_START_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_15_OUT_DONEQ_START_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_15_OUT_DONEQ_START_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_15_OUT_DONEQ_START_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_15_OUT_DONEQ_START_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_START_ADDRESS_REG_15_OUT_DONEQ_START_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_0 (EP_OUT_DONEQ_END_ADDRESS_REG_0)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_0_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_0_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_0_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_0_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_0_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_0_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_0_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_0_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_1 (EP_OUT_DONEQ_END_ADDRESS_REG_1)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_1_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_1_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_1_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_1_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_1_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_1_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_1_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_1_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_2 (EP_OUT_DONEQ_END_ADDRESS_REG_2)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_2_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_2_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_2_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_2_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_2_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_2_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_2_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_2_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_3 (EP_OUT_DONEQ_END_ADDRESS_REG_3)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_3_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_3_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_3_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_3_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_3_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_3_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_3_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_3_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_4 (EP_OUT_DONEQ_END_ADDRESS_REG_4)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_4_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_4_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_4_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_4_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_4_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_4_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_4_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_4_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_5 (EP_OUT_DONEQ_END_ADDRESS_REG_5)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_5_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_5_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_5_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_5_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_5_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_5_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_5_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_5_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_6 (EP_OUT_DONEQ_END_ADDRESS_REG_6)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_6_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_6_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_6_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_6_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_6_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_6_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_6_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_6_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_7 (EP_OUT_DONEQ_END_ADDRESS_REG_7)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_7_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_7_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_7_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_7_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_7_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_7_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_7_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_7_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_8 (EP_OUT_DONEQ_END_ADDRESS_REG_8)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_8_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_8_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_8_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_8_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_8_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_8_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_8_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_8_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_9 (EP_OUT_DONEQ_END_ADDRESS_REG_9)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_9_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_9_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_9_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_9_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_9_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_9_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_9_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_9_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_10 (EP_OUT_DONEQ_END_ADDRESS_REG_10)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_10_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_10_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_10_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_10_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_10_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_10_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_10_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_10_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_11 (EP_OUT_DONEQ_END_ADDRESS_REG_11)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_11_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_11_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_11_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_11_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_11_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_11_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_11_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_11_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_12 (EP_OUT_DONEQ_END_ADDRESS_REG_12)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_12_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_12_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_12_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_12_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_12_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_12_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_12_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_12_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_13 (EP_OUT_DONEQ_END_ADDRESS_REG_13)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_13_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_13_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_13_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_13_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_13_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_13_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_13_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_13_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_14 (EP_OUT_DONEQ_END_ADDRESS_REG_14)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_14_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_14_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_14_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_14_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_14_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_14_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_14_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_14_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_END_ADDRESS_REG_15 (EP_OUT_DONEQ_END_ADDRESS_REG_15)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_15_OUT_DONEQ_END_ADDR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_15_OUT_DONEQ_END_ADDR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_15_OUT_DONEQ_END_ADDR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_15_OUT_DONEQ_END_ADDR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_15_OUT_DONEQ_END_ADDR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_15_OUT_DONEQ_END_ADDR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_15_OUT_DONEQ_END_ADDR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_END_ADDRESS_REG_15_OUT_DONEQ_END_ADDR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_0 (EP_IN_DONEQ_WRITE_POINTER_REG_0)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_0_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_0_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_0_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_0_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_0_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_0_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_0_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_0_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_1 (EP_IN_DONEQ_WRITE_POINTER_REG_1)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_1_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_1_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_1_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_1_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_1_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_1_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_1_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_1_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_2 (EP_IN_DONEQ_WRITE_POINTER_REG_2)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_2_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_2_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_2_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_2_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_2_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_2_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_2_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_2_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_3 (EP_IN_DONEQ_WRITE_POINTER_REG_3)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_3_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_3_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_3_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_3_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_3_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_3_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_3_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_3_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_4 (EP_IN_DONEQ_WRITE_POINTER_REG_4)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_4_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_4_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_4_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_4_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_4_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_4_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_4_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_4_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_5 (EP_IN_DONEQ_WRITE_POINTER_REG_5)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_5_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_5_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_5_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_5_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_5_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_5_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_5_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_5_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_6 (EP_IN_DONEQ_WRITE_POINTER_REG_6)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_6_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_6_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_6_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_6_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_6_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_6_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_6_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_6_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_7 (EP_IN_DONEQ_WRITE_POINTER_REG_7)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_7_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_7_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_7_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_7_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_7_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_7_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_7_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_7_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_8 (EP_IN_DONEQ_WRITE_POINTER_REG_8)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_8_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_8_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_8_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_8_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_8_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_8_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_8_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_8_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_9 (EP_IN_DONEQ_WRITE_POINTER_REG_9)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_9_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_9_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_9_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_9_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_9_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_9_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_9_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_9_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_10 (EP_IN_DONEQ_WRITE_POINTER_REG_10)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_10_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_10_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_10_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_10_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_10_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_10_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_10_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_10_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_11 (EP_IN_DONEQ_WRITE_POINTER_REG_11)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_11_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_11_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_11_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_11_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_11_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_11_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_11_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_11_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_12 (EP_IN_DONEQ_WRITE_POINTER_REG_12)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_12_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_12_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_12_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_12_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_12_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_12_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_12_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_12_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_13 (EP_IN_DONEQ_WRITE_POINTER_REG_13)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_13_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_13_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_13_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_13_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_13_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_13_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_13_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_13_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_14 (EP_IN_DONEQ_WRITE_POINTER_REG_14)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_14_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_14_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_14_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_14_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_14_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_14_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_14_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_14_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_WRITE_POINTER_REG_15 (EP_IN_DONEQ_WRITE_POINTER_REG_15)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_15_IN_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_15_IN_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_15_IN_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_15_IN_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_15_IN_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_15_IN_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_15_IN_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_WRITE_POINTER_REG_15_IN_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_0 (EP_IN_DONEQ_READ_POINTER_REG_0)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_0_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_0_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_0_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_0_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_0_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_0_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_0_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_0_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_1 (EP_IN_DONEQ_READ_POINTER_REG_1)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_1_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_1_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_1_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_1_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_1_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_1_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_1_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_1_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_2 (EP_IN_DONEQ_READ_POINTER_REG_2)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_2_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_2_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_2_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_2_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_2_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_2_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_2_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_2_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_3 (EP_IN_DONEQ_READ_POINTER_REG_3)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_3_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_3_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_3_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_3_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_3_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_3_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_3_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_3_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_4 (EP_IN_DONEQ_READ_POINTER_REG_4)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_4_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_4_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_4_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_4_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_4_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_4_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_4_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_4_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_5 (EP_IN_DONEQ_READ_POINTER_REG_5)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_5_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_5_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_5_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_5_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_5_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_5_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_5_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_5_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_6 (EP_IN_DONEQ_READ_POINTER_REG_6)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_6_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_6_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_6_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_6_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_6_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_6_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_6_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_6_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_7 (EP_IN_DONEQ_READ_POINTER_REG_7)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_7_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_7_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_7_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_7_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_7_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_7_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_7_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_7_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_8 (EP_IN_DONEQ_READ_POINTER_REG_8)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_8_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_8_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_8_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_8_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_8_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_8_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_8_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_8_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_9 (EP_IN_DONEQ_READ_POINTER_REG_9)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_9_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_9_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_9_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_9_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_9_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_9_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_9_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_9_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_10 (EP_IN_DONEQ_READ_POINTER_REG_10)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_10_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_10_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_10_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_10_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_10_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_10_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_10_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_10_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_11 (EP_IN_DONEQ_READ_POINTER_REG_11)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_11_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_11_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_11_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_11_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_11_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_11_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_11_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_11_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_12 (EP_IN_DONEQ_READ_POINTER_REG_12)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_12_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_12_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_12_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_12_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_12_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_12_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_12_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_12_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_13 (EP_IN_DONEQ_READ_POINTER_REG_13)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_13_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_13_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_13_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_13_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_13_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_13_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_13_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_13_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_14 (EP_IN_DONEQ_READ_POINTER_REG_14)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_14_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_14_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_14_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_14_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_14_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_14_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_14_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_14_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_IN_DONEQ_READ_POINTER_REG_15 (EP_IN_DONEQ_READ_POINTER_REG_15)
//====================================================================

#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_15_IN_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_15_IN_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_15_IN_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_15_IN_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_15_IN_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_15_IN_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_15_IN_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_IN_DONEQ_READ_POINTER_REG_15_IN_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_0 (EP_OUT_DONEQ_WRITE_POINTER_REG_0)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_0_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_0_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_0_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_0_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_0_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_0_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_0_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_0_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_1 (EP_OUT_DONEQ_WRITE_POINTER_REG_1)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_1_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_1_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_1_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_1_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_1_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_1_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_1_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_1_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_2 (EP_OUT_DONEQ_WRITE_POINTER_REG_2)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_2_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_2_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_2_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_2_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_2_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_2_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_2_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_2_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_3 (EP_OUT_DONEQ_WRITE_POINTER_REG_3)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_3_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_3_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_3_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_3_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_3_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_3_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_3_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_3_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_4 (EP_OUT_DONEQ_WRITE_POINTER_REG_4)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_4_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_4_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_4_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_4_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_4_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_4_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_4_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_4_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_5 (EP_OUT_DONEQ_WRITE_POINTER_REG_5)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_5_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_5_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_5_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_5_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_5_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_5_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_5_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_5_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_6 (EP_OUT_DONEQ_WRITE_POINTER_REG_6)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_6_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_6_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_6_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_6_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_6_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_6_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_6_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_6_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_7 (EP_OUT_DONEQ_WRITE_POINTER_REG_7)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_7_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_7_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_7_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_7_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_7_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_7_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_7_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_7_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_8 (EP_OUT_DONEQ_WRITE_POINTER_REG_8)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_8_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_8_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_8_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_8_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_8_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_8_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_8_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_8_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_9 (EP_OUT_DONEQ_WRITE_POINTER_REG_9)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_9_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_9_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_9_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_9_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_9_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_9_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_9_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_9_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_10 (EP_OUT_DONEQ_WRITE_POINTER_REG_10)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_10_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_10_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_10_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_10_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_10_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_10_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_10_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_10_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_11 (EP_OUT_DONEQ_WRITE_POINTER_REG_11)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_11_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_11_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_11_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_11_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_11_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_11_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_11_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_11_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_12 (EP_OUT_DONEQ_WRITE_POINTER_REG_12)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_12_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_12_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_12_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_12_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_12_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_12_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_12_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_12_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_13 (EP_OUT_DONEQ_WRITE_POINTER_REG_13)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_13_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_13_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_13_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_13_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_13_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_13_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_13_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_13_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_14 (EP_OUT_DONEQ_WRITE_POINTER_REG_14)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_14_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_14_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_14_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_14_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_14_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_14_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_14_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_14_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_WRITE_POINTER_REG_15 (EP_OUT_DONEQ_WRITE_POINTER_REG_15)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_15_OUT_DONEQ_WPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_15_OUT_DONEQ_WPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_15_OUT_DONEQ_WPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_15_OUT_DONEQ_WPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_15_OUT_DONEQ_WPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_15_OUT_DONEQ_WPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_15_OUT_DONEQ_WPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_WRITE_POINTER_REG_15_OUT_DONEQ_WPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_0 (EP_OUT_DONEQ_READ_POINTER_REG_0)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_0_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_0_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_0_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_0_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_0_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_0_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_0_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_0_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_1 (EP_OUT_DONEQ_READ_POINTER_REG_1)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_1_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_1_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_1_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_1_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_1_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_1_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_1_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_1_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_2 (EP_OUT_DONEQ_READ_POINTER_REG_2)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_2_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_2_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_2_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_2_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_2_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_2_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_2_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_2_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_3 (EP_OUT_DONEQ_READ_POINTER_REG_3)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_3_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_3_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_3_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_3_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_3_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_3_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_3_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_3_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_4 (EP_OUT_DONEQ_READ_POINTER_REG_4)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_4_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_4_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_4_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_4_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_4_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_4_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_4_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_4_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_5 (EP_OUT_DONEQ_READ_POINTER_REG_5)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_5_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_5_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_5_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_5_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_5_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_5_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_5_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_5_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_6 (EP_OUT_DONEQ_READ_POINTER_REG_6)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_6_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_6_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_6_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_6_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_6_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_6_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_6_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_6_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_7 (EP_OUT_DONEQ_READ_POINTER_REG_7)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_7_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_7_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_7_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_7_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_7_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_7_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_7_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_7_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_8 (EP_OUT_DONEQ_READ_POINTER_REG_8)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_8_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_8_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_8_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_8_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_8_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_8_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_8_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_8_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_9 (EP_OUT_DONEQ_READ_POINTER_REG_9)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_9_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_9_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_9_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_9_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_9_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_9_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_9_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_9_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_10 (EP_OUT_DONEQ_READ_POINTER_REG_10)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_10_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_10_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_10_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_10_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_10_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_10_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_10_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_10_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_11 (EP_OUT_DONEQ_READ_POINTER_REG_11)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_11_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_11_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_11_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_11_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_11_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_11_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_11_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_11_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_12 (EP_OUT_DONEQ_READ_POINTER_REG_12)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_12_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_12_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_12_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_12_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_12_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_12_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_12_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_12_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_13 (EP_OUT_DONEQ_READ_POINTER_REG_13)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_13_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_13_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_13_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_13_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_13_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_13_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_13_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_13_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_14 (EP_OUT_DONEQ_READ_POINTER_REG_14)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_14_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_14_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_14_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_14_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_14_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_14_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_14_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_14_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: EP_OUT_DONEQ_READ_POINTER_REG_15 (EP_OUT_DONEQ_READ_POINTER_REG_15)
//====================================================================

#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_15_OUT_DONEQ_RPTR_N_MASK 0xffffffff
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_15_OUT_DONEQ_RPTR_N_SHIFT 0
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_15_OUT_DONEQ_RPTR_N_MASK_SHIFT(reg) (((reg) & USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_15_OUT_DONEQ_RPTR_N_MASK) >> USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_15_OUT_DONEQ_RPTR_N_SHIFT)
#define  USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_15_OUT_DONEQ_RPTR_N_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_15_OUT_DONEQ_RPTR_N_MASK) | (((uint32_t)val) << USB3D_SS_EP_OUT_DONEQ_READ_POINTER_REG_15_OUT_DONEQ_RPTR_N_SHIFT))

//====================================================================
//Register: DONEQ_FULL_STATUS_REG (DONEQ_FULL_STATUS_REG)
//====================================================================

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_15_MASK 0x80000000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_15_SHIFT 31
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_15_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_15_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_15_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_15_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_14_MASK 0x40000000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_14_SHIFT 30
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_14_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_14_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_14_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_14_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_13_MASK 0x20000000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_13_SHIFT 29
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_13_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_13_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_13_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_13_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_12_MASK 0x10000000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_12_SHIFT 28
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_12_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_12_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_12_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_12_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_11_MASK 0x8000000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_11_SHIFT 27
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_11_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_11_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_11_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_11_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_10_MASK 0x4000000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_10_SHIFT 26
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_10_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_10_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_10_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_10_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_9_MASK 0x2000000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_9_SHIFT 25
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_9_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_9_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_9_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_9_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_8_MASK 0x1000000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_8_SHIFT 24
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_8_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_8_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_8_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_8_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_7_MASK 0x800000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_7_SHIFT 23
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_7_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_7_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_7_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_7_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_6_MASK 0x400000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_6_SHIFT 22
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_6_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_6_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_6_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_6_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_5_MASK 0x200000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_5_SHIFT 21
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_5_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_5_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_5_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_5_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_4_MASK 0x100000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_4_SHIFT 20
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_4_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_4_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_4_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_4_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_3_MASK 0x80000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_3_SHIFT 19
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_3_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_3_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_3_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_3_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_2_MASK 0x40000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_2_SHIFT 18
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_2_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_2_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_2_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_2_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_1_MASK 0x20000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_1_SHIFT 17
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_1_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_1_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_1_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_1_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_0_MASK 0x10000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_0_SHIFT 16
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_0_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_0_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_0_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_IN_DONEQ_FULL_0_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_15_MASK 0x8000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_15_SHIFT 15
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_15_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_15_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_15_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_15_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_14_MASK 0x4000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_14_SHIFT 14
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_14_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_14_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_14_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_14_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_13_MASK 0x2000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_13_SHIFT 13
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_13_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_13_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_13_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_13_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_13_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_13_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_12_MASK 0x1000
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_12_SHIFT 12
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_12_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_12_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_12_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_12_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_12_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_12_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_11_MASK 0x800
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_11_SHIFT 11
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_11_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_11_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_11_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_11_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_11_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_11_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_10_MASK 0x400
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_10_SHIFT 10
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_10_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_10_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_10_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_10_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_10_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_10_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_9_MASK 0x200
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_9_SHIFT 9
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_9_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_9_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_9_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_9_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_9_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_9_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_8_MASK 0x100
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_8_SHIFT 8
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_8_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_8_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_8_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_8_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_8_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_8_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_7_MASK 0x80
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_7_SHIFT 7
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_7_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_7_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_7_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_7_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_7_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_7_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_6_MASK 0x40
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_6_SHIFT 6
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_6_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_6_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_6_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_6_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_6_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_6_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_5_MASK 0x20
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_5_SHIFT 5
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_5_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_5_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_5_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_5_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_5_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_5_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_4_MASK 0x10
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_4_SHIFT 4
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_4_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_4_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_4_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_4_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_4_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_4_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_3_MASK 0x8
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_3_SHIFT 3
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_3_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_3_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_3_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_3_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_3_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_3_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_2_MASK 0x4
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_2_SHIFT 2
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_2_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_2_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_2_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_2_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_2_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_2_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_1_MASK 0x2
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_1_SHIFT 1
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_1_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_1_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_1_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_1_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_1_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_1_SHIFT))

#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_0_MASK 0x1
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_0_SHIFT 0
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_0_MASK_SHIFT(reg) (((reg) & USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_0_MASK) >> USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_0_SHIFT)
#define  USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_0_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_0_MASK) | (((uint32_t)val) << USB3D_SS_DONEQ_FULL_STATUS_REG_OUT_DONEQ_FULL_0_SHIFT))

//====================================================================
//Register: ABORT_REQ_STATUS_REG (ABORT_REQ_STATUS_REG)
//====================================================================

#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_15_MASK 0x80000000
#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_15_SHIFT 31
#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_15_MASK_SHIFT(reg) (((reg) & USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_15_MASK) >> USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_15_SHIFT)
#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_15_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_15_MASK) | (((uint32_t)val) << USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_15_SHIFT))

#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_14_MASK 0x40000000
#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_14_SHIFT 30
#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_14_MASK_SHIFT(reg) (((reg) & USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_14_MASK) >> USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_14_SHIFT)
#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_14_REPLACE_VAL(reg,val) (((reg) & ~USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_14_MASK) | (((uint32_t)val) << USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_14_SHIFT))

#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_13_MASK 0x20000000
#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_13_SHIFT 29
#define  USB3D_SS_ABORT_REQ_STATUS_REG_IN_ABORT_REQ_13_MASK_