 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file UED_advanced_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _UED_ADVANCED_REGSTRUCTS_H_
#define _UED_ADVANCED_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Universal Error Diffusion Halftone Registers (UED_advanced)
/** \brief Register descriptions for the Univeral Error Diffusion halfTone block (UED).
    (rev 0 . 8 . 0 . 3)*/
//
//====================================================================

typedef struct UED_ADVANCED_REGS_s
{
  volatile uint32_t CLUT0[256];  ///< 0x0 [R/W]: TDS LUT SRAM (Instance 1 of 6)
  volatile uint32_t CLUT1[256];  ///< 0x400 [R/W]: TDS LUT SRAM (Instance 2 of 6)
  volatile uint32_t CLUT2[256];  ///< 0x800 [R/W]: TDS LUT SRAM (Instance 3 of 6)
  volatile uint32_t CLUT3[256];  ///< 0xc00 [R/W]: TDS LUT SRAM (Instance 4 of 6)
  volatile uint32_t CLUT4[256];  ///< 0x1000 [R/W]: TDS LUT SRAM (Instance 5 of 6)
  volatile uint32_t CLUT5[256];  ///< 0x1400 [R/W]: TDS LUT SRAM (Instance 6 of 6)
  volatile uint32_t WLUT0[256];  ///< 0x1800 [R/W]: TDW LUT SRAM (Instance 1 of 6)
  volatile uint32_t WLUT1[256];  ///< 0x1c00 [R/W]: TDW LUT SRAM (Instance 2 of 6)
  volatile uint32_t WLUT2[256];  ///< 0x2000 [R/W]: TDW LUT SRAM (Instance 3 of 6)
  volatile uint32_t WLUT3[256];  ///< 0x2400 [R/W]: TDW LUT SRAM (Instance 4 of 6)
  volatile uint32_t WLUT4[256];  ///< 0x2800 [R/W]: TDW LUT SRAM (Instance 5 of 6)
  volatile uint32_t WLUT5[256];  ///< 0x2c00 [R/W]: TDW LUT SRAM (Instance 6 of 6)
  volatile uint32_t BLAC0;  ///< 0x3000 [R/W]: Bias LUT Access Command (Instance 1 of 6)
  volatile uint32_t BLAC1;  ///< 0x3004 [R/W]: Bias LUT Access Command (Instance 2 of 6)
  volatile uint32_t BLAC2;  ///< 0x3008 [R/W]: Bias LUT Access Command (Instance 3 of 6)
  volatile uint32_t BLAC3;  ///< 0x300c [R/W]: Bias LUT Access Command (Instance 4 of 6)
  volatile uint32_t BLAC4;  ///< 0x3010 [R/W]: Bias LUT Access Command (Instance 5 of 6)
  volatile uint32_t BLAC5;  ///< 0x3014 [R/W]: Bias LUT Access Command (Instance 6 of 6)
  volatile uint32_t BLAA0;  ///< 0x3018 [R/W]: Bias LUT Access Address (Instance 1 of 6)
  volatile uint32_t BLAA1;  ///< 0x301c [R/W]: Bias LUT Access Address (Instance 2 of 6)
  volatile uint32_t BLAA2;  ///< 0x3020 [R/W]: Bias LUT Access Address (Instance 3 of 6)
  volatile uint32_t BLAA3;  ///< 0x3024 [R/W]: Bias LUT Access Address (Instance 4 of 6)
  volatile uint32_t BLAA4;  ///< 0x3028 [R/W]: Bias LUT Access Address (Instance 5 of 6)
  volatile uint32_t BLAA5;  ///< 0x302c [R/W]: Bias LUT Access Address (Instance 6 of 6)
  volatile uint32_t BLAD0;  ///< 0x3030 [R/W]: Bias LUT Access Data (Instance 1 of 6)
  volatile uint32_t BLAD1;  ///< 0x3034 [R/W]: Bias LUT Access Data (Instance 2 of 6)
  volatile uint32_t BLAD2;  ///< 0x3038 [R/W]: Bias LUT Access Data (Instance 3 of 6)
  volatile uint32_t BLAD3;  ///< 0x303c [R/W]: Bias LUT Access Data (Instance 4 of 6)
  volatile uint32_t BLAD4;  ///< 0x3040 [R/W]: Bias LUT Access Data (Instance 5 of 6)
  volatile uint32_t BLAD5;  ///< 0x3044 [R/W]: Bias LUT Access Data (Instance 6 of 6)
  volatile uint32_t CFGA;  ///< 0x3048 [R/W]: Configuration Register
  volatile uint32_t CFGB;  ///< 0x304c [R/W]: Configuration Register for ED PAIR mode
  volatile uint32_t LW;  ///< 0x3050 [R/W]: Image Line Width
  volatile uint32_t L1;  ///< 0x3054 [R/W]: First Line Error Control
  volatile uint32_t PSA;  ///< 0x3058 [R/W]: Pixel Stacking Avoidance Control
  volatile uint32_t EWC;  ///< 0x305c [R/W]: Tone Dependent Error Weight Control
  volatile uint32_t EDC;  ///< 0x3060 [R/W]: Error Decay Control
  volatile uint32_t EDD1;  ///< 0x3064 [R/W]: Decay Error Weights
  volatile uint32_t EDD2;  ///< 0x3068 [R/W]: Decay Error Weights
  volatile uint32_t EWD1;  ///< 0x306c [R/W]: Default Error Weights
  volatile uint32_t EWD2;  ///< 0x3070 [R/W]: Default Error Weights
  volatile uint32_t B1;  ///< 0x3074 [R/W]: Bias Control 1
  volatile uint32_t B2;  ///< 0x3078 [R/W]: Bias Control 2
  volatile uint32_t B3;  ///< 0x307c [R/W]: Bias Control 3
  volatile uint32_t UBS;  ///< 0x3080 [R]: UED Build Spec
  volatile uint32_t BWS0;  ///< 0x3084 [R/W]: Bias Window Shape (Instance 1 of 6)
  volatile uint32_t BWS1;  ///< 0x3088 [R/W]: Bias Window Shape (Instance 2 of 6)
  volatile uint32_t BWS2;  ///< 0x308c [R/W]: Bias Window Shape (Instance 3 of 6)
  volatile uint32_t BWS3;  ///< 0x3090 [R/W]: Bias Window Shape (Instance 4 of 6)
  volatile uint32_t BWS4;  ///< 0x3094 [R/W]: Bias Window Shape (Instance 5 of 6)
  volatile uint32_t BWS5;  ///< 0x3098 [R/W]: Bias Window Shape (Instance 6 of 6)
  volatile uint32_t IR;  ///< 0x309c [R/W]: Image Row Odd Even
  volatile uint32_t BWR0;  ///< 0x30a0 [R/W]: Bias Window Row Access (Instance 1 of 6)
  volatile uint32_t BWR1;  ///< 0x30a4 [R/W]: Bias Window Row Access (Instance 2 of 6)
  volatile uint32_t BWR2;  ///< 0x30a8 [R/W]: Bias Window Row Access (Instance 3 of 6)
  volatile uint32_t BWR3;  ///< 0x30ac [R/W]: Bias Window Row Access (Instance 4 of 6)
  volatile uint32_t BWR4;  ///< 0x30b0 [R/W]: Bias Window Row Access (Instance 5 of 6)
  volatile uint32_t BWR5;  ///< 0x30b4 [R/W]: Bias Window Row Access (Instance 6 of 6)
  volatile uint32_t LFSRX0;  ///< 0x30b8 [R/W]: LFSR Context Switch (Instance 1 of 6)
  volatile uint32_t LFSRX1;  ///< 0x30bc [R/W]: LFSR Context Switch (Instance 2 of 6)
  volatile uint32_t LFSRX2;  ///< 0x30c0 [R/W]: LFSR Context Switch (Instance 3 of 6)
  volatile uint32_t LFSRX3;  ///< 0x30c4 [R/W]: LFSR Context Switch (Instance 4 of 6)
  volatile uint32_t LFSRX4;  ///< 0x30c8 [R/W]: LFSR Context Switch (Instance 5 of 6)
  volatile uint32_t LFSRX5;  ///< 0x30cc [R/W]: LFSR Context Switch (Instance 6 of 6)
  volatile uint32_t LFSRS0;  ///< 0x30d0 [R/W]: LFSR Start Value (Instance 1 of 6)
  volatile uint32_t LFSRS1;  ///< 0x30d4 [R/W]: LFSR Start Value (Instance 2 of 6)
  volatile uint32_t LFSRS2;  ///< 0x30d8 [R/W]: LFSR Start Value (Instance 3 of 6)
  volatile uint32_t LFSRS3;  ///< 0x30dc [R/W]: LFSR Start Value (Instance 4 of 6)
  volatile uint32_t LFSRS4;  ///< 0x30e0 [R/W]: LFSR Start Value (Instance 5 of 6)
  volatile uint32_t LFSRS5;  ///< 0x30e4 [R/W]: LFSR Start Value (Instance 6 of 6)
  volatile uint32_t THA0;  ///< 0x30e8 [R/W]: Thresholding Registers (Instance 1 of 30)
  volatile uint32_t THA1;  ///< 0x30ec [R/W]: Thresholding Registers (Instance 2 of 30)
  volatile uint32_t THA2;  ///< 0x30f0 [R/W]: Thresholding Registers (Instance 3 of 30)
  volatile uint32_t THA3;  ///< 0x30f4 [R/W]: Thresholding Registers (Instance 4 of 30)
  volatile uint32_t THA4;  ///< 0x30f8 [R/W]: Thresholding Registers (Instance 5 of 30)
  volatile uint32_t THA5;  ///< 0x30fc [R/W]: Thresholding Registers (Instance 6 of 30)
  volatile uint32_t THA6;  ///< 0x3100 [R/W]: Thresholding Registers (Instance 7 of 30)
  volatile uint32_t THA7;  ///< 0x3104 [R/W]: Thresholding Registers (Instance 8 of 30)
  volatile uint32_t THA8;  ///< 0x3108 [R/W]: Thresholding Registers (Instance 9 of 30)
  volatile uint32_t THA9;  ///< 0x310c [R/W]: Thresholding Registers (Instance 10 of 30)
  volatile uint32_t THA10;  ///< 0x3110 [R/W]: Thresholding Registers (Instance 11 of 30)
  volatile uint32_t THA11;  ///< 0x3114 [R/W]: Thresholding Registers (Instance 12 of 30)
  volatile uint32_t THA12;  ///< 0x3118 [R/W]: Thresholding Registers (Instance 13 of 30)
  volatile uint32_t THA13;  ///< 0x311c [R/W]: Thresholding Registers (Instance 14 of 30)
  volatile uint32_t THA14;  ///< 0x3120 [R/W]: Thresholding Registers (Instance 15 of 30)
  volatile uint32_t THA15;  ///< 0x3124 [R/W]: Thresholding Registers (Instance 16 of 30)
  volatile uint32_t THA16;  ///< 0x3128 [R/W]: Thresholding Registers (Instance 17 of 30)
  volatile uint32_t THA17;  ///< 0x312c [R/W]: Thresholding Registers (Instance 18 of 30)
  volatile uint32_t THA18;  ///< 0x3130 [R/W]: Thresholding Registers (Instance 19 of 30)
  volatile uint32_t THA19;  ///< 0x3134 [R/W]: Thresholding Registers (Instance 20 of 30)
  volatile uint32_t THA20;  ///< 0x3138 [R/W]: Thresholding Registers (Instance 21 of 30)
  volatile uint32_t THA21;  ///< 0x313c [R/W]: Thresholding Registers (Instance 22 of 30)
  volatile uint32_t THA22;  ///< 0x3140 [R/W]: Thresholding Registers (Instance 23 of 30)
  volatile uint32_t THA23;  ///< 0x3144 [R/W]: Thresholding Registers (Instance 24 of 30)
  volatile uint32_t THA24;  ///< 0x3148 [R/W]: Thresholding Registers (Instance 25 of 30)
  volatile uint32_t THA25;  ///< 0x314c [R/W]: Thresholding Registers (Instance 26 of 30)
  volatile uint32_t THA26;  ///< 0x3150 [R/W]: Thresholding Registers (Instance 27 of 30)
  volatile uint32_t THA27;  ///< 0x3154 [R/W]: Thresholding Registers (Instance 28 of 30)
  volatile uint32_t THA28;  ///< 0x3158 [R/W]: Thresholding Registers (Instance 29 of 30)
  volatile uint32_t THA29;  ///< 0x315c [R/W]: Thresholding Registers (Instance 30 of 30)
  volatile uint32_t THB0;  ///< 0x3160 [R/W]: Thresholding Registers for ED Pair (Instance 1 of 30)
  volatile uint32_t THB1;  ///< 0x3164 [R/W]: Thresholding Registers for ED Pair (Instance 2 of 30)
  volatile uint32_t THB2;  ///< 0x3168 [R/W]: Thresholding Registers for ED Pair (Instance 3 of 30)
  volatile uint32_t THB3;  ///< 0x316c [R/W]: Thresholding Registers for ED Pair (Instance 4 of 30)
  volatile uint32_t THB4;  ///< 0x3170 [R/W]: Thresholding Registers for ED Pair (Instance 5 of 30)
  volatile uint32_t THB5;  ///< 0x3174 [R/W]: Thresholding Registers for ED Pair (Instance 6 of 30)
  volatile uint32_t THB6;  ///< 0x3178 [R/W]: Thresholding Registers for ED Pair (Instance 7 of 30)
  volatile uint32_t THB7;  ///< 0x317c [R/W]: Thresholding Registers for ED Pair (Instance 8 of 30)
  volatile uint32_t THB8;  ///< 0x3180 [R/W]: Thresholding Registers for ED Pair (Instance 9 of 30)
  volatile uint32_t THB9;  ///< 0x3184 [R/W]: Thresholding Registers for ED Pair (Instance 10 of 30)
  volatile uint32_t THB10;  ///< 0x3188 [R/W]: Thresholding Registers for ED Pair (Instance 11 of 30)
  volatile uint32_t THB11;  ///< 0x318c [R/W]: Thresholding Registers for ED Pair (Instance 12 of 30)
  volatile uint32_t THB12;  ///< 0x3190 [R/W]: Thresholding Registers for ED Pair (Instance 13 of 30)
  volatile uint32_t THB13;  ///< 0x3194 [R/W]: Thresholding Registers for ED Pair (Instance 14 of 30)
  volatile uint32_t THB14;  ///< 0x3198 [R/W]: Thresholding Registers for ED Pair (Instance 15 of 30)
  volatile uint32_t THB15;  ///< 0x319c [R/W]: Thresholding Registers for ED Pair (Instance 16 of 30)
  volatile uint32_t THB16;  ///< 0x31a0 [R/W]: Thresholding Registers for ED Pair (Instance 17 of 30)
  volatile uint32_t THB17;  ///< 0x31a4 [R/W]: Thresholding Registers for ED Pair (Instance 18 of 30)
  volatile uint32_t THB18;  ///< 0x31a8 [R/W]: Thresholding Registers for ED Pair (Instance 19 of 30)
  volatile uint32_t THB19;  ///< 0x31ac [R/W]: Thresholding Registers for ED Pair (Instance 20 of 30)
  volatile uint32_t THB20;  ///< 0x31b0 [R/W]: Thresholding Registers for ED Pair (Instance 21 of 30)
  volatile uint32_t THB21;  ///< 0x31b4 [R/W]: Thresholding Registers for ED Pair (Instance 22 of 30)
  volatile uint32_t THB22;  ///< 0x31b8 [R/W]: Thresholding Registers for ED Pair (Instance 23 of 30)
  volatile uint32_t THB23;  ///< 0x31bc [R/W]: Thresholding Registers for ED Pair (Instance 24 of 30)
  volatile uint32_t THB24;  ///< 0x31c0 [R/W]: Thresholding Registers for ED Pair (Instance 25 of 30)
  volatile uint32_t THB25;  ///< 0x31c4 [R/W]: Thresholding Registers for ED Pair (Instance 26 of 30)
  volatile uint32_t THB26;  ///< 0x31c8 [R/W]: Thresholding Registers for ED Pair (Instance 27 of 30)
  volatile uint32_t THB27;  ///< 0x31cc [R/W]: Thresholding Registers for ED Pair (Instance 28 of 30)
  volatile uint32_t THB28;  ///< 0x31d0 [R/W]: Thresholding Registers for ED Pair (Instance 29 of 30)
  volatile uint32_t THB29;  ///< 0x31d4 [R/W]: Thresholding Registers for ED Pair (Instance 30 of 30)
  volatile uint32_t THC0;  ///< 0x31d8 [R/W]: Thresholding Level Limits (Instance 1 of 30)
  volatile uint32_t THC1;  ///< 0x31dc [R/W]: Thresholding Level Limits (Instance 2 of 30)
  volatile uint32_t THC2;  ///< 0x31e0 [R/W]: Thresholding Level Limits (Instance 3 of 30)
  volatile uint32_t THC3;  ///< 0x31e4 [R/W]: Thresholding Level Limits (Instance 4 of 30)
  volatile uint32_t THC4;  ///< 0x31e8 [R/W]: Thresholding Level Limits (Instance 5 of 30)
  volatile uint32_t THC5;  ///< 0x31ec [R/W]: Thresholding Level Limits (Instance 6 of 30)
  volatile uint32_t THC6;  ///< 0x31f0 [R/W]: Thresholding Level Limits (Instance 7 of 30)
  volatile uint32_t THC7;  ///< 0x31f4 [R/W]: Thresholding Level Limits (Instance 8 of 30)
  volatile uint32_t THC8;  ///< 0x31f8 [R/W]: Thresholding Level Limits (Instance 9 of 30)
  volatile uint32_t THC9;  ///< 0x31fc [R/W]: Thresholding Level Limits (Instance 10 of 30)
  volatile uint32_t THC10;  ///< 0x3200 [R/W]: Thresholding Level Limits (Instance 11 of 30)
  volatile uint32_t THC11;  ///< 0x3204 [R/W]: Thresholding Level Limits (Instance 12 of 30)
  volatile uint32_t THC12;  ///< 0x3208 [R/W]: Thresholding Level Limits (Instance 13 of 30)
  volatile uint32_t THC13;  ///< 0x320c [R/W]: Thresholding Level Limits (Instance 14 of 30)
  volatile uint32_t THC14;  ///< 0x3210 [R/W]: Thresholding Level Limits (Instance 15 of 30)
  volatile uint32_t THC15;  ///< 0x3214 [R/W]: Thresholding Level Limits (Instance 16 of 30)
  volatile uint32_t THC16;  ///< 0x3218 [R/W]: Thresholding Level Limits (Instance 17 of 30)
  volatile uint32_t THC17;  ///< 0x321c [R/W]: Thresholding Level Limits (Instance 18 of 30)
  volatile uint32_t THC18;  ///< 0x3220 [R/W]: Thresholding Level Limits (Instance 19 of 30)
  volatile uint32_t THC19;  ///< 0x3224 [R/W]: Thresholding Level Limits (Instance 20 of 30)
  volatile uint32_t THC20;  ///< 0x3228 [R/W]: Thresholding Level Limits (Instance 21 of 30)
  volatile uint32_t THC21;  ///< 0x322c [R/W]: Thresholding Level Limits (Instance 22 of 30)
  volatile uint32_t THC22;  ///< 0x3230 [R/W]: Thresholding Level Limits (Instance 23 of 30)
  volatile uint32_t THC23;  ///< 0x3234 [R/W]: Thresholding Level Limits (Instance 24 of 30)
  volatile uint32_t THC24;  ///< 0x3238 [R/W]: Thresholding Level Limits (Instance 25 of 30)
  volatile uint32_t THC25;  ///< 0x323c [R/W]: Thresholding Level Limits (Instance 26 of 30)
  volatile uint32_t THC26;  ///< 0x3240 [R/W]: Thresholding Level Limits (Instance 27 of 30)
  volatile uint32_t THC27;  ///< 0x3244 [R/W]: Thresholding Level Limits (Instance 28 of 30)
  volatile uint32_t THC28;  ///< 0x3248 [R/W]: Thresholding Level Limits (Instance 29 of 30)
  volatile uint32_t THC29;  ///< 0x324c [R/W]: Thresholding Level Limits (Instance 30 of 30)
  volatile uint32_t ECMP1;  ///< 0x3250 [R/W]: Error Compression Control
  volatile uint32_t ECMP3;  ///< 0x3254 [R/W]: Error Decompression Shift Settings
  volatile uint32_t ECA0;  ///< 0x3258 [R/W]: Error Current Access (Instance 1 of 6)
  volatile uint32_t ECA1;  ///< 0x325c [R/W]: Error Current Access (Instance 2 of 6)
  volatile uint32_t ECA2;  ///< 0x3260 [R/W]: Error Current Access (Instance 3 of 6)
  volatile uint32_t ECA3;  ///< 0x3264 [R/W]: Error Current Access (Instance 4 of 6)
  volatile uint32_t ECA4;  ///< 0x3268 [R/W]: Error Current Access (Instance 5 of 6)
  volatile uint32_t ECA5;  ///< 0x326c [R/W]: Error Current Access (Instance 6 of 6)
  volatile uint32_t THP0;  ///< 0x3270 [R/W]: PSA Thresholding Registers (Instance 1 of 9)
  volatile uint32_t THP1;  ///< 0x3274 [R/W]: PSA Thresholding Registers (Instance 2 of 9)
  volatile uint32_t THP2;  ///< 0x3278 [R/W]: PSA Thresholding Registers (Instance 3 of 9)
  volatile uint32_t THP3;  ///< 0x327c [R/W]: PSA Thresholding Registers (Instance 4 of 9)
  volatile uint32_t THP4;  ///< 0x3280 [R/W]: PSA Thresholding Registers (Instance 5 of 9)
  volatile uint32_t THP5;  ///< 0x3284 [R/W]: PSA Thresholding Registers (Instance 6 of 9)
  volatile uint32_t THP6;  ///< 0x3288 [R/W]: PSA Thresholding Registers (Instance 7 of 9)
  volatile uint32_t THP7;  ///< 0x328c [R/W]: PSA Thresholding Registers (Instance 8 of 9)
  volatile uint32_t THP8;  ///< 0x3290 [R/W]: PSA Thresholding Registers (Instance 9 of 9)
  volatile uint32_t REV0;  ///< 0x3294 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3298 [R]: IP Tagging Revision 1
} UED_ADVANCED_REGS_t;

#endif // UED_ADVANCED
