 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file TIMEBASE2_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _TIMEBASE2_REG_REGSTRUCTS_H_
#define _TIMEBASE2_REG_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: TIMEBASE2 Registers (TIMEBASE2_reg)
/** \brief TIMEBASE2 block is used to generate timing periods that are useful to other blocks in the system, such as the APB Timers/watchdog, AUXADC, Engine Control, DDAC Audio, and DC Motor. By using a common configurable timebase, each block is not burdened with programmable dividers. <BR>
   TIMEBASE2 is programmable to generate desired period timing given an input reference clock. The reference clock can be fixed to a stable time standard such as a 25MHz crystal oscillator clock. <BR>
   TIMEBASE2 provides an APB register interface and output timebases, both in the bus clk domain. There are six output timebases provided - 1us, 10us, 100us, 1ms, 10ms, 100ms. Each output timebase is a train of single clock cycle pulses, where the start of each pulse is separated by the timebase perioud (1us, 10us, etc).*/
//
//====================================================================

typedef struct TIMEBASE2_REG_REGS_s
{
  volatile uint32_t TCR;  ///< 0x0 [R/W]: Timebase Configuration Register
  volatile uint32_t TTR;  ///< 0x4 [R/W]: Timebase Testing Register
  volatile uint32_t REV0;  ///< 0x8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc [R]: IP Tagging Revision 1
} TIMEBASE2_REG_REGS_t;

#endif // TIMEBASE2_REG
