 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file TIMEBASE2_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _TIMEBASE2_REG_REGMASKS_H_
#define _TIMEBASE2_REG_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: TIMEBASE2 Registers (TIMEBASE2_reg)
/** \brief TIMEBASE2 block is used to generate timing periods that are useful to other blocks in the system, such as the APB Timers/watchdog, AUXADC, Engine Control, DDAC Audio, and DC Motor. By using a common configurable timebase, each block is not burdened with programmable dividers. <BR>
   TIMEBASE2 is programmable to generate desired period timing given an input reference clock. The reference clock can be fixed to a stable time standard such as a 25MHz crystal oscillator clock. <BR>
   TIMEBASE2 provides an APB register interface and output timebases, both in the bus clk domain. There are six output timebases provided - 1us, 10us, 100us, 1ms, 10ms, 100ms. Each output timebase is a train of single clock cycle pulses, where the start of each pulse is separated by the timebase perioud (1us, 10us, etc).*/
//
//====================================================================

//====================================================================
//Register: Timebase Configuration Register (TCR)
/** \brief This register is set to indicate the reference frequency. This permits the timebase to generate correct timebase periods over a wide range of reference frequencies.<BR>
            This register should be programmed immediately following boot, and should be adjusted whenever the frequency changes (if using a programmable system PLL). Note that the default frequency is set to 25 MHz. When this register is written, the timebase counter restarts.<BR>
            This register may also be used to disable the timebase outputs (for testing or low-power purposes).*/
//====================================================================

#define  TIMEBASE2_REG_TCR_RESERVED1_MASK 0xc0000000
#define  TIMEBASE2_REG_TCR_RESERVED1_SHIFT 30
#define  TIMEBASE2_REG_TCR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TCR_RESERVED1_MASK) >> TIMEBASE2_REG_TCR_RESERVED1_SHIFT)
#define  TIMEBASE2_REG_TCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TCR_RESERVED1_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TCR_RESERVED1_SHIFT))

#define  TIMEBASE2_REG_TCR_DISABLE100MS_MASK 0x20000000
#define  TIMEBASE2_REG_TCR_DISABLE100MS_SHIFT 29
#define  TIMEBASE2_REG_TCR_DISABLE100MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TCR_DISABLE100MS_MASK) >> TIMEBASE2_REG_TCR_DISABLE100MS_SHIFT)
#define  TIMEBASE2_REG_TCR_DISABLE100MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TCR_DISABLE100MS_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TCR_DISABLE100MS_SHIFT))

#define  TIMEBASE2_REG_TCR_DISABLE10MS_MASK 0x10000000
#define  TIMEBASE2_REG_TCR_DISABLE10MS_SHIFT 28
#define  TIMEBASE2_REG_TCR_DISABLE10MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TCR_DISABLE10MS_MASK) >> TIMEBASE2_REG_TCR_DISABLE10MS_SHIFT)
#define  TIMEBASE2_REG_TCR_DISABLE10MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TCR_DISABLE10MS_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TCR_DISABLE10MS_SHIFT))

#define  TIMEBASE2_REG_TCR_DISABLE1MS_MASK 0x8000000
#define  TIMEBASE2_REG_TCR_DISABLE1MS_SHIFT 27
#define  TIMEBASE2_REG_TCR_DISABLE1MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TCR_DISABLE1MS_MASK) >> TIMEBASE2_REG_TCR_DISABLE1MS_SHIFT)
#define  TIMEBASE2_REG_TCR_DISABLE1MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TCR_DISABLE1MS_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TCR_DISABLE1MS_SHIFT))

#define  TIMEBASE2_REG_TCR_DISABLE100US_MASK 0x4000000
#define  TIMEBASE2_REG_TCR_DISABLE100US_SHIFT 26
#define  TIMEBASE2_REG_TCR_DISABLE100US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TCR_DISABLE100US_MASK) >> TIMEBASE2_REG_TCR_DISABLE100US_SHIFT)
#define  TIMEBASE2_REG_TCR_DISABLE100US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TCR_DISABLE100US_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TCR_DISABLE100US_SHIFT))

#define  TIMEBASE2_REG_TCR_DISABLE10US_MASK 0x2000000
#define  TIMEBASE2_REG_TCR_DISABLE10US_SHIFT 25
#define  TIMEBASE2_REG_TCR_DISABLE10US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TCR_DISABLE10US_MASK) >> TIMEBASE2_REG_TCR_DISABLE10US_SHIFT)
#define  TIMEBASE2_REG_TCR_DISABLE10US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TCR_DISABLE10US_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TCR_DISABLE10US_SHIFT))

#define  TIMEBASE2_REG_TCR_DISABLE1US_MASK 0x1000000
#define  TIMEBASE2_REG_TCR_DISABLE1US_SHIFT 24
#define  TIMEBASE2_REG_TCR_DISABLE1US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TCR_DISABLE1US_MASK) >> TIMEBASE2_REG_TCR_DISABLE1US_SHIFT)
#define  TIMEBASE2_REG_TCR_DISABLE1US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TCR_DISABLE1US_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TCR_DISABLE1US_SHIFT))

#define  TIMEBASE2_REG_TCR_RESERVED2_MASK 0xffff00
#define  TIMEBASE2_REG_TCR_RESERVED2_SHIFT 8
#define  TIMEBASE2_REG_TCR_RESERVED2_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TCR_RESERVED2_MASK) >> TIMEBASE2_REG_TCR_RESERVED2_SHIFT)
#define  TIMEBASE2_REG_TCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TCR_RESERVED2_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TCR_RESERVED2_SHIFT))

#define  TIMEBASE2_REG_TCR_SYSFREQ_MASK 0xff
#define  TIMEBASE2_REG_TCR_SYSFREQ_SHIFT 0
#define  TIMEBASE2_REG_TCR_SYSFREQ_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TCR_SYSFREQ_MASK) >> TIMEBASE2_REG_TCR_SYSFREQ_SHIFT)
#define  TIMEBASE2_REG_TCR_SYSFREQ_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TCR_SYSFREQ_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TCR_SYSFREQ_SHIFT))

//====================================================================
//Register: Timebase Testing Register (TTR)
/** \brief Writing to this register can force the respective timing outputs to be asserted for a single bus cycle, or will cause the respective timing outputs to pulse (one bus clock in width) continuously every other reference clock period. This is handy for writing ASIC test procedures to "speed up" the testing of slow real-time blocks, and to keep the test synchronized without having to explicitly count clock cycles.<BR>
     During testing, it is generally advisable to disable the normal tick outputs via the Timebase Configuration Register, and then force the desired timing sequence using this register. If the timebase is not disabled using the timebase configuration register, requesting a single tick will cause the count to increment by two.<BR>
     Requesting a single tick affects the count for higher timebases. Care should be taken when disabling the 1us timebase, because it can be required by other blocks. For example, DRAM or LCD refresh.*/
//====================================================================

#define  TIMEBASE2_REG_TTR_RESERVED1_MASK 0xc0000000
#define  TIMEBASE2_REG_TTR_RESERVED1_SHIFT 30
#define  TIMEBASE2_REG_TTR_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_RESERVED1_MASK) >> TIMEBASE2_REG_TTR_RESERVED1_SHIFT)
#define  TIMEBASE2_REG_TTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_RESERVED1_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_RESERVED1_SHIFT))

#define  TIMEBASE2_REG_TTR_FORCE100MS_MASK 0x20000000
#define  TIMEBASE2_REG_TTR_FORCE100MS_SHIFT 29
#define  TIMEBASE2_REG_TTR_FORCE100MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_FORCE100MS_MASK) >> TIMEBASE2_REG_TTR_FORCE100MS_SHIFT)
#define  TIMEBASE2_REG_TTR_FORCE100MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_FORCE100MS_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_FORCE100MS_SHIFT))

#define  TIMEBASE2_REG_TTR_FORCE10MS_MASK 0x10000000
#define  TIMEBASE2_REG_TTR_FORCE10MS_SHIFT 28
#define  TIMEBASE2_REG_TTR_FORCE10MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_FORCE10MS_MASK) >> TIMEBASE2_REG_TTR_FORCE10MS_SHIFT)
#define  TIMEBASE2_REG_TTR_FORCE10MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_FORCE10MS_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_FORCE10MS_SHIFT))

#define  TIMEBASE2_REG_TTR_FORCE1MS_MASK 0x8000000
#define  TIMEBASE2_REG_TTR_FORCE1MS_SHIFT 27
#define  TIMEBASE2_REG_TTR_FORCE1MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_FORCE1MS_MASK) >> TIMEBASE2_REG_TTR_FORCE1MS_SHIFT)
#define  TIMEBASE2_REG_TTR_FORCE1MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_FORCE1MS_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_FORCE1MS_SHIFT))

#define  TIMEBASE2_REG_TTR_FORCE100US_MASK 0x4000000
#define  TIMEBASE2_REG_TTR_FORCE100US_SHIFT 26
#define  TIMEBASE2_REG_TTR_FORCE100US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_FORCE100US_MASK) >> TIMEBASE2_REG_TTR_FORCE100US_SHIFT)
#define  TIMEBASE2_REG_TTR_FORCE100US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_FORCE100US_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_FORCE100US_SHIFT))

#define  TIMEBASE2_REG_TTR_FORCE10US_MASK 0x2000000
#define  TIMEBASE2_REG_TTR_FORCE10US_SHIFT 25
#define  TIMEBASE2_REG_TTR_FORCE10US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_FORCE10US_MASK) >> TIMEBASE2_REG_TTR_FORCE10US_SHIFT)
#define  TIMEBASE2_REG_TTR_FORCE10US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_FORCE10US_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_FORCE10US_SHIFT))

#define  TIMEBASE2_REG_TTR_FORCE1US_MASK 0x1000000
#define  TIMEBASE2_REG_TTR_FORCE1US_SHIFT 24
#define  TIMEBASE2_REG_TTR_FORCE1US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_FORCE1US_MASK) >> TIMEBASE2_REG_TTR_FORCE1US_SHIFT)
#define  TIMEBASE2_REG_TTR_FORCE1US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_FORCE1US_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_FORCE1US_SHIFT))

#define  TIMEBASE2_REG_TTR_RESERVED2_MASK 0xc00000
#define  TIMEBASE2_REG_TTR_RESERVED2_SHIFT 22
#define  TIMEBASE2_REG_TTR_RESERVED2_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_RESERVED2_MASK) >> TIMEBASE2_REG_TTR_RESERVED2_SHIFT)
#define  TIMEBASE2_REG_TTR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_RESERVED2_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_RESERVED2_SHIFT))

#define  TIMEBASE2_REG_TTR_CONT100MS_MASK 0x200000
#define  TIMEBASE2_REG_TTR_CONT100MS_SHIFT 21
#define  TIMEBASE2_REG_TTR_CONT100MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_CONT100MS_MASK) >> TIMEBASE2_REG_TTR_CONT100MS_SHIFT)
#define  TIMEBASE2_REG_TTR_CONT100MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_CONT100MS_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_CONT100MS_SHIFT))

#define  TIMEBASE2_REG_TTR_CONT10MS_MASK 0x100000
#define  TIMEBASE2_REG_TTR_CONT10MS_SHIFT 20
#define  TIMEBASE2_REG_TTR_CONT10MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_CONT10MS_MASK) >> TIMEBASE2_REG_TTR_CONT10MS_SHIFT)
#define  TIMEBASE2_REG_TTR_CONT10MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_CONT10MS_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_CONT10MS_SHIFT))

#define  TIMEBASE2_REG_TTR_CONT1MS_MASK 0x80000
#define  TIMEBASE2_REG_TTR_CONT1MS_SHIFT 19
#define  TIMEBASE2_REG_TTR_CONT1MS_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_CONT1MS_MASK) >> TIMEBASE2_REG_TTR_CONT1MS_SHIFT)
#define  TIMEBASE2_REG_TTR_CONT1MS_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_CONT1MS_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_CONT1MS_SHIFT))

#define  TIMEBASE2_REG_TTR_CONT100US_MASK 0x40000
#define  TIMEBASE2_REG_TTR_CONT100US_SHIFT 18
#define  TIMEBASE2_REG_TTR_CONT100US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_CONT100US_MASK) >> TIMEBASE2_REG_TTR_CONT100US_SHIFT)
#define  TIMEBASE2_REG_TTR_CONT100US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_CONT100US_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_CONT100US_SHIFT))

#define  TIMEBASE2_REG_TTR_CONT10US_MASK 0x20000
#define  TIMEBASE2_REG_TTR_CONT10US_SHIFT 17
#define  TIMEBASE2_REG_TTR_CONT10US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_CONT10US_MASK) >> TIMEBASE2_REG_TTR_CONT10US_SHIFT)
#define  TIMEBASE2_REG_TTR_CONT10US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_CONT10US_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_CONT10US_SHIFT))

#define  TIMEBASE2_REG_TTR_CONT1US_MASK 0x10000
#define  TIMEBASE2_REG_TTR_CONT1US_SHIFT 16
#define  TIMEBASE2_REG_TTR_CONT1US_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_CONT1US_MASK) >> TIMEBASE2_REG_TTR_CONT1US_SHIFT)
#define  TIMEBASE2_REG_TTR_CONT1US_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_CONT1US_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_CONT1US_SHIFT))

#define  TIMEBASE2_REG_TTR_RESERVED3_MASK 0xffff
#define  TIMEBASE2_REG_TTR_RESERVED3_SHIFT 0
#define  TIMEBASE2_REG_TTR_RESERVED3_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_TTR_RESERVED3_MASK) >> TIMEBASE2_REG_TTR_RESERVED3_SHIFT)
#define  TIMEBASE2_REG_TTR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_TTR_RESERVED3_MASK) | (((uint32_t)val) << TIMEBASE2_REG_TTR_RESERVED3_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  TIMEBASE2_REG_REV0_MAJ_MASK 0xffff0000
#define  TIMEBASE2_REG_REV0_MAJ_SHIFT 16
#define  TIMEBASE2_REG_REV0_MAJ_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_REV0_MAJ_MASK) >> TIMEBASE2_REG_REV0_MAJ_SHIFT)
#define  TIMEBASE2_REG_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_REV0_MAJ_MASK) | (((uint32_t)val) << TIMEBASE2_REG_REV0_MAJ_SHIFT))

#define  TIMEBASE2_REG_REV0_MID_MASK 0xffff
#define  TIMEBASE2_REG_REV0_MID_SHIFT 0
#define  TIMEBASE2_REG_REV0_MID_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_REV0_MID_MASK) >> TIMEBASE2_REG_REV0_MID_SHIFT)
#define  TIMEBASE2_REG_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_REV0_MID_MASK) | (((uint32_t)val) << TIMEBASE2_REG_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  TIMEBASE2_REG_REV1_RESERVED1_MASK 0xffff0000
#define  TIMEBASE2_REG_REV1_RESERVED1_SHIFT 16
#define  TIMEBASE2_REG_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_REV1_RESERVED1_MASK) >> TIMEBASE2_REG_REV1_RESERVED1_SHIFT)
#define  TIMEBASE2_REG_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_REV1_RESERVED1_MASK) | (((uint32_t)val) << TIMEBASE2_REG_REV1_RESERVED1_SHIFT))

#define  TIMEBASE2_REG_REV1_CFG_MASK 0xffff
#define  TIMEBASE2_REG_REV1_CFG_SHIFT 0
#define  TIMEBASE2_REG_REV1_CFG_MASK_SHIFT(reg) (((reg) & TIMEBASE2_REG_REV1_CFG_MASK) >> TIMEBASE2_REG_REV1_CFG_SHIFT)
#define  TIMEBASE2_REG_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~TIMEBASE2_REG_REV1_CFG_MASK) | (((uint32_t)val) << TIMEBASE2_REG_REV1_CFG_SHIFT))

#endif // TIMEBASE2_REG
