 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file TEMS_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _TEMS_REGMASKS_H_
#define _TEMS_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: TEMS (TEMS)
/** \brief Register descriptions for the TEMS registers.*/
//
//====================================================================

//====================================================================
//Register: Configuration Register (CR)
/** \brief This register configures the major modes of the TEMS block.*/
//====================================================================

#define  TEMS_CR_RESERVED1_MASK 0xffffffc0
#define  TEMS_CR_RESERVED1_SHIFT 6
#define  TEMS_CR_RESERVED1_MASK_SHIFT(reg) (((reg) & TEMS_CR_RESERVED1_MASK) >> TEMS_CR_RESERVED1_SHIFT)
#define  TEMS_CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TEMS_CR_RESERVED1_MASK) | (((uint32_t)val) << TEMS_CR_RESERVED1_SHIFT))

#define  TEMS_CR_SERP_START_DIR_MASK 0x20
#define  TEMS_CR_SERP_START_DIR_SHIFT 5
#define  TEMS_CR_SERP_START_DIR_MASK_SHIFT(reg) (((reg) & TEMS_CR_SERP_START_DIR_MASK) >> TEMS_CR_SERP_START_DIR_SHIFT)
#define  TEMS_CR_SERP_START_DIR_REPLACE_VAL(reg,val) (((reg) & ~TEMS_CR_SERP_START_DIR_MASK) | (((uint32_t)val) << TEMS_CR_SERP_START_DIR_SHIFT))

#define  TEMS_CR_SERPENTINE_DATA_MASK 0x10
#define  TEMS_CR_SERPENTINE_DATA_SHIFT 4
#define  TEMS_CR_SERPENTINE_DATA_MASK_SHIFT(reg) (((reg) & TEMS_CR_SERPENTINE_DATA_MASK) >> TEMS_CR_SERPENTINE_DATA_SHIFT)
#define  TEMS_CR_SERPENTINE_DATA_REPLACE_VAL(reg,val) (((reg) & ~TEMS_CR_SERPENTINE_DATA_MASK) | (((uint32_t)val) << TEMS_CR_SERPENTINE_DATA_SHIFT))

#define  TEMS_CR_RESERVED2_MASK 0xc
#define  TEMS_CR_RESERVED2_SHIFT 2
#define  TEMS_CR_RESERVED2_MASK_SHIFT(reg) (((reg) & TEMS_CR_RESERVED2_MASK) >> TEMS_CR_RESERVED2_SHIFT)
#define  TEMS_CR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TEMS_CR_RESERVED2_MASK) | (((uint32_t)val) << TEMS_CR_RESERVED2_SHIFT))

#define  TEMS_CR_SAVE_RESTORE_MODE_MASK 0x2
#define  TEMS_CR_SAVE_RESTORE_MODE_SHIFT 1
#define  TEMS_CR_SAVE_RESTORE_MODE_MASK_SHIFT(reg) (((reg) & TEMS_CR_SAVE_RESTORE_MODE_MASK) >> TEMS_CR_SAVE_RESTORE_MODE_SHIFT)
#define  TEMS_CR_SAVE_RESTORE_MODE_REPLACE_VAL(reg,val) (((reg) & ~TEMS_CR_SAVE_RESTORE_MODE_MASK) | (((uint32_t)val) << TEMS_CR_SAVE_RESTORE_MODE_SHIFT))

#define  TEMS_CR_BYPASS_MASK 0x1
#define  TEMS_CR_BYPASS_SHIFT 0
#define  TEMS_CR_BYPASS_MASK_SHIFT(reg) (((reg) & TEMS_CR_BYPASS_MASK) >> TEMS_CR_BYPASS_SHIFT)
#define  TEMS_CR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~TEMS_CR_BYPASS_MASK) | (((uint32_t)val) << TEMS_CR_BYPASS_SHIFT))

//====================================================================
//Register: Text Register (TEXT)
/** \brief Configures the text expand and merge functions of TEMS.*/
//====================================================================

#define  TEMS_TEXT_RESERVED1_MASK 0xfc000000
#define  TEMS_TEXT_RESERVED1_SHIFT 26
#define  TEMS_TEXT_RESERVED1_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_RESERVED1_MASK) >> TEMS_TEXT_RESERVED1_SHIFT)
#define  TEMS_TEXT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_RESERVED1_MASK) | (((uint32_t)val) << TEMS_TEXT_RESERVED1_SHIFT))

#define  TEMS_TEXT_REPLACE_VAL_MASK 0x3ff0000
#define  TEMS_TEXT_REPLACE_VAL_SHIFT 16
#define  TEMS_TEXT_REPLACE_VAL_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_REPLACE_VAL_MASK) >> TEMS_TEXT_REPLACE_VAL_SHIFT)
#define  TEMS_TEXT_REPLACE_VAL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_REPLACE_VAL_MASK) | (((uint32_t)val) << TEMS_TEXT_REPLACE_VAL_SHIFT))

#define  TEMS_TEXT_TEXT_BIT3_SEL_MASK 0xc000
#define  TEMS_TEXT_TEXT_BIT3_SEL_SHIFT 14
#define  TEMS_TEXT_TEXT_BIT3_SEL_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_TEXT_BIT3_SEL_MASK) >> TEMS_TEXT_TEXT_BIT3_SEL_SHIFT)
#define  TEMS_TEXT_TEXT_BIT3_SEL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_TEXT_BIT3_SEL_MASK) | (((uint32_t)val) << TEMS_TEXT_TEXT_BIT3_SEL_SHIFT))

#define  TEMS_TEXT_TEXT_BIT2_SEL_MASK 0x3000
#define  TEMS_TEXT_TEXT_BIT2_SEL_SHIFT 12
#define  TEMS_TEXT_TEXT_BIT2_SEL_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_TEXT_BIT2_SEL_MASK) >> TEMS_TEXT_TEXT_BIT2_SEL_SHIFT)
#define  TEMS_TEXT_TEXT_BIT2_SEL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_TEXT_BIT2_SEL_MASK) | (((uint32_t)val) << TEMS_TEXT_TEXT_BIT2_SEL_SHIFT))

#define  TEMS_TEXT_TEXT_BIT1_SEL_MASK 0xc00
#define  TEMS_TEXT_TEXT_BIT1_SEL_SHIFT 10
#define  TEMS_TEXT_TEXT_BIT1_SEL_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_TEXT_BIT1_SEL_MASK) >> TEMS_TEXT_TEXT_BIT1_SEL_SHIFT)
#define  TEMS_TEXT_TEXT_BIT1_SEL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_TEXT_BIT1_SEL_MASK) | (((uint32_t)val) << TEMS_TEXT_TEXT_BIT1_SEL_SHIFT))

#define  TEMS_TEXT_TEXT_BIT0_SEL_MASK 0x300
#define  TEMS_TEXT_TEXT_BIT0_SEL_SHIFT 8
#define  TEMS_TEXT_TEXT_BIT0_SEL_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_TEXT_BIT0_SEL_MASK) >> TEMS_TEXT_TEXT_BIT0_SEL_SHIFT)
#define  TEMS_TEXT_TEXT_BIT0_SEL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_TEXT_BIT0_SEL_MASK) | (((uint32_t)val) << TEMS_TEXT_TEXT_BIT0_SEL_SHIFT))

#define  TEMS_TEXT_RESERVED2_MASK 0xc0
#define  TEMS_TEXT_RESERVED2_SHIFT 6
#define  TEMS_TEXT_RESERVED2_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_RESERVED2_MASK) >> TEMS_TEXT_RESERVED2_SHIFT)
#define  TEMS_TEXT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_RESERVED2_MASK) | (((uint32_t)val) << TEMS_TEXT_RESERVED2_SHIFT))

#define  TEMS_TEXT_TEXT_RES_MASK 0x30
#define  TEMS_TEXT_TEXT_RES_SHIFT 4
#define  TEMS_TEXT_TEXT_RES_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_TEXT_RES_MASK) >> TEMS_TEXT_TEXT_RES_SHIFT)
#define  TEMS_TEXT_TEXT_RES_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_TEXT_RES_MASK) | (((uint32_t)val) << TEMS_TEXT_TEXT_RES_SHIFT))

#define  TEMS_TEXT_RESERVED3_MASK 0xc
#define  TEMS_TEXT_RESERVED3_SHIFT 2
#define  TEMS_TEXT_RESERVED3_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_RESERVED3_MASK) >> TEMS_TEXT_RESERVED3_SHIFT)
#define  TEMS_TEXT_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_RESERVED3_MASK) | (((uint32_t)val) << TEMS_TEXT_RESERVED3_SHIFT))

#define  TEMS_TEXT_OVERRIDE_FUNC_MASK 0x2
#define  TEMS_TEXT_OVERRIDE_FUNC_SHIFT 1
#define  TEMS_TEXT_OVERRIDE_FUNC_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_OVERRIDE_FUNC_MASK) >> TEMS_TEXT_OVERRIDE_FUNC_SHIFT)
#define  TEMS_TEXT_OVERRIDE_FUNC_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_OVERRIDE_FUNC_MASK) | (((uint32_t)val) << TEMS_TEXT_OVERRIDE_FUNC_SHIFT))

#define  TEMS_TEXT_TEXT_ENABLE_MASK 0x1
#define  TEMS_TEXT_TEXT_ENABLE_SHIFT 0
#define  TEMS_TEXT_TEXT_ENABLE_MASK_SHIFT(reg) (((reg) & TEMS_TEXT_TEXT_ENABLE_MASK) >> TEMS_TEXT_TEXT_ENABLE_SHIFT)
#define  TEMS_TEXT_TEXT_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~TEMS_TEXT_TEXT_ENABLE_MASK) | (((uint32_t)val) << TEMS_TEXT_TEXT_ENABLE_SHIFT))

//====================================================================
//Register: Clear Register (CLEAR)
/** \brief Configures the Contone Clear operation.*/
//====================================================================

#define  TEMS_CLEAR_RESERVED1_MASK 0xffffe000
#define  TEMS_CLEAR_RESERVED1_SHIFT 13
#define  TEMS_CLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & TEMS_CLEAR_RESERVED1_MASK) >> TEMS_CLEAR_RESERVED1_SHIFT)
#define  TEMS_CLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TEMS_CLEAR_RESERVED1_MASK) | (((uint32_t)val) << TEMS_CLEAR_RESERVED1_SHIFT))

#define  TEMS_CLEAR_CLEAR_1_3_MASK 0x1f00
#define  TEMS_CLEAR_CLEAR_1_3_SHIFT 8
#define  TEMS_CLEAR_CLEAR_1_3_MASK_SHIFT(reg) (((reg) & TEMS_CLEAR_CLEAR_1_3_MASK) >> TEMS_CLEAR_CLEAR_1_3_SHIFT)
#define  TEMS_CLEAR_CLEAR_1_3_REPLACE_VAL(reg,val) (((reg) & ~TEMS_CLEAR_CLEAR_1_3_MASK) | (((uint32_t)val) << TEMS_CLEAR_CLEAR_1_3_SHIFT))

#define  TEMS_CLEAR_RESERVED2_MASK 0xe0
#define  TEMS_CLEAR_RESERVED2_SHIFT 5
#define  TEMS_CLEAR_RESERVED2_MASK_SHIFT(reg) (((reg) & TEMS_CLEAR_RESERVED2_MASK) >> TEMS_CLEAR_RESERVED2_SHIFT)
#define  TEMS_CLEAR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TEMS_CLEAR_RESERVED2_MASK) | (((uint32_t)val) << TEMS_CLEAR_RESERVED2_SHIFT))

#define  TEMS_CLEAR_CLEAR_4_MASK 0x1f
#define  TEMS_CLEAR_CLEAR_4_SHIFT 0
#define  TEMS_CLEAR_CLEAR_4_MASK_SHIFT(reg) (((reg) & TEMS_CLEAR_CLEAR_4_MASK) >> TEMS_CLEAR_CLEAR_4_SHIFT)
#define  TEMS_CLEAR_CLEAR_4_REPLACE_VAL(reg,val) (((reg) & ~TEMS_CLEAR_CLEAR_4_MASK) | (((uint32_t)val) << TEMS_CLEAR_CLEAR_4_SHIFT))

//====================================================================
//Register: Scale Register (SCALE)
/** \brief Configures the Up-Scaling operation.*/
//====================================================================

#define  TEMS_SCALE_RESERVED1_MASK 0xffffe000
#define  TEMS_SCALE_RESERVED1_SHIFT 13
#define  TEMS_SCALE_RESERVED1_MASK_SHIFT(reg) (((reg) & TEMS_SCALE_RESERVED1_MASK) >> TEMS_SCALE_RESERVED1_SHIFT)
#define  TEMS_SCALE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TEMS_SCALE_RESERVED1_MASK) | (((uint32_t)val) << TEMS_SCALE_RESERVED1_SHIFT))

#define  TEMS_SCALE_VSCALE_M1_MASK 0x1f00
#define  TEMS_SCALE_VSCALE_M1_SHIFT 8
#define  TEMS_SCALE_VSCALE_M1_MASK_SHIFT(reg) (((reg) & TEMS_SCALE_VSCALE_M1_MASK) >> TEMS_SCALE_VSCALE_M1_SHIFT)
#define  TEMS_SCALE_VSCALE_M1_REPLACE_VAL(reg,val) (((reg) & ~TEMS_SCALE_VSCALE_M1_MASK) | (((uint32_t)val) << TEMS_SCALE_VSCALE_M1_SHIFT))

#define  TEMS_SCALE_RESERVED2_MASK 0xe0
#define  TEMS_SCALE_RESERVED2_SHIFT 5
#define  TEMS_SCALE_RESERVED2_MASK_SHIFT(reg) (((reg) & TEMS_SCALE_RESERVED2_MASK) >> TEMS_SCALE_RESERVED2_SHIFT)
#define  TEMS_SCALE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TEMS_SCALE_RESERVED2_MASK) | (((uint32_t)val) << TEMS_SCALE_RESERVED2_SHIFT))

#define  TEMS_SCALE_HSCALE_M1_MASK 0x1f
#define  TEMS_SCALE_HSCALE_M1_SHIFT 0
#define  TEMS_SCALE_HSCALE_M1_MASK_SHIFT(reg) (((reg) & TEMS_SCALE_HSCALE_M1_MASK) >> TEMS_SCALE_HSCALE_M1_SHIFT)
#define  TEMS_SCALE_HSCALE_M1_REPLACE_VAL(reg,val) (((reg) & ~TEMS_SCALE_HSCALE_M1_MASK) | (((uint32_t)val) << TEMS_SCALE_HSCALE_M1_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  TEMS_REV0_MAJ_MASK 0xffff0000
#define  TEMS_REV0_MAJ_SHIFT 16
#define  TEMS_REV0_MAJ_MASK_SHIFT(reg) (((reg) & TEMS_REV0_MAJ_MASK) >> TEMS_REV0_MAJ_SHIFT)
#define  TEMS_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~TEMS_REV0_MAJ_MASK) | (((uint32_t)val) << TEMS_REV0_MAJ_SHIFT))

#define  TEMS_REV0_MID_MASK 0xffff
#define  TEMS_REV0_MID_SHIFT 0
#define  TEMS_REV0_MID_MASK_SHIFT(reg) (((reg) & TEMS_REV0_MID_MASK) >> TEMS_REV0_MID_SHIFT)
#define  TEMS_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~TEMS_REV0_MID_MASK) | (((uint32_t)val) << TEMS_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  TEMS_REV1_RESERVED1_MASK 0xffff0000
#define  TEMS_REV1_RESERVED1_SHIFT 16
#define  TEMS_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & TEMS_REV1_RESERVED1_MASK) >> TEMS_REV1_RESERVED1_SHIFT)
#define  TEMS_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TEMS_REV1_RESERVED1_MASK) | (((uint32_t)val) << TEMS_REV1_RESERVED1_SHIFT))

#define  TEMS_REV1_CFG_MASK 0xffff
#define  TEMS_REV1_CFG_SHIFT 0
#define  TEMS_REV1_CFG_MASK_SHIFT(reg) (((reg) & TEMS_REV1_CFG_MASK) >> TEMS_REV1_CFG_SHIFT)
#define  TEMS_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~TEMS_REV1_CFG_MASK) | (((uint32_t)val) << TEMS_REV1_CFG_SHIFT))

//====================================================================
//Register: Save Restore Register (Instance 1 of 6) (SRR0)
/** \brief This register is used to save and restore the needed internal states of TEMS. (Instance 1 of 6)*/
//====================================================================

#define  TEMS_SRR0_STATEVAL_MASK 0xffffffff
#define  TEMS_SRR0_STATEVAL_SHIFT 0
#define  TEMS_SRR0_STATEVAL_MASK_SHIFT(reg) (((reg) & TEMS_SRR0_STATEVAL_MASK) >> TEMS_SRR0_STATEVAL_SHIFT)
#define  TEMS_SRR0_STATEVAL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_SRR0_STATEVAL_MASK) | (((uint32_t)val) << TEMS_SRR0_STATEVAL_SHIFT))

//====================================================================
//Register: Save Restore Register (Instance 2 of 6) (SRR1)
/** \brief This register is used to save and restore the needed internal states of TEMS. (Instance 2 of 6)*/
//====================================================================

#define  TEMS_SRR1_STATEVAL_MASK 0xffffffff
#define  TEMS_SRR1_STATEVAL_SHIFT 0
#define  TEMS_SRR1_STATEVAL_MASK_SHIFT(reg) (((reg) & TEMS_SRR1_STATEVAL_MASK) >> TEMS_SRR1_STATEVAL_SHIFT)
#define  TEMS_SRR1_STATEVAL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_SRR1_STATEVAL_MASK) | (((uint32_t)val) << TEMS_SRR1_STATEVAL_SHIFT))

//====================================================================
//Register: Save Restore Register (Instance 3 of 6) (SRR2)
/** \brief This register is used to save and restore the needed internal states of TEMS. (Instance 3 of 6)*/
//====================================================================

#define  TEMS_SRR2_STATEVAL_MASK 0xffffffff
#define  TEMS_SRR2_STATEVAL_SHIFT 0
#define  TEMS_SRR2_STATEVAL_MASK_SHIFT(reg) (((reg) & TEMS_SRR2_STATEVAL_MASK) >> TEMS_SRR2_STATEVAL_SHIFT)
#define  TEMS_SRR2_STATEVAL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_SRR2_STATEVAL_MASK) | (((uint32_t)val) << TEMS_SRR2_STATEVAL_SHIFT))

//====================================================================
//Register: Save Restore Register (Instance 4 of 6) (SRR3)
/** \brief This register is used to save and restore the needed internal states of TEMS. (Instance 4 of 6)*/
//====================================================================

#define  TEMS_SRR3_STATEVAL_MASK 0xffffffff
#define  TEMS_SRR3_STATEVAL_SHIFT 0
#define  TEMS_SRR3_STATEVAL_MASK_SHIFT(reg) (((reg) & TEMS_SRR3_STATEVAL_MASK) >> TEMS_SRR3_STATEVAL_SHIFT)
#define  TEMS_SRR3_STATEVAL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_SRR3_STATEVAL_MASK) | (((uint32_t)val) << TEMS_SRR3_STATEVAL_SHIFT))

//====================================================================
//Register: Save Restore Register (Instance 5 of 6) (SRR4)
/** \brief This register is used to save and restore the needed internal states of TEMS. (Instance 5 of 6)*/
//====================================================================

#define  TEMS_SRR4_STATEVAL_MASK 0xffffffff
#define  TEMS_SRR4_STATEVAL_SHIFT 0
#define  TEMS_SRR4_STATEVAL_MASK_SHIFT(reg) (((reg) & TEMS_SRR4_STATEVAL_MASK) >> TEMS_SRR4_STATEVAL_SHIFT)
#define  TEMS_SRR4_STATEVAL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_SRR4_STATEVAL_MASK) | (((uint32_t)val) << TEMS_SRR4_STATEVAL_SHIFT))

//====================================================================
//Register: Save Restore Register (Instance 6 of 6) (SRR5)
/** \brief This register is used to save and restore the needed internal states of TEMS. (Instance 6 of 6)*/
//====================================================================

#define  TEMS_SRR5_STATEVAL_MASK 0xffffffff
#define  TEMS_SRR5_STATEVAL_SHIFT 0
#define  TEMS_SRR5_STATEVAL_MASK_SHIFT(reg) (((reg) & TEMS_SRR5_STATEVAL_MASK) >> TEMS_SRR5_STATEVAL_SHIFT)
#define  TEMS_SRR5_STATEVAL_REPLACE_VAL(reg,val) (((reg) & ~TEMS_SRR5_STATEVAL_MASK) | (((uint32_t)val) << TEMS_SRR5_STATEVAL_SHIFT))

#endif // TEMS
