 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file ScCSC_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SCCSC_REGMASKS_H_
#define _SCCSC_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SubCube Color Space Conversion (ScCSC)
/** \brief Top-level register file for ScCSC*/
//
//====================================================================

//====================================================================
//Register: ScCSC STATUS REG (STATUS)
/** \brief ScCSC Status Register*/
//====================================================================

#define  SCCSC_STATUS_RESERVED1_MASK 0xffffff00
#define  SCCSC_STATUS_RESERVED1_SHIFT 8
#define  SCCSC_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_STATUS_RESERVED1_MASK) >> SCCSC_STATUS_RESERVED1_SHIFT)
#define  SCCSC_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_STATUS_RESERVED1_SHIFT))

#define  SCCSC_STATUS_DMABUSY7_MASK 0x80
#define  SCCSC_STATUS_DMABUSY7_SHIFT 7
#define  SCCSC_STATUS_DMABUSY7_MASK_SHIFT(reg) (((reg) & SCCSC_STATUS_DMABUSY7_MASK) >> SCCSC_STATUS_DMABUSY7_SHIFT)
#define  SCCSC_STATUS_DMABUSY7_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_STATUS_DMABUSY7_MASK) | (((uint32_t)val) << SCCSC_STATUS_DMABUSY7_SHIFT))

#define  SCCSC_STATUS_DMABUSY6_MASK 0x40
#define  SCCSC_STATUS_DMABUSY6_SHIFT 6
#define  SCCSC_STATUS_DMABUSY6_MASK_SHIFT(reg) (((reg) & SCCSC_STATUS_DMABUSY6_MASK) >> SCCSC_STATUS_DMABUSY6_SHIFT)
#define  SCCSC_STATUS_DMABUSY6_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_STATUS_DMABUSY6_MASK) | (((uint32_t)val) << SCCSC_STATUS_DMABUSY6_SHIFT))

#define  SCCSC_STATUS_DMABUSY5_MASK 0x20
#define  SCCSC_STATUS_DMABUSY5_SHIFT 5
#define  SCCSC_STATUS_DMABUSY5_MASK_SHIFT(reg) (((reg) & SCCSC_STATUS_DMABUSY5_MASK) >> SCCSC_STATUS_DMABUSY5_SHIFT)
#define  SCCSC_STATUS_DMABUSY5_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_STATUS_DMABUSY5_MASK) | (((uint32_t)val) << SCCSC_STATUS_DMABUSY5_SHIFT))

#define  SCCSC_STATUS_DMABUSY4_MASK 0x10
#define  SCCSC_STATUS_DMABUSY4_SHIFT 4
#define  SCCSC_STATUS_DMABUSY4_MASK_SHIFT(reg) (((reg) & SCCSC_STATUS_DMABUSY4_MASK) >> SCCSC_STATUS_DMABUSY4_SHIFT)
#define  SCCSC_STATUS_DMABUSY4_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_STATUS_DMABUSY4_MASK) | (((uint32_t)val) << SCCSC_STATUS_DMABUSY4_SHIFT))

#define  SCCSC_STATUS_DMABUSY3_MASK 0x8
#define  SCCSC_STATUS_DMABUSY3_SHIFT 3
#define  SCCSC_STATUS_DMABUSY3_MASK_SHIFT(reg) (((reg) & SCCSC_STATUS_DMABUSY3_MASK) >> SCCSC_STATUS_DMABUSY3_SHIFT)
#define  SCCSC_STATUS_DMABUSY3_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_STATUS_DMABUSY3_MASK) | (((uint32_t)val) << SCCSC_STATUS_DMABUSY3_SHIFT))

#define  SCCSC_STATUS_DMABUSY2_MASK 0x4
#define  SCCSC_STATUS_DMABUSY2_SHIFT 2
#define  SCCSC_STATUS_DMABUSY2_MASK_SHIFT(reg) (((reg) & SCCSC_STATUS_DMABUSY2_MASK) >> SCCSC_STATUS_DMABUSY2_SHIFT)
#define  SCCSC_STATUS_DMABUSY2_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_STATUS_DMABUSY2_MASK) | (((uint32_t)val) << SCCSC_STATUS_DMABUSY2_SHIFT))

#define  SCCSC_STATUS_DMABUSY1_MASK 0x2
#define  SCCSC_STATUS_DMABUSY1_SHIFT 1
#define  SCCSC_STATUS_DMABUSY1_MASK_SHIFT(reg) (((reg) & SCCSC_STATUS_DMABUSY1_MASK) >> SCCSC_STATUS_DMABUSY1_SHIFT)
#define  SCCSC_STATUS_DMABUSY1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_STATUS_DMABUSY1_MASK) | (((uint32_t)val) << SCCSC_STATUS_DMABUSY1_SHIFT))

#define  SCCSC_STATUS_DMABUSY0_MASK 0x1
#define  SCCSC_STATUS_DMABUSY0_SHIFT 0
#define  SCCSC_STATUS_DMABUSY0_MASK_SHIFT(reg) (((reg) & SCCSC_STATUS_DMABUSY0_MASK) >> SCCSC_STATUS_DMABUSY0_SHIFT)
#define  SCCSC_STATUS_DMABUSY0_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_STATUS_DMABUSY0_MASK) | (((uint32_t)val) << SCCSC_STATUS_DMABUSY0_SHIFT))

//====================================================================
//Register: ScCSC CONTROL REG (CNTRL)
/** \brief ScCSC Control Register*/
//====================================================================

#define  SCCSC_CNTRL_BYPASSALL_MASK 0x80000000
#define  SCCSC_CNTRL_BYPASSALL_SHIFT 31
#define  SCCSC_CNTRL_BYPASSALL_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_BYPASSALL_MASK) >> SCCSC_CNTRL_BYPASSALL_SHIFT)
#define  SCCSC_CNTRL_BYPASSALL_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_BYPASSALL_MASK) | (((uint32_t)val) << SCCSC_CNTRL_BYPASSALL_SHIFT))

#define  SCCSC_CNTRL_RESERVED1_MASK 0x60000000
#define  SCCSC_CNTRL_RESERVED1_SHIFT 29
#define  SCCSC_CNTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_RESERVED1_MASK) >> SCCSC_CNTRL_RESERVED1_SHIFT)
#define  SCCSC_CNTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_CNTRL_RESERVED1_SHIFT))

#define  SCCSC_CNTRL_CPUACCESS_MASK 0x10000000
#define  SCCSC_CNTRL_CPUACCESS_SHIFT 28
#define  SCCSC_CNTRL_CPUACCESS_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_CPUACCESS_MASK) >> SCCSC_CNTRL_CPUACCESS_SHIFT)
#define  SCCSC_CNTRL_CPUACCESS_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_CPUACCESS_MASK) | (((uint32_t)val) << SCCSC_CNTRL_CPUACCESS_SHIFT))

#define  SCCSC_CNTRL_RESERVED2_MASK 0xe000000
#define  SCCSC_CNTRL_RESERVED2_SHIFT 25
#define  SCCSC_CNTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_RESERVED2_MASK) >> SCCSC_CNTRL_RESERVED2_SHIFT)
#define  SCCSC_CNTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_RESERVED2_MASK) | (((uint32_t)val) << SCCSC_CNTRL_RESERVED2_SHIFT))

#define  SCCSC_CNTRL_IALG_MASK 0x1000000
#define  SCCSC_CNTRL_IALG_SHIFT 24
#define  SCCSC_CNTRL_IALG_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_IALG_MASK) >> SCCSC_CNTRL_IALG_SHIFT)
#define  SCCSC_CNTRL_IALG_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_IALG_MASK) | (((uint32_t)val) << SCCSC_CNTRL_IALG_SHIFT))

#define  SCCSC_CNTRL_RESERVED3_MASK 0xc00000
#define  SCCSC_CNTRL_RESERVED3_SHIFT 22
#define  SCCSC_CNTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_RESERVED3_MASK) >> SCCSC_CNTRL_RESERVED3_SHIFT)
#define  SCCSC_CNTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_RESERVED3_MASK) | (((uint32_t)val) << SCCSC_CNTRL_RESERVED3_SHIFT))

#define  SCCSC_CNTRL_WME_MASK 0x200000
#define  SCCSC_CNTRL_WME_SHIFT 21
#define  SCCSC_CNTRL_WME_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_WME_MASK) >> SCCSC_CNTRL_WME_SHIFT)
#define  SCCSC_CNTRL_WME_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_WME_MASK) | (((uint32_t)val) << SCCSC_CNTRL_WME_SHIFT))

#define  SCCSC_CNTRL_KME_MASK 0x180000
#define  SCCSC_CNTRL_KME_SHIFT 19
#define  SCCSC_CNTRL_KME_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_KME_MASK) >> SCCSC_CNTRL_KME_SHIFT)
#define  SCCSC_CNTRL_KME_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_KME_MASK) | (((uint32_t)val) << SCCSC_CNTRL_KME_SHIFT))

#define  SCCSC_CNTRL_RESERVED4_MASK 0x40000
#define  SCCSC_CNTRL_RESERVED4_SHIFT 18
#define  SCCSC_CNTRL_RESERVED4_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_RESERVED4_MASK) >> SCCSC_CNTRL_RESERVED4_SHIFT)
#define  SCCSC_CNTRL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_RESERVED4_MASK) | (((uint32_t)val) << SCCSC_CNTRL_RESERVED4_SHIFT))

#define  SCCSC_CNTRL_LUTSEL_MASK 0x20000
#define  SCCSC_CNTRL_LUTSEL_SHIFT 17
#define  SCCSC_CNTRL_LUTSEL_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_LUTSEL_MASK) >> SCCSC_CNTRL_LUTSEL_SHIFT)
#define  SCCSC_CNTRL_LUTSEL_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_LUTSEL_MASK) | (((uint32_t)val) << SCCSC_CNTRL_LUTSEL_SHIFT))

#define  SCCSC_CNTRL_SBAND_EN_MASK 0x10000
#define  SCCSC_CNTRL_SBAND_EN_SHIFT 16
#define  SCCSC_CNTRL_SBAND_EN_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_SBAND_EN_MASK) >> SCCSC_CNTRL_SBAND_EN_SHIFT)
#define  SCCSC_CNTRL_SBAND_EN_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_SBAND_EN_MASK) | (((uint32_t)val) << SCCSC_CNTRL_SBAND_EN_SHIFT))

#define  SCCSC_CNTRL_SBAND_VALUE_MASK 0xff00
#define  SCCSC_CNTRL_SBAND_VALUE_SHIFT 8
#define  SCCSC_CNTRL_SBAND_VALUE_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_SBAND_VALUE_MASK) >> SCCSC_CNTRL_SBAND_VALUE_SHIFT)
#define  SCCSC_CNTRL_SBAND_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_SBAND_VALUE_MASK) | (((uint32_t)val) << SCCSC_CNTRL_SBAND_VALUE_SHIFT))

#define  SCCSC_CNTRL_SBAND_MASK_MASK 0xff
#define  SCCSC_CNTRL_SBAND_MASK_SHIFT 0
#define  SCCSC_CNTRL_SBAND_MASK_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_SBAND_MASK_MASK) >> SCCSC_CNTRL_SBAND_MASK_SHIFT)
#define  SCCSC_CNTRL_SBAND_MASK_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_SBAND_MASK_MASK) | (((uint32_t)val) << SCCSC_CNTRL_SBAND_MASK_SHIFT))

//====================================================================
//Register: Cache Miss Counters Clear (MCClr)
/** \brief Write only register for clearing the Cache Pixel and Index Miss counters*/
//====================================================================

#define  SCCSC_MCCLR_RESERVED1_MASK 0xfffffffe
#define  SCCSC_MCCLR_RESERVED1_SHIFT 1
#define  SCCSC_MCCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_MCCLR_RESERVED1_MASK) >> SCCSC_MCCLR_RESERVED1_SHIFT)
#define  SCCSC_MCCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_MCCLR_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_MCCLR_RESERVED1_SHIFT))

#define  SCCSC_MCCLR_CLR_MASK 0x1
#define  SCCSC_MCCLR_CLR_SHIFT 0
#define  SCCSC_MCCLR_CLR_MASK_SHIFT(reg) (((reg) & SCCSC_MCCLR_CLR_MASK) >> SCCSC_MCCLR_CLR_SHIFT)
#define  SCCSC_MCCLR_CLR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_MCCLR_CLR_MASK) | (((uint32_t)val) << SCCSC_MCCLR_CLR_SHIFT))

//====================================================================
//Register: Cache Latency Counter Clear (LCClr)
/** \brief Write only register for clearing the Cache Latency counter.*/
//====================================================================

#define  SCCSC_LCCLR_RESERVED1_MASK 0xfffffffe
#define  SCCSC_LCCLR_RESERVED1_SHIFT 1
#define  SCCSC_LCCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_LCCLR_RESERVED1_MASK) >> SCCSC_LCCLR_RESERVED1_SHIFT)
#define  SCCSC_LCCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_LCCLR_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_LCCLR_RESERVED1_SHIFT))

#define  SCCSC_LCCLR_CLR_MASK 0x1
#define  SCCSC_LCCLR_CLR_SHIFT 0
#define  SCCSC_LCCLR_CLR_MASK_SHIFT(reg) (((reg) & SCCSC_LCCLR_CLR_MASK) >> SCCSC_LCCLR_CLR_SHIFT)
#define  SCCSC_LCCLR_CLR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_LCCLR_CLR_MASK) | (((uint32_t)val) << SCCSC_LCCLR_CLR_SHIFT))

//====================================================================
//Register: INVALIDATE All Caches Register (CACHE_INVLD)
/** \brief Write only register that invalidates all Cache tags.*/
//====================================================================

#define  SCCSC_CACHE_INVLD_RESERVED1_MASK 0xfffffffe
#define  SCCSC_CACHE_INVLD_RESERVED1_SHIFT 1
#define  SCCSC_CACHE_INVLD_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_INVLD_RESERVED1_MASK) >> SCCSC_CACHE_INVLD_RESERVED1_SHIFT)
#define  SCCSC_CACHE_INVLD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_INVLD_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_CACHE_INVLD_RESERVED1_SHIFT))

#define  SCCSC_CACHE_INVLD_INVLD_MASK 0x1
#define  SCCSC_CACHE_INVLD_INVLD_SHIFT 0
#define  SCCSC_CACHE_INVLD_INVLD_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_INVLD_INVLD_MASK) >> SCCSC_CACHE_INVLD_INVLD_SHIFT)
#define  SCCSC_CACHE_INVLD_INVLD_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_INVLD_INVLD_MASK) | (((uint32_t)val) << SCCSC_CACHE_INVLD_INVLD_SHIFT))

//====================================================================
//Register: Cache Control Register (CACHE_CNTRL)
/** \brief Caching Control Functions*/
//====================================================================

#define  SCCSC_CACHE_CNTRL_RESERVED1_MASK 0xffe00000
#define  SCCSC_CACHE_CNTRL_RESERVED1_SHIFT 21
#define  SCCSC_CACHE_CNTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_CNTRL_RESERVED1_MASK) >> SCCSC_CACHE_CNTRL_RESERVED1_SHIFT)
#define  SCCSC_CACHE_CNTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_CNTRL_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_CACHE_CNTRL_RESERVED1_SHIFT))

#define  SCCSC_CACHE_CNTRL_LUTSIZE_MASK 0x100000
#define  SCCSC_CACHE_CNTRL_LUTSIZE_SHIFT 20
#define  SCCSC_CACHE_CNTRL_LUTSIZE_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_CNTRL_LUTSIZE_MASK) >> SCCSC_CACHE_CNTRL_LUTSIZE_SHIFT)
#define  SCCSC_CACHE_CNTRL_LUTSIZE_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_CNTRL_LUTSIZE_MASK) | (((uint32_t)val) << SCCSC_CACHE_CNTRL_LUTSIZE_SHIFT))

#define  SCCSC_CACHE_CNTRL_RESERVED2_MASK 0xe0000
#define  SCCSC_CACHE_CNTRL_RESERVED2_SHIFT 17
#define  SCCSC_CACHE_CNTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_CNTRL_RESERVED2_MASK) >> SCCSC_CACHE_CNTRL_RESERVED2_SHIFT)
#define  SCCSC_CACHE_CNTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_CNTRL_RESERVED2_MASK) | (((uint32_t)val) << SCCSC_CACHE_CNTRL_RESERVED2_SHIFT))

#define  SCCSC_CACHE_CNTRL_HC_MASK 0x10000
#define  SCCSC_CACHE_CNTRL_HC_SHIFT 16
#define  SCCSC_CACHE_CNTRL_HC_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_CNTRL_HC_MASK) >> SCCSC_CACHE_CNTRL_HC_SHIFT)
#define  SCCSC_CACHE_CNTRL_HC_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_CNTRL_HC_MASK) | (((uint32_t)val) << SCCSC_CACHE_CNTRL_HC_SHIFT))

#define  SCCSC_CACHE_CNTRL_RESERVED3_MASK 0xfe00
#define  SCCSC_CACHE_CNTRL_RESERVED3_SHIFT 9
#define  SCCSC_CACHE_CNTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_CNTRL_RESERVED3_MASK) >> SCCSC_CACHE_CNTRL_RESERVED3_SHIFT)
#define  SCCSC_CACHE_CNTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_CNTRL_RESERVED3_MASK) | (((uint32_t)val) << SCCSC_CACHE_CNTRL_RESERVED3_SHIFT))

#define  SCCSC_CACHE_CNTRL_MCE_MASK 0x100
#define  SCCSC_CACHE_CNTRL_MCE_SHIFT 8
#define  SCCSC_CACHE_CNTRL_MCE_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_CNTRL_MCE_MASK) >> SCCSC_CACHE_CNTRL_MCE_SHIFT)
#define  SCCSC_CACHE_CNTRL_MCE_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_CNTRL_MCE_MASK) | (((uint32_t)val) << SCCSC_CACHE_CNTRL_MCE_SHIFT))

#define  SCCSC_CACHE_CNTRL_RESERVED4_MASK 0xf0
#define  SCCSC_CACHE_CNTRL_RESERVED4_SHIFT 4
#define  SCCSC_CACHE_CNTRL_RESERVED4_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_CNTRL_RESERVED4_MASK) >> SCCSC_CACHE_CNTRL_RESERVED4_SHIFT)
#define  SCCSC_CACHE_CNTRL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_CNTRL_RESERVED4_MASK) | (((uint32_t)val) << SCCSC_CACHE_CNTRL_RESERVED4_SHIFT))

#define  SCCSC_CACHE_CNTRL_LCE_MASK 0x8
#define  SCCSC_CACHE_CNTRL_LCE_SHIFT 3
#define  SCCSC_CACHE_CNTRL_LCE_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_CNTRL_LCE_MASK) >> SCCSC_CACHE_CNTRL_LCE_SHIFT)
#define  SCCSC_CACHE_CNTRL_LCE_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_CNTRL_LCE_MASK) | (((uint32_t)val) << SCCSC_CACHE_CNTRL_LCE_SHIFT))

#define  SCCSC_CACHE_CNTRL_RESERVED5_MASK 0x7
#define  SCCSC_CACHE_CNTRL_RESERVED5_SHIFT 0
#define  SCCSC_CACHE_CNTRL_RESERVED5_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_CNTRL_RESERVED5_MASK) >> SCCSC_CACHE_CNTRL_RESERVED5_SHIFT)
#define  SCCSC_CACHE_CNTRL_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_CNTRL_RESERVED5_MASK) | (((uint32_t)val) << SCCSC_CACHE_CNTRL_RESERVED5_SHIFT))

//====================================================================
//Register: Cache Index Miss counter (IDX_MISS_COUNTER)
/** \brief Cache Index Miss count*/
//====================================================================

#define  SCCSC_IDX_MISS_COUNTER_CNT_MASK 0xffffffff
#define  SCCSC_IDX_MISS_COUNTER_CNT_SHIFT 0
#define  SCCSC_IDX_MISS_COUNTER_CNT_MASK_SHIFT(reg) (((reg) & SCCSC_IDX_MISS_COUNTER_CNT_MASK) >> SCCSC_IDX_MISS_COUNTER_CNT_SHIFT)
#define  SCCSC_IDX_MISS_COUNTER_CNT_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_IDX_MISS_COUNTER_CNT_MASK) | (((uint32_t)val) << SCCSC_IDX_MISS_COUNTER_CNT_SHIFT))

//====================================================================
//Register: Cache PIXEL Miss counter (PIXEL_MISS_COUNTER)
/** \brief Cache Pixel Miss count*/
//====================================================================

#define  SCCSC_PIXEL_MISS_COUNTER_CNT_MASK 0xffffffff
#define  SCCSC_PIXEL_MISS_COUNTER_CNT_SHIFT 0
#define  SCCSC_PIXEL_MISS_COUNTER_CNT_MASK_SHIFT(reg) (((reg) & SCCSC_PIXEL_MISS_COUNTER_CNT_MASK) >> SCCSC_PIXEL_MISS_COUNTER_CNT_SHIFT)
#define  SCCSC_PIXEL_MISS_COUNTER_CNT_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PIXEL_MISS_COUNTER_CNT_MASK) | (((uint32_t)val) << SCCSC_PIXEL_MISS_COUNTER_CNT_SHIFT))

//====================================================================
//Register: Cache Latency counter (LATENCY_COUNTER)
/** \brief Cache latency counter*/
//====================================================================

#define  SCCSC_LATENCY_COUNTER_CNT_MASK 0xffffffff
#define  SCCSC_LATENCY_COUNTER_CNT_SHIFT 0
#define  SCCSC_LATENCY_COUNTER_CNT_MASK_SHIFT(reg) (((reg) & SCCSC_LATENCY_COUNTER_CNT_MASK) >> SCCSC_LATENCY_COUNTER_CNT_SHIFT)
#define  SCCSC_LATENCY_COUNTER_CNT_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_LATENCY_COUNTER_CNT_MASK) | (((uint32_t)val) << SCCSC_LATENCY_COUNTER_CNT_SHIFT))

//====================================================================
//Register: Cached LUT Base Address (BASE_ADDR)
/** \brief Cached LUT Base Address in system memory*/
//====================================================================

#define  SCCSC_BASE_ADDR_ADDR_MASK 0xfffffff8
#define  SCCSC_BASE_ADDR_ADDR_SHIFT 3
#define  SCCSC_BASE_ADDR_ADDR_MASK_SHIFT(reg) (((reg) & SCCSC_BASE_ADDR_ADDR_MASK) >> SCCSC_BASE_ADDR_ADDR_SHIFT)
#define  SCCSC_BASE_ADDR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_BASE_ADDR_ADDR_MASK) | (((uint32_t)val) << SCCSC_BASE_ADDR_ADDR_SHIFT))

#define  SCCSC_BASE_ADDR_RESERVED1_MASK 0x7
#define  SCCSC_BASE_ADDR_RESERVED1_SHIFT 0
#define  SCCSC_BASE_ADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_BASE_ADDR_RESERVED1_MASK) >> SCCSC_BASE_ADDR_RESERVED1_SHIFT)
#define  SCCSC_BASE_ADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_BASE_ADDR_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_BASE_ADDR_RESERVED1_SHIFT))

//====================================================================
//Register: White Threshold settings (WT)
/** \brief Input White Threshold settings.
If white mapping is enabled (WME=1) and the incoming pixel exceeds all input channel White thresholds, the pre-defined WHITE RESPONSE (WR register) will be output.*/
//====================================================================

#define  SCCSC_WT_RESERVED1_MASK 0xc0000000
#define  SCCSC_WT_RESERVED1_SHIFT 30
#define  SCCSC_WT_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_WT_RESERVED1_MASK) >> SCCSC_WT_RESERVED1_SHIFT)
#define  SCCSC_WT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WT_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_WT_RESERVED1_SHIFT))

#define  SCCSC_WT_CH0_WT_MASK 0x3ff00000
#define  SCCSC_WT_CH0_WT_SHIFT 20
#define  SCCSC_WT_CH0_WT_MASK_SHIFT(reg) (((reg) & SCCSC_WT_CH0_WT_MASK) >> SCCSC_WT_CH0_WT_SHIFT)
#define  SCCSC_WT_CH0_WT_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WT_CH0_WT_MASK) | (((uint32_t)val) << SCCSC_WT_CH0_WT_SHIFT))

#define  SCCSC_WT_CH1_WT_MASK 0xffc00
#define  SCCSC_WT_CH1_WT_SHIFT 10
#define  SCCSC_WT_CH1_WT_MASK_SHIFT(reg) (((reg) & SCCSC_WT_CH1_WT_MASK) >> SCCSC_WT_CH1_WT_SHIFT)
#define  SCCSC_WT_CH1_WT_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WT_CH1_WT_MASK) | (((uint32_t)val) << SCCSC_WT_CH1_WT_SHIFT))

#define  SCCSC_WT_CH2_WT_MASK 0x3ff
#define  SCCSC_WT_CH2_WT_SHIFT 0
#define  SCCSC_WT_CH2_WT_MASK_SHIFT(reg) (((reg) & SCCSC_WT_CH2_WT_MASK) >> SCCSC_WT_CH2_WT_SHIFT)
#define  SCCSC_WT_CH2_WT_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WT_CH2_WT_MASK) | (((uint32_t)val) << SCCSC_WT_CH2_WT_SHIFT))

//====================================================================
//Register: White Response reg 0  (WR_REG0)
/** \brief White pixel response values for output channels 0 - 2.*/
//====================================================================

#define  SCCSC_WR_REG0_RESERVED1_MASK 0xc0000000
#define  SCCSC_WR_REG0_RESERVED1_SHIFT 30
#define  SCCSC_WR_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG0_RESERVED1_MASK) >> SCCSC_WR_REG0_RESERVED1_SHIFT)
#define  SCCSC_WR_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG0_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_WR_REG0_RESERVED1_SHIFT))

#define  SCCSC_WR_REG0_CH0_WR_MASK 0x3ff00000
#define  SCCSC_WR_REG0_CH0_WR_SHIFT 20
#define  SCCSC_WR_REG0_CH0_WR_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG0_CH0_WR_MASK) >> SCCSC_WR_REG0_CH0_WR_SHIFT)
#define  SCCSC_WR_REG0_CH0_WR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG0_CH0_WR_MASK) | (((uint32_t)val) << SCCSC_WR_REG0_CH0_WR_SHIFT))

#define  SCCSC_WR_REG0_CH1_WR_MASK 0xffc00
#define  SCCSC_WR_REG0_CH1_WR_SHIFT 10
#define  SCCSC_WR_REG0_CH1_WR_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG0_CH1_WR_MASK) >> SCCSC_WR_REG0_CH1_WR_SHIFT)
#define  SCCSC_WR_REG0_CH1_WR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG0_CH1_WR_MASK) | (((uint32_t)val) << SCCSC_WR_REG0_CH1_WR_SHIFT))

#define  SCCSC_WR_REG0_CH2_WR_MASK 0x3ff
#define  SCCSC_WR_REG0_CH2_WR_SHIFT 0
#define  SCCSC_WR_REG0_CH2_WR_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG0_CH2_WR_MASK) >> SCCSC_WR_REG0_CH2_WR_SHIFT)
#define  SCCSC_WR_REG0_CH2_WR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG0_CH2_WR_MASK) | (((uint32_t)val) << SCCSC_WR_REG0_CH2_WR_SHIFT))

//====================================================================
//Register: White Response reg 1  (WR_REG1)
/** \brief White pixel response values for output channels 3 - 5.*/
//====================================================================

#define  SCCSC_WR_REG1_RESERVED1_MASK 0xc0000000
#define  SCCSC_WR_REG1_RESERVED1_SHIFT 30
#define  SCCSC_WR_REG1_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG1_RESERVED1_MASK) >> SCCSC_WR_REG1_RESERVED1_SHIFT)
#define  SCCSC_WR_REG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG1_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_WR_REG1_RESERVED1_SHIFT))

#define  SCCSC_WR_REG1_CH3_WR_MASK 0x3ff00000
#define  SCCSC_WR_REG1_CH3_WR_SHIFT 20
#define  SCCSC_WR_REG1_CH3_WR_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG1_CH3_WR_MASK) >> SCCSC_WR_REG1_CH3_WR_SHIFT)
#define  SCCSC_WR_REG1_CH3_WR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG1_CH3_WR_MASK) | (((uint32_t)val) << SCCSC_WR_REG1_CH3_WR_SHIFT))

#define  SCCSC_WR_REG1_CH4_WR_MASK 0xffc00
#define  SCCSC_WR_REG1_CH4_WR_SHIFT 10
#define  SCCSC_WR_REG1_CH4_WR_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG1_CH4_WR_MASK) >> SCCSC_WR_REG1_CH4_WR_SHIFT)
#define  SCCSC_WR_REG1_CH4_WR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG1_CH4_WR_MASK) | (((uint32_t)val) << SCCSC_WR_REG1_CH4_WR_SHIFT))

#define  SCCSC_WR_REG1_CH5_WR_MASK 0x3ff
#define  SCCSC_WR_REG1_CH5_WR_SHIFT 0
#define  SCCSC_WR_REG1_CH5_WR_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG1_CH5_WR_MASK) >> SCCSC_WR_REG1_CH5_WR_SHIFT)
#define  SCCSC_WR_REG1_CH5_WR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG1_CH5_WR_MASK) | (((uint32_t)val) << SCCSC_WR_REG1_CH5_WR_SHIFT))

//====================================================================
//Register: White Response reg 2  (WR_REG2)
/** \brief White pixel response values for output channels 6 - 7.*/
//====================================================================

#define  SCCSC_WR_REG2_RESERVED1_MASK 0xffffffff
#define  SCCSC_WR_REG2_RESERVED1_SHIFT 0
#define  SCCSC_WR_REG2_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG2_RESERVED1_MASK) >> SCCSC_WR_REG2_RESERVED1_SHIFT)
#define  SCCSC_WR_REG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG2_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_WR_REG2_RESERVED1_SHIFT))

//====================================================================
//Register: Black Response Reg 0  (KR_REG0)
/** \brief Black pixel response values for output channels 0 - 2.*/
//====================================================================

#define  SCCSC_KR_REG0_RESERVED1_MASK 0xc0000000
#define  SCCSC_KR_REG0_RESERVED1_SHIFT 30
#define  SCCSC_KR_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG0_RESERVED1_MASK) >> SCCSC_KR_REG0_RESERVED1_SHIFT)
#define  SCCSC_KR_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG0_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_KR_REG0_RESERVED1_SHIFT))

#define  SCCSC_KR_REG0_CH0_KR_MASK 0x3ff00000
#define  SCCSC_KR_REG0_CH0_KR_SHIFT 20
#define  SCCSC_KR_REG0_CH0_KR_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG0_CH0_KR_MASK) >> SCCSC_KR_REG0_CH0_KR_SHIFT)
#define  SCCSC_KR_REG0_CH0_KR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG0_CH0_KR_MASK) | (((uint32_t)val) << SCCSC_KR_REG0_CH0_KR_SHIFT))

#define  SCCSC_KR_REG0_CH1_KR_MASK 0xffc00
#define  SCCSC_KR_REG0_CH1_KR_SHIFT 10
#define  SCCSC_KR_REG0_CH1_KR_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG0_CH1_KR_MASK) >> SCCSC_KR_REG0_CH1_KR_SHIFT)
#define  SCCSC_KR_REG0_CH1_KR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG0_CH1_KR_MASK) | (((uint32_t)val) << SCCSC_KR_REG0_CH1_KR_SHIFT))

#define  SCCSC_KR_REG0_CH2_KR_MASK 0x3ff
#define  SCCSC_KR_REG0_CH2_KR_SHIFT 0
#define  SCCSC_KR_REG0_CH2_KR_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG0_CH2_KR_MASK) >> SCCSC_KR_REG0_CH2_KR_SHIFT)
#define  SCCSC_KR_REG0_CH2_KR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG0_CH2_KR_MASK) | (((uint32_t)val) << SCCSC_KR_REG0_CH2_KR_SHIFT))

//====================================================================
//Register: Black Response Reg 1  (KR_REG1)
/** \brief Black pixel response values for output channels 3 - 5.*/
//====================================================================

#define  SCCSC_KR_REG1_RESERVED1_MASK 0xc0000000
#define  SCCSC_KR_REG1_RESERVED1_SHIFT 30
#define  SCCSC_KR_REG1_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG1_RESERVED1_MASK) >> SCCSC_KR_REG1_RESERVED1_SHIFT)
#define  SCCSC_KR_REG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG1_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_KR_REG1_RESERVED1_SHIFT))

#define  SCCSC_KR_REG1_CH3_KR_MASK 0x3ff00000
#define  SCCSC_KR_REG1_CH3_KR_SHIFT 20
#define  SCCSC_KR_REG1_CH3_KR_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG1_CH3_KR_MASK) >> SCCSC_KR_REG1_CH3_KR_SHIFT)
#define  SCCSC_KR_REG1_CH3_KR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG1_CH3_KR_MASK) | (((uint32_t)val) << SCCSC_KR_REG1_CH3_KR_SHIFT))

#define  SCCSC_KR_REG1_CH4_KR_MASK 0xffc00
#define  SCCSC_KR_REG1_CH4_KR_SHIFT 10
#define  SCCSC_KR_REG1_CH4_KR_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG1_CH4_KR_MASK) >> SCCSC_KR_REG1_CH4_KR_SHIFT)
#define  SCCSC_KR_REG1_CH4_KR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG1_CH4_KR_MASK) | (((uint32_t)val) << SCCSC_KR_REG1_CH4_KR_SHIFT))

#define  SCCSC_KR_REG1_CH5_KR_MASK 0x3ff
#define  SCCSC_KR_REG1_CH5_KR_SHIFT 0
#define  SCCSC_KR_REG1_CH5_KR_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG1_CH5_KR_MASK) >> SCCSC_KR_REG1_CH5_KR_SHIFT)
#define  SCCSC_KR_REG1_CH5_KR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG1_CH5_KR_MASK) | (((uint32_t)val) << SCCSC_KR_REG1_CH5_KR_SHIFT))

//====================================================================
//Register: Black Response Reg 2  (KR_REG2)
/** \brief Black pixel response values for output channels 6 - 7.*/
//====================================================================

#define  SCCSC_KR_REG2_RESERVED1_MASK 0xffffffff
#define  SCCSC_KR_REG2_RESERVED1_SHIFT 0
#define  SCCSC_KR_REG2_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG2_RESERVED1_MASK) >> SCCSC_KR_REG2_RESERVED1_SHIFT)
#define  SCCSC_KR_REG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG2_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_KR_REG2_RESERVED1_SHIFT))

//====================================================================
//Register: SRAM Address  (RAR)
/** \brief Write Only RAM address and control for CPU Access to the 8 iLUT and 8 Cache RAMS
Register is ignored unless CPUAccess bit of the CNTRL register is asserted.*/
//====================================================================

#define  SCCSC_RAR_AUTOINC_MASK 0xc0000000
#define  SCCSC_RAR_AUTOINC_SHIFT 30
#define  SCCSC_RAR_AUTOINC_MASK_SHIFT(reg) (((reg) & SCCSC_RAR_AUTOINC_MASK) >> SCCSC_RAR_AUTOINC_SHIFT)
#define  SCCSC_RAR_AUTOINC_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RAR_AUTOINC_MASK) | (((uint32_t)val) << SCCSC_RAR_AUTOINC_SHIFT))

#define  SCCSC_RAR_RESERVED1_MASK 0x3ffe0000
#define  SCCSC_RAR_RESERVED1_SHIFT 17
#define  SCCSC_RAR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_RAR_RESERVED1_MASK) >> SCCSC_RAR_RESERVED1_SHIFT)
#define  SCCSC_RAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RAR_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_RAR_RESERVED1_SHIFT))

#define  SCCSC_RAR_RNW_MASK 0x10000
#define  SCCSC_RAR_RNW_SHIFT 16
#define  SCCSC_RAR_RNW_MASK_SHIFT(reg) (((reg) & SCCSC_RAR_RNW_MASK) >> SCCSC_RAR_RNW_SHIFT)
#define  SCCSC_RAR_RNW_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RAR_RNW_MASK) | (((uint32_t)val) << SCCSC_RAR_RNW_SHIFT))

#define  SCCSC_RAR_RESERVED2_MASK 0xc000
#define  SCCSC_RAR_RESERVED2_SHIFT 14
#define  SCCSC_RAR_RESERVED2_MASK_SHIFT(reg) (((reg) & SCCSC_RAR_RESERVED2_MASK) >> SCCSC_RAR_RESERVED2_SHIFT)
#define  SCCSC_RAR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RAR_RESERVED2_MASK) | (((uint32_t)val) << SCCSC_RAR_RESERVED2_SHIFT))

#define  SCCSC_RAR_ADDR_MASK 0x3fff
#define  SCCSC_RAR_ADDR_SHIFT 0
#define  SCCSC_RAR_ADDR_MASK_SHIFT(reg) (((reg) & SCCSC_RAR_ADDR_MASK) >> SCCSC_RAR_ADDR_SHIFT)
#define  SCCSC_RAR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RAR_ADDR_MASK) | (((uint32_t)val) << SCCSC_RAR_ADDR_SHIFT))

//====================================================================
//Register: RAM Data Write 0 (RDW0)
/** \brief CPU Access Write data[31:0] to RAMs*/
//====================================================================

#define  SCCSC_RDW0_DATA_MASK 0xffffffff
#define  SCCSC_RDW0_DATA_SHIFT 0
#define  SCCSC_RDW0_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDW0_DATA_MASK) >> SCCSC_RDW0_DATA_SHIFT)
#define  SCCSC_RDW0_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDW0_DATA_MASK) | (((uint32_t)val) << SCCSC_RDW0_DATA_SHIFT))

//====================================================================
//Register: RAM Data Write 1 (RDW1)
/** \brief CPU Access Write data[63:32] to RAMs. These bits are only used if the cache or ilut RAM width exceeds 32 bits. The RAM width is a function of the number of channels and their widths. It is up to the user to determine if this register needs to be used depending on the block configuration. The hardware does understand which registers are needed for AUTOINC mode 2'b10.*/
//====================================================================

#define  SCCSC_RDW1_DATA_MASK 0xffffffff
#define  SCCSC_RDW1_DATA_SHIFT 0
#define  SCCSC_RDW1_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDW1_DATA_MASK) >> SCCSC_RDW1_DATA_SHIFT)
#define  SCCSC_RDW1_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDW1_DATA_MASK) | (((uint32_t)val) << SCCSC_RDW1_DATA_SHIFT))

//====================================================================
//Register: RAM Data Write 2 (RDW2)
/** \brief CPU Access Write data[79:64] to RAMs. These bits are only used if the cache or ilut RAM width exceed 64 bits. The RAM width is a function of the number of channels and their widths. It is up to the user to determine if this register needs to be used depending on the block configuration. The hardware does understand which registers are needed for AUTOINC mode 2'b10*/
//====================================================================

#define  SCCSC_RDW2_RESERVED1_MASK 0xffff0000
#define  SCCSC_RDW2_RESERVED1_SHIFT 16
#define  SCCSC_RDW2_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_RDW2_RESERVED1_MASK) >> SCCSC_RDW2_RESERVED1_SHIFT)
#define  SCCSC_RDW2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDW2_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_RDW2_RESERVED1_SHIFT))

#define  SCCSC_RDW2_DATA_MASK 0xffff
#define  SCCSC_RDW2_DATA_SHIFT 0
#define  SCCSC_RDW2_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDW2_DATA_MASK) >> SCCSC_RDW2_DATA_SHIFT)
#define  SCCSC_RDW2_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDW2_DATA_MASK) | (((uint32_t)val) << SCCSC_RDW2_DATA_SHIFT))

//====================================================================
//Register: RAM Data Read 0 (RDR0)
/** \brief CPU Access Read data[31:0] from RAMs*/
//====================================================================

#define  SCCSC_RDR0_DATA_MASK 0xffffffff
#define  SCCSC_RDR0_DATA_SHIFT 0
#define  SCCSC_RDR0_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDR0_DATA_MASK) >> SCCSC_RDR0_DATA_SHIFT)
#define  SCCSC_RDR0_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDR0_DATA_MASK) | (((uint32_t)val) << SCCSC_RDR0_DATA_SHIFT))

//====================================================================
//Register: RAM Data Read 1 (RDR1)
/** \brief CPU Access Read data[63:32] from RAMs. These bits are only used if the cache or ilut RAM width exceed 32 bits. The ram width is a function of the number of channels and their widths. It is up to the user to determine if this register is needed. The hardware does understand which registers are needed for AUTOINC mode.*/
//====================================================================

#define  SCCSC_RDR1_DATA_MASK 0xffffffff
#define  SCCSC_RDR1_DATA_SHIFT 0
#define  SCCSC_RDR1_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDR1_DATA_MASK) >> SCCSC_RDR1_DATA_SHIFT)
#define  SCCSC_RDR1_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDR1_DATA_MASK) | (((uint32_t)val) << SCCSC_RDR1_DATA_SHIFT))

//====================================================================
//Register: RAM Data Read 2 (RDR2)
/** \brief CPU Access Read data[79:64] from RAMs. These bits are only used if the cache or ilut RAM width exceed 64 bits. The ram width is a function of the number of channels and their widths. It is up to the user to determine if this register is needed. The hardware does understand which registers are needed for AUTOINC mode.*/
//====================================================================

#define  SCCSC_RDR2_RESERVED1_MASK 0xffff0000
#define  SCCSC_RDR2_RESERVED1_SHIFT 16
#define  SCCSC_RDR2_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_RDR2_RESERVED1_MASK) >> SCCSC_RDR2_RESERVED1_SHIFT)
#define  SCCSC_RDR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDR2_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_RDR2_RESERVED1_SHIFT))

#define  SCCSC_RDR2_DATA_MASK 0xffff
#define  SCCSC_RDR2_DATA_SHIFT 0
#define  SCCSC_RDR2_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDR2_DATA_MASK) >> SCCSC_RDR2_DATA_SHIFT)
#define  SCCSC_RDR2_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDR2_DATA_MASK) | (((uint32_t)val) << SCCSC_RDR2_DATA_SHIFT))

//====================================================================
//Register: IIP Tagging Revision (REV)
/** \brief Provide means to firmware to read IP revision.*/
//====================================================================

#define  SCCSC_REV_CFG_MASK 0xffc00000
#define  SCCSC_REV_CFG_SHIFT 22
#define  SCCSC_REV_CFG_MASK_SHIFT(reg) (((reg) & SCCSC_REV_CFG_MASK) >> SCCSC_REV_CFG_SHIFT)
#define  SCCSC_REV_CFG_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_REV_CFG_MASK) | (((uint32_t)val) << SCCSC_REV_CFG_SHIFT))

#define  SCCSC_REV_MID_MASK 0x3ff000
#define  SCCSC_REV_MID_SHIFT 12
#define  SCCSC_REV_MID_MASK_SHIFT(reg) (((reg) & SCCSC_REV_MID_MASK) >> SCCSC_REV_MID_SHIFT)
#define  SCCSC_REV_MID_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_REV_MID_MASK) | (((uint32_t)val) << SCCSC_REV_MID_SHIFT))

#define  SCCSC_REV_MAJ_MASK 0xfff
#define  SCCSC_REV_MAJ_SHIFT 0
#define  SCCSC_REV_MAJ_MASK_SHIFT(reg) (((reg) & SCCSC_REV_MAJ_MASK) >> SCCSC_REV_MAJ_SHIFT)
#define  SCCSC_REV_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_REV_MAJ_MASK) | (((uint32_t)val) << SCCSC_REV_MAJ_SHIFT))

//====================================================================
//Register: PARAMETERS (PARAMS)
/** \brief Provide means to firmware to read PARAMETERS used to generate this BLOCK.*/
//====================================================================

#define  SCCSC_PARAMS_CACHELINES_MASK 0xffff0000
#define  SCCSC_PARAMS_CACHELINES_SHIFT 16
#define  SCCSC_PARAMS_CACHELINES_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_CACHELINES_MASK) >> SCCSC_PARAMS_CACHELINES_SHIFT)
#define  SCCSC_PARAMS_CACHELINES_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_CACHELINES_MASK) | (((uint32_t)val) << SCCSC_PARAMS_CACHELINES_SHIFT))

#define  SCCSC_PARAMS_NUMOUTS_MASK 0xf000
#define  SCCSC_PARAMS_NUMOUTS_SHIFT 12
#define  SCCSC_PARAMS_NUMOUTS_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_NUMOUTS_MASK) >> SCCSC_PARAMS_NUMOUTS_SHIFT)
#define  SCCSC_PARAMS_NUMOUTS_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_NUMOUTS_MASK) | (((uint32_t)val) << SCCSC_PARAMS_NUMOUTS_SHIFT))

#define  SCCSC_PARAMS_OUTWIDTH_MASK 0xf00
#define  SCCSC_PARAMS_OUTWIDTH_SHIFT 8
#define  SCCSC_PARAMS_OUTWIDTH_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_OUTWIDTH_MASK) >> SCCSC_PARAMS_OUTWIDTH_SHIFT)
#define  SCCSC_PARAMS_OUTWIDTH_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_OUTWIDTH_MASK) | (((uint32_t)val) << SCCSC_PARAMS_OUTWIDTH_SHIFT))

#define  SCCSC_PARAMS_INWIDTH_MASK 0xf0
#define  SCCSC_PARAMS_INWIDTH_SHIFT 4
#define  SCCSC_PARAMS_INWIDTH_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_INWIDTH_MASK) >> SCCSC_PARAMS_INWIDTH_SHIFT)
#define  SCCSC_PARAMS_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_INWIDTH_MASK) | (((uint32_t)val) << SCCSC_PARAMS_INWIDTH_SHIFT))

#define  SCCSC_PARAMS_RESERVED1_MASK 0xe
#define  SCCSC_PARAMS_RESERVED1_SHIFT 1
#define  SCCSC_PARAMS_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_RESERVED1_MASK) >> SCCSC_PARAMS_RESERVED1_SHIFT)
#define  SCCSC_PARAMS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_PARAMS_RESERVED1_SHIFT))

#define  SCCSC_PARAMS_RESERVED2_MASK 0x1
#define  SCCSC_PARAMS_RESERVED2_SHIFT 0
#define  SCCSC_PARAMS_RESERVED2_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_RESERVED2_MASK) >> SCCSC_PARAMS_RESERVED2_SHIFT)
#define  SCCSC_PARAMS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_RESERVED2_MASK) | (((uint32_t)val) << SCCSC_PARAMS_RESERVED2_SHIFT))

#endif // SCCSC
