 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SSPA_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SSPA_REGSTRUCTS_H_
#define _SSPA_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SSPA (SSPA)
/** \brief Top-level register file for SSPA
(rev 0 . 0 . 2 . 7)*/
//
//====================================================================

typedef struct SSPA_REGS_s
{
  volatile uint32_t Rx_Data;  ///< 0x0 [R]: Receive Data Register
  volatile uint32_t Rx_Channel_Ident;  ///< 0x4 [R]: Receive Channel Identification Register
  volatile uint32_t RxCfg;  ///< 0x8 [R/W]: Receive Configuration Register
  volatile uint32_t RxSerialCtrl;  ///< 0xc [R/W]: Receive Serial Control Register
  volatile uint32_t Rx_Fifo_UL;  ///< 0x10 [R/W]: Receive Fifo Upper Limit Register
  volatile uint32_t Rx_Int;  ///< 0x14 [R/W]: Receive Interrupt Register
  volatile uint32_t Rx_IPCore_Version;  ///< 0x18 [R]: Receive Core Version Register
  volatile uint32_t Rx_Fifo_NumSamples;  ///< 0x1c [R]: Number of Samples in Rx Fifo Register
  volatile uint32_t Rx_Fifo_Depth;  ///< 0x20 [R]: Rx Fifo Depth Register
  volatile uint32_t reserved0[23];
  volatile uint32_t Tx_Data_Reg;  ///< 0x80 [W]: Transmit Data Register
  volatile uint32_t Tx_Channel_Ident;  ///< 0x84 [R]: Transmit Channel Identification Register
  volatile uint32_t TxCfg;  ///< 0x88 [R/W]: Transmit Configuration Register
  volatile uint32_t TxSerialCtrl;  ///< 0x8c [R/W]: Transmit Serial Control Register
  volatile uint32_t Tx_Fifo_LL;  ///< 0x90 [R/W]: Transmit Fifo Lower Limit Register
  volatile uint32_t Tx_Int;  ///< 0x94 [R/W]: Transmit Interrupt Register
  volatile uint32_t Tx_IPCore_Version;  ///< 0x98 [R]: Transmit Core Version Register
  volatile uint32_t Tx_Fifo_NumSamples;  ///< 0x9c [R]: Number of samples in Tx Fifo Register
  volatile uint32_t Tx_Fifo_Depth;  ///< 0xa0 [R]: Tx Fifo Depth Register
  volatile uint32_t reserved1[23];
  volatile uint32_t SSPA_cfg;  ///< 0x100 [R/W]: SSPA Configuration Register
  volatile uint32_t SSPA_sreset;  ///< 0x104 [W]: Soft Reset Register
  volatile uint32_t reserved2[6];
  volatile uint32_t REV0;  ///< 0x120 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x124 [R]: IP Tagging Revision 1
} SSPA_REGS_t;

#endif // SSPA
