 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SSPA_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SSPA_REGMASKS_H_
#define _SSPA_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SSPA (SSPA)
/** \brief Top-level register file for SSPA
(rev 0 . 0 . 2 . 7)*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  SSPA_REV0_MAJ_MASK 0xffff0000
#define  SSPA_REV0_MAJ_SHIFT 16
#define  SSPA_REV0_MAJ_MASK_SHIFT(reg) (((reg) & SSPA_REV0_MAJ_MASK) >> SSPA_REV0_MAJ_SHIFT)
#define  SSPA_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SSPA_REV0_MAJ_MASK) | (((uint32_t)val) << SSPA_REV0_MAJ_SHIFT))

#define  SSPA_REV0_MID_MASK 0xffff
#define  SSPA_REV0_MID_SHIFT 0
#define  SSPA_REV0_MID_MASK_SHIFT(reg) (((reg) & SSPA_REV0_MID_MASK) >> SSPA_REV0_MID_SHIFT)
#define  SSPA_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~SSPA_REV0_MID_MASK) | (((uint32_t)val) << SSPA_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  SSPA_REV1_RESERVED1_MASK 0xffff0000
#define  SSPA_REV1_RESERVED1_SHIFT 16
#define  SSPA_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_REV1_RESERVED1_MASK) >> SSPA_REV1_RESERVED1_SHIFT)
#define  SSPA_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_REV1_RESERVED1_MASK) | (((uint32_t)val) << SSPA_REV1_RESERVED1_SHIFT))

#define  SSPA_REV1_CFG_MASK 0xffff
#define  SSPA_REV1_CFG_SHIFT 0
#define  SSPA_REV1_CFG_MASK_SHIFT(reg) (((reg) & SSPA_REV1_CFG_MASK) >> SSPA_REV1_CFG_SHIFT)
#define  SSPA_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~SSPA_REV1_CFG_MASK) | (((uint32_t)val) << SSPA_REV1_CFG_SHIFT))

//====================================================================
//Register: SSPA Configuration Register (SSPA_cfg)
//====================================================================

#define  SSPA_SSPA_CFG_RESERVED1_MASK 0xfffffffc
#define  SSPA_SSPA_CFG_RESERVED1_SHIFT 2
#define  SSPA_SSPA_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_SSPA_CFG_RESERVED1_MASK) >> SSPA_SSPA_CFG_RESERVED1_SHIFT)
#define  SSPA_SSPA_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_SSPA_CFG_RESERVED1_MASK) | (((uint32_t)val) << SSPA_SSPA_CFG_RESERVED1_SHIFT))

#define  SSPA_SSPA_CFG_SYSCLKSEL_MASK 0x2
#define  SSPA_SSPA_CFG_SYSCLKSEL_SHIFT 1
#define  SSPA_SSPA_CFG_SYSCLKSEL_MASK_SHIFT(reg) (((reg) & SSPA_SSPA_CFG_SYSCLKSEL_MASK) >> SSPA_SSPA_CFG_SYSCLKSEL_SHIFT)
#define  SSPA_SSPA_CFG_SYSCLKSEL_REPLACE_VAL(reg,val) (((reg) & ~SSPA_SSPA_CFG_SYSCLKSEL_MASK) | (((uint32_t)val) << SSPA_SSPA_CFG_SYSCLKSEL_SHIFT))

#define  SSPA_SSPA_CFG_ENCDMA_MASK 0x1
#define  SSPA_SSPA_CFG_ENCDMA_SHIFT 0
#define  SSPA_SSPA_CFG_ENCDMA_MASK_SHIFT(reg) (((reg) & SSPA_SSPA_CFG_ENCDMA_MASK) >> SSPA_SSPA_CFG_ENCDMA_SHIFT)
#define  SSPA_SSPA_CFG_ENCDMA_REPLACE_VAL(reg,val) (((reg) & ~SSPA_SSPA_CFG_ENCDMA_MASK) | (((uint32_t)val) << SSPA_SSPA_CFG_ENCDMA_SHIFT))

//====================================================================
//Register: Soft Reset Register (SSPA_sreset)
//====================================================================

#define  SSPA_SSPA_SRESET_RESERVED1_MASK 0xfffffffe
#define  SSPA_SSPA_SRESET_RESERVED1_SHIFT 1
#define  SSPA_SSPA_SRESET_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_SSPA_SRESET_RESERVED1_MASK) >> SSPA_SSPA_SRESET_RESERVED1_SHIFT)
#define  SSPA_SSPA_SRESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_SSPA_SRESET_RESERVED1_MASK) | (((uint32_t)val) << SSPA_SSPA_SRESET_RESERVED1_SHIFT))

#define  SSPA_SSPA_SRESET_SOFTRESET_MASK 0x1
#define  SSPA_SSPA_SRESET_SOFTRESET_SHIFT 0
#define  SSPA_SSPA_SRESET_SOFTRESET_MASK_SHIFT(reg) (((reg) & SSPA_SSPA_SRESET_SOFTRESET_MASK) >> SSPA_SSPA_SRESET_SOFTRESET_SHIFT)
#define  SSPA_SSPA_SRESET_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~SSPA_SSPA_SRESET_SOFTRESET_MASK) | (((uint32_t)val) << SSPA_SSPA_SRESET_SOFTRESET_SHIFT))

//====================================================================
//Register: Receive Data Register (Rx_Data)
//====================================================================

#define  SSPA_RX_DATA_FIFODATA_MASK 0xffffffff
#define  SSPA_RX_DATA_FIFODATA_SHIFT 0
#define  SSPA_RX_DATA_FIFODATA_MASK_SHIFT(reg) (((reg) & SSPA_RX_DATA_FIFODATA_MASK) >> SSPA_RX_DATA_FIFODATA_SHIFT)
#define  SSPA_RX_DATA_FIFODATA_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_DATA_FIFODATA_MASK) | (((uint32_t)val) << SSPA_RX_DATA_FIFODATA_SHIFT))

//====================================================================
//Register: Receive Channel Identification Register (Rx_Channel_Ident)
//====================================================================

#define  SSPA_RX_CHANNEL_IDENT_RESERVED1_MASK 0xffffff00
#define  SSPA_RX_CHANNEL_IDENT_RESERVED1_SHIFT 8
#define  SSPA_RX_CHANNEL_IDENT_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_RX_CHANNEL_IDENT_RESERVED1_MASK) >> SSPA_RX_CHANNEL_IDENT_RESERVED1_SHIFT)
#define  SSPA_RX_CHANNEL_IDENT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_CHANNEL_IDENT_RESERVED1_MASK) | (((uint32_t)val) << SSPA_RX_CHANNEL_IDENT_RESERVED1_SHIFT))

#define  SSPA_RX_CHANNEL_IDENT_CHANIDENT_MASK 0xff
#define  SSPA_RX_CHANNEL_IDENT_CHANIDENT_SHIFT 0
#define  SSPA_RX_CHANNEL_IDENT_CHANIDENT_MASK_SHIFT(reg) (((reg) & SSPA_RX_CHANNEL_IDENT_CHANIDENT_MASK) >> SSPA_RX_CHANNEL_IDENT_CHANIDENT_SHIFT)
#define  SSPA_RX_CHANNEL_IDENT_CHANIDENT_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_CHANNEL_IDENT_CHANIDENT_MASK) | (((uint32_t)val) << SSPA_RX_CHANNEL_IDENT_CHANIDENT_SHIFT))

//====================================================================
//Register: Receive Configuration Register (RxCfg)
//====================================================================

#define  SSPA_RXCFG_READPHASE_MASK 0x80000000
#define  SSPA_RXCFG_READPHASE_SHIFT 31
#define  SSPA_RXCFG_READPHASE_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_READPHASE_MASK) >> SSPA_RXCFG_READPHASE_SHIFT)
#define  SSPA_RXCFG_READPHASE_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_READPHASE_MASK) | (((uint32_t)val) << SSPA_RXCFG_READPHASE_SHIFT))

#define  SSPA_RXCFG_RXCHANNELS2_MASK 0x7f000000
#define  SSPA_RXCFG_RXCHANNELS2_SHIFT 24
#define  SSPA_RXCFG_RXCHANNELS2_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_RXCHANNELS2_MASK) >> SSPA_RXCFG_RXCHANNELS2_SHIFT)
#define  SSPA_RXCFG_RXCHANNELS2_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_RXCHANNELS2_MASK) | (((uint32_t)val) << SSPA_RXCFG_RXCHANNELS2_SHIFT))

#define  SSPA_RXCFG_RXWORDLEN2_MASK 0xe00000
#define  SSPA_RXCFG_RXWORDLEN2_SHIFT 21
#define  SSPA_RXCFG_RXWORDLEN2_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_RXWORDLEN2_MASK) >> SSPA_RXCFG_RXWORDLEN2_SHIFT)
#define  SSPA_RXCFG_RXWORDLEN2_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_RXWORDLEN2_MASK) | (((uint32_t)val) << SSPA_RXCFG_RXWORDLEN2_SHIFT))

#define  SSPA_RXCFG_RXDATDLY_MASK 0x180000
#define  SSPA_RXCFG_RXDATDLY_SHIFT 19
#define  SSPA_RXCFG_RXDATDLY_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_RXDATDLY_MASK) >> SSPA_RXCFG_RXDATDLY_SHIFT)
#define  SSPA_RXCFG_RXDATDLY_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_RXDATDLY_MASK) | (((uint32_t)val) << SSPA_RXCFG_RXDATDLY_SHIFT))

#define  SSPA_RXCFG_RXSMPLSIZE2_MASK 0x70000
#define  SSPA_RXCFG_RXSMPLSIZE2_SHIFT 16
#define  SSPA_RXCFG_RXSMPLSIZE2_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_RXSMPLSIZE2_MASK) >> SSPA_RXCFG_RXSMPLSIZE2_SHIFT)
#define  SSPA_RXCFG_RXSMPLSIZE2_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_RXSMPLSIZE2_MASK) | (((uint32_t)val) << SSPA_RXCFG_RXSMPLSIZE2_SHIFT))

#define  SSPA_RXCFG_RXFSYNCIGNORE_MASK 0x8000
#define  SSPA_RXCFG_RXFSYNCIGNORE_SHIFT 15
#define  SSPA_RXCFG_RXFSYNCIGNORE_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_RXFSYNCIGNORE_MASK) >> SSPA_RXCFG_RXFSYNCIGNORE_SHIFT)
#define  SSPA_RXCFG_RXFSYNCIGNORE_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_RXFSYNCIGNORE_MASK) | (((uint32_t)val) << SSPA_RXCFG_RXFSYNCIGNORE_SHIFT))

#define  SSPA_RXCFG_RXCHANNELS1_MASK 0x7f00
#define  SSPA_RXCFG_RXCHANNELS1_SHIFT 8
#define  SSPA_RXCFG_RXCHANNELS1_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_RXCHANNELS1_MASK) >> SSPA_RXCFG_RXCHANNELS1_SHIFT)
#define  SSPA_RXCFG_RXCHANNELS1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_RXCHANNELS1_MASK) | (((uint32_t)val) << SSPA_RXCFG_RXCHANNELS1_SHIFT))

#define  SSPA_RXCFG_RXWORDLEN1_MASK 0xe0
#define  SSPA_RXCFG_RXWORDLEN1_SHIFT 5
#define  SSPA_RXCFG_RXWORDLEN1_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_RXWORDLEN1_MASK) >> SSPA_RXCFG_RXWORDLEN1_SHIFT)
#define  SSPA_RXCFG_RXWORDLEN1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_RXWORDLEN1_MASK) | (((uint32_t)val) << SSPA_RXCFG_RXWORDLEN1_SHIFT))

#define  SSPA_RXCFG_RESERVED1_MASK 0x10
#define  SSPA_RXCFG_RESERVED1_SHIFT 4
#define  SSPA_RXCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_RESERVED1_MASK) >> SSPA_RXCFG_RESERVED1_SHIFT)
#define  SSPA_RXCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_RESERVED1_MASK) | (((uint32_t)val) << SSPA_RXCFG_RESERVED1_SHIFT))

#define  SSPA_RXCFG_RXJUSTIFY_MASK 0x8
#define  SSPA_RXCFG_RXJUSTIFY_SHIFT 3
#define  SSPA_RXCFG_RXJUSTIFY_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_RXJUSTIFY_MASK) >> SSPA_RXCFG_RXJUSTIFY_SHIFT)
#define  SSPA_RXCFG_RXJUSTIFY_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_RXJUSTIFY_MASK) | (((uint32_t)val) << SSPA_RXCFG_RXJUSTIFY_SHIFT))

#define  SSPA_RXCFG_RXSMPLSIZE1_MASK 0x7
#define  SSPA_RXCFG_RXSMPLSIZE1_SHIFT 0
#define  SSPA_RXCFG_RXSMPLSIZE1_MASK_SHIFT(reg) (((reg) & SSPA_RXCFG_RXSMPLSIZE1_MASK) >> SSPA_RXCFG_RXSMPLSIZE1_SHIFT)
#define  SSPA_RXCFG_RXSMPLSIZE1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXCFG_RXSMPLSIZE1_MASK) | (((uint32_t)val) << SSPA_RXCFG_RXSMPLSIZE1_SHIFT))

//====================================================================
//Register: Receive Serial Control Register (RxSerialCtrl)
//====================================================================

#define  SSPA_RXSERIALCTRL_WEN_MASK 0x80000000
#define  SSPA_RXSERIALCTRL_WEN_SHIFT 31
#define  SSPA_RXSERIALCTRL_WEN_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_WEN_MASK) >> SSPA_RXSERIALCTRL_WEN_SHIFT)
#define  SSPA_RXSERIALCTRL_WEN_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_WEN_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_WEN_SHIFT))

#define  SSPA_RXSERIALCTRL_RESERVED1_MASK 0x70000000
#define  SSPA_RXSERIALCTRL_RESERVED1_SHIFT 28
#define  SSPA_RXSERIALCTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_RESERVED1_MASK) >> SSPA_RXSERIALCTRL_RESERVED1_SHIFT)
#define  SSPA_RXSERIALCTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_RESERVED1_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_RESERVED1_SHIFT))

#define  SSPA_RXSERIALCTRL_FSYNCWIDTH_MASK 0xff00000
#define  SSPA_RXSERIALCTRL_FSYNCWIDTH_SHIFT 20
#define  SSPA_RXSERIALCTRL_FSYNCWIDTH_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_FSYNCWIDTH_MASK) >> SSPA_RXSERIALCTRL_FSYNCWIDTH_SHIFT)
#define  SSPA_RXSERIALCTRL_FSYNCWIDTH_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_FSYNCWIDTH_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_FSYNCWIDTH_SHIFT))

#define  SSPA_RXSERIALCTRL_RESERVED2_MASK 0x80000
#define  SSPA_RXSERIALCTRL_RESERVED2_SHIFT 19
#define  SSPA_RXSERIALCTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_RESERVED2_MASK) >> SSPA_RXSERIALCTRL_RESERVED2_SHIFT)
#define  SSPA_RXSERIALCTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_RESERVED2_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_RESERVED2_SHIFT))

#define  SSPA_RXSERIALCTRL_MASTERSLAVE_MASK 0x40000
#define  SSPA_RXSERIALCTRL_MASTERSLAVE_SHIFT 18
#define  SSPA_RXSERIALCTRL_MASTERSLAVE_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_MASTERSLAVE_MASK) >> SSPA_RXSERIALCTRL_MASTERSLAVE_SHIFT)
#define  SSPA_RXSERIALCTRL_MASTERSLAVE_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_MASTERSLAVE_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_MASTERSLAVE_SHIFT))

#define  SSPA_RXSERIALCTRL_SCLKPOL_MASK 0x20000
#define  SSPA_RXSERIALCTRL_SCLKPOL_SHIFT 17
#define  SSPA_RXSERIALCTRL_SCLKPOL_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_SCLKPOL_MASK) >> SSPA_RXSERIALCTRL_SCLKPOL_SHIFT)
#define  SSPA_RXSERIALCTRL_SCLKPOL_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_SCLKPOL_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_SCLKPOL_SHIFT))

#define  SSPA_RXSERIALCTRL_FSYNCPOL_MASK 0x10000
#define  SSPA_RXSERIALCTRL_FSYNCPOL_SHIFT 16
#define  SSPA_RXSERIALCTRL_FSYNCPOL_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_FSYNCPOL_MASK) >> SSPA_RXSERIALCTRL_FSYNCPOL_SHIFT)
#define  SSPA_RXSERIALCTRL_FSYNCPOL_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_FSYNCPOL_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_FSYNCPOL_SHIFT))

#define  SSPA_RXSERIALCTRL_FRAMEPER_MASK 0xfff0
#define  SSPA_RXSERIALCTRL_FRAMEPER_SHIFT 4
#define  SSPA_RXSERIALCTRL_FRAMEPER_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_FRAMEPER_MASK) >> SSPA_RXSERIALCTRL_FRAMEPER_SHIFT)
#define  SSPA_RXSERIALCTRL_FRAMEPER_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_FRAMEPER_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_FRAMEPER_SHIFT))

#define  SSPA_RXSERIALCTRL_RESERVED3_MASK 0x8
#define  SSPA_RXSERIALCTRL_RESERVED3_SHIFT 3
#define  SSPA_RXSERIALCTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_RESERVED3_MASK) >> SSPA_RXSERIALCTRL_RESERVED3_SHIFT)
#define  SSPA_RXSERIALCTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_RESERVED3_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_RESERVED3_SHIFT))

#define  SSPA_RXSERIALCTRL_FIFOFLUSH_MASK 0x4
#define  SSPA_RXSERIALCTRL_FIFOFLUSH_SHIFT 2
#define  SSPA_RXSERIALCTRL_FIFOFLUSH_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_FIFOFLUSH_MASK) >> SSPA_RXSERIALCTRL_FIFOFLUSH_SHIFT)
#define  SSPA_RXSERIALCTRL_FIFOFLUSH_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_FIFOFLUSH_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_FIFOFLUSH_SHIFT))

#define  SSPA_RXSERIALCTRL_SERIALRESET_MASK 0x2
#define  SSPA_RXSERIALCTRL_SERIALRESET_SHIFT 1
#define  SSPA_RXSERIALCTRL_SERIALRESET_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_SERIALRESET_MASK) >> SSPA_RXSERIALCTRL_SERIALRESET_SHIFT)
#define  SSPA_RXSERIALCTRL_SERIALRESET_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_SERIALRESET_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_SERIALRESET_SHIFT))

#define  SSPA_RXSERIALCTRL_SERIALENABLE_MASK 0x1
#define  SSPA_RXSERIALCTRL_SERIALENABLE_SHIFT 0
#define  SSPA_RXSERIALCTRL_SERIALENABLE_MASK_SHIFT(reg) (((reg) & SSPA_RXSERIALCTRL_SERIALENABLE_MASK) >> SSPA_RXSERIALCTRL_SERIALENABLE_SHIFT)
#define  SSPA_RXSERIALCTRL_SERIALENABLE_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RXSERIALCTRL_SERIALENABLE_MASK) | (((uint32_t)val) << SSPA_RXSERIALCTRL_SERIALENABLE_SHIFT))

//====================================================================
//Register: Receive Fifo Upper Limit Register (Rx_Fifo_UL)
//====================================================================

#define  SSPA_RX_FIFO_UL_RESERVED1_MASK 0xffff0000
#define  SSPA_RX_FIFO_UL_RESERVED1_SHIFT 16
#define  SSPA_RX_FIFO_UL_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_RX_FIFO_UL_RESERVED1_MASK) >> SSPA_RX_FIFO_UL_RESERVED1_SHIFT)
#define  SSPA_RX_FIFO_UL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_FIFO_UL_RESERVED1_MASK) | (((uint32_t)val) << SSPA_RX_FIFO_UL_RESERVED1_SHIFT))

#define  SSPA_RX_FIFO_UL_UPPERLIMIT_MASK 0xffff
#define  SSPA_RX_FIFO_UL_UPPERLIMIT_SHIFT 0
#define  SSPA_RX_FIFO_UL_UPPERLIMIT_MASK_SHIFT(reg) (((reg) & SSPA_RX_FIFO_UL_UPPERLIMIT_MASK) >> SSPA_RX_FIFO_UL_UPPERLIMIT_SHIFT)
#define  SSPA_RX_FIFO_UL_UPPERLIMIT_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_FIFO_UL_UPPERLIMIT_MASK) | (((uint32_t)val) << SSPA_RX_FIFO_UL_UPPERLIMIT_SHIFT))

//====================================================================
//Register: Receive Interrupt Register (Rx_Int)
//====================================================================

#define  SSPA_RX_INT_RESERVED1_MASK 0xfffe0000
#define  SSPA_RX_INT_RESERVED1_SHIFT 17
#define  SSPA_RX_INT_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_RX_INT_RESERVED1_MASK) >> SSPA_RX_INT_RESERVED1_SHIFT)
#define  SSPA_RX_INT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_INT_RESERVED1_MASK) | (((uint32_t)val) << SSPA_RX_INT_RESERVED1_SHIFT))

#define  SSPA_RX_INT_FIFOLIMITINTPEND_MASK 0x10000
#define  SSPA_RX_INT_FIFOLIMITINTPEND_SHIFT 16
#define  SSPA_RX_INT_FIFOLIMITINTPEND_MASK_SHIFT(reg) (((reg) & SSPA_RX_INT_FIFOLIMITINTPEND_MASK) >> SSPA_RX_INT_FIFOLIMITINTPEND_SHIFT)
#define  SSPA_RX_INT_FIFOLIMITINTPEND_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_INT_FIFOLIMITINTPEND_MASK) | (((uint32_t)val) << SSPA_RX_INT_FIFOLIMITINTPEND_SHIFT))

#define  SSPA_RX_INT_RESERVED2_MASK 0xfffe
#define  SSPA_RX_INT_RESERVED2_SHIFT 1
#define  SSPA_RX_INT_RESERVED2_MASK_SHIFT(reg) (((reg) & SSPA_RX_INT_RESERVED2_MASK) >> SSPA_RX_INT_RESERVED2_SHIFT)
#define  SSPA_RX_INT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_INT_RESERVED2_MASK) | (((uint32_t)val) << SSPA_RX_INT_RESERVED2_SHIFT))

#define  SSPA_RX_INT_FIFOINTMASK_MASK 0x1
#define  SSPA_RX_INT_FIFOINTMASK_SHIFT 0
#define  SSPA_RX_INT_FIFOINTMASK_MASK_SHIFT(reg) (((reg) & SSPA_RX_INT_FIFOINTMASK_MASK) >> SSPA_RX_INT_FIFOINTMASK_SHIFT)
#define  SSPA_RX_INT_FIFOINTMASK_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_INT_FIFOINTMASK_MASK) | (((uint32_t)val) << SSPA_RX_INT_FIFOINTMASK_SHIFT))

//====================================================================
//Register: Receive Core Version Register (Rx_IPCore_Version)
//====================================================================

#define  SSPA_RX_IPCORE_VERSION_COREFAMILY_MASK 0xff000000
#define  SSPA_RX_IPCORE_VERSION_COREFAMILY_SHIFT 24
#define  SSPA_RX_IPCORE_VERSION_COREFAMILY_MASK_SHIFT(reg) (((reg) & SSPA_RX_IPCORE_VERSION_COREFAMILY_MASK) >> SSPA_RX_IPCORE_VERSION_COREFAMILY_SHIFT)
#define  SSPA_RX_IPCORE_VERSION_COREFAMILY_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_IPCORE_VERSION_COREFAMILY_MASK) | (((uint32_t)val) << SSPA_RX_IPCORE_VERSION_COREFAMILY_SHIFT))

#define  SSPA_RX_IPCORE_VERSION_COREID_MASK 0xff0000
#define  SSPA_RX_IPCORE_VERSION_COREID_SHIFT 16
#define  SSPA_RX_IPCORE_VERSION_COREID_MASK_SHIFT(reg) (((reg) & SSPA_RX_IPCORE_VERSION_COREID_MASK) >> SSPA_RX_IPCORE_VERSION_COREID_SHIFT)
#define  SSPA_RX_IPCORE_VERSION_COREID_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_IPCORE_VERSION_COREID_MASK) | (((uint32_t)val) << SSPA_RX_IPCORE_VERSION_COREID_SHIFT))

#define  SSPA_RX_IPCORE_VERSION_COREVERSION_MASK 0xff00
#define  SSPA_RX_IPCORE_VERSION_COREVERSION_SHIFT 8
#define  SSPA_RX_IPCORE_VERSION_COREVERSION_MASK_SHIFT(reg) (((reg) & SSPA_RX_IPCORE_VERSION_COREVERSION_MASK) >> SSPA_RX_IPCORE_VERSION_COREVERSION_SHIFT)
#define  SSPA_RX_IPCORE_VERSION_COREVERSION_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_IPCORE_VERSION_COREVERSION_MASK) | (((uint32_t)val) << SSPA_RX_IPCORE_VERSION_COREVERSION_SHIFT))

#define  SSPA_RX_IPCORE_VERSION_CORERELEASE_MASK 0xff
#define  SSPA_RX_IPCORE_VERSION_CORERELEASE_SHIFT 0
#define  SSPA_RX_IPCORE_VERSION_CORERELEASE_MASK_SHIFT(reg) (((reg) & SSPA_RX_IPCORE_VERSION_CORERELEASE_MASK) >> SSPA_RX_IPCORE_VERSION_CORERELEASE_SHIFT)
#define  SSPA_RX_IPCORE_VERSION_CORERELEASE_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_IPCORE_VERSION_CORERELEASE_MASK) | (((uint32_t)val) << SSPA_RX_IPCORE_VERSION_CORERELEASE_SHIFT))

//====================================================================
//Register: Number of Samples in Rx Fifo Register (Rx_Fifo_NumSamples)
//====================================================================

#define  SSPA_RX_FIFO_NUMSAMPLES_RESERVED1_MASK 0xffffff00
#define  SSPA_RX_FIFO_NUMSAMPLES_RESERVED1_SHIFT 8
#define  SSPA_RX_FIFO_NUMSAMPLES_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_RX_FIFO_NUMSAMPLES_RESERVED1_MASK) >> SSPA_RX_FIFO_NUMSAMPLES_RESERVED1_SHIFT)
#define  SSPA_RX_FIFO_NUMSAMPLES_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_FIFO_NUMSAMPLES_RESERVED1_MASK) | (((uint32_t)val) << SSPA_RX_FIFO_NUMSAMPLES_RESERVED1_SHIFT))

#define  SSPA_RX_FIFO_NUMSAMPLES_NUMSAMPLES_MASK 0xff
#define  SSPA_RX_FIFO_NUMSAMPLES_NUMSAMPLES_SHIFT 0
#define  SSPA_RX_FIFO_NUMSAMPLES_NUMSAMPLES_MASK_SHIFT(reg) (((reg) & SSPA_RX_FIFO_NUMSAMPLES_NUMSAMPLES_MASK) >> SSPA_RX_FIFO_NUMSAMPLES_NUMSAMPLES_SHIFT)
#define  SSPA_RX_FIFO_NUMSAMPLES_NUMSAMPLES_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_FIFO_NUMSAMPLES_NUMSAMPLES_MASK) | (((uint32_t)val) << SSPA_RX_FIFO_NUMSAMPLES_NUMSAMPLES_SHIFT))

//====================================================================
//Register: Rx Fifo Depth Register (Rx_Fifo_Depth)
//====================================================================

#define  SSPA_RX_FIFO_DEPTH_RESERVED1_MASK 0xffffff00
#define  SSPA_RX_FIFO_DEPTH_RESERVED1_SHIFT 8
#define  SSPA_RX_FIFO_DEPTH_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_RX_FIFO_DEPTH_RESERVED1_MASK) >> SSPA_RX_FIFO_DEPTH_RESERVED1_SHIFT)
#define  SSPA_RX_FIFO_DEPTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_FIFO_DEPTH_RESERVED1_MASK) | (((uint32_t)val) << SSPA_RX_FIFO_DEPTH_RESERVED1_SHIFT))

#define  SSPA_RX_FIFO_DEPTH_DEPTH_MASK 0xff
#define  SSPA_RX_FIFO_DEPTH_DEPTH_SHIFT 0
#define  SSPA_RX_FIFO_DEPTH_DEPTH_MASK_SHIFT(reg) (((reg) & SSPA_RX_FIFO_DEPTH_DEPTH_MASK) >> SSPA_RX_FIFO_DEPTH_DEPTH_SHIFT)
#define  SSPA_RX_FIFO_DEPTH_DEPTH_REPLACE_VAL(reg,val) (((reg) & ~SSPA_RX_FIFO_DEPTH_DEPTH_MASK) | (((uint32_t)val) << SSPA_RX_FIFO_DEPTH_DEPTH_SHIFT))

//====================================================================
//Register: Transmit Data Register (Tx_Data_Reg)
//====================================================================

#define  SSPA_TX_DATA_REG_FIFODATA_MASK 0xffffffff
#define  SSPA_TX_DATA_REG_FIFODATA_SHIFT 0
#define  SSPA_TX_DATA_REG_FIFODATA_MASK_SHIFT(reg) (((reg) & SSPA_TX_DATA_REG_FIFODATA_MASK) >> SSPA_TX_DATA_REG_FIFODATA_SHIFT)
#define  SSPA_TX_DATA_REG_FIFODATA_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_DATA_REG_FIFODATA_MASK) | (((uint32_t)val) << SSPA_TX_DATA_REG_FIFODATA_SHIFT))

//====================================================================
//Register: Transmit Channel Identification Register (Tx_Channel_Ident)
//====================================================================

#define  SSPA_TX_CHANNEL_IDENT_RESERVED1_MASK 0xffffff00
#define  SSPA_TX_CHANNEL_IDENT_RESERVED1_SHIFT 8
#define  SSPA_TX_CHANNEL_IDENT_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_TX_CHANNEL_IDENT_RESERVED1_MASK) >> SSPA_TX_CHANNEL_IDENT_RESERVED1_SHIFT)
#define  SSPA_TX_CHANNEL_IDENT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_CHANNEL_IDENT_RESERVED1_MASK) | (((uint32_t)val) << SSPA_TX_CHANNEL_IDENT_RESERVED1_SHIFT))

#define  SSPA_TX_CHANNEL_IDENT_CHANIDENT_MASK 0xff
#define  SSPA_TX_CHANNEL_IDENT_CHANIDENT_SHIFT 0
#define  SSPA_TX_CHANNEL_IDENT_CHANIDENT_MASK_SHIFT(reg) (((reg) & SSPA_TX_CHANNEL_IDENT_CHANIDENT_MASK) >> SSPA_TX_CHANNEL_IDENT_CHANIDENT_SHIFT)
#define  SSPA_TX_CHANNEL_IDENT_CHANIDENT_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_CHANNEL_IDENT_CHANIDENT_MASK) | (((uint32_t)val) << SSPA_TX_CHANNEL_IDENT_CHANIDENT_SHIFT))

//====================================================================
//Register: Transmit Configuration Register (TxCfg)
//====================================================================

#define  SSPA_TXCFG_TXPHASE_MASK 0x80000000
#define  SSPA_TXCFG_TXPHASE_SHIFT 31
#define  SSPA_TXCFG_TXPHASE_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_TXPHASE_MASK) >> SSPA_TXCFG_TXPHASE_SHIFT)
#define  SSPA_TXCFG_TXPHASE_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_TXPHASE_MASK) | (((uint32_t)val) << SSPA_TXCFG_TXPHASE_SHIFT))

#define  SSPA_TXCFG_TXCHANNELS2_MASK 0x7f000000
#define  SSPA_TXCFG_TXCHANNELS2_SHIFT 24
#define  SSPA_TXCFG_TXCHANNELS2_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_TXCHANNELS2_MASK) >> SSPA_TXCFG_TXCHANNELS2_SHIFT)
#define  SSPA_TXCFG_TXCHANNELS2_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_TXCHANNELS2_MASK) | (((uint32_t)val) << SSPA_TXCFG_TXCHANNELS2_SHIFT))

#define  SSPA_TXCFG_TXWORDLEN2_MASK 0xe00000
#define  SSPA_TXCFG_TXWORDLEN2_SHIFT 21
#define  SSPA_TXCFG_TXWORDLEN2_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_TXWORDLEN2_MASK) >> SSPA_TXCFG_TXWORDLEN2_SHIFT)
#define  SSPA_TXCFG_TXWORDLEN2_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_TXWORDLEN2_MASK) | (((uint32_t)val) << SSPA_TXCFG_TXWORDLEN2_SHIFT))

#define  SSPA_TXCFG_TXDATDLY_MASK 0x180000
#define  SSPA_TXCFG_TXDATDLY_SHIFT 19
#define  SSPA_TXCFG_TXDATDLY_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_TXDATDLY_MASK) >> SSPA_TXCFG_TXDATDLY_SHIFT)
#define  SSPA_TXCFG_TXDATDLY_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_TXDATDLY_MASK) | (((uint32_t)val) << SSPA_TXCFG_TXDATDLY_SHIFT))

#define  SSPA_TXCFG_TXSMPLSIZE2_MASK 0x70000
#define  SSPA_TXCFG_TXSMPLSIZE2_SHIFT 16
#define  SSPA_TXCFG_TXSMPLSIZE2_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_TXSMPLSIZE2_MASK) >> SSPA_TXCFG_TXSMPLSIZE2_SHIFT)
#define  SSPA_TXCFG_TXSMPLSIZE2_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_TXSMPLSIZE2_MASK) | (((uint32_t)val) << SSPA_TXCFG_TXSMPLSIZE2_SHIFT))

#define  SSPA_TXCFG_TXEMPTY_MASK 0x8000
#define  SSPA_TXCFG_TXEMPTY_SHIFT 15
#define  SSPA_TXCFG_TXEMPTY_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_TXEMPTY_MASK) >> SSPA_TXCFG_TXEMPTY_SHIFT)
#define  SSPA_TXCFG_TXEMPTY_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_TXEMPTY_MASK) | (((uint32_t)val) << SSPA_TXCFG_TXEMPTY_SHIFT))

#define  SSPA_TXCFG_TXCHANNELS1_MASK 0x7f00
#define  SSPA_TXCFG_TXCHANNELS1_SHIFT 8
#define  SSPA_TXCFG_TXCHANNELS1_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_TXCHANNELS1_MASK) >> SSPA_TXCFG_TXCHANNELS1_SHIFT)
#define  SSPA_TXCFG_TXCHANNELS1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_TXCHANNELS1_MASK) | (((uint32_t)val) << SSPA_TXCFG_TXCHANNELS1_SHIFT))

#define  SSPA_TXCFG_TXWORDLEN1_MASK 0xe0
#define  SSPA_TXCFG_TXWORDLEN1_SHIFT 5
#define  SSPA_TXCFG_TXWORDLEN1_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_TXWORDLEN1_MASK) >> SSPA_TXCFG_TXWORDLEN1_SHIFT)
#define  SSPA_TXCFG_TXWORDLEN1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_TXWORDLEN1_MASK) | (((uint32_t)val) << SSPA_TXCFG_TXWORDLEN1_SHIFT))

#define  SSPA_TXCFG_RESERVED1_MASK 0x10
#define  SSPA_TXCFG_RESERVED1_SHIFT 4
#define  SSPA_TXCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_RESERVED1_MASK) >> SSPA_TXCFG_RESERVED1_SHIFT)
#define  SSPA_TXCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_RESERVED1_MASK) | (((uint32_t)val) << SSPA_TXCFG_RESERVED1_SHIFT))

#define  SSPA_TXCFG_TXJUSTIFY_MASK 0x8
#define  SSPA_TXCFG_TXJUSTIFY_SHIFT 3
#define  SSPA_TXCFG_TXJUSTIFY_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_TXJUSTIFY_MASK) >> SSPA_TXCFG_TXJUSTIFY_SHIFT)
#define  SSPA_TXCFG_TXJUSTIFY_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_TXJUSTIFY_MASK) | (((uint32_t)val) << SSPA_TXCFG_TXJUSTIFY_SHIFT))

#define  SSPA_TXCFG_TXSMPLSIZE1_MASK 0x7
#define  SSPA_TXCFG_TXSMPLSIZE1_SHIFT 0
#define  SSPA_TXCFG_TXSMPLSIZE1_MASK_SHIFT(reg) (((reg) & SSPA_TXCFG_TXSMPLSIZE1_MASK) >> SSPA_TXCFG_TXSMPLSIZE1_SHIFT)
#define  SSPA_TXCFG_TXSMPLSIZE1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXCFG_TXSMPLSIZE1_MASK) | (((uint32_t)val) << SSPA_TXCFG_TXSMPLSIZE1_SHIFT))

//====================================================================
//Register: Transmit Serial Control Register (TxSerialCtrl)
//====================================================================

#define  SSPA_TXSERIALCTRL_WEN_MASK 0x80000000
#define  SSPA_TXSERIALCTRL_WEN_SHIFT 31
#define  SSPA_TXSERIALCTRL_WEN_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_WEN_MASK) >> SSPA_TXSERIALCTRL_WEN_SHIFT)
#define  SSPA_TXSERIALCTRL_WEN_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_WEN_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_WEN_SHIFT))

#define  SSPA_TXSERIALCTRL_RESERVED1_MASK 0x70000000
#define  SSPA_TXSERIALCTRL_RESERVED1_SHIFT 28
#define  SSPA_TXSERIALCTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_RESERVED1_MASK) >> SSPA_TXSERIALCTRL_RESERVED1_SHIFT)
#define  SSPA_TXSERIALCTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_RESERVED1_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_RESERVED1_SHIFT))

#define  SSPA_TXSERIALCTRL_FSYNCWIDTH_MASK 0xff00000
#define  SSPA_TXSERIALCTRL_FSYNCWIDTH_SHIFT 20
#define  SSPA_TXSERIALCTRL_FSYNCWIDTH_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_FSYNCWIDTH_MASK) >> SSPA_TXSERIALCTRL_FSYNCWIDTH_SHIFT)
#define  SSPA_TXSERIALCTRL_FSYNCWIDTH_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_FSYNCWIDTH_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_FSYNCWIDTH_SHIFT))

#define  SSPA_TXSERIALCTRL_RESERVED2_MASK 0x80000
#define  SSPA_TXSERIALCTRL_RESERVED2_SHIFT 19
#define  SSPA_TXSERIALCTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_RESERVED2_MASK) >> SSPA_TXSERIALCTRL_RESERVED2_SHIFT)
#define  SSPA_TXSERIALCTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_RESERVED2_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_RESERVED2_SHIFT))

#define  SSPA_TXSERIALCTRL_MASTERSLAVE_MASK 0x40000
#define  SSPA_TXSERIALCTRL_MASTERSLAVE_SHIFT 18
#define  SSPA_TXSERIALCTRL_MASTERSLAVE_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_MASTERSLAVE_MASK) >> SSPA_TXSERIALCTRL_MASTERSLAVE_SHIFT)
#define  SSPA_TXSERIALCTRL_MASTERSLAVE_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_MASTERSLAVE_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_MASTERSLAVE_SHIFT))

#define  SSPA_TXSERIALCTRL_SCLKPOL_MASK 0x20000
#define  SSPA_TXSERIALCTRL_SCLKPOL_SHIFT 17
#define  SSPA_TXSERIALCTRL_SCLKPOL_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_SCLKPOL_MASK) >> SSPA_TXSERIALCTRL_SCLKPOL_SHIFT)
#define  SSPA_TXSERIALCTRL_SCLKPOL_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_SCLKPOL_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_SCLKPOL_SHIFT))

#define  SSPA_TXSERIALCTRL_FSYNCPOL_MASK 0x10000
#define  SSPA_TXSERIALCTRL_FSYNCPOL_SHIFT 16
#define  SSPA_TXSERIALCTRL_FSYNCPOL_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_FSYNCPOL_MASK) >> SSPA_TXSERIALCTRL_FSYNCPOL_SHIFT)
#define  SSPA_TXSERIALCTRL_FSYNCPOL_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_FSYNCPOL_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_FSYNCPOL_SHIFT))

#define  SSPA_TXSERIALCTRL_FRAMEPER_MASK 0xfff0
#define  SSPA_TXSERIALCTRL_FRAMEPER_SHIFT 4
#define  SSPA_TXSERIALCTRL_FRAMEPER_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_FRAMEPER_MASK) >> SSPA_TXSERIALCTRL_FRAMEPER_SHIFT)
#define  SSPA_TXSERIALCTRL_FRAMEPER_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_FRAMEPER_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_FRAMEPER_SHIFT))

#define  SSPA_TXSERIALCTRL_RESERVED3_MASK 0x8
#define  SSPA_TXSERIALCTRL_RESERVED3_SHIFT 3
#define  SSPA_TXSERIALCTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_RESERVED3_MASK) >> SSPA_TXSERIALCTRL_RESERVED3_SHIFT)
#define  SSPA_TXSERIALCTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_RESERVED3_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_RESERVED3_SHIFT))

#define  SSPA_TXSERIALCTRL_FIFOFLUSH_MASK 0x4
#define  SSPA_TXSERIALCTRL_FIFOFLUSH_SHIFT 2
#define  SSPA_TXSERIALCTRL_FIFOFLUSH_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_FIFOFLUSH_MASK) >> SSPA_TXSERIALCTRL_FIFOFLUSH_SHIFT)
#define  SSPA_TXSERIALCTRL_FIFOFLUSH_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_FIFOFLUSH_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_FIFOFLUSH_SHIFT))

#define  SSPA_TXSERIALCTRL_SERIALRESET_MASK 0x2
#define  SSPA_TXSERIALCTRL_SERIALRESET_SHIFT 1
#define  SSPA_TXSERIALCTRL_SERIALRESET_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_SERIALRESET_MASK) >> SSPA_TXSERIALCTRL_SERIALRESET_SHIFT)
#define  SSPA_TXSERIALCTRL_SERIALRESET_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_SERIALRESET_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_SERIALRESET_SHIFT))

#define  SSPA_TXSERIALCTRL_SERIALENABLE_MASK 0x1
#define  SSPA_TXSERIALCTRL_SERIALENABLE_SHIFT 0
#define  SSPA_TXSERIALCTRL_SERIALENABLE_MASK_SHIFT(reg) (((reg) & SSPA_TXSERIALCTRL_SERIALENABLE_MASK) >> SSPA_TXSERIALCTRL_SERIALENABLE_SHIFT)
#define  SSPA_TXSERIALCTRL_SERIALENABLE_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TXSERIALCTRL_SERIALENABLE_MASK) | (((uint32_t)val) << SSPA_TXSERIALCTRL_SERIALENABLE_SHIFT))

//====================================================================
//Register: Transmit Fifo Lower Limit Register (Tx_Fifo_LL)
//====================================================================

#define  SSPA_TX_FIFO_LL_RESERVED1_MASK 0xffff0000
#define  SSPA_TX_FIFO_LL_RESERVED1_SHIFT 16
#define  SSPA_TX_FIFO_LL_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_TX_FIFO_LL_RESERVED1_MASK) >> SSPA_TX_FIFO_LL_RESERVED1_SHIFT)
#define  SSPA_TX_FIFO_LL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_FIFO_LL_RESERVED1_MASK) | (((uint32_t)val) << SSPA_TX_FIFO_LL_RESERVED1_SHIFT))

#define  SSPA_TX_FIFO_LL_LOWERLIMIT_MASK 0xffff
#define  SSPA_TX_FIFO_LL_LOWERLIMIT_SHIFT 0
#define  SSPA_TX_FIFO_LL_LOWERLIMIT_MASK_SHIFT(reg) (((reg) & SSPA_TX_FIFO_LL_LOWERLIMIT_MASK) >> SSPA_TX_FIFO_LL_LOWERLIMIT_SHIFT)
#define  SSPA_TX_FIFO_LL_LOWERLIMIT_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_FIFO_LL_LOWERLIMIT_MASK) | (((uint32_t)val) << SSPA_TX_FIFO_LL_LOWERLIMIT_SHIFT))

//====================================================================
//Register: Transmit Interrupt Register (Tx_Int)
//====================================================================

#define  SSPA_TX_INT_RESERVED1_MASK 0xfffe0000
#define  SSPA_TX_INT_RESERVED1_SHIFT 17
#define  SSPA_TX_INT_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_TX_INT_RESERVED1_MASK) >> SSPA_TX_INT_RESERVED1_SHIFT)
#define  SSPA_TX_INT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_INT_RESERVED1_MASK) | (((uint32_t)val) << SSPA_TX_INT_RESERVED1_SHIFT))

#define  SSPA_TX_INT_FIFOLIMITINTPEND_MASK 0x10000
#define  SSPA_TX_INT_FIFOLIMITINTPEND_SHIFT 16
#define  SSPA_TX_INT_FIFOLIMITINTPEND_MASK_SHIFT(reg) (((reg) & SSPA_TX_INT_FIFOLIMITINTPEND_MASK) >> SSPA_TX_INT_FIFOLIMITINTPEND_SHIFT)
#define  SSPA_TX_INT_FIFOLIMITINTPEND_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_INT_FIFOLIMITINTPEND_MASK) | (((uint32_t)val) << SSPA_TX_INT_FIFOLIMITINTPEND_SHIFT))

#define  SSPA_TX_INT_RESERVED2_MASK 0xfffe
#define  SSPA_TX_INT_RESERVED2_SHIFT 1
#define  SSPA_TX_INT_RESERVED2_MASK_SHIFT(reg) (((reg) & SSPA_TX_INT_RESERVED2_MASK) >> SSPA_TX_INT_RESERVED2_SHIFT)
#define  SSPA_TX_INT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_INT_RESERVED2_MASK) | (((uint32_t)val) << SSPA_TX_INT_RESERVED2_SHIFT))

#define  SSPA_TX_INT_FIFOINTMASK_MASK 0x1
#define  SSPA_TX_INT_FIFOINTMASK_SHIFT 0
#define  SSPA_TX_INT_FIFOINTMASK_MASK_SHIFT(reg) (((reg) & SSPA_TX_INT_FIFOINTMASK_MASK) >> SSPA_TX_INT_FIFOINTMASK_SHIFT)
#define  SSPA_TX_INT_FIFOINTMASK_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_INT_FIFOINTMASK_MASK) | (((uint32_t)val) << SSPA_TX_INT_FIFOINTMASK_SHIFT))

//====================================================================
//Register: Transmit Core Version Register (Tx_IPCore_Version)
//====================================================================

#define  SSPA_TX_IPCORE_VERSION_COREFAMILY_MASK 0xff000000
#define  SSPA_TX_IPCORE_VERSION_COREFAMILY_SHIFT 24
#define  SSPA_TX_IPCORE_VERSION_COREFAMILY_MASK_SHIFT(reg) (((reg) & SSPA_TX_IPCORE_VERSION_COREFAMILY_MASK) >> SSPA_TX_IPCORE_VERSION_COREFAMILY_SHIFT)
#define  SSPA_TX_IPCORE_VERSION_COREFAMILY_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_IPCORE_VERSION_COREFAMILY_MASK) | (((uint32_t)val) << SSPA_TX_IPCORE_VERSION_COREFAMILY_SHIFT))

#define  SSPA_TX_IPCORE_VERSION_COREID_MASK 0xff0000
#define  SSPA_TX_IPCORE_VERSION_COREID_SHIFT 16
#define  SSPA_TX_IPCORE_VERSION_COREID_MASK_SHIFT(reg) (((reg) & SSPA_TX_IPCORE_VERSION_COREID_MASK) >> SSPA_TX_IPCORE_VERSION_COREID_SHIFT)
#define  SSPA_TX_IPCORE_VERSION_COREID_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_IPCORE_VERSION_COREID_MASK) | (((uint32_t)val) << SSPA_TX_IPCORE_VERSION_COREID_SHIFT))

#define  SSPA_TX_IPCORE_VERSION_COREVERSION_MASK 0xff00
#define  SSPA_TX_IPCORE_VERSION_COREVERSION_SHIFT 8
#define  SSPA_TX_IPCORE_VERSION_COREVERSION_MASK_SHIFT(reg) (((reg) & SSPA_TX_IPCORE_VERSION_COREVERSION_MASK) >> SSPA_TX_IPCORE_VERSION_COREVERSION_SHIFT)
#define  SSPA_TX_IPCORE_VERSION_COREVERSION_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_IPCORE_VERSION_COREVERSION_MASK) | (((uint32_t)val) << SSPA_TX_IPCORE_VERSION_COREVERSION_SHIFT))

#define  SSPA_TX_IPCORE_VERSION_CORERELEASE_MASK 0xff
#define  SSPA_TX_IPCORE_VERSION_CORERELEASE_SHIFT 0
#define  SSPA_TX_IPCORE_VERSION_CORERELEASE_MASK_SHIFT(reg) (((reg) & SSPA_TX_IPCORE_VERSION_CORERELEASE_MASK) >> SSPA_TX_IPCORE_VERSION_CORERELEASE_SHIFT)
#define  SSPA_TX_IPCORE_VERSION_CORERELEASE_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_IPCORE_VERSION_CORERELEASE_MASK) | (((uint32_t)val) << SSPA_TX_IPCORE_VERSION_CORERELEASE_SHIFT))

//====================================================================
//Register: Number of samples in Tx Fifo Register (Tx_Fifo_NumSamples)
//====================================================================

#define  SSPA_TX_FIFO_NUMSAMPLES_RESERVED1_MASK 0xffffff00
#define  SSPA_TX_FIFO_NUMSAMPLES_RESERVED1_SHIFT 8
#define  SSPA_TX_FIFO_NUMSAMPLES_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_TX_FIFO_NUMSAMPLES_RESERVED1_MASK) >> SSPA_TX_FIFO_NUMSAMPLES_RESERVED1_SHIFT)
#define  SSPA_TX_FIFO_NUMSAMPLES_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_FIFO_NUMSAMPLES_RESERVED1_MASK) | (((uint32_t)val) << SSPA_TX_FIFO_NUMSAMPLES_RESERVED1_SHIFT))

#define  SSPA_TX_FIFO_NUMSAMPLES_NUMSAMPLES_MASK 0xff
#define  SSPA_TX_FIFO_NUMSAMPLES_NUMSAMPLES_SHIFT 0
#define  SSPA_TX_FIFO_NUMSAMPLES_NUMSAMPLES_MASK_SHIFT(reg) (((reg) & SSPA_TX_FIFO_NUMSAMPLES_NUMSAMPLES_MASK) >> SSPA_TX_FIFO_NUMSAMPLES_NUMSAMPLES_SHIFT)
#define  SSPA_TX_FIFO_NUMSAMPLES_NUMSAMPLES_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_FIFO_NUMSAMPLES_NUMSAMPLES_MASK) | (((uint32_t)val) << SSPA_TX_FIFO_NUMSAMPLES_NUMSAMPLES_SHIFT))

//====================================================================
//Register: Tx Fifo Depth Register (Tx_Fifo_Depth)
//====================================================================

#define  SSPA_TX_FIFO_DEPTH_RESERVED1_MASK 0xffffff00
#define  SSPA_TX_FIFO_DEPTH_RESERVED1_SHIFT 8
#define  SSPA_TX_FIFO_DEPTH_RESERVED1_MASK_SHIFT(reg) (((reg) & SSPA_TX_FIFO_DEPTH_RESERVED1_MASK) >> SSPA_TX_FIFO_DEPTH_RESERVED1_SHIFT)
#define  SSPA_TX_FIFO_DEPTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_FIFO_DEPTH_RESERVED1_MASK) | (((uint32_t)val) << SSPA_TX_FIFO_DEPTH_RESERVED1_SHIFT))

#define  SSPA_TX_FIFO_DEPTH_DEPTH_MASK 0xff
#define  SSPA_TX_FIFO_DEPTH_DEPTH_SHIFT 0
#define  SSPA_TX_FIFO_DEPTH_DEPTH_MASK_SHIFT(reg) (((reg) & SSPA_TX_FIFO_DEPTH_DEPTH_MASK) >> SSPA_TX_FIFO_DEPTH_DEPTH_SHIFT)
#define  SSPA_TX_FIFO_DEPTH_DEPTH_REPLACE_VAL(reg,val) (((reg) & ~SSPA_TX_FIFO_DEPTH_DEPTH_MASK) | (((uint32_t)val) << SSPA_TX_FIFO_DEPTH_DEPTH_SHIFT))

#endif // SSPA
