 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 */

 // Midas:    V1.03 Sat Nov  3 14:22:15 PDT 2012
 // Usergen:  V1.00
 // Path:     /proj/iip1/wa/gunruh/iip_fe/modules/SQU/xml
 // Cmdline:  midas -usergen /proj/iip1/wa/gunruh/iip_fe/nve/tools/midas/gen_cmask.tcl SQU.tcl -o ../unit_test/include/SQU_regmasks.h


#ifndef _SQU_REGMASKS_H_
#define _SQU_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

// ====================================================================
//
// Register File: SQU (SQU)
//
// ====================================================================


// ====================================================================
// Register: SQU Control 0 Register (SQU_CTRL_0)
// ====================================================================

#define SQU_SQU_CTRL_0_FIXPRIORITY_MASK 0x800000
#define SQU_SQU_CTRL_0_FIXPRIORITY_SHIFT 23
#define SQU_SQU_CTRL_0_FIXPRIORITY_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_0_FIXPRIORITY_MASK) >> SQU_SQU_CTRL_0_FIXPRIORITY_SHIFT)
#define SQU_SQU_CTRL_0_FIXPRIORITY_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_0_FIXPRIORITY_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_0_FIXPRIORITY_SHIFT))

#define SQU_SQU_CTRL_0_SECURE_WRITE_BK0_MASK 0x400000
#define SQU_SQU_CTRL_0_SECURE_WRITE_BK0_SHIFT 22
#define SQU_SQU_CTRL_0_SECURE_WRITE_BK0_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_0_SECURE_WRITE_BK0_MASK) >> SQU_SQU_CTRL_0_SECURE_WRITE_BK0_SHIFT)
#define SQU_SQU_CTRL_0_SECURE_WRITE_BK0_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_0_SECURE_WRITE_BK0_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_0_SECURE_WRITE_BK0_SHIFT))

#define SQU_SQU_CTRL_0_SECURE_READ_BK0_MASK 0x200000
#define SQU_SQU_CTRL_0_SECURE_READ_BK0_SHIFT 21
#define SQU_SQU_CTRL_0_SECURE_READ_BK0_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_0_SECURE_READ_BK0_MASK) >> SQU_SQU_CTRL_0_SECURE_READ_BK0_SHIFT)
#define SQU_SQU_CTRL_0_SECURE_READ_BK0_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_0_SECURE_READ_BK0_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_0_SECURE_READ_BK0_SHIFT))


// ====================================================================
// Register: SQU Control 1 Register (SQU_CTRL_1)
// ====================================================================

#define SQU_SQU_CTRL_1_FIXPRIORITY2_MASK 0x800000
#define SQU_SQU_CTRL_1_FIXPRIORITY2_SHIFT 23
#define SQU_SQU_CTRL_1_FIXPRIORITY2_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_1_FIXPRIORITY2_MASK) >> SQU_SQU_CTRL_1_FIXPRIORITY2_SHIFT)
#define SQU_SQU_CTRL_1_FIXPRIORITY2_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_1_FIXPRIORITY2_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_1_FIXPRIORITY2_SHIFT))

#define SQU_SQU_CTRL_1_SECURE_WRITE_BK2_MASK 0x400000
#define SQU_SQU_CTRL_1_SECURE_WRITE_BK2_SHIFT 22
#define SQU_SQU_CTRL_1_SECURE_WRITE_BK2_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_1_SECURE_WRITE_BK2_MASK) >> SQU_SQU_CTRL_1_SECURE_WRITE_BK2_SHIFT)
#define SQU_SQU_CTRL_1_SECURE_WRITE_BK2_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_1_SECURE_WRITE_BK2_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_1_SECURE_WRITE_BK2_SHIFT))

#define SQU_SQU_CTRL_1_SECURE_READ_BK2_MASK 0x200000
#define SQU_SQU_CTRL_1_SECURE_READ_BK2_SHIFT 21
#define SQU_SQU_CTRL_1_SECURE_READ_BK2_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_1_SECURE_READ_BK2_MASK) >> SQU_SQU_CTRL_1_SECURE_READ_BK2_SHIFT)
#define SQU_SQU_CTRL_1_SECURE_READ_BK2_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_1_SECURE_READ_BK2_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_1_SECURE_READ_BK2_SHIFT))

#define SQU_SQU_CTRL_1_FIXPRIORITY1_MASK 0x80
#define SQU_SQU_CTRL_1_FIXPRIORITY1_SHIFT 7
#define SQU_SQU_CTRL_1_FIXPRIORITY1_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_1_FIXPRIORITY1_MASK) >> SQU_SQU_CTRL_1_FIXPRIORITY1_SHIFT)
#define SQU_SQU_CTRL_1_FIXPRIORITY1_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_1_FIXPRIORITY1_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_1_FIXPRIORITY1_SHIFT))

#define SQU_SQU_CTRL_1_SECURE_WRITE_BK1_MASK 0x40
#define SQU_SQU_CTRL_1_SECURE_WRITE_BK1_SHIFT 6
#define SQU_SQU_CTRL_1_SECURE_WRITE_BK1_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_1_SECURE_WRITE_BK1_MASK) >> SQU_SQU_CTRL_1_SECURE_WRITE_BK1_SHIFT)
#define SQU_SQU_CTRL_1_SECURE_WRITE_BK1_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_1_SECURE_WRITE_BK1_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_1_SECURE_WRITE_BK1_SHIFT))

#define SQU_SQU_CTRL_1_SECURE_READ_BK1_MASK 0x20
#define SQU_SQU_CTRL_1_SECURE_READ_BK1_SHIFT 5
#define SQU_SQU_CTRL_1_SECURE_READ_BK1_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_1_SECURE_READ_BK1_MASK) >> SQU_SQU_CTRL_1_SECURE_READ_BK1_SHIFT)
#define SQU_SQU_CTRL_1_SECURE_READ_BK1_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_1_SECURE_READ_BK1_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_1_SECURE_READ_BK1_SHIFT))


// ====================================================================
// Register: Performance Counter Control Register (PERF_COUNT_CNTRL)
// ====================================================================

#define SQU_PERF_COUNT_CNTRL_S8_RD_BYTE_COUNT_EN_MASK 0x400
#define SQU_PERF_COUNT_CNTRL_S8_RD_BYTE_COUNT_EN_SHIFT 10
#define SQU_PERF_COUNT_CNTRL_S8_RD_BYTE_COUNT_EN_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_CNTRL_S8_RD_BYTE_COUNT_EN_MASK) >> SQU_PERF_COUNT_CNTRL_S8_RD_BYTE_COUNT_EN_SHIFT)
#define SQU_PERF_COUNT_CNTRL_S8_RD_BYTE_COUNT_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_CNTRL_S8_RD_BYTE_COUNT_EN_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_CNTRL_S8_RD_BYTE_COUNT_EN_SHIFT))

#define SQU_PERF_COUNT_CNTRL_S8_WR_BYTE_COUNT_EN_MASK 0x200
#define SQU_PERF_COUNT_CNTRL_S8_WR_BYTE_COUNT_EN_SHIFT 9
#define SQU_PERF_COUNT_CNTRL_S8_WR_BYTE_COUNT_EN_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_CNTRL_S8_WR_BYTE_COUNT_EN_MASK) >> SQU_PERF_COUNT_CNTRL_S8_WR_BYTE_COUNT_EN_SHIFT)
#define SQU_PERF_COUNT_CNTRL_S8_WR_BYTE_COUNT_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_CNTRL_S8_WR_BYTE_COUNT_EN_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_CNTRL_S8_WR_BYTE_COUNT_EN_SHIFT))

#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S8_MASK 0x100
#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S8_SHIFT 8
#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S8_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_CNTRL_CLR_COUNT_S8_MASK) >> SQU_PERF_COUNT_CNTRL_CLR_COUNT_S8_SHIFT)
#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S8_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_CNTRL_CLR_COUNT_S8_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_CNTRL_CLR_COUNT_S8_SHIFT))

#define SQU_PERF_COUNT_CNTRL_S4_RD_BYTE_COUNT_EN_MASK 0x40
#define SQU_PERF_COUNT_CNTRL_S4_RD_BYTE_COUNT_EN_SHIFT 6
#define SQU_PERF_COUNT_CNTRL_S4_RD_BYTE_COUNT_EN_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_CNTRL_S4_RD_BYTE_COUNT_EN_MASK) >> SQU_PERF_COUNT_CNTRL_S4_RD_BYTE_COUNT_EN_SHIFT)
#define SQU_PERF_COUNT_CNTRL_S4_RD_BYTE_COUNT_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_CNTRL_S4_RD_BYTE_COUNT_EN_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_CNTRL_S4_RD_BYTE_COUNT_EN_SHIFT))

#define SQU_PERF_COUNT_CNTRL_S4_WR_BYTE_COUNT_EN_MASK 0x20
#define SQU_PERF_COUNT_CNTRL_S4_WR_BYTE_COUNT_EN_SHIFT 5
#define SQU_PERF_COUNT_CNTRL_S4_WR_BYTE_COUNT_EN_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_CNTRL_S4_WR_BYTE_COUNT_EN_MASK) >> SQU_PERF_COUNT_CNTRL_S4_WR_BYTE_COUNT_EN_SHIFT)
#define SQU_PERF_COUNT_CNTRL_S4_WR_BYTE_COUNT_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_CNTRL_S4_WR_BYTE_COUNT_EN_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_CNTRL_S4_WR_BYTE_COUNT_EN_SHIFT))

#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S4_MASK 0x10
#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S4_SHIFT 4
#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S4_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_CNTRL_CLR_COUNT_S4_MASK) >> SQU_PERF_COUNT_CNTRL_CLR_COUNT_S4_SHIFT)
#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S4_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_CNTRL_CLR_COUNT_S4_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_CNTRL_CLR_COUNT_S4_SHIFT))

#define SQU_PERF_COUNT_CNTRL_S1_RD_BYTE_COUNT_EN_MASK 0x4
#define SQU_PERF_COUNT_CNTRL_S1_RD_BYTE_COUNT_EN_SHIFT 2
#define SQU_PERF_COUNT_CNTRL_S1_RD_BYTE_COUNT_EN_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_CNTRL_S1_RD_BYTE_COUNT_EN_MASK) >> SQU_PERF_COUNT_CNTRL_S1_RD_BYTE_COUNT_EN_SHIFT)
#define SQU_PERF_COUNT_CNTRL_S1_RD_BYTE_COUNT_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_CNTRL_S1_RD_BYTE_COUNT_EN_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_CNTRL_S1_RD_BYTE_COUNT_EN_SHIFT))

#define SQU_PERF_COUNT_CNTRL_S1_WR_BYTE_COUNT_EN_MASK 0x2
#define SQU_PERF_COUNT_CNTRL_S1_WR_BYTE_COUNT_EN_SHIFT 1
#define SQU_PERF_COUNT_CNTRL_S1_WR_BYTE_COUNT_EN_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_CNTRL_S1_WR_BYTE_COUNT_EN_MASK) >> SQU_PERF_COUNT_CNTRL_S1_WR_BYTE_COUNT_EN_SHIFT)
#define SQU_PERF_COUNT_CNTRL_S1_WR_BYTE_COUNT_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_CNTRL_S1_WR_BYTE_COUNT_EN_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_CNTRL_S1_WR_BYTE_COUNT_EN_SHIFT))

#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S1_MASK 0x1
#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S1_SHIFT 0
#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S1_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_CNTRL_CLR_COUNT_S1_MASK) >> SQU_PERF_COUNT_CNTRL_CLR_COUNT_S1_SHIFT)
#define SQU_PERF_COUNT_CNTRL_CLR_COUNT_S1_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_CNTRL_CLR_COUNT_S1_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_CNTRL_CLR_COUNT_S1_SHIFT))


// ====================================================================
// Register: Performance Count S1 Registers (PERF_COUNT_S1)
// ====================================================================

#define SQU_PERF_COUNT_S1_COUNT_VALUE_MASK 0xffffffff
#define SQU_PERF_COUNT_S1_COUNT_VALUE_SHIFT 0
#define SQU_PERF_COUNT_S1_COUNT_VALUE_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_S1_COUNT_VALUE_MASK) >> SQU_PERF_COUNT_S1_COUNT_VALUE_SHIFT)
#define SQU_PERF_COUNT_S1_COUNT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_S1_COUNT_VALUE_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_S1_COUNT_VALUE_SHIFT))


// ====================================================================
// Register: Performance Count S4 Registers (PERF_COUNT_S4)
// ====================================================================

#define SQU_PERF_COUNT_S4_COUNT_VALUE_MASK 0xffffffff
#define SQU_PERF_COUNT_S4_COUNT_VALUE_SHIFT 0
#define SQU_PERF_COUNT_S4_COUNT_VALUE_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_S4_COUNT_VALUE_MASK) >> SQU_PERF_COUNT_S4_COUNT_VALUE_SHIFT)
#define SQU_PERF_COUNT_S4_COUNT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_S4_COUNT_VALUE_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_S4_COUNT_VALUE_SHIFT))


// ====================================================================
// Register: Performance Count S8 Registers (PERF_COUNT_S8)
// ====================================================================

#define SQU_PERF_COUNT_S8_COUNT_VALUE_MASK 0xffffffff
#define SQU_PERF_COUNT_S8_COUNT_VALUE_SHIFT 0
#define SQU_PERF_COUNT_S8_COUNT_VALUE_MASK_SHIFT(reg) (((reg) & SQU_PERF_COUNT_S8_COUNT_VALUE_MASK) >> SQU_PERF_COUNT_S8_COUNT_VALUE_SHIFT)
#define SQU_PERF_COUNT_S8_COUNT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SQU_PERF_COUNT_S8_COUNT_VALUE_MASK) | (((uint32_t)val) << SQU_PERF_COUNT_S8_COUNT_VALUE_SHIFT))


// ====================================================================
// Register: FIFO_CONTROL Registers (FIFO_CONTROL)
// ====================================================================

#define SQU_FIFO_CONTROL_FIFO_ENABLE_MASK 0x1
#define SQU_FIFO_CONTROL_FIFO_ENABLE_SHIFT 0
#define SQU_FIFO_CONTROL_FIFO_ENABLE_MASK_SHIFT(reg) (((reg) & SQU_FIFO_CONTROL_FIFO_ENABLE_MASK) >> SQU_FIFO_CONTROL_FIFO_ENABLE_SHIFT)
#define SQU_FIFO_CONTROL_FIFO_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~SQU_FIFO_CONTROL_FIFO_ENABLE_MASK) | (((uint32_t)val) << SQU_FIFO_CONTROL_FIFO_ENABLE_SHIFT))


// ====================================================================
// Register: FIFO_RD_ADDR_BASE Registers (FIFO_RD_ADDR_BASE)
// ====================================================================

#define SQU_FIFO_RD_ADDR_BASE_FIFO_RD_ADDR_BASE_MASK 0xf0000
#define SQU_FIFO_RD_ADDR_BASE_FIFO_RD_ADDR_BASE_SHIFT 16
#define SQU_FIFO_RD_ADDR_BASE_FIFO_RD_ADDR_BASE_MASK_SHIFT(reg) (((reg) & SQU_FIFO_RD_ADDR_BASE_FIFO_RD_ADDR_BASE_MASK) >> SQU_FIFO_RD_ADDR_BASE_FIFO_RD_ADDR_BASE_SHIFT)
#define SQU_FIFO_RD_ADDR_BASE_FIFO_RD_ADDR_BASE_REPLACE_VAL(reg,val) (((reg) & ~SQU_FIFO_RD_ADDR_BASE_FIFO_RD_ADDR_BASE_MASK) | (((uint32_t)val) << SQU_FIFO_RD_ADDR_BASE_FIFO_RD_ADDR_BASE_SHIFT))


// ====================================================================
// Register: FIFO_WR_ADDR_BASE Registers (FIFO_WR_ADDR_BASE)
// ====================================================================

#define SQU_FIFO_WR_ADDR_BASE_FIFO_WR_ADDR_BASE_MASK 0xf0000
#define SQU_FIFO_WR_ADDR_BASE_FIFO_WR_ADDR_BASE_SHIFT 16
#define SQU_FIFO_WR_ADDR_BASE_FIFO_WR_ADDR_BASE_MASK_SHIFT(reg) (((reg) & SQU_FIFO_WR_ADDR_BASE_FIFO_WR_ADDR_BASE_MASK) >> SQU_FIFO_WR_ADDR_BASE_FIFO_WR_ADDR_BASE_SHIFT)
#define SQU_FIFO_WR_ADDR_BASE_FIFO_WR_ADDR_BASE_REPLACE_VAL(reg,val) (((reg) & ~SQU_FIFO_WR_ADDR_BASE_FIFO_WR_ADDR_BASE_MASK) | (((uint32_t)val) << SQU_FIFO_WR_ADDR_BASE_FIFO_WR_ADDR_BASE_SHIFT))


// ====================================================================
// Register: FIFO_START_ADDR Registers (FIFO_START_ADDR)
// ====================================================================

#define SQU_FIFO_START_ADDR_FIFO_START_ADDR_MASK 0x3fff8
#define SQU_FIFO_START_ADDR_FIFO_START_ADDR_SHIFT 3
#define SQU_FIFO_START_ADDR_FIFO_START_ADDR_MASK_SHIFT(reg) (((reg) & SQU_FIFO_START_ADDR_FIFO_START_ADDR_MASK) >> SQU_FIFO_START_ADDR_FIFO_START_ADDR_SHIFT)
#define SQU_FIFO_START_ADDR_FIFO_START_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SQU_FIFO_START_ADDR_FIFO_START_ADDR_MASK) | (((uint32_t)val) << SQU_FIFO_START_ADDR_FIFO_START_ADDR_SHIFT))


// ====================================================================
// Register: FIFO_START_ADDR Registers (FIFO_END_ADDR)
// ====================================================================

#define SQU_FIFO_END_ADDR_FIFO_END_ADDR_MASK 0x3fff8
#define SQU_FIFO_END_ADDR_FIFO_END_ADDR_SHIFT 3
#define SQU_FIFO_END_ADDR_FIFO_END_ADDR_MASK_SHIFT(reg) (((reg) & SQU_FIFO_END_ADDR_FIFO_END_ADDR_MASK) >> SQU_FIFO_END_ADDR_FIFO_END_ADDR_SHIFT)
#define SQU_FIFO_END_ADDR_FIFO_END_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SQU_FIFO_END_ADDR_FIFO_END_ADDR_MASK) | (((uint32_t)val) << SQU_FIFO_END_ADDR_FIFO_END_ADDR_SHIFT))


// ====================================================================
// Register: FIFO_LEVEL_1 Registers (FIFO_LEVEL_1)
// ====================================================================

#define SQU_FIFO_LEVEL_1_FIFO_LEVEL_1_MASK 0x3fff8
#define SQU_FIFO_LEVEL_1_FIFO_LEVEL_1_SHIFT 3
#define SQU_FIFO_LEVEL_1_FIFO_LEVEL_1_MASK_SHIFT(reg) (((reg) & SQU_FIFO_LEVEL_1_FIFO_LEVEL_1_MASK) >> SQU_FIFO_LEVEL_1_FIFO_LEVEL_1_SHIFT)
#define SQU_FIFO_LEVEL_1_FIFO_LEVEL_1_REPLACE_VAL(reg,val) (((reg) & ~SQU_FIFO_LEVEL_1_FIFO_LEVEL_1_MASK) | (((uint32_t)val) << SQU_FIFO_LEVEL_1_FIFO_LEVEL_1_SHIFT))


// ====================================================================
// Register: FIFO_LEVEL_2 Registers (FIFO_LEVEL_2)
// ====================================================================

#define SQU_FIFO_LEVEL_2_FIFO_LEVEL_2_MASK 0x3fff8
#define SQU_FIFO_LEVEL_2_FIFO_LEVEL_2_SHIFT 3
#define SQU_FIFO_LEVEL_2_FIFO_LEVEL_2_MASK_SHIFT(reg) (((reg) & SQU_FIFO_LEVEL_2_FIFO_LEVEL_2_MASK) >> SQU_FIFO_LEVEL_2_FIFO_LEVEL_2_SHIFT)
#define SQU_FIFO_LEVEL_2_FIFO_LEVEL_2_REPLACE_VAL(reg,val) (((reg) & ~SQU_FIFO_LEVEL_2_FIFO_LEVEL_2_MASK) | (((uint32_t)val) << SQU_FIFO_LEVEL_2_FIFO_LEVEL_2_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK0_MSTR_ID_WR)
// ====================================================================

#define SQU_SQU_CTRL_BANK0_MSTR_ID_WR_MASTER_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK0_MSTR_ID_WR_MASTER_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK0_MSTR_ID_WR_MASTER_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK0_MSTR_ID_WR_MASTER_ID_MASK) >> SQU_SQU_CTRL_BANK0_MSTR_ID_WR_MASTER_ID_SHIFT)
#define SQU_SQU_CTRL_BANK0_MSTR_ID_WR_MASTER_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK0_MSTR_ID_WR_MASTER_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK0_MSTR_ID_WR_MASTER_ID_SHIFT))

#define SQU_SQU_CTRL_BANK0_MSTR_ID_WR_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK0_MSTR_ID_WR_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK0_MSTR_ID_WR_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK0_MSTR_ID_WR_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK0_MSTR_ID_WR_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK0_MSTR_ID_WR_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK0_MSTR_ID_WR_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK0_MSTR_ID_WR_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK0_MASK_ID_WR)
// ====================================================================

#define SQU_SQU_CTRL_BANK0_MASK_ID_WR_MASK_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK0_MASK_ID_WR_MASK_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK0_MASK_ID_WR_MASK_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK0_MASK_ID_WR_MASK_ID_MASK) >> SQU_SQU_CTRL_BANK0_MASK_ID_WR_MASK_ID_SHIFT)
#define SQU_SQU_CTRL_BANK0_MASK_ID_WR_MASK_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK0_MASK_ID_WR_MASK_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK0_MASK_ID_WR_MASK_ID_SHIFT))

#define SQU_SQU_CTRL_BANK0_MASK_ID_WR_MDMA_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK0_MASK_ID_WR_MDMA_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK0_MASK_ID_WR_MDMA_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK0_MASK_ID_WR_MDMA_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK0_MASK_ID_WR_MDMA_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK0_MASK_ID_WR_MDMA_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK0_MASK_ID_WR_MDMA_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK0_MASK_ID_WR_MDMA_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK1_MSTR_ID_WR)
// ====================================================================

#define SQU_SQU_CTRL_BANK1_MSTR_ID_WR_MASTER_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK1_MSTR_ID_WR_MASTER_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK1_MSTR_ID_WR_MASTER_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK1_MSTR_ID_WR_MASTER_ID_MASK) >> SQU_SQU_CTRL_BANK1_MSTR_ID_WR_MASTER_ID_SHIFT)
#define SQU_SQU_CTRL_BANK1_MSTR_ID_WR_MASTER_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK1_MSTR_ID_WR_MASTER_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK1_MSTR_ID_WR_MASTER_ID_SHIFT))

#define SQU_SQU_CTRL_BANK1_MSTR_ID_WR_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK1_MSTR_ID_WR_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK1_MSTR_ID_WR_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK1_MSTR_ID_WR_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK1_MSTR_ID_WR_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK1_MSTR_ID_WR_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK1_MSTR_ID_WR_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK1_MSTR_ID_WR_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK1_MASK_ID_WR)
// ====================================================================

#define SQU_SQU_CTRL_BANK1_MASK_ID_WR_MASK_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK1_MASK_ID_WR_MASK_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK1_MASK_ID_WR_MASK_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK1_MASK_ID_WR_MASK_ID_MASK) >> SQU_SQU_CTRL_BANK1_MASK_ID_WR_MASK_ID_SHIFT)
#define SQU_SQU_CTRL_BANK1_MASK_ID_WR_MASK_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK1_MASK_ID_WR_MASK_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK1_MASK_ID_WR_MASK_ID_SHIFT))

#define SQU_SQU_CTRL_BANK1_MASK_ID_WR_MDMA_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK1_MASK_ID_WR_MDMA_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK1_MASK_ID_WR_MDMA_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK1_MASK_ID_WR_MDMA_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK1_MASK_ID_WR_MDMA_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK1_MASK_ID_WR_MDMA_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK1_MASK_ID_WR_MDMA_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK1_MASK_ID_WR_MDMA_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK2_MSTR_ID_WR)
// ====================================================================

#define SQU_SQU_CTRL_BANK2_MSTR_ID_WR_MASTER_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK2_MSTR_ID_WR_MASTER_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK2_MSTR_ID_WR_MASTER_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK2_MSTR_ID_WR_MASTER_ID_MASK) >> SQU_SQU_CTRL_BANK2_MSTR_ID_WR_MASTER_ID_SHIFT)
#define SQU_SQU_CTRL_BANK2_MSTR_ID_WR_MASTER_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK2_MSTR_ID_WR_MASTER_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK2_MSTR_ID_WR_MASTER_ID_SHIFT))

#define SQU_SQU_CTRL_BANK2_MSTR_ID_WR_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK2_MSTR_ID_WR_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK2_MSTR_ID_WR_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK2_MSTR_ID_WR_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK2_MSTR_ID_WR_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK2_MSTR_ID_WR_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK2_MSTR_ID_WR_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK2_MSTR_ID_WR_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK2_MASK_ID_WR)
// ====================================================================

#define SQU_SQU_CTRL_BANK2_MASK_ID_WR_MASK_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK2_MASK_ID_WR_MASK_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK2_MASK_ID_WR_MASK_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK2_MASK_ID_WR_MASK_ID_MASK) >> SQU_SQU_CTRL_BANK2_MASK_ID_WR_MASK_ID_SHIFT)
#define SQU_SQU_CTRL_BANK2_MASK_ID_WR_MASK_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK2_MASK_ID_WR_MASK_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK2_MASK_ID_WR_MASK_ID_SHIFT))

#define SQU_SQU_CTRL_BANK2_MASK_ID_WR_MDMA_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK2_MASK_ID_WR_MDMA_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK2_MASK_ID_WR_MDMA_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK2_MASK_ID_WR_MDMA_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK2_MASK_ID_WR_MDMA_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK2_MASK_ID_WR_MDMA_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK2_MASK_ID_WR_MDMA_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK2_MASK_ID_WR_MDMA_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK0_MSTR_ID_RD)
// ====================================================================

#define SQU_SQU_CTRL_BANK0_MSTR_ID_RD_MASTER_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK0_MSTR_ID_RD_MASTER_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK0_MSTR_ID_RD_MASTER_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK0_MSTR_ID_RD_MASTER_ID_MASK) >> SQU_SQU_CTRL_BANK0_MSTR_ID_RD_MASTER_ID_SHIFT)
#define SQU_SQU_CTRL_BANK0_MSTR_ID_RD_MASTER_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK0_MSTR_ID_RD_MASTER_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK0_MSTR_ID_RD_MASTER_ID_SHIFT))

#define SQU_SQU_CTRL_BANK0_MSTR_ID_RD_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK0_MSTR_ID_RD_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK0_MSTR_ID_RD_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK0_MSTR_ID_RD_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK0_MSTR_ID_RD_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK0_MSTR_ID_RD_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK0_MSTR_ID_RD_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK0_MSTR_ID_RD_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK0_MASK_ID_RD)
// ====================================================================

#define SQU_SQU_CTRL_BANK0_MASK_ID_RD_MASK_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK0_MASK_ID_RD_MASK_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK0_MASK_ID_RD_MASK_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK0_MASK_ID_RD_MASK_ID_MASK) >> SQU_SQU_CTRL_BANK0_MASK_ID_RD_MASK_ID_SHIFT)
#define SQU_SQU_CTRL_BANK0_MASK_ID_RD_MASK_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK0_MASK_ID_RD_MASK_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK0_MASK_ID_RD_MASK_ID_SHIFT))

#define SQU_SQU_CTRL_BANK0_MASK_ID_RD_MDMA_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK0_MASK_ID_RD_MDMA_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK0_MASK_ID_RD_MDMA_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK0_MASK_ID_RD_MDMA_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK0_MASK_ID_RD_MDMA_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK0_MASK_ID_RD_MDMA_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK0_MASK_ID_RD_MDMA_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK0_MASK_ID_RD_MDMA_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK1_MSTR_ID_RD)
// ====================================================================

#define SQU_SQU_CTRL_BANK1_MSTR_ID_RD_MASTER_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK1_MSTR_ID_RD_MASTER_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK1_MSTR_ID_RD_MASTER_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK1_MSTR_ID_RD_MASTER_ID_MASK) >> SQU_SQU_CTRL_BANK1_MSTR_ID_RD_MASTER_ID_SHIFT)
#define SQU_SQU_CTRL_BANK1_MSTR_ID_RD_MASTER_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK1_MSTR_ID_RD_MASTER_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK1_MSTR_ID_RD_MASTER_ID_SHIFT))

#define SQU_SQU_CTRL_BANK1_MSTR_ID_RD_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK1_MSTR_ID_RD_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK1_MSTR_ID_RD_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK1_MSTR_ID_RD_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK1_MSTR_ID_RD_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK1_MSTR_ID_RD_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK1_MSTR_ID_RD_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK1_MSTR_ID_RD_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK1_MASK_ID_RD)
// ====================================================================

#define SQU_SQU_CTRL_BANK1_MASK_ID_RD_MASK_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK1_MASK_ID_RD_MASK_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK1_MASK_ID_RD_MASK_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK1_MASK_ID_RD_MASK_ID_MASK) >> SQU_SQU_CTRL_BANK1_MASK_ID_RD_MASK_ID_SHIFT)
#define SQU_SQU_CTRL_BANK1_MASK_ID_RD_MASK_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK1_MASK_ID_RD_MASK_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK1_MASK_ID_RD_MASK_ID_SHIFT))

#define SQU_SQU_CTRL_BANK1_MASK_ID_RD_MDMA_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK1_MASK_ID_RD_MDMA_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK1_MASK_ID_RD_MDMA_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK1_MASK_ID_RD_MDMA_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK1_MASK_ID_RD_MDMA_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK1_MASK_ID_RD_MDMA_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK1_MASK_ID_RD_MDMA_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK1_MASK_ID_RD_MDMA_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK2_MSTR_ID_RD)
// ====================================================================

#define SQU_SQU_CTRL_BANK2_MSTR_ID_RD_MASTER_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK2_MSTR_ID_RD_MASTER_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK2_MSTR_ID_RD_MASTER_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK2_MSTR_ID_RD_MASTER_ID_MASK) >> SQU_SQU_CTRL_BANK2_MSTR_ID_RD_MASTER_ID_SHIFT)
#define SQU_SQU_CTRL_BANK2_MSTR_ID_RD_MASTER_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK2_MSTR_ID_RD_MASTER_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK2_MSTR_ID_RD_MASTER_ID_SHIFT))

#define SQU_SQU_CTRL_BANK2_MSTR_ID_RD_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK2_MSTR_ID_RD_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK2_MSTR_ID_RD_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK2_MSTR_ID_RD_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK2_MSTR_ID_RD_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK2_MSTR_ID_RD_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK2_MSTR_ID_RD_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK2_MSTR_ID_RD_SECURITY_EN_SHIFT))


// ====================================================================
// Register:  (SQU_CTRL_BANK2_MASK_ID_RD)
// ====================================================================

#define SQU_SQU_CTRL_BANK2_MASK_ID_RD_MASK_ID_MASK 0xfffffffe
#define SQU_SQU_CTRL_BANK2_MASK_ID_RD_MASK_ID_SHIFT 1
#define SQU_SQU_CTRL_BANK2_MASK_ID_RD_MASK_ID_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK2_MASK_ID_RD_MASK_ID_MASK) >> SQU_SQU_CTRL_BANK2_MASK_ID_RD_MASK_ID_SHIFT)
#define SQU_SQU_CTRL_BANK2_MASK_ID_RD_MASK_ID_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK2_MASK_ID_RD_MASK_ID_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK2_MASK_ID_RD_MASK_ID_SHIFT))

#define SQU_SQU_CTRL_BANK2_MASK_ID_RD_MDMA_SECURITY_EN_MASK 0x1
#define SQU_SQU_CTRL_BANK2_MASK_ID_RD_MDMA_SECURITY_EN_SHIFT 0
#define SQU_SQU_CTRL_BANK2_MASK_ID_RD_MDMA_SECURITY_EN_MASK_SHIFT(reg) (((reg) & SQU_SQU_CTRL_BANK2_MASK_ID_RD_MDMA_SECURITY_EN_MASK) >> SQU_SQU_CTRL_BANK2_MASK_ID_RD_MDMA_SECURITY_EN_SHIFT)
#define SQU_SQU_CTRL_BANK2_MASK_ID_RD_MDMA_SECURITY_EN_REPLACE_VAL(reg,val) (((reg) & ~SQU_SQU_CTRL_BANK2_MASK_ID_RD_MDMA_SECURITY_EN_MASK) | (((uint32_t)val) << SQU_SQU_CTRL_BANK2_MASK_ID_RD_MDMA_SECURITY_EN_SHIFT))

#endif
