 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SMMU_TOP_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SMMU_TOP_REGMASKS_H_
#define _SMMU_TOP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SMMU_TOP (SMMU_TOP)
/** \brief Register Descriptions for the SMMU Top block*/
//
//====================================================================

//====================================================================
//
//Register File: MMU400 Registers (mmu400_smmu_gr2_a3_ns)
//
//====================================================================

//====================================================================
//Register:  (SMMU_CR0)
/** \brief Non-Secure Configuration register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_WACFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_WACFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RACFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RACFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SHCFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SHCFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SMCFCFG_MASK 0x200000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SMCFCFG_SHIFT 21
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SMCFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SMCFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SMCFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SMCFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SMCFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_SMCFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MTCFG_MASK 0x100000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MTCFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MEMATTR_MASK 0xf0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MEMATTR_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MEMATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MEMATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MEMATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MEMATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MEMATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_MEMATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_BSU_MASK 0xc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_BSU_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_BSU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_BSU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_BSU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_BSU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_BSU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_BSU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_FB_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_FB_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_FB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_FB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_FB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_FB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_FB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_FB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_PTM_MASK 0x1000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_PTM_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_PTM_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_PTM_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_PTM_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_PTM_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_PTM_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_PTM_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_VMIDPNE_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_VMIDPNE_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_VMIDPNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_VMIDPNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_VMIDPNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_VMIDPNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_VMIDPNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_VMIDPNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_USFCFG_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_USFCFG_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_USFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_USFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_USFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_USFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_USFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_USFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GSE_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GSE_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GSE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GSE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GSE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GSE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GSE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GSE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_STALLD_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_STALLD_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_STALLD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_STALLD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_STALLD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_STALLD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_STALLD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_STALLD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED2_MASK 0xc0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED2_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFIE_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFIE_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFIE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFIE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFIE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFIE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFIE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFIE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFRE_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFRE_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GCFGFRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED3_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFIE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFIE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFIE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFIE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFIE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFIE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFIE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFIE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFRE_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFRE_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_GFRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_CLIENTPD_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_CLIENTPD_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_CLIENTPD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CR0_CLIENTPD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CR0_CLIENTPD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CR0_CLIENTPD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CR0_CLIENTPD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CR0_CLIENTPD_SHIFT))

//====================================================================
//Register:  (SMMU_ACR)
/** \brief Non-Secure Auxiliary Configuration register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED1_MASK 0xfffff800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED1_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_S2CR_BPTLBEN_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_S2CR_BPTLBEN_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_S2CR_BPTLBEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ACR_S2CR_BPTLBEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ACR_S2CR_BPTLBEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_S2CR_BPTLBEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ACR_S2CR_BPTLBEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ACR_S2CR_BPTLBEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_MMUDIS_BPTLBEN_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_MMUDIS_BPTLBEN_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_MMUDIS_BPTLBEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ACR_MMUDIS_BPTLBEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ACR_MMUDIS_BPTLBEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_MMUDIS_BPTLBEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ACR_MMUDIS_BPTLBEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ACR_MMUDIS_BPTLBEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_SMTNMC_BPTLBEN_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_SMTNMC_BPTLBEN_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_SMTNMC_BPTLBEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ACR_SMTNMC_BPTLBEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ACR_SMTNMC_BPTLBEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_SMTNMC_BPTLBEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ACR_SMTNMC_BPTLBEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ACR_SMTNMC_BPTLBEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED2_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED2_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ACR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC2EN_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC2EN_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC2EN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC2EN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC2EN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC2EN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC2EN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC2EN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC1EN_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC1EN_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC1EN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC1EN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC1EN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC1EN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC1EN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ACR_WC1EN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_PREFETCH_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_PREFETCH_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_PREFETCH_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ACR_PREFETCH_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ACR_PREFETCH_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ACR_PREFETCH_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ACR_PREFETCH_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ACR_PREFETCH_SHIFT))

//====================================================================
//Register:  (SMMU_IDR0)
/** \brief Non-Secure ID register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SES_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SES_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SES_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SES_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SES_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SES_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SES_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SES_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S1TS_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S1TS_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S1TS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S1TS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S1TS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S1TS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S1TS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S1TS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S2TS_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S2TS_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S2TS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S2TS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S2TS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S2TS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S2TS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_S2TS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NTS_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NTS_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NTS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NTS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NTS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NTS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NTS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NTS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SMS_MASK 0x8000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SMS_SHIFT 27
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SMS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SMS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SMS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SMS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SMS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_SMS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED1_MASK 0x6000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED1_SHIFT 25
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_PTFS_MASK 0x1000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_PTFS_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_PTFS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_PTFS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_PTFS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_PTFS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_PTFS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_PTFS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMIRPT_MASK 0xff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMIRPT_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMIRPT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMIRPT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMIRPT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMIRPT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMIRPT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMIRPT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED2_MASK 0x8000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED2_SHIFT 15
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_CTTW_MASK 0x4000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_CTTW_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_CTTW_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_CTTW_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_CTTW_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_CTTW_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_CTTW_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_CTTW_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_BTM_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_BTM_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_BTM_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_BTM_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_BTM_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_BTM_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_BTM_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_BTM_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSIDB_MASK 0x1e00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSIDB_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSIDB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSIDB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSIDB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSIDB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSIDB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSIDB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED3_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED3_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSMRG_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSMRG_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSMRG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSMRG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSMRG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSMRG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSMRG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR0_NUMSMRG_SHIFT))

//====================================================================
//Register:  (SMMU_IDR1)
/** \brief Non-Secure ID register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_PAGESIZE_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_PAGESIZE_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_PAGESIZE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_PAGESIZE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_PAGESIZE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_PAGESIZE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_PAGESIZE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_PAGESIZE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMPAGENDXB_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMPAGENDXB_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMPAGENDXB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMPAGENDXB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMPAGENDXB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMPAGENDXB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMPAGENDXB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMPAGENDXB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED1_MASK 0xf000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED1_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMS2CB_MASK 0xff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMS2CB_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMS2CB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMS2CB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMS2CB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMS2CB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMS2CB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMS2CB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED2_MASK 0xc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED2_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SMCD_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SMCD_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SMCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SMCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SMCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SMCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SMCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SMCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SSDTP_MASK 0x1000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SSDTP_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SSDTP_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SSDTP_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SSDTP_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SSDTP_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SSDTP_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_SSDTP_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMSSDNDXB_MASK 0xf00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMSSDNDXB_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMSSDNDXB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMSSDNDXB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMSSDNDXB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMSSDNDXB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMSSDNDXB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMSSDNDXB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMCB_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMCB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMCB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMCB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMCB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMCB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMCB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR1_NUMCB_SHIFT))

//====================================================================
//Register:  (SMMU_IDR2)
/** \brief Non-Secure ID register 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_OAS_MASK 0xf0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_OAS_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_OAS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_OAS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_OAS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_OAS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_OAS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_OAS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_IAS_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_IAS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_IAS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_IAS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_IAS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_IAS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_IAS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR2_IAS_SHIFT))

//====================================================================
//Register:  (SMMU_IDR7)
/** \brief Non-Secure ID register 7*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MAJOR_MASK 0xf0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MAJOR_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MAJOR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MAJOR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MAJOR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MAJOR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MAJOR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MAJOR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MINOR_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MINOR_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MINOR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MINOR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MINOR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MINOR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MINOR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_IDR7_MINOR_SHIFT))

//====================================================================
//Register:  (SMMU_GFAR_LOW)
/** \brief Non-Secure Global Fault Address register Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_GFAR_HIGH)
/** \brief Non-Secure Global Fault Address register Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFAR_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_GFSR)
/** \brief Non-Secure Global Fault Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_MULTI_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_MULTI_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_MULTI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_MULTI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_MULTI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_MULTI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_MULTI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_MULTI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_RESERVED1_MASK 0x7fffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_PF_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_PF_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_PF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_PF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_PF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_PF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_PF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_PF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_EF_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_EF_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_EF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_EF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_EF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_EF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_EF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_EF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_CAF_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_CAF_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_CAF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_CAF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_CAF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_CAF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_CAF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_CAF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCIF_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCIF_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCIF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCIF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCIF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCIF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCIF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCIF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCBF_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCBF_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCBF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCBF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCBF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCBF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCBF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_UCBF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_SMCF_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_SMCF_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_SMCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_SMCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_SMCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_SMCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_SMCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_SMCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_USF_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_USF_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_USF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_USF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_USF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_USF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_USF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_USF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_ICF_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_ICF_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_ICF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_ICF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_ICF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_ICF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_ICF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSR_ICF_SHIFT))

//====================================================================
//Register:  (SMMU_GFSRRESTORE)
/** \brief Non-Secure Global Fault Status Restore register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSRRESTORE_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSRRESTORE_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSRRESTORE_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSRRESTORE_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSRRESTORE_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSRRESTORE_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSRRESTORE_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSRRESTORE_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_GFSYNDR0)
/** \brief Non-Secure Global Fault Syndrome register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_RESERVED1_MASK 0xffffffc0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_RESERVED1_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSATTR_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSATTR_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSSTATE_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSSTATE_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSSTATE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSSTATE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSSTATE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSSTATE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSSTATE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NSSTATE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_IND_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_IND_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_IND_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_IND_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_IND_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_IND_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_IND_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_IND_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_PNU_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_PNU_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_PNU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_PNU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_PNU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_PNU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_PNU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_PNU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_WNR_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_WNR_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_WNR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_WNR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_WNR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_WNR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_WNR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_WNR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NESTED_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NESTED_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NESTED_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NESTED_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NESTED_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NESTED_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NESTED_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR0_NESTED_SHIFT))

//====================================================================
//Register:  (SMMU_GFSYNDR1)
/** \brief Non-Secure Global Fault Syndrome register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_RESERVED1_MASK 0xfffff000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_RESERVED1_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_STREAM_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_STREAM_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_STREAM_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_STREAM_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_STREAM_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_STREAM_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_STREAM_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_GFSYNDR1_STREAM_ID_SHIFT))

//====================================================================
//Register:  (SMMU_TLBIVMID)
/** \brief Non-Secure Global Invalidate TLB by VMID*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_BITS_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_BITS_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_BITS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_VMID_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_VMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_VMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_VMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_VMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_VMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_VMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_TLBIVMID_VMID_SHIFT))

//====================================================================
//Register:  (SMMU_TLBIALLNSNH)
/** \brief Non-Secure Global TLB invalidate entire non-secure non-hyp TLB*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIALLNSNH_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIALLNSNH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIALLNSNH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_TLBIALLNSNH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_TLBIALLNSNH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBIALLNSNH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_TLBIALLNSNH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_TLBIALLNSNH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_TLBGSYNC)
/** \brief Non-Secure TLB Global Synchronize*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSYNC_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSYNC_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSYNC_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSYNC_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSYNC_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSYNC_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSYNC_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSYNC_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_TLBGSTATUS)
/** \brief Non-Secure TLB Global Status*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_RESERVED1_MASK 0xfffffffe
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_RESERVED1_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_GSACTIVE_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_GSACTIVE_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_GSACTIVE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_GSACTIVE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_GSACTIVE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_GSACTIVE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_GSACTIVE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_TLBGSTATUS_GSACTIVE_SHIFT))

//====================================================================
//Register:  (SMMU_SMR0)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR0_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR1)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR1_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR2)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR2_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR3)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR3_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR4)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR4_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR5)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR5_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR6)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR6_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR7)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR7_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR8)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR8_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR9)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR9_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR10)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR10_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR11)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR11_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR12)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR12_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR13)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR13_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR14)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR14_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR15)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR15_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR16)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR16_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR17)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR17_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR18)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR18_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR19)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR19_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR20)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR20_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR21)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR21_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR22)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR22_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR23)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR23_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR24)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR24_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR25)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR25_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR26)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR26_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR27)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR27_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR28)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR28_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR29)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR29_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR30)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR30_ID_SHIFT))

//====================================================================
//Register:  (SMMU_SMR31)
/** \brief Stream Match register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_VALID_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_VALID_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_VALID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_VALID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_VALID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_VALID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_VALID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_VALID_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED1_MASK 0x70000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_SMR31_ID_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR0)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR0_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR1)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR1_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR2)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR2_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR3)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR3_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR4)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR4_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR5)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR5_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR6)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR6_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR7)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR7_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR8)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR8_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR9)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR9_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR10)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR10_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR11)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR11_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR12)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR12_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR13)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR13_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR14)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR14_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR15)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR15_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR16)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR16_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR17)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR17_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR18)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR18_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR19)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR19_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR20)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR20_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR21)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR21_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR22)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR22_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR23)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR23_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR24)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR24_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR25)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR25_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR26)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR26_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR27)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR27_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR28)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR28_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR29)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR29_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR30)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR30_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_S2CR31)
/** \brief Stream 2 Context register Context Translation*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_INSTCFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_INSTCFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_INSTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_INSTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_INSTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_INSTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_INSTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_INSTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_PRIVCFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_PRIVCFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_PRIVCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_PRIVCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_PRIVCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_PRIVCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_PRIVCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_PRIVCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_WACFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_WACFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RACFG_MASK 0x300000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RACFG_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_NSCFG_MASK 0xc0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_NSCFG_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_NSCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_NSCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_NSCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_NSCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_NSCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_NSCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_TYPE_MASK 0x30000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_TYPE_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_TYPE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_TYPE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_TYPE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_TYPE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_TYPE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MEM_ATTR_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MEM_ATTR_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MTCFG_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MTCFG_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MTCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MTCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MTCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MTCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MTCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_MTCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED2_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED2_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_SHCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_SHCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED3_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED3_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_CBNDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_CBNDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_S2CR31_CBNDX_SHIFT))

//====================================================================
//Register:  (SMMU_CBAR0)
/** \brief Context Bank 0 Attribute register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_IRPTNDX_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_IRPTNDX_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_IRPTNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_IRPTNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_IRPTNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_IRPTNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_IRPTNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_IRPTNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_RESERVED1_MASK 0xffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_VMID_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_VMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_VMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_VMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_VMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_VMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_VMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR0_VMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBAR1)
/** \brief Context Bank 1 Attribute register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_IRPTNDX_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_IRPTNDX_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_IRPTNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_IRPTNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_IRPTNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_IRPTNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_IRPTNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_IRPTNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_RESERVED1_MASK 0xffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_VMID_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_VMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_VMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_VMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_VMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_VMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_VMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR1_VMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBAR2)
/** \brief Context Bank 2 Attribute register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_IRPTNDX_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_IRPTNDX_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_IRPTNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_IRPTNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_IRPTNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_IRPTNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_IRPTNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_IRPTNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_RESERVED1_MASK 0xffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_VMID_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_VMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_VMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_VMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_VMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_VMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_VMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR2_VMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBAR3)
/** \brief Context Bank 3 Attribute register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_IRPTNDX_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_IRPTNDX_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_IRPTNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_IRPTNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_IRPTNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_IRPTNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_IRPTNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_IRPTNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_RESERVED1_MASK 0xffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_VMID_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_VMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_VMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_VMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_VMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_VMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_VMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR3_VMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBAR4)
/** \brief Context Bank 4 Attribute register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_IRPTNDX_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_IRPTNDX_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_IRPTNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_IRPTNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_IRPTNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_IRPTNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_IRPTNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_IRPTNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_RESERVED1_MASK 0xffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_VMID_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_VMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_VMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_VMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_VMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_VMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_VMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR4_VMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBAR5)
/** \brief Context Bank 5 Attribute register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_IRPTNDX_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_IRPTNDX_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_IRPTNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_IRPTNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_IRPTNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_IRPTNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_IRPTNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_IRPTNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_RESERVED1_MASK 0xffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_VMID_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_VMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_VMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_VMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_VMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_VMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_VMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR5_VMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBAR6)
/** \brief Context Bank 6 Attribute register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_IRPTNDX_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_IRPTNDX_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_IRPTNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_IRPTNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_IRPTNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_IRPTNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_IRPTNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_IRPTNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_RESERVED1_MASK 0xffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_VMID_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_VMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_VMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_VMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_VMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_VMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_VMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR6_VMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBAR7)
/** \brief Context Bank 7 Attribute register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_IRPTNDX_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_IRPTNDX_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_IRPTNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_IRPTNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_IRPTNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_IRPTNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_IRPTNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_IRPTNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_RESERVED1_MASK 0xffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_VMID_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_VMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_VMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_VMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_VMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_VMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_VMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBAR7_VMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBFRSYNRA0)
/** \brief Context Bank 0 Fault Restricted Syndrome register A*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED1_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED1_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_SSD_INDEX_MASK 0x7fff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_SSD_INDEX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_SSD_INDEX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_SSD_INDEX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_SSD_INDEX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_SSD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_SSD_INDEX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_SSD_INDEX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_STREAMID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_STREAMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_STREAMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_STREAMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_STREAMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_STREAMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_STREAMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA0_STREAMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBFRSYNRA1)
/** \brief Context Bank 1 Fault Restricted Syndrome register A*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED1_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED1_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_SSD_INDEX_MASK 0x7fff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_SSD_INDEX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_SSD_INDEX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_SSD_INDEX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_SSD_INDEX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_SSD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_SSD_INDEX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_SSD_INDEX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_STREAMID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_STREAMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_STREAMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_STREAMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_STREAMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_STREAMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_STREAMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA1_STREAMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBFRSYNRA2)
/** \brief Context Bank 2 Fault Restricted Syndrome register A*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED1_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED1_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_SSD_INDEX_MASK 0x7fff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_SSD_INDEX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_SSD_INDEX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_SSD_INDEX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_SSD_INDEX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_SSD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_SSD_INDEX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_SSD_INDEX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_STREAMID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_STREAMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_STREAMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_STREAMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_STREAMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_STREAMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_STREAMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA2_STREAMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBFRSYNRA3)
/** \brief Context Bank 3 Fault Restricted Syndrome register A*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED1_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED1_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_SSD_INDEX_MASK 0x7fff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_SSD_INDEX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_SSD_INDEX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_SSD_INDEX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_SSD_INDEX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_SSD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_SSD_INDEX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_SSD_INDEX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_STREAMID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_STREAMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_STREAMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_STREAMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_STREAMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_STREAMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_STREAMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA3_STREAMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBFRSYNRA4)
/** \brief Context Bank 4 Fault Restricted Syndrome register A*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED1_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED1_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_SSD_INDEX_MASK 0x7fff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_SSD_INDEX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_SSD_INDEX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_SSD_INDEX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_SSD_INDEX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_SSD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_SSD_INDEX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_SSD_INDEX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_STREAMID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_STREAMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_STREAMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_STREAMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_STREAMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_STREAMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_STREAMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA4_STREAMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBFRSYNRA5)
/** \brief Context Bank 5 Fault Restricted Syndrome register A*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED1_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED1_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_SSD_INDEX_MASK 0x7fff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_SSD_INDEX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_SSD_INDEX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_SSD_INDEX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_SSD_INDEX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_SSD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_SSD_INDEX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_SSD_INDEX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_STREAMID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_STREAMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_STREAMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_STREAMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_STREAMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_STREAMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_STREAMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA5_STREAMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBFRSYNRA6)
/** \brief Context Bank 6 Fault Restricted Syndrome register A*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED1_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED1_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_SSD_INDEX_MASK 0x7fff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_SSD_INDEX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_SSD_INDEX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_SSD_INDEX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_SSD_INDEX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_SSD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_SSD_INDEX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_SSD_INDEX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_STREAMID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_STREAMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_STREAMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_STREAMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_STREAMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_STREAMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_STREAMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA6_STREAMID_SHIFT))

//====================================================================
//Register:  (SMMU_CBFRSYNRA7)
/** \brief Context Bank 7 Fault Restricted Syndrome register A*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED1_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED1_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_SSD_INDEX_MASK 0x7fff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_SSD_INDEX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_SSD_INDEX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_SSD_INDEX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_SSD_INDEX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_SSD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_SSD_INDEX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_SSD_INDEX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_STREAMID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_STREAMID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_STREAMID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_STREAMID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_STREAMID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_STREAMID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_STREAMID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CBFRSYNRA7_STREAMID_SHIFT))

//====================================================================
//Register:  (SMMU_INTG_CTRL)
/** \brief Integration Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_RESERVED1_MASK 0xfffffffe
#define  MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_RESERVED1_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_INTG_TEST_EN_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_INTG_TEST_EN_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_INTG_TEST_EN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_INTG_TEST_EN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_INTG_TEST_EN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_INTG_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_INTG_TEST_EN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_INTG_CTRL_INTG_TEST_EN_SHIFT))

//====================================================================
//Register:  (SMMU_ITIP)
/** \brief Integration Input register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_RESERVED1_MASK 0xfffffffe
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_RESERVED1_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_SPINDEN_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_SPINDEN_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_SPINDEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_SPINDEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_SPINDEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_SPINDEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_SPINDEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ITIP_SPINDEN_SHIFT))

//====================================================================
//Register:  (SMMU_ITOP)
/** \brief Integration Output register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED1_MASK 0xfffffc00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED1_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SGLB_IRPT_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SGLB_IRPT_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SGLB_IRPT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SGLB_IRPT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SGLB_IRPT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SGLB_IRPT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SGLB_IRPT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SGLB_IRPT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SCFG_IRPT_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SCFG_IRPT_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SCFG_IRPT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SCFG_IRPT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SCFG_IRPT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SCFG_IRPT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SCFG_IRPT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_SCFG_IRPT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED2_MASK 0xf0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED2_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_CXT_IRPT_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_CXT_IRPT_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_CXT_IRPT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_CXT_IRPT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_CXT_IRPT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_CXT_IRPT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_CXT_IRPT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_CXT_IRPT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_PERF_IRPT_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_PERF_IRPT_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_PERF_IRPT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_PERF_IRPT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_PERF_IRPT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_PERF_IRPT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_PERF_IRPT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_PERF_IRPT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSGLB_IRPT_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSGLB_IRPT_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSGLB_IRPT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSGLB_IRPT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSGLB_IRPT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSGLB_IRPT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSGLB_IRPT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSGLB_IRPT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSCFG_IRPT_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSCFG_IRPT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSCFG_IRPT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSCFG_IRPT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSCFG_IRPT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSCFG_IRPT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSCFG_IRPT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_ITOP_NSCFG_IRPT_SHIFT))

//====================================================================
//Register:  (SMMU_PMXEVCNTR0)
/** \brief Performance Monitor Event Counter 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR0_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR0_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR0_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR0_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR0_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR0_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR0_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR0_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_PMXEVCNTR1)
/** \brief Performance Monitor Event Counter 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR1_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR1_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR1_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR1_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR1_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR1_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR1_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR1_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_PMXEVCNTR2)
/** \brief Performance Monitor Event Counter 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR2_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR2_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR2_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR2_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR2_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR2_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR2_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVCNTR2_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_PMXEVTYPER0)
/** \brief Performance Monitor Event Type register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER0_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_PMXEVTYPER1)
/** \brief Performance Monitor Event Type register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER1_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_PMXEVTYPER2)
/** \brief Performance Monitor Event Type register 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMXEVTYPER2_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_PMCGCR)
/** \brief Performance Monitor Counter Group Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CGNC_MASK 0xf000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CGNC_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CGNC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CGNC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CGNC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CGNC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CGNC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CGNC_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED2_MASK 0x800000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED2_SHIFT 23
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_SIDG_MASK 0x7f0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_SIDG_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_SIDG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_SIDG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_SIDG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_SIDG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_SIDG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_SIDG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED3_MASK 0xe000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED3_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_EX_MASK 0x1000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_EX_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CEN_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CEN_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CBAEN_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CBAEN_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CBAEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CBAEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CBAEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CBAEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CBAEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_CBAEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_TCEFCFG_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_TCEFCFG_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_TCEFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_TCEFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_TCEFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_TCEFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_TCEFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_TCEFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED4_MASK 0xf8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED4_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED4_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED4_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED4_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED4_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_RESERVED4_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_NDX_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_NDX_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_NDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_NDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_NDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_NDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_NDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGCR_NDX_SHIFT))

//====================================================================
//Register:  (SMMU_PMCGSMR)
/** \brief Performance Monitor Counter Group Stream Mapping register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_MASK_MASK 0xfff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_MASK_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_MASK_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_MASK_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_MASK_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_MASK_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_MASK_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_MASK_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_ID_MASK 0xfff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_ID_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_ID_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_ID_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_ID_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_ID_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_ID_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCGSMR_ID_SHIFT))

//====================================================================
//Register:  (SMMU_PMCNTENSET)
/** \brief Performance Monitor Counter Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_PMCNTENCLEAR)
/** \brief Performance Monitor Counter Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCNTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_PMINTENSET)
/** \brief Performance Monitor Interrupt Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_PMINTENCLEAR)
/** \brief Performance Monitor Interrupt Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMINTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_PMOVSCLR)
/** \brief Performance Monitor Overflow Status Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSCLR_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_PMOVSSET)
/** \brief Performance Monitor Overflow Status Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMOVSSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_PMCFGR)
/** \brief Performance Monitor Configuration register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NCG_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NCG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NCG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NCG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NCG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NCG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NCG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NCG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RESERVED1_MASK 0xf00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RESERVED1_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_UEN_MASK 0x80000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_UEN_SHIFT 19
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_UEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_UEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_UEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_UEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_UEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_UEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_WT_MASK 0x40000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_WT_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NA_MASK 0x20000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NA_SHIFT 17
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_EX_MASK 0x10000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_EX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CCD_MASK 0x8000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CCD_SHIFT 15
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CC_MASK 0x4000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CC_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_CC_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAZ_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAZ_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAZ_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_SIZE_MASK 0x1800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_SIZE_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_SIZE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_SIZE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_SIZE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_SIZE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_SIZE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_SIZE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAO_MASK 0x700
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAO_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAO_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAO_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAO_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAO_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAO_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_RAO_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NUM_CNT_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NUM_CNT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NUM_CNT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NUM_CNT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NUM_CNT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NUM_CNT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NUM_CNT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCFGR_NUM_CNT_SHIFT))

//====================================================================
//Register:  (SMMU_PMCR)
/** \brief Performance Monitor Configuration register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_WT_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_WT_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_NA_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_NA_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_DP_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_DP_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_DP_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_DP_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_DP_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_DP_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_DP_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_DP_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_EX_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_EX_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCR_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCR_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CCR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RST_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RST_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RST_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RST_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RST_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RST_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RST_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_RST_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CEN_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CEN_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCR_CEN_SHIFT))

//====================================================================
//Register:  (SMMU_PMCEID0)
/** \brief Performance Monitor Common Event Identification register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RESERVED1_MASK 0xffffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_ACCESS_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_ACCESS_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_ACCESS_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_ACCESS_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_ACCESS_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_ACCESS_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_REFILL_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_REFILL_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_WR_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_REFILL_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_REFILL_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_RD_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_REFILL_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_REFILL_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_CC_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_CC_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMCEID0_CC_SHIFT))

//====================================================================
//Register:  (SMMU_PMAUTHSTATUS)
/** \brief Performance Monitor Authentication Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNI_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNI_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SI_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SI_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SE_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SE_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_SE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNI_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNI_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSI_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSI_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSE_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSE_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMAUTHSTATUS_NSE_SHIFT))

//====================================================================
//Register:  (SMMU_PMDEVTYPE)
/** \brief Performance Monitor Device Type register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_T_MASK 0xf0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_T_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_T_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_T_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_T_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_T_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_T_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_T_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_C_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_C_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_C_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_C_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_C_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_C_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_C_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_PMDEVTYPE_C_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_SCTLR)
/** \brief Context Bank System Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_WACFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_WACFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RACFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RACFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_SHCFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_SHCFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_FB_MASK 0x200000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_FB_SHIFT 21
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_FB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_FB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_FB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_FB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_FB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_FB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED2_MASK 0x100000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED2_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MEM_ATTR_MASK 0xf0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MEM_ATTR_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_BSU_MASK 0xc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_BSU_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_BSU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_BSU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_BSU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_BSU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_BSU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_BSU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_PTW_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_PTW_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_PTW_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_PTW_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_PTW_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_PTW_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_PTW_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_PTW_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED3_MASK 0x1e00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED3_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_HUPCF_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_HUPCF_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_HUPCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_HUPCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_HUPCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_HUPCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_HUPCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_HUPCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFCFG_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFCFG_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFIE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFIE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFIE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFIE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFIE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFIE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFIE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFIE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFRE_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFRE_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_CFRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_ENDIAN_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_ENDIAN_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_ENDIAN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_ENDIAN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_ENDIAN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_ENDIAN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_ENDIAN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFFD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFFD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFFD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFFD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFFD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFFD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFFD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFFD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_AFE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_TRE_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_TRE_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_TRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_TRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_TRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_TRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_TRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_TRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MMU_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MMU_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MMU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MMU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MMU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MMU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MMU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_SCTLR_MMU_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_TTBR0_LOW)
/** \brief Context Bank Translation Table Base register 0 Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_TTBR0_HIGH)
/** \brief Context Bank Translation Table Base register 0 Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBR0_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_TTBCR)
/** \brief Context Bank Translation Table Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_EAE_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_EAE_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_EAE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_EAE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_EAE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_EAE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_EAE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_EAE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED1_MASK 0x7fffc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED1_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SH0_MASK 0x3000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SH0_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SH0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SH0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SH0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SH0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SH0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SH0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_ORGN0_MASK 0xc00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_ORGN0_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_ORGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_ORGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_ORGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_ORGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_ORGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_ORGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_IRGN0_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_IRGN0_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_IRGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_IRGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_IRGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_IRGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_IRGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_IRGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SL0_MASK 0xc0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SL0_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SL0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SL0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SL0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SL0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SL0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_SL0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED2_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED2_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_S_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_S_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_S_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_S_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_S_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_S_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_S_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_S_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_T0SZ_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_T0SZ_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_T0SZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_T0SZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_T0SZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_T0SZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_T0SZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_TTBCR_T0SZ_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_FSR)
/** \brief Context Bank Fault Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_MULTI_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_MULTI_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_MULTI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_MULTI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_MULTI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_MULTI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_MULTI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_MULTI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_SS_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_SS_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_SS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_SS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_SS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_SS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_SS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_SS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED1_MASK 0x3fffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBLKF_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBLKF_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBLKF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBLKF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBLKF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBLKF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBLKF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBLKF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBMCF_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBMCF_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBMCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBMCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBMCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBMCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBMCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TLBMCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_EF_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_EF_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_EF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_EF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_EF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_EF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_EF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_EF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_PF_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_PF_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_PF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_PF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_PF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_PF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_PF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_PF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_AFF_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_AFF_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_AFF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_AFF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_AFF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_AFF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_AFF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_AFF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TF_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TF_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_TF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED2_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED2_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSR_RESERVED2_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_FSRRESTORE)
/** \brief Context Bank Fault Status Restore register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSRRESTORE_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSRRESTORE_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSRRESTORE_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSRRESTORE_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSRRESTORE_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSRRESTORE_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSRRESTORE_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSRRESTORE_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_FAR_LOW)
/** \brief Context Bank Fault Address register Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_FAR_HIGH)
/** \brief Context Bank Fault Address register Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FAR_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_FSYNR0)
/** \brief Context Bank Fault Syndrome register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED1_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED1_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_S1CBNDX_MASK 0xff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_S1CBNDX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_S1CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_S1CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_S1CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_S1CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_S1CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_S1CBNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_AFR_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_AFR_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_AFR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_AFR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_AFR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_AFR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_AFR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_AFR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PTWF_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PTWF_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PTWF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PTWF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PTWF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PTWF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PTWF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PTWF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_ATOF_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_ATOF_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_ATOF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_ATOF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_ATOF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_ATOF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_ATOF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_ATOF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSATTR_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSATTR_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSSTATE_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSSTATE_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSSTATE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSSTATE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSSTATE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSSTATE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSSTATE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_NSSTATE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_IND_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_IND_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_IND_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_IND_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_IND_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_IND_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_IND_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_IND_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PNU_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PNU_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PNU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PNU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PNU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PNU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PNU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PNU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_WNR_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_WNR_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_WNR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_WNR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_WNR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_WNR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_WNR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_WNR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_STAGE_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_STAGE_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_STAGE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_STAGE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_STAGE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_STAGE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_STAGE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_STAGE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED3_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED3_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PLVL_MASK 0x3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PLVL_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PLVL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PLVL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PLVL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PLVL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PLVL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_FSYNR0_PLVL_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMXEVCNTR0)
/** \brief Performance Monitor Context Bank Event Counter 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR0_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR0_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR0_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR0_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR0_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR0_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR0_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR0_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMXEVCNTR1)
/** \brief Performance Monitor Context Bank Event Counter 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR1_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR1_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR1_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR1_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR1_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR1_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR1_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR1_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMXEVCNTR2)
/** \brief Performance Monitor Context Bank Event Counter 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR2_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR2_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR2_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR2_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR2_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR2_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR2_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVCNTR2_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMXEVTYPER0)
/** \brief Performance Monitor Context Bank Event Type register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER0_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMXEVTYPER1)
/** \brief Performance Monitor Context Bank Event Type register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER1_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMXEVTYPER2)
/** \brief Performance Monitor Context Bank Event Type register 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMXEVTYPER2_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMCFGR)
/** \brief Performance Monitor Context Bank Configuration register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NCG_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NCG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NCG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NCG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NCG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NCG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NCG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NCG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RESERVED1_MASK 0xf00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RESERVED1_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_UEN_MASK 0x80000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_UEN_SHIFT 19
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_UEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_UEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_UEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_UEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_UEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_UEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_WT_MASK 0x40000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_WT_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NA_MASK 0x20000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NA_SHIFT 17
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_EX_MASK 0x10000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_EX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CCD_MASK 0x8000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CCD_SHIFT 15
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CC_MASK 0x4000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CC_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_CC_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAZ_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAZ_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAZ_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_SIZE_MASK 0x1800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_SIZE_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_SIZE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_SIZE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_SIZE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_SIZE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_SIZE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_SIZE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAO_MASK 0x700
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAO_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAO_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAO_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAO_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAO_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAO_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_RAO_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NUM_CNT_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NUM_CNT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NUM_CNT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NUM_CNT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NUM_CNT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NUM_CNT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NUM_CNT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCFGR_NUM_CNT_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMCR)
/** \brief Performance Monitor Context Bank Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_WT_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_WT_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_NA_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_NA_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_DP_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_DP_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_DP_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_DP_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_DP_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_DP_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_DP_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_DP_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_EX_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_EX_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCR_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCR_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CCR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RST_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RST_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RST_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RST_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RST_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RST_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RST_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_RST_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CEN_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CEN_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCR_CEN_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMCEID)
/** \brief Performance Monitor Context Bank Event Identification register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RESERVED1_MASK 0xffffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_ACCESS_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_ACCESS_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_ACCESS_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_ACCESS_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_ACCESS_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_ACCESS_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_REFILL_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_REFILL_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_WR_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_REFILL_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_REFILL_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_RD_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_REFILL_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_REFILL_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_CC_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_CC_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCEID_CC_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMCNTENSE)
/** \brief Performance Monitor Context Bank Count Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSE_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMCNTENCLEAR)
/** \brief Performance Monitor Context Bank Count Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMCNTENSET)
/** \brief Performance Monitor Context Bank Interrupt Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMCNTENSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMINTENCLEAR)
/** \brief Performance Monitor Context Bank Interrupt Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMINTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMOVSCLR)
/** \brief Performance Monitor Context Bank Overflow Status Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSCLR_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMOVSSET)
/** \brief Performance Monitor Context Bank Overflow Status Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMOVSSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB0_PMAUTHSTATUS)
/** \brief Performance Monitor Context Bank Authentication Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNI_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNI_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SI_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SI_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SE_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SE_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_SE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNI_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNI_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSI_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSI_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSE_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSE_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB0_PMAUTHSTATUS_NSE_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_SCTLR)
/** \brief Context Bank System Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_WACFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_WACFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RACFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RACFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_SHCFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_SHCFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_FB_MASK 0x200000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_FB_SHIFT 21
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_FB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_FB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_FB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_FB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_FB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_FB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED2_MASK 0x100000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED2_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MEM_ATTR_MASK 0xf0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MEM_ATTR_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_BSU_MASK 0xc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_BSU_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_BSU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_BSU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_BSU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_BSU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_BSU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_BSU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_PTW_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_PTW_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_PTW_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_PTW_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_PTW_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_PTW_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_PTW_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_PTW_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED3_MASK 0x1e00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED3_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_HUPCF_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_HUPCF_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_HUPCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_HUPCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_HUPCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_HUPCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_HUPCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_HUPCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFCFG_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFCFG_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFIE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFIE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFIE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFIE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFIE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFIE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFIE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFIE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFRE_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFRE_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_CFRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_ENDIAN_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_ENDIAN_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_ENDIAN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_ENDIAN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_ENDIAN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_ENDIAN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_ENDIAN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFFD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFFD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFFD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFFD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFFD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFFD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFFD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFFD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_AFE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_TRE_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_TRE_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_TRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_TRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_TRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_TRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_TRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_TRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MMU_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MMU_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MMU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MMU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MMU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MMU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MMU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_SCTLR_MMU_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_TTBR0_LOW)
/** \brief Context Bank Translation Table Base register 0 Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_TTBR0_HIGH)
/** \brief Context Bank Translation Table Base register 0 Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBR0_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_TTBCR)
/** \brief Context Bank Translation Table Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_EAE_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_EAE_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_EAE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_EAE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_EAE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_EAE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_EAE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_EAE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED1_MASK 0x7fffc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED1_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SH0_MASK 0x3000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SH0_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SH0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SH0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SH0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SH0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SH0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SH0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_ORGN0_MASK 0xc00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_ORGN0_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_ORGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_ORGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_ORGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_ORGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_ORGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_ORGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_IRGN0_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_IRGN0_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_IRGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_IRGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_IRGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_IRGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_IRGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_IRGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SL0_MASK 0xc0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SL0_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SL0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SL0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SL0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SL0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SL0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_SL0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED2_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED2_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_S_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_S_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_S_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_S_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_S_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_S_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_S_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_S_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_T0SZ_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_T0SZ_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_T0SZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_T0SZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_T0SZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_T0SZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_T0SZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_TTBCR_T0SZ_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_FSR)
/** \brief Context Bank Fault Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_MULTI_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_MULTI_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_MULTI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_MULTI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_MULTI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_MULTI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_MULTI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_MULTI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_SS_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_SS_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_SS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_SS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_SS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_SS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_SS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_SS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED1_MASK 0x3fffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBLKF_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBLKF_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBLKF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBLKF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBLKF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBLKF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBLKF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBLKF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBMCF_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBMCF_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBMCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBMCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBMCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBMCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBMCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TLBMCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_EF_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_EF_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_EF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_EF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_EF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_EF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_EF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_EF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_PF_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_PF_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_PF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_PF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_PF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_PF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_PF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_PF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_AFF_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_AFF_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_AFF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_AFF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_AFF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_AFF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_AFF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_AFF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TF_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TF_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_TF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED2_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED2_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSR_RESERVED2_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_FSRRESTORE)
/** \brief Context Bank Fault Status Restore register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSRRESTORE_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSRRESTORE_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSRRESTORE_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSRRESTORE_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSRRESTORE_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSRRESTORE_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSRRESTORE_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSRRESTORE_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_FAR_LOW)
/** \brief Context Bank Fault Address register Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_FAR_HIGH)
/** \brief Context Bank Fault Address register Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FAR_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_FSYNR0)
/** \brief Context Bank Fault Syndrome register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED1_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED1_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_S1CBNDX_MASK 0xff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_S1CBNDX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_S1CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_S1CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_S1CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_S1CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_S1CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_S1CBNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_AFR_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_AFR_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_AFR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_AFR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_AFR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_AFR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_AFR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_AFR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PTWF_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PTWF_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PTWF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PTWF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PTWF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PTWF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PTWF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PTWF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_ATOF_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_ATOF_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_ATOF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_ATOF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_ATOF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_ATOF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_ATOF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_ATOF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSATTR_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSATTR_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSSTATE_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSSTATE_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSSTATE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSSTATE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSSTATE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSSTATE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSSTATE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_NSSTATE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_IND_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_IND_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_IND_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_IND_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_IND_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_IND_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_IND_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_IND_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PNU_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PNU_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PNU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PNU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PNU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PNU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PNU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PNU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_WNR_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_WNR_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_WNR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_WNR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_WNR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_WNR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_WNR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_WNR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_STAGE_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_STAGE_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_STAGE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_STAGE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_STAGE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_STAGE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_STAGE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_STAGE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED3_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED3_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PLVL_MASK 0x3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PLVL_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PLVL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PLVL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PLVL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PLVL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PLVL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_FSYNR0_PLVL_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMXEVCNTR0)
/** \brief Performance Monitor Context Bank Event Counter 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR0_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR0_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR0_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR0_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR0_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR0_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR0_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR0_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMXEVCNTR1)
/** \brief Performance Monitor Context Bank Event Counter 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR1_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR1_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR1_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR1_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR1_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR1_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR1_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR1_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMXEVCNTR2)
/** \brief Performance Monitor Context Bank Event Counter 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR2_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR2_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR2_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR2_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR2_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR2_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR2_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVCNTR2_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMXEVTYPER0)
/** \brief Performance Monitor Context Bank Event Type register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER0_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMXEVTYPER1)
/** \brief Performance Monitor Context Bank Event Type register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER1_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMXEVTYPER2)
/** \brief Performance Monitor Context Bank Event Type register 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMXEVTYPER2_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMCFGR)
/** \brief Performance Monitor Context Bank Configuration register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NCG_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NCG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NCG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NCG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NCG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NCG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NCG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NCG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RESERVED1_MASK 0xf00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RESERVED1_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_UEN_MASK 0x80000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_UEN_SHIFT 19
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_UEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_UEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_UEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_UEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_UEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_UEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_WT_MASK 0x40000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_WT_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NA_MASK 0x20000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NA_SHIFT 17
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_EX_MASK 0x10000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_EX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CCD_MASK 0x8000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CCD_SHIFT 15
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CC_MASK 0x4000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CC_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_CC_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAZ_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAZ_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAZ_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_SIZE_MASK 0x1800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_SIZE_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_SIZE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_SIZE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_SIZE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_SIZE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_SIZE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_SIZE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAO_MASK 0x700
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAO_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAO_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAO_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAO_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAO_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAO_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_RAO_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NUM_CNT_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NUM_CNT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NUM_CNT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NUM_CNT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NUM_CNT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NUM_CNT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NUM_CNT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCFGR_NUM_CNT_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMCR)
/** \brief Performance Monitor Context Bank Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_WT_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_WT_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_NA_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_NA_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_DP_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_DP_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_DP_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_DP_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_DP_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_DP_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_DP_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_DP_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_EX_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_EX_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCR_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCR_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CCR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RST_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RST_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RST_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RST_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RST_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RST_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RST_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_RST_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CEN_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CEN_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCR_CEN_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMCEID)
/** \brief Performance Monitor Context Bank Event Identification register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RESERVED1_MASK 0xffffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_ACCESS_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_ACCESS_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_ACCESS_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_ACCESS_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_ACCESS_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_ACCESS_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_REFILL_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_REFILL_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_WR_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_REFILL_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_REFILL_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_RD_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_REFILL_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_REFILL_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_CC_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_CC_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCEID_CC_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMCNTENSE)
/** \brief Performance Monitor Context Bank Count Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSE_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMCNTENCLEAR)
/** \brief Performance Monitor Context Bank Count Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMCNTENSET)
/** \brief Performance Monitor Context Bank Interrupt Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMCNTENSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMINTENCLEAR)
/** \brief Performance Monitor Context Bank Interrupt Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMINTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMOVSCLR)
/** \brief Performance Monitor Context Bank Overflow Status Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSCLR_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMOVSSET)
/** \brief Performance Monitor Context Bank Overflow Status Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMOVSSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB1_PMAUTHSTATUS)
/** \brief Performance Monitor Context Bank Authentication Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNI_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNI_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SI_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SI_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SE_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SE_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_SE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNI_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNI_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSI_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSI_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSE_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSE_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB1_PMAUTHSTATUS_NSE_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_SCTLR)
/** \brief Context Bank System Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_WACFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_WACFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RACFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RACFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_SHCFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_SHCFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_FB_MASK 0x200000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_FB_SHIFT 21
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_FB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_FB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_FB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_FB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_FB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_FB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED2_MASK 0x100000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED2_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MEM_ATTR_MASK 0xf0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MEM_ATTR_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_BSU_MASK 0xc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_BSU_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_BSU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_BSU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_BSU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_BSU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_BSU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_BSU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_PTW_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_PTW_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_PTW_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_PTW_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_PTW_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_PTW_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_PTW_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_PTW_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED3_MASK 0x1e00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED3_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_HUPCF_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_HUPCF_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_HUPCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_HUPCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_HUPCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_HUPCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_HUPCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_HUPCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFCFG_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFCFG_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFIE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFIE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFIE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFIE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFIE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFIE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFIE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFIE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFRE_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFRE_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_CFRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_ENDIAN_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_ENDIAN_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_ENDIAN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_ENDIAN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_ENDIAN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_ENDIAN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_ENDIAN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFFD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFFD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFFD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFFD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFFD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFFD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFFD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFFD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_AFE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_TRE_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_TRE_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_TRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_TRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_TRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_TRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_TRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_TRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MMU_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MMU_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MMU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MMU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MMU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MMU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MMU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_SCTLR_MMU_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_TTBR0_LOW)
/** \brief Context Bank Translation Table Base register 0 Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_TTBR0_HIGH)
/** \brief Context Bank Translation Table Base register 0 Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBR0_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_TTBCR)
/** \brief Context Bank Translation Table Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_EAE_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_EAE_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_EAE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_EAE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_EAE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_EAE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_EAE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_EAE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED1_MASK 0x7fffc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED1_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SH0_MASK 0x3000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SH0_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SH0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SH0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SH0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SH0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SH0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SH0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_ORGN0_MASK 0xc00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_ORGN0_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_ORGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_ORGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_ORGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_ORGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_ORGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_ORGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_IRGN0_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_IRGN0_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_IRGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_IRGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_IRGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_IRGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_IRGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_IRGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SL0_MASK 0xc0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SL0_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SL0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SL0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SL0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SL0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SL0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_SL0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED2_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED2_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_S_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_S_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_S_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_S_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_S_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_S_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_S_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_S_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_T0SZ_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_T0SZ_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_T0SZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_T0SZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_T0SZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_T0SZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_T0SZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_TTBCR_T0SZ_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_FSR)
/** \brief Context Bank Fault Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_MULTI_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_MULTI_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_MULTI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_MULTI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_MULTI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_MULTI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_MULTI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_MULTI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_SS_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_SS_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_SS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_SS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_SS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_SS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_SS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_SS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED1_MASK 0x3fffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBLKF_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBLKF_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBLKF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBLKF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBLKF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBLKF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBLKF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBLKF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBMCF_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBMCF_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBMCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBMCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBMCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBMCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBMCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TLBMCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_EF_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_EF_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_EF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_EF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_EF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_EF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_EF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_EF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_PF_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_PF_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_PF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_PF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_PF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_PF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_PF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_PF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_AFF_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_AFF_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_AFF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_AFF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_AFF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_AFF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_AFF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_AFF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TF_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TF_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_TF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED2_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED2_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSR_RESERVED2_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_FSRRESTORE)
/** \brief Context Bank Fault Status Restore register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSRRESTORE_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSRRESTORE_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSRRESTORE_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSRRESTORE_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSRRESTORE_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSRRESTORE_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSRRESTORE_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSRRESTORE_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_FAR_LOW)
/** \brief Context Bank Fault Address register Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_FAR_HIGH)
/** \brief Context Bank Fault Address register Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FAR_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_FSYNR0)
/** \brief Context Bank Fault Syndrome register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED1_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED1_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_S1CBNDX_MASK 0xff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_S1CBNDX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_S1CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_S1CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_S1CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_S1CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_S1CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_S1CBNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_AFR_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_AFR_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_AFR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_AFR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_AFR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_AFR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_AFR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_AFR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PTWF_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PTWF_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PTWF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PTWF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PTWF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PTWF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PTWF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PTWF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_ATOF_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_ATOF_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_ATOF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_ATOF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_ATOF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_ATOF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_ATOF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_ATOF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSATTR_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSATTR_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSSTATE_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSSTATE_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSSTATE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSSTATE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSSTATE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSSTATE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSSTATE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_NSSTATE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_IND_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_IND_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_IND_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_IND_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_IND_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_IND_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_IND_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_IND_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PNU_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PNU_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PNU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PNU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PNU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PNU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PNU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PNU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_WNR_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_WNR_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_WNR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_WNR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_WNR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_WNR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_WNR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_WNR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_STAGE_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_STAGE_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_STAGE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_STAGE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_STAGE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_STAGE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_STAGE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_STAGE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED3_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED3_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PLVL_MASK 0x3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PLVL_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PLVL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PLVL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PLVL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PLVL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PLVL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_FSYNR0_PLVL_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMXEVCNTR0)
/** \brief Performance Monitor Context Bank Event Counter 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR0_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR0_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR0_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR0_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR0_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR0_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR0_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR0_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMXEVCNTR1)
/** \brief Performance Monitor Context Bank Event Counter 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR1_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR1_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR1_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR1_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR1_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR1_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR1_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR1_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMXEVCNTR2)
/** \brief Performance Monitor Context Bank Event Counter 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR2_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR2_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR2_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR2_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR2_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR2_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR2_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVCNTR2_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMXEVTYPER0)
/** \brief Performance Monitor Context Bank Event Type register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER0_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMXEVTYPER1)
/** \brief Performance Monitor Context Bank Event Type register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER1_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMXEVTYPER2)
/** \brief Performance Monitor Context Bank Event Type register 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMXEVTYPER2_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMCFGR)
/** \brief Performance Monitor Context Bank Configuration register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NCG_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NCG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NCG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NCG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NCG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NCG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NCG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NCG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RESERVED1_MASK 0xf00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RESERVED1_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_UEN_MASK 0x80000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_UEN_SHIFT 19
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_UEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_UEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_UEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_UEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_UEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_UEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_WT_MASK 0x40000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_WT_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NA_MASK 0x20000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NA_SHIFT 17
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_EX_MASK 0x10000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_EX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CCD_MASK 0x8000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CCD_SHIFT 15
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CC_MASK 0x4000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CC_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_CC_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAZ_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAZ_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAZ_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_SIZE_MASK 0x1800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_SIZE_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_SIZE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_SIZE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_SIZE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_SIZE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_SIZE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_SIZE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAO_MASK 0x700
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAO_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAO_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAO_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAO_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAO_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAO_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_RAO_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NUM_CNT_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NUM_CNT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NUM_CNT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NUM_CNT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NUM_CNT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NUM_CNT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NUM_CNT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCFGR_NUM_CNT_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMCR)
/** \brief Performance Monitor Context Bank Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_WT_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_WT_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_NA_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_NA_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_DP_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_DP_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_DP_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_DP_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_DP_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_DP_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_DP_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_DP_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_EX_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_EX_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCR_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCR_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CCR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RST_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RST_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RST_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RST_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RST_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RST_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RST_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_RST_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CEN_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CEN_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCR_CEN_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMCEID)
/** \brief Performance Monitor Context Bank Event Identification register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RESERVED1_MASK 0xffffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_ACCESS_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_ACCESS_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_ACCESS_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_ACCESS_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_ACCESS_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_ACCESS_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_REFILL_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_REFILL_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_WR_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_REFILL_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_REFILL_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_RD_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_REFILL_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_REFILL_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_CC_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_CC_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCEID_CC_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMCNTENSE)
/** \brief Performance Monitor Context Bank Count Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSE_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMCNTENCLEAR)
/** \brief Performance Monitor Context Bank Count Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMCNTENSET)
/** \brief Performance Monitor Context Bank Interrupt Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMCNTENSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMINTENCLEAR)
/** \brief Performance Monitor Context Bank Interrupt Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMINTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMOVSCLR)
/** \brief Performance Monitor Context Bank Overflow Status Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSCLR_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMOVSSET)
/** \brief Performance Monitor Context Bank Overflow Status Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMOVSSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB2_PMAUTHSTATUS)
/** \brief Performance Monitor Context Bank Authentication Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNI_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNI_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SI_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SI_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SE_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SE_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_SE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNI_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNI_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSI_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSI_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSE_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSE_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB2_PMAUTHSTATUS_NSE_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_SCTLR)
/** \brief Context Bank System Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_WACFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_WACFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RACFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RACFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_SHCFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_SHCFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_FB_MASK 0x200000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_FB_SHIFT 21
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_FB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_FB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_FB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_FB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_FB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_FB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED2_MASK 0x100000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED2_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MEM_ATTR_MASK 0xf0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MEM_ATTR_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_BSU_MASK 0xc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_BSU_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_BSU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_BSU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_BSU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_BSU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_BSU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_BSU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_PTW_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_PTW_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_PTW_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_PTW_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_PTW_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_PTW_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_PTW_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_PTW_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED3_MASK 0x1e00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED3_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_HUPCF_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_HUPCF_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_HUPCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_HUPCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_HUPCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_HUPCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_HUPCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_HUPCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFCFG_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFCFG_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFIE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFIE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFIE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFIE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFIE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFIE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFIE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFIE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFRE_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFRE_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_CFRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_ENDIAN_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_ENDIAN_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_ENDIAN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_ENDIAN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_ENDIAN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_ENDIAN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_ENDIAN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFFD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFFD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFFD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFFD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFFD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFFD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFFD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFFD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_AFE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_TRE_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_TRE_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_TRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_TRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_TRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_TRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_TRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_TRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MMU_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MMU_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MMU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MMU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MMU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MMU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MMU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_SCTLR_MMU_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_TTBR0_LOW)
/** \brief Context Bank Translation Table Base register 0 Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_TTBR0_HIGH)
/** \brief Context Bank Translation Table Base register 0 Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBR0_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_TTBCR)
/** \brief Context Bank Translation Table Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_EAE_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_EAE_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_EAE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_EAE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_EAE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_EAE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_EAE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_EAE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED1_MASK 0x7fffc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED1_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SH0_MASK 0x3000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SH0_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SH0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SH0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SH0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SH0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SH0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SH0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_ORGN0_MASK 0xc00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_ORGN0_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_ORGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_ORGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_ORGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_ORGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_ORGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_ORGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_IRGN0_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_IRGN0_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_IRGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_IRGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_IRGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_IRGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_IRGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_IRGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SL0_MASK 0xc0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SL0_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SL0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SL0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SL0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SL0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SL0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_SL0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED2_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED2_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_S_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_S_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_S_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_S_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_S_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_S_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_S_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_S_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_T0SZ_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_T0SZ_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_T0SZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_T0SZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_T0SZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_T0SZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_T0SZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_TTBCR_T0SZ_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_FSR)
/** \brief Context Bank Fault Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_MULTI_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_MULTI_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_MULTI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_MULTI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_MULTI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_MULTI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_MULTI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_MULTI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_SS_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_SS_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_SS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_SS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_SS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_SS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_SS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_SS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED1_MASK 0x3fffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBLKF_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBLKF_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBLKF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBLKF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBLKF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBLKF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBLKF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBLKF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBMCF_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBMCF_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBMCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBMCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBMCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBMCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBMCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TLBMCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_EF_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_EF_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_EF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_EF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_EF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_EF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_EF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_EF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_PF_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_PF_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_PF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_PF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_PF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_PF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_PF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_PF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_AFF_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_AFF_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_AFF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_AFF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_AFF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_AFF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_AFF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_AFF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TF_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TF_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_TF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED2_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED2_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSR_RESERVED2_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_FSRRESTORE)
/** \brief Context Bank Fault Status Restore register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSRRESTORE_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSRRESTORE_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSRRESTORE_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSRRESTORE_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSRRESTORE_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSRRESTORE_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSRRESTORE_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSRRESTORE_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_FAR_LOW)
/** \brief Context Bank Fault Address register Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_FAR_HIGH)
/** \brief Context Bank Fault Address register Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FAR_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_FSYNR0)
/** \brief Context Bank Fault Syndrome register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED1_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED1_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_S1CBNDX_MASK 0xff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_S1CBNDX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_S1CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_S1CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_S1CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_S1CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_S1CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_S1CBNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_AFR_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_AFR_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_AFR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_AFR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_AFR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_AFR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_AFR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_AFR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PTWF_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PTWF_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PTWF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PTWF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PTWF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PTWF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PTWF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PTWF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_ATOF_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_ATOF_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_ATOF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_ATOF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_ATOF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_ATOF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_ATOF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_ATOF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSATTR_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSATTR_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSSTATE_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSSTATE_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSSTATE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSSTATE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSSTATE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSSTATE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSSTATE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_NSSTATE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_IND_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_IND_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_IND_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_IND_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_IND_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_IND_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_IND_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_IND_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PNU_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PNU_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PNU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PNU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PNU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PNU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PNU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PNU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_WNR_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_WNR_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_WNR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_WNR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_WNR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_WNR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_WNR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_WNR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_STAGE_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_STAGE_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_STAGE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_STAGE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_STAGE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_STAGE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_STAGE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_STAGE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED3_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED3_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PLVL_MASK 0x3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PLVL_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PLVL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PLVL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PLVL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PLVL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PLVL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_FSYNR0_PLVL_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMXEVCNTR0)
/** \brief Performance Monitor Context Bank Event Counter 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR0_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR0_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR0_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR0_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR0_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR0_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR0_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR0_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMXEVCNTR1)
/** \brief Performance Monitor Context Bank Event Counter 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR1_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR1_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR1_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR1_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR1_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR1_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR1_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR1_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMXEVCNTR2)
/** \brief Performance Monitor Context Bank Event Counter 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR2_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR2_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR2_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR2_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR2_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR2_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR2_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVCNTR2_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMXEVTYPER0)
/** \brief Performance Monitor Context Bank Event Type register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER0_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMXEVTYPER1)
/** \brief Performance Monitor Context Bank Event Type register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER1_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMXEVTYPER2)
/** \brief Performance Monitor Context Bank Event Type register 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMXEVTYPER2_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMCFGR)
/** \brief Performance Monitor Context Bank Configuration register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NCG_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NCG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NCG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NCG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NCG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NCG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NCG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NCG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RESERVED1_MASK 0xf00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RESERVED1_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_UEN_MASK 0x80000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_UEN_SHIFT 19
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_UEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_UEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_UEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_UEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_UEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_UEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_WT_MASK 0x40000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_WT_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NA_MASK 0x20000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NA_SHIFT 17
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_EX_MASK 0x10000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_EX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CCD_MASK 0x8000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CCD_SHIFT 15
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CC_MASK 0x4000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CC_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_CC_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAZ_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAZ_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAZ_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_SIZE_MASK 0x1800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_SIZE_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_SIZE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_SIZE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_SIZE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_SIZE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_SIZE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_SIZE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAO_MASK 0x700
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAO_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAO_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAO_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAO_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAO_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAO_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_RAO_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NUM_CNT_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NUM_CNT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NUM_CNT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NUM_CNT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NUM_CNT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NUM_CNT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NUM_CNT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCFGR_NUM_CNT_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMCR)
/** \brief Performance Monitor Context Bank Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_WT_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_WT_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_NA_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_NA_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_DP_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_DP_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_DP_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_DP_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_DP_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_DP_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_DP_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_DP_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_EX_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_EX_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCR_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCR_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CCR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RST_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RST_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RST_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RST_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RST_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RST_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RST_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_RST_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CEN_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CEN_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCR_CEN_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMCEID)
/** \brief Performance Monitor Context Bank Event Identification register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RESERVED1_MASK 0xffffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_ACCESS_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_ACCESS_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_ACCESS_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_ACCESS_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_ACCESS_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_ACCESS_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_REFILL_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_REFILL_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_WR_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_REFILL_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_REFILL_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_RD_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_REFILL_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_REFILL_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_CC_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_CC_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCEID_CC_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMCNTENSE)
/** \brief Performance Monitor Context Bank Count Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSE_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMCNTENCLEAR)
/** \brief Performance Monitor Context Bank Count Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMCNTENSET)
/** \brief Performance Monitor Context Bank Interrupt Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMCNTENSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMINTENCLEAR)
/** \brief Performance Monitor Context Bank Interrupt Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMINTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMOVSCLR)
/** \brief Performance Monitor Context Bank Overflow Status Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSCLR_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMOVSSET)
/** \brief Performance Monitor Context Bank Overflow Status Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMOVSSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB3_PMAUTHSTATUS)
/** \brief Performance Monitor Context Bank Authentication Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNI_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNI_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SI_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SI_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SE_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SE_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_SE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNI_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNI_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSI_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSI_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSE_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSE_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB3_PMAUTHSTATUS_NSE_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_SCTLR)
/** \brief Context Bank System Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_WACFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_WACFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RACFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RACFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_SHCFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_SHCFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_FB_MASK 0x200000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_FB_SHIFT 21
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_FB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_FB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_FB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_FB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_FB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_FB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED2_MASK 0x100000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED2_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MEM_ATTR_MASK 0xf0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MEM_ATTR_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_BSU_MASK 0xc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_BSU_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_BSU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_BSU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_BSU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_BSU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_BSU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_BSU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_PTW_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_PTW_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_PTW_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_PTW_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_PTW_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_PTW_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_PTW_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_PTW_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED3_MASK 0x1e00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED3_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_HUPCF_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_HUPCF_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_HUPCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_HUPCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_HUPCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_HUPCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_HUPCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_HUPCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFCFG_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFCFG_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFIE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFIE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFIE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFIE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFIE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFIE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFIE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFIE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFRE_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFRE_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_CFRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_ENDIAN_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_ENDIAN_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_ENDIAN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_ENDIAN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_ENDIAN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_ENDIAN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_ENDIAN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFFD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFFD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFFD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFFD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFFD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFFD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFFD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFFD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_AFE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_TRE_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_TRE_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_TRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_TRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_TRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_TRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_TRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_TRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MMU_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MMU_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MMU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MMU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MMU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MMU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MMU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_SCTLR_MMU_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_TTBR0_LOW)
/** \brief Context Bank Translation Table Base register 0 Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_TTBR0_HIGH)
/** \brief Context Bank Translation Table Base register 0 Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBR0_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_TTBCR)
/** \brief Context Bank Translation Table Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_EAE_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_EAE_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_EAE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_EAE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_EAE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_EAE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_EAE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_EAE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED1_MASK 0x7fffc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED1_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SH0_MASK 0x3000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SH0_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SH0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SH0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SH0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SH0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SH0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SH0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_ORGN0_MASK 0xc00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_ORGN0_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_ORGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_ORGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_ORGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_ORGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_ORGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_ORGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_IRGN0_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_IRGN0_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_IRGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_IRGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_IRGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_IRGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_IRGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_IRGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SL0_MASK 0xc0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SL0_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SL0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SL0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SL0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SL0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SL0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_SL0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED2_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED2_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_S_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_S_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_S_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_S_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_S_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_S_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_S_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_S_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_T0SZ_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_T0SZ_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_T0SZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_T0SZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_T0SZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_T0SZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_T0SZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_TTBCR_T0SZ_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_FSR)
/** \brief Context Bank Fault Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_MULTI_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_MULTI_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_MULTI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_MULTI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_MULTI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_MULTI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_MULTI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_MULTI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_SS_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_SS_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_SS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_SS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_SS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_SS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_SS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_SS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED1_MASK 0x3fffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBLKF_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBLKF_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBLKF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBLKF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBLKF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBLKF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBLKF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBLKF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBMCF_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBMCF_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBMCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBMCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBMCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBMCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBMCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TLBMCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_EF_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_EF_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_EF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_EF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_EF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_EF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_EF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_EF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_PF_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_PF_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_PF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_PF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_PF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_PF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_PF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_PF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_AFF_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_AFF_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_AFF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_AFF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_AFF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_AFF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_AFF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_AFF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TF_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TF_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_TF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED2_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED2_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSR_RESERVED2_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_FSRRESTORE)
/** \brief Context Bank Fault Status Restore register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSRRESTORE_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSRRESTORE_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSRRESTORE_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSRRESTORE_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSRRESTORE_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSRRESTORE_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSRRESTORE_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSRRESTORE_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_FAR_LOW)
/** \brief Context Bank Fault Address register Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_FAR_HIGH)
/** \brief Context Bank Fault Address register Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FAR_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_FSYNR0)
/** \brief Context Bank Fault Syndrome register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED1_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED1_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_S1CBNDX_MASK 0xff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_S1CBNDX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_S1CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_S1CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_S1CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_S1CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_S1CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_S1CBNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_AFR_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_AFR_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_AFR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_AFR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_AFR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_AFR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_AFR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_AFR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PTWF_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PTWF_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PTWF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PTWF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PTWF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PTWF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PTWF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PTWF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_ATOF_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_ATOF_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_ATOF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_ATOF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_ATOF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_ATOF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_ATOF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_ATOF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSATTR_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSATTR_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSSTATE_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSSTATE_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSSTATE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSSTATE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSSTATE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSSTATE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSSTATE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_NSSTATE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_IND_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_IND_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_IND_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_IND_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_IND_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_IND_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_IND_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_IND_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PNU_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PNU_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PNU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PNU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PNU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PNU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PNU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PNU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_WNR_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_WNR_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_WNR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_WNR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_WNR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_WNR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_WNR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_WNR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_STAGE_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_STAGE_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_STAGE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_STAGE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_STAGE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_STAGE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_STAGE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_STAGE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED3_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED3_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PLVL_MASK 0x3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PLVL_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PLVL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PLVL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PLVL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PLVL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PLVL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_FSYNR0_PLVL_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMXEVCNTR0)
/** \brief Performance Monitor Context Bank Event Counter 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR0_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR0_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR0_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR0_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR0_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR0_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR0_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR0_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMXEVCNTR1)
/** \brief Performance Monitor Context Bank Event Counter 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR1_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR1_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR1_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR1_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR1_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR1_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR1_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR1_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMXEVCNTR2)
/** \brief Performance Monitor Context Bank Event Counter 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR2_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR2_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR2_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR2_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR2_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR2_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR2_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVCNTR2_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMXEVTYPER0)
/** \brief Performance Monitor Context Bank Event Type register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER0_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMXEVTYPER1)
/** \brief Performance Monitor Context Bank Event Type register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER1_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMXEVTYPER2)
/** \brief Performance Monitor Context Bank Event Type register 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMXEVTYPER2_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMCFGR)
/** \brief Performance Monitor Context Bank Configuration register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NCG_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NCG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NCG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NCG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NCG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NCG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NCG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NCG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RESERVED1_MASK 0xf00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RESERVED1_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_UEN_MASK 0x80000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_UEN_SHIFT 19
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_UEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_UEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_UEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_UEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_UEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_UEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_WT_MASK 0x40000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_WT_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NA_MASK 0x20000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NA_SHIFT 17
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_EX_MASK 0x10000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_EX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CCD_MASK 0x8000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CCD_SHIFT 15
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CC_MASK 0x4000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CC_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_CC_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAZ_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAZ_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAZ_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_SIZE_MASK 0x1800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_SIZE_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_SIZE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_SIZE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_SIZE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_SIZE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_SIZE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_SIZE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAO_MASK 0x700
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAO_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAO_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAO_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAO_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAO_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAO_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_RAO_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NUM_CNT_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NUM_CNT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NUM_CNT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NUM_CNT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NUM_CNT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NUM_CNT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NUM_CNT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCFGR_NUM_CNT_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMCR)
/** \brief Performance Monitor Context Bank Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_WT_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_WT_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_NA_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_NA_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_DP_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_DP_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_DP_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_DP_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_DP_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_DP_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_DP_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_DP_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_EX_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_EX_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCR_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCR_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CCR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RST_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RST_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RST_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RST_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RST_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RST_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RST_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_RST_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CEN_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CEN_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCR_CEN_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMCEID)
/** \brief Performance Monitor Context Bank Event Identification register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RESERVED1_MASK 0xffffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_ACCESS_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_ACCESS_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_ACCESS_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_ACCESS_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_ACCESS_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_ACCESS_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_REFILL_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_REFILL_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_WR_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_REFILL_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_REFILL_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_RD_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_REFILL_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_REFILL_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_CC_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_CC_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCEID_CC_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMCNTENSE)
/** \brief Performance Monitor Context Bank Count Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSE_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMCNTENCLEAR)
/** \brief Performance Monitor Context Bank Count Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMCNTENSET)
/** \brief Performance Monitor Context Bank Interrupt Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMCNTENSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMINTENCLEAR)
/** \brief Performance Monitor Context Bank Interrupt Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMINTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMOVSCLR)
/** \brief Performance Monitor Context Bank Overflow Status Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSCLR_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMOVSSET)
/** \brief Performance Monitor Context Bank Overflow Status Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMOVSSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB4_PMAUTHSTATUS)
/** \brief Performance Monitor Context Bank Authentication Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNI_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNI_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SI_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SI_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SE_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SE_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_SE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNI_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNI_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSI_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSI_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSE_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSE_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB4_PMAUTHSTATUS_NSE_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_SCTLR)
/** \brief Context Bank System Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_WACFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_WACFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RACFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RACFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_SHCFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_SHCFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_FB_MASK 0x200000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_FB_SHIFT 21
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_FB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_FB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_FB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_FB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_FB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_FB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED2_MASK 0x100000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED2_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MEM_ATTR_MASK 0xf0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MEM_ATTR_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_BSU_MASK 0xc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_BSU_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_BSU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_BSU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_BSU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_BSU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_BSU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_BSU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_PTW_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_PTW_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_PTW_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_PTW_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_PTW_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_PTW_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_PTW_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_PTW_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED3_MASK 0x1e00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED3_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_HUPCF_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_HUPCF_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_HUPCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_HUPCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_HUPCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_HUPCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_HUPCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_HUPCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFCFG_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFCFG_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFIE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFIE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFIE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFIE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFIE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFIE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFIE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFIE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFRE_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFRE_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_CFRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_ENDIAN_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_ENDIAN_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_ENDIAN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_ENDIAN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_ENDIAN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_ENDIAN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_ENDIAN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFFD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFFD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFFD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFFD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFFD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFFD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFFD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFFD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_AFE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_TRE_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_TRE_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_TRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_TRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_TRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_TRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_TRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_TRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MMU_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MMU_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MMU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MMU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MMU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MMU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MMU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_SCTLR_MMU_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_TTBR0_LOW)
/** \brief Context Bank Translation Table Base register 0 Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_TTBR0_HIGH)
/** \brief Context Bank Translation Table Base register 0 Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBR0_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_TTBCR)
/** \brief Context Bank Translation Table Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_EAE_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_EAE_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_EAE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_EAE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_EAE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_EAE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_EAE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_EAE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED1_MASK 0x7fffc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED1_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SH0_MASK 0x3000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SH0_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SH0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SH0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SH0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SH0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SH0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SH0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_ORGN0_MASK 0xc00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_ORGN0_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_ORGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_ORGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_ORGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_ORGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_ORGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_ORGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_IRGN0_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_IRGN0_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_IRGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_IRGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_IRGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_IRGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_IRGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_IRGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SL0_MASK 0xc0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SL0_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SL0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SL0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SL0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SL0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SL0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_SL0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED2_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED2_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_S_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_S_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_S_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_S_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_S_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_S_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_S_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_S_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_T0SZ_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_T0SZ_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_T0SZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_T0SZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_T0SZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_T0SZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_T0SZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_TTBCR_T0SZ_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_FSR)
/** \brief Context Bank Fault Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_MULTI_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_MULTI_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_MULTI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_MULTI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_MULTI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_MULTI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_MULTI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_MULTI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_SS_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_SS_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_SS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_SS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_SS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_SS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_SS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_SS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED1_MASK 0x3fffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBLKF_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBLKF_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBLKF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBLKF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBLKF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBLKF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBLKF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBLKF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBMCF_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBMCF_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBMCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBMCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBMCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBMCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBMCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TLBMCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_EF_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_EF_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_EF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_EF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_EF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_EF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_EF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_EF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_PF_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_PF_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_PF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_PF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_PF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_PF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_PF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_PF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_AFF_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_AFF_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_AFF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_AFF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_AFF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_AFF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_AFF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_AFF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TF_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TF_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_TF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED2_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED2_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSR_RESERVED2_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_FSRRESTORE)
/** \brief Context Bank Fault Status Restore register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSRRESTORE_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSRRESTORE_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSRRESTORE_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSRRESTORE_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSRRESTORE_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSRRESTORE_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSRRESTORE_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSRRESTORE_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_FAR_LOW)
/** \brief Context Bank Fault Address register Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_FAR_HIGH)
/** \brief Context Bank Fault Address register Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FAR_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_FSYNR0)
/** \brief Context Bank Fault Syndrome register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED1_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED1_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_S1CBNDX_MASK 0xff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_S1CBNDX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_S1CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_S1CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_S1CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_S1CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_S1CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_S1CBNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_AFR_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_AFR_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_AFR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_AFR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_AFR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_AFR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_AFR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_AFR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PTWF_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PTWF_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PTWF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PTWF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PTWF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PTWF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PTWF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PTWF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_ATOF_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_ATOF_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_ATOF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_ATOF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_ATOF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_ATOF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_ATOF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_ATOF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSATTR_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSATTR_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSSTATE_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSSTATE_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSSTATE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSSTATE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSSTATE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSSTATE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSSTATE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_NSSTATE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_IND_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_IND_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_IND_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_IND_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_IND_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_IND_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_IND_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_IND_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PNU_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PNU_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PNU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PNU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PNU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PNU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PNU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PNU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_WNR_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_WNR_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_WNR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_WNR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_WNR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_WNR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_WNR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_WNR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_STAGE_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_STAGE_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_STAGE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_STAGE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_STAGE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_STAGE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_STAGE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_STAGE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED3_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED3_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PLVL_MASK 0x3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PLVL_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PLVL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PLVL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PLVL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PLVL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PLVL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_FSYNR0_PLVL_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMXEVCNTR0)
/** \brief Performance Monitor Context Bank Event Counter 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR0_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR0_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR0_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR0_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR0_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR0_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR0_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR0_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMXEVCNTR1)
/** \brief Performance Monitor Context Bank Event Counter 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR1_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR1_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR1_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR1_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR1_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR1_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR1_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR1_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMXEVCNTR2)
/** \brief Performance Monitor Context Bank Event Counter 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR2_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR2_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR2_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR2_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR2_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR2_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR2_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVCNTR2_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMXEVTYPER0)
/** \brief Performance Monitor Context Bank Event Type register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER0_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMXEVTYPER1)
/** \brief Performance Monitor Context Bank Event Type register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER1_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMXEVTYPER2)
/** \brief Performance Monitor Context Bank Event Type register 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMXEVTYPER2_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMCFGR)
/** \brief Performance Monitor Context Bank Configuration register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NCG_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NCG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NCG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NCG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NCG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NCG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NCG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NCG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RESERVED1_MASK 0xf00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RESERVED1_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_UEN_MASK 0x80000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_UEN_SHIFT 19
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_UEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_UEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_UEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_UEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_UEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_UEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_WT_MASK 0x40000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_WT_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NA_MASK 0x20000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NA_SHIFT 17
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_EX_MASK 0x10000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_EX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CCD_MASK 0x8000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CCD_SHIFT 15
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CC_MASK 0x4000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CC_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_CC_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAZ_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAZ_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAZ_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_SIZE_MASK 0x1800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_SIZE_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_SIZE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_SIZE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_SIZE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_SIZE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_SIZE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_SIZE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAO_MASK 0x700
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAO_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAO_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAO_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAO_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAO_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAO_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_RAO_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NUM_CNT_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NUM_CNT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NUM_CNT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NUM_CNT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NUM_CNT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NUM_CNT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NUM_CNT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCFGR_NUM_CNT_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMCR)
/** \brief Performance Monitor Context Bank Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_WT_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_WT_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_NA_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_NA_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_DP_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_DP_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_DP_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_DP_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_DP_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_DP_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_DP_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_DP_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_EX_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_EX_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCR_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCR_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CCR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RST_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RST_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RST_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RST_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RST_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RST_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RST_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_RST_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CEN_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CEN_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCR_CEN_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMCEID)
/** \brief Performance Monitor Context Bank Event Identification register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RESERVED1_MASK 0xffffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_ACCESS_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_ACCESS_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_ACCESS_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_ACCESS_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_ACCESS_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_ACCESS_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_REFILL_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_REFILL_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_WR_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_REFILL_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_REFILL_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_RD_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_REFILL_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_REFILL_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_CC_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_CC_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCEID_CC_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMCNTENSE)
/** \brief Performance Monitor Context Bank Count Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSE_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMCNTENCLEAR)
/** \brief Performance Monitor Context Bank Count Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMCNTENSET)
/** \brief Performance Monitor Context Bank Interrupt Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMCNTENSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMINTENCLEAR)
/** \brief Performance Monitor Context Bank Interrupt Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMINTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMOVSCLR)
/** \brief Performance Monitor Context Bank Overflow Status Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSCLR_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMOVSSET)
/** \brief Performance Monitor Context Bank Overflow Status Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMOVSSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB5_PMAUTHSTATUS)
/** \brief Performance Monitor Context Bank Authentication Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNI_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNI_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SI_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SI_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SE_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SE_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_SE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNI_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNI_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSI_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSI_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSE_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSE_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB5_PMAUTHSTATUS_NSE_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_SCTLR)
/** \brief Context Bank System Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_WACFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_WACFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RACFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RACFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_SHCFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_SHCFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_FB_MASK 0x200000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_FB_SHIFT 21
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_FB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_FB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_FB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_FB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_FB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_FB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED2_MASK 0x100000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED2_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MEM_ATTR_MASK 0xf0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MEM_ATTR_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_BSU_MASK 0xc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_BSU_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_BSU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_BSU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_BSU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_BSU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_BSU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_BSU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_PTW_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_PTW_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_PTW_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_PTW_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_PTW_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_PTW_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_PTW_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_PTW_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED3_MASK 0x1e00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED3_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_HUPCF_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_HUPCF_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_HUPCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_HUPCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_HUPCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_HUPCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_HUPCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_HUPCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFCFG_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFCFG_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFIE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFIE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFIE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFIE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFIE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFIE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFIE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFIE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFRE_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFRE_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_CFRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_ENDIAN_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_ENDIAN_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_ENDIAN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_ENDIAN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_ENDIAN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_ENDIAN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_ENDIAN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFFD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFFD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFFD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFFD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFFD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFFD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFFD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFFD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_AFE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_TRE_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_TRE_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_TRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_TRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_TRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_TRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_TRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_TRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MMU_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MMU_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MMU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MMU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MMU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MMU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MMU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_SCTLR_MMU_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_TTBR0_LOW)
/** \brief Context Bank Translation Table Base register 0 Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_TTBR0_HIGH)
/** \brief Context Bank Translation Table Base register 0 Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBR0_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_TTBCR)
/** \brief Context Bank Translation Table Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_EAE_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_EAE_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_EAE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_EAE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_EAE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_EAE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_EAE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_EAE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED1_MASK 0x7fffc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED1_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SH0_MASK 0x3000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SH0_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SH0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SH0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SH0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SH0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SH0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SH0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_ORGN0_MASK 0xc00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_ORGN0_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_ORGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_ORGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_ORGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_ORGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_ORGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_ORGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_IRGN0_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_IRGN0_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_IRGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_IRGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_IRGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_IRGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_IRGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_IRGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SL0_MASK 0xc0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SL0_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SL0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SL0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SL0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SL0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SL0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_SL0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED2_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED2_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_S_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_S_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_S_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_S_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_S_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_S_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_S_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_S_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_T0SZ_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_T0SZ_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_T0SZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_T0SZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_T0SZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_T0SZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_T0SZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_TTBCR_T0SZ_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_FSR)
/** \brief Context Bank Fault Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_MULTI_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_MULTI_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_MULTI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_MULTI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_MULTI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_MULTI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_MULTI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_MULTI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_SS_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_SS_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_SS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_SS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_SS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_SS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_SS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_SS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED1_MASK 0x3fffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBLKF_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBLKF_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBLKF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBLKF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBLKF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBLKF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBLKF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBLKF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBMCF_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBMCF_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBMCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBMCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBMCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBMCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBMCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TLBMCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_EF_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_EF_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_EF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_EF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_EF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_EF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_EF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_EF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_PF_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_PF_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_PF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_PF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_PF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_PF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_PF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_PF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_AFF_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_AFF_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_AFF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_AFF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_AFF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_AFF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_AFF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_AFF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TF_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TF_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_TF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED2_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED2_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSR_RESERVED2_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_FSRRESTORE)
/** \brief Context Bank Fault Status Restore register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSRRESTORE_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSRRESTORE_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSRRESTORE_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSRRESTORE_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSRRESTORE_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSRRESTORE_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSRRESTORE_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSRRESTORE_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_FAR_LOW)
/** \brief Context Bank Fault Address register Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_FAR_HIGH)
/** \brief Context Bank Fault Address register Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FAR_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_FSYNR0)
/** \brief Context Bank Fault Syndrome register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED1_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED1_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_S1CBNDX_MASK 0xff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_S1CBNDX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_S1CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_S1CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_S1CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_S1CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_S1CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_S1CBNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_AFR_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_AFR_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_AFR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_AFR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_AFR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_AFR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_AFR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_AFR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PTWF_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PTWF_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PTWF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PTWF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PTWF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PTWF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PTWF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PTWF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_ATOF_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_ATOF_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_ATOF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_ATOF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_ATOF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_ATOF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_ATOF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_ATOF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSATTR_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSATTR_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSSTATE_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSSTATE_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSSTATE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSSTATE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSSTATE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSSTATE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSSTATE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_NSSTATE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_IND_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_IND_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_IND_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_IND_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_IND_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_IND_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_IND_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_IND_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PNU_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PNU_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PNU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PNU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PNU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PNU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PNU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PNU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_WNR_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_WNR_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_WNR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_WNR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_WNR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_WNR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_WNR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_WNR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_STAGE_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_STAGE_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_STAGE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_STAGE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_STAGE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_STAGE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_STAGE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_STAGE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED3_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED3_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PLVL_MASK 0x3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PLVL_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PLVL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PLVL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PLVL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PLVL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PLVL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_FSYNR0_PLVL_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMXEVCNTR0)
/** \brief Performance Monitor Context Bank Event Counter 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR0_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR0_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR0_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR0_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR0_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR0_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR0_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR0_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMXEVCNTR1)
/** \brief Performance Monitor Context Bank Event Counter 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR1_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR1_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR1_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR1_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR1_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR1_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR1_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR1_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMXEVCNTR2)
/** \brief Performance Monitor Context Bank Event Counter 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR2_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR2_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR2_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR2_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR2_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR2_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR2_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVCNTR2_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMXEVTYPER0)
/** \brief Performance Monitor Context Bank Event Type register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER0_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMXEVTYPER1)
/** \brief Performance Monitor Context Bank Event Type register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER1_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMXEVTYPER2)
/** \brief Performance Monitor Context Bank Event Type register 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMXEVTYPER2_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMCFGR)
/** \brief Performance Monitor Context Bank Configuration register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NCG_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NCG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NCG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NCG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NCG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NCG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NCG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NCG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RESERVED1_MASK 0xf00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RESERVED1_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_UEN_MASK 0x80000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_UEN_SHIFT 19
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_UEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_UEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_UEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_UEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_UEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_UEN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_WT_MASK 0x40000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_WT_SHIFT 18
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NA_MASK 0x20000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NA_SHIFT 17
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_EX_MASK 0x10000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_EX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CCD_MASK 0x8000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CCD_SHIFT 15
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CC_MASK 0x4000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CC_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_CC_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAZ_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAZ_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAZ_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_SIZE_MASK 0x1800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_SIZE_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_SIZE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_SIZE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_SIZE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_SIZE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_SIZE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_SIZE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAO_MASK 0x700
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAO_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAO_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAO_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAO_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAO_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAO_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_RAO_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NUM_CNT_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NUM_CNT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NUM_CNT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NUM_CNT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NUM_CNT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NUM_CNT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NUM_CNT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCFGR_NUM_CNT_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMCR)
/** \brief Performance Monitor Context Bank Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_WT_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_WT_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_WT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_WT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_WT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_WT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_WT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_WT_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_NA_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_NA_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_NA_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_NA_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_NA_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_NA_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_NA_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_NA_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_DP_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_DP_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_DP_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_DP_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_DP_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_DP_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_DP_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_DP_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_EX_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_EX_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_EX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_EX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_EX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_EX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_EX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_EX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCR_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCR_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CCR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RST_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RST_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RST_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RST_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RST_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RST_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RST_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_RST_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CEN_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CEN_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CEN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CEN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CEN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CEN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CEN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCR_CEN_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMCEID)
/** \brief Performance Monitor Context Bank Event Identification register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RESERVED1_MASK 0xffffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_ACCESS_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_ACCESS_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_ACCESS_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_ACCESS_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_ACCESS_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_ACCESS_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_ACCESS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_ACCESS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_ACCESS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_ACCESS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_ACCESS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_REFILL_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_REFILL_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_WR_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_REFILL_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_REFILL_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_RD_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_REFILL_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_REFILL_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_REFILL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_REFILL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_REFILL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_REFILL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_REFILL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_REFILL_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_CC_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_CC_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_CC_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_CC_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_CC_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_CC_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_CC_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCEID_CC_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMCNTENSE)
/** \brief Performance Monitor Context Bank Count Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSE_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMCNTENCLEAR)
/** \brief Performance Monitor Context Bank Count Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMCNTENSET)
/** \brief Performance Monitor Context Bank Interrupt Enable Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMCNTENSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMINTENCLEAR)
/** \brief Performance Monitor Context Bank Interrupt Enable Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_DISAB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_DISAB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_DISAB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_DISAB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_DISAB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_DISAB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_DISAB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMINTENCLEAR_DISAB_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMOVSCLR)
/** \brief Performance Monitor Context Bank Overflow Status Clear register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSCLR_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMOVSSET)
/** \brief Performance Monitor Context Bank Overflow Status Set register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_RESERVED1_MASK 0xfffffff8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_RESERVED1_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_ENB_MASK 0x7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_ENB_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_ENB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_ENB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_ENB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_ENB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_ENB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMOVSSET_ENB_SHIFT))

//====================================================================
//Register:  (SMMU_CB6_PMAUTHSTATUS)
/** \brief Performance Monitor Context Bank Authentication Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNI_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNI_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SI_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SI_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SE_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SE_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_SE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNI_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNI_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSNE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSI_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSI_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSE_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSE_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB6_PMAUTHSTATUS_NSE_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_SCTLR)
/** \brief Context Bank System Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED1_MASK 0xf0000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED1_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_WACFG_MASK 0xc000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_WACFG_SHIFT 26
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_WACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_WACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_WACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_WACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_WACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_WACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RACFG_MASK 0x3000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RACFG_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RACFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RACFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RACFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RACFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RACFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RACFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_SHCFG_MASK 0xc00000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_SHCFG_SHIFT 22
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_SHCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_SHCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_SHCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_SHCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_SHCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_SHCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_FB_MASK 0x200000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_FB_SHIFT 21
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_FB_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_FB_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_FB_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_FB_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_FB_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_FB_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED2_MASK 0x100000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED2_SHIFT 20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MEM_ATTR_MASK 0xf0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MEM_ATTR_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MEM_ATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MEM_ATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MEM_ATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MEM_ATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MEM_ATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MEM_ATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_BSU_MASK 0xc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_BSU_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_BSU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_BSU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_BSU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_BSU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_BSU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_BSU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_PTW_MASK 0x2000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_PTW_SHIFT 13
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_PTW_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_PTW_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_PTW_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_PTW_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_PTW_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_PTW_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED3_MASK 0x1e00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED3_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_HUPCF_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_HUPCF_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_HUPCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_HUPCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_HUPCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_HUPCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_HUPCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_HUPCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFCFG_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFCFG_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFCFG_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFCFG_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFCFG_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFCFG_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFCFG_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFCFG_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFIE_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFIE_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFIE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFIE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFIE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFIE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFIE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFIE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFRE_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFRE_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_CFRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_ENDIAN_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_ENDIAN_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_ENDIAN_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_ENDIAN_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_ENDIAN_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_ENDIAN_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_ENDIAN_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFFD_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFFD_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFFD_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFFD_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFFD_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFFD_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFFD_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFFD_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFE_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFE_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_AFE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_TRE_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_TRE_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_TRE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_TRE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_TRE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_TRE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_TRE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_TRE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MMU_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MMU_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MMU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MMU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MMU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MMU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MMU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_SCTLR_MMU_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_TTBR0_LOW)
/** \brief Context Bank Translation Table Base register 0 Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_TTBR0_HIGH)
/** \brief Context Bank Translation Table Base register 0 Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBR0_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_TTBCR)
/** \brief Context Bank Translation Table Control register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_EAE_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_EAE_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_EAE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_EAE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_EAE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_EAE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_EAE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_EAE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED1_MASK 0x7fffc000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED1_SHIFT 14
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SH0_MASK 0x3000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SH0_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SH0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SH0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SH0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SH0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SH0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SH0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_ORGN0_MASK 0xc00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_ORGN0_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_ORGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_ORGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_ORGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_ORGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_ORGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_ORGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_IRGN0_MASK 0x300
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_IRGN0_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_IRGN0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_IRGN0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_IRGN0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_IRGN0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_IRGN0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_IRGN0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SL0_MASK 0xc0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SL0_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SL0_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SL0_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SL0_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SL0_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SL0_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_SL0_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED2_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED2_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_S_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_S_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_S_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_S_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_S_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_S_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_S_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_S_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_T0SZ_MASK 0xf
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_T0SZ_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_T0SZ_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_T0SZ_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_T0SZ_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_T0SZ_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_T0SZ_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_TTBCR_T0SZ_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_FSR)
/** \brief Context Bank Fault Status register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_MULTI_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_MULTI_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_MULTI_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_MULTI_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_MULTI_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_MULTI_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_MULTI_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_MULTI_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_SS_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_SS_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_SS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_SS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_SS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_SS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_SS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_SS_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED1_MASK 0x3fffff80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED1_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBLKF_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBLKF_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBLKF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBLKF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBLKF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBLKF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBLKF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBLKF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBMCF_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBMCF_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBMCF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBMCF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBMCF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBMCF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBMCF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TLBMCF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_EF_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_EF_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_EF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_EF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_EF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_EF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_EF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_EF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_PF_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_PF_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_PF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_PF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_PF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_PF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_PF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_PF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_AFF_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_AFF_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_AFF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_AFF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_AFF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_AFF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_AFF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_AFF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TF_MASK 0x2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TF_SHIFT 1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_TF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED2_MASK 0x1
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED2_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSR_RESERVED2_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_FSRRESTORE)
/** \brief Context Bank Fault Status Restore register*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSRRESTORE_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSRRESTORE_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSRRESTORE_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSRRESTORE_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSRRESTORE_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSRRESTORE_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSRRESTORE_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSRRESTORE_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_FAR_LOW)
/** \brief Context Bank Fault Address register Lower bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_LOW_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_LOW_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_LOW_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_LOW_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_LOW_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_LOW_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_LOW_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_LOW_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_FAR_HIGH)
/** \brief Context Bank Fault Address register Upper bits*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_RESERVED1_MASK 0xffffff00
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_RESERVED1_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_BITS_MASK 0xff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FAR_HIGH_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_FSYNR0)
/** \brief Context Bank Fault Syndrome register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED1_MASK 0xff000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED1_SHIFT 24
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_S1CBNDX_MASK 0xff0000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_S1CBNDX_SHIFT 16
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_S1CBNDX_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_S1CBNDX_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_S1CBNDX_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_S1CBNDX_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_S1CBNDX_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_S1CBNDX_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED2_MASK 0xf000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED2_SHIFT 12
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED2_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED2_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED2_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED2_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED2_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_AFR_MASK 0x800
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_AFR_SHIFT 11
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_AFR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_AFR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_AFR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_AFR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_AFR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_AFR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PTWF_MASK 0x400
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PTWF_SHIFT 10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PTWF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PTWF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PTWF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PTWF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PTWF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PTWF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_ATOF_MASK 0x200
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_ATOF_SHIFT 9
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_ATOF_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_ATOF_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_ATOF_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_ATOF_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_ATOF_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_ATOF_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSATTR_MASK 0x100
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSATTR_SHIFT 8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSATTR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSATTR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSATTR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSATTR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSATTR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSATTR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSSTATE_MASK 0x80
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSSTATE_SHIFT 7
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSSTATE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSSTATE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSSTATE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSSTATE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSSTATE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_NSSTATE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_IND_MASK 0x40
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_IND_SHIFT 6
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_IND_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_IND_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_IND_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_IND_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_IND_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_IND_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PNU_MASK 0x20
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PNU_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PNU_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PNU_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PNU_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PNU_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PNU_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PNU_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_WNR_MASK 0x10
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_WNR_SHIFT 4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_WNR_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_WNR_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_WNR_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_WNR_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_WNR_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_WNR_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_STAGE_MASK 0x8
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_STAGE_SHIFT 3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_STAGE_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_STAGE_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_STAGE_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_STAGE_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_STAGE_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_STAGE_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED3_MASK 0x4
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED3_SHIFT 2
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED3_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED3_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED3_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED3_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_RESERVED3_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PLVL_MASK 0x3
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PLVL_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PLVL_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PLVL_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PLVL_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PLVL_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PLVL_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_FSYNR0_PLVL_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_PMXEVCNTR0)
/** \brief Performance Monitor Context Bank Event Counter 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR0_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR0_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR0_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR0_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR0_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR0_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR0_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR0_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_PMXEVCNTR1)
/** \brief Performance Monitor Context Bank Event Counter 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR1_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR1_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR1_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR1_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR1_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR1_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR1_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR1_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_PMXEVCNTR2)
/** \brief Performance Monitor Context Bank Event Counter 2*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR2_BITS_MASK 0xffffffff
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR2_BITS_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR2_BITS_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR2_BITS_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR2_BITS_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR2_BITS_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR2_BITS_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVCNTR2_BITS_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_PMXEVTYPER0)
/** \brief Performance Monitor Context Bank Event Type register 0*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSUNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_NSUNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_RESERVED1_MASK 0xfffffe0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_RESERVED1_SHIFT 5
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_RESERVED1_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_RESERVED1_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_RESERVED1_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_RESERVED1_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_RESERVED1_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_EVENT_MASK 0x1f
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_EVENT_SHIFT 0
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_EVENT_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_EVENT_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_EVENT_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_EVENT_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_EVENT_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER0_EVENT_SHIFT))

//====================================================================
//Register:  (SMMU_CB7_PMXEVTYPER1)
/** \brief Performance Monitor Context Bank Event Type register 1*/
//====================================================================

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_PRV_MASK 0x80000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_PRV_SHIFT 31
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_PRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_PRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_PRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_PRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_PRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_PRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_UNPRV_MASK 0x40000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_UNPRV_SHIFT 30
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_UNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_UNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_UNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_UNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_UNPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_UNPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSPRV_MASK 0x20000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSPRV_SHIFT 29
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSPRV_MASK) | (((uint32_t)val) << MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSPRV_SHIFT))

#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSUNPRV_MASK 0x10000000
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSUNPRV_SHIFT 28
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSUNPRV_MASK_SHIFT(reg) (((reg) & MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSUNPRV_MASK) >> MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSUNPRV_SHIFT)
#define  MMU400_SMMU_GR2_A3_NS_SMMU_CB7_PMXEVTYPER1_NSUNPRV_REPLACE_VAL(reg,val) (((reg) & ~MMU400_SMMU_GR2_