 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SKEWDET_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SKEWDET_REGSTRUCTS_H_
#define _SKEWDET_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SKEWDET (SKEWDET)
/** \brief Register descriptions for the SKEWDET block.*/
//
//====================================================================

typedef struct SKEWDET_REGS_s
{
  volatile uint32_t CA;  ///< 0x0 [R/W]: Channel Address
  volatile uint32_t Ctl;  ///< 0x4 [R/W]: Control
  volatile uint32_t Compare;  ///< 0x8 [R/W]: Compare Threshold
  volatile uint32_t MaxLineCnt;  ///< 0xc [R/W]: Max Line Count
  volatile uint32_t RdMemAddr;  ///< 0x10 [R]: Read Memory Address
  volatile uint32_t WrMemAddr;  ///< 0x14 [W]: Write Memory Address
  volatile uint32_t RdMemData;  ///< 0x18 [R]: Memory Read
  volatile uint32_t WrMemData;  ///< 0x1c [W]: Memory Write
  volatile uint32_t int_enable;  ///< 0x20 [R/W]: Interrupt enable register
  volatile uint32_t int_pending;  ///< 0x24 [R]: Interrupt pending register
  volatile uint32_t int_status;  ///< 0x28 [R]: Interrupt status register
  volatile uint32_t int_ack;  ///< 0x2c [W]: Interrupt acknowledge register
  volatile uint32_t int_force;  ///< 0x30 [W]: Interrupt force register
  volatile uint32_t REV0;  ///< 0x34 [R]: SKEWDET Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: SKEWDET Tagging Revision 1
} SKEWDET_REGS_t;

#endif // SKEWDET
