 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SKEWDET_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SKEWDET_REGMASKS_H_
#define _SKEWDET_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SKEWDET (SKEWDET)
/** \brief Register descriptions for the SKEWDET block.*/
//
//====================================================================

//====================================================================
//Register: SKEWDET Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  SKEWDET_REV0_MAJ_MASK 0xffff0000
#define  SKEWDET_REV0_MAJ_SHIFT 16
#define  SKEWDET_REV0_MAJ_MASK_SHIFT(reg) (((reg) & SKEWDET_REV0_MAJ_MASK) >> SKEWDET_REV0_MAJ_SHIFT)
#define  SKEWDET_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_REV0_MAJ_MASK) | (((uint32_t)val) << SKEWDET_REV0_MAJ_SHIFT))

#define  SKEWDET_REV0_MID_MASK 0xffff
#define  SKEWDET_REV0_MID_SHIFT 0
#define  SKEWDET_REV0_MID_MASK_SHIFT(reg) (((reg) & SKEWDET_REV0_MID_MASK) >> SKEWDET_REV0_MID_SHIFT)
#define  SKEWDET_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_REV0_MID_MASK) | (((uint32_t)val) << SKEWDET_REV0_MID_SHIFT))

//====================================================================
//Register: SKEWDET Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  SKEWDET_REV1_RESERVED1_MASK 0xffff0000
#define  SKEWDET_REV1_RESERVED1_SHIFT 16
#define  SKEWDET_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_REV1_RESERVED1_MASK) >> SKEWDET_REV1_RESERVED1_SHIFT)
#define  SKEWDET_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_REV1_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_REV1_RESERVED1_SHIFT))

#define  SKEWDET_REV1_CFG_MASK 0xffff
#define  SKEWDET_REV1_CFG_SHIFT 0
#define  SKEWDET_REV1_CFG_MASK_SHIFT(reg) (((reg) & SKEWDET_REV1_CFG_MASK) >> SKEWDET_REV1_CFG_SHIFT)
#define  SKEWDET_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_REV1_CFG_MASK) | (((uint32_t)val) << SKEWDET_REV1_CFG_SHIFT))

//====================================================================
//Register: Channel Address (CA)
//====================================================================

#define  SKEWDET_CA_RESERVED1_MASK 0xfffffffc
#define  SKEWDET_CA_RESERVED1_SHIFT 2
#define  SKEWDET_CA_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_CA_RESERVED1_MASK) >> SKEWDET_CA_RESERVED1_SHIFT)
#define  SKEWDET_CA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CA_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_CA_RESERVED1_SHIFT))

#define  SKEWDET_CA_ADDR_MASK 0x3
#define  SKEWDET_CA_ADDR_SHIFT 0
#define  SKEWDET_CA_ADDR_MASK_SHIFT(reg) (((reg) & SKEWDET_CA_ADDR_MASK) >> SKEWDET_CA_ADDR_SHIFT)
#define  SKEWDET_CA_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CA_ADDR_MASK) | (((uint32_t)val) << SKEWDET_CA_ADDR_SHIFT))

//====================================================================
//Register: Control (Ctl)
//====================================================================

#define  SKEWDET_CTL_RESERVED1_MASK 0xfffe0000
#define  SKEWDET_CTL_RESERVED1_SHIFT 17
#define  SKEWDET_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_RESERVED1_MASK) >> SKEWDET_CTL_RESERVED1_SHIFT)
#define  SKEWDET_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_CTL_RESERVED1_SHIFT))

#define  SKEWDET_CTL_PX_MASK 0x1f000
#define  SKEWDET_CTL_PX_SHIFT 12
#define  SKEWDET_CTL_PX_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_PX_MASK) >> SKEWDET_CTL_PX_SHIFT)
#define  SKEWDET_CTL_PX_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_PX_MASK) | (((uint32_t)val) << SKEWDET_CTL_PX_SHIFT))

#define  SKEWDET_CTL_RESERVED2_MASK 0xc00
#define  SKEWDET_CTL_RESERVED2_SHIFT 10
#define  SKEWDET_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_RESERVED2_MASK) >> SKEWDET_CTL_RESERVED2_SHIFT)
#define  SKEWDET_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_RESERVED2_MASK) | (((uint32_t)val) << SKEWDET_CTL_RESERVED2_SHIFT))

#define  SKEWDET_CTL_ADVEDGE_MASK 0x200
#define  SKEWDET_CTL_ADVEDGE_SHIFT 9
#define  SKEWDET_CTL_ADVEDGE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_ADVEDGE_MASK) >> SKEWDET_CTL_ADVEDGE_SHIFT)
#define  SKEWDET_CTL_ADVEDGE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_ADVEDGE_MASK) | (((uint32_t)val) << SKEWDET_CTL_ADVEDGE_SHIFT))

#define  SKEWDET_CTL_DIVIDE_MASK 0x1c0
#define  SKEWDET_CTL_DIVIDE_SHIFT 6
#define  SKEWDET_CTL_DIVIDE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_DIVIDE_MASK) >> SKEWDET_CTL_DIVIDE_SHIFT)
#define  SKEWDET_CTL_DIVIDE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_DIVIDE_MASK) | (((uint32_t)val) << SKEWDET_CTL_DIVIDE_SHIFT))

#define  SKEWDET_CTL_DETECTMODE_MASK 0x30
#define  SKEWDET_CTL_DETECTMODE_SHIFT 4
#define  SKEWDET_CTL_DETECTMODE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_DETECTMODE_MASK) >> SKEWDET_CTL_DETECTMODE_SHIFT)
#define  SKEWDET_CTL_DETECTMODE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_DETECTMODE_MASK) | (((uint32_t)val) << SKEWDET_CTL_DETECTMODE_SHIFT))

#define  SKEWDET_CTL_MULTIEDGE_MASK 0x8
#define  SKEWDET_CTL_MULTIEDGE_SHIFT 3
#define  SKEWDET_CTL_MULTIEDGE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_MULTIEDGE_MASK) >> SKEWDET_CTL_MULTIEDGE_SHIFT)
#define  SKEWDET_CTL_MULTIEDGE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_MULTIEDGE_MASK) | (((uint32_t)val) << SKEWDET_CTL_MULTIEDGE_SHIFT))

#define  SKEWDET_CTL_INPUTMODE_MASK 0x6
#define  SKEWDET_CTL_INPUTMODE_SHIFT 1
#define  SKEWDET_CTL_INPUTMODE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_INPUTMODE_MASK) >> SKEWDET_CTL_INPUTMODE_SHIFT)
#define  SKEWDET_CTL_INPUTMODE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_INPUTMODE_MASK) | (((uint32_t)val) << SKEWDET_CTL_INPUTMODE_SHIFT))

#define  SKEWDET_CTL_ENABLE_MASK 0x1
#define  SKEWDET_CTL_ENABLE_SHIFT 0
#define  SKEWDET_CTL_ENABLE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_ENABLE_MASK) >> SKEWDET_CTL_ENABLE_SHIFT)
#define  SKEWDET_CTL_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_ENABLE_MASK) | (((uint32_t)val) << SKEWDET_CTL_ENABLE_SHIFT))

//====================================================================
//Register: Compare Threshold (Compare)
//====================================================================

#define  SKEWDET_COMPARE_RESERVED1_MASK 0xffff0000
#define  SKEWDET_COMPARE_RESERVED1_SHIFT 16
#define  SKEWDET_COMPARE_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_COMPARE_RESERVED1_MASK) >> SKEWDET_COMPARE_RESERVED1_SHIFT)
#define  SKEWDET_COMPARE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_COMPARE_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_COMPARE_RESERVED1_SHIFT))

#define  SKEWDET_COMPARE_THRESHOLD2_MASK 0xff00
#define  SKEWDET_COMPARE_THRESHOLD2_SHIFT 8
#define  SKEWDET_COMPARE_THRESHOLD2_MASK_SHIFT(reg) (((reg) & SKEWDET_COMPARE_THRESHOLD2_MASK) >> SKEWDET_COMPARE_THRESHOLD2_SHIFT)
#define  SKEWDET_COMPARE_THRESHOLD2_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_COMPARE_THRESHOLD2_MASK) | (((uint32_t)val) << SKEWDET_COMPARE_THRESHOLD2_SHIFT))

#define  SKEWDET_COMPARE_THRESHOLD1_MASK 0xff
#define  SKEWDET_COMPARE_THRESHOLD1_SHIFT 0
#define  SKEWDET_COMPARE_THRESHOLD1_MASK_SHIFT(reg) (((reg) & SKEWDET_COMPARE_THRESHOLD1_MASK) >> SKEWDET_COMPARE_THRESHOLD1_SHIFT)
#define  SKEWDET_COMPARE_THRESHOLD1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_COMPARE_THRESHOLD1_MASK) | (((uint32_t)val) << SKEWDET_COMPARE_THRESHOLD1_SHIFT))

//====================================================================
//Register: Max Line Count (MaxLineCnt)
//====================================================================

#define  SKEWDET_MAXLINECNT_RESERVED1_MASK 0xffff0000
#define  SKEWDET_MAXLINECNT_RESERVED1_SHIFT 16
#define  SKEWDET_MAXLINECNT_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_MAXLINECNT_RESERVED1_MASK) >> SKEWDET_MAXLINECNT_RESERVED1_SHIFT)
#define  SKEWDET_MAXLINECNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_MAXLINECNT_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_MAXLINECNT_RESERVED1_SHIFT))

#define  SKEWDET_MAXLINECNT_MAXLINECNT_MASK 0xffff
#define  SKEWDET_MAXLINECNT_MAXLINECNT_SHIFT 0
#define  SKEWDET_MAXLINECNT_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_MAXLINECNT_MAXLINECNT_MASK) >> SKEWDET_MAXLINECNT_MAXLINECNT_SHIFT)
#define  SKEWDET_MAXLINECNT_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_MAXLINECNT_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_MAXLINECNT_MAXLINECNT_SHIFT))

//====================================================================
//Register: Read Memory Address (RdMemAddr)
/** \brief Can read current memory address.*/
//====================================================================

#define  SKEWDET_RDMEMADDR_RESERVED1_MASK 0xfffffc00
#define  SKEWDET_RDMEMADDR_RESERVED1_SHIFT 10
#define  SKEWDET_RDMEMADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_RDMEMADDR_RESERVED1_MASK) >> SKEWDET_RDMEMADDR_RESERVED1_SHIFT)
#define  SKEWDET_RDMEMADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_RDMEMADDR_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_RDMEMADDR_RESERVED1_SHIFT))

#define  SKEWDET_RDMEMADDR_ADDRESS_MASK 0x3ff
#define  SKEWDET_RDMEMADDR_ADDRESS_SHIFT 0
#define  SKEWDET_RDMEMADDR_ADDRESS_MASK_SHIFT(reg) (((reg) & SKEWDET_RDMEMADDR_ADDRESS_MASK) >> SKEWDET_RDMEMADDR_ADDRESS_SHIFT)
#define  SKEWDET_RDMEMADDR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_RDMEMADDR_ADDRESS_MASK) | (((uint32_t)val) << SKEWDET_RDMEMADDR_ADDRESS_SHIFT))

//====================================================================
//Register: Write Memory Address (WrMemAddr)
/** \brief Write memory address.*/
//====================================================================

#define  SKEWDET_WRMEMADDR_RESERVED1_MASK 0xfffffc00
#define  SKEWDET_WRMEMADDR_RESERVED1_SHIFT 10
#define  SKEWDET_WRMEMADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_WRMEMADDR_RESERVED1_MASK) >> SKEWDET_WRMEMADDR_RESERVED1_SHIFT)
#define  SKEWDET_WRMEMADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_WRMEMADDR_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_WRMEMADDR_RESERVED1_SHIFT))

#define  SKEWDET_WRMEMADDR_ADDRESS_MASK 0x3ff
#define  SKEWDET_WRMEMADDR_ADDRESS_SHIFT 0
#define  SKEWDET_WRMEMADDR_ADDRESS_MASK_SHIFT(reg) (((reg) & SKEWDET_WRMEMADDR_ADDRESS_MASK) >> SKEWDET_WRMEMADDR_ADDRESS_SHIFT)
#define  SKEWDET_WRMEMADDR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_WRMEMADDR_ADDRESS_MASK) | (((uint32_t)val) << SKEWDET_WRMEMADDR_ADDRESS_SHIFT))

//====================================================================
//Register: Memory Read (RdMemData)
/** \brief Read the Memory. Used for single edge detect*/
//====================================================================

#define  SKEWDET_RDMEMDATA_RESERVED1_MASK 0xfffc0000
#define  SKEWDET_RDMEMDATA_RESERVED1_SHIFT 18
#define  SKEWDET_RDMEMDATA_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_RDMEMDATA_RESERVED1_MASK) >> SKEWDET_RDMEMDATA_RESERVED1_SHIFT)
#define  SKEWDET_RDMEMDATA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_RDMEMDATA_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_RDMEMDATA_RESERVED1_SHIFT))

#define  SKEWDET_RDMEMDATA_DATA_MASK 0x3ffff
#define  SKEWDET_RDMEMDATA_DATA_SHIFT 0
#define  SKEWDET_RDMEMDATA_DATA_MASK_SHIFT(reg) (((reg) & SKEWDET_RDMEMDATA_DATA_MASK) >> SKEWDET_RDMEMDATA_DATA_SHIFT)
#define  SKEWDET_RDMEMDATA_DATA_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_RDMEMDATA_DATA_MASK) | (((uint32_t)val) << SKEWDET_RDMEMDATA_DATA_SHIFT))

//====================================================================
//Register: Memory Write (WrMemData)
/** \brief Write to line buffer memory. Used only for ram testing*/
//====================================================================

#define  SKEWDET_WRMEMDATA_RESERVED1_MASK 0xfffc0000
#define  SKEWDET_WRMEMDATA_RESERVED1_SHIFT 18
#define  SKEWDET_WRMEMDATA_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_WRMEMDATA_RESERVED1_MASK) >> SKEWDET_WRMEMDATA_RESERVED1_SHIFT)
#define  SKEWDET_WRMEMDATA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_WRMEMDATA_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_WRMEMDATA_RESERVED1_SHIFT))

#define  SKEWDET_WRMEMDATA_DATA_MASK 0x3ffff
#define  SKEWDET_WRMEMDATA_DATA_SHIFT 0
#define  SKEWDET_WRMEMDATA_DATA_MASK_SHIFT(reg) (((reg) & SKEWDET_WRMEMDATA_DATA_MASK) >> SKEWDET_WRMEMDATA_DATA_SHIFT)
#define  SKEWDET_WRMEMDATA_DATA_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_WRMEMDATA_DATA_MASK) | (((uint32_t)val) << SKEWDET_WRMEMDATA_DATA_SHIFT))

//====================================================================
//Register: Interrupt enable register (int_enable)
//====================================================================

#define  SKEWDET_INT_ENABLE_RESERVED1_MASK 0xfffffff8
#define  SKEWDET_INT_ENABLE_RESERVED1_SHIFT 3
#define  SKEWDET_INT_ENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ENABLE_RESERVED1_MASK) >> SKEWDET_INT_ENABLE_RESERVED1_SHIFT)
#define  SKEWDET_INT_ENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ENABLE_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_INT_ENABLE_RESERVED1_SHIFT))

#define  SKEWDET_INT_ENABLE_ALLEDGEDET_MASK 0x4
#define  SKEWDET_INT_ENABLE_ALLEDGEDET_SHIFT 2
#define  SKEWDET_INT_ENABLE_ALLEDGEDET_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ENABLE_ALLEDGEDET_MASK) >> SKEWDET_INT_ENABLE_ALLEDGEDET_SHIFT)
#define  SKEWDET_INT_ENABLE_ALLEDGEDET_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ENABLE_ALLEDGEDET_MASK) | (((uint32_t)val) << SKEWDET_INT_ENABLE_ALLEDGEDET_SHIFT))

#define  SKEWDET_INT_ENABLE_RAMOVERFLOW_MASK 0x2
#define  SKEWDET_INT_ENABLE_RAMOVERFLOW_SHIFT 1
#define  SKEWDET_INT_ENABLE_RAMOVERFLOW_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ENABLE_RAMOVERFLOW_MASK) >> SKEWDET_INT_ENABLE_RAMOVERFLOW_SHIFT)
#define  SKEWDET_INT_ENABLE_RAMOVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ENABLE_RAMOVERFLOW_MASK) | (((uint32_t)val) << SKEWDET_INT_ENABLE_RAMOVERFLOW_SHIFT))

#define  SKEWDET_INT_ENABLE_MAXLINECNT_MASK 0x1
#define  SKEWDET_INT_ENABLE_MAXLINECNT_SHIFT 0
#define  SKEWDET_INT_ENABLE_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ENABLE_MAXLINECNT_MASK) >> SKEWDET_INT_ENABLE_MAXLINECNT_SHIFT)
#define  SKEWDET_INT_ENABLE_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ENABLE_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_INT_ENABLE_MAXLINECNT_SHIFT))

//====================================================================
//Register: Interrupt pending register (int_pending)
//====================================================================

#define  SKEWDET_INT_PENDING_RESERVED1_MASK 0xfffffff8
#define  SKEWDET_INT_PENDING_RESERVED1_SHIFT 3
#define  SKEWDET_INT_PENDING_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_PENDING_RESERVED1_MASK) >> SKEWDET_INT_PENDING_RESERVED1_SHIFT)
#define  SKEWDET_INT_PENDING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_PENDING_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_INT_PENDING_RESERVED1_SHIFT))

#define  SKEWDET_INT_PENDING_ALLEDGEDET_MASK 0x4
#define  SKEWDET_INT_PENDING_ALLEDGEDET_SHIFT 2
#define  SKEWDET_INT_PENDING_ALLEDGEDET_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_PENDING_ALLEDGEDET_MASK) >> SKEWDET_INT_PENDING_ALLEDGEDET_SHIFT)
#define  SKEWDET_INT_PENDING_ALLEDGEDET_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_PENDING_ALLEDGEDET_MASK) | (((uint32_t)val) << SKEWDET_INT_PENDING_ALLEDGEDET_SHIFT))

#define  SKEWDET_INT_PENDING_RAMOVERFLOW_MASK 0x2
#define  SKEWDET_INT_PENDING_RAMOVERFLOW_SHIFT 1
#define  SKEWDET_INT_PENDING_RAMOVERFLOW_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_PENDING_RAMOVERFLOW_MASK) >> SKEWDET_INT_PENDING_RAMOVERFLOW_SHIFT)
#define  SKEWDET_INT_PENDING_RAMOVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_PENDING_RAMOVERFLOW_MASK) | (((uint32_t)val) << SKEWDET_INT_PENDING_RAMOVERFLOW_SHIFT))

#define  SKEWDET_INT_PENDING_MAXLINECNT_MASK 0x1
#define  SKEWDET_INT_PENDING_MAXLINECNT_SHIFT 0
#define  SKEWDET_INT_PENDING_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_PENDING_MAXLINECNT_MASK) >> SKEWDET_INT_PENDING_MAXLINECNT_SHIFT)
#define  SKEWDET_INT_PENDING_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_PENDING_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_INT_PENDING_MAXLINECNT_SHIFT))

//====================================================================
//Register: Interrupt status register (int_status)
//====================================================================

#define  SKEWDET_INT_STATUS_RESERVED1_MASK 0xfffffff8
#define  SKEWDET_INT_STATUS_RESERVED1_SHIFT 3
#define  SKEWDET_INT_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_STATUS_RESERVED1_MASK) >> SKEWDET_INT_STATUS_RESERVED1_SHIFT)
#define  SKEWDET_INT_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_INT_STATUS_RESERVED1_SHIFT))

#define  SKEWDET_INT_STATUS_ALLEDGEDET_MASK 0x4
#define  SKEWDET_INT_STATUS_ALLEDGEDET_SHIFT 2
#define  SKEWDET_INT_STATUS_ALLEDGEDET_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_STATUS_ALLEDGEDET_MASK) >> SKEWDET_INT_STATUS_ALLEDGEDET_SHIFT)
#define  SKEWDET_INT_STATUS_ALLEDGEDET_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_STATUS_ALLEDGEDET_MASK) | (((uint32_t)val) << SKEWDET_INT_STATUS_ALLEDGEDET_SHIFT))

#define  SKEWDET_INT_STATUS_RAMOVERFLOW_MASK 0x2
#define  SKEWDET_INT_STATUS_RAMOVERFLOW_SHIFT 1
#define  SKEWDET_INT_STATUS_RAMOVERFLOW_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_STATUS_RAMOVERFLOW_MASK) >> SKEWDET_INT_STATUS_RAMOVERFLOW_SHIFT)
#define  SKEWDET_INT_STATUS_RAMOVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_STATUS_RAMOVERFLOW_MASK) | (((uint32_t)val) << SKEWDET_INT_STATUS_RAMOVERFLOW_SHIFT))

#define  SKEWDET_INT_STATUS_MAXLINECNT_MASK 0x1
#define  SKEWDET_INT_STATUS_MAXLINECNT_SHIFT 0
#define  SKEWDET_INT_STATUS_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_STATUS_MAXLINECNT_MASK) >> SKEWDET_INT_STATUS_MAXLINECNT_SHIFT)
#define  SKEWDET_INT_STATUS_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_STATUS_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_INT_STATUS_MAXLINECNT_SHIFT))

//====================================================================
//Register: Interrupt acknowledge register (int_ack)
//====================================================================

#define  SKEWDET_INT_ACK_RESERVED1_MASK 0xfffffff8
#define  SKEWDET_INT_ACK_RESERVED1_SHIFT 3
#define  SKEWDET_INT_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ACK_RESERVED1_MASK) >> SKEWDET_INT_ACK_RESERVED1_SHIFT)
#define  SKEWDET_INT_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ACK_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_INT_ACK_RESERVED1_SHIFT))

#define  SKEWDET_INT_ACK_ALLEDGEDET_MASK 0x4
#define  SKEWDET_INT_ACK_ALLEDGEDET_SHIFT 2
#define  SKEWDET_INT_ACK_ALLEDGEDET_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ACK_ALLEDGEDET_MASK) >> SKEWDET_INT_ACK_ALLEDGEDET_SHIFT)
#define  SKEWDET_INT_ACK_ALLEDGEDET_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ACK_ALLEDGEDET_MASK) | (((uint32_t)val) << SKEWDET_INT_ACK_ALLEDGEDET_SHIFT))

#define  SKEWDET_INT_ACK_RAMOVERFLOW_MASK 0x2
#define  SKEWDET_INT_ACK_RAMOVERFLOW_SHIFT 1
#define  SKEWDET_INT_ACK_RAMOVERFLOW_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ACK_RAMOVERFLOW_MASK) >> SKEWDET_INT_ACK_RAMOVERFLOW_SHIFT)
#define  SKEWDET_INT_ACK_RAMOVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ACK_RAMOVERFLOW_MASK) | (((uint32_t)val) << SKEWDET_INT_ACK_RAMOVERFLOW_SHIFT))

#define  SKEWDET_INT_ACK_MAXLINECNT_MASK 0x1
#define  SKEWDET_INT_ACK_MAXLINECNT_SHIFT 0
#define  SKEWDET_INT_ACK_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ACK_MAXLINECNT_MASK) >> SKEWDET_INT_ACK_MAXLINECNT_SHIFT)
#define  SKEWDET_INT_ACK_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ACK_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_INT_ACK_MAXLINECNT_SHIFT))

//====================================================================
//Register: Interrupt force register (int_force)
//====================================================================

#define  SKEWDET_INT_FORCE_RESERVED1_MASK 0xfffffff8
#define  SKEWDET_INT_FORCE_RESERVED1_SHIFT 3
#define  SKEWDET_INT_FORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_FORCE_RESERVED1_MASK) >> SKEWDET_INT_FORCE_RESERVED1_SHIFT)
#define  SKEWDET_INT_FORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_FORCE_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_INT_FORCE_RESERVED1_SHIFT))

#define  SKEWDET_INT_FORCE_ALLEDGEDET_MASK 0x4
#define  SKEWDET_INT_FORCE_ALLEDGEDET_SHIFT 2
#define  SKEWDET_INT_FORCE_ALLEDGEDET_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_FORCE_ALLEDGEDET_MASK) >> SKEWDET_INT_FORCE_ALLEDGEDET_SHIFT)
#define  SKEWDET_INT_FORCE_ALLEDGEDET_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_FORCE_ALLEDGEDET_MASK) | (((uint32_t)val) << SKEWDET_INT_FORCE_ALLEDGEDET_SHIFT))

#define  SKEWDET_INT_FORCE_RAMOVERFLOW_MASK 0x2
#define  SKEWDET_INT_FORCE_RAMOVERFLOW_SHIFT 1
#define  SKEWDET_INT_FORCE_RAMOVERFLOW_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_FORCE_RAMOVERFLOW_MASK) >> SKEWDET_INT_FORCE_RAMOVERFLOW_SHIFT)
#define  SKEWDET_INT_FORCE_RAMOVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_FORCE_RAMOVERFLOW_MASK) | (((uint32_t)val) << SKEWDET_INT_FORCE_RAMOVERFLOW_SHIFT))

#define  SKEWDET_INT_FORCE_MAXLINECNT_MASK 0x1
#define  SKEWDET_INT_FORCE_MAXLINECNT_SHIFT 0
#define  SKEWDET_INT_FORCE_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_FORCE_MAXLINECNT_MASK) >> SKEWDET_INT_FORCE_MAXLINECNT_SHIFT)
#define  SKEWDET_INT_FORCE_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_FORCE_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_INT_FORCE_MAXLINECNT_SHIFT))

#endif // SKEWDET
