 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SHARPM_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SHARPM_REGSTRUCTS_H_
#define _SHARPM_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SHARPM (SHARPM)
/** \brief Register descriptions for the SharpM filter block
    (rev 0 . 1 . 0 . 0)*/
//
//====================================================================

typedef struct SHARPM_REGS_s
{
  volatile uint32_t Config;  ///< 0x0 [R/W]: SharpM Configuration Register
  volatile uint32_t fill_val_Y;  ///< 0x4 [R/W]: Y edge fill value
  volatile uint32_t fill_val_C;  ///< 0x8 [R/W]: C edge fill value
  volatile uint32_t H_Start_Loc;  ///< 0xc [R/W]: Horizontal Start Location
  volatile uint32_t H_Step;  ///< 0x10 [R/W]: Horizontal Step Size
  volatile uint32_t V_Start_Loc;  ///< 0x14 [R/W]: Vertical Start Location
  volatile uint32_t V_Step;  ///< 0x18 [R/W]: Vertical Step Size
  volatile uint32_t reserved0;
  volatile uint32_t Y_coeff0;  ///< 0x20 [R/W]: Y Coefficient (Instance 1 of 5)
  volatile uint32_t Y_coeff1;  ///< 0x24 [R/W]: Y Coefficient (Instance 2 of 5)
  volatile uint32_t Y_coeff2;  ///< 0x28 [R/W]: Y Coefficient (Instance 3 of 5)
  volatile uint32_t Y_coeff3;  ///< 0x2c [R/W]: Y Coefficient (Instance 4 of 5)
  volatile uint32_t Y_coeff4;  ///< 0x30 [R/W]: Y Coefficient (Instance 5 of 5)
  volatile uint32_t Y_Shift;  ///< 0x34 [R/W]: Y Shift Value
  volatile uint32_t reserved1[2];
  volatile uint32_t C_coeff0;  ///< 0x40 [R/W]: C Coefficient (Instance 1 of 5)
  volatile uint32_t C_coeff1;  ///< 0x44 [R/W]: C Coefficient (Instance 2 of 5)
  volatile uint32_t C_coeff2;  ///< 0x48 [R/W]: C Coefficient (Instance 3 of 5)
  volatile uint32_t C_coeff3;  ///< 0x4c [R/W]: C Coefficient (Instance 4 of 5)
  volatile uint32_t C_coeff4;  ///< 0x50 [R/W]: C Coefficient (Instance 5 of 5)
  volatile uint32_t reserved2[4];
  volatile uint32_t C_Shift;  ///< 0x64 [R/W]: C Shift Values
  volatile uint32_t LineBuffControl;  ///< 0x68 [R/W]: SharpM LineBuffer Access Control Register
  volatile uint32_t LineBuffAddrWr;  ///< 0x6c [W]: SharpM LineBuffer Address Write Register
  volatile uint32_t LineBuffAddrStatus;  ///< 0x70 [R]: SharpM LineBuffer Address Status Register
  volatile uint32_t LineBuffData0Wr;  ///< 0x74 [W]: SharpM LineBuffer Data0 Write Register
  volatile uint32_t LineBuffData1Wr;  ///< 0x78 [W]: SharpM LineBuffer Data1 Write Register
  volatile uint32_t LineBuffData2Wr;  ///< 0x7c [W]: SharpM LineBuffer Data2 Write Register
  volatile uint32_t LineBuffData3Wr;  ///< 0x80 [W]: SharpM LineBuffer Data3 Write Register
  volatile uint32_t LineBuffData0Rd;  ///< 0x84 [R]: SharpM LineBuffer Data0 Read Register
  volatile uint32_t LineBuffData1Rd;  ///< 0x88 [R]: SharpM LineBuffer Data1 Read Register
  volatile uint32_t LineBuffData2Rd;  ///< 0x8c [R]: SharpM LineBuffer Data2 Read Register
  volatile uint32_t LineBuffData3Rd;  ///< 0x90 [R]: SharpM LineBuffer Data3 Read Register
  volatile uint32_t SaveRestoreRd;  ///< 0x94 [R]: SharpM Save Restore Read Register
  volatile uint32_t SaveRestoreWr;  ///< 0x98 [W]: SharpM Save Restore Write Register
  volatile uint32_t SaveRestoreRd2;  ///< 0x9c [R]: SharpM Save Restore Read Register 2
  volatile uint32_t SaveRestoreWr2;  ///< 0xa0 [W]: SharpM Save Restore Write Register 2
  volatile uint32_t REV0;  ///< 0xa4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xa8 [R]: IP Tagging Revision 1
  volatile uint32_t reserved3;
  volatile uint32_t Y_coeff_scale0;  ///< 0xb0 [R/W]: Y Resizing Coefficient (Instance 1 of 30)
  volatile uint32_t Y_coeff_scale1;  ///< 0xb4 [R/W]: Y Resizing Coefficient (Instance 2 of 30)
  volatile uint32_t Y_coeff_scale2;  ///< 0xb8 [R/W]: Y Resizing Coefficient (Instance 3 of 30)
  volatile uint32_t Y_coeff_scale3;  ///< 0xbc [R/W]: Y Resizing Coefficient (Instance 4 of 30)
  volatile uint32_t Y_coeff_scale4;  ///< 0xc0 [R/W]: Y Resizing Coefficient (Instance 5 of 30)
  volatile uint32_t Y_coeff_scale5;  ///< 0xc4 [R/W]: Y Resizing Coefficient (Instance 6 of 30)
  volatile uint32_t Y_coeff_scale6;  ///< 0xc8 [R/W]: Y Resizing Coefficient (Instance 7 of 30)
  volatile uint32_t Y_coeff_scale7;  ///< 0xcc [R/W]: Y Resizing Coefficient (Instance 8 of 30)
  volatile uint32_t Y_coeff_scale8;  ///< 0xd0 [R/W]: Y Resizing Coefficient (Instance 9 of 30)
  volatile uint32_t Y_coeff_scale9;  ///< 0xd4 [R/W]: Y Resizing Coefficient (Instance 10 of 30)
  volatile uint32_t Y_coeff_scale10;  ///< 0xd8 [R/W]: Y Resizing Coefficient (Instance 11 of 30)
  volatile uint32_t Y_coeff_scale11;  ///< 0xdc [R/W]: Y Resizing Coefficient (Instance 12 of 30)
  volatile uint32_t Y_coeff_scale12;  ///< 0xe0 [R/W]: Y Resizing Coefficient (Instance 13 of 30)
  volatile uint32_t Y_coeff_scale13;  ///< 0xe4 [R/W]: Y Resizing Coefficient (Instance 14 of 30)
  volatile uint32_t Y_coeff_scale14;  ///< 0xe8 [R/W]: Y Resizing Coefficient (Instance 15 of 30)
  volatile uint32_t Y_coeff_scale15;  ///< 0xec [R/W]: Y Resizing Coefficient (Instance 16 of 30)
  volatile uint32_t Y_coeff_scale16;  ///< 0xf0 [R/W]: Y Resizing Coefficient (Instance 17 of 30)
  volatile uint32_t Y_coeff_scale17;  ///< 0xf4 [R/W]: Y Resizing Coefficient (Instance 18 of 30)
  volatile uint32_t Y_coeff_scale18;  ///< 0xf8 [R/W]: Y Resizing Coefficient (Instance 19 of 30)
  volatile uint32_t Y_coeff_scale19;  ///< 0xfc [R/W]: Y Resizing Coefficient (Instance 20 of 30)
  volatile uint32_t Y_coeff_scale20;  ///< 0x100 [R/W]: Y Resizing Coefficient (Instance 21 of 30)
  volatile uint32_t Y_coeff_scale21;  ///< 0x104 [R/W]: Y Resizing Coefficient (Instance 22 of 30)
  volatile uint32_t Y_coeff_scale22;  ///< 0x108 [R/W]: Y Resizing Coefficient (Instance 23 of 30)
  volatile uint32_t Y_coeff_scale23;  ///< 0x10c [R/W]: Y Resizing Coefficient (Instance 24 of 30)
  volatile uint32_t Y_coeff_scale24;  ///< 0x110 [R/W]: Y Resizing Coefficient (Instance 25 of 30)
  volatile uint32_t Y_coeff_scale25;  ///< 0x114 [R/W]: Y Resizing Coefficient (Instance 26 of 30)
  volatile uint32_t Y_coeff_scale26;  ///< 0x118 [R/W]: Y Resizing Coefficient (Instance 27 of 30)
  volatile uint32_t Y_coeff_scale27;  ///< 0x11c [R/W]: Y Resizing Coefficient (Instance 28 of 30)
  volatile uint32_t Y_coeff_scale28;  ///< 0x120 [R/W]: Y Resizing Coefficient (Instance 29 of 30)
  volatile uint32_t Y_coeff_scale29;  ///< 0x124 [R/W]: Y Resizing Coefficient (Instance 30 of 30)
  volatile uint32_t reserved4[2];
  volatile uint32_t C_coeff_scale0;  ///< 0x130 [R/W]: C Resizing Coefficient (Instance 1 of 30)
  volatile uint32_t C_coeff_scale1;  ///< 0x134 [R/W]: C Resizing Coefficient (Instance 2 of 30)
  volatile uint32_t C_coeff_scale2;  ///< 0x138 [R/W]: C Resizing Coefficient (Instance 3 of 30)
  volatile uint32_t C_coeff_scale3;  ///< 0x13c [R/W]: C Resizing Coefficient (Instance 4 of 30)
  volatile uint32_t C_coeff_scale4;  ///< 0x140 [R/W]: C Resizing Coefficient (Instance 5 of 30)
  volatile uint32_t C_coeff_scale5;  ///< 0x144 [R/W]: C Resizing Coefficient (Instance 6 of 30)
  volatile uint32_t C_coeff_scale6;  ///< 0x148 [R/W]: C Resizing Coefficient (Instance 7 of 30)
  volatile uint32_t C_coeff_scale7;  ///< 0x14c [R/W]: C Resizing Coefficient (Instance 8 of 30)
  volatile uint32_t C_coeff_scale8;  ///< 0x150 [R/W]: C Resizing Coefficient (Instance 9 of 30)
  volatile uint32_t C_coeff_scale9;  ///< 0x154 [R/W]: C Resizing Coefficient (Instance 10 of 30)
  volatile uint32_t C_coeff_scale10;  ///< 0x158 [R/W]: C Resizing Coefficient (Instance 11 of 30)
  volatile uint32_t C_coeff_scale11;  ///< 0x15c [R/W]: C Resizing Coefficient (Instance 12 of 30)
  volatile uint32_t C_coeff_scale12;  ///< 0x160 [R/W]: C Resizing Coefficient (Instance 13 of 30)
  volatile uint32_t C_coeff_scale13;  ///< 0x164 [R/W]: C Resizing Coefficient (Instance 14 of 30)
  volatile uint32_t C_coeff_scale14;  ///< 0x168 [R/W]: C Resizing Coefficient (Instance 15 of 30)
  volatile uint32_t C_coeff_scale15;  ///< 0x16c [R/W]: C Resizing Coefficient (Instance 16 of 30)
  volatile uint32_t C_coeff_scale16;  ///< 0x170 [R/W]: C Resizing Coefficient (Instance 17 of 30)
  volatile uint32_t C_coeff_scale17;  ///< 0x174 [R/W]: C Resizing Coefficient (Instance 18 of 30)
  volatile uint32_t C_coeff_scale18;  ///< 0x178 [R/W]: C Resizing Coefficient (Instance 19 of 30)
  volatile uint32_t C_coeff_scale19;  ///< 0x17c [R/W]: C Resizing Coefficient (Instance 20 of 30)
  volatile uint32_t C_coeff_scale20;  ///< 0x180 [R/W]: C Resizing Coefficient (Instance 21 of 30)
  volatile uint32_t C_coeff_scale21;  ///< 0x184 [R/W]: C Resizing Coefficient (Instance 22 of 30)
  volatile uint32_t C_coeff_scale22;  ///< 0x188 [R/W]: C Resizing Coefficient (Instance 23 of 30)
  volatile uint32_t C_coeff_scale23;  ///< 0x18c [R/W]: C Resizing Coefficient (Instance 24 of 30)
  volatile uint32_t C_coeff_scale24;  ///< 0x190 [R/W]: C Resizing Coefficient (Instance 25 of 30)
  volatile uint32_t C_coeff_scale25;  ///< 0x194 [R/W]: C Resizing Coefficient (Instance 26 of 30)
  volatile uint32_t C_coeff_scale26;  ///< 0x198 [R/W]: C Resizing Coefficient (Instance 27 of 30)
  volatile uint32_t C_coeff_scale27;  ///< 0x19c [R/W]: C Resizing Coefficient (Instance 28 of 30)
  volatile uint32_t C_coeff_scale28;  ///< 0x1a0 [R/W]: C Resizing Coefficient (Instance 29 of 30)
  volatile uint32_t C_coeff_scale29;  ///< 0x1a4 [R/W]: C Resizing Coefficient (Instance 30 of 30)
} SHARPM_REGS_t;

#endif // SHARPM
