 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SHARPM_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SHARPM_REGMASKS_H_
#define _SHARPM_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SHARPM (SHARPM)
/** \brief Register descriptions for the SharpM filter block
    (rev 0 . 1 . 0 . 0)*/
//
//====================================================================

//====================================================================
//Register: SharpM Configuration Register (Config)
//====================================================================

#define  SHARPM_CONFIG_RESERVED1_MASK 0xffffff00
#define  SHARPM_CONFIG_RESERVED1_SHIFT 8
#define  SHARPM_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_CONFIG_RESERVED1_MASK) >> SHARPM_CONFIG_RESERVED1_SHIFT)
#define  SHARPM_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_CONFIG_RESERVED1_SHIFT))

#define  SHARPM_CONFIG_C_COEF_MODE_MASK 0x80
#define  SHARPM_CONFIG_C_COEF_MODE_SHIFT 7
#define  SHARPM_CONFIG_C_COEF_MODE_MASK_SHIFT(reg) (((reg) & SHARPM_CONFIG_C_COEF_MODE_MASK) >> SHARPM_CONFIG_C_COEF_MODE_SHIFT)
#define  SHARPM_CONFIG_C_COEF_MODE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_CONFIG_C_COEF_MODE_MASK) | (((uint32_t)val) << SHARPM_CONFIG_C_COEF_MODE_SHIFT))

#define  SHARPM_CONFIG_Y_COEF_MODE_MASK 0x40
#define  SHARPM_CONFIG_Y_COEF_MODE_SHIFT 6
#define  SHARPM_CONFIG_Y_COEF_MODE_MASK_SHIFT(reg) (((reg) & SHARPM_CONFIG_Y_COEF_MODE_MASK) >> SHARPM_CONFIG_Y_COEF_MODE_SHIFT)
#define  SHARPM_CONFIG_Y_COEF_MODE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_CONFIG_Y_COEF_MODE_MASK) | (((uint32_t)val) << SHARPM_CONFIG_Y_COEF_MODE_SHIFT))

#define  SHARPM_CONFIG_MODE_SELECT_MASK 0x20
#define  SHARPM_CONFIG_MODE_SELECT_SHIFT 5
#define  SHARPM_CONFIG_MODE_SELECT_MASK_SHIFT(reg) (((reg) & SHARPM_CONFIG_MODE_SELECT_MASK) >> SHARPM_CONFIG_MODE_SELECT_SHIFT)
#define  SHARPM_CONFIG_MODE_SELECT_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_CONFIG_MODE_SELECT_MASK) | (((uint32_t)val) << SHARPM_CONFIG_MODE_SELECT_SHIFT))

#define  SHARPM_CONFIG_OT_NIBBLE_SEL_MASK 0x10
#define  SHARPM_CONFIG_OT_NIBBLE_SEL_SHIFT 4
#define  SHARPM_CONFIG_OT_NIBBLE_SEL_MASK_SHIFT(reg) (((reg) & SHARPM_CONFIG_OT_NIBBLE_SEL_MASK) >> SHARPM_CONFIG_OT_NIBBLE_SEL_SHIFT)
#define  SHARPM_CONFIG_OT_NIBBLE_SEL_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_CONFIG_OT_NIBBLE_SEL_MASK) | (((uint32_t)val) << SHARPM_CONFIG_OT_NIBBLE_SEL_SHIFT))

#define  SHARPM_CONFIG_FILL_NREPLICATE_MASK 0x8
#define  SHARPM_CONFIG_FILL_NREPLICATE_SHIFT 3
#define  SHARPM_CONFIG_FILL_NREPLICATE_MASK_SHIFT(reg) (((reg) & SHARPM_CONFIG_FILL_NREPLICATE_MASK) >> SHARPM_CONFIG_FILL_NREPLICATE_SHIFT)
#define  SHARPM_CONFIG_FILL_NREPLICATE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_CONFIG_FILL_NREPLICATE_MASK) | (((uint32_t)val) << SHARPM_CONFIG_FILL_NREPLICATE_SHIFT))

#define  SHARPM_CONFIG_LB_SRAM_ACCESS_ENABLE_MASK 0x4
#define  SHARPM_CONFIG_LB_SRAM_ACCESS_ENABLE_SHIFT 2
#define  SHARPM_CONFIG_LB_SRAM_ACCESS_ENABLE_MASK_SHIFT(reg) (((reg) & SHARPM_CONFIG_LB_SRAM_ACCESS_ENABLE_MASK) >> SHARPM_CONFIG_LB_SRAM_ACCESS_ENABLE_SHIFT)
#define  SHARPM_CONFIG_LB_SRAM_ACCESS_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_CONFIG_LB_SRAM_ACCESS_ENABLE_MASK) | (((uint32_t)val) << SHARPM_CONFIG_LB_SRAM_ACCESS_ENABLE_SHIFT))

#define  SHARPM_CONFIG_SAVE_RESTORE_MODE_MASK 0x2
#define  SHARPM_CONFIG_SAVE_RESTORE_MODE_SHIFT 1
#define  SHARPM_CONFIG_SAVE_RESTORE_MODE_MASK_SHIFT(reg) (((reg) & SHARPM_CONFIG_SAVE_RESTORE_MODE_MASK) >> SHARPM_CONFIG_SAVE_RESTORE_MODE_SHIFT)
#define  SHARPM_CONFIG_SAVE_RESTORE_MODE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_CONFIG_SAVE_RESTORE_MODE_MASK) | (((uint32_t)val) << SHARPM_CONFIG_SAVE_RESTORE_MODE_SHIFT))

#define  SHARPM_CONFIG_BYPASS_MASK 0x1
#define  SHARPM_CONFIG_BYPASS_SHIFT 0
#define  SHARPM_CONFIG_BYPASS_MASK_SHIFT(reg) (((reg) & SHARPM_CONFIG_BYPASS_MASK) >> SHARPM_CONFIG_BYPASS_SHIFT)
#define  SHARPM_CONFIG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_CONFIG_BYPASS_MASK) | (((uint32_t)val) << SHARPM_CONFIG_BYPASS_SHIFT))

//====================================================================
//Register: Y edge fill value (fill_val_Y)
/** \brief If the fill_nReplicate bit of the Config register is set, this value will be used to
      fill out the window manager when processing the values of pixels on the edges of the
      image. If the fill_nReplicate bit of the Config register is not set, this register's
      value is ignored.*/
//====================================================================

#define  SHARPM_FILL_VAL_Y_RESERVED1_MASK 0xffffff00
#define  SHARPM_FILL_VAL_Y_RESERVED1_SHIFT 8
#define  SHARPM_FILL_VAL_Y_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_FILL_VAL_Y_RESERVED1_MASK) >> SHARPM_FILL_VAL_Y_RESERVED1_SHIFT)
#define  SHARPM_FILL_VAL_Y_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_FILL_VAL_Y_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_FILL_VAL_Y_RESERVED1_SHIFT))

#define  SHARPM_FILL_VAL_Y_Y_EDGE_FILL_MASK 0xff
#define  SHARPM_FILL_VAL_Y_Y_EDGE_FILL_SHIFT 0
#define  SHARPM_FILL_VAL_Y_Y_EDGE_FILL_MASK_SHIFT(reg) (((reg) & SHARPM_FILL_VAL_Y_Y_EDGE_FILL_MASK) >> SHARPM_FILL_VAL_Y_Y_EDGE_FILL_SHIFT)
#define  SHARPM_FILL_VAL_Y_Y_EDGE_FILL_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_FILL_VAL_Y_Y_EDGE_FILL_MASK) | (((uint32_t)val) << SHARPM_FILL_VAL_Y_Y_EDGE_FILL_SHIFT))

//====================================================================
//Register: C edge fill value (fill_val_C)
/** \brief If the fill_nReplicate bit of the Config register is set, this value will be used to
      fill out the window manager when processing the values of pixels on the edges of the
      image. If the fill_nReplicate bit of the Config register is not set, this register's
      value is ignored.*/
//====================================================================

#define  SHARPM_FILL_VAL_C_RESERVED1_MASK 0xffffff00
#define  SHARPM_FILL_VAL_C_RESERVED1_SHIFT 8
#define  SHARPM_FILL_VAL_C_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_FILL_VAL_C_RESERVED1_MASK) >> SHARPM_FILL_VAL_C_RESERVED1_SHIFT)
#define  SHARPM_FILL_VAL_C_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_FILL_VAL_C_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_FILL_VAL_C_RESERVED1_SHIFT))

#define  SHARPM_FILL_VAL_C_C_EDGE_FILL_MASK 0xff
#define  SHARPM_FILL_VAL_C_C_EDGE_FILL_SHIFT 0
#define  SHARPM_FILL_VAL_C_C_EDGE_FILL_MASK_SHIFT(reg) (((reg) & SHARPM_FILL_VAL_C_C_EDGE_FILL_MASK) >> SHARPM_FILL_VAL_C_C_EDGE_FILL_SHIFT)
#define  SHARPM_FILL_VAL_C_C_EDGE_FILL_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_FILL_VAL_C_C_EDGE_FILL_MASK) | (((uint32_t)val) << SHARPM_FILL_VAL_C_C_EDGE_FILL_SHIFT))

//====================================================================
//Register: Horizontal Start Location (H_Start_Loc)
/** \brief Used for resizing only. Determines the horizontal location of first pixel relative to the first
      pixel in each line of the input image. See the "Detailed Functional Description" section of the
      DRS for information about how these values are used.*/
//====================================================================

#define  SHARPM_H_START_LOC_IMAGE_WIDTH_MASK 0xffff0000
#define  SHARPM_H_START_LOC_IMAGE_WIDTH_SHIFT 16
#define  SHARPM_H_START_LOC_IMAGE_WIDTH_MASK_SHIFT(reg) (((reg) & SHARPM_H_START_LOC_IMAGE_WIDTH_MASK) >> SHARPM_H_START_LOC_IMAGE_WIDTH_SHIFT)
#define  SHARPM_H_START_LOC_IMAGE_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_H_START_LOC_IMAGE_WIDTH_MASK) | (((uint32_t)val) << SHARPM_H_START_LOC_IMAGE_WIDTH_SHIFT))

#define  SHARPM_H_START_LOC_H_START_LOC_MASK 0xffff
#define  SHARPM_H_START_LOC_H_START_LOC_SHIFT 0
#define  SHARPM_H_START_LOC_H_START_LOC_MASK_SHIFT(reg) (((reg) & SHARPM_H_START_LOC_H_START_LOC_MASK) >> SHARPM_H_START_LOC_H_START_LOC_SHIFT)
#define  SHARPM_H_START_LOC_H_START_LOC_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_H_START_LOC_H_START_LOC_MASK) | (((uint32_t)val) << SHARPM_H_START_LOC_H_START_LOC_SHIFT))

//====================================================================
//Register: Horizontal Step Size (H_Step)
/** \brief Used for resizing only. Determines the horizontal distance between pixels in the output image.
      See the "Detailed Functional Description" section of the DRS for information about how
      these values are used.*/
//====================================================================

#define  SHARPM_H_STEP_RESERVED1_MASK 0xfffc0000
#define  SHARPM_H_STEP_RESERVED1_SHIFT 18
#define  SHARPM_H_STEP_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_H_STEP_RESERVED1_MASK) >> SHARPM_H_STEP_RESERVED1_SHIFT)
#define  SHARPM_H_STEP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_H_STEP_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_H_STEP_RESERVED1_SHIFT))

#define  SHARPM_H_STEP_H_STEP_MASK 0x3ffff
#define  SHARPM_H_STEP_H_STEP_SHIFT 0
#define  SHARPM_H_STEP_H_STEP_MASK_SHIFT(reg) (((reg) & SHARPM_H_STEP_H_STEP_MASK) >> SHARPM_H_STEP_H_STEP_SHIFT)
#define  SHARPM_H_STEP_H_STEP_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_H_STEP_H_STEP_MASK) | (((uint32_t)val) << SHARPM_H_STEP_H_STEP_SHIFT))

//====================================================================
//Register: Vertical Start Location (V_Start_Loc)
/** \brief Used for resizing only. Determines the vertical location of first line of pixels relative to the first line of
      pixels in the input image.
      See the "Detailed Functional Description" section of the DRS for information about how
      these values are used.*/
//====================================================================

#define  SHARPM_V_START_LOC_IMAGE_HEIGHT_MASK 0xffff0000
#define  SHARPM_V_START_LOC_IMAGE_HEIGHT_SHIFT 16
#define  SHARPM_V_START_LOC_IMAGE_HEIGHT_MASK_SHIFT(reg) (((reg) & SHARPM_V_START_LOC_IMAGE_HEIGHT_MASK) >> SHARPM_V_START_LOC_IMAGE_HEIGHT_SHIFT)
#define  SHARPM_V_START_LOC_IMAGE_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_V_START_LOC_IMAGE_HEIGHT_MASK) | (((uint32_t)val) << SHARPM_V_START_LOC_IMAGE_HEIGHT_SHIFT))

#define  SHARPM_V_START_LOC_V_START_LOC_MASK 0xffff
#define  SHARPM_V_START_LOC_V_START_LOC_SHIFT 0
#define  SHARPM_V_START_LOC_V_START_LOC_MASK_SHIFT(reg) (((reg) & SHARPM_V_START_LOC_V_START_LOC_MASK) >> SHARPM_V_START_LOC_V_START_LOC_SHIFT)
#define  SHARPM_V_START_LOC_V_START_LOC_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_V_START_LOC_V_START_LOC_MASK) | (((uint32_t)val) << SHARPM_V_START_LOC_V_START_LOC_SHIFT))

//====================================================================
//Register: Vertical Step Size (V_Step)
/** \brief Used for resizing only. Determines the vertical distance between lines in the output image.
      See the "Detailed Functional Description" section of the DRS for information about how
      these values are used.*/
//====================================================================

#define  SHARPM_V_STEP_RESERVED1_MASK 0xfffc0000
#define  SHARPM_V_STEP_RESERVED1_SHIFT 18
#define  SHARPM_V_STEP_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_V_STEP_RESERVED1_MASK) >> SHARPM_V_STEP_RESERVED1_SHIFT)
#define  SHARPM_V_STEP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_V_STEP_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_V_STEP_RESERVED1_SHIFT))

#define  SHARPM_V_STEP_V_STEP_MASK 0x3ffff
#define  SHARPM_V_STEP_V_STEP_SHIFT 0
#define  SHARPM_V_STEP_V_STEP_MASK_SHIFT(reg) (((reg) & SHARPM_V_STEP_V_STEP_MASK) >> SHARPM_V_STEP_V_STEP_SHIFT)
#define  SHARPM_V_STEP_V_STEP_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_V_STEP_V_STEP_MASK) | (((uint32_t)val) << SHARPM_V_STEP_V_STEP_SHIFT))

//====================================================================
//Register: Y Coefficient (Instance 1 of 5) (Y_coeff0)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is for both
      sharpen and resizing functions. There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode (mode_select = 0) - 4x4 filter. There are 16 sets of 4 coefficients. If y_coef_mode is set then
      they are split into 2 groups of 8.
      <br/> <br/> Sharpen Mode (mode_select = 1) - 5x5 filter. There is one set of 5 coefficients. If y_coef_mode is set then
      there are two groups of 5.
      <br/> (Instance 1 of 5)*/
//====================================================================

#define  SHARPM_Y_COEFF0_RESERVED1_MASK 0xfffff000
#define  SHARPM_Y_COEFF0_RESERVED1_SHIFT 12
#define  SHARPM_Y_COEFF0_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF0_RESERVED1_MASK) >> SHARPM_Y_COEFF0_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF0_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF0_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF0_VALUE_MASK 0xfff
#define  SHARPM_Y_COEFF0_VALUE_SHIFT 0
#define  SHARPM_Y_COEFF0_VALUE_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF0_VALUE_MASK) >> SHARPM_Y_COEFF0_VALUE_SHIFT)
#define  SHARPM_Y_COEFF0_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF0_VALUE_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF0_VALUE_SHIFT))

//====================================================================
//Register: Y Coefficient (Instance 2 of 5) (Y_coeff1)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is for both
      sharpen and resizing functions. There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode (mode_select = 0) - 4x4 filter. There are 16 sets of 4 coefficients. If y_coef_mode is set then
      they are split into 2 groups of 8.
      <br/> <br/> Sharpen Mode (mode_select = 1) - 5x5 filter. There is one set of 5 coefficients. If y_coef_mode is set then
      there are two groups of 5.
      <br/> (Instance 2 of 5)*/
//====================================================================

#define  SHARPM_Y_COEFF1_RESERVED1_MASK 0xfffff000
#define  SHARPM_Y_COEFF1_RESERVED1_SHIFT 12
#define  SHARPM_Y_COEFF1_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF1_RESERVED1_MASK) >> SHARPM_Y_COEFF1_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF1_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF1_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF1_VALUE_MASK 0xfff
#define  SHARPM_Y_COEFF1_VALUE_SHIFT 0
#define  SHARPM_Y_COEFF1_VALUE_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF1_VALUE_MASK) >> SHARPM_Y_COEFF1_VALUE_SHIFT)
#define  SHARPM_Y_COEFF1_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF1_VALUE_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF1_VALUE_SHIFT))

//====================================================================
//Register: Y Coefficient (Instance 3 of 5) (Y_coeff2)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is for both
      sharpen and resizing functions. There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode (mode_select = 0) - 4x4 filter. There are 16 sets of 4 coefficients. If y_coef_mode is set then
      they are split into 2 groups of 8.
      <br/> <br/> Sharpen Mode (mode_select = 1) - 5x5 filter. There is one set of 5 coefficients. If y_coef_mode is set then
      there are two groups of 5.
      <br/> (Instance 3 of 5)*/
//====================================================================

#define  SHARPM_Y_COEFF2_RESERVED1_MASK 0xfffff000
#define  SHARPM_Y_COEFF2_RESERVED1_SHIFT 12
#define  SHARPM_Y_COEFF2_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF2_RESERVED1_MASK) >> SHARPM_Y_COEFF2_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF2_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF2_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF2_VALUE_MASK 0xfff
#define  SHARPM_Y_COEFF2_VALUE_SHIFT 0
#define  SHARPM_Y_COEFF2_VALUE_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF2_VALUE_MASK) >> SHARPM_Y_COEFF2_VALUE_SHIFT)
#define  SHARPM_Y_COEFF2_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF2_VALUE_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF2_VALUE_SHIFT))

//====================================================================
//Register: Y Coefficient (Instance 4 of 5) (Y_coeff3)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is for both
      sharpen and resizing functions. There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode (mode_select = 0) - 4x4 filter. There are 16 sets of 4 coefficients. If y_coef_mode is set then
      they are split into 2 groups of 8.
      <br/> <br/> Sharpen Mode (mode_select = 1) - 5x5 filter. There is one set of 5 coefficients. If y_coef_mode is set then
      there are two groups of 5.
      <br/> (Instance 4 of 5)*/
//====================================================================

#define  SHARPM_Y_COEFF3_RESERVED1_MASK 0xfffff000
#define  SHARPM_Y_COEFF3_RESERVED1_SHIFT 12
#define  SHARPM_Y_COEFF3_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF3_RESERVED1_MASK) >> SHARPM_Y_COEFF3_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF3_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF3_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF3_VALUE_MASK 0xfff
#define  SHARPM_Y_COEFF3_VALUE_SHIFT 0
#define  SHARPM_Y_COEFF3_VALUE_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF3_VALUE_MASK) >> SHARPM_Y_COEFF3_VALUE_SHIFT)
#define  SHARPM_Y_COEFF3_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF3_VALUE_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF3_VALUE_SHIFT))

//====================================================================
//Register: Y Coefficient (Instance 5 of 5) (Y_coeff4)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is for both
      sharpen and resizing functions. There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode (mode_select = 0) - 4x4 filter. There are 16 sets of 4 coefficients. If y_coef_mode is set then
      they are split into 2 groups of 8.
      <br/> <br/> Sharpen Mode (mode_select = 1) - 5x5 filter. There is one set of 5 coefficients. If y_coef_mode is set then
      there are two groups of 5.
      <br/> (Instance 5 of 5)*/
//====================================================================

#define  SHARPM_Y_COEFF4_RESERVED1_MASK 0xfffff000
#define  SHARPM_Y_COEFF4_RESERVED1_SHIFT 12
#define  SHARPM_Y_COEFF4_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF4_RESERVED1_MASK) >> SHARPM_Y_COEFF4_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF4_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF4_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF4_VALUE_MASK 0xfff
#define  SHARPM_Y_COEFF4_VALUE_SHIFT 0
#define  SHARPM_Y_COEFF4_VALUE_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF4_VALUE_MASK) >> SHARPM_Y_COEFF4_VALUE_SHIFT)
#define  SHARPM_Y_COEFF4_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF4_VALUE_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF4_VALUE_SHIFT))

//====================================================================
//Register: Y Shift Value (Y_Shift)
/** \brief The values in this register are used as part of the filter calculation.
      See the "Detailed Functional Description" section of the DRS for information about how
      these values are used.*/
//====================================================================

#define  SHARPM_Y_SHIFT_RESERVED1_MASK 0xfff00000
#define  SHARPM_Y_SHIFT_RESERVED1_SHIFT 20
#define  SHARPM_Y_SHIFT_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_SHIFT_RESERVED1_MASK) >> SHARPM_Y_SHIFT_RESERVED1_SHIFT)
#define  SHARPM_Y_SHIFT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_SHIFT_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_SHIFT_RESERVED1_SHIFT))

#define  SHARPM_Y_SHIFT_Y_VSHIFT_MASK 0xf0000
#define  SHARPM_Y_SHIFT_Y_VSHIFT_SHIFT 16
#define  SHARPM_Y_SHIFT_Y_VSHIFT_MASK_SHIFT(reg) (((reg) & SHARPM_Y_SHIFT_Y_VSHIFT_MASK) >> SHARPM_Y_SHIFT_Y_VSHIFT_SHIFT)
#define  SHARPM_Y_SHIFT_Y_VSHIFT_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_SHIFT_Y_VSHIFT_MASK) | (((uint32_t)val) << SHARPM_Y_SHIFT_Y_VSHIFT_SHIFT))

#define  SHARPM_Y_SHIFT_RESERVED2_MASK 0xfff0
#define  SHARPM_Y_SHIFT_RESERVED2_SHIFT 4
#define  SHARPM_Y_SHIFT_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_SHIFT_RESERVED2_MASK) >> SHARPM_Y_SHIFT_RESERVED2_SHIFT)
#define  SHARPM_Y_SHIFT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_SHIFT_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_SHIFT_RESERVED2_SHIFT))

#define  SHARPM_Y_SHIFT_Y_HSHIFT_MASK 0xf
#define  SHARPM_Y_SHIFT_Y_HSHIFT_SHIFT 0
#define  SHARPM_Y_SHIFT_Y_HSHIFT_MASK_SHIFT(reg) (((reg) & SHARPM_Y_SHIFT_Y_HSHIFT_MASK) >> SHARPM_Y_SHIFT_Y_HSHIFT_SHIFT)
#define  SHARPM_Y_SHIFT_Y_HSHIFT_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_SHIFT_Y_HSHIFT_MASK) | (((uint32_t)val) << SHARPM_Y_SHIFT_Y_HSHIFT_SHIFT))

//====================================================================
//Register: C Coefficient (Instance 1 of 5) (C_coeff0)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is for both
      sharpen and resizing functions. There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode (mode_select = 0) - 4x4 filter. There are 16 sets of 4 coefficients. If c_coef_mode is set then
      they are split into 2 groups of 8.
      <br/> <br/> Sharpen Mode (mode_select = 1) - 5x5 filter. There is one set of 5 coefficients. If c_coef_mode is set then
      there are two groups of 5.
      <br/> (Instance 1 of 5)*/
//====================================================================

#define  SHARPM_C_COEFF0_RESERVED1_MASK 0xfffff000
#define  SHARPM_C_COEFF0_RESERVED1_SHIFT 12
#define  SHARPM_C_COEFF0_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF0_RESERVED1_MASK) >> SHARPM_C_COEFF0_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF0_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF0_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF0_VALUE_MASK 0xfff
#define  SHARPM_C_COEFF0_VALUE_SHIFT 0
#define  SHARPM_C_COEFF0_VALUE_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF0_VALUE_MASK) >> SHARPM_C_COEFF0_VALUE_SHIFT)
#define  SHARPM_C_COEFF0_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF0_VALUE_MASK) | (((uint32_t)val) << SHARPM_C_COEFF0_VALUE_SHIFT))

//====================================================================
//Register: C Coefficient (Instance 2 of 5) (C_coeff1)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is for both
      sharpen and resizing functions. There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode (mode_select = 0) - 4x4 filter. There are 16 sets of 4 coefficients. If c_coef_mode is set then
      they are split into 2 groups of 8.
      <br/> <br/> Sharpen Mode (mode_select = 1) - 5x5 filter. There is one set of 5 coefficients. If c_coef_mode is set then
      there are two groups of 5.
      <br/> (Instance 2 of 5)*/
//====================================================================

#define  SHARPM_C_COEFF1_RESERVED1_MASK 0xfffff000
#define  SHARPM_C_COEFF1_RESERVED1_SHIFT 12
#define  SHARPM_C_COEFF1_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF1_RESERVED1_MASK) >> SHARPM_C_COEFF1_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF1_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF1_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF1_VALUE_MASK 0xfff
#define  SHARPM_C_COEFF1_VALUE_SHIFT 0
#define  SHARPM_C_COEFF1_VALUE_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF1_VALUE_MASK) >> SHARPM_C_COEFF1_VALUE_SHIFT)
#define  SHARPM_C_COEFF1_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF1_VALUE_MASK) | (((uint32_t)val) << SHARPM_C_COEFF1_VALUE_SHIFT))

//====================================================================
//Register: C Coefficient (Instance 3 of 5) (C_coeff2)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is for both
      sharpen and resizing functions. There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode (mode_select = 0) - 4x4 filter. There are 16 sets of 4 coefficients. If c_coef_mode is set then
      they are split into 2 groups of 8.
      <br/> <br/> Sharpen Mode (mode_select = 1) - 5x5 filter. There is one set of 5 coefficients. If c_coef_mode is set then
      there are two groups of 5.
      <br/> (Instance 3 of 5)*/
//====================================================================

#define  SHARPM_C_COEFF2_RESERVED1_MASK 0xfffff000
#define  SHARPM_C_COEFF2_RESERVED1_SHIFT 12
#define  SHARPM_C_COEFF2_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF2_RESERVED1_MASK) >> SHARPM_C_COEFF2_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF2_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF2_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF2_VALUE_MASK 0xfff
#define  SHARPM_C_COEFF2_VALUE_SHIFT 0
#define  SHARPM_C_COEFF2_VALUE_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF2_VALUE_MASK) >> SHARPM_C_COEFF2_VALUE_SHIFT)
#define  SHARPM_C_COEFF2_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF2_VALUE_MASK) | (((uint32_t)val) << SHARPM_C_COEFF2_VALUE_SHIFT))

//====================================================================
//Register: C Coefficient (Instance 4 of 5) (C_coeff3)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is for both
      sharpen and resizing functions. There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode (mode_select = 0) - 4x4 filter. There are 16 sets of 4 coefficients. If c_coef_mode is set then
      they are split into 2 groups of 8.
      <br/> <br/> Sharpen Mode (mode_select = 1) - 5x5 filter. There is one set of 5 coefficients. If c_coef_mode is set then
      there are two groups of 5.
      <br/> (Instance 4 of 5)*/
//====================================================================

#define  SHARPM_C_COEFF3_RESERVED1_MASK 0xfffff000
#define  SHARPM_C_COEFF3_RESERVED1_SHIFT 12
#define  SHARPM_C_COEFF3_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF3_RESERVED1_MASK) >> SHARPM_C_COEFF3_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF3_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF3_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF3_VALUE_MASK 0xfff
#define  SHARPM_C_COEFF3_VALUE_SHIFT 0
#define  SHARPM_C_COEFF3_VALUE_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF3_VALUE_MASK) >> SHARPM_C_COEFF3_VALUE_SHIFT)
#define  SHARPM_C_COEFF3_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF3_VALUE_MASK) | (((uint32_t)val) << SHARPM_C_COEFF3_VALUE_SHIFT))

//====================================================================
//Register: C Coefficient (Instance 5 of 5) (C_coeff4)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is for both
      sharpen and resizing functions. There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode (mode_select = 0) - 4x4 filter. There are 16 sets of 4 coefficients. If c_coef_mode is set then
      they are split into 2 groups of 8.
      <br/> <br/> Sharpen Mode (mode_select = 1) - 5x5 filter. There is one set of 5 coefficients. If c_coef_mode is set then
      there are two groups of 5.
      <br/> (Instance 5 of 5)*/
//====================================================================

#define  SHARPM_C_COEFF4_RESERVED1_MASK 0xfffff000
#define  SHARPM_C_COEFF4_RESERVED1_SHIFT 12
#define  SHARPM_C_COEFF4_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF4_RESERVED1_MASK) >> SHARPM_C_COEFF4_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF4_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF4_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF4_VALUE_MASK 0xfff
#define  SHARPM_C_COEFF4_VALUE_SHIFT 0
#define  SHARPM_C_COEFF4_VALUE_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF4_VALUE_MASK) >> SHARPM_C_COEFF4_VALUE_SHIFT)
#define  SHARPM_C_COEFF4_VALUE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF4_VALUE_MASK) | (((uint32_t)val) << SHARPM_C_COEFF4_VALUE_SHIFT))

//====================================================================
//Register: C Shift Values (C_Shift)
/** \brief The values in this register are used as part of the convolution filter calculation.
      See the "Detailed Functional Description" section of the DRS for information about how
      these values are used.*/
//====================================================================

#define  SHARPM_C_SHIFT_RESERVED1_MASK 0xfff00000
#define  SHARPM_C_SHIFT_RESERVED1_SHIFT 20
#define  SHARPM_C_SHIFT_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_SHIFT_RESERVED1_MASK) >> SHARPM_C_SHIFT_RESERVED1_SHIFT)
#define  SHARPM_C_SHIFT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_SHIFT_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_SHIFT_RESERVED1_SHIFT))

#define  SHARPM_C_SHIFT_C_VSHIFT_MASK 0xf0000
#define  SHARPM_C_SHIFT_C_VSHIFT_SHIFT 16
#define  SHARPM_C_SHIFT_C_VSHIFT_MASK_SHIFT(reg) (((reg) & SHARPM_C_SHIFT_C_VSHIFT_MASK) >> SHARPM_C_SHIFT_C_VSHIFT_SHIFT)
#define  SHARPM_C_SHIFT_C_VSHIFT_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_SHIFT_C_VSHIFT_MASK) | (((uint32_t)val) << SHARPM_C_SHIFT_C_VSHIFT_SHIFT))

#define  SHARPM_C_SHIFT_RESERVED2_MASK 0xfff0
#define  SHARPM_C_SHIFT_RESERVED2_SHIFT 4
#define  SHARPM_C_SHIFT_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_SHIFT_RESERVED2_MASK) >> SHARPM_C_SHIFT_RESERVED2_SHIFT)
#define  SHARPM_C_SHIFT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_SHIFT_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_SHIFT_RESERVED2_SHIFT))

#define  SHARPM_C_SHIFT_C_HSHIFT_MASK 0xf
#define  SHARPM_C_SHIFT_C_HSHIFT_SHIFT 0
#define  SHARPM_C_SHIFT_C_HSHIFT_MASK_SHIFT(reg) (((reg) & SHARPM_C_SHIFT_C_HSHIFT_MASK) >> SHARPM_C_SHIFT_C_HSHIFT_SHIFT)
#define  SHARPM_C_SHIFT_C_HSHIFT_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_SHIFT_C_HSHIFT_MASK) | (((uint32_t)val) << SHARPM_C_SHIFT_C_HSHIFT_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Access Control Register (LineBuffControl)
//====================================================================

#define  SHARPM_LINEBUFFCONTROL_RESERVED1_MASK 0xfffffffc
#define  SHARPM_LINEBUFFCONTROL_RESERVED1_SHIFT 2
#define  SHARPM_LINEBUFFCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFCONTROL_RESERVED1_MASK) >> SHARPM_LINEBUFFCONTROL_RESERVED1_SHIFT)
#define  SHARPM_LINEBUFFCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFCONTROL_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFCONTROL_RESERVED1_SHIFT))

#define  SHARPM_LINEBUFFCONTROL_INC_ADDR_MODE_MASK 0x2
#define  SHARPM_LINEBUFFCONTROL_INC_ADDR_MODE_SHIFT 1
#define  SHARPM_LINEBUFFCONTROL_INC_ADDR_MODE_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFCONTROL_INC_ADDR_MODE_MASK) >> SHARPM_LINEBUFFCONTROL_INC_ADDR_MODE_SHIFT)
#define  SHARPM_LINEBUFFCONTROL_INC_ADDR_MODE_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFCONTROL_INC_ADDR_MODE_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFCONTROL_INC_ADDR_MODE_SHIFT))

#define  SHARPM_LINEBUFFCONTROL_LB_RNW_MASK 0x1
#define  SHARPM_LINEBUFFCONTROL_LB_RNW_SHIFT 0
#define  SHARPM_LINEBUFFCONTROL_LB_RNW_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFCONTROL_LB_RNW_MASK) >> SHARPM_LINEBUFFCONTROL_LB_RNW_SHIFT)
#define  SHARPM_LINEBUFFCONTROL_LB_RNW_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFCONTROL_LB_RNW_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFCONTROL_LB_RNW_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Address Write Register (LineBuffAddrWr)
//====================================================================

#define  SHARPM_LINEBUFFADDRWR_RESERVED1_MASK 0xffff0000
#define  SHARPM_LINEBUFFADDRWR_RESERVED1_SHIFT 16
#define  SHARPM_LINEBUFFADDRWR_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFADDRWR_RESERVED1_MASK) >> SHARPM_LINEBUFFADDRWR_RESERVED1_SHIFT)
#define  SHARPM_LINEBUFFADDRWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFADDRWR_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFADDRWR_RESERVED1_SHIFT))

#define  SHARPM_LINEBUFFADDRWR_ADDRESS_MASK 0xffff
#define  SHARPM_LINEBUFFADDRWR_ADDRESS_SHIFT 0
#define  SHARPM_LINEBUFFADDRWR_ADDRESS_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFADDRWR_ADDRESS_MASK) >> SHARPM_LINEBUFFADDRWR_ADDRESS_SHIFT)
#define  SHARPM_LINEBUFFADDRWR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFADDRWR_ADDRESS_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFADDRWR_ADDRESS_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Address Status Register (LineBuffAddrStatus)
//====================================================================

#define  SHARPM_LINEBUFFADDRSTATUS_RESERVED1_MASK 0xffff0000
#define  SHARPM_LINEBUFFADDRSTATUS_RESERVED1_SHIFT 16
#define  SHARPM_LINEBUFFADDRSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFADDRSTATUS_RESERVED1_MASK) >> SHARPM_LINEBUFFADDRSTATUS_RESERVED1_SHIFT)
#define  SHARPM_LINEBUFFADDRSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFADDRSTATUS_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFADDRSTATUS_RESERVED1_SHIFT))

#define  SHARPM_LINEBUFFADDRSTATUS_ADDRESS_MASK 0xffff
#define  SHARPM_LINEBUFFADDRSTATUS_ADDRESS_SHIFT 0
#define  SHARPM_LINEBUFFADDRSTATUS_ADDRESS_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFADDRSTATUS_ADDRESS_MASK) >> SHARPM_LINEBUFFADDRSTATUS_ADDRESS_SHIFT)
#define  SHARPM_LINEBUFFADDRSTATUS_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFADDRSTATUS_ADDRESS_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFADDRSTATUS_ADDRESS_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Data0 Write Register (LineBuffData0Wr)
/** \brief SharpM Line Buffer SRAM Write Data*/
//====================================================================

#define  SHARPM_LINEBUFFDATA0WR_DATA_MASK 0xffffffff
#define  SHARPM_LINEBUFFDATA0WR_DATA_SHIFT 0
#define  SHARPM_LINEBUFFDATA0WR_DATA_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFDATA0WR_DATA_MASK) >> SHARPM_LINEBUFFDATA0WR_DATA_SHIFT)
#define  SHARPM_LINEBUFFDATA0WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFDATA0WR_DATA_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFDATA0WR_DATA_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Data1 Write Register (LineBuffData1Wr)
/** \brief SharpM Line Buffer SRAM Write Data*/
//====================================================================

#define  SHARPM_LINEBUFFDATA1WR_DATA_MASK 0xffffffff
#define  SHARPM_LINEBUFFDATA1WR_DATA_SHIFT 0
#define  SHARPM_LINEBUFFDATA1WR_DATA_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFDATA1WR_DATA_MASK) >> SHARPM_LINEBUFFDATA1WR_DATA_SHIFT)
#define  SHARPM_LINEBUFFDATA1WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFDATA1WR_DATA_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFDATA1WR_DATA_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Data2 Write Register (LineBuffData2Wr)
/** \brief SharpM Line Buffer SRAM Write Data*/
//====================================================================

#define  SHARPM_LINEBUFFDATA2WR_DATA_MASK 0xffffffff
#define  SHARPM_LINEBUFFDATA2WR_DATA_SHIFT 0
#define  SHARPM_LINEBUFFDATA2WR_DATA_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFDATA2WR_DATA_MASK) >> SHARPM_LINEBUFFDATA2WR_DATA_SHIFT)
#define  SHARPM_LINEBUFFDATA2WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFDATA2WR_DATA_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFDATA2WR_DATA_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Data3 Write Register (LineBuffData3Wr)
/** \brief SharpM Line Buffer SRAM Write Data*/
//====================================================================

#define  SHARPM_LINEBUFFDATA3WR_RESERVED1_MASK 0xffffff00
#define  SHARPM_LINEBUFFDATA3WR_RESERVED1_SHIFT 8
#define  SHARPM_LINEBUFFDATA3WR_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFDATA3WR_RESERVED1_MASK) >> SHARPM_LINEBUFFDATA3WR_RESERVED1_SHIFT)
#define  SHARPM_LINEBUFFDATA3WR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFDATA3WR_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFDATA3WR_RESERVED1_SHIFT))

#define  SHARPM_LINEBUFFDATA3WR_DATA_MASK 0xff
#define  SHARPM_LINEBUFFDATA3WR_DATA_SHIFT 0
#define  SHARPM_LINEBUFFDATA3WR_DATA_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFDATA3WR_DATA_MASK) >> SHARPM_LINEBUFFDATA3WR_DATA_SHIFT)
#define  SHARPM_LINEBUFFDATA3WR_DATA_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFDATA3WR_DATA_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFDATA3WR_DATA_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Data0 Read Register (LineBuffData0Rd)
/** \brief SharpM Line Buffer SRAM Read Data*/
//====================================================================

#define  SHARPM_LINEBUFFDATA0RD_DATA_MASK 0xffffffff
#define  SHARPM_LINEBUFFDATA0RD_DATA_SHIFT 0
#define  SHARPM_LINEBUFFDATA0RD_DATA_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFDATA0RD_DATA_MASK) >> SHARPM_LINEBUFFDATA0RD_DATA_SHIFT)
#define  SHARPM_LINEBUFFDATA0RD_DATA_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFDATA0RD_DATA_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFDATA0RD_DATA_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Data1 Read Register (LineBuffData1Rd)
/** \brief SharpM Line Buffer SRAM Read Data*/
//====================================================================

#define  SHARPM_LINEBUFFDATA1RD_DATA_MASK 0xffffffff
#define  SHARPM_LINEBUFFDATA1RD_DATA_SHIFT 0
#define  SHARPM_LINEBUFFDATA1RD_DATA_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFDATA1RD_DATA_MASK) >> SHARPM_LINEBUFFDATA1RD_DATA_SHIFT)
#define  SHARPM_LINEBUFFDATA1RD_DATA_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFDATA1RD_DATA_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFDATA1RD_DATA_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Data2 Read Register (LineBuffData2Rd)
/** \brief SharpM Line Buffer SRAM Read Data*/
//====================================================================

#define  SHARPM_LINEBUFFDATA2RD_DATA_MASK 0xffffffff
#define  SHARPM_LINEBUFFDATA2RD_DATA_SHIFT 0
#define  SHARPM_LINEBUFFDATA2RD_DATA_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFDATA2RD_DATA_MASK) >> SHARPM_LINEBUFFDATA2RD_DATA_SHIFT)
#define  SHARPM_LINEBUFFDATA2RD_DATA_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFDATA2RD_DATA_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFDATA2RD_DATA_SHIFT))

//====================================================================
//Register: SharpM LineBuffer Data3 Read Register (LineBuffData3Rd)
/** \brief SharpM Line Buffer SRAM Read Data*/
//====================================================================

#define  SHARPM_LINEBUFFDATA3RD_RESERVED1_MASK 0xffffff00
#define  SHARPM_LINEBUFFDATA3RD_RESERVED1_SHIFT 8
#define  SHARPM_LINEBUFFDATA3RD_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFDATA3RD_RESERVED1_MASK) >> SHARPM_LINEBUFFDATA3RD_RESERVED1_SHIFT)
#define  SHARPM_LINEBUFFDATA3RD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFDATA3RD_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFDATA3RD_RESERVED1_SHIFT))

#define  SHARPM_LINEBUFFDATA3RD_DATA_MASK 0xff
#define  SHARPM_LINEBUFFDATA3RD_DATA_SHIFT 0
#define  SHARPM_LINEBUFFDATA3RD_DATA_MASK_SHIFT(reg) (((reg) & SHARPM_LINEBUFFDATA3RD_DATA_MASK) >> SHARPM_LINEBUFFDATA3RD_DATA_SHIFT)
#define  SHARPM_LINEBUFFDATA3RD_DATA_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_LINEBUFFDATA3RD_DATA_MASK) | (((uint32_t)val) << SHARPM_LINEBUFFDATA3RD_DATA_SHIFT))

//====================================================================
//Register: SharpM Save Restore Read Register (SaveRestoreRd)
/** \brief This read-only register is provided for the save portion of save/restore functionality. The "save_restore_mode" bit of the configuration register must be set to a 1 to access this register. The ReadyForSave bit is set when the block is in a state suitable for save operations.*/
//====================================================================

#define  SHARPM_SAVERESTORERD_SAVE_VAL_MASK 0xffffffff
#define  SHARPM_SAVERESTORERD_SAVE_VAL_SHIFT 0
#define  SHARPM_SAVERESTORERD_SAVE_VAL_MASK_SHIFT(reg) (((reg) & SHARPM_SAVERESTORERD_SAVE_VAL_MASK) >> SHARPM_SAVERESTORERD_SAVE_VAL_SHIFT)
#define  SHARPM_SAVERESTORERD_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_SAVERESTORERD_SAVE_VAL_MASK) | (((uint32_t)val) << SHARPM_SAVERESTORERD_SAVE_VAL_SHIFT))

//====================================================================
//Register: SharpM Save Restore Write Register (SaveRestoreWr)
/** \brief This write-only register is provided for the restore portion of save/restore functionality. The "save_restore_mode" bit of the configuration register must be set to a 1 to access
      this register.*/
//====================================================================

#define  SHARPM_SAVERESTOREWR_RESTORE_VAL_MASK 0xffffffff
#define  SHARPM_SAVERESTOREWR_RESTORE_VAL_SHIFT 0
#define  SHARPM_SAVERESTOREWR_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & SHARPM_SAVERESTOREWR_RESTORE_VAL_MASK) >> SHARPM_SAVERESTOREWR_RESTORE_VAL_SHIFT)
#define  SHARPM_SAVERESTOREWR_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_SAVERESTOREWR_RESTORE_VAL_MASK) | (((uint32_t)val) << SHARPM_SAVERESTOREWR_RESTORE_VAL_SHIFT))

//====================================================================
//Register: SharpM Save Restore Read Register 2 (SaveRestoreRd2)
/** \brief This read-only register is provided for the save portion of save/restore functionality. The "save_restore_mode" bit of the configuration register must be set to a 1 to access this register.*/
//====================================================================

#define  SHARPM_SAVERESTORERD2_SAVE_VAL_MASK 0xffffffff
#define  SHARPM_SAVERESTORERD2_SAVE_VAL_SHIFT 0
#define  SHARPM_SAVERESTORERD2_SAVE_VAL_MASK_SHIFT(reg) (((reg) & SHARPM_SAVERESTORERD2_SAVE_VAL_MASK) >> SHARPM_SAVERESTORERD2_SAVE_VAL_SHIFT)
#define  SHARPM_SAVERESTORERD2_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_SAVERESTORERD2_SAVE_VAL_MASK) | (((uint32_t)val) << SHARPM_SAVERESTORERD2_SAVE_VAL_SHIFT))

//====================================================================
//Register: SharpM Save Restore Write Register 2 (SaveRestoreWr2)
/** \brief This write-only register is provided for the restore portion of save/restore functionality. The "save_restore_mode" bit of the configuration register must be set to a 1 to access
      this register.*/
//====================================================================

#define  SHARPM_SAVERESTOREWR2_RESTORE_VAL_MASK 0xffffffff
#define  SHARPM_SAVERESTOREWR2_RESTORE_VAL_SHIFT 0
#define  SHARPM_SAVERESTOREWR2_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & SHARPM_SAVERESTOREWR2_RESTORE_VAL_MASK) >> SHARPM_SAVERESTOREWR2_RESTORE_VAL_SHIFT)
#define  SHARPM_SAVERESTOREWR2_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_SAVERESTOREWR2_RESTORE_VAL_MASK) | (((uint32_t)val) << SHARPM_SAVERESTOREWR2_RESTORE_VAL_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  SHARPM_REV0_MAJ_MASK 0xffff0000
#define  SHARPM_REV0_MAJ_SHIFT 16
#define  SHARPM_REV0_MAJ_MASK_SHIFT(reg) (((reg) & SHARPM_REV0_MAJ_MASK) >> SHARPM_REV0_MAJ_SHIFT)
#define  SHARPM_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_REV0_MAJ_MASK) | (((uint32_t)val) << SHARPM_REV0_MAJ_SHIFT))

#define  SHARPM_REV0_MID_MASK 0xffff
#define  SHARPM_REV0_MID_SHIFT 0
#define  SHARPM_REV0_MID_MASK_SHIFT(reg) (((reg) & SHARPM_REV0_MID_MASK) >> SHARPM_REV0_MID_SHIFT)
#define  SHARPM_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_REV0_MID_MASK) | (((uint32_t)val) << SHARPM_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  SHARPM_REV1_RESERVED1_MASK 0xffff0000
#define  SHARPM_REV1_RESERVED1_SHIFT 16
#define  SHARPM_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_REV1_RESERVED1_MASK) >> SHARPM_REV1_RESERVED1_SHIFT)
#define  SHARPM_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_REV1_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_REV1_RESERVED1_SHIFT))

#define  SHARPM_REV1_CFG_MASK 0xffff
#define  SHARPM_REV1_CFG_SHIFT 0
#define  SHARPM_REV1_CFG_MASK_SHIFT(reg) (((reg) & SHARPM_REV1_CFG_MASK) >> SHARPM_REV1_CFG_SHIFT)
#define  SHARPM_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_REV1_CFG_MASK) | (((uint32_t)val) << SHARPM_REV1_CFG_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 1 of 30) (Y_coeff_scale0)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 1 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE0_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE0_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE0_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE0_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE0_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE0_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE0_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE0_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE0_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE0_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE0_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE0_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE0_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE0_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE0_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE0_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE0_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE0_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE0_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE0_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE0_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE0_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE0_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE0_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE0_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE0_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE0_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE0_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE0_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE0_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 2 of 30) (Y_coeff_scale1)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 2 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE1_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE1_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE1_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE1_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE1_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE1_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE1_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE1_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE1_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE1_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE1_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE1_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE1_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE1_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE1_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE1_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE1_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE1_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE1_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE1_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE1_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE1_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE1_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE1_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE1_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE1_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE1_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE1_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE1_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE1_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 3 of 30) (Y_coeff_scale2)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 3 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE2_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE2_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE2_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE2_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE2_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE2_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE2_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE2_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE2_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE2_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE2_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE2_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE2_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE2_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE2_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE2_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE2_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE2_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE2_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE2_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE2_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE2_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE2_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE2_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE2_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE2_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE2_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE2_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE2_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE2_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 4 of 30) (Y_coeff_scale3)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 4 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE3_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE3_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE3_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE3_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE3_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE3_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE3_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE3_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE3_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE3_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE3_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE3_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE3_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE3_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE3_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE3_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE3_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE3_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE3_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE3_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE3_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE3_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE3_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE3_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE3_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE3_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE3_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE3_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE3_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE3_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 5 of 30) (Y_coeff_scale4)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 5 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE4_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE4_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE4_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE4_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE4_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE4_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE4_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE4_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE4_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE4_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE4_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE4_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE4_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE4_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE4_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE4_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE4_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE4_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE4_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE4_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE4_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE4_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE4_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE4_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE4_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE4_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE4_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE4_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE4_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE4_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 6 of 30) (Y_coeff_scale5)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 6 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE5_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE5_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE5_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE5_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE5_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE5_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE5_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE5_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE5_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE5_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE5_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE5_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE5_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE5_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE5_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE5_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE5_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE5_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE5_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE5_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE5_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE5_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE5_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE5_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE5_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE5_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE5_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE5_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE5_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE5_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 7 of 30) (Y_coeff_scale6)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 7 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE6_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE6_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE6_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE6_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE6_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE6_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE6_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE6_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE6_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE6_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE6_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE6_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE6_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE6_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE6_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE6_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE6_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE6_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE6_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE6_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE6_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE6_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE6_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE6_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE6_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE6_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE6_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE6_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE6_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE6_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 8 of 30) (Y_coeff_scale7)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 8 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE7_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE7_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE7_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE7_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE7_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE7_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE7_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE7_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE7_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE7_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE7_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE7_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE7_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE7_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE7_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE7_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE7_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE7_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE7_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE7_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE7_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE7_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE7_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE7_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE7_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE7_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE7_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE7_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE7_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE7_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 9 of 30) (Y_coeff_scale8)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 9 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE8_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE8_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE8_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE8_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE8_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE8_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE8_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE8_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE8_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE8_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE8_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE8_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE8_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE8_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE8_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE8_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE8_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE8_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE8_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE8_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE8_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE8_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE8_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE8_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE8_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE8_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE8_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE8_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE8_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE8_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 10 of 30) (Y_coeff_scale9)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 10 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE9_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE9_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE9_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE9_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE9_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE9_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE9_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE9_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE9_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE9_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE9_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE9_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE9_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE9_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE9_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE9_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE9_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE9_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE9_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE9_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE9_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE9_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE9_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE9_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE9_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE9_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE9_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE9_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE9_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE9_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 11 of 30) (Y_coeff_scale10)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 11 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE10_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE10_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE10_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE10_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE10_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE10_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE10_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE10_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE10_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE10_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE10_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE10_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE10_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE10_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE10_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE10_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE10_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE10_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE10_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE10_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE10_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE10_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE10_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE10_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE10_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE10_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE10_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE10_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE10_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE10_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 12 of 30) (Y_coeff_scale11)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 12 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE11_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE11_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE11_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE11_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE11_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE11_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE11_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE11_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE11_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE11_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE11_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE11_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE11_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE11_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE11_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE11_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE11_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE11_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE11_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE11_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE11_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE11_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE11_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE11_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE11_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE11_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE11_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE11_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE11_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE11_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 13 of 30) (Y_coeff_scale12)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 13 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE12_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE12_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE12_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE12_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE12_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE12_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE12_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE12_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE12_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE12_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE12_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE12_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE12_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE12_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE12_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE12_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE12_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE12_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE12_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE12_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE12_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE12_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE12_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE12_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE12_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE12_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE12_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE12_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE12_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE12_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 14 of 30) (Y_coeff_scale13)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 14 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE13_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE13_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE13_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE13_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE13_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE13_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE13_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE13_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE13_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE13_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE13_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE13_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE13_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE13_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE13_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE13_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE13_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE13_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE13_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE13_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE13_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE13_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE13_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE13_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE13_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE13_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE13_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE13_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE13_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE13_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 15 of 30) (Y_coeff_scale14)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 15 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE14_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE14_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE14_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE14_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE14_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE14_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE14_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE14_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE14_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE14_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE14_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE14_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE14_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE14_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE14_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE14_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE14_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE14_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE14_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE14_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE14_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE14_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE14_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE14_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE14_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE14_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE14_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE14_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE14_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE14_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 16 of 30) (Y_coeff_scale15)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 16 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE15_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE15_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE15_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE15_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE15_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE15_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE15_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE15_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE15_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE15_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE15_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE15_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE15_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE15_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE15_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE15_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE15_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE15_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE15_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE15_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE15_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE15_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE15_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE15_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE15_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE15_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE15_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE15_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE15_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE15_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 17 of 30) (Y_coeff_scale16)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 17 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE16_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE16_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE16_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE16_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE16_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE16_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE16_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE16_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE16_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE16_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE16_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE16_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE16_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE16_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE16_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE16_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE16_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE16_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE16_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE16_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE16_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE16_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE16_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE16_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE16_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE16_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE16_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE16_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE16_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE16_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE16_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE16_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 18 of 30) (Y_coeff_scale17)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 18 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE17_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE17_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE17_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE17_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE17_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE17_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE17_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE17_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE17_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE17_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE17_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE17_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE17_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE17_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE17_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE17_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE17_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE17_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE17_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE17_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE17_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE17_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE17_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE17_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE17_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE17_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE17_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE17_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE17_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE17_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE17_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE17_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 19 of 30) (Y_coeff_scale18)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 19 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE18_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE18_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE18_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE18_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE18_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE18_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE18_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE18_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE18_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE18_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE18_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE18_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE18_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE18_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE18_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE18_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE18_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE18_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE18_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE18_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE18_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE18_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE18_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE18_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE18_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE18_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE18_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE18_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE18_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE18_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE18_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE18_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 20 of 30) (Y_coeff_scale19)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 20 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE19_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE19_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE19_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE19_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE19_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE19_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE19_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE19_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE19_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE19_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE19_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE19_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE19_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE19_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE19_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE19_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE19_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE19_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE19_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE19_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE19_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE19_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE19_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE19_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE19_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE19_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE19_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE19_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE19_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE19_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE19_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE19_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 21 of 30) (Y_coeff_scale20)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 21 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE20_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE20_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE20_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE20_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE20_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE20_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE20_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE20_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE20_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE20_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE20_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE20_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE20_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE20_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE20_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE20_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE20_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE20_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE20_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE20_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE20_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE20_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE20_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE20_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE20_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE20_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE20_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE20_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE20_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE20_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE20_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE20_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 22 of 30) (Y_coeff_scale21)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 22 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE21_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE21_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE21_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE21_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE21_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE21_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE21_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE21_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE21_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE21_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE21_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE21_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE21_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE21_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE21_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE21_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE21_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE21_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE21_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE21_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE21_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE21_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE21_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE21_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE21_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE21_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE21_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE21_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE21_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE21_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE21_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 23 of 30) (Y_coeff_scale22)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 23 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE22_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE22_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE22_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE22_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE22_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE22_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE22_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE22_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE22_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE22_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE22_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE22_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE22_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE22_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE22_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE22_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE22_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE22_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE22_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE22_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE22_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE22_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE22_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE22_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE22_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE22_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE22_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE22_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE22_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE22_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE22_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE22_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 24 of 30) (Y_coeff_scale23)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 24 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE23_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE23_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE23_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE23_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE23_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE23_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE23_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE23_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE23_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE23_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE23_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE23_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE23_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE23_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE23_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE23_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE23_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE23_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE23_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE23_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE23_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE23_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE23_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE23_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE23_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE23_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE23_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE23_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE23_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE23_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE23_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE23_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 25 of 30) (Y_coeff_scale24)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 25 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE24_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE24_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE24_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE24_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE24_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE24_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE24_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE24_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE24_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE24_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE24_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE24_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE24_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE24_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE24_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE24_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE24_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE24_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE24_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE24_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE24_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE24_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE24_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE24_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE24_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE24_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE24_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE24_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE24_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE24_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE24_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 26 of 30) (Y_coeff_scale25)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 26 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE25_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE25_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE25_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE25_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE25_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE25_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE25_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE25_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE25_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE25_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE25_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE25_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE25_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE25_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE25_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE25_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE25_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE25_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE25_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE25_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE25_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE25_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE25_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE25_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE25_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE25_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE25_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE25_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE25_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE25_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE25_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE25_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 27 of 30) (Y_coeff_scale26)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 27 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE26_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE26_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE26_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE26_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE26_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE26_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE26_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE26_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE26_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE26_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE26_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE26_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE26_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE26_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE26_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE26_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE26_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE26_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE26_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE26_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE26_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE26_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE26_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE26_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE26_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE26_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE26_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE26_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE26_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE26_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE26_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE26_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 28 of 30) (Y_coeff_scale27)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 28 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE27_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE27_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE27_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE27_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE27_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE27_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE27_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE27_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE27_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE27_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE27_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE27_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE27_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE27_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE27_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE27_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE27_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE27_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE27_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE27_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE27_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE27_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE27_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE27_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE27_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE27_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE27_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE27_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE27_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE27_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE27_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE27_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 29 of 30) (Y_coeff_scale28)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 29 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE28_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE28_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE28_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE28_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE28_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE28_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE28_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE28_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE28_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE28_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE28_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE28_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE28_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE28_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE28_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE28_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE28_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE28_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE28_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE28_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE28_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE28_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE28_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE28_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE28_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE28_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE28_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE28_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE28_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE28_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE28_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE28_VALUE0_SHIFT))

//====================================================================
//Register: Y Resizing Coefficient (Instance 30 of 30) (Y_coeff_scale29)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the Y (first) color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in Y_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If y_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining y_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if y_coeff_mode is set. The first 5 values (contained in Y_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 30 of 30)*/
//====================================================================

#define  SHARPM_Y_COEFF_SCALE29_RESERVED1_MASK 0xf0000000
#define  SHARPM_Y_COEFF_SCALE29_RESERVED1_SHIFT 28
#define  SHARPM_Y_COEFF_SCALE29_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE29_RESERVED1_MASK) >> SHARPM_Y_COEFF_SCALE29_RESERVED1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE29_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE29_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE29_RESERVED1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE29_VALUE1_MASK 0xfff0000
#define  SHARPM_Y_COEFF_SCALE29_VALUE1_SHIFT 16
#define  SHARPM_Y_COEFF_SCALE29_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE29_VALUE1_MASK) >> SHARPM_Y_COEFF_SCALE29_VALUE1_SHIFT)
#define  SHARPM_Y_COEFF_SCALE29_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE29_VALUE1_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE29_VALUE1_SHIFT))

#define  SHARPM_Y_COEFF_SCALE29_RESERVED2_MASK 0xf000
#define  SHARPM_Y_COEFF_SCALE29_RESERVED2_SHIFT 12
#define  SHARPM_Y_COEFF_SCALE29_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE29_RESERVED2_MASK) >> SHARPM_Y_COEFF_SCALE29_RESERVED2_SHIFT)
#define  SHARPM_Y_COEFF_SCALE29_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE29_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE29_RESERVED2_SHIFT))

#define  SHARPM_Y_COEFF_SCALE29_VALUE0_MASK 0xfff
#define  SHARPM_Y_COEFF_SCALE29_VALUE0_SHIFT 0
#define  SHARPM_Y_COEFF_SCALE29_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_Y_COEFF_SCALE29_VALUE0_MASK) >> SHARPM_Y_COEFF_SCALE29_VALUE0_SHIFT)
#define  SHARPM_Y_COEFF_SCALE29_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_Y_COEFF_SCALE29_VALUE0_MASK) | (((uint32_t)val) << SHARPM_Y_COEFF_SCALE29_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 1 of 30) (C_coeff_scale0)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 1 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE0_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE0_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE0_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE0_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE0_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE0_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE0_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE0_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE0_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE0_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE0_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE0_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE0_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE0_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE0_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE0_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE0_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE0_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE0_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE0_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE0_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE0_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE0_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE0_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE0_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE0_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE0_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE0_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE0_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE0_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 2 of 30) (C_coeff_scale1)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 2 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE1_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE1_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE1_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE1_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE1_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE1_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE1_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE1_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE1_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE1_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE1_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE1_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE1_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE1_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE1_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE1_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE1_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE1_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE1_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE1_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE1_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE1_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE1_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE1_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE1_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE1_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE1_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE1_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE1_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE1_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 3 of 30) (C_coeff_scale2)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 3 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE2_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE2_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE2_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE2_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE2_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE2_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE2_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE2_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE2_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE2_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE2_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE2_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE2_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE2_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE2_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE2_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE2_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE2_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE2_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE2_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE2_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE2_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE2_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE2_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE2_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE2_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE2_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE2_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE2_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE2_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 4 of 30) (C_coeff_scale3)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 4 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE3_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE3_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE3_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE3_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE3_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE3_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE3_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE3_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE3_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE3_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE3_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE3_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE3_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE3_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE3_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE3_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE3_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE3_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE3_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE3_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE3_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE3_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE3_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE3_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE3_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE3_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE3_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE3_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE3_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE3_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 5 of 30) (C_coeff_scale4)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 5 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE4_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE4_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE4_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE4_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE4_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE4_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE4_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE4_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE4_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE4_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE4_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE4_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE4_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE4_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE4_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE4_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE4_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE4_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE4_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE4_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE4_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE4_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE4_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE4_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE4_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE4_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE4_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE4_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE4_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE4_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 6 of 30) (C_coeff_scale5)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 6 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE5_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE5_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE5_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE5_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE5_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE5_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE5_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE5_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE5_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE5_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE5_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE5_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE5_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE5_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE5_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE5_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE5_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE5_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE5_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE5_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE5_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE5_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE5_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE5_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE5_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE5_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE5_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE5_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE5_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE5_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 7 of 30) (C_coeff_scale6)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 7 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE6_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE6_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE6_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE6_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE6_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE6_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE6_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE6_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE6_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE6_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE6_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE6_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE6_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE6_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE6_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE6_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE6_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE6_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE6_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE6_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE6_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE6_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE6_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE6_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE6_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE6_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE6_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE6_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE6_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE6_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 8 of 30) (C_coeff_scale7)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 8 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE7_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE7_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE7_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE7_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE7_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE7_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE7_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE7_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE7_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE7_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE7_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE7_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE7_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE7_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE7_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE7_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE7_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE7_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE7_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE7_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE7_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE7_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE7_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE7_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE7_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE7_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE7_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE7_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE7_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE7_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 9 of 30) (C_coeff_scale8)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 9 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE8_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE8_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE8_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE8_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE8_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE8_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE8_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE8_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE8_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE8_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE8_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE8_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE8_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE8_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE8_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE8_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE8_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE8_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE8_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE8_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE8_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE8_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE8_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE8_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE8_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE8_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE8_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE8_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE8_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE8_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 10 of 30) (C_coeff_scale9)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 10 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE9_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE9_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE9_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE9_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE9_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE9_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE9_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE9_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE9_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE9_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE9_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE9_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE9_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE9_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE9_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE9_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE9_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE9_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE9_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE9_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE9_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE9_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE9_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE9_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE9_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE9_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE9_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE9_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE9_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE9_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 11 of 30) (C_coeff_scale10)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 11 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE10_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE10_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE10_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE10_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE10_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE10_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE10_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE10_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE10_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE10_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE10_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE10_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE10_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE10_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE10_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE10_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE10_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE10_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE10_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE10_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE10_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE10_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE10_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE10_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE10_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE10_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE10_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE10_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE10_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE10_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 12 of 30) (C_coeff_scale11)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 12 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE11_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE11_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE11_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE11_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE11_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE11_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE11_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE11_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE11_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE11_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE11_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE11_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE11_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE11_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE11_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE11_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE11_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE11_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE11_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE11_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE11_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE11_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE11_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE11_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE11_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE11_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE11_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE11_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE11_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE11_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 13 of 30) (C_coeff_scale12)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 13 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE12_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE12_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE12_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE12_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE12_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE12_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE12_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE12_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE12_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE12_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE12_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE12_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE12_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE12_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE12_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE12_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE12_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE12_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE12_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE12_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE12_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE12_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE12_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE12_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE12_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE12_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE12_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE12_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE12_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE12_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 14 of 30) (C_coeff_scale13)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 14 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE13_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE13_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE13_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE13_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE13_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE13_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE13_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE13_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE13_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE13_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE13_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE13_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE13_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE13_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE13_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE13_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE13_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE13_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE13_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE13_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE13_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE13_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE13_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE13_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE13_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE13_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE13_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE13_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE13_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE13_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 15 of 30) (C_coeff_scale14)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 15 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE14_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE14_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE14_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE14_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE14_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE14_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE14_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE14_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE14_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE14_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE14_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE14_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE14_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE14_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE14_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE14_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE14_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE14_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE14_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE14_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE14_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE14_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE14_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE14_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE14_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE14_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE14_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE14_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE14_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE14_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 16 of 30) (C_coeff_scale15)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 16 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE15_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE15_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE15_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE15_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE15_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE15_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE15_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE15_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE15_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE15_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE15_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE15_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE15_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE15_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE15_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE15_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE15_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE15_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE15_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE15_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE15_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE15_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE15_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE15_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE15_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE15_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE15_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE15_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE15_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE15_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 17 of 30) (C_coeff_scale16)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 17 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE16_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE16_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE16_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE16_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE16_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE16_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE16_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE16_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE16_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE16_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE16_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE16_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE16_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE16_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE16_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE16_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE16_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE16_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE16_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE16_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE16_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE16_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE16_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE16_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE16_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE16_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE16_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE16_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE16_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE16_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE16_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE16_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 18 of 30) (C_coeff_scale17)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 18 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE17_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE17_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE17_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE17_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE17_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE17_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE17_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE17_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE17_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE17_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE17_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE17_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE17_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE17_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE17_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE17_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE17_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE17_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE17_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE17_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE17_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE17_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE17_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE17_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE17_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE17_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE17_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE17_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE17_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE17_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE17_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE17_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 19 of 30) (C_coeff_scale18)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 19 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE18_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE18_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE18_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE18_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE18_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE18_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE18_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE18_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE18_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE18_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE18_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE18_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE18_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE18_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE18_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE18_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE18_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE18_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE18_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE18_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE18_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE18_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE18_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE18_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE18_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE18_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE18_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE18_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE18_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE18_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE18_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE18_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 20 of 30) (C_coeff_scale19)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 20 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE19_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE19_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE19_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE19_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE19_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE19_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE19_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE19_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE19_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE19_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE19_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE19_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE19_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE19_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE19_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE19_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE19_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE19_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE19_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE19_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE19_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE19_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE19_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE19_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE19_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE19_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE19_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE19_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE19_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE19_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE19_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE19_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 21 of 30) (C_coeff_scale20)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 21 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE20_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE20_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE20_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE20_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE20_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE20_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE20_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE20_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE20_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE20_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE20_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE20_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE20_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE20_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE20_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE20_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE20_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE20_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE20_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE20_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE20_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE20_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE20_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE20_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE20_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE20_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE20_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE20_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE20_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE20_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE20_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE20_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 22 of 30) (C_coeff_scale21)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 22 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE21_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE21_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE21_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE21_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE21_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE21_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE21_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE21_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE21_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE21_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE21_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE21_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE21_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE21_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE21_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE21_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE21_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE21_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE21_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE21_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE21_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE21_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE21_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE21_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE21_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE21_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE21_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE21_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE21_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE21_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE21_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 23 of 30) (C_coeff_scale22)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 23 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE22_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE22_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE22_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE22_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE22_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE22_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE22_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE22_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE22_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE22_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE22_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE22_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE22_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE22_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE22_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE22_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE22_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE22_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE22_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE22_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE22_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE22_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE22_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE22_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE22_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE22_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE22_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE22_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE22_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE22_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE22_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE22_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 24 of 30) (C_coeff_scale23)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 24 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE23_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE23_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE23_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE23_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE23_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE23_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE23_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE23_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE23_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE23_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE23_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE23_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE23_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE23_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE23_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE23_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE23_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE23_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE23_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE23_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE23_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE23_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE23_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE23_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE23_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE23_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE23_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE23_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE23_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE23_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE23_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE23_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 25 of 30) (C_coeff_scale24)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 25 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE24_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE24_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE24_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE24_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE24_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE24_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE24_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE24_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE24_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE24_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE24_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE24_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE24_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE24_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE24_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE24_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE24_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE24_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE24_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE24_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE24_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE24_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE24_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE24_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE24_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE24_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE24_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE24_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE24_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE24_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE24_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 26 of 30) (C_coeff_scale25)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 26 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE25_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE25_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE25_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE25_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE25_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE25_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE25_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE25_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE25_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE25_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE25_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE25_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE25_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE25_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE25_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE25_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE25_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE25_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE25_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE25_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE25_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE25_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE25_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE25_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE25_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE25_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE25_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE25_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE25_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE25_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE25_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE25_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 27 of 30) (C_coeff_scale26)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 27 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE26_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE26_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE26_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE26_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE26_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE26_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE26_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE26_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE26_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE26_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE26_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE26_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE26_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE26_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE26_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE26_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE26_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE26_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE26_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE26_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE26_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE26_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE26_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE26_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE26_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE26_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE26_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE26_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE26_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE26_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE26_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE26_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 28 of 30) (C_coeff_scale27)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 28 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE27_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE27_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE27_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE27_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE27_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE27_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE27_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE27_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE27_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE27_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE27_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE27_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE27_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE27_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE27_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE27_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE27_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE27_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE27_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE27_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE27_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE27_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE27_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE27_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE27_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE27_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE27_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE27_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE27_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE27_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE27_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE27_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 29 of 30) (C_coeff_scale28)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 29 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE28_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE28_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE28_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE28_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE28_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE28_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE28_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE28_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE28_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE28_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE28_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE28_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE28_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE28_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE28_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE28_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE28_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE28_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE28_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE28_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE28_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE28_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE28_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE28_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE28_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE28_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE28_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE28_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE28_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE28_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE28_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE28_VALUE0_SHIFT))

//====================================================================
//Register: C Resizing Coefficient (Instance 30 of 30) (C_coeff_scale29)
/** \brief These registers should be written with the coefficient values for the Filter
      that will be applied to the C color channel. This set of coefficients is primarily used for resizing.
      There is a complete descripton of how to program these registers in the programming section.
      <br/> <br/> Resize Mode - 4x4 filter. There are 16 sets of coefficients. The first set is in C_coeff[1:4]. The remaining sets are contained in the Y_coeff_scale
      registers. If c_coeff_mode is set then y_coeff_scale0 to 13 are decoded as horizontal multiplication coefficents. The
      remaining c_coeff_scale14 to 30 are for vertical multiplications.
      <br/> <br/> Sharpen Mode - Only used if c_coeff_mode is set. The first 5 values (contained in C_coeff_scale0-2) are used for the
      vertical coefficients. (Instance 30 of 30)*/
//====================================================================

#define  SHARPM_C_COEFF_SCALE29_RESERVED1_MASK 0xf0000000
#define  SHARPM_C_COEFF_SCALE29_RESERVED1_SHIFT 28
#define  SHARPM_C_COEFF_SCALE29_RESERVED1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE29_RESERVED1_MASK) >> SHARPM_C_COEFF_SCALE29_RESERVED1_SHIFT)
#define  SHARPM_C_COEFF_SCALE29_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE29_RESERVED1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE29_RESERVED1_SHIFT))

#define  SHARPM_C_COEFF_SCALE29_VALUE1_MASK 0xfff0000
#define  SHARPM_C_COEFF_SCALE29_VALUE1_SHIFT 16
#define  SHARPM_C_COEFF_SCALE29_VALUE1_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE29_VALUE1_MASK) >> SHARPM_C_COEFF_SCALE29_VALUE1_SHIFT)
#define  SHARPM_C_COEFF_SCALE29_VALUE1_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE29_VALUE1_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE29_VALUE1_SHIFT))

#define  SHARPM_C_COEFF_SCALE29_RESERVED2_MASK 0xf000
#define  SHARPM_C_COEFF_SCALE29_RESERVED2_SHIFT 12
#define  SHARPM_C_COEFF_SCALE29_RESERVED2_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE29_RESERVED2_MASK) >> SHARPM_C_COEFF_SCALE29_RESERVED2_SHIFT)
#define  SHARPM_C_COEFF_SCALE29_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE29_RESERVED2_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE29_RESERVED2_SHIFT))

#define  SHARPM_C_COEFF_SCALE29_VALUE0_MASK 0xfff
#define  SHARPM_C_COEFF_SCALE29_VALUE0_SHIFT 0
#define  SHARPM_C_COEFF_SCALE29_VALUE0_MASK_SHIFT(reg) (((reg) & SHARPM_C_COEFF_SCALE29_VALUE0_MASK) >> SHARPM_C_COEFF_SCALE29_VALUE0_SHIFT)
#define  SHARPM_C_COEFF_SCALE29_VALUE0_REPLACE_VAL(reg,val) (((reg) & ~SHARPM_C_COEFF_SCALE29_VALUE0_MASK) | (((uint32_t)val) << SHARPM_C_COEFF_SCALE29_VALUE0_SHIFT))

#endif // SHARPM
