 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SDMMC3_regstructs_2p.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SDMMC3_2P_REGSTRUCTS_H_
#define _SDMMC3_2P_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SDMMC3 Card Interface (SDMMC3_2p)
/** \brief Top-level register file for SDMMC3 Host Interface Block*/
//
//====================================================================

typedef struct SDMMC3_2P_REGS_s
{
  volatile uint16_t SD_SYS_ADDR_LOW0;  ///< 0x0 [R/W]: SDMA System Address / Argument 2 (Low) Register (Instance 1 of 2)
  volatile uint16_t SD_SYS_ADDR_HIGH0;  ///< 0x2 [R/W]: System Address High Register (Instance 1 of 2)
  volatile uint16_t SD_BLOCK_SIZE0;  ///< 0x4 [R/W]: Block Size Register (Instance 1 of 2)
  volatile uint16_t SD_BLOCK_COUNT0;  ///< 0x6 [R/W]: Block Count Register (Instance 1 of 2)
  volatile uint16_t SD_ARG_LOW0;  ///< 0x8 [R/W]: Argument Low Register (Instance 1 of 2)
  volatile uint16_t SD_ARG_HIGH0;  ///< 0xA [R/W]: Argument High Register (Instance 1 of 2)
  volatile uint16_t SD_TRANSFER_MODE0;  ///< 0xC [R/W]: Transfer Mode Register (Instance 1 of 2)
  volatile uint16_t SD_CMD0;  ///< 0xE [R/W]: Command Register (Instance 1 of 2)
  volatile uint16_t SD_RESP_00;  ///< 0x10 [R]: Response Register 0 (Instance 1 of 2)
  volatile uint16_t SD_RESP_10;  ///< 0x12 [R]: Response Register 1 (Instance 1 of 2)
  volatile uint16_t SD_RESP_20;  ///< 0x14 [R]: Response Register 2 (Instance 1 of 2)
  volatile uint16_t SD_RESP_30;  ///< 0x16 [R]: Response Register 3 (Instance 1 of 2)
  volatile uint16_t SD_RESP_40;  ///< 0x18 [R]: Response Register 4 (Instance 1 of 2)
  volatile uint16_t SD_RESP_50;  ///< 0x1A [R]: Response Register 5 (Instance 1 of 2)
  volatile uint16_t SD_RESP_60;  ///< 0x1C [R]: Response Register 6 (Instance 1 of 2)
  volatile uint16_t SD_RESP_70;  ///< 0x1E [R]: Response Register 7 (Instance 1 of 2)
  volatile uint16_t SD_BUFFER_DATA_PORT_00;  ///< 0x20 [R/W]: Buffer Data Port 0 Register (Instance 1 of 2)
  volatile uint16_t SD_BUFFER_DATA_PORT_10;  ///< 0x22 [R/W]: Buffer Data Port 1 Register (Instance 1 of 2)
  volatile uint16_t SD_PRESENT_STATE_00;  ///< 0x24 [R/W]: Present State Register 0 (Instance 1 of 2)
  volatile uint16_t SD_PRESENT_STATE_10;  ///< 0x26 [R]: Present State Register 1 (Instance 1 of 2)
  volatile uint16_t SD_HOST_CTRL0;  ///< 0x28 [R/W]: Host Control Register (Instance 1 of 2)
  volatile uint16_t SD_BLOCK_GAP_CTRL0;  ///< 0x2A [R/W]: Block Gap Control Register (Instance 1 of 2)
  volatile uint16_t SD_CLOCK_CTRL0;  ///< 0x2C [R/W]: Clock Control Register (Instance 1 of 2)
  volatile uint16_t SD_TIMEOUT_CTRL_SW_RESET0;  ///< 0x2E [R/W]: Timeout Control/Software Reset Register (Instance 1 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS0;  ///< 0x30 [R/W]: Normal Interrupt Status Register (Instance 1 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS0;  ///< 0x32 [R/W]: Error Interrupt Status Register (Instance 1 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS_EN0;  ///< 0x34 [R/W]: Normal Interrupt Status Enable Register (Instance 1 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS_EN0;  ///< 0x36 [R/W]: Error Interrupt Status Enable Register (Instance 1 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS_INT_EN0;  ///< 0x38 [R/W]: Normal Interrupt Signal Enable Register (Instance 1 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS_INT_EN0;  ///< 0x3A [R/W]: Error Interrupt Signal Enable Register (Instance 1 of 2)
  volatile uint16_t SD_AUTO_CMD12_ERROR_STATUS0;  ///< 0x3C [R/W]: Auto CMD12 Error Status Register (Instance 1 of 2)
  volatile uint16_t SD_HOST_CTRL20;  ///< 0x3E [R/W]: Host Control Register 2 (Instance 1 of 2)
  volatile uint16_t SD_CAPABILITIES_00;  ///< 0x40 [R]: Capabilities Register 0 (Instance 1 of 2)
  volatile uint16_t SD_CAPABILITIES_10;  ///< 0x42 [R]: Capabilities Register 1 (Instance 1 of 2)
  volatile uint16_t SD_CAPABILITIES_20;  ///< 0x44 [R]: Capabilities Register 2 (Instance 1 of 2)
  volatile uint16_t SD_CAPABILITIES_30;  ///< 0x46 [R]: Capabilities Register 3 (Instance 1 of 2)
  volatile uint16_t SD_MAX_CURRENT_00;  ///< 0x48 [R]: Maximum Current Register 0 (Instance 1 of 2)
  volatile uint16_t SD_MAX_CURRENT_10;  ///< 0x4A [R]: Maximum Current Register 1 (Instance 1 of 2)
  volatile uint16_t SD_MAX_CURRENT_20;  ///< 0x4C [R]: Maximum Current Register 2 (Instance 1 of 2)
  volatile uint16_t SD_MAX_CURRENT_30;  ///< 0x4E [R]: Maximum Current Register 3 (Instance 1 of 2)
  volatile uint16_t SD_FORCE_EVENT_AUTO_CMD12_ERROR0;  ///< 0x50 [W]: Force Event Auto cmd12 Error Register (Instance 1 of 2)
  volatile uint16_t SD_FORCE_EVENT_FOR_ERROR_STATUS0;  ///< 0x52 [W]: Force Event for Error Status Register (Instance 1 of 2)
  volatile uint16_t SD_ADMA_ERROR_STATUS0;  ///< 0x54 [R/W]: ADMA Error Status Register (Instance 1 of 2)
  volatile uint16_t reserved0;
  volatile uint16_t SD_ADMA_SYS_ADDR_00;  ///< 0x58 [R/W]: ADMA System Address Register 0 (Instance 1 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_10;  ///< 0x5A [R/W]: ADMA System Address Register 1 (Instance 1 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_20;  ///< 0x5C [R/W]: ADMA System Address Register 2 (Instance 1 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_30;  ///< 0x5E [R/W]: ADMA System Address Register 3 (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_INIT0;  ///< 0x60 [R]: Preset Value Regiser for Initialization (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_DS0;  ///< 0x62 [R]: Preset Value Regiser for Default Speed (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_HS0;  ///< 0x64 [R]: Preset Value Regiser for High Speed (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR120;  ///< 0x66 [R]: Preset Value Regiser for SDR12 (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR250;  ///< 0x68 [R]: Preset Value Regiser for SDR25 (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR500;  ///< 0x6A [R]: Preset Value Regiser for SDR50 (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR1040;  ///< 0x6C [R]: Preset Value Regiser for SDR104 (Instance 1 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_DDR500;  ///< 0x6E [R]: Preset Value Regiser for DDR50 (Instance 1 of 2)
  volatile uint16_t reserved1[56];
  volatile uint16_t SD_SHARED_BUS_CTRL_LOW0;  ///< 0xE0 [R/W]: Shared Bus Control Register (Low) (Instance 1 of 2)
  volatile uint16_t SD_SHARED_BUS_CTRL_HIGH0;  ///< 0xE2 [R/W]: Shared Bus Control Register (High) (Instance 1 of 2)
  volatile uint16_t reserved2[12];
  volatile uint16_t SD_SLOT_INT_STATUS0;  ///< 0xFC [R]: Slot Interrupt Status Register (Instance 1 of 2)
  volatile uint16_t SD_HOST_CTRL_VER0;  ///< 0xFE [R]: Host Control Version Register (Instance 1 of 2)
  volatile uint16_t SD_CFG_FIFO_PARAM_00;  ///< 0x100 [R/W]: SD Extra parameters Register (Low) (Instance 1 of 2)
  volatile uint16_t SD_CFG_FIFO_PARAM_10;  ///< 0x102 [R/W]: SD Extra parameters Register (High) (Instance 1 of 2)
  volatile uint16_t SD_FIFO_PARAM_00;  ///< 0x104 [R/W]: FIFO Parameters Register (LOW) (Instance 1 of 2)
  volatile uint16_t SD_FIFO_PARAM_10;  ///< 0x106 [R/W]: FIFO Parameters Register (High) (Instance 1 of 2)
  volatile uint16_t SD_SPI_MODE0;  ///< 0x108 [R/W]: SPI Mode Register (Instance 1 of 2)
  volatile uint16_t SD_CLOCK_AND_BURST_SIZE_SETUP0;  ///< 0x10A [R/W]: Clock and Burst Size Setup Register (Instance 1 of 2)
  volatile uint16_t SD_CE_ATA_10;  ///< 0x10C [R/W]: CE-ATA Register 0 (Instance 1 of 2)
  volatile uint16_t SD_CE_ATA_20;  ///< 0x10E [R/W]: CE-ATA Register 1 (Instance 1 of 2)
  volatile uint16_t SD_PAD_IO_SETUP00;  ///< 0x110 [R/W]: PAD I/O Setup Register lower (Instance 1 of 2)
  volatile uint16_t SD_PAD_IO_SETUP10;  ///< 0x112 [R/W]: PAD I/O Setup Register upper (Instance 1 of 2)
  volatile uint16_t SD_RX_CFG_00;  ///< 0x114 [R/W]: RX Configuration Register (Low) (Instance 1 of 2)
  volatile uint16_t SD_RX_CFG_10;  ///< 0x116 [R/W]: RX Configuration Register (High) (Instance 1 of 2)
  volatile uint16_t SD_TX_CFG_00;  ///< 0x118 [R/W]: TX Configuration Register (Low) (Instance 1 of 2)
  volatile uint16_t SD_TX_CFG_10;  ///< 0x11A [R/W]: TX Configuration Register (HIGH) (Instance 1 of 2)
  volatile uint16_t TUNING_CFG_REG_00;  ///< 0x11C [R/W]: Tuning Configuration Register (Low) (Instance 1 of 2)
  volatile uint16_t TUNING_CFG_REG_10;  ///< 0x11E [R/W]: Tuning Configuration Register (HIGH) (Instance 1 of 2)
  volatile uint16_t SD_DBG_000;  ///< 0x120 [R/W]: Debug Register 0 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_010;  ///< 0x122 [R/W]: Debug Register 0 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_100;  ///< 0x124 [R/W]: Debug Register 1 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_110;  ///< 0x126 [R/W]: Debug Register 1 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_200;  ///< 0x128 [R/W]: Debug Register 2 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_210;  ///< 0x12A [R/W]: Debug Register 2 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_300;  ///< 0x12C [R/W]: Debug Register 3 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_310;  ///< 0x12E [R/W]: Debug Register 3 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_400;  ///< 0x130 [R/W]: Debug Register 4 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_410;  ///< 0x132 [R/W]: Debug Register 4 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_500;  ///< 0x134 [R/W]: Debug Register 5 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_510;  ///< 0x136 [R/W]: Debug Register 5 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_600;  ///< 0x138 [R/W]: Debug Register 6 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_610;  ///< 0x13A [R/W]: Debug Register 6 (High) (Instance 1 of 2)
  volatile uint16_t SD_DBG_700;  ///< 0x13C [R/W]: Debug Register 7 (Low) (Instance 1 of 2)
  volatile uint16_t SD_DBG_710;  ///< 0x13E [R/W]: Debug Register 7 (High) (Instance 1 of 2)
  volatile uint16_t reserved3[92];
  volatile uint16_t INT_VER_000;  ///< 0x1F8 [R]: Internal Version Register 0 (Low) (Instance 1 of 2)
  volatile uint16_t INT_VER_010;  ///< 0x1FA [R]: Internal Version Register 0 (High) (Instance 1 of 2)
  volatile uint16_t INT_VER_100;  ///< 0x1FC [R]: Internal Version Register 1 (Low) (Instance 1 of 2)
  volatile uint16_t INT_VER_110;  ///< 0x1FE [R]: Internal Version Register 1 (High) (Instance 1 of 2)
  volatile uint16_t reserved4[768];
  volatile uint16_t SD_SYS_ADDR_LOW1;  ///< 0x1000 [R/W]: SDMA System Address / Argument 2 (Low) Register (Instance 2 of 2)
  volatile uint16_t SD_SYS_ADDR_HIGH1;  ///< 0x1002 [R/W]: System Address High Register (Instance 2 of 2)
  volatile uint16_t SD_BLOCK_SIZE1;  ///< 0x1004 [R/W]: Block Size Register (Instance 2 of 2)
  volatile uint16_t SD_BLOCK_COUNT1;  ///< 0x1006 [R/W]: Block Count Register (Instance 2 of 2)
  volatile uint16_t SD_ARG_LOW1;  ///< 0x1008 [R/W]: Argument Low Register (Instance 2 of 2)
  volatile uint16_t SD_ARG_HIGH1;  ///< 0x100A [R/W]: Argument High Register (Instance 2 of 2)
  volatile uint16_t SD_TRANSFER_MODE1;  ///< 0x100C [R/W]: Transfer Mode Register (Instance 2 of 2)
  volatile uint16_t SD_CMD1;  ///< 0x100E [R/W]: Command Register (Instance 2 of 2)
  volatile uint16_t SD_RESP_01;  ///< 0x1010 [R]: Response Register 0 (Instance 2 of 2)
  volatile uint16_t SD_RESP_11;  ///< 0x1012 [R]: Response Register 1 (Instance 2 of 2)
  volatile uint16_t SD_RESP_21;  ///< 0x1014 [R]: Response Register 2 (Instance 2 of 2)
  volatile uint16_t SD_RESP_31;  ///< 0x1016 [R]: Response Register 3 (Instance 2 of 2)
  volatile uint16_t SD_RESP_41;  ///< 0x1018 [R]: Response Register 4 (Instance 2 of 2)
  volatile uint16_t SD_RESP_51;  ///< 0x101A [R]: Response Register 5 (Instance 2 of 2)
  volatile uint16_t SD_RESP_61;  ///< 0x101C [R]: Response Register 6 (Instance 2 of 2)
  volatile uint16_t SD_RESP_71;  ///< 0x101E [R]: Response Register 7 (Instance 2 of 2)
  volatile uint16_t SD_BUFFER_DATA_PORT_01;  ///< 0x1020 [R/W]: Buffer Data Port 0 Register (Instance 2 of 2)
  volatile uint16_t SD_BUFFER_DATA_PORT_11;  ///< 0x1022 [R/W]: Buffer Data Port 1 Register (Instance 2 of 2)
  volatile uint16_t SD_PRESENT_STATE_01;  ///< 0x1024 [R/W]: Present State Register 0 (Instance 2 of 2)
  volatile uint16_t SD_PRESENT_STATE_11;  ///< 0x1026 [R]: Present State Register 1 (Instance 2 of 2)
  volatile uint16_t SD_HOST_CTRL1;  ///< 0x1028 [R/W]: Host Control Register (Instance 2 of 2)
  volatile uint16_t SD_BLOCK_GAP_CTRL1;  ///< 0x102A [R/W]: Block Gap Control Register (Instance 2 of 2)
  volatile uint16_t SD_CLOCK_CTRL1;  ///< 0x102C [R/W]: Clock Control Register (Instance 2 of 2)
  volatile uint16_t SD_TIMEOUT_CTRL_SW_RESET1;  ///< 0x102E [R/W]: Timeout Control/Software Reset Register (Instance 2 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS1;  ///< 0x1030 [R/W]: Normal Interrupt Status Register (Instance 2 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS1;  ///< 0x1032 [R/W]: Error Interrupt Status Register (Instance 2 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS_EN1;  ///< 0x1034 [R/W]: Normal Interrupt Status Enable Register (Instance 2 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS_EN1;  ///< 0x1036 [R/W]: Error Interrupt Status Enable Register (Instance 2 of 2)
  volatile uint16_t SD_NORMAL_INT_STATUS_INT_EN1;  ///< 0x1038 [R/W]: Normal Interrupt Signal Enable Register (Instance 2 of 2)
  volatile uint16_t SD_ERROR_INT_STATUS_INT_EN1;  ///< 0x103A [R/W]: Error Interrupt Signal Enable Register (Instance 2 of 2)
  volatile uint16_t SD_AUTO_CMD12_ERROR_STATUS1;  ///< 0x103C [R/W]: Auto CMD12 Error Status Register (Instance 2 of 2)
  volatile uint16_t SD_HOST_CTRL21;  ///< 0x103E [R/W]: Host Control Register 2 (Instance 2 of 2)
  volatile uint16_t SD_CAPABILITIES_01;  ///< 0x1040 [R]: Capabilities Register 0 (Instance 2 of 2)
  volatile uint16_t SD_CAPABILITIES_11;  ///< 0x1042 [R]: Capabilities Register 1 (Instance 2 of 2)
  volatile uint16_t SD_CAPABILITIES_21;  ///< 0x1044 [R]: Capabilities Register 2 (Instance 2 of 2)
  volatile uint16_t SD_CAPABILITIES_31;  ///< 0x1046 [R]: Capabilities Register 3 (Instance 2 of 2)
  volatile uint16_t SD_MAX_CURRENT_01;  ///< 0x1048 [R]: Maximum Current Register 0 (Instance 2 of 2)
  volatile uint16_t SD_MAX_CURRENT_11;  ///< 0x104A [R]: Maximum Current Register 1 (Instance 2 of 2)
  volatile uint16_t SD_MAX_CURRENT_21;  ///< 0x104C [R]: Maximum Current Register 2 (Instance 2 of 2)
  volatile uint16_t SD_MAX_CURRENT_31;  ///< 0x104E [R]: Maximum Current Register 3 (Instance 2 of 2)
  volatile uint16_t SD_FORCE_EVENT_AUTO_CMD12_ERROR1;  ///< 0x1050 [W]: Force Event Auto cmd12 Error Register (Instance 2 of 2)
  volatile uint16_t SD_FORCE_EVENT_FOR_ERROR_STATUS1;  ///< 0x1052 [W]: Force Event for Error Status Register (Instance 2 of 2)
  volatile uint16_t SD_ADMA_ERROR_STATUS1;  ///< 0x1054 [R/W]: ADMA Error Status Register (Instance 2 of 2)
  volatile uint16_t reserved5;
  volatile uint16_t SD_ADMA_SYS_ADDR_01;  ///< 0x1058 [R/W]: ADMA System Address Register 0 (Instance 2 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_11;  ///< 0x105A [R/W]: ADMA System Address Register 1 (Instance 2 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_21;  ///< 0x105C [R/W]: ADMA System Address Register 2 (Instance 2 of 2)
  volatile uint16_t SD_ADMA_SYS_ADDR_31;  ///< 0x105E [R/W]: ADMA System Address Register 3 (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_INIT1;  ///< 0x1060 [R]: Preset Value Regiser for Initialization (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_DS1;  ///< 0x1062 [R]: Preset Value Regiser for Default Speed (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_HS1;  ///< 0x1064 [R]: Preset Value Regiser for High Speed (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR121;  ///< 0x1066 [R]: Preset Value Regiser for SDR12 (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR251;  ///< 0x1068 [R]: Preset Value Regiser for SDR25 (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR501;  ///< 0x106A [R]: Preset Value Regiser for SDR50 (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_SDR1041;  ///< 0x106C [R]: Preset Value Regiser for SDR104 (Instance 2 of 2)
  volatile uint16_t SD_PRESET_VALUE_FOR_DDR501;  ///< 0x106E [R]: Preset Value Regiser for DDR50 (Instance 2 of 2)
  volatile uint16_t reserved6[56];
  volatile uint16_t SD_SHARED_BUS_CTRL_LOW1;  ///< 0x10E0 [R/W]: Shared Bus Control Register (Low) (Instance 2 of 2)
  volatile uint16_t SD_SHARED_BUS_CTRL_HIGH1;  ///< 0x10E2 [R/W]: Shared Bus Control Register (High) (Instance 2 of 2)
  volatile uint16_t reserved7[12];
  volatile uint16_t SD_SLOT_INT_STATUS1;  ///< 0x10FC [R]: Slot Interrupt Status Register (Instance 2 of 2)
  volatile uint16_t SD_HOST_CTRL_VER1;  ///< 0x10FE [R]: Host Control Version Register (Instance 2 of 2)
  volatile uint16_t SD_CFG_FIFO_PARAM_01;  ///< 0x1100 [R/W]: SD Extra parameters Register (Low) (Instance 2 of 2)
  volatile uint16_t SD_CFG_FIFO_PARAM_11;  ///< 0x1102 [R/W]: SD Extra parameters Register (High) (Instance 2 of 2)
  volatile uint16_t SD_FIFO_PARAM_01;  ///< 0x1104 [R/W]: FIFO Parameters Register (LOW) (Instance 2 of 2)
  volatile uint16_t SD_FIFO_PARAM_11;  ///< 0x1106 [R/W]: FIFO Parameters Register (High) (Instance 2 of 2)
  volatile uint16_t SD_SPI_MODE1;  ///< 0x1108 [R/W]: SPI Mode Register (Instance 2 of 2)
  volatile uint16_t SD_CLOCK_AND_BURST_SIZE_SETUP1;  ///< 0x110A [R/W]: Clock and Burst Size Setup Register (Instance 2 of 2)
  volatile uint16_t SD_CE_ATA_11;  ///< 0x110C [R/W]: CE-ATA Register 0 (Instance 2 of 2)
  volatile uint16_t SD_CE_ATA_21;  ///< 0x110E [R/W]: CE-ATA Register 1 (Instance 2 of 2)
  volatile uint16_t SD_PAD_IO_SETUP01;  ///< 0x1110 [R/W]: PAD I/O Setup Register lower (Instance 2 of 2)
  volatile uint16_t SD_PAD_IO_SETUP11;  ///< 0x1112 [R/W]: PAD I/O Setup Register upper (Instance 2 of 2)
  volatile uint16_t SD_RX_CFG_01;  ///< 0x1114 [R/W]: RX Configuration Register (Low) (Instance 2 of 2)
  volatile uint16_t SD_RX_CFG_11;  ///< 0x1116 [R/W]: RX Configuration Register (High) (Instance 2 of 2)
  volatile uint16_t SD_TX_CFG_01;  ///< 0x1118 [R/W]: TX Configuration Register (Low) (Instance 2 of 2)
  volatile uint16_t SD_TX_CFG_11;  ///< 0x111A [R/W]: TX Configuration Register (HIGH) (Instance 2 of 2)
  volatile uint16_t TUNING_CFG_REG_01;  ///< 0x111C [R/W]: Tuning Configuration Register (Low) (Instance 2 of 2)
  volatile uint16_t TUNING_CFG_REG_11;  ///< 0x111E [R/W]: Tuning Configuration Register (HIGH) (Instance 2 of 2)
  volatile uint16_t SD_DBG_001;  ///< 0x1120 [R/W]: Debug Register 0 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_011;  ///< 0x1122 [R/W]: Debug Register 0 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_101;  ///< 0x1124 [R/W]: Debug Register 1 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_111;  ///< 0x1126 [R/W]: Debug Register 1 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_201;  ///< 0x1128 [R/W]: Debug Register 2 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_211;  ///< 0x112A [R/W]: Debug Register 2 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_301;  ///< 0x112C [R/W]: Debug Register 3 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_311;  ///< 0x112E [R/W]: Debug Register 3 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_401;  ///< 0x1130 [R/W]: Debug Register 4 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_411;  ///< 0x1132 [R/W]: Debug Register 4 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_501;  ///< 0x1134 [R/W]: Debug Register 5 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_511;  ///< 0x1136 [R/W]: Debug Register 5 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_601;  ///< 0x1138 [R/W]: Debug Register 6 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_611;  ///< 0x113A [R/W]: Debug Register 6 (High) (Instance 2 of 2)
  volatile uint16_t SD_DBG_701;  ///< 0x113C [R/W]: Debug Register 7 (Low) (Instance 2 of 2)
  volatile uint16_t SD_DBG_711;  ///< 0x113E [R/W]: Debug Register 7 (High) (Instance 2 of 2)
  volatile uint16_t reserved8[92];
  volatile uint16_t INT_VER_001;  ///< 0x11F8 [R]: Internal Version Register 0 (Low) (Instance 2 of 2)
  volatile uint16_t INT_VER_011;  ///< 0x11FA [R]: Internal Version Register 0 (High) (Instance 2 of 2)
  volatile uint16_t INT_VER_101;  ///< 0x11FC [R]: Internal Version Register 1 (Low) (Instance 2 of 2)
  volatile uint16_t INT_VER_111;  ///< 0x11FE [R]: Internal Version Register 1 (High) (Instance 2 of 2)
} SDMMC3_2P_REGS_t;

#endif // SDMMC3_2P
