 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SCCPLITE_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SCCPLITE_REG_REGSTRUCTS_H_
#define _SCCPLITE_REG_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Serial Control Channel Processor Lite (SCCPLITE_reg)
/** \brief Top-level register file for SCCP Lite (Serial Control Channel Processor Lite) block (rev 0 . 7 . 7 . 0).*/
//
//====================================================================

typedef struct SCCPLITE_REG_REGS_s
{
  volatile uint32_t BPTR0;  ///< 0x0 [R/W]: Bit Pointer 0 Register
  volatile uint32_t BPTR1;  ///< 0x4 [R/W]: Bit Pointer 1 Register
  volatile uint32_t GEN0;  ///< 0x8 [R/W]: General Purpose Register 0
  volatile uint32_t GEN1;  ///< 0xc [R/W]: General Purpose Register 1
  volatile uint32_t GEN2;  ///< 0x10 [R/W]: General Purpose Register 2
  volatile uint32_t GEN3;  ///< 0x14 [R/W]: General Purpose Register 3
  volatile uint32_t GEN4;  ///< 0x18 [R/W]: General Purpose Register 4
  volatile uint32_t GEN5;  ///< 0x1c [R/W]: General Purpose Register 5
  volatile uint32_t STACK;  ///< 0x20 [R/W]: Stack Pointer
  volatile uint32_t MODE;  ///< 0x24 [R/W]: Mode Register
  volatile uint32_t GPIO_OE;  ///< 0x28 [R/W]: GPIO Output Enable Register
  volatile uint32_t GPIO_O;  ///< 0x2c [R/W]: GPIO Output Value Register
  volatile uint32_t GPIO_I;  ///< 0x30 [R]: GPIO Input Value Register
  volatile uint32_t TRIG;  ///< 0x34 [R/W]: External Triggers Register
  volatile uint32_t INT;  ///< 0x38 [R/W]: Interrupts Register
  volatile uint32_t PAR;  ///< 0x3c [R/W]: Parity Register
  volatile uint32_t TRIG_RD;  ///< 0x40 [R]: External Triggers Read Register
  volatile uint32_t EXT_ADDR_L;  ///< 0x44 [R/W]: External Address Lower
  volatile uint32_t EXT_ADDR_U;  ///< 0x48 [R/W]: External Address Upper
  volatile uint32_t EXT_DATA_L;  ///< 0x4c [R/W]: External Data Lower
  volatile uint32_t EXT_DATA_U;  ///< 0x50 [R/W]: External Data Upper
  volatile uint32_t EXT_ERR;  ///< 0x54 [R/W]: External Error Register
  volatile uint32_t reserved0[42];
  volatile uint32_t CPU_CTRL;  ///< 0x100 [R/W]: CPU Control Register
  volatile uint32_t IPTR;  ///< 0x104 [R/W]: Instruction Pointer Register
  volatile uint32_t CINST;  ///< 0x108 [R]: Current Instruction Register
  volatile uint32_t DEBUG_IADDR;  ///< 0x10c [R]: Debug Instruction Address
  volatile uint32_t TRIG_CFG0;  ///< 0x110 [R/W]: Trigger Configuration 0
  volatile uint32_t TRIG_CFG1;  ///< 0x114 [R/W]: Trigger Configuration 1
  volatile uint32_t REV0;  ///< 0x118 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x11c [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[952];
  volatile uint32_t SRAM[1024];  ///< 0x1000 [R/W]: Microcode SRAM
} SCCPLITE_REG_REGS_t;

#endif // SCCPLITE_REG
