 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SCCPLITE_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SCCPLITE_REG_REGMASKS_H_
#define _SCCPLITE_REG_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Serial Control Channel Processor Lite (SCCPLITE_reg)
/** \brief Top-level register file for SCCP Lite (Serial Control Channel Processor Lite) block (rev 0 . 7 . 7 . 0).*/
//
//====================================================================

//====================================================================
//Register: Bit Pointer 0 Register (BPTR0)
/** \brief Bit Pointer 0 is a 4 bit pointer that selects which bit of the selected register is accessed by the SDAT/RDAT instructions operating on Pin0. Bit Pointer 0 is post-incremented or post-decremented by the SDAT/RDAT instructions depending on the MSB field in MODE register.*/
//====================================================================

#define  SCCPLITE_REG_BPTR0_RESERVED1_MASK 0xfffffff0
#define  SCCPLITE_REG_BPTR0_RESERVED1_SHIFT 4
#define  SCCPLITE_REG_BPTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_BPTR0_RESERVED1_MASK) >> SCCPLITE_REG_BPTR0_RESERVED1_SHIFT)
#define  SCCPLITE_REG_BPTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_BPTR0_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_BPTR0_RESERVED1_SHIFT))

#define  SCCPLITE_REG_BPTR0_BITPTR_MASK 0xf
#define  SCCPLITE_REG_BPTR0_BITPTR_SHIFT 0
#define  SCCPLITE_REG_BPTR0_BITPTR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_BPTR0_BITPTR_MASK) >> SCCPLITE_REG_BPTR0_BITPTR_SHIFT)
#define  SCCPLITE_REG_BPTR0_BITPTR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_BPTR0_BITPTR_MASK) | (((uint32_t)val) << SCCPLITE_REG_BPTR0_BITPTR_SHIFT))

//====================================================================
//Register: Bit Pointer 1 Register (BPTR1)
/** \brief Bit Pointer 1 is a 4 bit pointer that selects which bit of the selected register is accessed by the SDAT/RDAT instructions operating on Pin1. Bit Pointer 1 is post-incremented or post-decremented by the SDAT/RDAT instructions depending on the MSB field in MODE register.*/
//====================================================================

#define  SCCPLITE_REG_BPTR1_RESERVED1_MASK 0xfffffff0
#define  SCCPLITE_REG_BPTR1_RESERVED1_SHIFT 4
#define  SCCPLITE_REG_BPTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_BPTR1_RESERVED1_MASK) >> SCCPLITE_REG_BPTR1_RESERVED1_SHIFT)
#define  SCCPLITE_REG_BPTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_BPTR1_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_BPTR1_RESERVED1_SHIFT))

#define  SCCPLITE_REG_BPTR1_BITPTR_MASK 0xf
#define  SCCPLITE_REG_BPTR1_BITPTR_SHIFT 0
#define  SCCPLITE_REG_BPTR1_BITPTR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_BPTR1_BITPTR_MASK) >> SCCPLITE_REG_BPTR1_BITPTR_SHIFT)
#define  SCCPLITE_REG_BPTR1_BITPTR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_BPTR1_BITPTR_MASK) | (((uint32_t)val) << SCCPLITE_REG_BPTR1_BITPTR_SHIFT))

//====================================================================
//Register: General Purpose Register 0 (GEN0)
/** \brief 16 bit general purpose data register*/
//====================================================================

#define  SCCPLITE_REG_GEN0_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_GEN0_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_GEN0_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN0_RESERVED1_MASK) >> SCCPLITE_REG_GEN0_RESERVED1_SHIFT)
#define  SCCPLITE_REG_GEN0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN0_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN0_RESERVED1_SHIFT))

#define  SCCPLITE_REG_GEN0_DATA_MASK 0xffff
#define  SCCPLITE_REG_GEN0_DATA_SHIFT 0
#define  SCCPLITE_REG_GEN0_DATA_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN0_DATA_MASK) >> SCCPLITE_REG_GEN0_DATA_SHIFT)
#define  SCCPLITE_REG_GEN0_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN0_DATA_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN0_DATA_SHIFT))

//====================================================================
//Register: General Purpose Register 1 (GEN1)
/** \brief 16 bit general purpose data register*/
//====================================================================

#define  SCCPLITE_REG_GEN1_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_GEN1_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_GEN1_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN1_RESERVED1_MASK) >> SCCPLITE_REG_GEN1_RESERVED1_SHIFT)
#define  SCCPLITE_REG_GEN1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN1_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN1_RESERVED1_SHIFT))

#define  SCCPLITE_REG_GEN1_DATA_MASK 0xffff
#define  SCCPLITE_REG_GEN1_DATA_SHIFT 0
#define  SCCPLITE_REG_GEN1_DATA_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN1_DATA_MASK) >> SCCPLITE_REG_GEN1_DATA_SHIFT)
#define  SCCPLITE_REG_GEN1_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN1_DATA_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN1_DATA_SHIFT))

//====================================================================
//Register: General Purpose Register 2 (GEN2)
/** \brief 16 bit general purpose data register*/
//====================================================================

#define  SCCPLITE_REG_GEN2_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_GEN2_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_GEN2_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN2_RESERVED1_MASK) >> SCCPLITE_REG_GEN2_RESERVED1_SHIFT)
#define  SCCPLITE_REG_GEN2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN2_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN2_RESERVED1_SHIFT))

#define  SCCPLITE_REG_GEN2_DATA_MASK 0xffff
#define  SCCPLITE_REG_GEN2_DATA_SHIFT 0
#define  SCCPLITE_REG_GEN2_DATA_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN2_DATA_MASK) >> SCCPLITE_REG_GEN2_DATA_SHIFT)
#define  SCCPLITE_REG_GEN2_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN2_DATA_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN2_DATA_SHIFT))

//====================================================================
//Register: General Purpose Register 3 (GEN3)
/** \brief 16 bit general purpose data register*/
//====================================================================

#define  SCCPLITE_REG_GEN3_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_GEN3_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_GEN3_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN3_RESERVED1_MASK) >> SCCPLITE_REG_GEN3_RESERVED1_SHIFT)
#define  SCCPLITE_REG_GEN3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN3_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN3_RESERVED1_SHIFT))

#define  SCCPLITE_REG_GEN3_DATA_MASK 0xffff
#define  SCCPLITE_REG_GEN3_DATA_SHIFT 0
#define  SCCPLITE_REG_GEN3_DATA_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN3_DATA_MASK) >> SCCPLITE_REG_GEN3_DATA_SHIFT)
#define  SCCPLITE_REG_GEN3_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN3_DATA_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN3_DATA_SHIFT))

//====================================================================
//Register: General Purpose Register 4 (GEN4)
/** \brief 16 bit general purpose data register*/
//====================================================================

#define  SCCPLITE_REG_GEN4_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_GEN4_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_GEN4_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN4_RESERVED1_MASK) >> SCCPLITE_REG_GEN4_RESERVED1_SHIFT)
#define  SCCPLITE_REG_GEN4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN4_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN4_RESERVED1_SHIFT))

#define  SCCPLITE_REG_GEN4_DATA_MASK 0xffff
#define  SCCPLITE_REG_GEN4_DATA_SHIFT 0
#define  SCCPLITE_REG_GEN4_DATA_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN4_DATA_MASK) >> SCCPLITE_REG_GEN4_DATA_SHIFT)
#define  SCCPLITE_REG_GEN4_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN4_DATA_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN4_DATA_SHIFT))

//====================================================================
//Register: General Purpose Register 5 (GEN5)
/** \brief 16 bit general purpose data register*/
//====================================================================

#define  SCCPLITE_REG_GEN5_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_GEN5_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_GEN5_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN5_RESERVED1_MASK) >> SCCPLITE_REG_GEN5_RESERVED1_SHIFT)
#define  SCCPLITE_REG_GEN5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN5_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN5_RESERVED1_SHIFT))

#define  SCCPLITE_REG_GEN5_DATA_MASK 0xffff
#define  SCCPLITE_REG_GEN5_DATA_SHIFT 0
#define  SCCPLITE_REG_GEN5_DATA_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GEN5_DATA_MASK) >> SCCPLITE_REG_GEN5_DATA_SHIFT)
#define  SCCPLITE_REG_GEN5_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GEN5_DATA_MASK) | (((uint32_t)val) << SCCPLITE_REG_GEN5_DATA_SHIFT))

//====================================================================
//Register: Stack Pointer (STACK)
/** \brief Stack Pointer is a 10 bit word offset into the SCCP Lite SRAM space which points to the current location in the stack. The stack pointer is incremented/decremented by 1 in the SCCP Lite whenever a stack related operation occurs (push, pop, jsr, return). The stack grows upward, so jsr and push will increment the Stack Pointer while return and pop will decrement the Stack Pointer.*/
//====================================================================

#define  SCCPLITE_REG_STACK_RESERVED1_MASK 0xfffffc00
#define  SCCPLITE_REG_STACK_RESERVED1_SHIFT 10
#define  SCCPLITE_REG_STACK_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_STACK_RESERVED1_MASK) >> SCCPLITE_REG_STACK_RESERVED1_SHIFT)
#define  SCCPLITE_REG_STACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_STACK_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_STACK_RESERVED1_SHIFT))

#define  SCCPLITE_REG_STACK_STACKPTR_MASK 0x3ff
#define  SCCPLITE_REG_STACK_STACKPTR_SHIFT 0
#define  SCCPLITE_REG_STACK_STACKPTR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_STACK_STACKPTR_MASK) >> SCCPLITE_REG_STACK_STACKPTR_SHIFT)
#define  SCCPLITE_REG_STACK_STACKPTR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_STACK_STACKPTR_MASK) | (((uint32_t)val) << SCCPLITE_REG_STACK_STACKPTR_SHIFT))

//====================================================================
//Register: Mode Register (MODE)
/** \brief The Mode Register is used to control and configure the overall operation of SCCP Lite.*/
//====================================================================

#define  SCCPLITE_REG_MODE_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_MODE_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_RESERVED1_MASK) >> SCCPLITE_REG_MODE_RESERVED1_SHIFT)
#define  SCCPLITE_REG_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_RESERVED1_SHIFT))

#define  SCCPLITE_REG_MODE_STACKERR_MASK 0x8000
#define  SCCPLITE_REG_MODE_STACKERR_SHIFT 15
#define  SCCPLITE_REG_MODE_STACKERR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_STACKERR_MASK) >> SCCPLITE_REG_MODE_STACKERR_SHIFT)
#define  SCCPLITE_REG_MODE_STACKERR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_STACKERR_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_STACKERR_SHIFT))

#define  SCCPLITE_REG_MODE_RESERVED2_MASK 0x7000
#define  SCCPLITE_REG_MODE_RESERVED2_SHIFT 12
#define  SCCPLITE_REG_MODE_RESERVED2_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_RESERVED2_MASK) >> SCCPLITE_REG_MODE_RESERVED2_SHIFT)
#define  SCCPLITE_REG_MODE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_RESERVED2_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_RESERVED2_SHIFT))

#define  SCCPLITE_REG_MODE_EXTERRINT_MASK 0x800
#define  SCCPLITE_REG_MODE_EXTERRINT_SHIFT 11
#define  SCCPLITE_REG_MODE_EXTERRINT_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_EXTERRINT_MASK) >> SCCPLITE_REG_MODE_EXTERRINT_SHIFT)
#define  SCCPLITE_REG_MODE_EXTERRINT_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_EXTERRINT_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_EXTERRINT_SHIFT))

#define  SCCPLITE_REG_MODE_CLKTERM_MASK 0x400
#define  SCCPLITE_REG_MODE_CLKTERM_SHIFT 10
#define  SCCPLITE_REG_MODE_CLKTERM_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_CLKTERM_MASK) >> SCCPLITE_REG_MODE_CLKTERM_SHIFT)
#define  SCCPLITE_REG_MODE_CLKTERM_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_CLKTERM_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_CLKTERM_SHIFT))

#define  SCCPLITE_REG_MODE_OE_SENSE_MASK 0x200
#define  SCCPLITE_REG_MODE_OE_SENSE_SHIFT 9
#define  SCCPLITE_REG_MODE_OE_SENSE_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_OE_SENSE_MASK) >> SCCPLITE_REG_MODE_OE_SENSE_SHIFT)
#define  SCCPLITE_REG_MODE_OE_SENSE_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_OE_SENSE_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_OE_SENSE_SHIFT))

#define  SCCPLITE_REG_MODE_OE_OVERRIDE_MASK 0x100
#define  SCCPLITE_REG_MODE_OE_OVERRIDE_SHIFT 8
#define  SCCPLITE_REG_MODE_OE_OVERRIDE_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_OE_OVERRIDE_MASK) >> SCCPLITE_REG_MODE_OE_OVERRIDE_SHIFT)
#define  SCCPLITE_REG_MODE_OE_OVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_OE_OVERRIDE_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_OE_OVERRIDE_SHIFT))

#define  SCCPLITE_REG_MODE_RESERVED3_MASK 0x80
#define  SCCPLITE_REG_MODE_RESERVED3_SHIFT 7
#define  SCCPLITE_REG_MODE_RESERVED3_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_RESERVED3_MASK) >> SCCPLITE_REG_MODE_RESERVED3_SHIFT)
#define  SCCPLITE_REG_MODE_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_RESERVED3_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_RESERVED3_SHIFT))

#define  SCCPLITE_REG_MODE_TRIGBANK_MASK 0x40
#define  SCCPLITE_REG_MODE_TRIGBANK_SHIFT 6
#define  SCCPLITE_REG_MODE_TRIGBANK_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_TRIGBANK_MASK) >> SCCPLITE_REG_MODE_TRIGBANK_SHIFT)
#define  SCCPLITE_REG_MODE_TRIGBANK_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_TRIGBANK_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_TRIGBANK_SHIFT))

#define  SCCPLITE_REG_MODE_RESERVED4_MASK 0x20
#define  SCCPLITE_REG_MODE_RESERVED4_SHIFT 5
#define  SCCPLITE_REG_MODE_RESERVED4_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_RESERVED4_MASK) >> SCCPLITE_REG_MODE_RESERVED4_SHIFT)
#define  SCCPLITE_REG_MODE_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_RESERVED4_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_RESERVED4_SHIFT))

#define  SCCPLITE_REG_MODE_GPIOBANK_MASK 0x10
#define  SCCPLITE_REG_MODE_GPIOBANK_SHIFT 4
#define  SCCPLITE_REG_MODE_GPIOBANK_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_GPIOBANK_MASK) >> SCCPLITE_REG_MODE_GPIOBANK_SHIFT)
#define  SCCPLITE_REG_MODE_GPIOBANK_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_GPIOBANK_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_GPIOBANK_SHIFT))

#define  SCCPLITE_REG_MODE_DATA1MSB_MASK 0x8
#define  SCCPLITE_REG_MODE_DATA1MSB_SHIFT 3
#define  SCCPLITE_REG_MODE_DATA1MSB_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_DATA1MSB_MASK) >> SCCPLITE_REG_MODE_DATA1MSB_SHIFT)
#define  SCCPLITE_REG_MODE_DATA1MSB_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_DATA1MSB_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_DATA1MSB_SHIFT))

#define  SCCPLITE_REG_MODE_DATA0MSB_MASK 0x4
#define  SCCPLITE_REG_MODE_DATA0MSB_SHIFT 2
#define  SCCPLITE_REG_MODE_DATA0MSB_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_DATA0MSB_MASK) >> SCCPLITE_REG_MODE_DATA0MSB_SHIFT)
#define  SCCPLITE_REG_MODE_DATA0MSB_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_DATA0MSB_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_DATA0MSB_SHIFT))

#define  SCCPLITE_REG_MODE_DMATOMEM_MASK 0x2
#define  SCCPLITE_REG_MODE_DMATOMEM_SHIFT 1
#define  SCCPLITE_REG_MODE_DMATOMEM_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_DMATOMEM_MASK) >> SCCPLITE_REG_MODE_DMATOMEM_SHIFT)
#define  SCCPLITE_REG_MODE_DMATOMEM_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_DMATOMEM_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_DMATOMEM_SHIFT))

#define  SCCPLITE_REG_MODE_DMAFROMMEM_MASK 0x1
#define  SCCPLITE_REG_MODE_DMAFROMMEM_SHIFT 0
#define  SCCPLITE_REG_MODE_DMAFROMMEM_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_MODE_DMAFROMMEM_MASK) >> SCCPLITE_REG_MODE_DMAFROMMEM_SHIFT)
#define  SCCPLITE_REG_MODE_DMAFROMMEM_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_MODE_DMAFROMMEM_MASK) | (((uint32_t)val) << SCCPLITE_REG_MODE_DMAFROMMEM_SHIFT))

//====================================================================
//Register: GPIO Output Enable Register (GPIO_OE)
/** \brief GPIO Output Enable is a 16 bit register to hold output enables for up to 16 GPIO pins. GPIO Output Enable can be modified directly or as a side effect of the SGPIO instruction.*/
//====================================================================

#define  SCCPLITE_REG_GPIO_OE_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_GPIO_OE_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_GPIO_OE_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GPIO_OE_RESERVED1_MASK) >> SCCPLITE_REG_GPIO_OE_RESERVED1_SHIFT)
#define  SCCPLITE_REG_GPIO_OE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GPIO_OE_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_GPIO_OE_RESERVED1_SHIFT))

#define  SCCPLITE_REG_GPIO_OE_GPIOOE_MASK 0xffff
#define  SCCPLITE_REG_GPIO_OE_GPIOOE_SHIFT 0
#define  SCCPLITE_REG_GPIO_OE_GPIOOE_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GPIO_OE_GPIOOE_MASK) >> SCCPLITE_REG_GPIO_OE_GPIOOE_SHIFT)
#define  SCCPLITE_REG_GPIO_OE_GPIOOE_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GPIO_OE_GPIOOE_MASK) | (((uint32_t)val) << SCCPLITE_REG_GPIO_OE_GPIOOE_SHIFT))

//====================================================================
//Register: GPIO Output Value Register (GPIO_O)
/** \brief GPIO Output Value is a 16 bit register to hold output value for up to 16 GPIO pins. GPIO Output Value can be modified directly or as a side effect of the SGPIO instruction.*/
//====================================================================

#define  SCCPLITE_REG_GPIO_O_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_GPIO_O_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_GPIO_O_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GPIO_O_RESERVED1_MASK) >> SCCPLITE_REG_GPIO_O_RESERVED1_SHIFT)
#define  SCCPLITE_REG_GPIO_O_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GPIO_O_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_GPIO_O_RESERVED1_SHIFT))

#define  SCCPLITE_REG_GPIO_O_GPIOOUT_MASK 0xffff
#define  SCCPLITE_REG_GPIO_O_GPIOOUT_SHIFT 0
#define  SCCPLITE_REG_GPIO_O_GPIOOUT_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GPIO_O_GPIOOUT_MASK) >> SCCPLITE_REG_GPIO_O_GPIOOUT_SHIFT)
#define  SCCPLITE_REG_GPIO_O_GPIOOUT_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GPIO_O_GPIOOUT_MASK) | (((uint32_t)val) << SCCPLITE_REG_GPIO_O_GPIOOUT_SHIFT))

//====================================================================
//Register: GPIO Input Value Register (GPIO_I)
/** \brief GPIO Input Value is a READ-ONLY 16 bit register that reflects input values for up to 16 GPIO pins.*/
//====================================================================

#define  SCCPLITE_REG_GPIO_I_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_GPIO_I_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_GPIO_I_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GPIO_I_RESERVED1_MASK) >> SCCPLITE_REG_GPIO_I_RESERVED1_SHIFT)
#define  SCCPLITE_REG_GPIO_I_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GPIO_I_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_GPIO_I_RESERVED1_SHIFT))

#define  SCCPLITE_REG_GPIO_I_GPIOIN_MASK 0xffff
#define  SCCPLITE_REG_GPIO_I_GPIOIN_SHIFT 0
#define  SCCPLITE_REG_GPIO_I_GPIOIN_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_GPIO_I_GPIOIN_MASK) >> SCCPLITE_REG_GPIO_I_GPIOIN_SHIFT)
#define  SCCPLITE_REG_GPIO_I_GPIOIN_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_GPIO_I_GPIOIN_MASK) | (((uint32_t)val) << SCCPLITE_REG_GPIO_I_GPIOIN_SHIFT))

//====================================================================
//Register: External Triggers Register (TRIG)
/** \brief External Triggers is a 16 bit register that can be set by external events and cleared by SCCP Lite code or the main CPU. External Triggers can be modified directly or as a side effect if the CLT instruction.*/
//====================================================================

#define  SCCPLITE_REG_TRIG_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_TRIG_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_TRIG_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_TRIG_RESERVED1_MASK) >> SCCPLITE_REG_TRIG_RESERVED1_SHIFT)
#define  SCCPLITE_REG_TRIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_TRIG_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_TRIG_RESERVED1_SHIFT))

#define  SCCPLITE_REG_TRIG_TRIG_MASK 0xffff
#define  SCCPLITE_REG_TRIG_TRIG_SHIFT 0
#define  SCCPLITE_REG_TRIG_TRIG_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_TRIG_TRIG_MASK) >> SCCPLITE_REG_TRIG_TRIG_SHIFT)
#define  SCCPLITE_REG_TRIG_TRIG_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_TRIG_TRIG_MASK) | (((uint32_t)val) << SCCPLITE_REG_TRIG_TRIG_SHIFT))

//====================================================================
//Register: Interrupts Register (INT)
/** \brief Interrupts is a 16 bit register that can be set/cleared by SCCP Lite code or by the main CPU. Interrupts can be modified directly or as a side effect if the SINT instruction.*/
//====================================================================

#define  SCCPLITE_REG_INT_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_INT_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_INT_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_INT_RESERVED1_MASK) >> SCCPLITE_REG_INT_RESERVED1_SHIFT)
#define  SCCPLITE_REG_INT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_INT_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_INT_RESERVED1_SHIFT))

#define  SCCPLITE_REG_INT_INT_MASK 0xffff
#define  SCCPLITE_REG_INT_INT_SHIFT 0
#define  SCCPLITE_REG_INT_INT_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_INT_INT_MASK) >> SCCPLITE_REG_INT_INT_SHIFT)
#define  SCCPLITE_REG_INT_INT_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_INT_INT_MASK) | (((uint32_t)val) << SCCPLITE_REG_INT_INT_SHIFT))

//====================================================================
//Register: Parity Register (PAR)
/** \brief Parity contains the odd and even parity bits calculated by SDAT/RDAT instructions.*/
//====================================================================

#define  SCCPLITE_REG_PAR_RESERVED1_MASK 0xffffffc0
#define  SCCPLITE_REG_PAR_RESERVED1_SHIFT 6
#define  SCCPLITE_REG_PAR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_PAR_RESERVED1_MASK) >> SCCPLITE_REG_PAR_RESERVED1_SHIFT)
#define  SCCPLITE_REG_PAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_PAR_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_PAR_RESERVED1_SHIFT))

#define  SCCPLITE_REG_PAR_ODDPAR1_MASK 0x20
#define  SCCPLITE_REG_PAR_ODDPAR1_SHIFT 5
#define  SCCPLITE_REG_PAR_ODDPAR1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_PAR_ODDPAR1_MASK) >> SCCPLITE_REG_PAR_ODDPAR1_SHIFT)
#define  SCCPLITE_REG_PAR_ODDPAR1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_PAR_ODDPAR1_MASK) | (((uint32_t)val) << SCCPLITE_REG_PAR_ODDPAR1_SHIFT))

#define  SCCPLITE_REG_PAR_EVENPAR1_MASK 0x10
#define  SCCPLITE_REG_PAR_EVENPAR1_SHIFT 4
#define  SCCPLITE_REG_PAR_EVENPAR1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_PAR_EVENPAR1_MASK) >> SCCPLITE_REG_PAR_EVENPAR1_SHIFT)
#define  SCCPLITE_REG_PAR_EVENPAR1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_PAR_EVENPAR1_MASK) | (((uint32_t)val) << SCCPLITE_REG_PAR_EVENPAR1_SHIFT))

#define  SCCPLITE_REG_PAR_RESERVED2_MASK 0xc
#define  SCCPLITE_REG_PAR_RESERVED2_SHIFT 2
#define  SCCPLITE_REG_PAR_RESERVED2_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_PAR_RESERVED2_MASK) >> SCCPLITE_REG_PAR_RESERVED2_SHIFT)
#define  SCCPLITE_REG_PAR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_PAR_RESERVED2_MASK) | (((uint32_t)val) << SCCPLITE_REG_PAR_RESERVED2_SHIFT))

#define  SCCPLITE_REG_PAR_ODDPAR0_MASK 0x2
#define  SCCPLITE_REG_PAR_ODDPAR0_SHIFT 1
#define  SCCPLITE_REG_PAR_ODDPAR0_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_PAR_ODDPAR0_MASK) >> SCCPLITE_REG_PAR_ODDPAR0_SHIFT)
#define  SCCPLITE_REG_PAR_ODDPAR0_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_PAR_ODDPAR0_MASK) | (((uint32_t)val) << SCCPLITE_REG_PAR_ODDPAR0_SHIFT))

#define  SCCPLITE_REG_PAR_EVENPAR0_MASK 0x1
#define  SCCPLITE_REG_PAR_EVENPAR0_SHIFT 0
#define  SCCPLITE_REG_PAR_EVENPAR0_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_PAR_EVENPAR0_MASK) >> SCCPLITE_REG_PAR_EVENPAR0_SHIFT)
#define  SCCPLITE_REG_PAR_EVENPAR0_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_PAR_EVENPAR0_MASK) | (((uint32_t)val) << SCCPLITE_REG_PAR_EVENPAR0_SHIFT))

//====================================================================
//Register: External Triggers Read Register (TRIG_RD)
/** \brief Provides the raw value of the trigger inputs connected to the SCCP triggers. Read only register.*/
//====================================================================

#define  SCCPLITE_REG_TRIG_RD_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_TRIG_RD_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_TRIG_RD_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_TRIG_RD_RESERVED1_MASK) >> SCCPLITE_REG_TRIG_RD_RESERVED1_SHIFT)
#define  SCCPLITE_REG_TRIG_RD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_TRIG_RD_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_TRIG_RD_RESERVED1_SHIFT))

#define  SCCPLITE_REG_TRIG_RD_TRIG_MASK 0xffff
#define  SCCPLITE_REG_TRIG_RD_TRIG_SHIFT 0
#define  SCCPLITE_REG_TRIG_RD_TRIG_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_TRIG_RD_TRIG_MASK) >> SCCPLITE_REG_TRIG_RD_TRIG_SHIFT)
#define  SCCPLITE_REG_TRIG_RD_TRIG_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_TRIG_RD_TRIG_MASK) | (((uint32_t)val) << SCCPLITE_REG_TRIG_RD_TRIG_SHIFT))

//====================================================================
//Register: External Address Lower (EXT_ADDR_L)
/** \brief SCCPLITE can read/write external addresses via its AXI initiator. The EXT_ADDR_L register allows the lower 16 bits of external address to be specified for reading or writing.*/
//====================================================================

#define  SCCPLITE_REG_EXT_ADDR_L_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_EXT_ADDR_L_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_EXT_ADDR_L_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ADDR_L_RESERVED1_MASK) >> SCCPLITE_REG_EXT_ADDR_L_RESERVED1_SHIFT)
#define  SCCPLITE_REG_EXT_ADDR_L_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ADDR_L_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ADDR_L_RESERVED1_SHIFT))

#define  SCCPLITE_REG_EXT_ADDR_L_ADDR_MASK 0xffff
#define  SCCPLITE_REG_EXT_ADDR_L_ADDR_SHIFT 0
#define  SCCPLITE_REG_EXT_ADDR_L_ADDR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ADDR_L_ADDR_MASK) >> SCCPLITE_REG_EXT_ADDR_L_ADDR_SHIFT)
#define  SCCPLITE_REG_EXT_ADDR_L_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ADDR_L_ADDR_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ADDR_L_ADDR_SHIFT))

//====================================================================
//Register: External Address Upper (EXT_ADDR_U)
/** \brief SCCPLITE can read/write external addresses via its AXI initiator. The EXT_ADDR_U register allows the upper 16 bits of external address to be specified for reading or writing.*/
//====================================================================

#define  SCCPLITE_REG_EXT_ADDR_U_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_EXT_ADDR_U_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_EXT_ADDR_U_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ADDR_U_RESERVED1_MASK) >> SCCPLITE_REG_EXT_ADDR_U_RESERVED1_SHIFT)
#define  SCCPLITE_REG_EXT_ADDR_U_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ADDR_U_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ADDR_U_RESERVED1_SHIFT))

#define  SCCPLITE_REG_EXT_ADDR_U_ADDR_MASK 0xffff
#define  SCCPLITE_REG_EXT_ADDR_U_ADDR_SHIFT 0
#define  SCCPLITE_REG_EXT_ADDR_U_ADDR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ADDR_U_ADDR_MASK) >> SCCPLITE_REG_EXT_ADDR_U_ADDR_SHIFT)
#define  SCCPLITE_REG_EXT_ADDR_U_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ADDR_U_ADDR_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ADDR_U_ADDR_SHIFT))

//====================================================================
//Register: External Data Lower (EXT_DATA_L)
/** \brief SCCPLITE can read/write external addresses via its AXI initiator. In the case of an external write, the EXT_DATA_L register allows the lower 16 bits of external write data to be specified prior to initiating the write. In the case of an external read, the EXT_DATA_L register allows the lower 16 bits of external read data to be accessed following the completion of the read.*/
//====================================================================

#define  SCCPLITE_REG_EXT_DATA_L_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_EXT_DATA_L_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_EXT_DATA_L_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_DATA_L_RESERVED1_MASK) >> SCCPLITE_REG_EXT_DATA_L_RESERVED1_SHIFT)
#define  SCCPLITE_REG_EXT_DATA_L_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_DATA_L_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_DATA_L_RESERVED1_SHIFT))

#define  SCCPLITE_REG_EXT_DATA_L_DATA_MASK 0xffff
#define  SCCPLITE_REG_EXT_DATA_L_DATA_SHIFT 0
#define  SCCPLITE_REG_EXT_DATA_L_DATA_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_DATA_L_DATA_MASK) >> SCCPLITE_REG_EXT_DATA_L_DATA_SHIFT)
#define  SCCPLITE_REG_EXT_DATA_L_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_DATA_L_DATA_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_DATA_L_DATA_SHIFT))

//====================================================================
//Register: External Data Upper (EXT_DATA_U)
/** \brief SCCPLITE can read/write external addresses via its AXI initiator. In the case of an external write, the EXT_DATA_U register allows the upper 16 bits of external write data to be specified prior to initiating the write. In the case of an external read, the EXT_DATA_U register allows the upper 16 bits of external read data to be accessed following the completion of the read.*/
//====================================================================

#define  SCCPLITE_REG_EXT_DATA_U_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_EXT_DATA_U_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_EXT_DATA_U_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_DATA_U_RESERVED1_MASK) >> SCCPLITE_REG_EXT_DATA_U_RESERVED1_SHIFT)
#define  SCCPLITE_REG_EXT_DATA_U_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_DATA_U_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_DATA_U_RESERVED1_SHIFT))

#define  SCCPLITE_REG_EXT_DATA_U_DATA_MASK 0xffff
#define  SCCPLITE_REG_EXT_DATA_U_DATA_SHIFT 0
#define  SCCPLITE_REG_EXT_DATA_U_DATA_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_DATA_U_DATA_MASK) >> SCCPLITE_REG_EXT_DATA_U_DATA_SHIFT)
#define  SCCPLITE_REG_EXT_DATA_U_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_DATA_U_DATA_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_DATA_U_DATA_SHIFT))

//====================================================================
//Register: External Error Register (EXT_ERR)
/** \brief SCCPLITE can read/write external addresses via its AXI initiator. If the read or write operation is invalid, the AXI bus will return an error response. This register captures any AXI errors. In addition, if the mode bit ExtErrInt is set an interrupt will be generated on the occurance of an error.*/
//====================================================================

#define  SCCPLITE_REG_EXT_ERR_RESERVED1_MASK 0xffffffc0
#define  SCCPLITE_REG_EXT_ERR_RESERVED1_SHIFT 6
#define  SCCPLITE_REG_EXT_ERR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ERR_RESERVED1_MASK) >> SCCPLITE_REG_EXT_ERR_RESERVED1_SHIFT)
#define  SCCPLITE_REG_EXT_ERR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ERR_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ERR_RESERVED1_SHIFT))

#define  SCCPLITE_REG_EXT_ERR_WRALIGNERR_MASK 0x20
#define  SCCPLITE_REG_EXT_ERR_WRALIGNERR_SHIFT 5
#define  SCCPLITE_REG_EXT_ERR_WRALIGNERR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ERR_WRALIGNERR_MASK) >> SCCPLITE_REG_EXT_ERR_WRALIGNERR_SHIFT)
#define  SCCPLITE_REG_EXT_ERR_WRALIGNERR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ERR_WRALIGNERR_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ERR_WRALIGNERR_SHIFT))

#define  SCCPLITE_REG_EXT_ERR_RDALIGNERR_MASK 0x10
#define  SCCPLITE_REG_EXT_ERR_RDALIGNERR_SHIFT 4
#define  SCCPLITE_REG_EXT_ERR_RDALIGNERR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ERR_RDALIGNERR_MASK) >> SCCPLITE_REG_EXT_ERR_RDALIGNERR_SHIFT)
#define  SCCPLITE_REG_EXT_ERR_RDALIGNERR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ERR_RDALIGNERR_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ERR_RDALIGNERR_SHIFT))

#define  SCCPLITE_REG_EXT_ERR_WRDECERR_MASK 0x8
#define  SCCPLITE_REG_EXT_ERR_WRDECERR_SHIFT 3
#define  SCCPLITE_REG_EXT_ERR_WRDECERR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ERR_WRDECERR_MASK) >> SCCPLITE_REG_EXT_ERR_WRDECERR_SHIFT)
#define  SCCPLITE_REG_EXT_ERR_WRDECERR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ERR_WRDECERR_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ERR_WRDECERR_SHIFT))

#define  SCCPLITE_REG_EXT_ERR_RDDECERR_MASK 0x4
#define  SCCPLITE_REG_EXT_ERR_RDDECERR_SHIFT 2
#define  SCCPLITE_REG_EXT_ERR_RDDECERR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ERR_RDDECERR_MASK) >> SCCPLITE_REG_EXT_ERR_RDDECERR_SHIFT)
#define  SCCPLITE_REG_EXT_ERR_RDDECERR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ERR_RDDECERR_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ERR_RDDECERR_SHIFT))

#define  SCCPLITE_REG_EXT_ERR_WRSLVERR_MASK 0x2
#define  SCCPLITE_REG_EXT_ERR_WRSLVERR_SHIFT 1
#define  SCCPLITE_REG_EXT_ERR_WRSLVERR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ERR_WRSLVERR_MASK) >> SCCPLITE_REG_EXT_ERR_WRSLVERR_SHIFT)
#define  SCCPLITE_REG_EXT_ERR_WRSLVERR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ERR_WRSLVERR_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ERR_WRSLVERR_SHIFT))

#define  SCCPLITE_REG_EXT_ERR_RDSLVERR_MASK 0x1
#define  SCCPLITE_REG_EXT_ERR_RDSLVERR_SHIFT 0
#define  SCCPLITE_REG_EXT_ERR_RDSLVERR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_EXT_ERR_RDSLVERR_MASK) >> SCCPLITE_REG_EXT_ERR_RDSLVERR_SHIFT)
#define  SCCPLITE_REG_EXT_ERR_RDSLVERR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_EXT_ERR_RDSLVERR_MASK) | (((uint32_t)val) << SCCPLITE_REG_EXT_ERR_RDSLVERR_SHIFT))

//====================================================================
//Register: CPU Control Register (CPU_CTRL)
/** \brief This register is only accessible by the main CPU, and is used to control the uCtrl.*/
//====================================================================

#define  SCCPLITE_REG_CPU_CTRL_SOFTRESET_MASK 0x80000000
#define  SCCPLITE_REG_CPU_CTRL_SOFTRESET_SHIFT 31
#define  SCCPLITE_REG_CPU_CTRL_SOFTRESET_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_CPU_CTRL_SOFTRESET_MASK) >> SCCPLITE_REG_CPU_CTRL_SOFTRESET_SHIFT)
#define  SCCPLITE_REG_CPU_CTRL_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_CPU_CTRL_SOFTRESET_MASK) | (((uint32_t)val) << SCCPLITE_REG_CPU_CTRL_SOFTRESET_SHIFT))

#define  SCCPLITE_REG_CPU_CTRL_RESERVED1_MASK 0x7fffff00
#define  SCCPLITE_REG_CPU_CTRL_RESERVED1_SHIFT 8
#define  SCCPLITE_REG_CPU_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_CPU_CTRL_RESERVED1_MASK) >> SCCPLITE_REG_CPU_CTRL_RESERVED1_SHIFT)
#define  SCCPLITE_REG_CPU_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_CPU_CTRL_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_CPU_CTRL_RESERVED1_SHIFT))

#define  SCCPLITE_REG_CPU_CTRL_SYNCBYPASSGPIO_MASK 0x80
#define  SCCPLITE_REG_CPU_CTRL_SYNCBYPASSGPIO_SHIFT 7
#define  SCCPLITE_REG_CPU_CTRL_SYNCBYPASSGPIO_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_CPU_CTRL_SYNCBYPASSGPIO_MASK) >> SCCPLITE_REG_CPU_CTRL_SYNCBYPASSGPIO_SHIFT)
#define  SCCPLITE_REG_CPU_CTRL_SYNCBYPASSGPIO_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_CPU_CTRL_SYNCBYPASSGPIO_MASK) | (((uint32_t)val) << SCCPLITE_REG_CPU_CTRL_SYNCBYPASSGPIO_SHIFT))

#define  SCCPLITE_REG_CPU_CTRL_SYNCBYPASSTRIG_MASK 0x40
#define  SCCPLITE_REG_CPU_CTRL_SYNCBYPASSTRIG_SHIFT 6
#define  SCCPLITE_REG_CPU_CTRL_SYNCBYPASSTRIG_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_CPU_CTRL_SYNCBYPASSTRIG_MASK) >> SCCPLITE_REG_CPU_CTRL_SYNCBYPASSTRIG_SHIFT)
#define  SCCPLITE_REG_CPU_CTRL_SYNCBYPASSTRIG_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_CPU_CTRL_SYNCBYPASSTRIG_MASK) | (((uint32_t)val) << SCCPLITE_REG_CPU_CTRL_SYNCBYPASSTRIG_SHIFT))

#define  SCCPLITE_REG_CPU_CTRL_RESERVED2_MASK 0x38
#define  SCCPLITE_REG_CPU_CTRL_RESERVED2_SHIFT 3
#define  SCCPLITE_REG_CPU_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_CPU_CTRL_RESERVED2_MASK) >> SCCPLITE_REG_CPU_CTRL_RESERVED2_SHIFT)
#define  SCCPLITE_REG_CPU_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_CPU_CTRL_RESERVED2_MASK) | (((uint32_t)val) << SCCPLITE_REG_CPU_CTRL_RESERVED2_SHIFT))

#define  SCCPLITE_REG_CPU_CTRL_SRAMPRIORITY_MASK 0x4
#define  SCCPLITE_REG_CPU_CTRL_SRAMPRIORITY_SHIFT 2
#define  SCCPLITE_REG_CPU_CTRL_SRAMPRIORITY_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_CPU_CTRL_SRAMPRIORITY_MASK) >> SCCPLITE_REG_CPU_CTRL_SRAMPRIORITY_SHIFT)
#define  SCCPLITE_REG_CPU_CTRL_SRAMPRIORITY_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_CPU_CTRL_SRAMPRIORITY_MASK) | (((uint32_t)val) << SCCPLITE_REG_CPU_CTRL_SRAMPRIORITY_SHIFT))

#define  SCCPLITE_REG_CPU_CTRL_SS_MASK 0x2
#define  SCCPLITE_REG_CPU_CTRL_SS_SHIFT 1
#define  SCCPLITE_REG_CPU_CTRL_SS_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_CPU_CTRL_SS_MASK) >> SCCPLITE_REG_CPU_CTRL_SS_SHIFT)
#define  SCCPLITE_REG_CPU_CTRL_SS_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_CPU_CTRL_SS_MASK) | (((uint32_t)val) << SCCPLITE_REG_CPU_CTRL_SS_SHIFT))

#define  SCCPLITE_REG_CPU_CTRL_RUN_MASK 0x1
#define  SCCPLITE_REG_CPU_CTRL_RUN_SHIFT 0
#define  SCCPLITE_REG_CPU_CTRL_RUN_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_CPU_CTRL_RUN_MASK) >> SCCPLITE_REG_CPU_CTRL_RUN_SHIFT)
#define  SCCPLITE_REG_CPU_CTRL_RUN_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_CPU_CTRL_RUN_MASK) | (((uint32_t)val) << SCCPLITE_REG_CPU_CTRL_RUN_SHIFT))

//====================================================================
//Register: Instruction Pointer Register (IPTR)
/** \brief This register is only accessible by the main CPU. Instruction Pointer is the 10 bit instruction offset into the SCCM SRAM space.*/
//====================================================================

#define  SCCPLITE_REG_IPTR_RESERVED1_MASK 0xfffffc00
#define  SCCPLITE_REG_IPTR_RESERVED1_SHIFT 10
#define  SCCPLITE_REG_IPTR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_IPTR_RESERVED1_MASK) >> SCCPLITE_REG_IPTR_RESERVED1_SHIFT)
#define  SCCPLITE_REG_IPTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_IPTR_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_IPTR_RESERVED1_SHIFT))

#define  SCCPLITE_REG_IPTR_INSTRPTR_MASK 0x3ff
#define  SCCPLITE_REG_IPTR_INSTRPTR_SHIFT 0
#define  SCCPLITE_REG_IPTR_INSTRPTR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_IPTR_INSTRPTR_MASK) >> SCCPLITE_REG_IPTR_INSTRPTR_SHIFT)
#define  SCCPLITE_REG_IPTR_INSTRPTR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_IPTR_INSTRPTR_MASK) | (((uint32_t)val) << SCCPLITE_REG_IPTR_INSTRPTR_SHIFT))

//====================================================================
//Register: Current Instruction Register (CINST)
/** \brief This register is only accessible by the main CPU. Current Instruction is a READ-ONLY 16-bit register that contains the current instruction being executed for debugging.*/
//====================================================================

#define  SCCPLITE_REG_CINST_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_CINST_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_CINST_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_CINST_RESERVED1_MASK) >> SCCPLITE_REG_CINST_RESERVED1_SHIFT)
#define  SCCPLITE_REG_CINST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_CINST_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_CINST_RESERVED1_SHIFT))

#define  SCCPLITE_REG_CINST_CURINST_MASK 0xffff
#define  SCCPLITE_REG_CINST_CURINST_SHIFT 0
#define  SCCPLITE_REG_CINST_CURINST_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_CINST_CURINST_MASK) >> SCCPLITE_REG_CINST_CURINST_SHIFT)
#define  SCCPLITE_REG_CINST_CURINST_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_CINST_CURINST_MASK) | (((uint32_t)val) << SCCPLITE_REG_CINST_CURINST_SHIFT))

//====================================================================
//Register: Debug Instruction Address (DEBUG_IADDR)
/** \brief This register is only accessible by the main CPU. Debug Instruction Address is a 10 bit word offset into the SCCM SRAM space. It represents the address of the current instruction in the execute stage (ie. the instruction that will be executed next). Useful for debugging SCCP Lite assembly in single step mode.*/
//====================================================================

#define  SCCPLITE_REG_DEBUG_IADDR_RESERVED1_MASK 0xfffffc00
#define  SCCPLITE_REG_DEBUG_IADDR_RESERVED1_SHIFT 10
#define  SCCPLITE_REG_DEBUG_IADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_DEBUG_IADDR_RESERVED1_MASK) >> SCCPLITE_REG_DEBUG_IADDR_RESERVED1_SHIFT)
#define  SCCPLITE_REG_DEBUG_IADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_DEBUG_IADDR_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_DEBUG_IADDR_RESERVED1_SHIFT))

#define  SCCPLITE_REG_DEBUG_IADDR_DEBUGIADDR_MASK 0x3ff
#define  SCCPLITE_REG_DEBUG_IADDR_DEBUGIADDR_SHIFT 0
#define  SCCPLITE_REG_DEBUG_IADDR_DEBUGIADDR_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_DEBUG_IADDR_DEBUGIADDR_MASK) >> SCCPLITE_REG_DEBUG_IADDR_DEBUGIADDR_SHIFT)
#define  SCCPLITE_REG_DEBUG_IADDR_DEBUGIADDR_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_DEBUG_IADDR_DEBUGIADDR_MASK) | (((uint32_t)val) << SCCPLITE_REG_DEBUG_IADDR_DEBUGIADDR_SHIFT))

//====================================================================
//Register: Trigger Configuration 0 (TRIG_CFG0)
/** \brief This register is only accessible by the main CPU, and is used to configure the edge detect and inversion for bank0 of the external triggers.*/
//====================================================================

#define  SCCPLITE_REG_TRIG_CFG0_TRIG_INV_MASK 0xffff0000
#define  SCCPLITE_REG_TRIG_CFG0_TRIG_INV_SHIFT 16
#define  SCCPLITE_REG_TRIG_CFG0_TRIG_INV_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_TRIG_CFG0_TRIG_INV_MASK) >> SCCPLITE_REG_TRIG_CFG0_TRIG_INV_SHIFT)
#define  SCCPLITE_REG_TRIG_CFG0_TRIG_INV_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_TRIG_CFG0_TRIG_INV_MASK) | (((uint32_t)val) << SCCPLITE_REG_TRIG_CFG0_TRIG_INV_SHIFT))

#define  SCCPLITE_REG_TRIG_CFG0_EDGE_SEL_MASK 0xffff
#define  SCCPLITE_REG_TRIG_CFG0_EDGE_SEL_SHIFT 0
#define  SCCPLITE_REG_TRIG_CFG0_EDGE_SEL_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_TRIG_CFG0_EDGE_SEL_MASK) >> SCCPLITE_REG_TRIG_CFG0_EDGE_SEL_SHIFT)
#define  SCCPLITE_REG_TRIG_CFG0_EDGE_SEL_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_TRIG_CFG0_EDGE_SEL_MASK) | (((uint32_t)val) << SCCPLITE_REG_TRIG_CFG0_EDGE_SEL_SHIFT))

//====================================================================
//Register: Trigger Configuration 1 (TRIG_CFG1)
/** \brief This register is only accessible by the main CPU, and is used to configure the edge detect and inversion for bank1 of the external triggers.*/
//====================================================================

#define  SCCPLITE_REG_TRIG_CFG1_TRIG_INV_MASK 0xffff0000
#define  SCCPLITE_REG_TRIG_CFG1_TRIG_INV_SHIFT 16
#define  SCCPLITE_REG_TRIG_CFG1_TRIG_INV_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_TRIG_CFG1_TRIG_INV_MASK) >> SCCPLITE_REG_TRIG_CFG1_TRIG_INV_SHIFT)
#define  SCCPLITE_REG_TRIG_CFG1_TRIG_INV_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_TRIG_CFG1_TRIG_INV_MASK) | (((uint32_t)val) << SCCPLITE_REG_TRIG_CFG1_TRIG_INV_SHIFT))

#define  SCCPLITE_REG_TRIG_CFG1_EDGE_SEL_MASK 0xffff
#define  SCCPLITE_REG_TRIG_CFG1_EDGE_SEL_SHIFT 0
#define  SCCPLITE_REG_TRIG_CFG1_EDGE_SEL_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_TRIG_CFG1_EDGE_SEL_MASK) >> SCCPLITE_REG_TRIG_CFG1_EDGE_SEL_SHIFT)
#define  SCCPLITE_REG_TRIG_CFG1_EDGE_SEL_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_TRIG_CFG1_EDGE_SEL_MASK) | (((uint32_t)val) << SCCPLITE_REG_TRIG_CFG1_EDGE_SEL_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  SCCPLITE_REG_REV0_MAJ_MASK 0xffff0000
#define  SCCPLITE_REG_REV0_MAJ_SHIFT 16
#define  SCCPLITE_REG_REV0_MAJ_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_REV0_MAJ_MASK) >> SCCPLITE_REG_REV0_MAJ_SHIFT)
#define  SCCPLITE_REG_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_REV0_MAJ_MASK) | (((uint32_t)val) << SCCPLITE_REG_REV0_MAJ_SHIFT))

#define  SCCPLITE_REG_REV0_MID_MASK 0xffff
#define  SCCPLITE_REG_REV0_MID_SHIFT 0
#define  SCCPLITE_REG_REV0_MID_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_REV0_MID_MASK) >> SCCPLITE_REG_REV0_MID_SHIFT)
#define  SCCPLITE_REG_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_REV0_MID_MASK) | (((uint32_t)val) << SCCPLITE_REG_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  SCCPLITE_REG_REV1_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_REV1_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_REV1_RESERVED1_MASK) >> SCCPLITE_REG_REV1_RESERVED1_SHIFT)
#define  SCCPLITE_REG_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_REV1_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_REV1_RESERVED1_SHIFT))

#define  SCCPLITE_REG_REV1_CFG_MASK 0xffff
#define  SCCPLITE_REG_REV1_CFG_SHIFT 0
#define  SCCPLITE_REG_REV1_CFG_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_REV1_CFG_MASK) >> SCCPLITE_REG_REV1_CFG_SHIFT)
#define  SCCPLITE_REG_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_REV1_CFG_MASK) | (((uint32_t)val) << SCCPLITE_REG_REV1_CFG_SHIFT))

//====================================================================
//Register: Microcode SRAM (SRAM)
/** \brief The Microcode SRAM holds the microcode executed by the SCCP Lite embedded micro-controller. There are 1k address x 16 bits.*/
//====================================================================

#define  SCCPLITE_REG_SRAM_RESERVED1_MASK 0xffff0000
#define  SCCPLITE_REG_SRAM_RESERVED1_SHIFT 16
#define  SCCPLITE_REG_SRAM_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_SRAM_RESERVED1_MASK) >> SCCPLITE_REG_SRAM_RESERVED1_SHIFT)
#define  SCCPLITE_REG_SRAM_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_SRAM_RESERVED1_MASK) | (((uint32_t)val) << SCCPLITE_REG_SRAM_RESERVED1_SHIFT))

#define  SCCPLITE_REG_SRAM_DATA_MASK 0xffff
#define  SCCPLITE_REG_SRAM_DATA_SHIFT 0
#define  SCCPLITE_REG_SRAM_DATA_MASK_SHIFT(reg) (((reg) & SCCPLITE_REG_SRAM_DATA_MASK) >> SCCPLITE_REG_SRAM_DATA_SHIFT)
#define  SCCPLITE_REG_SRAM_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCPLITE_REG_SRAM_DATA_MASK) | (((uint32_t)val) << SCCPLITE_REG_SRAM_DATA_SHIFT))

#endif // SCCPLITE_REG
